/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2024 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */
#include <stddef.h>
#include "cpu.h"
#include "riscv.h"
#include "plic.h"
#include "reg_access.h"


struct interrupt_entry plic_int_table[PLIC_INT_SRC_NUM];


void plic_init(void)
{
	int hart = r_tp();
  
	*(uint32_t*)PLIC_MTHRESHOLD(hart) = 0;
	*(uint32_t*)PLIC_STHRESHOLD(hart) = 0;

	/* enable machine-mode external interrupts. */
	w_mie(r_mie() | MIE_MEIE);

	/* enable supervisor-mode external interrupts. */
	w_mie(r_mie() | SIE_SEIE);
}

void plic_pending(priv_e mode , unsigned int *status)
{
	int hart = r_tp();
    if (ePRIV_M == mode)
    {
        *status = *(uint32_t*)PLIC_PENDING(hart);
    }
    else
    {
        *status = *(uint32_t*)PLIC_PENDING(hart);
    }
}

int plic_int_register(uint8_t src,
		              uint8_t priority,
					  uint8_t mode,
					  irq_handler isr,
					  void *context) 
{
	int hart = r_tp();

	if (src < PLIC_INT_SRC_MIN || src > PLIC_INT_SRC_MAX) {
		return 1;
	}

	plic_int_table[src].isr = isr;
	plic_int_table[src].context = context;

	if (src) {
		PLIC_PRIORITY(src) = priority;

		if (mode & ePRIV_M) {
			PLIC_ENABLE_M(hart) |= 1 << src;
		}

		if (mode & ePRIV_S) {
			PLIC_ENABLE_S(hart) |= 1 << src;
		}
	}

	return 0;
}


int plic_claim(priv_e mode)
{
	int hart = r_tp();
    int irq = 0; 
    if (ePRIV_M == mode)
    {
        irq = *(uint32_t*)PLIC_MCLAIM(hart);
    }
    else
    {
        irq = *(uint32_t*)PLIC_SCLAIM(hart);
    }
	return irq;
}


void plic_complete(priv_e mode, int irq)
{
	int hart = r_tp();
    if (ePRIV_M == mode)
    {
	    *(uint32_t*)PLIC_MCOMPLETE(hart) = irq;
    }
    else
    {
	    *(uint32_t*)PLIC_SCOMPLETE(hart) = irq;
    }
}

void plic_enable(priv_e mode , int src)
{
	int hart = r_tp();
	if (src) {
		PLIC_PRIORITY(src) = 1;

		if (mode & ePRIV_M) {
			PLIC_ENABLE_M(hart) |= 1 << src;
		}

		if (mode & ePRIV_S) {
			PLIC_ENABLE_S(hart) |= 1 << src;
		}
	}
}

void plic_disable(priv_e mode , int src)
{
	int hart = r_tp();
	if (src) {
		PLIC_PRIORITY(src) = 1;

		if (mode & ePRIV_M) {
			PLIC_ENABLE_M(hart) &= 0 << src;
		}

		if (mode & ePRIV_S) {
			PLIC_ENABLE_S(hart) &= 0 << src;
		}
	}
}

