/**
 * @file flash_cntl.h
 * @brief Driver to handle the Flash controller core ip
 */

/*   ==================================================================

 >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
 ------------------------------------------------------------------
 Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
 ALL RIGHTS RESERVED
 ------------------------------------------------------------------

 IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
 DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

 Lattice grants permission to use this code pursuant to the
 terms of the Lattice Propel License Agreement.

 DISCLAIMER:

 LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
 WHETHER EXPRESSED, IMPLIED, STATUTORY,
 OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
 COMMUNICATION WITH LICENSEE,
 AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
 LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
 SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
 UNINTERRUPTED OR ERROR FREE,
 OR THAT DEFECTS HEREIN WILL BE CORRECTED.
 LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
 ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
 AND RESULTS OBTAINED THEREFROM.
 LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
 DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
 LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
 CORRECTION,
 OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
 SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
 INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
 INCLUDING LOST PROFITS,
 ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
 EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
 IS SET FORTH ABOVE.
 LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
 ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
 INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
 RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
 FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
 ------------------------------------------------------------------

 ================================================================== */

#ifndef FLASH_CNTL_H_
#define FLASH_CNTL_H_

#include <stdint.h>
#include <stdbool.h>

#define SPI_FLASH_CONTROLLER_DRV_VER "v1.7.1"

/**
 * @brief  Flash Controller Register-map
 */

struct flash_cntl_dev {
	// basic command registers
	volatile uint32_t reg_page_program;							  // 0x00
	volatile uint32_t reg_page_read;							  // 0x04
	volatile uint32_t reg_4k_erase;								  // 0x08
	volatile uint32_t reg_32k_erase;							  // 0x0C
	volatile uint32_t reg_64k_erase;							  // 0x10
	volatile uint32_t reg_chip_erase;							  // 0x14
	volatile uint32_t reg_wr_en;								  // 0x18
	volatile uint32_t reg_wr_dis;								  // 0x1c
	volatile uint32_t reg_status_read;							  // 0x20
	volatile uint32_t reg_status_write;							  // 0x24
	volatile uint32_t reg_power_down;							  // 0x28
	volatile uint32_t reg_power_up;								  // 0x2C
	volatile uint32_t reg_mf_id;								  // 0x30

	volatile uint32_t DUMMY1;									  // 0x34
	volatile uint32_t DUMMY2;									  // 0x38
	volatile uint32_t DUMMY3;									  // 0x3C

	volatile uint32_t reg_flash_addr;							  // 0x40
	volatile uint32_t reg_flash_mode;							  // 0x44

	volatile uint32_t DUMMY4;									  // 0x48
	volatile uint32_t DUMMY5;									  // 0x4C
	volatile uint32_t DUMMY6;									  // 0x50
	volatile uint32_t DUMMY7;									  // 0x54
	volatile uint32_t DUMMY8;									  // 0x58
	volatile uint32_t DUMMY9;									  // 0x5C
	volatile uint32_t DUMMY10;									  // 0x60
	volatile uint32_t DUMMY11;									  // 0x64
	volatile uint32_t DUMMY12;									  // 0x68
	volatile uint32_t DUMMY13;									  // 0x6C
	volatile uint32_t DUMMY14;									  // 0x70
	volatile uint32_t DUMMY15;									  // 0x74
	volatile uint32_t DUMMY16;									  // 0x78
	volatile uint32_t DUMMY17;									  // 0x7C

	volatile uint32_t reg_user_cmd_opcode;						  // 0x80
	volatile uint32_t reg_user_cmd_addr;						  // 0x84
	volatile uint32_t reg_user_cmd0;							  // 0x88
	volatile uint32_t reg_user_cmd1;							  // 0x8C
	volatile uint32_t reg_user_cmd_length;						  // 0x90
	volatile uint32_t reg_user_cmd_config;						  // 0x94
	volatile uint32_t reg_user_read_data0;						  // 0x98
	volatile uint32_t reg_user_read_data1;						  // 0x9C
	volatile uint32_t reg_user_cmd_init;						  // 0xA0

	volatile uint32_t placeholder_0xA4_0xFC[(0x100-0xA4)/4];      // 0xA4 to 0xFC

	volatile uint32_t read_speed;                                 // 0x100
	volatile uint32_t page_program_size;                          // 0x104
	volatile uint32_t page_read_size;                             // 0x108
	volatile uint32_t write_protect_reg;                          // 0x10C
	volatile uint32_t sclk_rate;                                  // 0x110
	volatile uint32_t spi_first_transmitted;                      // 0x114
	volatile uint32_t ahbl_page_buffer_enable;                    // 0x118
	volatile uint32_t sclk_polarity_reg;              		      // 0x11C
	volatile uint32_t sclk_phase_reg;          			          // 0x120

	volatile uint32_t placeholder_0x11C_0x17C[(0x180-0x124)/4];   // 0x124 to 0x17C

	volatile uint32_t slow_read_cfg;                              // 0x180
	volatile uint32_t fast_read_cfg;                              // 0x184
	volatile uint32_t byte_program_cfg;                           // 0x188  //reserved
	volatile uint32_t page_program_cfg;                           // 0x18C
	volatile uint32_t block_erase_1_cfg;                          // 0x190
	volatile uint32_t block_erase_2_cfg;                          // 0x194
	volatile uint32_t block_erase_3_cfg;                          // 0x198
	volatile uint32_t chip_erase_cfg;                             // 0x19C
	volatile uint32_t write_enable_cfg;                           // 0x1A0
	volatile uint32_t write_disable_cfg;                          // 0x1A4
	volatile uint32_t read_status_cfg;                            // 0x1A8
	volatile uint32_t write_status_cfg;                           // 0x1AC
	volatile uint32_t power_down_cfg;                             // 0x1B0
	volatile uint32_t power_up_cfg;                               // 0x1B4
	volatile uint32_t read_id_cfg;                                // 0x1B8

	volatile uint32_t DUMMY18;									  // 0x1BC

	volatile uint32_t transaction_status_reg;                     // 0x1C0
	volatile uint32_t page_read_buf_data_count_status_reg;        // 0x1C4
	volatile uint32_t page_read_buf_addr_reg;                     // 0x1C8

	volatile uint32_t placeholder_0x1BC_0x1FC[(0x200-0x1CC)/4];   // 0x1CC to 0x1FF

	volatile uint32_t page_program_buffer[(0x400-0x200)/4];       // 0x200 to 0x3FF
	volatile uint32_t page_read_buffer[(0x600-0x400)/4];          // 0x400 to 0x5FF
};

/**
 * @brief Definition for the offset address of Page program buffer.
 */
#define PAGE_PROGRAM_BUFF_OFFSET	0x200

/**
 * @brief	Definition for the offset address of Page Read buffer.
 */
#define PAGE_READ_BUFF_OFFSET		0x400

/**
 * @brief Definition for flash address mask.
 */
#define FLASH_ADDR_MASK  0x0FFFFFF

/**
 * @brief Definition for flash Command mask.
 */
#define FLASH_CMD_MASK   0xFF000000

/**
 * @brief definition for start transition.
 */
#define START_TRANSACTION  (1 << 0)

/**
 * @brief Definition for flash Read command.
 */
#define FLASH_READ				0x03

/**
 * @brief Definition for flash fast Read command.
 */
#define FLASH_FAST_READ 		0x0B

/**
 * @brief Definition for flash Read status command.
 */
#define FLASH_READ_STSTUS		0x05

/**
 * @brief Definition for flash Read WIP status bit command.
 */
#define FLASH_STS_WIP			0x01

/**
 * @brief Definition for flash Transaction Read status bit command.
 */
#define FLASH_TRNS_RD_STATUS	0x01

/**
 * @brief Definition for flash Write enable command.
 */
#define FLASH_WRITE_EN			0x06

/**
 * @brief Definition for flash Write disable command.
 */
#define FLASH_WRITE_DIS			0x04

/**
 * @brief Definition for flash page write command.
 */
#define FLASH_PAGE_PROGRAM		0x02

/**
 * @brief Definition for flash User command init.
 */
#define FLASH_USER_CMD_INIT		0x01


/**
 * @brief	enumeration for the flash erase type
 */
typedef enum {
	FLASH_4K_ERASE = 0,/**< FLASH_4K_ERASE */
	FLASH_32K_ERASE, /**< FLASH_32K_ERASE */
	FLASH_64K_ERASE, /**< FLASH_64K_ERASE */
	FLASH_CHIP_ERASE, /**< FLASH_CHIP_ERASE */

} FLASH_MODE;

typedef enum {
	ADDR_24BIT, ADDR_32BIT

} FLASH_ADDR_MODE;

typedef enum {
	USER_CMD_OPCODE = 0,
	USER_CMD_ADDR = 1,
	USER_CMD_DATA0 = 2,
	USER_CMD_DATA1 = 3,
	USER_CMD_DATALENGTH = 4,
	USER_CMD_CONFIG = 5,
	USER_CMD_READ0 = 6,
	USER_CMD_READ1 = 7,
	USER_CMD_START = 8,

} USER_CMD;


typedef enum {
	FLASH_READ_DIR  = 0,
	FLASH_WRITE_DIR = 1,

} FLASH_USER_DIRECTION;

/**
 * @brief	definition for page size in terms of bytes.
 */
#define PAGE_SIZE	256

/**
 * @brief	definition for sector size in terms of bytes.
 */
#define SECTOR_SIZE    4096

/**
 * @brief	definition for ERROR status.
 */
#define STS_ERR		-1

/**
 * @brief	definition for OK status.
 */
#define STS_OK		0

/**
 * @brief	definition for Read transition.
 */
#define SCFC_READ_TRANS		2

/**
 * @brief	definition for Write transition.
 */
#define SCFC_WRITE_TRANS	1

/**
 * @brief	definition for Idle state.
 */
#define IDLE			0

/**
 * @brief handle for flash controller
 * @brief 1.base	-base address of the SCFC module
 * @brief 2.status	-SCFC current status
 */
struct flash_cntl_instance {
	const char *name;
	uint32_t base;                       // base address of the SCFC module
	uint8_t status;                      // SCFC current status
};



uint8_t flash_cntl_init(struct flash_cntl_instance *this_flash_cntl,
      uint32_t base_addr, uint32_t page_program_size, uint32_t page_read_size);


uint8_t flash_cntl_status_read(struct flash_cntl_instance *this_flash_cntl,
		uint32_t *buff);

uint8_t flash_cntl_status_write(struct flash_cntl_instance *this_flash_cntl,
		uint8_t status);

uint8_t flash_cntl_page_read(struct flash_cntl_instance *this_flash_cntl,
		uint32_t addr, uint8_t *buff);

uint8_t flash_cntl_page_program(struct flash_cntl_instance *this_flash_cntl,
		uint32_t addr, uint8_t *buff);

uint8_t flash_cntl_erase(struct flash_cntl_instance *this_flash_cntl,
		uint32_t addr, uint32_t mode);

uint8_t flash_cntl_pw(struct flash_cntl_instance *this_flash_cntl,
		uint32_t power_on);

uint8_t flash_issue_cmd(struct flash_cntl_instance *this_flash_cntl,
		uint8_t *command, uint32_t command_length, uint8_t return_length);

uint8_t flash_cntl_write_enable(struct flash_cntl_instance *this_flash_cntl);

uint8_t flash_cntl_write_disable(struct flash_cntl_instance *this_flash_cntl);

uint8_t flash_cntl_read_speed(struct flash_cntl_instance *this_flash_cntl,
		uint32_t speed);

uint8_t flash_cntl_page_program_size(
		struct flash_cntl_instance *this_flash_cntl, uint32_t size);

uint8_t flash_cntl_page_read_size(struct flash_cntl_instance *this_flash_cntl,
		uint32_t size);

uint8_t flash_cntl_id_read(struct flash_cntl_instance *this_flash_cntl,
		uint32_t *manu_id);

uint8_t flash_read_cmd_data(struct flash_cntl_instance *this_flash_cntl,
		uint32_t *buff);

uint8_t flash_cntl_set_addr(struct flash_cntl_instance *this_flash_cntl,
		uint32_t addr);

uint8_t flash_cntl_set_addr_mode(struct flash_cntl_instance *this_flash_cntl,
		FLASH_ADDR_MODE mode);

uint8_t flash_cntl_page_buffer(struct flash_cntl_instance *this_flash_cntl,
		bool enable);

uint8_t flash_cntl_set_user_cmd(struct flash_cntl_instance *this_flash_cntl,
		USER_CMD cmd, uint32_t value);

uint8_t flash_cntl_get_user_cmd(struct flash_cntl_instance *this_flash_cntl,
		USER_CMD cmd, uint32_t *buff);

uint8_t flash_cntl_write_protect(struct flash_cntl_instance *this_flash_cntl,
		uint8_t wr_protection);

uint8_t flash_cntl_wip(struct flash_cntl_instance *this_flash_cntl);

uint8_t flash_cntl_spi_transaction_status(struct flash_cntl_instance *this_flash_cntl);

uint8_t flash_cntl_set_clock_mode(struct flash_cntl_instance *this_flash_cntl,
		uint8_t mode);

uint8_t flash_cntl_set_clock_rate(struct flash_cntl_instance *this_flash_cntl,
		uint8_t rate);

uint8_t flash_cntl_user_cmd_write(struct flash_cntl_instance *this_flash_cntl,
		uint8_t opcode ,uint8_t include_address , uint32_t address, uint8_t *data, uint8_t data_len);

uint8_t flash_cntl_user_cmd_read(struct flash_cntl_instance *this_flash_cntl,
		uint8_t opcode ,uint8_t include_address , uint32_t address , uint8_t dummy_len ,  uint8_t *data, uint8_t data_len );

#endif				/* FLASH_CNTL_H_ */
