/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

# save all General-Purpose(GP) registers to context
# struct context *base = &ctx_task;
# base->ra = ra;
# ......
.macro reg_save base
	sw ra, 0(\base)
	sw sp, 4(\base)
	sw gp, 8(\base)
	sw tp, 12(\base)
	sw t0, 16(\base)
	sw t1, 20(\base)
	sw t2, 24(\base)
	sw s0, 28(\base)
	sw s1, 32(\base)
	sw a0, 36(\base)
	sw a1, 40(\base)
	sw a2, 44(\base)
	sw a3, 48(\base)
	sw a4, 52(\base)
	sw a5, 56(\base)
	sw a6, 60(\base)
	sw a7, 64(\base)
	sw s2, 68(\base)
	sw s3, 72(\base)
	sw s4, 76(\base)
	sw s5, 80(\base)
	sw s6, 84(\base)
	sw s7, 88(\base)
	sw s8, 92(\base)
	sw s9, 96(\base)
	sw s10, 100(\base)
	sw s11, 104(\base)
	sw t3, 108(\base)
	sw t4, 112(\base)
	sw t5, 116(\base)
	# we don't save t6 here, due to we have used
	# it as base, we have to save t6 in an extra step
	# outside of reg_save
.endm

# restore all General-Purpose(GP) registers from the context
# struct context *base = &ctx_task;
# ra = base->ra;
# ......
.macro reg_restore base
	lw ra, 0(\base)
	lw sp, 4(\base)
	lw gp, 8(\base)
	lw tp, 12(\base)
	lw t0, 16(\base)
	lw t1, 20(\base)
	lw t2, 24(\base)
	lw s0, 28(\base)
	lw s1, 32(\base)
	lw a0, 36(\base)
	lw a1, 40(\base)
	lw a2, 44(\base)
	lw a3, 48(\base)
	lw a4, 52(\base)
	lw a5, 56(\base)
	lw a6, 60(\base)
	lw a7, 64(\base)
	lw s2, 68(\base)
	lw s3, 72(\base)
	lw s4, 76(\base)
	lw s5, 80(\base)
	lw s6, 84(\base)
	lw s7, 88(\base)
	lw s8, 92(\base)
	lw s9, 96(\base)
	lw s10, 100(\base)
	lw s11, 104(\base)
	lw t3, 108(\base)
	lw t4, 112(\base)
	lw t5, 116(\base)
	lw t6, 120(\base)
.endm

.macro trap_depth_inc
    la t0, g_trap_depth
    lw t1, (t0)
    addi t1, t1, 1
    sw t1, (t0)
.endm

.macro trap_depth_dec
    la t0, g_trap_depth
    lw t1, (t0)
    addi t1, t1, -1
    sw t1, (t0)
.endm


# Something to note about save/restore:
# - We use mscratch to hold a pointer to context of previous task
#      * mscratch is used to hold a pointer to a machine-mode hart-local context 
#      * space and swapped with a user register upon entry to an M-mode trap handler.
# - We use t6 as the 'base' for reg_save/reg_restore, because it is the
#   very bottom register (x31) and would not be overwritten during loading.

.text

# interrupts and exceptions while in machine mode come here.
.globl trap_entry
# the trap vector base address must always be aligned on a 4-byte boundary
.align 4
trap_entry:

	# save context(registers).
	csrrw	t6, mscratch, t6	# swap t6 and mscratch
	reg_save t6

	# Save the actual t6 register, which we swapped into
	# mscratch
	mv	t5, t6		# t5 points to the context of current task
	csrr	t6, mscratch	# read t6 back from mscratch
	sw	t6, 120(t5)	# save t6 with t5 as base

	# save mepc to context of current task
	csrr	a0, mepc
	sw	a0, 124(t5)

	# Restore the context pointer into mscratch
	csrw	mscratch, t5

    trap_depth_inc

	# call the C trap handler in trap.c
	csrr	a0, mepc
	csrr	a1, mcause
	csrr	a2, mscratch
	call	trap_handler

    trap_depth_dec

	# trap_handler will return the return address via a0.
	csrw	mepc, a0

	# restore context(registers).
	csrr	t6, mscratch
	reg_restore t6

	# return to whatever we were doing before trap.
	mret

# vectored interrupts and exceptions handlers.
.globl trap_vector
# the trap vector base address must always be aligned on a 4-byte boundary
.align 4
trap_vector:
    j       trap_vector_entry0
    j       trap_vector_entry1
    j       trap_vector_entry2
    j       trap_vector_entry3
    j       trap_vector_entry4
    j       trap_vector_entry5
    j       trap_vector_entry6
    j       trap_vector_entry7
    j       trap_vector_entry8
    j       trap_vector_entry9
    j       trap_vector_entry10
    j       trap_vector_entry11
    j       trap_vector_entry12
    j       trap_vector_entry13
    j       trap_vector_entry14
    j       trap_vector_entry15

trap_vector_entry0:
    j       trap_entry
trap_vector_entry1:
    j       trap_entry
trap_vector_entry2:
    j       trap_entry
trap_vector_entry3:
    j       trap_entry
trap_vector_entry4:
    j       trap_entry
trap_vector_entry5:
    j       trap_entry
trap_vector_entry6:
    j       trap_entry
trap_vector_entry7:
    j       trap_entry
trap_vector_entry8:
    j       trap_entry
trap_vector_entry9:
    j       trap_entry
trap_vector_entry10:
    j       trap_entry
trap_vector_entry11:
    j       trap_entry
trap_vector_entry12:
    j       trap_entry
trap_vector_entry13:
    j       trap_entry
trap_vector_entry14:
    j       trap_entry
trap_vector_entry15:
    j       trap_entry


# non-maskable interrupts in machine come here.
.globl nmi_entry
.align 4
nmi_entry:

	csrr	a0, mepc
	csrr	a1, mcause
	csrr	a2, mscratch
	call	nmi_handler
block:
    wfi
    j       block


# void switch_to(struct context *next);
.globl switch_to
.align 4
switch_to:

    trap_depth_dec

	# write mscratch with the point to the context of the next task,
    # thus, after mret, mscratch will hold the poniter of context being used
	csrw	mscratch, a0

	# set mepc to the pc of the next task
	lw	a1, 124(a0)
	csrw	mepc, a1

	# Restore all GP registers
	# Use t6 to point to the context of the new task
	mv	t6, a0
	reg_restore t6

	# Do actual context switching.
	# Notice this will enable global interrupt
	mret


# void prepare_mmode();
.globl prepare_mmode
.align 4
prepare_mmode:

    # Set mstatus.MPIE to 0, so MRET will disable the interrupt.
    csrr    a1, mstatus
    li      t0, 0xffffff7f
    and     t0, t0, a1
    csrw    mstatus, t0

    # Keep mstatus.MPP as 3, so we will stay in Machine mode after MRET.
    csrr    a1, mstatus
    li      t0, 0x00001800
    or      t0, t0, a1
    csrw    mstatus, t0

    ret


# void prepare_umode();
.globl prepare_umode
.align 4
prepare_umode:

    # Set mstatus.MPIE to 1, so MRET will enable the interrupt.
    csrr    a1, mstatus
    li      t0, 0x00000080
    or      t0, t0, a1
    csrw    mstatus, t0

    # Keep mstatus.MPP as 0, so we will run in User mode after MRET.
    csrr    a1, mstatus
    li      t0, 0xffffe7ff
    and     t0, t0, a1
    csrw    mstatus, t0

    ret


# void prepare_smode();
.globl prepare_smode
.align 4
prepare_smode:

    # Set mstatus.MPIE to 1, so MRET will enable the interrupt.
    csrr    a1, mstatus
    li      t0, 1 << 7
    or      t0, t0, a1
    csrw    mstatus, t0

    # Keep mstatus.MPP as 1, so we will run in S mode after MRET.
    csrr    a1, mstatus
    li      t0, 0x00000800
    or      t0, t0, a1
    li      t0, 0xffffefff
    and     t0, t0, a1
    csrw    mstatus, t0

    ret


# void enter_umode(void *entry);
.globl enter_umode
.align 4
enter_umode:

    trap_depth_dec

    # Set mstatus.MPIE to 1, so MRET will enable the interrupt.
    csrr    a1, mstatus
    li      t0, 1 << 7
    or      t0, t0, a1
    csrw    mstatus, t0

    # Keep mstatus.MPP as 0, so we will run in U mode after MRET.
    csrr    a1, mstatus
    li      t0, 0xffffE7FF
    and     t0, t0, a1
    csrw    mstatus, t0

    csrw    mepc, a0
    mret


# void enter_smode(void *entry);
.globl enter_smode
.align 4
enter_smode:

    trap_depth_dec

    # Set mstatus.MPIE to 1, so MRET will enable the interrupt.
    csrr    a1, mstatus
    li      t0, 1 << 7
    or      t0, t0, a1
    csrw    mstatus, t0

    # Keep mstatus.MPP as 1, so we will run in S mode after MRET.
    csrr    a1, mstatus
    li      t0, 0x00000800
    or      t0, t0, a1
    li      t0, 0xffffefff
    and     t0, t0, a1
    csrw    mstatus, t0

    csrw    mepc, a0
    mret


# void enter_mmode(void *entry);
.globl enter_mmode
.align 4
enter_mmode:

    trap_depth_dec

    # Set mstatus.MPIE to 1, so MRET will enable the interrupt.
    csrr    a1, mstatus
    li      t0, 1 << 7
    or      t0, t0, a1
    csrw    mstatus, t0

    # Keep mstatus.MPP as 3, so we will stay in Machine mode after MRET.
    csrr    a1, mstatus
    li      t0, 0x00001800
    or      t0, t0, a1
    csrw    mstatus, t0

    csrw    mepc, a0
    mret


.end




