// >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// ------------------------------------------------------------------
// Copyright (c) 2019-2024 by Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// ------------------------------------------------------------------
//
// IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL
// DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.
//
// Lattice grants permission to use this code pursuant to the
// terms of the Lattice Propel License Agreement.
//
// DISCLAIMER:
//
//  LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER
//  EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE
//  PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE 
//  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
//  FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE
//  FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT
//  LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE
//  OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS
//  HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR 
//  SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE
//  PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE
//  ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE
//  OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL 
//  ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR
//  ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE 
//  SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
//  INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST
//  PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF
//  LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S
//  SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  
//  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR
//  USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY
//  RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY
//  THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE
//  USE OF FORMAL SOFTWARE VALIDATION METHODS.
// ------------------------------------------------------------------

#include "hal.h"
#include "utils.h"
#include <stdio.h>
#include "sys_platform.h"
#include <riscv_errors.h>

#ifdef UART_INST_BASE_ADDR
#include "uart.h"

#ifndef _UART_NO_INTERRUPTS_
#include "pic.h"
#endif
#endif

#ifdef GPIO0_INST_GPIO_MEM_MAP_BASE_ADDR
#include "gpio.h"
struct gpio_instance gpio_inst;
#endif

#if (defined UART_INST_BASE_ADDR)
struct uart_instance uart_core_uart;
#elif (defined CPU_INST_LOCAL_UART_BASE_ADDR)
struct local_uart_instance local_uart_core;
#endif

static int lscc_uart_putc(char c, FILE *file)
{
#ifdef LSCC_STDIO_UART_APB
		int ret = EOF;
#if (defined UART_INST_BASE_ADDR)
		ret = uart_putc(&uart_core_uart, c);
		if (c == '\n' && ret == 0)
			ret = uart_putc(&uart_core_uart, '\r');
#elif (defined CPU_INST_LOCAL_UART_BASE_ADDR)
		ret = local_uart_putc(&local_uart_core, c);
		if (c == '\n' && ret == 0)
			ret = local_uart_putc(&local_uart_core, '\r');
#endif
		return ret;
#else
		return EOF;
#endif
}


static int lscc_uart_getc(FILE *file)
{
	(void) file;
	return EOF;
}


static int lscc_uart_flush(FILE *file)
{
	(void) file;
	return 0;
}


static void bsp_init(void)
{
#ifdef GPIO0_INST_GPIO_MEM_MAP_BASE_ADDR
	//initialize GPIO
	gpio_inst.instance_name = GPIO0_INST_GPIO_MEM_MAP_NAME;
	gpio_init(&gpio_inst, GPIO0_INST_GPIO_MEM_MAP_BASE_ADDR, GPIO_INST_LINES_NUM, GPIO_INST_GPIO_DIRS);
#endif

#if (defined UART_INST_BASE_ADDR)
#ifndef _UART_NO_INTERRUPTS_
	//setup uart IRQ
	pic_init(CPU0_INST_PICTIMER_START_ADDR);
	uart_core_uart.intrLevel = UART0_INST_IRQ;
	uart_core_uart.intrAvail = true;
	//pic_isr_register(UART0_INST_IRQ, uart_isr, (void *)&uart_core_uart);
#endif

	//initialize UART
	uart_init(&uart_core_uart, UART_INST_BASE_ADDR, UART_INST_SYS_CLK * 1000000, UART_INST_BAUD_RATE, 1, 8);
#elif (defined CPU_INST_LOCAL_UART_BASE_ADDR)
    local_uart_init(&local_uart_core, CPU_INST_LOCAL_UART_BASE_ADDR, CPU_INST_SYS_CLOCK_FREQ * 1000000, CPU_INST_BAUD_RATE, 1, 8);
#endif
	iob_init(lscc_uart_putc, lscc_uart_getc, lscc_uart_flush);
	trap_init();
}


int main(void) {
	static uint8_t idx = 0;
	static uint8_t pin_state = 0xFF;

	bsp_init();

	printf("Started!\nHello RISC-V world!\n"); 

	while (true) {
#ifdef GPIO0_INST_GPIO_MEM_MAP_BASE_ADDR
		gpio_output_write(&gpio_inst, idx, pin_state);
#else
		printf("0x%02X\n",(pin_state ^ (1<<idx)));
#endif

		if (++idx == LED_COUNT) {
			idx = 0;
			pin_state = ~pin_state;
		}

		if (RTL_SIM) {
			delay(1);
		} else {
			delay(500);
		}
	}

	return 0;
}

