/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */
#include <stdio.h>
#include <stdint.h>
#include "image.h"
#include "spi_flash_cntl.h"

#define CRC32_POLY 0xEDB88320

extern struct flash_cntl_instance this_flash_cntl;

uint32_t crc32(uint8_t *message, uint32_t len) {
    uint32_t crc_table[256];
    uint32_t crc = 0xFFFFFFFF;
    uint32_t i;

    /* Generate CRC32 lookup table */
    for (i = 0; i < 256; i++) {
        crc = i;

        for (int j = 0; j < 8; j++) {
            crc = (crc & 1) ? (crc >> 1) ^ CRC32_POLY : (crc >> 1);
        }

        crc_table[i] = crc;
    }

    /* Calculate CRC32 value */
    crc = 0xFFFFFFFF;

    for (i = 0; i < len; i++) {
        crc = crc_table[(crc ^ message[i]) & 0xFF] ^ (crc >> 8);
    }

    return ~crc;
}

image_status_t read_flash_image(uint32_t src_addr, uint32_t *dest_addr)
{
	image_hdr_t image_hdr;
	uint32_t fw_addr;
	uint32_t *dest_addr_l;
	uint32_t page_count;
	uint32_t remaining;
	uint32_t crc;

	dest_addr_l = dest_addr;

	spi_flash_cntl_page_read(&this_flash_cntl, src_addr, (uint32_t *)&image_hdr);
	fw_addr = src_addr + PAGE_SIZE;

	if(image_hdr.magic != LSCC_MAGIC)
	{
		return IMAGE_MAGIC_ERR;
	}

	/*
	 * Reading full page of firmware data
	 */
	for(page_count = 0; page_count < (image_hdr.len/PAGE_SIZE); page_count++)
	{
		spi_flash_cntl_page_read(&this_flash_cntl, fw_addr, dest_addr_l);
		fw_addr = fw_addr + PAGE_SIZE;
		dest_addr_l = dest_addr_l + (PAGE_SIZE/4);
	}

	remaining = image_hdr.len % PAGE_SIZE;

	if(remaining)
		spi_flash_cntl_page_read(&this_flash_cntl, fw_addr, dest_addr_l);

	crc = crc32((uint8_t *)dest_addr, image_hdr.len);

	if(crc != image_hdr.crc32)
	{
		printf("csc calcolato %x\r\n", crc);
		printf("csc header %x\r\n", image_hdr.crc32);
		return IMAGE_CRC32_ERR;
	}

	return IMAGE_SUCCESS;
}
