/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#ifndef MEMORY_CONTROLLER_H_
#define MEMORY_CONTROLLER_H_

/*
 * Register Offsets
 */
#define FEATURE_CTRL_REG	0x00
#define RESET_REG			0x04
#define SETTINGS_REG		0x08
#define ERROR_LOG_REG		0x0C
#define INT_STATUS_REG		0x10
#define INT_ENABLE_REG		0x14
#define INT_SET_REG			0x18
#define TRN_OP_REG			0x20
#define STATUS_REG			0x24

/*
 * Reset Register Bits
 */
#define CPU_RST_N		0x02
#define TRN_ENG_RST_N	0x01

/*
 * Training Operation Register Bits
 */
#define MEM_VREF_TRN_EN		0x80
#define MC_VREF_TRN_EN		0x40
#define CA_VREF_TRN_EN		0x20
#define WRITE_TRN_EN		0x10
#define READ_TRN_EN			0x08
#define WRITE_LVL_EN		0x04
#define CBT_EN				0x02
#define INIT_EN				0x01

/*
 * Status Register Bits
 */
#define ERR_ON_RANK			0x3000
#define WR_TRN_ERR			0x800
#define RD_TRN_ERR			0x400
#define WR_LVL_ERR			0x200
#define CBT_ERR				0x100
#define WR_TRN_DONE			0x10
#define RD_TRN_DONE			0x08
#define WR_LVL_DONE			0x04
#define CBT_DONE			0x02
#define PHY_READY			0x01

#define ALL_DONE			WR_TRN_DONE | RD_TRN_DONE | WR_LVL_DONE | CBT_DONE | PHY_READY
#define ERRORS				ERR_ON_RANK | WR_TRN_ERR | RD_TRN_ERR | WR_LVL_ERR | CBT_ERR

typedef enum {
	NO_FAIL = 0,
	CBT_FAIL,
	WR_LVL_FAIL,
	RD_DQS_TRN_FAIL,
	RD_DATA_EYE_TRN_FAIL,
	WR_TRN_FAIL,
	OTHER_FAIL
}ddr_ret;

ddr_ret mem_cntl_init();

#endif /* MEMORY_CONTROLLER_H_ */
