/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#ifndef SPI_FLASH_CNTL_H_
#define SPI_FLASH_CNTL_H_

#include <stdint.h>
#include <stdbool.h>


/*
 ------------------------------------------------------
 -                                                    -
 - Flash Controller Register-map                           -
 -                                                    -
 ------------------------------------------------------
 */
struct flash_cntl_dev {
  // basic command registers
  volatile uint32_t reg_page_program;                           // 0x00
  volatile uint32_t reg_page_read;                              // 0x04
  volatile uint32_t reg_4k_erase;                               // 0x08
  volatile uint32_t reg_32k_erase;                              // 0x0C
  volatile uint32_t reg_64k_erase;                              // 0x10
  volatile uint32_t reg_chip_erase;                             // 0x14
  volatile uint32_t reg_wr_en;                                  // 0x18
  volatile uint32_t reg_wr_dis;                                 // 0x1C
  volatile uint32_t reg_status_read;                            // 0x20
  volatile uint32_t reg_status_write;                           // 0x24
  volatile uint32_t reg_power_down;                             // 0x28
  volatile uint32_t reg_power_up;                               // 0x2C
  volatile uint32_t reg_mf_id;                                  // 0x30
  volatile uint32_t placeholder_0x34;                           // 0x34
  volatile uint32_t placeholder_0x38;                           // 0x38
  volatile uint32_t placeholder_0x3C;                           // 0x3C
  volatile uint32_t spi_flash_addr;                             // 0x40
  volatile uint32_t spi_flash_addr_mode;                        // 0x44

  volatile uint32_t placeholder_0x48_0x7C[(0x80-0x48)/4];       // 0x48 to 0x80
  // user command
  volatile uint32_t user_cmd_opcode;                            // 0x80
  volatile uint32_t user_cmd_addr;                              // 0x84
  volatile uint32_t user_cmd_wr_data_0;                         // 0x88
  volatile uint32_t user_cmd_wr_data_1;                         // 0x8C
  volatile uint32_t user_cmd_len;                               // 0x90
  volatile uint32_t user_cmd_config;                            // 0x94
  volatile uint32_t user_cmd_rd_data_0;                         // 0x98
  volatile uint32_t user_cmd_rd_data_1;                         // 0x9C
  volatile uint32_t user_cmd_start;                             // 0xA0

  volatile uint32_t placeholder_0xA4_0xFC[(0x100-0xA4)/4];      // 0xA4 to 0x100

  volatile uint32_t read_speed;                                 // 0x100
  volatile uint32_t page_program_size;                          // 0x104
  volatile uint32_t page_read_size;                             // 0x108
  volatile uint32_t write_protect_reg;                          // 0x10C
  volatile uint32_t sclk_rate;                                  // 0x110
  volatile uint32_t spi_first_transmitted;                      // 0x114
  volatile uint32_t ahbl_page_buffer_enable;                    // 0x118
  volatile uint32_t scl_polarity;			                    // 0x11C
  volatile uint32_t sclk_phase;				                    // 0x120

  volatile uint32_t placeholder_0x124_0x17C[(0x180-0x124)/4];   // 0x124 to 0x180

  volatile uint32_t slow_read_cfg;                              // 0x180
  volatile uint32_t fast_read_cfg;                              // 0x184
  volatile uint32_t byte_program_cfg;                           // 0x188
  volatile uint32_t page_program_cfg;                           // 0x18C
  volatile uint32_t block_erase_1_cfg;                          // 0x190
  volatile uint32_t block_erase_2_cfg;                          // 0x194
  volatile uint32_t block_erase_3_cfg;                          // 0x198
  volatile uint32_t chip_erase_cfg;                             // 0x19C
  volatile uint32_t write_enable_cfg;                           // 0x1A0
  volatile uint32_t write_disable_cfg;                          // 0x1A4
  volatile uint32_t read_status_cfg;                            // 0x1A8
  volatile uint32_t write_status_cfg;                           // 0x1AC
  volatile uint32_t power_down_cfg;                             // 0x1B0
  volatile uint32_t power_up_cfg;                               // 0x1B4
  volatile uint32_t read_id_cfg;                                // 0x1B8

  volatile uint32_t placeholder_0x1BC_0x1FC[(0x200-0x1BC)/4];   // 0x1BC to 0x1FC

  volatile uint32_t page_program_buffer[(0x400-0x200)/4];       // 0x200 to 0x3FC
  volatile uint32_t page_read_buffer[(0x600-0x400)/4];          // 0x400 to 0x5FC
};

#define PAGE_PROGRAM_BUFF_OFFSET  0x200
#define PAGE_READ_BUFF_OFFSET    0x400

// command register
#define FLASH_ADDR_MASK  0x0FFFFFF
#define FLASH_CMD_MASK   0xFF000000

// start trans reg
#define START_TRANSACTION  (1 << 0)

// flash cmd list
#define FLASH_READ        0x03
#define FLASH_FAST_READ     0x0B
#define FLASH_READ_STSTUS    0x05
#define FLASH_STS_WIP    0x01
#define FLASH_WRITE_EN      0x06
#define FLASH_WRITE_DIS      0x04
#define FLASH_PAGE_PROGRAM    0x02

enum
{
 FLASH_4K_ERASE  = 0,
 FLASH_32K_ERASE,
 FLASH_64K_ERASE,
 FLASH_CHIP_ERASE,
};

typedef enum
{
 ADDR_MODE_3B  = 0,
 ADDR_MODE_4B
}addr_mode;

#define PAGE_SIZE  256
#define SECTOR_SIZE    4096

#define STS_ERR    -1
#define STS_OK    0

#define SCFC_READ_TRANS    2
#define SCFC_WRITE_TRANS  1
#define IDLE      0

struct flash_cntl_instance {
  const char *name;
  uint32_t base;                       // base address of the SCFC module
  uint8_t work_mode;                   // polling mode or INT mode
  uint8_t status;                      // SCFC current status
  uint8_t data_rd_buf[PAGE_SIZE];      // store the data back in INT mode
  uint8_t data_wr_buf[PAGE_SIZE];      // store the data written out in INT mode
};

uint8_t spi_flash_cntl_init(struct flash_cntl_instance *this_flash_cntl,
      uint32_t base_addr, uint32_t page_program_size, uint32_t page_read_size, addr_mode mode);

uint8_t spi_flash_cntl_status_read(struct flash_cntl_instance *this_flash_cntl,
      uint32_t *buff);

uint8_t spi_flash_cntl_status_write(struct flash_cntl_instance *this_flash_cntl,
       uint8_t status);

uint8_t spi_flash_cntl_page_read(struct flash_cntl_instance *this_flash_cntl,
       uint32_t addr, uint32_t *buff);

uint8_t spi_flash_cntl_page_program(struct flash_cntl_instance *this_flash_cntl,
    uint32_t addr, uint32_t *buff);

uint8_t spi_flash_cntl_erase(struct flash_cntl_instance *this_flash_cntl,
          uint32_t addr, uint32_t mode);

uint8_t spi_flash_cntl_pw(struct flash_cntl_instance *this_flash_cntl,
       uint32_t power_on);

uint8_t spi_flash_cntl_id_read(struct flash_cntl_instance *this_flash_cntl,
       uint8_t *manu_id);

uint8_t spi_flash_cntl_set_clock_mode(struct flash_cntl_instance *this_flash_cntl, uint8_t mode);
uint8_t spi_flash_cntl_set_clock_rate(struct flash_cntl_instance *this_flash_cntl, uint8_t rate);

void spi_flash_cntl_isr(void *ctx);

#endif        /* SPI_FLASH_CNTL_H_ */
