/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */
#include "cpu.h"
#include "riscv.h"
#include "debug.h"
#include "plic.h"
#include "clint.h"
#include "interrupt.h"


extern struct interrupt_entry plic_int_table[];
extern struct interrupt_entry timer_irq_entry;
extern struct interrupt_entry soft_irq_entry;
struct interrupt_entry nmi_irq_entry;



void external_interrupt_handler(priv_e mode)
{
	int irq = plic_claim(mode);

	if (irq) {
        if (plic_int_table[irq].isr) {
            plic_int_table[irq].isr(plic_int_table[irq].context);
        }
		plic_complete(mode, irq);
	}
}


void external_interrupt_handler_m()
{
    external_interrupt_handler(ePRIV_M);
}


void external_interrupt_handler_s()
{
    external_interrupt_handler(ePRIV_S);
}


void software_interrupt_handler()
{
    int id = r_mhartid();
    clint_clear_soft_irq(id);

    if (soft_irq_entry.isr)
    {
        soft_irq_entry.isr(soft_irq_entry.context);   
    }
}


void timer_interrupt_handler()
{
    if (timer_irq_entry.isr)
    {
        timer_irq_entry.isr(timer_irq_entry.context);   
    }
}


void isr_callback(uint32_t mcause)
{
	switch (mcause) {
	case MCAUSE_VAL_MSIP:
        DEBUG("software interrupt!\r\n");
        software_interrupt_handler();
		break;
    case MCAUSE_VAL_MTIP:
        DEBUG("timer interrupt!\r\n");
        timer_interrupt_handler();
        break;
    case MCAUSE_VAL_SEIP:
        DEBUG("superior external interrupt!\r\n");
        external_interrupt_handler(ePRIV_S);
        break;
    case MCAUSE_VAL_MEIP:
        DEBUG("machine external interrupt!\r\n");
        external_interrupt_handler(ePRIV_M);
        break;
    default:
        DEBUG("unknown async exception!\r\n");
        break;
	}
}

 
int nmi_install_isr(irq_handler isr, void *context)
{
    nmi_irq_entry.isr = isr;
    nmi_irq_entry.context = context;
}


void nmi_callback(uint32_t mcause)
{
    DEBUG("non-maskable interrupt!\r\n");
    if (nmi_irq_entry.isr)
    {
        nmi_irq_entry.isr(nmi_irq_entry.context);
    }
}

