/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#include <stddef.h>
#include "cpu.h"
#include "debug.h"
#include "plic.h"
#include "watchdog_timer.h"


static wdt_config_t s_wdt_cfg;
extern int plic_int_register(uint8_t, uint8_t, uint8_t, irq_handler, void *);


static void watchdog_timer_isr(void *ctx)
{
    if (s_wdt_cfg.handler)
    {
        (*s_wdt_cfg.handler)(s_wdt_cfg.context);
    }
}


int watchdogtimer_start(uint32_t timeout, wdt_to_handler handler, void *context)
{
    if (!handler || timeout > WDT_TIMEOUT_TICK_MAX)
    {
        ERROR("invalid arguments: timeout=%d, handler=0x%08x\r\n", timeout, handler);
        return -1;
    }

    s_wdt_cfg.timeout = timeout;
    s_wdt_cfg.handler = handler;
    s_wdt_cfg.context = context;

    plic_int_register(PLIC_INT_SRC_S1WDT, 1, ePRIV_M, watchdog_timer_isr, NULL);

    uint32_t val = (1 << WDT_WDCSR_OFFSET_WDEN);
    val |= (s_wdt_cfg.timeout << WDT_WDCSR_OFFSET_WTOCNT) & WDT_WDCSR_MASK_WTOCNT; 
    CLINT_WDCSR = val;

    return 0;
}


void watchdogtimer_stop()
{
    uint32_t val = CLINT_WDCSR;
    val &= ~(1 << WDT_WDCSR_OFFSET_WDEN); 
    CLINT_WDCSR = val;
}


void watchdogtimer_kick()
{
    uint32_t val = CLINT_WDCSR;
    val |= ((s_wdt_cfg.timeout << WDT_WDCSR_OFFSET_WTOCNT) & WDT_WDCSR_MASK_WTOCNT); 
    CLINT_WDCSR = val;
}


const char *watchdogtimer_info()
{
    // TODO
}


