/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2023 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */
#include "hal.h"
#include "flash_cntl.h"
#include <string.h>

/*

*/
uint8_t flash_cntl_init(struct flash_cntl_instance *this_flash_cntl,
			uint32_t base_addr)
{
	if(this_flash_cntl == NULL)
		return STS_ERR;

	this_flash_cntl->base = base_addr;
	this_flash_cntl->status = IDLE;     // flash_cntl idle
	memset(this_flash_cntl->data_rd_buf, sizeof(this_flash_cntl->data_rd_buf), 0);
	memset(this_flash_cntl->data_wr_buf, sizeof(this_flash_cntl->data_wr_buf), 0);
	return STS_OK;
}

uint8_t flash_cntl_status_read(struct flash_cntl_instance *this_flash_cntl, uint32_t *buff)
{
	if(this_flash_cntl == NULL || buff == NULL)
			return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	*buff = flash_cntl->reg_status_read;

	return STS_OK;
}

uint8_t flash_cntl_status_write(struct flash_cntl_instance *this_flash_cntl,
			 uint8_t status)
{
	if(this_flash_cntl == NULL)
		return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	flash_cntl->reg_status_write = status;

	return STS_OK;

}


static uint8_t flash_cntl_wip(struct flash_cntl_instance *this_flash_cntl)
{
	uint32_t flash_status = 0;

	if(this_flash_cntl == NULL)
		return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	// read the flash status register to check WIP bit
	do
	{
		flash_status = flash_cntl->reg_status_read;
	}
	while(flash_status & FLASH_STS_WIP);

	return STS_OK;
}

uint8_t flash_cntl_page_read(struct flash_cntl_instance *this_flash_cntl,
			 uint32_t addr, uint32_t *buff)
{
	uint32_t current_addr = 0;

	if(this_flash_cntl == NULL || buff == NULL)
		return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	current_addr = (addr << 24 & 0xff000000) | (addr << 8 & 0x00ff0000)|
			(addr >> 8 & 0x0000ff00);

	flash_cntl->reg_page_read = current_addr | START_TRANSACTION;

	// status check to make sure page read is done
	flash_cntl_wip(this_flash_cntl);

	memcpy(buff, (void *)(this_flash_cntl->base + PAGE_READ_BUFF_OFFSET), PAGE_SIZE);

	return STS_OK;

}

uint8_t flash_cntl_page_program(struct flash_cntl_instance *this_flash_cntl,
		uint32_t addr, uint32_t *buff)
{
	uint32_t current_addr = 0;

	if(this_flash_cntl == NULL || buff == NULL)
		return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	current_addr = (addr << 24 & 0xff000000) | (addr << 8 & 0x00ff0000)|
			(addr >> 8 & 0x0000ff00);

	// write en

	flash_cntl->reg_wr_en = 1;

	memcpy((void *)(this_flash_cntl->base + PAGE_PROGRAM_BUFF_OFFSET), buff, PAGE_SIZE);

	flash_cntl->reg_page_program = current_addr | START_TRANSACTION;

	// status check to make sure page read is done
	flash_cntl_wip(this_flash_cntl);

	// write dis
	flash_cntl->reg_wr_dis = 1;

	return STS_OK;
}

uint8_t flash_cntl_erase(struct flash_cntl_instance *this_flash_cntl,
			    uint32_t addr, uint32_t mode)
{
	uint32_t current_addr = 0;  // should be 24-bit address

	if(this_flash_cntl == NULL)
			return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	current_addr = (addr << 24 & 0xff000000) | (addr << 8 & 0x00ff0000)|
				(addr >> 8 & 0x0000ff00);

	// write en
	flash_cntl->reg_wr_en = 1;

	// send the erase command
	switch(mode)
	{
	case FLASH_4K_ERASE:
		flash_cntl->reg_4k_erase = current_addr | START_TRANSACTION;
		break;
	case FLASH_32K_ERASE:
		flash_cntl->reg_32k_erase = current_addr | START_TRANSACTION;
		break;
	case FLASH_64K_ERASE:
		flash_cntl->reg_64k_erase = current_addr | START_TRANSACTION;
		break;
	case FLASH_CHIP_ERASE:
		flash_cntl->reg_chip_erase = current_addr | START_TRANSACTION;
		break;
	default:
		break;
	}

	// flash wip check
	flash_cntl_wip(this_flash_cntl);

	// send write disable
	flash_cntl->reg_wr_dis = 1;

	return STS_OK;
}

uint8_t flash_cntl_pw(struct flash_cntl_instance *this_flash_cntl,
			 uint32_t power_on)
{
	if(this_flash_cntl == NULL)
			return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

    if(power_on)
    {
    	flash_cntl->reg_power_up = 1;
    	flash_cntl->reg_power_up = 0;
    }
    else
    {
    	flash_cntl->reg_power_down = 1;
    	flash_cntl->reg_power_down = 0;
    }

	return STS_OK;
}

uint8_t flash_cntl_id_read(struct flash_cntl_instance *this_flash_cntl,
			 uint8_t *manu_id)
{
	if(this_flash_cntl == NULL)
			return STS_ERR;

	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	*manu_id = flash_cntl->reg_mf_id;

	return STS_OK;
}

void flash_cntl_isr(void *ctx)
{
	uint32_t int_status = 0;
	struct flash_cntl_instance *this_flash_cntl = (struct flash_cntl_instance *) ctx;
	volatile struct flash_cntl_dev *flash_cntl = (struct flash_cntl_dev *)this_flash_cntl->base;

	return;
}


