# Selecting the protocol define in the eval_top and tb_top
f_params = open('eval/dut_params.v', 'r')
sim_val = 0
ddr_type = 0;
intf_type = '`define '
pll_trefclk = 0.0
s_pll_trefclk = ""
ddr_width  = 0
dataclk_en = 0
apb_if_en  = 0
while True:
    line = f_params.readline()
    str_spl = line.split(' ')
    val = str_spl[-1]
    param = str_spl[1]
    if param == 'SIM_VAL':
        pos = val.index(';')
        val = val[0:(pos)]
        print(param, ' = ', val)
        sim_val = int(val)
    if param == 'DDR_TYPE':
        pos = val.index(';')
        val = val[0:(pos)]
        print(param, ' = ', val)
        ddr_type = int(val)
        if (ddr_type==1):
          intf_type = intf_type + 'LPDDR4'
        else:
          intf_type = intf_type + 'DDR3'
    if param == 'CLKI_FREQ':
        pos = val.index(';')
        val = val[0:(pos)]
        print(param, ' = ', val)
        pll_trefclk = 1000.0/float(val)
        s_pll_trefclk = f"{pll_trefclk:.3f}"
    if param == 'DDR_WIDTH':
        pos = val.index(';')
        val = val[0:(pos)]
        print(param, ' = ', val)
        ddr_width = int(val)
    if param == 'DATA_CLK_EN':
        pos = val.index(';')
        val = val[0:(pos)]
        print(param, ' = ', val)
        dataclk_en = int(val)
    if param == 'APB_INTF_EN':
        pos = val.index(';')
        val = val[0:(pos)]
        print(param, ' = ', val)
        apb_if_en = int(val)
        break

# Adding the protocol define in the eval_top
with open('eval/eval_top.sv', 'r') as file :
  filedata = file.read()

filedata = filedata.replace('//SELECT_PROTOCOL', intf_type)

with open('eval/eval_top.sv', 'w') as file:
  file.write(filedata)
file.close()
  
# Adding the protocol define in the tb_top
with open('testbench/tb_top.sv', 'r') as file :
  filedata = file.read()

filedata = filedata.replace('//SELECT_PROTOCOL', intf_type)

with open('testbench/tb_top.sv', 'w') as file:
  file.write(filedata)
file.close()
  
# Setting correct PLL refclk value to clock_constraint.sdc
# Not yet supported in CPNX LPDDR4 MC
#with open('eval/clock_constraint.sdc', 'r') as file :
#  filedata = file.read()
#
#filedata = filedata.replace('PLL_REFCLK_PERIOD', s_pll_trefclk)
#
#with open('eval/clock_constraint.sdc', 'w') as file:
#  file.write(filedata)
#file.close()

# Removing CDC constrains for Bus I/F when DATA_CLK_EN=0
with open('eval/constraint.pdc', 'r') as file :
  filedata = file.read()
if dataclk_en==1:
  filedata = filedata.replace('#For_DATA_CLK_EN#', '')
else:
  filedata = filedata.replace('#For_DATA_CLK_EN#', '#')
with open('eval/constraint.pdc', 'w') as file:
  file.write(filedata)
file.close()
  
# Removing CDC apb2init when APB_INTF_EN=1
with open('eval/constraint.pdc', 'r') as file :
  filedata = file.read()
if apb_if_en==0:
  filedata = filedata.replace('#For_APB_INTF_DIS#', '')
else:
  filedata = filedata.replace('#For_APB_INTF_DIS#', '#')
with open('eval/constraint.pdc', 'w') as file:
  file.write(filedata)  
file.close()

# Removing Pin assignment for Channel B when DDR_WIDTH=16
#with open('eval/constraint.pdc', 'r') as file :
#  filedata = file.read()
#if ddr_width==16:
#  filedata = filedata.replace('#For_Channel_B#', '#')
#else:
#  filedata = filedata.replace('#For_Channel_B#', '')
#with open('eval/constraint.pdc', 'w') as file:
#  file.write(filedata)  
#file.close()

if sim_val==1:
  with open('eval/eval_top.sv', 'r') as file :
    filedata = file.read()
    filedata = filedata.replace('parameter SIM = 0', 'parameter SIM = 1')
  with open('eval/eval_top.sv', 'w') as file:
    file.write(filedata)  
  file.close()