// >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// ------------------------------------------------------------------
// Copyright (c) 2022 by Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// ------------------------------------------------------------------
//
// IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL�
// DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.
//
// Lattice grants permission to use this code pursuant to the
// terms of the Lattice Propel License Agreement.
//
// DISCLAIMER:
//
//  LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER
//  EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE
//  PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE
//  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
//  FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE
//  FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT
//  LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE
//  OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS
//  HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR 
//  SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE
//  PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE
//  ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE
//  OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL
//  ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR
//  ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
//  SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
//  INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST
//  PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF
//  LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S
//  SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE. 
//  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR
//  USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY
//  RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY
//  THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE
//  USE OF FORMAL SOFTWARE VALIDATION METHODS.
// ------------------------------------------------------------------

/* synthesis translate_off*/
`define SBP_SIMULATION
/* synthesis translate_on*/
`ifndef SBP_SIMULATION
`define SBP_SYNTHESIS
`endif


//
// 
//
module mc_axi4_traffic_gen #(
    parameter SIM             = 0,
    parameter GEN_IN_WIDTH    = 1,
    parameter GEN_OUT_WIDTH   = 4,
    parameter AXI_ADDR_WIDTH  = 0,
    parameter AXI_DATA_WIDTH  = 0,
    parameter DATA_CLK_EN     = 0,
    parameter DDR_CMD_FREQ    = 0.0,
    parameter AXI_ID_WIDTH    = 0,
    parameter AXI_LEN_WIDTH   = 0
)
(
    aclk_i    ,
    areset_n_i,
    pclk_i    ,
    preset_n_i,   
    sclk_i    ,
    rstn_i    ,
    rxd_i     , 
    txd_o     , 
    led_o     , 
    gen_in_i  ,
	p_rd_error_occur_o,
    a_rd_error_occur_o,
	a_rd_timeout_o    ,
	a_wr_timeout_o    ,
    a_test_num_o      ,
 
    axi_arvalid_o,  
    axi_arid_o   ,  
    axi_arlen_o  ,  
    axi_arburst_o,  
    axi_araddr_o ,  
    axi_arready_i,  
    axi_arqos_o  ,  
    axi_arsize_o ,  
             
    axi_rresp_i , 
    axi_rid_i   , 
    axi_rdata_i , 
    axi_rvalid_i, 
    axi_rlast_i , 
    axi_rready_o, 
             
    axi_bready_o, 
    axi_bvalid_i,  
    axi_bresp_i ,  
    axi_bid_i   ,  
             
    axi_awvalid_o ,
    axi_awid_o    ,
    axi_awlen_o   ,
    axi_awburst_o ,
    axi_awaddr_o  ,
    axi_awready_i ,
    axi_awqos_o   , 
    axi_awsize_o  ,
             
    axi_wvalid_o  , 
    axi_wready_i  ,
    axi_wdata_o   , 
    axi_wstrb_o   , 
    axi_wlast_o   , 
    
    apb_paddr_o, 
    apb_prdata_i, 
    apb_pwdata_o, 
    apb_penable_o, 
    apb_pready_i, 
    apb_psel_o, 
    apb_pslverr_i, 
    apb_pwrite_o
) /* synthesis sbp_module=true */ ;

    input                           aclk_i    ;
    input                           areset_n_i;
    input                           pclk_i    ;
    input                           preset_n_i;
    input                           sclk_i    ;
    input                           rstn_i    ;
    input                           rxd_i     ;
    output                          txd_o     ;
    inout  [9:0]                    led_o     ;
    input  [GEN_IN_WIDTH-1:0]       gen_in_i  ;
	output                          p_rd_error_occur_o;
    output                          a_rd_error_occur_o;
	output                          a_rd_timeout_o    ;
	output                          a_wr_timeout_o    ;
//    output                          a_rd_err_o        ;
    output [GEN_OUT_WIDTH-1:0]      a_test_num_o      ;
    
    output                          apb_penable_o;
    output                          apb_psel_o   ;
    output                          apb_pwrite_o ;
    output [11:0]                   apb_paddr_o  ;
    output [31:0]                   apb_pwdata_o ;
    input  [31:0]                   apb_prdata_i ;
    input                           apb_pslverr_i;
    input                           apb_pready_i ;

    input                           axi_arready_i;
    output                          axi_arvalid_o;
    output  [AXI_ADDR_WIDTH -1 : 0] axi_araddr_o ;
    output  [AXI_ID_WIDTH-1 : 0]    axi_arid_o   ;
    output  [AXI_LEN_WIDTH-1 : 0]   axi_arlen_o  ;
    output  [1:0]                   axi_arburst_o;
    output  [3:0]                   axi_arqos_o  ;
    output  [2:0]                   axi_arsize_o ;
    
   
    output                          axi_rready_o ;
    input                           axi_rvalid_i ;
    input   [AXI_DATA_WIDTH - 1: 0] axi_rdata_i  ;
    input   [1:0]                   axi_rresp_i  ;
    input   [AXI_ID_WIDTH - 1: 0]   axi_rid_i    ;
    input                           axi_rlast_i  ;
    

    output                          axi_bready_o ;
    input                           axi_bvalid_i ;
    input   [1:0]                   axi_bresp_i  ;
    input   [AXI_ID_WIDTH - 1: 0]   axi_bid_i    ;
   
    output                          axi_awvalid_o;
    output  [AXI_ID_WIDTH-1 : 0]    axi_awid_o   ;   
    output  [AXI_LEN_WIDTH - 1: 0]  axi_awlen_o  ;
    output  [1:0]                   axi_awburst_o;
    output  [AXI_ADDR_WIDTH-1 : 0]  axi_awaddr_o ;
    output  [2:0]                   axi_awsize_o ;
    output  [3:0]                   axi_awqos_o  ;
    input                           axi_awready_i;
   
    output                          axi_wvalid_o ; 
    output  [AXI_DATA_WIDTH-1 : 0]  axi_wdata_o  ;
    output  [AXI_DATA_WIDTH/8 -1:0] axi_wstrb_o  ;     
    output                          axi_wlast_o  ;
    input                           axi_wready_i ;
    
    
    wire [31:0]ahbl0_inst_AHBL_M00_interconnect_HADDR_interconnect;
    wire [2:0]ahbl0_inst_AHBL_M00_interconnect_HBURST_interconnect;
    wire [3:0]ahbl0_inst_AHBL_M00_interconnect_HPROT_interconnect;
    wire [31:0]ahbl0_inst_AHBL_M00_interconnect_HRDATA_interconnect;
    wire [2:0]ahbl0_inst_AHBL_M00_interconnect_HSIZE_interconnect;
    wire [1:0]ahbl0_inst_AHBL_M00_interconnect_HTRANS_interconnect;
    wire [31:0]ahbl0_inst_AHBL_M00_interconnect_HWDATA_interconnect;
    wire [31:0]ahbl0_inst_AHBL_M01_interconnect_HADDR_interconnect;
    wire [2:0]ahbl0_inst_AHBL_M01_interconnect_HBURST_interconnect;
    wire [3:0]ahbl0_inst_AHBL_M01_interconnect_HPROT_interconnect;
    wire [31:0]ahbl0_inst_AHBL_M01_interconnect_HRDATA_interconnect;
    wire [2:0]ahbl0_inst_AHBL_M01_interconnect_HSIZE_interconnect;
    wire [1:0]ahbl0_inst_AHBL_M01_interconnect_HTRANS_interconnect;
    wire [31:0]ahbl0_inst_AHBL_M01_interconnect_HWDATA_interconnect;
    
    wire [31:0]cpu0_M1_DATA_HADDR_interconnect     /* synthesis syn_keep=1 */;
    wire [2:0] cpu0_M1_DATA_HBURST_interconnect    /* synthesis syn_keep=1 */;
    wire [3:0] cpu0_M1_DATA_HPROT_interconnect     /* synthesis syn_keep=1 */;
    wire [31:0]cpu0_M1_DATA_HRDATA_interconnect    /* synthesis syn_keep=1 */;
    wire [2:0] cpu0_M1_DATA_HSIZE_interconnect     /* synthesis syn_keep=1 */;
    wire [1:0] cpu0_M1_DATA_HTRANS_interconnect    /* synthesis syn_keep=1 */;
    wire [31:0]cpu0_M1_DATA_HWDATA_interconnect    /* synthesis syn_keep=1 */;
    wire       cpu0_M1_DATA_HMASTLOCK_interconnect /* synthesis syn_keep=1 */; 
    wire       cpu0_M1_DATA_HREADYOUT_interconnect /* synthesis syn_keep=1 */;
    wire       cpu0_M1_DATA_HRESP_interconnect     /* synthesis syn_keep=1 */; 
    wire       cpu0_M1_DATA_HWRITE_interconnect    /* synthesis syn_keep=1 */;
    
    wire cpu0_inst_system_resetn_o_net, ahbl0_inst_AHBL_M00_interconnect_HMASTLOCK_interconnect, 
        ahbl0_inst_AHBL_M00_interconnect_HREADYOUT_interconnect, ahbl0_inst_AHBL_M00_interconnect_HREADY_interconnect, 
        ahbl0_inst_AHBL_M00_interconnect_HRESP_interconnect, ahbl0_inst_AHBL_M00_interconnect_HSELx_interconnect, 
        ahbl0_inst_AHBL_M00_interconnect_HWRITE_interconnect, ahbl0_inst_AHBL_M01_interconnect_HMASTLOCK_interconnect, 
        ahbl0_inst_AHBL_M01_interconnect_HREADYOUT_interconnect, ahbl0_inst_AHBL_M01_interconnect_HREADY_interconnect, 
        ahbl0_inst_AHBL_M01_interconnect_HRESP_interconnect, ahbl0_inst_AHBL_M01_interconnect_HSELx_interconnect, 
        ahbl0_inst_AHBL_M01_interconnect_HWRITE_interconnect;
    wire [31:0]ahbl2apb0_inst_APB_M0_interconnect_PADDR_interconnect;
    wire [31:0]ahbl2apb0_inst_APB_M0_interconnect_PRDATA_interconnect;
    wire [31:0]ahbl2apb0_inst_APB_M0_interconnect_PWDATA_interconnect;
    
    wire ahbl2apb0_inst_APB_M0_interconnect_PENABLE_interconnect, ahbl2apb0_inst_APB_M0_interconnect_PREADY_interconnect, 
        ahbl2apb0_inst_APB_M0_interconnect_PSELx_interconnect, ahbl2apb0_inst_APB_M0_interconnect_PSLVERR_interconnect, 
        ahbl2apb0_inst_APB_M0_interconnect_PWRITE_interconnect;
    wire [31:0]apb0_inst_APB_M03_interconnect_PRDATA_interconnect;
    wire [12:0]apb0_inst_APB_M03_interconnect_PADDR_interconnect;
    wire [31:0]apb0_inst_APB_M03_interconnect_PWDATA_interconnect;
    
    wire apb0_inst_APB_M03_interconnect_PREADY_interconnect, apb0_inst_APB_M03_interconnect_PSLVERR_interconnect, 
        apb0_inst_APB_M03_interconnect_PSELx_interconnect, apb0_inst_APB_M03_interconnect_PWRITE_interconnect, 
        apb0_inst_APB_M03_interconnect_PENABLE_interconnect;
    wire [12:0]apb0_inst_APB_M00_interconnect_PADDR_interconnect;
    wire [31:0]apb0_inst_APB_M00_interconnect_PRDATA_interconnect;
    wire [31:0]apb0_inst_APB_M00_interconnect_PWDATA_interconnect;
    wire [12:0]apb0_inst_APB_M01_interconnect_PADDR_interconnect;
    wire [31:0]apb0_inst_APB_M01_interconnect_PRDATA_interconnect;
    wire [31:0]apb0_inst_APB_M01_interconnect_PWDATA_interconnect;
    wire [12:0]apb0_inst_APB_M02_interconnect_PADDR_interconnect;
    wire [31:0]apb0_inst_APB_M02_interconnect_PRDATA_interconnect;
    wire [31:0]apb0_inst_APB_M02_interconnect_PWDATA_interconnect;
    
    wire apb0_inst_APB_M00_interconnect_PENABLE_interconnect, apb0_inst_APB_M00_interconnect_PREADY_interconnect, 
        apb0_inst_APB_M00_interconnect_PSELx_interconnect, apb0_inst_APB_M00_interconnect_PSLVERR_interconnect, 
        apb0_inst_APB_M00_interconnect_PWRITE_interconnect, apb0_inst_APB_M01_interconnect_PENABLE_interconnect, 
        apb0_inst_APB_M01_interconnect_PREADY_interconnect, apb0_inst_APB_M01_interconnect_PSELx_interconnect, 
        apb0_inst_APB_M01_interconnect_PSLVERR_interconnect, apb0_inst_APB_M01_interconnect_PWRITE_interconnect, 
        apb0_inst_APB_M02_interconnect_PENABLE_interconnect, apb0_inst_APB_M02_interconnect_PREADY_interconnect, 
        apb0_inst_APB_M02_interconnect_PSELx_interconnect, apb0_inst_APB_M02_interconnect_PSLVERR_interconnect, 
        apb0_inst_APB_M02_interconnect_PWRITE_interconnect;
    wire [31:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HADDR_interconnect;
    wire [2:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HBURST_interconnect;
    wire [3:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HPROT_interconnect;
    wire [31:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HRDATA_interconnect;
    wire [2:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HSIZE_interconnect;
    wire [1:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HTRANS_interconnect;
    wire [31:0]cpu0_inst_AHBL_M0_INSTR_interconnect_HWDATA_interconnect;
    
    wire cpu0_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK_interconnect, cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect, 
        cpu0_inst_AHBL_M0_INSTR_interconnect_HRESP_interconnect, cpu0_inst_AHBL_M0_INSTR_interconnect_HWRITE_interconnect, 
        uart0_inst_INT_M0_interconnect_IRQ_interconnect, gpio0_inst_INTR_interconnect_IRQ_interconnect;
//    wire   a_rd_err_w;

    ahbl0 ahbl0_inst (.ahbl_m00_haddr_mstr_o({ahbl0_inst_AHBL_M00_interconnect_HADDR_interconnect}), 
          .ahbl_m00_hburst_mstr_o({ahbl0_inst_AHBL_M00_interconnect_HBURST_interconnect}), 
          .ahbl_m00_hprot_mstr_o({ahbl0_inst_AHBL_M00_interconnect_HPROT_interconnect}), 
          .ahbl_m00_hrdata_mstr_i({ahbl0_inst_AHBL_M00_interconnect_HRDATA_interconnect}), 
          .ahbl_m00_hsize_mstr_o({ahbl0_inst_AHBL_M00_interconnect_HSIZE_interconnect}), 
          .ahbl_m00_htrans_mstr_o({ahbl0_inst_AHBL_M00_interconnect_HTRANS_interconnect}), 
          .ahbl_m00_hwdata_mstr_o({ahbl0_inst_AHBL_M00_interconnect_HWDATA_interconnect}), 
          .ahbl_m01_haddr_mstr_o({ahbl0_inst_AHBL_M01_interconnect_HADDR_interconnect}), 
          .ahbl_m01_hburst_mstr_o({ahbl0_inst_AHBL_M01_interconnect_HBURST_interconnect}), 
          .ahbl_m01_hprot_mstr_o({ahbl0_inst_AHBL_M01_interconnect_HPROT_interconnect}), 
          .ahbl_m01_hrdata_mstr_i({ahbl0_inst_AHBL_M01_interconnect_HRDATA_interconnect}), 
          .ahbl_m01_hsize_mstr_o({ahbl0_inst_AHBL_M01_interconnect_HSIZE_interconnect}), 
          .ahbl_m01_htrans_mstr_o({ahbl0_inst_AHBL_M01_interconnect_HTRANS_interconnect}), 
          .ahbl_m01_hwdata_mstr_o({ahbl0_inst_AHBL_M01_interconnect_HWDATA_interconnect}), 
          .ahbl_s00_haddr_slv_i({cpu0_M1_DATA_HADDR_interconnect}), 
          .ahbl_s00_hburst_slv_i({cpu0_M1_DATA_HBURST_interconnect}), 
          .ahbl_s00_hprot_slv_i({cpu0_M1_DATA_HPROT_interconnect}), 
          .ahbl_s00_hrdata_slv_o({cpu0_M1_DATA_HRDATA_interconnect}), 
          .ahbl_s00_hsize_slv_i({cpu0_M1_DATA_HSIZE_interconnect}), 
          .ahbl_s00_htrans_slv_i({cpu0_M1_DATA_HTRANS_interconnect}), 
          .ahbl_s00_hwdata_slv_i({cpu0_M1_DATA_HWDATA_interconnect}), 
          .ahbl_hclk_i(pclk_i), .ahbl_hresetn_i(cpu0_inst_system_resetn_o_net), 
          .ahbl_m00_hmastlock_mstr_o(ahbl0_inst_AHBL_M00_interconnect_HMASTLOCK_interconnect), 
          .ahbl_m00_hready_mstr_i(ahbl0_inst_AHBL_M00_interconnect_HREADYOUT_interconnect), 
          .ahbl_m00_hready_mstr_o(ahbl0_inst_AHBL_M00_interconnect_HREADY_interconnect), 
          .ahbl_m00_hresp_mstr_i(ahbl0_inst_AHBL_M00_interconnect_HRESP_interconnect), 
          .ahbl_m00_hsel_mstr_o(ahbl0_inst_AHBL_M00_interconnect_HSELx_interconnect), 
          .ahbl_m00_hwrite_mstr_o(ahbl0_inst_AHBL_M00_interconnect_HWRITE_interconnect), 
          .ahbl_m01_hmastlock_mstr_o(ahbl0_inst_AHBL_M01_interconnect_HMASTLOCK_interconnect), 
          .ahbl_m01_hready_mstr_i(ahbl0_inst_AHBL_M01_interconnect_HREADYOUT_interconnect), 
          .ahbl_m01_hready_mstr_o(ahbl0_inst_AHBL_M01_interconnect_HREADY_interconnect), 
          .ahbl_m01_hresp_mstr_i(ahbl0_inst_AHBL_M01_interconnect_HRESP_interconnect), 
          .ahbl_m01_hsel_mstr_o(ahbl0_inst_AHBL_M01_interconnect_HSELx_interconnect), 
          .ahbl_m01_hwrite_mstr_o(ahbl0_inst_AHBL_M01_interconnect_HWRITE_interconnect), 
          .ahbl_s00_hmastlock_slv_i(cpu0_M1_DATA_HMASTLOCK_interconnect), 
          .ahbl_s00_hready_slv_i(cpu0_M1_DATA_HREADYOUT_interconnect), 
          .ahbl_s00_hreadyout_slv_o(cpu0_M1_DATA_HREADYOUT_interconnect), 
          .ahbl_s00_hresp_slv_o(cpu0_M1_DATA_HRESP_interconnect), 
          .ahbl_s00_hsel_slv_i(cpu0_M1_DATA_HTRANS_interconnect[1]), 
          .ahbl_s00_hwrite_slv_i(cpu0_M1_DATA_HWRITE_interconnect));
    defparam ahbl0_inst.FULL_DECODE_EN = 1;
    defparam ahbl0_inst.M_ADDR_WIDTH = 32;
    defparam ahbl0_inst.S0_ADDR_RANGE = 32'h00008000;
    defparam ahbl0_inst.S0_BASE_ADDR = 32'h00000000;
    defparam ahbl0_inst.S0_FRAGMENT_EN = 1;
    defparam ahbl0_inst.S1_ADDR_RANGE = 32'h00002000;
    defparam ahbl0_inst.S1_BASE_ADDR = 32'h00008000;
    defparam ahbl0_inst.S1_FRAGMENT_EN = 1;
    ahbl2apb0 ahbl2apb0_inst (.ahbl_haddr_i({ahbl0_inst_AHBL_M01_interconnect_HADDR_interconnect}), 
            .ahbl_hburst_i({ahbl0_inst_AHBL_M01_interconnect_HBURST_interconnect}), 
            .ahbl_hprot_i({ahbl0_inst_AHBL_M01_interconnect_HPROT_interconnect}), 
            .ahbl_hrdata_o({ahbl0_inst_AHBL_M01_interconnect_HRDATA_interconnect}), 
            .ahbl_hsize_i({ahbl0_inst_AHBL_M01_interconnect_HSIZE_interconnect}), 
            .ahbl_htrans_i({ahbl0_inst_AHBL_M01_interconnect_HTRANS_interconnect}), 
            .ahbl_hwdata_i({ahbl0_inst_AHBL_M01_interconnect_HWDATA_interconnect}), 
            .apb_paddr_o({ahbl2apb0_inst_APB_M0_interconnect_PADDR_interconnect}), 
            .apb_prdata_i({ahbl2apb0_inst_APB_M0_interconnect_PRDATA_interconnect}), 
            .apb_pwdata_o({ahbl2apb0_inst_APB_M0_interconnect_PWDATA_interconnect}), 
            .ahbl_hmastlock_i(ahbl0_inst_AHBL_M01_interconnect_HMASTLOCK_interconnect), 
            .ahbl_hready_i(ahbl0_inst_AHBL_M01_interconnect_HREADY_interconnect), 
            .ahbl_hreadyout_o(ahbl0_inst_AHBL_M01_interconnect_HREADYOUT_interconnect), 
            .ahbl_hresp_o(ahbl0_inst_AHBL_M01_interconnect_HRESP_interconnect), 
            .ahbl_hsel_i(ahbl0_inst_AHBL_M01_interconnect_HSELx_interconnect), 
            .ahbl_hwrite_i(ahbl0_inst_AHBL_M01_interconnect_HWRITE_interconnect), 
            .apb_penable_o(ahbl2apb0_inst_APB_M0_interconnect_PENABLE_interconnect), 
            .apb_pready_i(ahbl2apb0_inst_APB_M0_interconnect_PREADY_interconnect), 
            .apb_psel_o(ahbl2apb0_inst_APB_M0_interconnect_PSELx_interconnect), 
            .apb_pslverr_i(ahbl2apb0_inst_APB_M0_interconnect_PSLVERR_interconnect), 
            .apb_pwrite_o(ahbl2apb0_inst_APB_M0_interconnect_PWRITE_interconnect), 
            .clk_i(pclk_i), .rst_n_i(cpu0_inst_system_resetn_o_net));
    defparam ahbl2apb0_inst.ADDR_WIDTH = 32;

    lscc_axi4_traffic_gen #(
      .AXI_DATA_WIDTH(AXI_DATA_WIDTH ),
      .AXI_ADDR_WIDTH(AXI_ADDR_WIDTH ),
      .AXI_LEN_WIDTH (AXI_LEN_WIDTH  ),
      .AXI_ID_WIDTH  (AXI_ID_WIDTH   ),
      .DATA_CLK_EN   (DATA_CLK_EN    ),
      .DDR_CMD_FREQ  (DDR_CMD_FREQ   ),
      .GEN_IN_WIDTH  (GEN_IN_WIDTH   ),
      .GEN_OUT_WIDTH (GEN_OUT_WIDTH  )
    )
    axi_tragen_inst (
      .pclk_i       (pclk_i), 
      .preset_n_i   (cpu0_inst_system_resetn_o_net),
      .apb_pslverr_o(apb0_inst_APB_M03_interconnect_PSLVERR_interconnect     ), 
      .apb_psel_i   (apb0_inst_APB_M03_interconnect_PSELx_interconnect       ), 
      .apb_pwrite_i (apb0_inst_APB_M03_interconnect_PWRITE_interconnect      ), 
      .apb_penable_i(apb0_inst_APB_M03_interconnect_PENABLE_interconnect     ),
      .apb_prdata_o ({apb0_inst_APB_M03_interconnect_PRDATA_interconnect}    ), 
      .apb_pready_o (apb0_inst_APB_M03_interconnect_PREADY_interconnect      ),
      .apb_paddr_i  ({apb0_inst_APB_M03_interconnect_PADDR_interconnect[9:0]}), 
      .apb_pwdata_i ({apb0_inst_APB_M03_interconnect_PWDATA_interconnect}    ), 
      .gen_in_i     (gen_in_i     ),
	  .p_rd_error_occur_o(p_rd_error_occur_o),
	  .a_rd_timeout_o(a_rd_timeout_o),
	  .a_wr_timeout_o(a_wr_timeout_o),
      .a_rd_err_o   (a_rd_error_occur_o),
      .a_gen_out_o  (a_test_num_o  ),
      .aclk_i       (aclk_i        ),
      .areset_n_i   (areset_n_i    ),
      .sclk_i       (sclk_i        ),
      .rstn_i       (rstn_i        ),
      .axi_awready_i(axi_awready_i ),
      .axi_awvalid_o(axi_awvalid_o ),
      .axi_awaddr_o (axi_awaddr_o  ),
      .axi_awsize_o (axi_awsize_o  ),
      .axi_awlen_o  (axi_awlen_o   ),
      .axi_awburst_o(axi_awburst_o ),
      .axi_awqos_o  (axi_awqos_o   ),
      .axi_awid_o   (axi_awid_o    ),
      
      .axi_wready_i (axi_wready_i  ),
      .axi_wvalid_o (axi_wvalid_o  ),
      .axi_wdata_o  (axi_wdata_o   ),
      .axi_wstrb_o  (axi_wstrb_o   ),
      .axi_wlast_o  (axi_wlast_o   ),
      
      .axi_bready_o (axi_bready_o  ),
      .axi_bvalid_i (axi_bvalid_i  ),
      .axi_bresp_i  (axi_bresp_i   ),
      .axi_bid_i    (axi_bid_i     ), 
      
      .axi_arvalid_o(axi_arvalid_o ),
      .axi_arid_o   (axi_arid_o    ),
      .axi_arlen_o  (axi_arlen_o   ),
      .axi_arburst_o(axi_arburst_o ),
      .axi_araddr_o (axi_araddr_o  ),
      .axi_arqos_o  (axi_arqos_o   ),
      .axi_arsize_o (axi_arsize_o  ),
      .axi_arready_i(axi_arready_i ),

      .axi_rready_o (axi_rready_o  ),
      .axi_rvalid_i (axi_rvalid_i  ),
      .axi_rdata_i  (axi_rdata_i   ),
      .axi_rresp_i  (axi_rresp_i   ),
      .axi_rid_i    (axi_rid_i     ),
      .axi_rlast_i  (axi_rlast_i   )       
    );
           
    apb0 apb0_inst (.apb_m00_paddr_mstr_o({apb0_inst_APB_M00_interconnect_PADDR_interconnect}), 
         .apb_m00_prdata_mstr_i({apb0_inst_APB_M00_interconnect_PRDATA_interconnect}), 
         .apb_m00_pwdata_mstr_o({apb0_inst_APB_M00_interconnect_PWDATA_interconnect}), 
         .apb_m01_paddr_mstr_o({apb0_inst_APB_M01_interconnect_PADDR_interconnect}), 
         .apb_m01_prdata_mstr_i({apb0_inst_APB_M01_interconnect_PRDATA_interconnect}), 
         .apb_m01_pwdata_mstr_o({apb0_inst_APB_M01_interconnect_PWDATA_interconnect}), 
         .apb_m02_paddr_mstr_o({apb0_inst_APB_M02_interconnect_PADDR_interconnect}), 
         .apb_m02_prdata_mstr_i({apb0_inst_APB_M02_interconnect_PRDATA_interconnect}), 
         .apb_m02_pwdata_mstr_o({apb0_inst_APB_M02_interconnect_PWDATA_interconnect}), 
         .apb_m03_paddr_mstr_o({apb0_inst_APB_M03_interconnect_PADDR_interconnect}), 
         .apb_m03_prdata_mstr_i({apb0_inst_APB_M03_interconnect_PRDATA_interconnect}), 
         .apb_m03_pwdata_mstr_o({apb0_inst_APB_M03_interconnect_PWDATA_interconnect}), 
         .apb_s00_paddr_slv_i({ahbl2apb0_inst_APB_M0_interconnect_PADDR_interconnect[12:0]}), 
         .apb_s00_prdata_slv_o({ahbl2apb0_inst_APB_M0_interconnect_PRDATA_interconnect}), 
         .apb_s00_pwdata_slv_i({ahbl2apb0_inst_APB_M0_interconnect_PWDATA_interconnect}), 
         .apb_m00_penable_mstr_o(apb0_inst_APB_M00_interconnect_PENABLE_interconnect), 
         .apb_m00_pready_mstr_i(apb0_inst_APB_M00_interconnect_PREADY_interconnect), 
         .apb_m00_psel_mstr_o(apb0_inst_APB_M00_interconnect_PSELx_interconnect), 
         .apb_m00_pslverr_mstr_i(apb0_inst_APB_M00_interconnect_PSLVERR_interconnect), 
         .apb_m00_pwrite_mstr_o(apb0_inst_APB_M00_interconnect_PWRITE_interconnect), 
         .apb_m01_penable_mstr_o(apb0_inst_APB_M01_interconnect_PENABLE_interconnect), 
         .apb_m01_pready_mstr_i(apb0_inst_APB_M01_interconnect_PREADY_interconnect), 
         .apb_m01_psel_mstr_o(apb0_inst_APB_M01_interconnect_PSELx_interconnect), 
         .apb_m01_pslverr_mstr_i(apb0_inst_APB_M01_interconnect_PSLVERR_interconnect), 
         .apb_m01_pwrite_mstr_o(apb0_inst_APB_M01_interconnect_PWRITE_interconnect), 
         .apb_m02_penable_mstr_o(apb0_inst_APB_M02_interconnect_PENABLE_interconnect), 
         .apb_m02_pready_mstr_i(apb0_inst_APB_M02_interconnect_PREADY_interconnect), 
         .apb_m02_psel_mstr_o(apb0_inst_APB_M02_interconnect_PSELx_interconnect), 
         .apb_m02_pslverr_mstr_i(apb0_inst_APB_M02_interconnect_PSLVERR_interconnect), 
         .apb_m02_pwrite_mstr_o(apb0_inst_APB_M02_interconnect_PWRITE_interconnect), 
         .apb_m03_penable_mstr_o(apb0_inst_APB_M03_interconnect_PENABLE_interconnect), 
         .apb_m03_pready_mstr_i(apb0_inst_APB_M03_interconnect_PREADY_interconnect), 
         .apb_m03_psel_mstr_o(apb0_inst_APB_M03_interconnect_PSELx_interconnect), 
         .apb_m03_pslverr_mstr_i(apb0_inst_APB_M03_interconnect_PSLVERR_interconnect), 
         .apb_m03_pwrite_mstr_o(apb0_inst_APB_M03_interconnect_PWRITE_interconnect), 
         .apb_pclk_i(pclk_i), .apb_presetn_i(cpu0_inst_system_resetn_o_net), 
         .apb_s00_penable_slv_i(ahbl2apb0_inst_APB_M0_interconnect_PENABLE_interconnect), 
         .apb_s00_pready_slv_o(ahbl2apb0_inst_APB_M0_interconnect_PREADY_interconnect), 
         .apb_s00_psel_slv_i(ahbl2apb0_inst_APB_M0_interconnect_PSELx_interconnect), 
         .apb_s00_pslverr_slv_o(ahbl2apb0_inst_APB_M0_interconnect_PSLVERR_interconnect), 
         .apb_s00_pwrite_slv_i(ahbl2apb0_inst_APB_M0_interconnect_PWRITE_interconnect));
    defparam apb0_inst.FULL_DECODE_EN = 1;
    defparam apb0_inst.M_ADDR_WIDTH  = 13;
    defparam apb0_inst.S0_ADDR_RANGE = 13'h0400;
    defparam apb0_inst.S0_BASE_ADDR  = 13'h0000;
    defparam apb0_inst.S1_ADDR_RANGE = 13'h0400;
    defparam apb0_inst.S1_BASE_ADDR  = 13'h0400;
    defparam apb0_inst.S2_ADDR_RANGE = 13'h1000;
    defparam apb0_inst.S2_BASE_ADDR  = 13'h1000;
    defparam apb0_inst.S3_ADDR_RANGE = 13'h0400;
    defparam apb0_inst.S3_BASE_ADDR  = 13'h0800;
    cpu0 #(.SIM(SIM)) cpu0_inst (
         .ahbl_m_data_haddr_o({cpu0_M1_DATA_HADDR_interconnect}), 
         .ahbl_m_data_hburst_o({cpu0_M1_DATA_HBURST_interconnect}), 
         .ahbl_m_data_hprot_o({cpu0_M1_DATA_HPROT_interconnect}), 
         .ahbl_m_data_hrdata_i({cpu0_M1_DATA_HRDATA_interconnect}), 
         .ahbl_m_data_hsize_o({cpu0_M1_DATA_HSIZE_interconnect}), 
         .ahbl_m_data_htrans_o({cpu0_M1_DATA_HTRANS_interconnect}), 
         .ahbl_m_data_hwdata_o({cpu0_M1_DATA_HWDATA_interconnect}), 
         .ahbl_m_instr_haddr_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HADDR_interconnect}), 
         .ahbl_m_instr_hburst_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HBURST_interconnect}), 
         .ahbl_m_instr_hprot_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HPROT_interconnect}), 
         .ahbl_m_instr_hrdata_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HRDATA_interconnect}), 
         .ahbl_m_instr_hsize_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HSIZE_interconnect}), 
         .ahbl_m_instr_htrans_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HTRANS_interconnect}), 
         .ahbl_m_instr_hwdata_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HWDATA_interconnect}), 
         .ahbl_m_data_hmastlock_o(cpu0_M1_DATA_HMASTLOCK_interconnect), 
         .ahbl_m_data_hready_i(cpu0_M1_DATA_HREADYOUT_interconnect), 
         .ahbl_m_data_hresp_i(cpu0_M1_DATA_HRESP_interconnect), 
         .ahbl_m_data_hwrite_o(cpu0_M1_DATA_HWRITE_interconnect), 
         .ahbl_m_instr_hmastlock_o(cpu0_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK_interconnect), 
         .ahbl_m_instr_hready_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect), 
         .ahbl_m_instr_hresp_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HRESP_interconnect), 
         .ahbl_m_instr_hwrite_o(cpu0_inst_AHBL_M0_INSTR_interconnect_HWRITE_interconnect), 
         .clk_i(pclk_i), .irq0_i(uart0_inst_INT_M0_interconnect_IRQ_interconnect), 
         .irq1_i(gpio0_inst_INTR_interconnect_IRQ_interconnect), .rst_n_i(preset_n_i), 
         .system_resetn_o(cpu0_inst_system_resetn_o_net), .timer_irq_o());
         
//    assign presetn_o = cpu0_inst_system_resetn_o_net;       
         
    gpio0 gpio0_inst (.apb_paddr_i({apb0_inst_APB_M01_interconnect_PADDR_interconnect[5:0]}), 
          .apb_prdata_o({apb0_inst_APB_M01_interconnect_PRDATA_interconnect}), 
          .apb_pwdata_i({apb0_inst_APB_M01_interconnect_PWDATA_interconnect}), 
          .gpio_io({led_o}), .apb_penable_i(apb0_inst_APB_M01_interconnect_PENABLE_interconnect), 
          .apb_pready_o(apb0_inst_APB_M01_interconnect_PREADY_interconnect), 
          .apb_psel_i(apb0_inst_APB_M01_interconnect_PSELx_interconnect), 
          .apb_pslverr_o(apb0_inst_APB_M01_interconnect_PSLVERR_interconnect), 
          .apb_pwrite_i(apb0_inst_APB_M01_interconnect_PWRITE_interconnect), 
          .clk_i(pclk_i), .int_o(gpio0_inst_INTR_interconnect_IRQ_interconnect), 
          .resetn_i(cpu0_inst_system_resetn_o_net));
    memc_apb memc_apb_inst (
            .pclk_i(pclk_i),
            .preset_n_i(cpu0_inst_system_resetn_o_net),
            .apb_paddr_slv_i({apb0_inst_APB_M02_interconnect_PADDR_interconnect[11:0]}), 
            .apb_pwdata_slv_i({apb0_inst_APB_M02_interconnect_PWDATA_interconnect}), 
            .apb_prdata_slv_o({apb0_inst_APB_M02_interconnect_PRDATA_interconnect}), 
            .apb_paddr_mstr_o({apb_paddr_o}), 
            .apb_pwdata_mstr_o({apb_pwdata_o}), 
            .apb_prdata_mstr_i({apb_prdata_i}), 
            .apb_penable_slv_i(apb0_inst_APB_M02_interconnect_PENABLE_interconnect), 
            .apb_psel_slv_i(apb0_inst_APB_M02_interconnect_PSELx_interconnect), 
            .apb_pwrite_slv_i(apb0_inst_APB_M02_interconnect_PWRITE_interconnect), 
            .apb_pready_slv_o(apb0_inst_APB_M02_interconnect_PREADY_interconnect), 
            .apb_pslverr_slv_o(apb0_inst_APB_M02_interconnect_PSLVERR_interconnect), 
            .apb_penable_mstr_o(apb_penable_o), 
            .apb_psel_mstr_o(apb_psel_o), 
            .apb_pwrite_mstr_o(apb_pwrite_o), 
            .apb_pready_mstr_i(apb_pready_i), 
            .apb_pslverr_mstr_i(apb_pslverr_i));

generate
  if(SIM == 0) begin : IMPL
    sysmem0 sysmem0_inst (.ahbl_s0_haddr_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HADDR_interconnect}), 
            .ahbl_s0_hburst_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HBURST_interconnect}), 
            .ahbl_s0_hprot_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HPROT_interconnect}), 
            .ahbl_s0_hrdata_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HRDATA_interconnect}), 
            .ahbl_s0_hsize_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HSIZE_interconnect}), 
            .ahbl_s0_htrans_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HTRANS_interconnect}), 
            .ahbl_s0_hwdata_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HWDATA_interconnect}), 
            .ahbl_s1_haddr_i({ahbl0_inst_AHBL_M00_interconnect_HADDR_interconnect}), 
            .ahbl_s1_hburst_i({ahbl0_inst_AHBL_M00_interconnect_HBURST_interconnect}), 
            .ahbl_s1_hprot_i({ahbl0_inst_AHBL_M00_interconnect_HPROT_interconnect}), 
            .ahbl_s1_hrdata_o({ahbl0_inst_AHBL_M00_interconnect_HRDATA_interconnect}), 
            .ahbl_s1_hsize_i({ahbl0_inst_AHBL_M00_interconnect_HSIZE_interconnect}), 
            .ahbl_s1_htrans_i({ahbl0_inst_AHBL_M00_interconnect_HTRANS_interconnect}), 
            .ahbl_s1_hwdata_i({ahbl0_inst_AHBL_M00_interconnect_HWDATA_interconnect}), 
            .ahbl_hclk_i(pclk_i), .ahbl_hresetn_i(cpu0_inst_system_resetn_o_net), 
            .ahbl_s0_hmastlock_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK_interconnect), 
            .ahbl_s0_hready_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect), 
            .ahbl_s0_hreadyout_o(cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect), 
            .ahbl_s0_hresp_o(cpu0_inst_AHBL_M0_INSTR_interconnect_HRESP_interconnect), 
            .ahbl_s0_hsel_i(1'b1), .ahbl_s0_hwrite_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HWRITE_interconnect), 
            .ahbl_s1_hmastlock_i(ahbl0_inst_AHBL_M00_interconnect_HMASTLOCK_interconnect), 
            .ahbl_s1_hready_i(ahbl0_inst_AHBL_M00_interconnect_HREADY_interconnect), 
            .ahbl_s1_hreadyout_o(ahbl0_inst_AHBL_M00_interconnect_HREADYOUT_interconnect), 
            .ahbl_s1_hresp_o(ahbl0_inst_AHBL_M00_interconnect_HRESP_interconnect), 
            .ahbl_s1_hsel_i(ahbl0_inst_AHBL_M00_interconnect_HSELx_interconnect), 
            .ahbl_s1_hwrite_i(ahbl0_inst_AHBL_M00_interconnect_HWRITE_interconnect));
    defparam sysmem0_inst.MEM_ID = "1.0.2";
  end
  else begin : SIML
    sysmem0_sim sysmem0_inst (.ahbl_s0_haddr_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HADDR_interconnect}), 
            .ahbl_s0_hburst_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HBURST_interconnect}), 
            .ahbl_s0_hprot_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HPROT_interconnect}), 
            .ahbl_s0_hrdata_o({cpu0_inst_AHBL_M0_INSTR_interconnect_HRDATA_interconnect}), 
            .ahbl_s0_hsize_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HSIZE_interconnect}), 
            .ahbl_s0_htrans_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HTRANS_interconnect}), 
            .ahbl_s0_hwdata_i({cpu0_inst_AHBL_M0_INSTR_interconnect_HWDATA_interconnect}), 
            .ahbl_s1_haddr_i({ahbl0_inst_AHBL_M00_interconnect_HADDR_interconnect}), 
            .ahbl_s1_hburst_i({ahbl0_inst_AHBL_M00_interconnect_HBURST_interconnect}), 
            .ahbl_s1_hprot_i({ahbl0_inst_AHBL_M00_interconnect_HPROT_interconnect}), 
            .ahbl_s1_hrdata_o({ahbl0_inst_AHBL_M00_interconnect_HRDATA_interconnect}), 
            .ahbl_s1_hsize_i({ahbl0_inst_AHBL_M00_interconnect_HSIZE_interconnect}), 
            .ahbl_s1_htrans_i({ahbl0_inst_AHBL_M00_interconnect_HTRANS_interconnect}), 
            .ahbl_s1_hwdata_i({ahbl0_inst_AHBL_M00_interconnect_HWDATA_interconnect}), 
            .ahbl_hclk_i(pclk_i), .ahbl_hresetn_i(cpu0_inst_system_resetn_o_net), 
            .ahbl_s0_hmastlock_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HMASTLOCK_interconnect), 
            .ahbl_s0_hready_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect), 
            .ahbl_s0_hreadyout_o(cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect), 
            .ahbl_s0_hresp_o(cpu0_inst_AHBL_M0_INSTR_interconnect_HRESP_interconnect), 
            .ahbl_s0_hsel_i(1'b1), .ahbl_s0_hwrite_i(cpu0_inst_AHBL_M0_INSTR_interconnect_HWRITE_interconnect), 
            .ahbl_s1_hmastlock_i(ahbl0_inst_AHBL_M00_interconnect_HMASTLOCK_interconnect), 
            .ahbl_s1_hready_i(ahbl0_inst_AHBL_M00_interconnect_HREADY_interconnect), 
            .ahbl_s1_hreadyout_o(ahbl0_inst_AHBL_M00_interconnect_HREADYOUT_interconnect), 
            .ahbl_s1_hresp_o(ahbl0_inst_AHBL_M00_interconnect_HRESP_interconnect), 
            .ahbl_s1_hsel_i(ahbl0_inst_AHBL_M00_interconnect_HSELx_interconnect), 
            .ahbl_s1_hwrite_i(ahbl0_inst_AHBL_M00_interconnect_HWRITE_interconnect));
    defparam sysmem0_inst.MEM_ID = "1.0.2";
  end
endgenerate
    
    uart0 uart0_inst (
      .apb_paddr_i({apb0_inst_APB_M00_interconnect_PADDR_interconnect[5:0]}), 
      .apb_prdata_o({apb0_inst_APB_M00_interconnect_PRDATA_interconnect}), 
      .apb_pwdata_i({apb0_inst_APB_M00_interconnect_PWDATA_interconnect}), 
      .apb_penable_i(apb0_inst_APB_M00_interconnect_PENABLE_interconnect), 
      .apb_pready_o(apb0_inst_APB_M00_interconnect_PREADY_interconnect), 
      .apb_psel_i(apb0_inst_APB_M00_interconnect_PSELx_interconnect), 
      .apb_pslverr_o(apb0_inst_APB_M00_interconnect_PSLVERR_interconnect), 
      .apb_pwrite_i(apb0_inst_APB_M00_interconnect_PWRITE_interconnect), 
      .int_o(uart0_inst_INT_M0_interconnect_IRQ_interconnect),
      .clk_i(pclk_i),  
      .rst_n_i(cpu0_inst_system_resetn_o_net), 
      .rxd_i(rxd_i), 
      .txd_o(txd_o)
    );
    
// For debugging with reveal
`ifdef RVL_DEBUG_EN
reg [15:0] rvl_cpu_inst_hraddr;
reg [1:0]  rvl_cpu_inst_htrans;
reg        rvl_cpu_inst_hready;
reg [31:0] rvl_cpu_inst_hrdata;
reg        rvl_cpu_inst_hresp;
reg [15:0] rvl_cpu_data_hraddr;
reg [1:0]  rvl_cpu_data_htrans;
reg        rvl_cpu_data_hready;
reg [31:0] rvl_cpu_data_hrdata;
reg        rvl_cpu_data_hwrite;
reg [31:0] rvl_cpu_data_hwdata;
reg        rvl_cpu_data_hresp;
reg        rvl_uart_psel;
reg        rvl_gpio_psel;

always @(posedge pclk_i or negedge preset_n_i) begin
  if (!preset_n_i) begin
    rvl_cpu_inst_hraddr <= 16'h0000;
    rvl_cpu_inst_htrans <= 2'h0;
    rvl_cpu_inst_hready <= 1'b0;
    rvl_cpu_inst_hrdata <= 32'h00000000;
    rvl_cpu_inst_hresp  <= 1'b0;
    rvl_cpu_data_hraddr <= 16'h0000;
    rvl_cpu_data_htrans <= 2'h0;
    rvl_cpu_data_hready <= 1'b0;
    rvl_cpu_data_hrdata <= 32'h00000000;
    rvl_cpu_data_hwrite <= 1'b0;
    rvl_cpu_data_hwdata <= 32'h00000000;
    rvl_cpu_data_hresp  <= 1'b0;
    rvl_uart_psel       <= 1'b0;
    rvl_gpio_psel       <= 1'b0;
  end
  else begin
    rvl_cpu_inst_hraddr <= cpu0_inst_AHBL_M0_INSTR_interconnect_HADDR_interconnect[15:0];
    rvl_cpu_inst_htrans <= cpu0_inst_AHBL_M0_INSTR_interconnect_HTRANS_interconnect;
    rvl_cpu_inst_hready <= cpu0_inst_AHBL_M0_INSTR_interconnect_HREADYOUT_interconnect;
    rvl_cpu_inst_hrdata <= cpu0_inst_AHBL_M0_INSTR_interconnect_HRDATA_interconnect;
    rvl_cpu_inst_hresp  <= cpu0_inst_AHBL_M0_INSTR_interconnect_HRESP_interconnect;
    rvl_cpu_data_hraddr <= cpu0_M1_DATA_HADDR_interconnect[15:0];
    rvl_cpu_data_htrans <= cpu0_M1_DATA_HTRANS_interconnect;
    rvl_cpu_data_hready <= cpu0_M1_DATA_HREADYOUT_interconnect;
    rvl_cpu_data_hrdata <= cpu0_M1_DATA_HRDATA_interconnect;
    rvl_cpu_data_hwrite <= cpu0_M1_DATA_HWRITE_interconnect;
    rvl_cpu_data_hwdata <= cpu0_M1_DATA_HWDATA_interconnect;
    rvl_cpu_data_hresp  <= cpu0_M1_DATA_HRESP_interconnect;
    rvl_uart_psel       <= apb0_inst_APB_M00_interconnect_PSELx_interconnect;
    rvl_gpio_psel       <= apb0_inst_APB_M01_interconnect_PSELx_interconnect;
  end
end
`endif

endmodule


