/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#include "cpu.h"

#ifndef MAXNUM_CPU
    .equ    MAXNUM_CPU, 1
#endif

.section .crt0

    .global    _start

_start:

    mv x1, zero
    mv x2, zero
    mv x3, zero
    mv x4, zero
    mv x5, zero
    mv x6, zero
    mv x7, zero
    mv x8, zero
    mv x9, zero
    mv x10, zero
    mv x11, zero
    mv x12, zero
    mv x13, zero
    mv x14, zero
    mv x15, zero
    mv x16, zero
    mv x17, zero
    mv x18, zero
    mv x19, zero
    mv x20, zero
    mv x21, zero
    mv x22, zero
    mv x23, zero
    mv x24, zero
    mv x25, zero
    mv x26, zero
    mv x27, zero
    mv x28, zero
    mv x29, zero
    mv x30, zero
    mv x31, zero
 

#ifdef __riscv_flen
    fssr zero

    fmv.w.x f0, zero
    fmv.w.x f1, zero
    fmv.w.x f2, zero
    fmv.w.x f3, zero
    fmv.w.x f4, zero
    fmv.w.x f5, zero
    fmv.w.x f6, zero
    fmv.w.x f7, zero
    fmv.w.x f8, zero
    fmv.w.x f9, zero
    fmv.w.x f10, zero
    fmv.w.x f11, zero
    fmv.w.x f12, zero
    fmv.w.x f13, zero
    fmv.w.x f14, zero
    fmv.w.x f15, zero
    fmv.w.x f16, zero
    fmv.w.x f17, zero
    fmv.w.x f18, zero
    fmv.w.x f19, zero
    fmv.w.x f20, zero
    fmv.w.x f21, zero
    fmv.w.x f22, zero
    fmv.w.x f23, zero
    fmv.w.x f24, zero
    fmv.w.x f25, zero
    fmv.w.x f26, zero
    fmv.w.x f27, zero
    fmv.w.x f28, zero
    fmv.w.x f29, zero
    fmv.w.x f30, zero
    fmv.w.x f31, zero
#endif

    # park harts with id != 0
    csrr    t0, mhartid     # read current hart id:
    mv      tp, t0          # keep CPU's hartid in its tp for later usage in S mode and U mode.
    bnez    t0, park        # if we're not on the hart 0
                            # we park the hart

    la      sp, _stack_start  # set the initial stack pointer

bss_init:
    la a0, _bss_start
    la a1, _bss_end
bss_loop:
    beq a0,a1,bss_done
    sw zero,0(a0)
    add a0,a0,4
    j bss_loop
bss_done:
                  
    # Set mstatus.MPIE to 1, so MRET will enable the interrupt.
    li      t0, 1 << 7
    csrr    a1, mstatus
    or      t0, t0, a1
    csrw    mstatus, t0

    j       main                    # hart 0 jump to c

park:
    wfi
    j       park

