
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Propel (64-bit)
    1.1.2010292113
    Soft IP Version: 1.0.0
    2021 04 06 20:03:53
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module apb0 (apb_pclk_i, 
        apb_presetn_i, 
        apb_m03_pready_mstr_i, 
        apb_m03_pslverr_mstr_i, 
        apb_m03_prdata_mstr_i, 
        apb_m03_psel_mstr_o, 
        apb_m03_paddr_mstr_o, 
        apb_m03_pwrite_mstr_o, 
        apb_m03_pwdata_mstr_o, 
        apb_m03_penable_mstr_o, 
        apb_m02_pready_mstr_i, 
        apb_m02_pslverr_mstr_i, 
        apb_m02_prdata_mstr_i, 
        apb_m02_psel_mstr_o, 
        apb_m02_paddr_mstr_o, 
        apb_m02_pwrite_mstr_o, 
        apb_m02_pwdata_mstr_o, 
        apb_m02_penable_mstr_o, 
        apb_m01_pready_mstr_i, 
        apb_m01_pslverr_mstr_i, 
        apb_m01_prdata_mstr_i, 
        apb_m01_psel_mstr_o, 
        apb_m01_paddr_mstr_o, 
        apb_m01_pwrite_mstr_o, 
        apb_m01_pwdata_mstr_o, 
        apb_m01_penable_mstr_o, 
        apb_s00_psel_slv_i, 
        apb_s00_paddr_slv_i, 
        apb_s00_pwrite_slv_i, 
        apb_s00_pwdata_slv_i, 
        apb_s00_penable_slv_i, 
        apb_s00_pready_slv_o, 
        apb_s00_pslverr_slv_o, 
        apb_s00_prdata_slv_o, 
        apb_m00_pready_mstr_i, 
        apb_m00_pslverr_mstr_i, 
        apb_m00_prdata_mstr_i, 
        apb_m00_psel_mstr_o, 
        apb_m00_paddr_mstr_o, 
        apb_m00_pwrite_mstr_o, 
        apb_m00_pwdata_mstr_o, 
        apb_m00_penable_mstr_o) ;
    input apb_pclk_i ; 
    input apb_presetn_i ; 
    input [0:0] apb_m03_pready_mstr_i ; 
    input [0:0] apb_m03_pslverr_mstr_i ; 
    input [31:0] apb_m03_prdata_mstr_i ; 
    output [0:0] apb_m03_psel_mstr_o ; 
    output [12:0] apb_m03_paddr_mstr_o ; 
    output [0:0] apb_m03_pwrite_mstr_o ; 
    output [31:0] apb_m03_pwdata_mstr_o ; 
    output [0:0] apb_m03_penable_mstr_o ; 
    input [0:0] apb_m02_pready_mstr_i ; 
    input [0:0] apb_m02_pslverr_mstr_i ; 
    input [31:0] apb_m02_prdata_mstr_i ; 
    output [0:0] apb_m02_psel_mstr_o ; 
    output [12:0] apb_m02_paddr_mstr_o ; 
    output [0:0] apb_m02_pwrite_mstr_o ; 
    output [31:0] apb_m02_pwdata_mstr_o ; 
    output [0:0] apb_m02_penable_mstr_o ; 
    input [0:0] apb_m01_pready_mstr_i ; 
    input [0:0] apb_m01_pslverr_mstr_i ; 
    input [31:0] apb_m01_prdata_mstr_i ; 
    output [0:0] apb_m01_psel_mstr_o ; 
    output [12:0] apb_m01_paddr_mstr_o ; 
    output [0:0] apb_m01_pwrite_mstr_o ; 
    output [31:0] apb_m01_pwdata_mstr_o ; 
    output [0:0] apb_m01_penable_mstr_o ; 
    input [0:0] apb_s00_psel_slv_i ; 
    input [12:0] apb_s00_paddr_slv_i ; 
    input [0:0] apb_s00_pwrite_slv_i ; 
    input [31:0] apb_s00_pwdata_slv_i ; 
    input [0:0] apb_s00_penable_slv_i ; 
    output [0:0] apb_s00_pready_slv_o ; 
    output [0:0] apb_s00_pslverr_slv_o ; 
    output [31:0] apb_s00_prdata_slv_o ; 
    input [0:0] apb_m00_pready_mstr_i ; 
    input [0:0] apb_m00_pslverr_mstr_i ; 
    input [31:0] apb_m00_prdata_mstr_i ; 
    output [0:0] apb_m00_psel_mstr_o ; 
    output [12:0] apb_m00_paddr_mstr_o ; 
    output [0:0] apb_m00_pwrite_mstr_o ; 
    output [31:0] apb_m00_pwdata_mstr_o ; 
    output [0:0] apb_m00_penable_mstr_o ; 
    parameter M_ADDR_WIDTH = 13 ; 
    parameter FULL_DECODE_EN = 1 ; 
    parameter S0_BASE_ADDR = 13'h0000 ; 
    parameter S0_ADDR_RANGE = 13'h0400 ; 
    parameter S1_BASE_ADDR = 13'h0400 ; 
    parameter S1_ADDR_RANGE = 13'h0400 ; 
    parameter S2_BASE_ADDR = 13'h0800 ; 
    parameter S2_ADDR_RANGE = 13'h0400 ; 
    parameter S3_BASE_ADDR = 13'h0c00 ; 
    parameter S3_ADDR_RANGE = 13'h0400 ; 
    apb0_ipgen_lscc_apb_interconnect #(.TOTAL_MASTER_CNT(1),
            .TOTAL_SLAVE_CNT(4),
            .M_ADDR_WIDTH(M_ADDR_WIDTH),
            .FULL_DECODE_EN(FULL_DECODE_EN),
            .DATA_WIDTH(32),
            .OUTREG_EN(0),
            .FAMILY("LIFCL"),
            .S0_BASE_ADDR(S0_BASE_ADDR),
            .S0_ADDR_RANGE(S0_ADDR_RANGE),
            .S1_BASE_ADDR(S1_BASE_ADDR),
            .S1_ADDR_RANGE(S1_ADDR_RANGE),
            .S2_BASE_ADDR(S2_BASE_ADDR),
            .S2_ADDR_RANGE(S2_ADDR_RANGE),
            .S3_BASE_ADDR(S3_BASE_ADDR),
            .S3_ADDR_RANGE(S3_ADDR_RANGE),
//            .S4_BASE_ADDR(13'h1000),
//            .S4_ADDR_RANGE(13'h0400),
//            .S5_BASE_ADDR(13'h1400),
//            .S5_ADDR_RANGE(13'h0400),
//            .S6_BASE_ADDR(13'h1800),
//            .S6_ADDR_RANGE(13'h0400),
//            .S7_BASE_ADDR(13'h1c00),
//            .S7_ADDR_RANGE(13'h0400),
//            .S8_BASE_ADDR(13'h2000),
//            .S8_ADDR_RANGE(13'h0400),
//            .S9_BASE_ADDR(13'h2400),
//            .S9_ADDR_RANGE(13'h0400),
//            .S10_BASE_ADDR(13'h2800),
//            .S10_ADDR_RANGE(13'h0400),
//            .S11_BASE_ADDR(13'h2c00),
//            .S11_ADDR_RANGE(13'h0400),
//            .S12_BASE_ADDR(13'h3000),
//            .S12_ADDR_RANGE(13'h0400),
//            .S13_BASE_ADDR(13'h3400),
//            .S13_ADDR_RANGE(13'h0400),
//            .S14_BASE_ADDR(13'h3800),
//            .S14_ADDR_RANGE(13'h0400),
//            .S15_BASE_ADDR(13'h3c00),
//            .S15_ADDR_RANGE(13'h0400),
//            .S16_BASE_ADDR(13'h4000),
//            .S16_ADDR_RANGE(13'h0400),
//            .S17_BASE_ADDR(13'h4400),
//            .S17_ADDR_RANGE(13'h0400),
//            .S18_BASE_ADDR(13'h4800),
//            .S18_ADDR_RANGE(13'h0400),
//            .S19_BASE_ADDR(13'h4c00),
//            .S19_ADDR_RANGE(13'h0400),
//            .S20_BASE_ADDR(13'h5000),
//            .S20_ADDR_RANGE(13'h0400),
//            .S21_BASE_ADDR(13'h5400),
//            .S21_ADDR_RANGE(13'h0400),
//            .S22_BASE_ADDR(13'h5800),
//            .S22_ADDR_RANGE(13'h0400),
//            .S23_BASE_ADDR(13'h5c00),
//            .S23_ADDR_RANGE(13'h0400),
//            .S24_BASE_ADDR(13'h6000),
//            .S24_ADDR_RANGE(13'h0400),
//            .S25_BASE_ADDR(13'h6400),
//            .S25_ADDR_RANGE(13'h0400),
//            .S26_BASE_ADDR(13'h6800),
//            .S26_ADDR_RANGE(13'h0400),
//            .S27_BASE_ADDR(13'h6c00),
//            .S27_ADDR_RANGE(13'h0400),
//            .S28_BASE_ADDR(13'h7000),
//            .S28_ADDR_RANGE(13'h0400),
//            .S29_BASE_ADDR(13'h7400),
//            .S29_ADDR_RANGE(13'h0400),
//            .S30_BASE_ADDR(13'h7800),
//            .S30_ADDR_RANGE(13'h0400),
//            .S31_BASE_ADDR(13'h7c00),
//            .S31_ADDR_RANGE(13'h0400),
//            .S_ARBITER_SCHEME(3'd0),
            .S_M_PRIO_IDX(1'd1)) lscc_apb_interconnect_inst (.apb_pclk_i(apb_pclk_i), 
                .apb_presetn_i(apb_presetn_i), 
                .apb_psel_slv_i({apb_s00_psel_slv_i[0]}), 
                .apb_paddr_slv_i({apb_s00_paddr_slv_i[12:0]}), 
                .apb_pwrite_slv_i({apb_s00_pwrite_slv_i[0]}), 
                .apb_pwdata_slv_i({apb_s00_pwdata_slv_i[31:0]}), 
                .apb_penable_slv_i({apb_s00_penable_slv_i[0]}), 
                .apb_pready_slv_o({apb_s00_pready_slv_o[0]}), 
                .apb_pslverr_slv_o({apb_s00_pslverr_slv_o[0]}), 
                .apb_prdata_slv_o({apb_s00_prdata_slv_o[31:0]}), 
                .apb_pready_mstr_i({apb_m03_pready_mstr_i[0],
                    apb_m02_pready_mstr_i[0],
                    apb_m01_pready_mstr_i[0],
                    apb_m00_pready_mstr_i[0]}), 
                .apb_pslverr_mstr_i({apb_m03_pslverr_mstr_i[0],
                    apb_m02_pslverr_mstr_i[0],
                    apb_m01_pslverr_mstr_i[0],
                    apb_m00_pslverr_mstr_i[0]}), 
                .apb_prdata_mstr_i({apb_m03_prdata_mstr_i[31:0],
                    apb_m02_prdata_mstr_i[31:0],
                    apb_m01_prdata_mstr_i[31:0],
                    apb_m00_prdata_mstr_i[31:0]}), 
                .apb_psel_mstr_o({apb_m03_psel_mstr_o[0],
                    apb_m02_psel_mstr_o[0],
                    apb_m01_psel_mstr_o[0],
                    apb_m00_psel_mstr_o[0]}), 
                .apb_paddr_mstr_o({apb_m03_paddr_mstr_o[12:0],
                    apb_m02_paddr_mstr_o[12:0],
                    apb_m01_paddr_mstr_o[12:0],
                    apb_m00_paddr_mstr_o[12:0]}), 
                .apb_pwrite_mstr_o({apb_m03_pwrite_mstr_o[0],
                    apb_m02_pwrite_mstr_o[0],
                    apb_m01_pwrite_mstr_o[0],
                    apb_m00_pwrite_mstr_o[0]}), 
                .apb_pwdata_mstr_o({apb_m03_pwdata_mstr_o[31:0],
                    apb_m02_pwdata_mstr_o[31:0],
                    apb_m01_pwdata_mstr_o[31:0],
                    apb_m00_pwdata_mstr_o[31:0]}), 
                .apb_penable_mstr_o({apb_m03_penable_mstr_o[0],
                    apb_m02_penable_mstr_o[0],
                    apb_m01_penable_mstr_o[0],
                    apb_m00_penable_mstr_o[0]})) ; 
endmodule



`timescale 1ns/1ps

/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_arbiter.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_arbiter #(parameter K = 32, 
        parameter TOTAL_MASTER_CNT = 8, 
        parameter DATA_WIDTH = 32, 
        parameter M_PRIO_WIDTH = clog2(TOTAL_MASTER_CNT), 
        parameter [((TOTAL_MASTER_CNT * M_PRIO_WIDTH) - 1):0] M_PRIO_IDX = {3'd7,
                3'd6,
                3'd5,
                3'd4,
                3'd3,
                3'd2,
                3'd1,
                3'd0}, 
        parameter [2:0] ARBITER_SCHEME = 3'b0, 
        parameter [((TOTAL_MASTER_CNT * K) - 1):0] MAX_BURST_CNT = {32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32}) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input apb_pclk_i, 
    input apb_presetn_i, 
    input apb_arb_en_i, 
    input apb_ack_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_req_i, 
    input apb_adv_cnt_i, 
    output reg [(TOTAL_MASTER_CNT - 1):0] apb_gnt_o //output wire                             apb_max_reached_o
        ) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam M = TOTAL_MASTER_CNT ; 
    localparam PW = M_PRIO_WIDTH ; 
    localparam BURST_SZ = (DATA_WIDTH / 8) ; 
    localparam ST_WIDTH = 2 ; 
    localparam ST_IDLE = 2'b01 ; 
    localparam ST_ACTIVE = 2'b10 ; 
    // ------------------------------------------------------------------------------
    // Generate Variables
    // ------------------------------------------------------------------------------
    genvar i ; 
    // ------------------------------------------------------------------------------
    // Register Declarations
    // ------------------------------------------------------------------------------
    reg [(ST_WIDTH - 1):0] cs_sm ; 
    reg [(ST_WIDTH - 1):0] ns_sm ; 
    reg arb_en_Q ; 
    //reg [K-1:0]                             run_cnt;
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire [(M - 1):0] req_in ; 
    wire [(M - 1):0] req_mask ; 
    wire [((M * PW) - 1):0] prio_idx = M_PRIO_IDX ; 
    wire [((M * K) - 1):0] max_burst = MAX_BURST_CNT ; 
    // ------------------------------------------------------------------------------
    // Assign Statements
    // ------------------------------------------------------------------------------
    //assign                                  apb_max_reached_o =    (cs_sm == ST_ACTIVE)
    //                                                             && (run_cnt == 0)
    //                                                             && |apb_gnt_o;
    // ------------------------------------------------------------------------------
    // Generate Blocks
    // ------------------------------------------------------------------------------
    generate
        for (i = 0;(i < M);i = (i + 1))
        begin : genblk1
            assign req_mask[i] = ((max_burst[((K + (K * i)) - 1):(K * i)] == 0) ? 1'b1 : 1'b0) ; 
        end
    endgenerate
    //------------------------------------------------------------------------------
    // Combinatorial Blocks
    //------------------------------------------------------------------------------
    always
        @(*)
        begin
            ns_sm = cs_sm ;
            case (1)
            (cs_sm == ST_IDLE) : 
                begin
                    // Maximum burst count is reached for the current master
                    if (apb_arb_en_i) 
                        begin
                            ns_sm = ST_ACTIVE ;
                        end
                end
            (cs_sm == ST_ACTIVE) : 
                begin
                    if (apb_ack_i) 
                        begin
                            ns_sm = ST_IDLE ;
                        end
                end
            default : 
                begin
                    ns_sm = ST_IDLE ;
                end
            endcase // case (cs_sm)
        end
    //------------------------------------------------------------------------------
    // Sequential Blocks
    //------------------------------------------------------------------------------
    //integer k;
    //always @(posedge apb_pclk_i or negedge apb_presetn_i) begin
    //  if (!apb_presetn_i) begin
    //    run_cnt <= {K{1'b1}};
    //  end
    //  else begin
    //    if (apb_ack_i) begin
    //      run_cnt <= {K{1'b1}};
    //    end
    //    else if (arb_en_Q) begin
    //      for (k = 0; k < M; k = k + 1) begin
    //        if (apb_gnt_o[k] == 1'b1) begin
    //          run_cnt <= apb_adv_cnt_i
    //                     ? {K{1'b0}} | (max_burst >> K*k) - BURST_SZ
    //                     : {K{1'b0}} | (max_burst >> K*k);
    //        end
    //      end
    //    end
    //    else begin
    //      run_cnt <= apb_adv_cnt_i && |run_cnt ? (run_cnt - BURST_SZ) : run_cnt;
    //    end
    //  end
    //end
    always
        @(posedge apb_pclk_i or 
            negedge apb_presetn_i)
        begin
            if ((!apb_presetn_i)) 
                begin
                    arb_en_Q <=  1'b0 ;
                end
            else
                begin
                    arb_en_Q <=  apb_arb_en_i ;
                end
        end
    always
        @(posedge apb_pclk_i or 
            negedge apb_presetn_i)
        begin
            if ((!apb_presetn_i)) 
                begin
                    cs_sm <=  ST_IDLE ;
                end
            else
                begin
                    cs_sm <=  ns_sm ;
                end
        end
    // ------------------------------------------------------------------------------
    // Round-Robin Arbitration Scheme
    // ------------------------------------------------------------------------------
    generate
        if ((ARBITER_SCHEME == 3'b0)) 
            begin : genblk2
                // --------------------------------------------------------------------------
                // Register Declarations
                // --------------------------------------------------------------------------
                reg [(M - 1):0] req_masked ; 
                reg [(M - 1):0] prev_gnt ; 
                // --------------------------------------------------------------------------
                // Wire Declarations
                // --------------------------------------------------------------------------
                wire [(M - 1):0] gnt_masked ; 
                wire [(M - 1):0] gnt_unmasked ; 
                wire [(M - 1):0] mask ; 
                // --------------------------------------------------------------------------
                // Assign Statements
                // --------------------------------------------------------------------------
                for (i = 0;(i < M);i = (i + 1))
                begin : genblk1
                    assign req_in[i] = (apb_req_i[i] && (~req_mask[i])) ; 
                end
                // --------------------------------------------------------------------------
                // Combinatorial Block
                // --------------------------------------------------------------------------
                always
                    @(*)
                    begin
                        req_masked = (req_in & mask) ;
                    end
                // --------------------------------------------------------------------------
                // Sequential Block
                // --------------------------------------------------------------------------
                always
                    @(posedge apb_pclk_i or 
                        negedge apb_presetn_i)
                    begin
                        if ((!apb_presetn_i)) 
                            begin
                                apb_gnt_o <=  0 ;
                                prev_gnt <=  0 ;
                            end
                        else
                            begin
                                if (apb_ack_i) 
                                    begin
                                        apb_gnt_o <=  {M{1'b0}} ;
                                    end
                                else
                                    begin
                                        if (apb_arb_en_i) 
                                            begin
                                                apb_gnt_o <=  ((gnt_masked == {M{1'b0}}) ? gnt_unmasked : gnt_masked) ;
                                            end
                                    end
                                prev_gnt <=  (arb_en_Q ? apb_gnt_o : prev_gnt) ;
                            end
                    end
                // --------------------------------------------------------------------------
                // Submodule Instantiations
                // --------------------------------------------------------------------------
                // -----------------
                // Unmasked Grant
                // -----------------
                apb0_ipgen_lscc_apb_prio_arb #(.M(M)) u_lscc_apb_rr_gnt_unmasked (//AUTOINSTPARAM*/
                        // Parameters
                        //AUTOINST*/
                        // Outputs
                        .gnt_o(gnt_unmasked[(M - 1):0]), 
                            // Inputs
                        .req_i(req_in[(M - 1):0])) ; 
                // -----------------
                // Masked Grant
                // -----------------
                apb0_ipgen_lscc_apb_prio_arb #(.M(M)) u_lscc_apb_rr_gnt_masked (//AUTOINSTPARAM*/
                        // Parameters
                        //AUTOINST*/
                        // Outputs
                        .gnt_o(gnt_masked[(M - 1):0]), 
                            // Inputs
                        .req_i(req_masked[(M - 1):0])) ; 
                // -----------------
                // Mask Generation
                // -----------------
                apb0_ipgen_lscc_apb_thermo_mask #(.M(M)) u_lscc_apb_rr_mask (//AUTOINSTPARAM*/c
                        // Parameters
                        //AUTOINST*/
                        // Outputs
                        .mask_o(mask[(M - 1):0]), 
                            // Inputs
                        .vector_i(prev_gnt[(M - 1):0])) ; 
            end
    endgenerate
    // ------------------------------------------------------------------------------
    // Fixed Priority Arbitration Scheme
    // ------------------------------------------------------------------------------
    generate
        if ((ARBITER_SCHEME == 3'b1)) 
            begin : genblk3
                // --------------------------------------------------------------------------
                // Wire Declarations
                // --------------------------------------------------------------------------
                wire [(M - 1):0] gnt ; 
                wire valid = (|req_in) ; 
                // --------------------------------------------------------------------------
                // Assign Statements
                // --------------------------------------------------------------------------
                for (i = 0;(i < M);i = (i + 1))
                begin : genblk1
                    assign req_in[M_PRIO_IDX[((PW + (PW * i)) - 1):(PW * i)]] = (apb_req_i[i] && (~req_mask[i])) ; 
                end
                // --------------------------------------------------------------------------
                // Sequential Blocks
                // --------------------------------------------------------------------------
                always
                    @(posedge apb_pclk_i or 
                        negedge apb_presetn_i)
                    begin
                        if ((!apb_presetn_i)) 
                            begin
                                apb_gnt_o <=  {M{1'b0}} ;
                            end
                        else
                            begin
                                if (apb_ack_i) 
                                    begin
                                        apb_gnt_o <=  {M{1'b0}} ;
                                    end
                                if (apb_arb_en_i) 
                                    begin
                                        apb_gnt_o <=  (valid ? gnt : apb_gnt_o) ;
                                    end
                            end
                    end
                // --------------------------------------------------------------------------
                // Submodule Instantiations
                // --------------------------------------------------------------------------
                // -----------------
                // Priority Arbiter
                // -----------------
                apb0_ipgen_lscc_apb_prio_arb #(.M(M)) u_lscc_apb_fp_gnt (//AUTOINSTPARAM*/
                        // Parameters
                        //AUTOINST*/
                        // Outputs
                        .gnt_o(gnt[(M - 1):0]), 
                            // Inputs
                        .req_i(req_in[(M - 1):0])) ; 
            end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function integer clog2( 
        input integer depth )  ; 
        begin
            for (clog2 = 0 ; (depth > 0) ; clog2 = (clog2 + 1))
                depth = (depth >> 1) ;
        end
    endfunction

// lscc_apb_arbiter
endmodule



`timescale 1ns/1ps
//===============================================================================
// lscc_apb_arbiter.v
// Local Variables:
// verilog-library-directories:(".")
// End:
//===============================================================================
// ==============================================================================
// AHB-Lite Priority Arbiter
// ==============================================================================
module apb0_ipgen_lscc_apb_prio_arb #(parameter M = 32) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input [(M - 1):0] req_i, 
    output reg [(M - 1):0] gnt_o) ;
    // ------------------------------------------------------------------------------
    // Combinatorial Block
    // ------------------------------------------------------------------------------
    always
        @(*)
        begin
            gnt_o = (req_i & (-req_i)) ;
        end
endmodule



`timescale 1ns/1ps
//==============================================================================
// lscc_apb_prio_arb.v
//==============================================================================
// ==============================================================================
// AHB-Lite Thermometer Mask
// ==============================================================================
module apb0_ipgen_lscc_apb_thermo_mask #(parameter M = 32) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input [(M - 1):0] vector_i, 
    output reg [(M - 1):0] mask_o) ;
    // ------------------------------------------------------------------------------
    // Combinatorial Block
    // ------------------------------------------------------------------------------
    always
        @(*)
        begin
            // Outputs 1 at the first set bit and all less significant (leftmost) bits.
            // Outputs 0 for all more significant (rightmost) bits.
            // Outputs all 1's if no bit set.
            mask_o = (vector_i ^ (vector_i - 1)) ;
            // Invert mask to instead mask-off the set bit and the less significant bits
            // Don't invert mask if no bit set (don't want an all-zero mask)
            mask_o = ((vector_i == {M{1'b0}}) ? mask_o : (~mask_o)) ;
            // Re-add set bit, so it and the more significant (rightmost) bits pass.
            // mask_o = op_1 | vector_i;
        end
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_arbmux.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_arbmux #(parameter K = 32, 
        parameter TOTAL_MASTER_CNT = 8, 
        parameter M_ADDR_WIDTH = 32, 
        parameter M_PRIO_WIDTH = clog2(TOTAL_MASTER_CNT), 
        parameter DATA_WIDTH = 32, 
        parameter OUTREG_EN = 0, 
        parameter [((TOTAL_MASTER_CNT * M_PRIO_WIDTH) - 1):0] S_M_PRIO_IDX = {3'd7,
                3'd6,
                3'd5,
                3'd4,
                3'd3,
                3'd2,
                3'd1,
                3'd0}, 
        parameter [2:0] S_ARBITER_SCHEME = 3'b0, 
        parameter [((TOTAL_MASTER_CNT * K) - 1):0] S_MAX_BURST_CNT = {32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32}) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input apb_pclk_i, 
    input apb_presetn_i, 
    // -------------------------------------------
    // APB Master Interface (to/from master)
    // -------------------------------------------
    input [(TOTAL_MASTER_CNT - 1):0] apb_psel_slv_i, 
    input [((TOTAL_MASTER_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_slv_i, 
    input [((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0] apb_pwdata_slv_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_pwrite_slv_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_penable_slv_i, 
    output reg [(TOTAL_MASTER_CNT - 1):0] apb_pready_slv_o, 
    output reg [(TOTAL_MASTER_CNT - 1):0] apb_pslverr_slv_o, 
    output reg [((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0] apb_prdata_slv_o, 
    // -----------------------------------------
    // APB Slave Interface (to/from slave)
    // -----------------------------------------
    output reg apb_psel_mstr_o, 
    output reg [(M_ADDR_WIDTH - 1):0] apb_paddr_mstr_o, 
    output reg [(DATA_WIDTH - 1):0] apb_pwdata_mstr_o, 
    output reg apb_pwrite_mstr_o, 
    output reg apb_penable_mstr_o, 
    input apb_pready_mstr_i, 
    input apb_pslverr_mstr_i, 
    input [(DATA_WIDTH - 1):0] apb_prdata_mstr_i) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam ST_WIDTH = 4 ; 
    localparam ST_IDLE = 5'b00001 ; 
    localparam ST_REQ = 5'b00010 ; 
    localparam ST_ENABLE = 5'b00100 ; 
    localparam ST_ACTIVE = 5'b01000 ; 
    localparam SEL_WIDTH = clog2(TOTAL_MASTER_CNT) ; 
    // ------------------------------------------------------------------------------
    // Register Declarations
    // ------------------------------------------------------------------------------
    reg [(ST_WIDTH - 1):0] cs_sm ; 
    reg [(ST_WIDTH - 1):0] ns_sm ; 
    reg arb_en ; 
    reg arb_swap ; 
    reg arb_pready ; 
    reg gnt_psel ; 
    reg gnt_psel_Q ; 
    reg [(M_ADDR_WIDTH - 1):0] gnt_paddr ; 
    reg [(DATA_WIDTH - 1):0] gnt_pwdata ; 
    reg gnt_pwrite ; 
    reg gnt_penable ; 
    reg [(SEL_WIDTH - 1):0] sel ; 
    reg adv_cnt ; 
    reg ack ; 
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire [(TOTAL_MASTER_CNT - 1):0] gnt_w ; 
    wire gnt_psel_done ; 
    wire [(DATA_WIDTH - 1):0] gnt_prdata ; 
    wire gnt_pready ; 
    wire gnt_pslverr ; 
    wire [(TOTAL_MASTER_CNT - 1):0] req_in ; 
    wire [(TOTAL_MASTER_CNT - 1):0] req_mask ; 
    wire [((TOTAL_MASTER_CNT * K) - 1):0] max_burst = S_MAX_BURST_CNT ; 
    //wire                                           max_reached;
    // ------------------------------------------------------------------------------
    // Assign Statements
    // ------------------------------------------------------------------------------
    assign gnt_psel_done = ((~gnt_psel) && gnt_psel_Q) ; 
    assign gnt_prdata = apb_prdata_mstr_i ; 
    assign gnt_pready = apb_pready_mstr_i ; 
    assign gnt_pslverr = apb_pslverr_mstr_i ; 
    // ------------------------------------------------------------------------------
    // Generate Blocks
    // ------------------------------------------------------------------------------
    genvar j ; 
    generate
        for (j = 0;(j < TOTAL_MASTER_CNT);j = (j + 1))
        begin : genblk1
            assign req_mask[j] = ((max_burst[((K + (K * j)) - 1):(K * j)] == 0) ? 1'b1 : 1'b0) ; 
            assign req_in[j] = (apb_psel_slv_i[j] && (~req_mask[j])) ; 
        end
    endgenerate
    // ------------------------------------------------------------------------------
    // Combinatorial Block
    // ------------------------------------------------------------------------------
    integer i ; 
    // -----------
    // To Slave
    // -----------
    always
        @(*)
        begin
            //    gnt_psel    = 0;
            //    gnt_paddr   = 0;
            //    gnt_pwdata  = 0;
            //    gnt_pwrite  = 0;
            //    gnt_penable = 0;
            sel = 0 ;
            for (i = 0 ; (i < TOTAL_MASTER_CNT) ; i = (i + 1))
                begin
                    if ((gnt_w == (1 << i))) 
                        begin
                            sel = i ;
                        end
                end
            gnt_psel = apb_psel_slv_i[sel] ;
            gnt_paddr = apb_paddr_slv_i[(M_ADDR_WIDTH * sel) +: M_ADDR_WIDTH] ;
            gnt_pwdata = apb_pwdata_slv_i[(DATA_WIDTH * sel) +: DATA_WIDTH] ;
            gnt_pwrite = apb_pwrite_slv_i[sel] ;
            gnt_penable = apb_penable_slv_i[sel] ;
        end
    generate
        if ((OUTREG_EN == 0)) 
            begin : outreg_mstr_off
                always
                    @(*)
                    begin
                        apb_psel_mstr_o = (arb_swap ? (|gnt_w) : gnt_psel) ;
                        apb_paddr_mstr_o = gnt_paddr ;
                        apb_pwdata_mstr_o = gnt_pwdata ;
                        apb_pwrite_mstr_o = gnt_pwrite ;
                        apb_penable_mstr_o = (arb_swap ? 1'b0 : gnt_penable) ;
                    end
            end
        else
            begin : outreg_mstr_on
                always
                    @(posedge apb_pclk_i or 
                        negedge apb_presetn_i)
                    begin
                        if ((!apb_presetn_i)) 
                            begin
                                apb_psel_mstr_o <=  0 ;
                                apb_paddr_mstr_o <=  0 ;
                                apb_pwdata_mstr_o <=  0 ;
                                apb_pwrite_mstr_o <=  0 ;
                                apb_penable_mstr_o <=  0 ;
                            end
                        else
                            begin
                                apb_psel_mstr_o <=  (arb_swap ? (|gnt_w) : gnt_psel) ;
                                apb_paddr_mstr_o <=  gnt_paddr ;
                                apb_pwdata_mstr_o <=  gnt_pwdata ;
                                apb_pwrite_mstr_o <=  gnt_pwrite ;
                                apb_penable_mstr_o <=  (arb_swap ? 1'b0 : gnt_penable) ;
                            end
                    end
            end
    endgenerate
    // -----------
    // To Master
    // -----------
    generate
        if ((OUTREG_EN == 0)) 
            begin : outreg_slv_off
                always
                    @(*)
                    begin
                        for (i = 0 ; (i < TOTAL_MASTER_CNT) ; i = (i + 1))
                            begin
                                apb_prdata_slv_o[(DATA_WIDTH * i) +: DATA_WIDTH] = 0 ;
                                apb_pready_slv_o[i] = 0 ;
                                apb_pslverr_slv_o[i] = 0 ;
                                if (gnt_w[i]) 
                                    begin
                                        apb_prdata_slv_o[(DATA_WIDTH * i) +: DATA_WIDTH] = gnt_prdata ;
                                        apb_pready_slv_o[i] = (arb_swap ? arb_pready : gnt_pready) ;
                                        apb_pslverr_slv_o[i] = gnt_pslverr ;
                                    end
                            end
                    end
            end
        else
            begin : outreg_slv_on
                always
                    @(posedge apb_pclk_i or 
                        negedge apb_presetn_i)
                    begin
                        if ((!apb_presetn_i)) 
                            begin
                                apb_prdata_slv_o <=  0 ;
                                apb_pready_slv_o <=  0 ;
                                apb_pslverr_slv_o <=  0 ;
                            end
                        else
                            begin
                                for (i = 0 ; (i < TOTAL_MASTER_CNT) ; i = (i + 1))
                                    begin
                                        apb_prdata_slv_o[(DATA_WIDTH * i) +: DATA_WIDTH] <=  0 ;
                                        apb_pready_slv_o[i] <=  0 ;
                                        apb_pslverr_slv_o[i] <=  0 ;
                                        if (gnt_w[i]) 
                                            begin
                                                apb_prdata_slv_o[(DATA_WIDTH * i) +: DATA_WIDTH] <=  gnt_prdata ;
                                                apb_pready_slv_o[i] <=  (arb_swap ? arb_pready : gnt_pready) ;
                                                apb_pslverr_slv_o[i] <=  gnt_pslverr ;
                                            end
                                    end
                            end
                    end
            end
    endgenerate
    /* -----\/----- EXCLUDED -----\/-----
always @* begin

  ns_sm  = cs_sm;
  arb_en = 1'b0;
  
  case (cs_sm)
    ST_IDLE: begin
      if (|apb_psel_slv_i) begin
        arb_en  = 1'b1;
        ns_sm   = ST_ARB;
      end      
    end
    ST_ARB: begin
      if (|gnt_w) begin
        ns_sm  = ST_GNT;
      end
    end
    ST_GNT: begin
      if (gnt_pready) begin
        if (|apb_psel_slv_i) begin
          arb_en = 1'b1;
          ns_sm = ST_ARB;
        end
        else begin
          ns_sm = ST_IDLE;
        end
      end
    end
    default: begin
      ns_sm = ST_IDLE;
    end    
  endcase // case (1)
 -----/\----- EXCLUDED -----/\----- */
    // ------------------------------------------------------------------------------
    // Combinatorial Blocks
    // ------------------------------------------------------------------------------
    always
        @(*)
        begin
            ns_sm = cs_sm ;
            arb_en = 1'b0 ;
            adv_cnt = 1'b0 ;
            ack = 1'b0 ;
            arb_pready = 1'b1 ;
            arb_swap = 1'b0 ;
            case (1)
            (cs_sm == ST_IDLE) : 
                begin
                    if ((|req_in)) 
                        begin
                            // mask psel going to slave during request phase
                            arb_swap = 1'b1 ;
                            arb_en = 1'b1 ;
                            ns_sm = ST_REQ ;
                        end
                end
            (cs_sm == ST_REQ) : 
                begin
                    // send psel to slave after grant is given to master
                    if ((|gnt_w)) 
                        begin
                            arb_pready = 1'b0 ;
                            arb_swap = 1'b1 ;
                            ns_sm = ST_ENABLE ;
                        end
                end
            (cs_sm == ST_ENABLE) : 
                begin
                    // wait for slave to issue pready
                    if ((gnt_penable && gnt_pready)) 
                        begin
                            ns_sm = ST_ACTIVE ;
                        end
                end
            (cs_sm == ST_ACTIVE) : 
                begin
                    // proceed with normal apb transaction
                    adv_cnt = gnt_penable ;
                    //      if (max_reached || gnt_psel_done) begin
                    if (gnt_psel_done) 
                        begin
                            ack = 1'b1 ;
                            ns_sm = ST_IDLE ;
                        end
                end
            default : 
                begin
                    ns_sm = ST_IDLE ;
                end
            endcase // case (1)
        end
    // ------------------------------------------------------------------------------
    // Sequential Block
    // ------------------------------------------------------------------------------
    always
        @(posedge apb_pclk_i or 
            negedge apb_presetn_i)
        begin
            if ((!apb_presetn_i)) 
                begin
                    cs_sm <=  ST_IDLE ;
                end
            else
                begin
                    cs_sm <=  ns_sm ;
                end
        end
    always
        @(posedge apb_pclk_i or 
            negedge apb_presetn_i)
        begin
            if ((!apb_presetn_i)) 
                begin
                    gnt_psel_Q <=  1'b0 ;
                end
            else
                begin
                    gnt_psel_Q <=  gnt_psel ;
                end
        end
    // ------------------------------------------------------------------------------
    // Submodule Instantiation(s)
    // ------------------------------------------------------------------------------
    // -----------------------------
    // APB Arbiter-Multiplexor
    // -----------------------------
    apb0_ipgen_lscc_apb_arbiter #(.K(K),
            .TOTAL_MASTER_CNT(TOTAL_MASTER_CNT),
            .DATA_WIDTH(DATA_WIDTH),
            .M_PRIO_IDX(S_M_PRIO_IDX),
            .ARBITER_SCHEME(S_ARBITER_SCHEME),
            .MAX_BURST_CNT(S_MAX_BURST_CNT)) u_lscc_apb_arbiter (/*AUTOINSTPARAM*/ // Parameters
            /*AUTOINST*/ // Outputs
            .apb_gnt_o(gnt_w[(TOTAL_MASTER_CNT - 1):0]), 
                //   .apb_max_reached_o                   (max_reached),
            // Inputs
            .apb_pclk_i(apb_pclk_i), 
                .apb_presetn_i(apb_presetn_i), 
                .apb_arb_en_i(arb_en), 
                .apb_ack_i(ack), 
                .apb_req_i(apb_psel_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                .apb_adv_cnt_i(adv_cnt)) ; 
    // ------------------------------------------------------------------------------
    // Function Definition
    // ------------------------------------------------------------------------------
    function integer clog2( 
        input integer depth )  ; 
        begin
            for (clog2 = 0 ; (depth > 0) ; clog2 = (clog2 + 1))
                depth = (depth >> 1) ;
        end
    endfunction
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_bus.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_bus #(parameter K = 32, 
        parameter F = 8, 
        parameter M_ADDR_WIDTH = 32, 
        parameter FULL_DECODE_EN = 1, 
        parameter DATA_WIDTH = 32, 
        parameter TOTAL_SLAVE_CNT = 32, 
        parameter SHARED_PORT = 0, 
        parameter OUTREG_EN = 0, 
        parameter [((F * K) - 1):0] S0_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S0_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S1_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S1_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S2_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S2_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S3_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S3_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S4_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S4_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S5_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S5_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S6_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S6_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S7_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S7_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S8_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S8_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S9_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S9_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S10_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S10_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S11_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S11_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S12_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S12_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S13_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S13_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S14_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S14_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S15_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S15_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S16_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S16_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S17_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S17_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S18_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S18_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S19_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S19_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S20_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S20_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S21_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S21_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S22_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S22_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S23_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S23_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S24_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S24_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S25_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S25_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S26_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S26_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S27_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S27_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S28_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S28_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S29_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S29_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S30_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S30_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S31_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S31_ADDR_RANGE = {32'h400}) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input apb_pclk_i, 
    input apb_presetn_i, 
    // ----------------------------------------
    // APB Master Interface (to/from master)
    // ----------------------------------------
    input apb_psel_slv_i, 
    input [(M_ADDR_WIDTH - 1):0] apb_paddr_slv_i, 
    input [(DATA_WIDTH - 1):0] apb_pwdata_slv_i, 
    input apb_pwrite_slv_i, 
    input apb_penable_slv_i, 
    output wire apb_pready_slv_o, 
    output wire apb_pslverr_slv_o, 
    output wire [(DATA_WIDTH - 1):0] apb_prdata_slv_o, 
    // -----------------------------------------
    // APB Slave Interface (to/from slave)
    // -----------------------------------------
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_psel_mstr_o, 
    output wire [((TOTAL_SLAVE_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_mstr_o, 
    output wire [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_pwdata_mstr_o, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_pwrite_mstr_o, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_penable_mstr_o, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pready_mstr_i, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pslverr_mstr_i, 
    input [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_prdata_mstr_i) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam S0_FRAGMENT_EN = 4'd1 ; 
    localparam S1_FRAGMENT_EN = 4'd1 ; 
    localparam S2_FRAGMENT_EN = 4'd1 ; 
    localparam S3_FRAGMENT_EN = 4'd1 ; 
    localparam S4_FRAGMENT_EN = 4'd1 ; 
    localparam S5_FRAGMENT_EN = 4'd1 ; 
    localparam S6_FRAGMENT_EN = 4'd1 ; 
    localparam S7_FRAGMENT_EN = 4'd1 ; 
    localparam S8_FRAGMENT_EN = 4'd1 ; 
    localparam S9_FRAGMENT_EN = 4'd1 ; 
    localparam S10_FRAGMENT_EN = 4'd1 ; 
    localparam S11_FRAGMENT_EN = 4'd1 ; 
    localparam S12_FRAGMENT_EN = 4'd1 ; 
    localparam S13_FRAGMENT_EN = 4'd1 ; 
    localparam S14_FRAGMENT_EN = 4'd1 ; 
    localparam S15_FRAGMENT_EN = 4'd1 ; 
    localparam S16_FRAGMENT_EN = 4'd1 ; 
    localparam S17_FRAGMENT_EN = 4'd1 ; 
    localparam S18_FRAGMENT_EN = 4'd1 ; 
    localparam S19_FRAGMENT_EN = 4'd1 ; 
    localparam S20_FRAGMENT_EN = 4'd1 ; 
    localparam S21_FRAGMENT_EN = 4'd1 ; 
    localparam S22_FRAGMENT_EN = 4'd1 ; 
    localparam S23_FRAGMENT_EN = 4'd1 ; 
    localparam S24_FRAGMENT_EN = 4'd1 ; 
    localparam S25_FRAGMENT_EN = 4'd1 ; 
    localparam S26_FRAGMENT_EN = 4'd1 ; 
    localparam S27_FRAGMENT_EN = 4'd1 ; 
    localparam S28_FRAGMENT_EN = 4'd1 ; 
    localparam S29_FRAGMENT_EN = 4'd1 ; 
    localparam S30_FRAGMENT_EN = 4'd1 ; 
    localparam S31_FRAGMENT_EN = 4'd1 ; 
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire [(TOTAL_SLAVE_CNT - 1):0] apb_psel_dec_w ; 
    wire [(DATA_WIDTH - 1):0] apb_prdata_def_mstr_w ; 
    // ------------------------------------------------------------------------------
    // Submodule Instantiations
    // ------------------------------------------------------------------------------
    // -----------------
    // APB Decoder
    // -----------------
    apb0_ipgen_lscc_apb_decoder #(.K(K),
            .F(F),
            .M_ADDR_WIDTH(M_ADDR_WIDTH),
            .FULL_DECODE_EN(FULL_DECODE_EN),
            .TOTAL_SLAVE_CNT(TOTAL_SLAVE_CNT),
            .S0_FRAGMENT_EN(S0_FRAGMENT_EN),
            .S0_BASE_ADDR(S0_BASE_ADDR),
            .S0_ADDR_RANGE(S0_ADDR_RANGE),
            .S1_FRAGMENT_EN(S1_FRAGMENT_EN),
            .S1_BASE_ADDR(S1_BASE_ADDR),
            .S1_ADDR_RANGE(S1_ADDR_RANGE),
            .S2_FRAGMENT_EN(S2_FRAGMENT_EN),
            .S2_BASE_ADDR(S2_BASE_ADDR),
            .S2_ADDR_RANGE(S2_ADDR_RANGE),
            .S3_FRAGMENT_EN(S3_FRAGMENT_EN),
            .S3_BASE_ADDR(S3_BASE_ADDR),
            .S3_ADDR_RANGE(S3_ADDR_RANGE),
            .S4_FRAGMENT_EN(S4_FRAGMENT_EN),
            .S4_BASE_ADDR(S4_BASE_ADDR),
            .S4_ADDR_RANGE(S4_ADDR_RANGE),
            .S5_FRAGMENT_EN(S5_FRAGMENT_EN),
            .S5_BASE_ADDR(S5_BASE_ADDR),
            .S5_ADDR_RANGE(S5_ADDR_RANGE),
            .S6_FRAGMENT_EN(S6_FRAGMENT_EN),
            .S6_BASE_ADDR(S6_BASE_ADDR),
            .S6_ADDR_RANGE(S6_ADDR_RANGE),
            .S7_FRAGMENT_EN(S7_FRAGMENT_EN),
            .S7_BASE_ADDR(S7_BASE_ADDR),
            .S7_ADDR_RANGE(S7_ADDR_RANGE),
            .S8_FRAGMENT_EN(S8_FRAGMENT_EN),
            .S8_BASE_ADDR(S8_BASE_ADDR),
            .S8_ADDR_RANGE(S8_ADDR_RANGE),
            .S9_FRAGMENT_EN(S9_FRAGMENT_EN),
            .S9_BASE_ADDR(S9_BASE_ADDR),
            .S9_ADDR_RANGE(S9_ADDR_RANGE),
            .S10_FRAGMENT_EN(S10_FRAGMENT_EN),
            .S10_BASE_ADDR(S10_BASE_ADDR),
            .S10_ADDR_RANGE(S10_ADDR_RANGE),
            .S11_FRAGMENT_EN(S11_FRAGMENT_EN),
            .S11_BASE_ADDR(S11_BASE_ADDR),
            .S11_ADDR_RANGE(S11_ADDR_RANGE),
            .S12_FRAGMENT_EN(S12_FRAGMENT_EN),
            .S12_BASE_ADDR(S12_BASE_ADDR),
            .S12_ADDR_RANGE(S12_ADDR_RANGE),
            .S13_FRAGMENT_EN(S13_FRAGMENT_EN),
            .S13_BASE_ADDR(S13_BASE_ADDR),
            .S13_ADDR_RANGE(S13_ADDR_RANGE),
            .S14_FRAGMENT_EN(S14_FRAGMENT_EN),
            .S14_BASE_ADDR(S14_BASE_ADDR),
            .S14_ADDR_RANGE(S14_ADDR_RANGE),
            .S15_FRAGMENT_EN(S15_FRAGMENT_EN),
            .S15_BASE_ADDR(S15_BASE_ADDR),
            .S15_ADDR_RANGE(S15_ADDR_RANGE),
            .S16_FRAGMENT_EN(S16_FRAGMENT_EN),
            .S16_BASE_ADDR(S16_BASE_ADDR),
            .S16_ADDR_RANGE(S16_ADDR_RANGE),
            .S17_FRAGMENT_EN(S17_FRAGMENT_EN),
            .S17_BASE_ADDR(S17_BASE_ADDR),
            .S17_ADDR_RANGE(S17_ADDR_RANGE),
            .S18_FRAGMENT_EN(S18_FRAGMENT_EN),
            .S18_BASE_ADDR(S18_BASE_ADDR),
            .S18_ADDR_RANGE(S18_ADDR_RANGE),
            .S19_FRAGMENT_EN(S19_FRAGMENT_EN),
            .S19_BASE_ADDR(S19_BASE_ADDR),
            .S19_ADDR_RANGE(S19_ADDR_RANGE),
            .S20_FRAGMENT_EN(S20_FRAGMENT_EN),
            .S20_BASE_ADDR(S20_BASE_ADDR),
            .S20_ADDR_RANGE(S20_ADDR_RANGE),
            .S21_FRAGMENT_EN(S21_FRAGMENT_EN),
            .S21_BASE_ADDR(S21_BASE_ADDR),
            .S21_ADDR_RANGE(S21_ADDR_RANGE),
            .S22_FRAGMENT_EN(S22_FRAGMENT_EN),
            .S22_BASE_ADDR(S22_BASE_ADDR),
            .S22_ADDR_RANGE(S22_ADDR_RANGE),
            .S23_FRAGMENT_EN(S23_FRAGMENT_EN),
            .S23_BASE_ADDR(S23_BASE_ADDR),
            .S23_ADDR_RANGE(S23_ADDR_RANGE),
            .S24_FRAGMENT_EN(S24_FRAGMENT_EN),
            .S24_BASE_ADDR(S24_BASE_ADDR),
            .S24_ADDR_RANGE(S24_ADDR_RANGE),
            .S25_FRAGMENT_EN(S25_FRAGMENT_EN),
            .S25_BASE_ADDR(S25_BASE_ADDR),
            .S25_ADDR_RANGE(S25_ADDR_RANGE),
            .S26_FRAGMENT_EN(S26_FRAGMENT_EN),
            .S26_BASE_ADDR(S26_BASE_ADDR),
            .S26_ADDR_RANGE(S26_ADDR_RANGE),
            .S27_FRAGMENT_EN(S27_FRAGMENT_EN),
            .S27_BASE_ADDR(S27_BASE_ADDR),
            .S27_ADDR_RANGE(S27_ADDR_RANGE),
            .S28_FRAGMENT_EN(S28_FRAGMENT_EN),
            .S28_BASE_ADDR(S28_BASE_ADDR),
            .S28_ADDR_RANGE(S28_ADDR_RANGE),
            .S29_FRAGMENT_EN(S29_FRAGMENT_EN),
            .S29_BASE_ADDR(S29_BASE_ADDR),
            .S29_ADDR_RANGE(S29_ADDR_RANGE),
            .S30_FRAGMENT_EN(S30_FRAGMENT_EN),
            .S30_BASE_ADDR(S30_BASE_ADDR),
            .S30_ADDR_RANGE(S30_ADDR_RANGE),
            .S31_FRAGMENT_EN(S31_FRAGMENT_EN),
            .S31_BASE_ADDR(S31_BASE_ADDR),
            .S31_ADDR_RANGE(S31_ADDR_RANGE)) u_lscc_apb_decoder (//AUTOINSTPARAM*/
            // Parameters
            //AUTOINST*/
            // Outputs
            .apb_psel_o(apb_psel_dec_w[(TOTAL_SLAVE_CNT - 1):0]), 
                .apb_psel_def_o(apb_psel_def_mstr_w), 
                // Inputs
            .enable_i(apb_psel_slv_i), 
                .apb_paddr_i(apb_paddr_slv_i[(M_ADDR_WIDTH - 1):10])) ; 
    // ---------------------
    // APB Multiplexor
    // ---------------------
    apb0_ipgen_lscc_apb_multiplexor #(.K(K),
            .M_ADDR_WIDTH(M_ADDR_WIDTH),
            .DATA_WIDTH(DATA_WIDTH),
            .TOTAL_SLAVE_CNT(TOTAL_SLAVE_CNT),
            .OUTREG_EN(OUTREG_EN)) u_lscc_apb_multiplexor (//AUTOINSTPARAM*/
            // Parameters
            //AUTOINST*/
            // Outputs
            .apb_pready_slv_o(apb_pready_slv_o), 
                .apb_pslverr_slv_o(apb_pslverr_slv_o), 
                .apb_prdata_slv_o(apb_prdata_slv_o), 
                .apb_psel_mstr_o(apb_psel_mstr_o), 
                .apb_paddr_mstr_o(apb_paddr_mstr_o), 
                .apb_pwdata_mstr_o(apb_pwdata_mstr_o), 
                .apb_pwrite_mstr_o(apb_pwrite_mstr_o), 
                .apb_penable_mstr_o(apb_penable_mstr_o), 
                // Inputs
            .apb_pclk_i(apb_pclk_i), 
                .apb_presetn_i(apb_presetn_i), 
                .apb_psel_dec_i(apb_psel_dec_w[(TOTAL_SLAVE_CNT - 1):0]), 
                .apb_psel_slv_i(apb_psel_slv_i), 
                .apb_paddr_slv_i(apb_paddr_slv_i), 
                .apb_pwdata_slv_i(apb_pwdata_slv_i), 
                .apb_pwrite_slv_i(apb_pwrite_slv_i), 
                .apb_penable_slv_i(apb_penable_slv_i), 
                .apb_pready_mstr_i(apb_pready_mstr_i), 
                .apb_pslverr_mstr_i(apb_pslverr_mstr_i), 
                .apb_prdata_mstr_i(apb_prdata_mstr_i), 
                .apb_psel_def_mstr_i(apb_psel_def_mstr_w)) ; 
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_crossbar.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_crossbar #(parameter K = 32, 
        parameter F = 1, 
        parameter TOTAL_MASTER_CNT = 8, 
        parameter TOTAL_SLAVE_CNT = 8, 
        parameter M_ADDR_WIDTH = 32, 
        parameter FULL_DECODE_EN = 1, 
        parameter M_PRIO_WIDTH = clog2(TOTAL_MASTER_CNT), 
        parameter DATA_WIDTH = 32, 
        parameter OUTREG_EN = 0, 
        parameter [((TOTAL_MASTER_CNT * M_PRIO_WIDTH) - 1):0] S_M_PRIO_IDX = {3'd7,
                3'd6,
                3'd5,
                3'd4,
                3'd3,
                3'd2,
                3'd1,
                3'd0}, 
        parameter [2:0] S_ARBITER_SCHEME = 3'b0, 
        parameter [((TOTAL_MASTER_CNT * K) - 1):0] S_MAX_BURST_CNT = {32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32,
                32'd32}, 
        parameter [((F * K) - 1):0] S0_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S0_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S1_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S1_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S2_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S2_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S3_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S3_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S4_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S4_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S5_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S5_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S6_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S6_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S7_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S7_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S8_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S8_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S9_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S9_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S10_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S10_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S11_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S11_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S12_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S12_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S13_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S13_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S14_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S14_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S15_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S15_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S16_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S16_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S17_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S17_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S18_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S18_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S19_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S19_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S20_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S20_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S21_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S21_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S22_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S22_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S23_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S23_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S24_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S24_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S25_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S25_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S26_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S26_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S27_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S27_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S28_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S28_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S29_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S29_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S30_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S30_ADDR_RANGE = {32'h400}, 
        parameter [((F * K) - 1):0] S31_BASE_ADDR = {32'h0}, 
        parameter [((F * K) - 1):0] S31_ADDR_RANGE = {32'h400}) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input apb_pclk_i, 
    input apb_presetn_i, 
    // -------------------------------------------
    // APB Master Interface (to/from master)
    // -------------------------------------------
    input [(TOTAL_MASTER_CNT - 1):0] apb_psel_slv_i, 
    input [((TOTAL_MASTER_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_slv_i, 
    input [((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0] apb_pwdata_slv_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_pwrite_slv_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_penable_slv_i, 
    output wire [(TOTAL_MASTER_CNT - 1):0] apb_pready_slv_o, 
    output wire [(TOTAL_MASTER_CNT - 1):0] apb_pslverr_slv_o, 
    output wire [((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0] apb_prdata_slv_o, 
    // -----------------------------------------
    // APB Slave Interface (to/from slave)
    // -----------------------------------------
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_psel_mstr_o, 
    output wire [((TOTAL_SLAVE_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_mstr_o, 
    output wire [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_pwdata_mstr_o, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_pwrite_mstr_o, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_penable_mstr_o, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pready_mstr_i, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pslverr_mstr_i, 
    input [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_prdata_mstr_i) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam ST_WIDTH = 2 ; 
    localparam ST_IDLE = 0 ; 
    localparam ST_ARB = 1 ; 
    localparam ST_GNT = 2 ; 
    localparam M = TOTAL_MASTER_CNT ; 
    localparam N = TOTAL_SLAVE_CNT ; 
    localparam AW = M_ADDR_WIDTH ; 
    localparam DW = DATA_WIDTH ; 
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire apb_m2s_psel ; 
    wire [(M_ADDR_WIDTH - 1):0] apb_m2s_paddr ; 
    wire [(DATA_WIDTH - 1):0] apb_m2s_pwdata ; 
    wire apb_m2s_pwrite ; 
    wire apb_m2s_penable ; 
    wire apb_s2m_pready ; 
    wire apb_s2m_pslverr ; 
    wire [(DATA_WIDTH - 1):0] apb_s2m_prdata ; 
    // ------------------------------------------------------------------------------
    // Submodule Instantiation(s)
    // ------------------------------------------------------------------------------
    // -----------------------------
    // APB Arbiter-Multiplexor
    // -----------------------------
    apb0_ipgen_lscc_apb_arbmux #(.K(K),
            .TOTAL_MASTER_CNT(TOTAL_MASTER_CNT),
            .M_ADDR_WIDTH(M_ADDR_WIDTH),
            .DATA_WIDTH(DATA_WIDTH),
            .OUTREG_EN(OUTREG_EN),
            .S_M_PRIO_IDX(S_M_PRIO_IDX),
            .S_ARBITER_SCHEME(S_ARBITER_SCHEME),
            .S_MAX_BURST_CNT(S_MAX_BURST_CNT)) u_lscc_apb_arbmux (/*AUTOINSTPARAM*/ // Parameters
            /*AUTOINST*/ // Outputs
            .apb_pready_slv_o(apb_pready_slv_o), 
                .apb_pslverr_slv_o(apb_pslverr_slv_o), 
                .apb_prdata_slv_o(apb_prdata_slv_o), 
                .apb_psel_mstr_o(apb_m2s_psel), 
                .apb_paddr_mstr_o(apb_m2s_paddr[(M_ADDR_WIDTH - 1):0]), 
                .apb_pwdata_mstr_o(apb_m2s_pwdata[(DATA_WIDTH - 1):0]), 
                .apb_pwrite_mstr_o(apb_m2s_pwrite), 
                .apb_penable_mstr_o(apb_m2s_penable), 
                // Inputs
            .apb_pclk_i(apb_pclk_i), 
                .apb_presetn_i(apb_presetn_i), 
                .apb_psel_slv_i(apb_psel_slv_i), 
                .apb_paddr_slv_i(apb_paddr_slv_i), 
                .apb_pwdata_slv_i(apb_pwdata_slv_i), 
                .apb_pwrite_slv_i(apb_pwrite_slv_i), 
                .apb_penable_slv_i(apb_penable_slv_i), 
                .apb_pready_mstr_i(apb_s2m_pready), 
                .apb_pslverr_mstr_i(apb_s2m_pslverr), 
                .apb_prdata_mstr_i(apb_s2m_prdata[(DATA_WIDTH - 1):0])) ; 
    // -------------
    // APB Bus
    // -------------
    apb0_ipgen_lscc_apb_bus #(.K(K),
            .F(F),
            .M_ADDR_WIDTH(M_ADDR_WIDTH),
            .FULL_DECODE_EN(FULL_DECODE_EN),
            .DATA_WIDTH(DATA_WIDTH),
            .TOTAL_SLAVE_CNT(TOTAL_SLAVE_CNT),
            .OUTREG_EN(OUTREG_EN),
            .S0_BASE_ADDR(S0_BASE_ADDR[((F * K) - 1):0]),
            .S0_ADDR_RANGE(S0_ADDR_RANGE[((F * K) - 1):0]),
            .S1_BASE_ADDR(S1_BASE_ADDR[((F * K) - 1):0]),
            .S1_ADDR_RANGE(S1_ADDR_RANGE[((F * K) - 1):0]),
            .S2_BASE_ADDR(S2_BASE_ADDR[((F * K) - 1):0]),
            .S2_ADDR_RANGE(S2_ADDR_RANGE[((F * K) - 1):0]),
            .S3_BASE_ADDR(S3_BASE_ADDR[((F * K) - 1):0]),
            .S3_ADDR_RANGE(S3_ADDR_RANGE[((F * K) - 1):0]),
            .S4_BASE_ADDR(S4_BASE_ADDR[((F * K) - 1):0]),
            .S4_ADDR_RANGE(S4_ADDR_RANGE[((F * K) - 1):0]),
            .S5_BASE_ADDR(S5_BASE_ADDR[((F * K) - 1):0]),
            .S5_ADDR_RANGE(S5_ADDR_RANGE[((F * K) - 1):0]),
            .S6_BASE_ADDR(S6_BASE_ADDR[((F * K) - 1):0]),
            .S6_ADDR_RANGE(S6_ADDR_RANGE[((F * K) - 1):0]),
            .S7_BASE_ADDR(S7_BASE_ADDR[((F * K) - 1):0]),
            .S7_ADDR_RANGE(S7_ADDR_RANGE[((F * K) - 1):0]),
            .S8_BASE_ADDR(S8_BASE_ADDR[((F * K) - 1):0]),
            .S8_ADDR_RANGE(S8_ADDR_RANGE[((F * K) - 1):0]),
            .S9_BASE_ADDR(S9_BASE_ADDR[((F * K) - 1):0]),
            .S9_ADDR_RANGE(S9_ADDR_RANGE[((F * K) - 1):0]),
            .S10_BASE_ADDR(S10_BASE_ADDR[((F * K) - 1):0]),
            .S10_ADDR_RANGE(S10_ADDR_RANGE[((F * K) - 1):0]),
            .S11_BASE_ADDR(S11_BASE_ADDR[((F * K) - 1):0]),
            .S11_ADDR_RANGE(S11_ADDR_RANGE[((F * K) - 1):0]),
            .S12_BASE_ADDR(S12_BASE_ADDR[((F * K) - 1):0]),
            .S12_ADDR_RANGE(S12_ADDR_RANGE[((F * K) - 1):0]),
            .S13_BASE_ADDR(S13_BASE_ADDR[((F * K) - 1):0]),
            .S13_ADDR_RANGE(S13_ADDR_RANGE[((F * K) - 1):0]),
            .S14_BASE_ADDR(S14_BASE_ADDR[((F * K) - 1):0]),
            .S14_ADDR_RANGE(S14_ADDR_RANGE[((F * K) - 1):0]),
            .S15_BASE_ADDR(S15_BASE_ADDR[((F * K) - 1):0]),
            .S15_ADDR_RANGE(S15_ADDR_RANGE[((F * K) - 1):0]),
            .S16_BASE_ADDR(S16_BASE_ADDR[((F * K) - 1):0]),
            .S16_ADDR_RANGE(S16_ADDR_RANGE[((F * K) - 1):0]),
            .S17_BASE_ADDR(S17_BASE_ADDR[((F * K) - 1):0]),
            .S17_ADDR_RANGE(S17_ADDR_RANGE[((F * K) - 1):0]),
            .S18_BASE_ADDR(S18_BASE_ADDR[((F * K) - 1):0]),
            .S18_ADDR_RANGE(S18_ADDR_RANGE[((F * K) - 1):0]),
            .S19_BASE_ADDR(S19_BASE_ADDR[((F * K) - 1):0]),
            .S19_ADDR_RANGE(S19_ADDR_RANGE[((F * K) - 1):0]),
            .S20_BASE_ADDR(S20_BASE_ADDR[((F * K) - 1):0]),
            .S20_ADDR_RANGE(S20_ADDR_RANGE[((F * K) - 1):0]),
            .S21_BASE_ADDR(S21_BASE_ADDR[((F * K) - 1):0]),
            .S21_ADDR_RANGE(S21_ADDR_RANGE[((F * K) - 1):0]),
            .S22_BASE_ADDR(S22_BASE_ADDR[((F * K) - 1):0]),
            .S22_ADDR_RANGE(S22_ADDR_RANGE[((F * K) - 1):0]),
            .S23_BASE_ADDR(S23_BASE_ADDR[((F * K) - 1):0]),
            .S23_ADDR_RANGE(S23_ADDR_RANGE[((F * K) - 1):0]),
            .S24_BASE_ADDR(S24_BASE_ADDR[((F * K) - 1):0]),
            .S24_ADDR_RANGE(S24_ADDR_RANGE[((F * K) - 1):0]),
            .S25_BASE_ADDR(S25_BASE_ADDR[((F * K) - 1):0]),
            .S25_ADDR_RANGE(S25_ADDR_RANGE[((F * K) - 1):0]),
            .S26_BASE_ADDR(S26_BASE_ADDR[((F * K) - 1):0]),
            .S26_ADDR_RANGE(S26_ADDR_RANGE[((F * K) - 1):0]),
            .S27_BASE_ADDR(S27_BASE_ADDR[((F * K) - 1):0]),
            .S27_ADDR_RANGE(S27_ADDR_RANGE[((F * K) - 1):0]),
            .S28_BASE_ADDR(S28_BASE_ADDR[((F * K) - 1):0]),
            .S28_ADDR_RANGE(S28_ADDR_RANGE[((F * K) - 1):0]),
            .S29_BASE_ADDR(S29_BASE_ADDR[((F * K) - 1):0]),
            .S29_ADDR_RANGE(S29_ADDR_RANGE[((F * K) - 1):0]),
            .S30_BASE_ADDR(S30_BASE_ADDR[((F * K) - 1):0]),
            .S30_ADDR_RANGE(S30_ADDR_RANGE[((F * K) - 1):0]),
            .S31_BASE_ADDR(S31_BASE_ADDR[((F * K) - 1):0]),
            .S31_ADDR_RANGE(S31_ADDR_RANGE[((F * K) - 1):0])) u_lscc_apb_bus (//AUTOINSTPARAM*/
            // Parameters
            //AUTOINST*/
            // Outputs
            .apb_pready_slv_o(apb_s2m_pready), 
                .apb_pslverr_slv_o(apb_s2m_pslverr), 
                .apb_prdata_slv_o(apb_s2m_prdata[(DATA_WIDTH - 1):0]), 
                .apb_psel_mstr_o(apb_psel_mstr_o), 
                .apb_paddr_mstr_o(apb_paddr_mstr_o), 
                .apb_pwdata_mstr_o(apb_pwdata_mstr_o), 
                .apb_pwrite_mstr_o(apb_pwrite_mstr_o), 
                .apb_penable_mstr_o(apb_penable_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                // Inputs
            .apb_pclk_i(apb_pclk_i), 
                .apb_presetn_i(apb_presetn_i), 
                .apb_psel_slv_i(apb_m2s_psel), 
                .apb_paddr_slv_i(apb_m2s_paddr[(M_ADDR_WIDTH - 1):0]), 
                .apb_pwdata_slv_i(apb_m2s_pwdata[(DATA_WIDTH - 1):0]), 
                .apb_pwrite_slv_i(apb_m2s_pwrite), 
                .apb_penable_slv_i(apb_m2s_penable), 
                .apb_pready_mstr_i(apb_pready_mstr_i), 
                .apb_pslverr_mstr_i(apb_pslverr_mstr_i), 
                .apb_prdata_mstr_i(apb_prdata_mstr_i)) ; 
    // ------------------------------------------------------------------------------
    // Function Definition
    // ------------------------------------------------------------------------------
    function integer clog2( 
        input integer depth )  ; 
        begin
            for (clog2 = 0 ; (depth > 0) ; clog2 = (clog2 + 1))
                depth = (depth >> 1) ;
        end
    endfunction
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS         
// Project               : 
// File                  : lscc_apb_decoder.v
// Title                 : 
// Dependencies          : 1.
//                       : 2.
// Description           : 
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_decoder #(parameter K = 32, 
        parameter F = 8, 
        parameter M_ADDR_WIDTH = 32, 
        parameter FULL_DECODE_EN = 1, 
        parameter TOTAL_SLAVE_CNT = 32, 
        parameter [3:0] S0_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S0_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S0_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S1_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S1_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S1_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S2_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S2_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S2_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S3_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S3_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S3_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S4_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S4_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S4_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S5_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S5_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S5_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S6_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S6_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S6_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S7_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S7_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S7_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S8_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S8_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S8_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S9_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S9_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S9_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S10_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S10_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S10_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S11_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S11_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S11_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S12_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S12_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S12_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S13_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S13_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S13_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S14_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S14_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S14_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S15_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S15_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S15_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S16_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S16_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S16_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S17_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S17_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S17_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S18_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S18_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S18_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S19_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S19_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S19_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S20_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S20_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S20_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S21_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S21_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S21_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S22_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S22_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S22_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S23_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S23_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S23_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S24_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S24_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S24_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S25_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S25_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S25_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S26_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S26_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S26_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S27_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S27_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S27_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S28_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S28_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S28_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S29_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S29_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S29_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S30_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S30_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S30_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}, 
        parameter [3:0] S31_FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] S31_BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] S31_ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input enable_i, 
    input [(M_ADDR_WIDTH - 1):10] apb_paddr_i, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_psel_o, 
    output wire apb_psel_def_o) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam N = TOTAL_SLAVE_CNT ; 
    localparam [((N * 4) - 1):0] FRAGMENT_EN = {S31_FRAGMENT_EN,
                S30_FRAGMENT_EN,
                S29_FRAGMENT_EN,
                S28_FRAGMENT_EN,
                S27_FRAGMENT_EN,
                S26_FRAGMENT_EN,
                S25_FRAGMENT_EN,
                S24_FRAGMENT_EN,
                S23_FRAGMENT_EN,
                S22_FRAGMENT_EN,
                S21_FRAGMENT_EN,
                S20_FRAGMENT_EN,
                S19_FRAGMENT_EN,
                S18_FRAGMENT_EN,
                S17_FRAGMENT_EN,
                S16_FRAGMENT_EN,
                S15_FRAGMENT_EN,
                S14_FRAGMENT_EN,
                S13_FRAGMENT_EN,
                S12_FRAGMENT_EN,
                S11_FRAGMENT_EN,
                S10_FRAGMENT_EN,
                S9_FRAGMENT_EN,
                S8_FRAGMENT_EN,
                S7_FRAGMENT_EN,
                S6_FRAGMENT_EN,
                S5_FRAGMENT_EN,
                S4_FRAGMENT_EN,
                S3_FRAGMENT_EN,
                S2_FRAGMENT_EN,
                S1_FRAGMENT_EN,
                S0_FRAGMENT_EN} ; 
    localparam [(((N * F) * K) - 1):0] BASE_ADDR = {S31_BASE_ADDR,
                S30_BASE_ADDR,
                S29_BASE_ADDR,
                S28_BASE_ADDR,
                S27_BASE_ADDR,
                S26_BASE_ADDR,
                S25_BASE_ADDR,
                S24_BASE_ADDR,
                S23_BASE_ADDR,
                S22_BASE_ADDR,
                S21_BASE_ADDR,
                S20_BASE_ADDR,
                S19_BASE_ADDR,
                S18_BASE_ADDR,
                S17_BASE_ADDR,
                S16_BASE_ADDR,
                S15_BASE_ADDR,
                S14_BASE_ADDR,
                S13_BASE_ADDR,
                S12_BASE_ADDR,
                S11_BASE_ADDR,
                S10_BASE_ADDR,
                S9_BASE_ADDR,
                S8_BASE_ADDR,
                S7_BASE_ADDR,
                S6_BASE_ADDR,
                S5_BASE_ADDR,
                S4_BASE_ADDR,
                S3_BASE_ADDR,
                S2_BASE_ADDR,
                S1_BASE_ADDR,
                S0_BASE_ADDR} ; 
    localparam [(((N * F) * K) - 1):0] ADDR_RANGE = {S31_ADDR_RANGE,
                S30_ADDR_RANGE,
                S29_ADDR_RANGE,
                S28_ADDR_RANGE,
                S27_ADDR_RANGE,
                S26_ADDR_RANGE,
                S25_ADDR_RANGE,
                S24_ADDR_RANGE,
                S23_ADDR_RANGE,
                S22_ADDR_RANGE,
                S21_ADDR_RANGE,
                S20_ADDR_RANGE,
                S19_ADDR_RANGE,
                S18_ADDR_RANGE,
                S17_ADDR_RANGE,
                S16_ADDR_RANGE,
                S15_ADDR_RANGE,
                S14_ADDR_RANGE,
                S13_ADDR_RANGE,
                S12_ADDR_RANGE,
                S11_ADDR_RANGE,
                S10_ADDR_RANGE,
                S9_ADDR_RANGE,
                S8_ADDR_RANGE,
                S7_ADDR_RANGE,
                S6_ADDR_RANGE,
                S5_ADDR_RANGE,
                S4_ADDR_RANGE,
                S3_ADDR_RANGE,
                S2_ADDR_RANGE,
                S1_ADDR_RANGE,
                S0_ADDR_RANGE} ; 
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire [(TOTAL_SLAVE_CNT - 1):0] psel ; 
    // ------------------------------------------------------------------------------
    // Assign Statements
    // ------------------------------------------------------------------------------
    assign apb_psel_o = (enable_i ? psel : {TOTAL_SLAVE_CNT{1'b0}}) ; 
    assign apb_psel_def_o = (enable_i ? ((|psel) ? 1'b0 : 1'b1) : 1'b0) ; 
    // ------------------------------------------------------------------------------
    // Submodule Instantiations
    // ------------------------------------------------------------------------------
    genvar i ; 
    generate
        for (i = 0;(i < TOTAL_SLAVE_CNT);i = (i + 1))
        begin : genblk1
            apb0_ipgen_lscc_apb_decoder_prim #(.K(K),
                    .F(F),
                    .M_ADDR_WIDTH(M_ADDR_WIDTH),
                    .FULL_DECODE_EN(FULL_DECODE_EN),
                    .FRAGMENT_EN(FRAGMENT_EN[(4 * i) +: 4]),
                    .BASE_ADDR(BASE_ADDR[((F * K) * i) +: (F * K)]),
                    .ADDR_RANGE(ADDR_RANGE[((F * K) * i) +: (F * K)])) u_lscc_apb_decoder_sel (.enable_i(enable_i), 
                        .addr_i(apb_paddr_i[(M_ADDR_WIDTH - 1):10]), 
                        .sel_o(psel[i])) ; 
        end
    endgenerate
endmodule



`timescale 1ns/1ps
// ==============================================================================
// lscc_apb_decoder.v
// ==============================================================================
//  `ifndef LSCC_APB_DECODER
// ==============================================================================
// APB Decoder: Primitive
// ==============================================================================
module apb0_ipgen_lscc_apb_decoder_prim #(parameter K = 32, 
        parameter F = 8, 
        parameter M_ADDR_WIDTH = 32, 
        parameter FULL_DECODE_EN = 1, 
        parameter [3:0] FRAGMENT_EN = 4'd1, 
        parameter [((F * K) - 1):0] BASE_ADDR = {32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0,
                32'h0}, 
        parameter [((F * K) - 1):0] ADDR_RANGE = {32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400,
                32'h400}) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input enable_i, 
    input [(M_ADDR_WIDTH - 1):10] addr_i, 
    output wire sel_o) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire [(FRAGMENT_EN - 1):0] sel_w ; 
    // ------------------------------------------------------------------------------
    // Assign Statements
    // ------------------------------------------------------------------------------
    assign sel_o = (|sel_w) ; 
    // ------------------------------------------------------------------------------
    // Generate Blocks
    // ------------------------------------------------------------------------------
    genvar i ; 
    // Slave 0
    generate
        for (i = 0;(i < FRAGMENT_EN);i = (i + 1))
        begin : genblk1
            apb0_ipgen_lscc_apb_decoder_comp #(.K(K),
                    .BASE_ADDR(BASE_ADDR[((K + (K * i)) - 1):(i * K)]),
                    .ADDR_RANGE(ADDR_RANGE[((K + (K * i)) - 1):(i * K)]),
                    .ADDR_WIDTH(M_ADDR_WIDTH),
                    .FULL_DECODE_EN(FULL_DECODE_EN)) u_lscc_apb_decoder_comp (.enable_i(enable_i), 
                        .addr_i(addr_i), 
                        .sel_o(sel_w[i])) ; 
        end
    endgenerate
endmodule



`timescale 1ns/1ps
// ==============================================================================
// lscc_apb_decoder_prim.v
// ==============================================================================
//  `ifndef LSCC_APB_DECODER_PRIM
// ==============================================================================
// APB Decoder: Comparator
// ==============================================================================
module apb0_ipgen_lscc_apb_decoder_comp #(parameter K = 32, 
        parameter BASE_ADDR = 32'h0, 
        parameter ADDR_RANGE = 32'h400, 
        parameter ADDR_WIDTH = 32, 
        parameter FULL_DECODE_EN = 1) (
    // ------------------------------------------------------------------------------
    // Module Parameters
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input enable_i, 
    input [(ADDR_WIDTH - 1):10] addr_i, 
    output reg sel_o) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    localparam MAX_ADDR = ((BASE_ADDR + ADDR_RANGE) - 1) ; // Added -1 to be consistent with ipxact:range
    localparam RANGE_WIDTH = ((ADDR_RANGE >= 32'h400) ? clog2((ADDR_RANGE - 1)) : 10) ; 
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    wire [(K - 1):0] min_addr = BASE_ADDR ; 
    wire [(K - 1):0] max_addr = ({K{1'b0}} | MAX_ADDR) ; 
    wire [(K - 1):0] addr = ({K{1'b0}} | {addr_i[(ADDR_WIDTH - 1):10],
                {10{1'b0}}}) ; 
    // ------------------------------------------------------------------------------
    // Combinatorial Blocks
    // ------------------------------------------------------------------------------
    generate
        if ((FULL_DECODE_EN == 1)) 
            begin : full_dec
                always
                    @(*)
                    begin
                        if (((addr[(ADDR_WIDTH - 1):10] >= min_addr[(ADDR_WIDTH - 1):10]) && (addr[(ADDR_WIDTH - 1):10] <= max_addr[(ADDR_WIDTH - 1):10]))) 
                            begin
                                sel_o = (enable_i ? 1'b1 : 1'b0) ;
                            end
                        else
                            begin
                                sel_o = 1'b0 ;
                            end
                    end
            end
        else
            if ((ADDR_WIDTH > RANGE_WIDTH)) 
                begin : partial_dec_1
                    always
                        @(*)
                        begin
                            if ((addr[(ADDR_WIDTH - 1):RANGE_WIDTH] == min_addr[(ADDR_WIDTH - 1):RANGE_WIDTH])) 
                                begin
                                    sel_o = (enable_i ? 1'b1 : 1'b0) ;
                                end
                            else
                                begin
                                    sel_o = 1'b0 ;
                                end
                        end
                end
            else
                begin : partial_dec_2
                    always
                        @(*)
                        begin
                            sel_o = enable_i ;
                        end
                end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function integer clog2( 
        input integer depth )  ; 
        begin
            if ((depth == 0)) 
                clog2 = 1 ;
            else
                for (clog2 = 0 ; (depth > 0) ; clog2 = (clog2 + 1))
                    depth = (depth >> 1) ;
        end
    endfunction

//
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_crossbar.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_arbmux.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_arbiter.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
// ==============================================================================
// AHB-Lite Priority Arbiter
// ==============================================================================
// ==============================================================================
// AHB-Lite Thermometer Mask
// ==============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_bus.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS         
// Project               : 
// File                  : lscc_apb_decoder.v
// Title                 : 
// Dependencies          : 1.
//                       : 2.
// Description           : 
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
//  `ifndef LSCC_APB_DECODER
// ==============================================================================
// APB Decoder: Primitive
// ==============================================================================
//  `ifndef LSCC_APB_DECODER_PRIM
// ==============================================================================
// APB Decoder: Comparator
// ==============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS         
// Project               : 
// File                  : lscc_apb_multiplexor.v
// Title                 : 
// Dependencies          : 1.
//                       : 2.
// Description           : 
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_multiplexor #(parameter K = 32, 
        parameter M_ADDR_WIDTH = 32, 
        parameter DATA_WIDTH = 32, 
        parameter TOTAL_SLAVE_CNT = 32, 
        parameter OUTREG_EN = 0) (
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input apb_pclk_i, 
    input apb_presetn_i, 
    // ----------------------
    // From APB Decoder
    // ----------------------
    input [(TOTAL_SLAVE_CNT - 1):0] apb_psel_dec_i, 
    // ----------------------------------------
    // APB Master Interface (to/from master)
    // ----------------------------------------
    input apb_psel_slv_i, 
    input [(M_ADDR_WIDTH - 1):0] apb_paddr_slv_i, 
    input [(DATA_WIDTH - 1):0] apb_pwdata_slv_i, 
    input apb_pwrite_slv_i, 
    input apb_penable_slv_i, 
    output reg apb_pready_slv_o, 
    output reg apb_pslverr_slv_o, 
    output reg [(DATA_WIDTH - 1):0] apb_prdata_slv_o, 
    // -----------------------------------------
    // APB Slave Interface (to/from slave)
    // -----------------------------------------
    output reg [(TOTAL_SLAVE_CNT - 1):0] apb_psel_mstr_o, 
    output reg [((TOTAL_SLAVE_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_mstr_o, 
    output reg [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_pwdata_mstr_o, 
    output reg [(TOTAL_SLAVE_CNT - 1):0] apb_pwrite_mstr_o, 
    output reg [(TOTAL_SLAVE_CNT - 1):0] apb_penable_mstr_o, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pready_mstr_i, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pslverr_mstr_i, 
    input [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_prdata_mstr_i, 
    // -------------------------------------------------
    // APB DEFAULT Slave Interface (to/from slave)
    // -------------------------------------------------
    input apb_psel_def_mstr_i) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    //localparam                                    SEL_WIDTH = clog2(TOTAL_SLAVE_CNT);
    // ------------------------------------------------------------------------------
    // Register Declarations
    // ------------------------------------------------------------------------------
    reg pready ; 
    reg pslverr ; 
    reg [(DATA_WIDTH - 1):0] prdata ; 
    //reg [SEL_WIDTH-1:0]                           sel;
    reg [(TOTAL_SLAVE_CNT - 1):0] apb_psel_dec_r ; 
    reg apb_psel_def_r ; 
    reg [(((TOTAL_SLAVE_CNT + 1) * DATA_WIDTH) - 1):0] tmp_data ; 
    // ------------------------------------------------------------------------------
    // Assign Statements
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Generate Blocks
    // ------------------------------------------------------------------------------
    integer i, 
        j ; 
    // ----------
    // To Master
    // ----------
    always
        @(posedge apb_pclk_i or 
            negedge apb_presetn_i)
        begin
            if ((~apb_presetn_i)) 
                begin
                    apb_psel_dec_r <=  {TOTAL_SLAVE_CNT{1'b0}} ;
                    apb_psel_def_r <=  1'b0 ;
                end
            else
                begin
                    if (apb_psel_slv_i) // only default slave selector is negated
                        begin
                            apb_psel_dec_r <=  apb_psel_dec_i ;
                            apb_psel_def_r <=  apb_psel_def_mstr_i ;
                        end
                    else
                        apb_psel_def_r <=  1'b0 ;
                end
        end
    always
        @(*)
        begin
            tmp_data = {((TOTAL_SLAVE_CNT + 1) * DATA_WIDTH){1'b0}} ;
            pready = (|(apb_psel_dec_r & apb_pready_mstr_i)) ;
            pslverr = (|(apb_psel_dec_r & apb_pslverr_mstr_i)) ;
            for (j = 0 ; (j < TOTAL_SLAVE_CNT) ; j = (j + 1))
                begin
                    tmp_data[(DATA_WIDTH * (j + 1)) +: DATA_WIDTH] = (({DATA_WIDTH{apb_psel_dec_r[j]}} & apb_prdata_mstr_i[(DATA_WIDTH * j) +: DATA_WIDTH]) | tmp_data[(DATA_WIDTH * j) +: DATA_WIDTH]) ;
                end
            prdata = tmp_data[(DATA_WIDTH * TOTAL_SLAVE_CNT) +: DATA_WIDTH] ;
        end
    generate
        if ((OUTREG_EN == 0)) 
            begin : noreg
                always
                    @(*)
                    begin
                        apb_pready_slv_o = (apb_psel_def_r ? 1'b1 : pready) ;
                        apb_pslverr_slv_o = (apb_psel_def_r ? 1'b1 : pslverr) ;
                        apb_prdata_slv_o = (apb_psel_def_r ? {DATA_WIDTH{1'b0}} : prdata) ;
                    end
            end
        else
            begin : outreg
            end
    endgenerate
    //always @* begin
    //  pready   = 1;
    //  pslverr  = 0;
    //  prdata   = 0;
    //    
    //  sel      = 0;
    //  for (i = 0; i < TOTAL_SLAVE_CNT; i = i + 1) begin                
    //    if (apb_psel_dec_i == (1 << i)) begin
    //      sel = i;
    //    end
    //    pready  = apb_pready_mstr_i[sel];
    //    pslverr = apb_pslverr_mstr_i[sel];
    //    prdata  = apb_prdata_mstr_i[(DATA_WIDTH*sel)+:DATA_WIDTH];       
    //  end
    //end
    //
    //generate
    //  if (OUTREG_EN == 0) begin : outreg_slv_off
    //    always @* begin
    //      apb_pready_slv_o  = apb_psel_def_mstr_i
    //                           ? 1'b1
    //                           : pready;
    //      apb_pslverr_slv_o = apb_psel_def_mstr_i
    //                           ? 1'b1
    //                           : pslverr;
    //      apb_prdata_slv_o  = apb_psel_def_mstr_i
    //                           ? {DATA_WIDTH{1'b0}}
    //                           : prdata;
    //    end
    //  end
    //  else begin : outreg_slv_on
    //    always @(posedge apb_pclk_i or negedge apb_presetn_i) begin
    //      if (~apb_presetn_i) begin
    //        apb_pready_slv_o  <= 0;
    //        apb_pslverr_slv_o <= 0;
    //        apb_prdata_slv_o  <= 0;
    //      end
    //      else begin
    //        apb_pready_slv_o  <= apb_psel_def_mstr_i
    //                              ? 1'b1
    //                              : pready;
    //        apb_pslverr_slv_o <= apb_psel_def_mstr_i
    //                              ? 1'b1
    //                              : pslverr;
    //        apb_prdata_slv_o  <= apb_psel_def_mstr_i
    //                              ? {DATA_WIDTH{1'b0}}
    //                              : prdata;
    //      end
    //    end
    //  end
    //endgenerate
    // ---------
    // To Slave
    // ---------
    generate
        if ((OUTREG_EN == 0)) 
            begin : outreg_mstr_off
                always
                    @(*)
                    begin
                        apb_psel_mstr_o = apb_psel_dec_i ;
                        for (i = 0 ; (i < TOTAL_SLAVE_CNT) ; i = (i + 1))
                            begin
                                //apb_paddr_mstr_o[(M_ADDR_WIDTH*i)+:M_ADDR_WIDTH]  = 0;
                                //apb_pwdata_mstr_o[(DATA_WIDTH*i)+:DATA_WIDTH]     = 0;
                                //apb_pwrite_mstr_o[i]                              = 0;
                                //apb_penable_mstr_o[i]                             = 0;
                                //
                                //if (apb_psel_dec_i[i]) begin
                                apb_paddr_mstr_o[(M_ADDR_WIDTH * i) +: M_ADDR_WIDTH] = apb_paddr_slv_i ;
                                apb_pwdata_mstr_o[(DATA_WIDTH * i) +: DATA_WIDTH] = apb_pwdata_slv_i ;
                                apb_pwrite_mstr_o[i] = apb_pwrite_slv_i ;
                                apb_penable_mstr_o[i] = apb_penable_slv_i ;
                                //end
                            end
                    end
            end
        else
            begin : outreg_mstr_on
                always
                    @(posedge apb_pclk_i or 
                        negedge apb_presetn_i)
                    begin
                        if ((~apb_presetn_i)) 
                            begin
                                apb_psel_mstr_o <= 0 ;
                                apb_paddr_mstr_o <= 0 ;
                                apb_pwdata_mstr_o <= 0 ;
                                apb_pwrite_mstr_o <= 0 ;
                                apb_penable_mstr_o <= 0 ;
                            end
                        else
                            begin
                                apb_psel_mstr_o <=  apb_psel_dec_i ;
                                apb_paddr_mstr_o[(M_ADDR_WIDTH * i) +: M_ADDR_WIDTH] <=  0 ;
                                apb_pwdata_mstr_o[(DATA_WIDTH * i) +: DATA_WIDTH] <=  0 ;
                                apb_pwrite_mstr_o[i] <=  0 ;
                                apb_penable_mstr_o[i] <=  0 ;
                                if (apb_psel_dec_i[i]) 
                                    begin
                                        apb_paddr_mstr_o[(M_ADDR_WIDTH * i) +: M_ADDR_WIDTH] <=  apb_paddr_slv_i ;
                                        apb_pwdata_mstr_o[(DATA_WIDTH * i) +: DATA_WIDTH] <=  apb_pwdata_slv_i ;
                                        apb_pwrite_mstr_o[i] <=  apb_pwrite_slv_i ;
                                        apb_penable_mstr_o[i] <=  apb_penable_slv_i ;
                                    end
                            end
                    end
            end
    endgenerate

//------------------------------------------------------------------------------
// Function Definition
//------------------------------------------------------------------------------
//function integer clog2 (input integer depth);
//  begin
//    for (clog2 = 0; depth > 0;  clog2 = clog2 + 1)
//      depth = depth >> 1;
//  end
//endfunction
endmodule



`timescale 1ns/1ps
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_interconnect.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_crossbar.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_arbmux.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_arbiter.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
// ==============================================================================
// AHB-Lite Priority Arbiter
// ==============================================================================
// ==============================================================================
// AHB-Lite Thermometer Mask
// ==============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_bus.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           :
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS         
// Project               : 
// File                  : lscc_apb_decoder.v
// Title                 : 
// Dependencies          : 1.
//                       : 2.
// Description           : 
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
//  `ifndef LSCC_APB_DECODER
// ==============================================================================
// APB Decoder: Primitive
// ==============================================================================
//  `ifndef LSCC_APB_DECODER_PRIM
// ==============================================================================
// APB Decoder: Comparator
// ==============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™ DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                         FILE DETAILS         
// Project               : 
// File                  : lscc_apb_multiplexor.v
// Title                 : 
// Dependencies          : 1.
//                       : 2.
// Description           : 
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
module apb0_ipgen_lscc_apb_interconnect #(parameter K = 32, 
        parameter F = 1, 
        parameter TOTAL_MASTER_CNT = 8, 
        parameter TOTAL_SLAVE_CNT = 8, 
        parameter M_ADDR_WIDTH = 32, 
        parameter FULL_DECODE_EN = 1, 
        parameter M_PRIO_WIDTH = clog2(TOTAL_MASTER_CNT), 
        parameter DATA_WIDTH = 32, 
        parameter OUTREG_EN = 0, 
        parameter FAMILY = "LIFCL", 
        parameter [((TOTAL_MASTER_CNT * M_PRIO_WIDTH) - 1):0] S_M_PRIO_IDX = {3'd7,
                3'd6,
                3'd5,
                3'd4,
                3'd3,
                3'd2,
                3'd1,
                3'd0}, 
        parameter [2:0] S_ARBITER_SCHEME = 3'b0, 
        parameter [31:0] S0_BASE_ADDR = 32'h0, 
        parameter [31:0] S0_ADDR_RANGE = 32'h400, 
        parameter [31:0] S1_BASE_ADDR = 32'h0, 
        parameter [31:0] S1_ADDR_RANGE = 32'h400, 
        parameter [31:0] S2_BASE_ADDR = 32'h0, 
        parameter [31:0] S2_ADDR_RANGE = 32'h400, 
        parameter [31:0] S3_BASE_ADDR = 32'h0, 
        parameter [31:0] S3_ADDR_RANGE = 32'h400, 
        parameter [31:0] S4_BASE_ADDR = 32'h0, 
        parameter [31:0] S4_ADDR_RANGE = 32'h400, 
        parameter [31:0] S5_BASE_ADDR = 32'h0, 
        parameter [31:0] S5_ADDR_RANGE = 32'h400, 
        parameter [31:0] S6_BASE_ADDR = 32'h0, 
        parameter [31:0] S6_ADDR_RANGE = 32'h400, 
        parameter [31:0] S7_BASE_ADDR = 32'h0, 
        parameter [31:0] S7_ADDR_RANGE = 32'h400, 
        parameter [31:0] S8_BASE_ADDR = 32'h0, 
        parameter [31:0] S8_ADDR_RANGE = 32'h400, 
        parameter [31:0] S9_BASE_ADDR = 32'h0, 
        parameter [31:0] S9_ADDR_RANGE = 32'h400, 
        parameter [31:0] S10_BASE_ADDR = 32'h0, 
        parameter [31:0] S10_ADDR_RANGE = 32'h400, 
        parameter [31:0] S11_BASE_ADDR = 32'h0, 
        parameter [31:0] S11_ADDR_RANGE = 32'h400, 
        parameter [31:0] S12_BASE_ADDR = 32'h0, 
        parameter [31:0] S12_ADDR_RANGE = 32'h400, 
        parameter [31:0] S13_BASE_ADDR = 32'h0, 
        parameter [31:0] S13_ADDR_RANGE = 32'h400, 
        parameter [31:0] S14_BASE_ADDR = 32'h0, 
        parameter [31:0] S14_ADDR_RANGE = 32'h400, 
        parameter [31:0] S15_BASE_ADDR = 32'h0, 
        parameter [31:0] S15_ADDR_RANGE = 32'h400, 
        parameter [31:0] S16_BASE_ADDR = 32'h0, 
        parameter [31:0] S16_ADDR_RANGE = 32'h400, 
        parameter [31:0] S17_BASE_ADDR = 32'h0, 
        parameter [31:0] S17_ADDR_RANGE = 32'h400, 
        parameter [31:0] S18_BASE_ADDR = 32'h0, 
        parameter [31:0] S18_ADDR_RANGE = 32'h400, 
        parameter [31:0] S19_BASE_ADDR = 32'h0, 
        parameter [31:0] S19_ADDR_RANGE = 32'h400, 
        parameter [31:0] S20_BASE_ADDR = 32'h0, 
        parameter [31:0] S20_ADDR_RANGE = 32'h400, 
        parameter [31:0] S21_BASE_ADDR = 32'h0, 
        parameter [31:0] S21_ADDR_RANGE = 32'h400, 
        parameter [31:0] S22_BASE_ADDR = 32'h0, 
        parameter [31:0] S22_ADDR_RANGE = 32'h400, 
        parameter [31:0] S23_BASE_ADDR = 32'h0, 
        parameter [31:0] S23_ADDR_RANGE = 32'h400, 
        parameter [31:0] S24_BASE_ADDR = 32'h0, 
        parameter [31:0] S24_ADDR_RANGE = 32'h400, 
        parameter [31:0] S25_BASE_ADDR = 32'h0, 
        parameter [31:0] S25_ADDR_RANGE = 32'h400, 
        parameter [31:0] S26_BASE_ADDR = 32'h0, 
        parameter [31:0] S26_ADDR_RANGE = 32'h400, 
        parameter [31:0] S27_BASE_ADDR = 32'h0, 
        parameter [31:0] S27_ADDR_RANGE = 32'h400, 
        parameter [31:0] S28_BASE_ADDR = 32'h0, 
        parameter [31:0] S28_ADDR_RANGE = 32'h400, 
        parameter [31:0] S29_BASE_ADDR = 32'h0, 
        parameter [31:0] S29_ADDR_RANGE = 32'h400, 
        parameter [31:0] S30_BASE_ADDR = 32'h0, 
        parameter [31:0] S30_ADDR_RANGE = 32'h400, 
        parameter [31:0] S31_BASE_ADDR = 32'h0, 
        parameter [31:0] S31_ADDR_RANGE = 32'h400) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    input apb_pclk_i, 
    input apb_presetn_i, 
    // -------------------------------------------
    // APB Master Interface (to/from master)
    // -------------------------------------------
    input [(TOTAL_MASTER_CNT - 1):0] apb_psel_slv_i, 
    input [((TOTAL_MASTER_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_slv_i, 
    input [((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0] apb_pwdata_slv_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_pwrite_slv_i, 
    input [(TOTAL_MASTER_CNT - 1):0] apb_penable_slv_i, 
    output wire [(TOTAL_MASTER_CNT - 1):0] apb_pready_slv_o, 
    output wire [(TOTAL_MASTER_CNT - 1):0] apb_pslverr_slv_o, 
    output wire [((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0] apb_prdata_slv_o, 
    // -----------------------------------------
    // APB Slave Interface (to/from slave)
    // -----------------------------------------
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_psel_mstr_o, 
    output wire [((TOTAL_SLAVE_CNT * M_ADDR_WIDTH) - 1):0] apb_paddr_mstr_o, 
    output wire [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_pwdata_mstr_o, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_pwrite_mstr_o, 
    output wire [(TOTAL_SLAVE_CNT - 1):0] apb_penable_mstr_o, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pready_mstr_i, 
    input [(TOTAL_SLAVE_CNT - 1):0] apb_pslverr_mstr_i, 
    input [((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0] apb_prdata_mstr_i) ;
    // ------------------------------------------------------------------------------
    // Local Parameters
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Wire Declarations
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Assign Statements
    // ------------------------------------------------------------------------------
    // ------------------------------------------------------------------------------
    // Submodule Instantiation(s)
    // ------------------------------------------------------------------------------
    generate
        if (((TOTAL_MASTER_CNT == 1) && (TOTAL_SLAVE_CNT >= 1))) 
            begin : apb_bus
                // -------------
                // AHB-Lite Bus
                // -------------
                apb0_ipgen_lscc_apb_bus #(.K(K),
                        .F(F),
                        .M_ADDR_WIDTH(M_ADDR_WIDTH),
                        .FULL_DECODE_EN(FULL_DECODE_EN),
                        .DATA_WIDTH(DATA_WIDTH),
                        .TOTAL_SLAVE_CNT(TOTAL_SLAVE_CNT),
                        .OUTREG_EN(OUTREG_EN),
                        .S0_BASE_ADDR(S0_BASE_ADDR),
                        .S0_ADDR_RANGE(S0_ADDR_RANGE),
                        .S1_BASE_ADDR(S1_BASE_ADDR),
                        .S1_ADDR_RANGE(S1_ADDR_RANGE),
                        .S2_BASE_ADDR(S2_BASE_ADDR),
                        .S2_ADDR_RANGE(S2_ADDR_RANGE),
                        .S3_BASE_ADDR(S3_BASE_ADDR),
                        .S3_ADDR_RANGE(S3_ADDR_RANGE),
                        .S4_BASE_ADDR(S4_BASE_ADDR),
                        .S4_ADDR_RANGE(S4_ADDR_RANGE),
                        .S5_BASE_ADDR(S5_BASE_ADDR),
                        .S5_ADDR_RANGE(S5_ADDR_RANGE),
                        .S6_BASE_ADDR(S6_BASE_ADDR),
                        .S6_ADDR_RANGE(S6_ADDR_RANGE),
                        .S7_BASE_ADDR(S7_BASE_ADDR),
                        .S7_ADDR_RANGE(S7_ADDR_RANGE),
                        .S8_BASE_ADDR(S8_BASE_ADDR),
                        .S8_ADDR_RANGE(S8_ADDR_RANGE),
                        .S9_BASE_ADDR(S9_BASE_ADDR),
                        .S9_ADDR_RANGE(S9_ADDR_RANGE),
                        .S10_BASE_ADDR(S10_BASE_ADDR),
                        .S10_ADDR_RANGE(S10_ADDR_RANGE),
                        .S11_BASE_ADDR(S11_BASE_ADDR),
                        .S11_ADDR_RANGE(S11_ADDR_RANGE),
                        .S12_BASE_ADDR(S12_BASE_ADDR),
                        .S12_ADDR_RANGE(S12_ADDR_RANGE),
                        .S13_BASE_ADDR(S13_BASE_ADDR),
                        .S13_ADDR_RANGE(S13_ADDR_RANGE),
                        .S14_BASE_ADDR(S14_BASE_ADDR),
                        .S14_ADDR_RANGE(S14_ADDR_RANGE),
                        .S15_BASE_ADDR(S15_BASE_ADDR),
                        .S15_ADDR_RANGE(S15_ADDR_RANGE),
                        .S16_BASE_ADDR(S16_BASE_ADDR),
                        .S16_ADDR_RANGE(S16_ADDR_RANGE),
                        .S17_BASE_ADDR(S17_BASE_ADDR),
                        .S17_ADDR_RANGE(S17_ADDR_RANGE),
                        .S18_BASE_ADDR(S18_BASE_ADDR),
                        .S18_ADDR_RANGE(S18_ADDR_RANGE),
                        .S19_BASE_ADDR(S19_BASE_ADDR),
                        .S19_ADDR_RANGE(S19_ADDR_RANGE),
                        .S20_BASE_ADDR(S20_BASE_ADDR),
                        .S20_ADDR_RANGE(S20_ADDR_RANGE),
                        .S21_BASE_ADDR(S21_BASE_ADDR),
                        .S21_ADDR_RANGE(S21_ADDR_RANGE),
                        .S22_BASE_ADDR(S22_BASE_ADDR),
                        .S22_ADDR_RANGE(S22_ADDR_RANGE),
                        .S23_BASE_ADDR(S23_BASE_ADDR),
                        .S23_ADDR_RANGE(S23_ADDR_RANGE),
                        .S24_BASE_ADDR(S24_BASE_ADDR),
                        .S24_ADDR_RANGE(S24_ADDR_RANGE),
                        .S25_BASE_ADDR(S25_BASE_ADDR),
                        .S25_ADDR_RANGE(S25_ADDR_RANGE),
                        .S26_BASE_ADDR(S26_BASE_ADDR),
                        .S26_ADDR_RANGE(S26_ADDR_RANGE),
                        .S27_BASE_ADDR(S27_BASE_ADDR),
                        .S27_ADDR_RANGE(S27_ADDR_RANGE),
                        .S28_BASE_ADDR(S28_BASE_ADDR),
                        .S28_ADDR_RANGE(S28_ADDR_RANGE),
                        .S29_BASE_ADDR(S29_BASE_ADDR),
                        .S29_ADDR_RANGE(S29_ADDR_RANGE),
                        .S30_BASE_ADDR(S30_BASE_ADDR),
                        .S30_ADDR_RANGE(S30_ADDR_RANGE),
                        .S31_BASE_ADDR(S31_BASE_ADDR),
                        .S31_ADDR_RANGE(S31_ADDR_RANGE)) u_lscc_apb_bus (/*AUTOINSTPARAM*/ // Parameters
                        /*AUTOINST*/ // Outputs
                        .apb_pready_slv_o(apb_pready_slv_o), 
                            .apb_pslverr_slv_o(apb_pslverr_slv_o), 
                            .apb_prdata_slv_o(apb_prdata_slv_o[(DATA_WIDTH - 1):0]), 
                            .apb_psel_mstr_o(apb_psel_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_paddr_mstr_o(apb_paddr_mstr_o[((TOTAL_SLAVE_CNT * M_ADDR_WIDTH) - 1):0]), 
                            .apb_pwdata_mstr_o(apb_pwdata_mstr_o[((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0]), 
                            .apb_pwrite_mstr_o(apb_pwrite_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_penable_mstr_o(apb_penable_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                            // Inputs
                        .apb_pclk_i(apb_pclk_i), 
                            .apb_presetn_i(apb_presetn_i), 
                            .apb_psel_slv_i(apb_psel_slv_i), 
                            .apb_paddr_slv_i(apb_paddr_slv_i[(M_ADDR_WIDTH - 1):0]), 
                            .apb_pwdata_slv_i(apb_pwdata_slv_i[(DATA_WIDTH - 1):0]), 
                            .apb_pwrite_slv_i(apb_pwrite_slv_i), 
                            .apb_penable_slv_i(apb_penable_slv_i), 
                            .apb_pready_mstr_i(apb_pready_mstr_i[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_pslverr_mstr_i(apb_pslverr_mstr_i[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_prdata_mstr_i(apb_prdata_mstr_i[((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0])) ; 
            end
        if (((TOTAL_MASTER_CNT >= 1) && (TOTAL_SLAVE_CNT == 1))) 
            begin : apb_arbmux
                // -----------------------------
                // AHB-Lite Arbiter-Multiplexor
                // -----------------------------
                apb0_ipgen_lscc_apb_arbmux #(.K(K),
                        .TOTAL_MASTER_CNT(TOTAL_MASTER_CNT),
                        .M_ADDR_WIDTH(M_ADDR_WIDTH),
                        .DATA_WIDTH(DATA_WIDTH),
                        .OUTREG_EN(OUTREG_EN),
                        .S_M_PRIO_IDX(S_M_PRIO_IDX[((TOTAL_MASTER_CNT * M_PRIO_WIDTH) - 1):0]),
                        .S_ARBITER_SCHEME(S_ARBITER_SCHEME[2:0])) u_lscc_apb_arbmux (/*AUTOINSTPARAM*/ // Parameters
                        /*AUTOINST*/ // Outputs
                        .apb_pready_slv_o(apb_pready_slv_o[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_pslverr_slv_o(apb_pslverr_slv_o[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_prdata_slv_o(apb_prdata_slv_o[((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0]), 
                            .apb_psel_mstr_o(apb_psel_mstr_o), 
                            .apb_paddr_mstr_o(apb_paddr_mstr_o[(M_ADDR_WIDTH - 1):0]), 
                            .apb_pwdata_mstr_o(apb_pwdata_mstr_o[(DATA_WIDTH - 1):0]), 
                            .apb_pwrite_mstr_o(apb_pwrite_mstr_o), 
                            .apb_penable_mstr_o(apb_penable_mstr_o), 
                            // Inputs
                        .apb_pclk_i(apb_pclk_i), 
                            .apb_presetn_i(apb_presetn_i), 
                            .apb_psel_slv_i(apb_psel_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_paddr_slv_i(apb_paddr_slv_i[((TOTAL_MASTER_CNT * M_ADDR_WIDTH) - 1):0]), 
                            .apb_pwdata_slv_i(apb_pwdata_slv_i[((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0]), 
                            .apb_pwrite_slv_i(apb_pwrite_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_penable_slv_i(apb_penable_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_pready_mstr_i(apb_pready_mstr_i), 
                            .apb_pslverr_mstr_i(apb_pslverr_mstr_i), 
                            .apb_prdata_mstr_i(apb_prdata_mstr_i[(DATA_WIDTH - 1):0])) ; 
            end
        if (((TOTAL_MASTER_CNT > 1) && (TOTAL_SLAVE_CNT > 1))) 
            begin : apb_crossbar
                // ------------------
                // AHB-Lite Crossbar
                // ------------------
                apb0_ipgen_lscc_apb_crossbar #(.K(K),
                        .F(F),
                        .TOTAL_MASTER_CNT(TOTAL_MASTER_CNT),
                        .TOTAL_SLAVE_CNT(TOTAL_SLAVE_CNT),
                        .M_ADDR_WIDTH(M_ADDR_WIDTH),
                        .FULL_DECODE_EN(FULL_DECODE_EN),
                        .DATA_WIDTH(DATA_WIDTH),
                        .OUTREG_EN(OUTREG_EN),
                        .S_M_PRIO_IDX(S_M_PRIO_IDX[((TOTAL_MASTER_CNT * M_PRIO_WIDTH) - 1):0]),
                        .S_ARBITER_SCHEME(S_ARBITER_SCHEME[2:0]),
                        .S0_BASE_ADDR(S0_BASE_ADDR),
                        .S0_ADDR_RANGE(S0_ADDR_RANGE),
                        .S1_BASE_ADDR(S1_BASE_ADDR),
                        .S1_ADDR_RANGE(S1_ADDR_RANGE),
                        .S2_BASE_ADDR(S2_BASE_ADDR),
                        .S2_ADDR_RANGE(S2_ADDR_RANGE),
                        .S3_BASE_ADDR(S3_BASE_ADDR),
                        .S3_ADDR_RANGE(S3_ADDR_RANGE),
                        .S4_BASE_ADDR(S4_BASE_ADDR),
                        .S4_ADDR_RANGE(S4_ADDR_RANGE),
                        .S5_BASE_ADDR(S5_BASE_ADDR),
                        .S5_ADDR_RANGE(S5_ADDR_RANGE),
                        .S6_BASE_ADDR(S6_BASE_ADDR),
                        .S6_ADDR_RANGE(S6_ADDR_RANGE),
                        .S7_BASE_ADDR(S7_BASE_ADDR),
                        .S7_ADDR_RANGE(S7_ADDR_RANGE),
                        .S8_BASE_ADDR(S8_BASE_ADDR),
                        .S8_ADDR_RANGE(S8_ADDR_RANGE),
                        .S9_BASE_ADDR(S9_BASE_ADDR),
                        .S9_ADDR_RANGE(S9_ADDR_RANGE),
                        .S10_BASE_ADDR(S10_BASE_ADDR),
                        .S10_ADDR_RANGE(S10_ADDR_RANGE),
                        .S11_BASE_ADDR(S11_BASE_ADDR),
                        .S11_ADDR_RANGE(S11_ADDR_RANGE),
                        .S12_BASE_ADDR(S12_BASE_ADDR),
                        .S12_ADDR_RANGE(S12_ADDR_RANGE),
                        .S13_BASE_ADDR(S13_BASE_ADDR),
                        .S13_ADDR_RANGE(S13_ADDR_RANGE),
                        .S14_BASE_ADDR(S14_BASE_ADDR),
                        .S14_ADDR_RANGE(S14_ADDR_RANGE),
                        .S15_BASE_ADDR(S15_BASE_ADDR),
                        .S15_ADDR_RANGE(S15_ADDR_RANGE),
                        .S16_BASE_ADDR(S16_BASE_ADDR),
                        .S16_ADDR_RANGE(S16_ADDR_RANGE),
                        .S17_BASE_ADDR(S17_BASE_ADDR),
                        .S17_ADDR_RANGE(S17_ADDR_RANGE),
                        .S18_BASE_ADDR(S18_BASE_ADDR),
                        .S18_ADDR_RANGE(S18_ADDR_RANGE),
                        .S19_BASE_ADDR(S19_BASE_ADDR),
                        .S19_ADDR_RANGE(S19_ADDR_RANGE),
                        .S20_BASE_ADDR(S20_BASE_ADDR),
                        .S20_ADDR_RANGE(S20_ADDR_RANGE),
                        .S21_BASE_ADDR(S21_BASE_ADDR),
                        .S21_ADDR_RANGE(S21_ADDR_RANGE),
                        .S22_BASE_ADDR(S22_BASE_ADDR),
                        .S22_ADDR_RANGE(S22_ADDR_RANGE),
                        .S23_BASE_ADDR(S23_BASE_ADDR),
                        .S23_ADDR_RANGE(S23_ADDR_RANGE),
                        .S24_BASE_ADDR(S24_BASE_ADDR),
                        .S24_ADDR_RANGE(S24_ADDR_RANGE),
                        .S25_BASE_ADDR(S25_BASE_ADDR),
                        .S25_ADDR_RANGE(S25_ADDR_RANGE),
                        .S26_BASE_ADDR(S26_BASE_ADDR),
                        .S26_ADDR_RANGE(S26_ADDR_RANGE),
                        .S27_BASE_ADDR(S27_BASE_ADDR),
                        .S27_ADDR_RANGE(S27_ADDR_RANGE),
                        .S28_BASE_ADDR(S28_BASE_ADDR),
                        .S28_ADDR_RANGE(S28_ADDR_RANGE),
                        .S29_BASE_ADDR(S29_BASE_ADDR),
                        .S29_ADDR_RANGE(S29_ADDR_RANGE),
                        .S30_BASE_ADDR(S30_BASE_ADDR),
                        .S30_ADDR_RANGE(S30_ADDR_RANGE),
                        .S31_BASE_ADDR(S31_BASE_ADDR),
                        .S31_ADDR_RANGE(S31_ADDR_RANGE)) u_lscc_apb_crossbar (/*AUTOINSTPARAM*/ // Parameters
                        /*AUTOINST*/ // Outputs
                        .apb_pready_slv_o(apb_pready_slv_o[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_pslverr_slv_o(apb_pslverr_slv_o[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_prdata_slv_o(apb_prdata_slv_o[((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0]), 
                            .apb_psel_mstr_o(apb_psel_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_paddr_mstr_o(apb_paddr_mstr_o[((TOTAL_SLAVE_CNT * M_ADDR_WIDTH) - 1):0]), 
                            .apb_pwdata_mstr_o(apb_pwdata_mstr_o[((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0]), 
                            .apb_pwrite_mstr_o(apb_pwrite_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_penable_mstr_o(apb_penable_mstr_o[(TOTAL_SLAVE_CNT - 1):0]), 
                            // Inputs
                        .apb_pclk_i(apb_pclk_i), 
                            .apb_presetn_i(apb_presetn_i), 
                            .apb_psel_slv_i(apb_psel_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_paddr_slv_i(apb_paddr_slv_i[((TOTAL_MASTER_CNT * M_ADDR_WIDTH) - 1):0]), 
                            .apb_pwdata_slv_i(apb_pwdata_slv_i[((TOTAL_MASTER_CNT * DATA_WIDTH) - 1):0]), 
                            .apb_pwrite_slv_i(apb_pwrite_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_penable_slv_i(apb_penable_slv_i[(TOTAL_MASTER_CNT - 1):0]), 
                            .apb_pready_mstr_i(apb_pready_mstr_i[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_pslverr_mstr_i(apb_pslverr_mstr_i[(TOTAL_SLAVE_CNT - 1):0]), 
                            .apb_prdata_mstr_i(apb_prdata_mstr_i[((TOTAL_SLAVE_CNT * DATA_WIDTH) - 1):0])) ; 
            end
    endgenerate
    // ------------------------------------------------------------------------------
    // Function Definition
    // ------------------------------------------------------------------------------
    function integer clog2( 
        input integer depth )  ; 
        begin
            for (clog2 = 0 ; (depth > 0) ; clog2 = (clog2 + 1))
                depth = (depth >> 1) ;
        end
    endfunction
endmodule


