
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Radiant Software (64-bit)
    3.2.0.3.0
    Soft IP Version: 2.0.0
    2022 06 07 13:54:44
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module ctrl_fifo #( 
    parameter DATA_WIDTH = 10
)(
        clk_i, 
        rst_i, 
        wr_en_i, 
        rd_en_i, 
        wr_data_i, 
        full_o, 
        empty_o, 
        rd_data_o) ;
    input clk_i ; 
    input rst_i ; 
    input wr_en_i ; 
    input rd_en_i ; 
    input [DATA_WIDTH-1:0] wr_data_i ; 
    output full_o ; 
    output empty_o ; 
    output [DATA_WIDTH-1:0] rd_data_o ; 
    ctrl_fifo_ipgen_lscc_fifo #(.FAMILY("LAV-AT"),
            .ADDRESS_DEPTH(8),
            .DATA_WIDTH(DATA_WIDTH),
            .FIFO_CONTROLLER("FABRIC"),
            .FORCE_FAST_CONTROLLER(0),
            .FWFT(0),
            .IMPLEMENTATION("LUT"),
            .ADDRESS_WIDTH(3),
            .REGMODE("reg"),
            .RESET_MODE("async"),
            .ENABLE_ALMOST_FULL_FLAG("FALSE"),
            .ALMOST_FULL_ASSERTION("static-dual"),
            .ALMOST_FULL_ASSERT_LVL(7),
            .ALMOST_FULL_DEASSERT_LVL(6),
            .ENABLE_ALMOST_EMPTY_FLAG("FALSE"),
            .ALMOST_EMPTY_ASSERTION("static-dual"),
            .ALMOST_EMPTY_ASSERT_LVL(1),
            .ALMOST_EMPTY_DEASSERT_LVL(2),
            .ENABLE_DATA_COUNT("FALSE")) lscc_fifo_inst (.clk_i(clk_i), 
                .rst_i(rst_i), 
                .wr_en_i(wr_en_i), 
                .rd_en_i(rd_en_i), 
                .wr_data_i(wr_data_i), 
                .almost_full_th_i(3'b111), 
                .almost_full_clr_th_i(3'b111), 
                .almost_empty_th_i(3'b111), 
                .almost_empty_clr_th_i(3'b111), 
                .full_o(full_o), 
                .empty_o(empty_o), 
                .almost_full_o(), 
                .almost_empty_o(), 
                .data_cnt_o(), 
                .rd_data_o(rd_data_o)) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module ctrl_fifo_ipgen_lscc_fifo #(parameter IMPLEMENTATION = "EBR", 
        parameter ADDRESS_DEPTH = 512, 
        parameter ADDRESS_WIDTH = clog2(ADDRESS_DEPTH), 
        parameter DATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter RESET_MODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 1023, 
        parameter ALMOST_FULL_DEASSERT_LVL = 1020, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 4, 
        parameter ENABLE_DATA_COUNT = "FALSE", 
        parameter FAMILY = "common", 
        parameter FIFO_CONTROLLER = "FABRIC", 
        parameter FORCE_FAST_CONTROLLER = 0, 
        parameter FWFT = 0) (
    //----------------------------
    // Parameters
    //----
    //----------------------------
    // Inputs
    //----------------------------
    input clk_i, 
    input [(DATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(DATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [ADDRESS_WIDTH:0] data_cnt_o) ;
    localparam T_FAMILY = ((((((FAMILY == "LFD2NX") || (FAMILY == "LFCPNX")) || (FAMILY == "LFMXO5")) || (FAMILY == "UT24C")) || (FAMILY == "UT24CP")) ? "LIFCL" : FAMILY) ; 
    localparam T_REGMODE = (FWFT ? "noreg" : REGMODE) ; 
    wire empty_w ; 
    wire rden_w ; 
    wire [(DATA_WIDTH - 1):0] d_w ; 
    ctrl_fifo_ipgen_lscc_fifo_fwft_fabric #(.REGMODE(REGMODE),
            .FWFT(FWFT),
            .DWID(DATA_WIDTH)) u_fwft (.clk_i(clk_i), 
                .rst_i(rst_i), 
                .empty_i(empty_w), 
                .rd_en_i(rd_en_i), 
                .d_i(d_w), 
                .empty_o(empty_o), 
                .rden_o(rden_w), 
                .d_o(rd_data_o)) ; 
    ctrl_fifo_ipgen_lscc_fifo_main #(.IMPLEMENTATION(IMPLEMENTATION),
            .ADDRESS_DEPTH(ADDRESS_DEPTH),
            .ADDRESS_WIDTH(ADDRESS_WIDTH),
            .DATA_WIDTH(DATA_WIDTH),
            .REGMODE(T_REGMODE),
            .RESET_MODE(RESET_MODE),
            .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
            .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
            .ALMOST_FULL_ASSERTION(ALMOST_FULL_ASSERTION),
            .ALMOST_FULL_ASSERT_LVL(ALMOST_FULL_ASSERT_LVL),
            .ALMOST_FULL_DEASSERT_LVL(ALMOST_FULL_DEASSERT_LVL),
            .ALMOST_EMPTY_ASSERTION(ALMOST_EMPTY_ASSERTION),
            .ALMOST_EMPTY_ASSERT_LVL(ALMOST_EMPTY_ASSERT_LVL),
            .ALMOST_EMPTY_DEASSERT_LVL(ALMOST_EMPTY_DEASSERT_LVL),
            .ENABLE_DATA_COUNT(ENABLE_DATA_COUNT),
            .FAMILY(T_FAMILY),
            .FIFO_CONTROLLER(FIFO_CONTROLLER),
            .FORCE_FAST_CONTROLLER(FORCE_FAST_CONTROLLER),
            .FWFT(FWFT)) fifo0 (//----------------------------
            // Parameters
            //----
            //----------------------------
            // Inputs
            //----------------------------
            .clk_i(clk_i), 
                .wr_data_i(wr_data_i), 
                .wr_en_i(wr_en_i), 
                .rd_en_i(rden_w), 
                .rst_i(rst_i), 
                .almost_full_th_i(almost_full_th_i), 
                .almost_full_clr_th_i(almost_full_clr_th_i), 
                .almost_empty_th_i(almost_empty_th_i), 
                .almost_empty_clr_th_i(almost_empty_clr_th_i), 
                //----------------------------
            // Outputs
            //----------------------------
            .rd_data_o(d_w), 
                .full_o(full_o), 
                .empty_o(empty_w), 
                .almost_full_o(almost_full_o), 
                .almost_empty_o(almost_empty_o), 
                .data_cnt_o(data_cnt_o)) ; 
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo_fwft_fabric.v
// Title                 :
// Dependencies          :
// Description           : Implements an FWFT logic.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module ctrl_fifo_ipgen_lscc_fifo_fwft_fabric #(parameter REGMODE = "noreg", 
        parameter FWFT = 0, 
        parameter DWID = 32) (
    input clk_i, 
    input rst_i, 
    input empty_i, 
    input rd_en_i, 
    input [(DWID - 1):0] d_i, 
    output empty_o, 
    output rden_o, 
    output [(DWID - 1):0] d_o) ;
    if (FWFT) 
        begin : _FWFT_ENABLE
            wire f0 ; 
            wire f1 ; 
            wire f2 ; 
            wire f3 ; 
            wire RE ; 
            wire REc ; 
            reg q0 ; 
            reg q2 ; 
            reg q3 ; 
            reg REp ; 
            reg [(DWID - 1):0] d_r ; 
            wire [(DWID - 1):0] d_c ; 
            wire CSR ; 
            assign RE = (rd_en_i & (~empty_o)) ; 
            assign f0 = ((empty_i | q0) & (~RE)) ; 
            assign CSR = 3'b111 ; 
            assign f1 = (RE | ((~q2) & f2)) ; 
            assign f2 = (f0 & ((~empty_i) | q2)) ; 
            assign f3 = (empty_i & (q3 | RE)) ; 
            assign rden_o = f1 ; 
            assign empty_o = q3 ; 
            assign REc = (rden_o & (~empty_i)) ; 
            assign d_c = (REp ? d_i : d_r) ; 
            always
                @(posedge clk_i or 
                    posedge rst_i)
                begin
                    if (rst_i) 
                        begin
                            q0 <=  1'b1 ;
                            q2 <=  1'b0 ;
                            q3 <=  1'b1 ;
                            REp <=  1'b0 ;
                            d_r <=  {DWID{1'b0}} ;
                        end
                    else
                        begin
                            q0 <=  f0 ;
                            q2 <=  f2 ;
                            q3 <=  f3 ;
                            REp <=  REc ;
                            d_r <=  d_c ;
                        end
                end
            if ((REGMODE == "noreg")) 
                begin : _NO_REG
                    assign d_o = d_c ; 
                end
            else
                begin : _REG
                    reg [(DWID - 1):0] dd_r ; 
                    wire [(DWID - 1):0] dd_c ; 
                    assign dd_c = (RE ? d_c : dd_r) ; 
                    assign d_o = dd_r ; 
                    always
                        @(posedge clk_i or 
                            posedge rst_i)
                        begin
                            if (rst_i) 
                                begin
                                    dd_r <=  {DWID{1'b0}} ;
                                end
                            else
                                begin
                                    dd_r <=  dd_c ;
                                end
                        end
                end
        end
    else
        begin : _FWFT_DISABLE
            assign empty_o = empty_i ; 
            assign rden_o = rd_en_i ; 
            assign d_o = d_i ; 
        end
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_fifo.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module ctrl_fifo_ipgen_lscc_fifo_main #(parameter IMPLEMENTATION = "EBR", 
        parameter ADDRESS_DEPTH = 512, 
        parameter ADDRESS_WIDTH = clog2(ADDRESS_DEPTH), 
        parameter DATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter RESET_MODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 1023, 
        parameter ALMOST_FULL_DEASSERT_LVL = 1020, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 4, 
        parameter ENABLE_DATA_COUNT = "FALSE", 
        parameter FAMILY = "common", 
        parameter FIFO_CONTROLLER = "FABRIC", 
        parameter FORCE_FAST_CONTROLLER = 0, 
        parameter FWFT = 0) (
    //----------------------------
    // Parameters
    //----
    //----------------------------
    // Inputs
    //----------------------------
    input clk_i, 
    input [(DATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(DATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [ADDRESS_WIDTH:0] data_cnt_o) ;
    if ((FIFO_CONTROLLER == "FABRIC")) 
        begin : _FABRIC
            ctrl_fifo_ipgen_lscc_soft_fifo #(.IMPLEMENTATION(IMPLEMENTATION),
                    .ADDRESS_DEPTH(ADDRESS_DEPTH),
                    .ADDRESS_WIDTH(ADDRESS_WIDTH),
                    .DATA_WIDTH(DATA_WIDTH),
                    .REGMODE(REGMODE),
                    .RESET_MODE(RESET_MODE),
                    .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                    .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                    .ALMOST_FULL_ASSERTION(ALMOST_FULL_ASSERTION),
                    .ALMOST_FULL_ASSERT_LVL(ALMOST_FULL_ASSERT_LVL),
                    .ALMOST_FULL_DEASSERT_LVL(ALMOST_FULL_DEASSERT_LVL),
                    .ALMOST_EMPTY_ASSERTION(ALMOST_EMPTY_ASSERTION),
                    .ALMOST_EMPTY_ASSERT_LVL(ALMOST_EMPTY_ASSERT_LVL),
                    .ALMOST_EMPTY_DEASSERT_LVL(ALMOST_EMPTY_DEASSERT_LVL),
                    .ENABLE_DATA_COUNT(ENABLE_DATA_COUNT),
                    .FAMILY(FAMILY)) u_fifo (.clk_i(clk_i), 
                        .wr_data_i(wr_data_i), 
                        .wr_en_i(wr_en_i), 
                        .rd_en_i(rd_en_i), 
                        .rst_i(rst_i), 
                        .almost_full_th_i(almost_full_th_i), 
                        .almost_full_clr_th_i(almost_full_clr_th_i), 
                        .almost_empty_th_i(almost_empty_th_i), 
                        .almost_empty_clr_th_i(almost_empty_clr_th_i), 
                        .rd_data_o(rd_data_o), 
                        .full_o(full_o), 
                        .empty_o(empty_o), 
                        .almost_full_o(almost_full_o), 
                        .almost_empty_o(almost_empty_o), 
                        .data_cnt_o(data_cnt_o)) ; 
        end
    else
        begin : _HARD_IP
            ctrl_fifo_ipgen_lscc_hard_fifo_dc #(.IMPLEMENTATION(IMPLEMENTATION),
                    .WADDR_DEPTH(ADDRESS_DEPTH),
                    .WADDR_WIDTH(ADDRESS_WIDTH),
                    .WDATA_WIDTH(DATA_WIDTH),
                    .RADDR_DEPTH(ADDRESS_DEPTH),
                    .RADDR_WIDTH(ADDRESS_WIDTH),
                    .RDATA_WIDTH(DATA_WIDTH),
                    .REGMODE(REGMODE),
                    .RESETMODE(RESET_MODE),
                    .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                    .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                    .ALMOST_FULL_ASSERTION(ALMOST_FULL_ASSERTION),
                    .ALMOST_FULL_ASSERT_LVL(ALMOST_FULL_ASSERT_LVL),
                    .ALMOST_FULL_DEASSERT_LVL(ALMOST_FULL_DEASSERT_LVL),
                    .ALMOST_EMPTY_ASSERTION(ALMOST_EMPTY_ASSERTION),
                    .ALMOST_EMPTY_ASSERT_LVL(ALMOST_EMPTY_ASSERT_LVL),
                    .ALMOST_EMPTY_DEASSERT_LVL(ALMOST_EMPTY_DEASSERT_LVL),
                    .ECC_ENABLE(0),
                    .FAMILY(FAMILY),
                    .FORCE_FAST_CONTROLLER(FORCE_FAST_CONTROLLER),
                    .FWFT(FWFT)) u_fifo (//----------------------------
                    // Inputs
                    //----------------------------
                    .wr_clk_i(clk_i), 
                        .rd_clk_i(clk_i), 
                        .wr_data_i(wr_data_i), 
                        .wr_en_i(wr_en_i), 
                        .rd_en_i(rd_en_i), 
                        .rst_i(rst_i), 
                        .rp_rst_i(rst_i), 
                        .almost_full_th_i(almost_full_th_i), 
                        .almost_full_clr_th_i(almost_full_clr_th_i), 
                        .almost_empty_th_i(almost_empty_th_i), 
                        .almost_empty_clr_th_i(almost_empty_clr_th_i), 
                        //----------------------------
                    // Outputs
                    //----------------------------
                    .rd_data_o(rd_data_o), 
                        .full_o(full_o), 
                        .empty_o(empty_o), 
                        .almost_full_o(almost_full_o), 
                        .almost_empty_o(almost_empty_o), 
                        .wr_data_cnt_o(), 
                        .rd_data_cnt_o(), 
                        .one_err_det_o(), 
                        .two_err_det_o()) ; 
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 2.1
// File                  : lscc_hard_fifo_dc.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO using an internal 
//                         controller
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module ctrl_fifo_ipgen_lscc_hard_fifo_dc #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_ICE_ = 2, 
        parameter _FCODE_AP6_ = 3, 
        parameter _FCODE_COMMON_ = 0, 
        parameter IMPLEMENTATION = "EBR", 
        parameter FAMILY = "LIFCL", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : ((FAMILY == "iCE40UP") ? _FCODE_ICE_ : (((FAMILY == "LATG1") || (FAMILY == "LAV-AT")) ? _FCODE_AP6_ : _FCODE_COMMON_))), 
        parameter WADDR_DEPTH = 16384, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 16, 
        parameter RADDR_DEPTH = 8192, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 32, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter INIT_FILE = "none", 
        parameter INIT_MODE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 511, 
        parameter ALMOST_FULL_DEASSERT_LVL = 510, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ECC_ENABLE = 0, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter FORCE_FAST_CONTROLLER = 0, 
        parameter FWFT = 0) (
    //----------------------------
    // Inputs
    //----------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_th_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [WADDR_WIDTH:0] wr_data_cnt_o, 
    output [RADDR_WIDTH:0] rd_data_cnt_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    //--end_ports--
    genvar i0, 
        i1 ; 
    generate
        if ((WDATA_WIDTH == RDATA_WIDTH)) 
            begin : _SAME_WIDTH
                localparam OPT_DATA_WIDTH = getMinFIFO(WADDR_DEPTH,
                            WDATA_WIDTH,
                            ECC_ENABLE,
                            FAMILY_CODE,
                            FORCE_FAST_CONTROLLER) ; 
                localparam OPT_ADDR_DEPTH = data_to_addr(OPT_DATA_WIDTH,
                            FAMILY_CODE) ; 
                localparam FIFO_DATA = roundUP(WDATA_WIDTH,
                            OPT_DATA_WIDTH) ; 
                localparam FIFO_ADDR = roundUP(WADDR_DEPTH,
                            OPT_ADDR_DEPTH) ; 
                localparam FULL_PER_EBR = roundUP(WADDR_DEPTH,
                            FIFO_ADDR) ; 
                localparam AFULL_PER_EBR = roundUP(ALMOST_FULL_ASSERT_LVL,
                            FIFO_ADDR) ; 
                localparam AEMPTY_PER_EBR = (ALMOST_EMPTY_ASSERT_LVL / FIFO_ADDR) ; 
                localparam FULL_CNT = (WADDR_DEPTH % FIFO_ADDR) ; 
                localparam AF_FLAG_CNT = (ALMOST_FULL_ASSERT_LVL % FIFO_ADDR) ; 
                localparam AE_FLAG_CNT = (FIFO_ADDR - (ALMOST_EMPTY_ASSERT_LVL % FIFO_ADDR)) ; 
                localparam IS_CASCADE = (FIFO_ADDR > 1) ; 
                reg [(FIFO_ADDR - 1):0] wr_pong_r ; 
                reg [(FIFO_ADDR - 1):0] rd_pong_r ; 
                reg [(FIFO_ADDR - 1):0] wr_pong_nxt_c ; 
                reg [(FIFO_ADDR - 1):0] rd_pong_nxt_c ; 
                wire [(RDATA_WIDTH - 1):0] rd_data_raw_w [(FIFO_ADDR - 1):0] ; 
                wire [(FIFO_ADDR - 1):0] full_out_w ; 
                wire [(FIFO_ADDR - 1):0] afull_out_w ; 
                wire [(FIFO_ADDR - 1):0] empty_out_w ; 
                wire [(FIFO_ADDR - 1):0] aempty_out_w ; 
                wire [(FIFO_ADDR - 1):0] one_err_det_out_w ; 
                wire [(FIFO_ADDR - 1):0] two_err_det_out_w ; 
                for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                begin : _FIFO_ADDR
                    // ------ Read Port ------
                    wire [(RDATA_WIDTH - 1):0] fifo_out_raw_w ; 
                    assign rd_data_raw_w[i0] = fifo_out_raw_w ; 
                    wire wr_fifo_w ; 
                    wire rd_fifo_w ; 
                    if ((FIFO_ADDR == 1)) 
                        begin : genblk1
                            assign wr_fifo_w = wr_en_i ; 
                            assign rd_fifo_w = rd_en_i ; 
                        end
                    else
                        begin : genblk1
                            assign wr_fifo_w = (wr_pong_r[i0] & wr_en_i) ; 
                            assign rd_fifo_w = (rd_pong_r[i0] & rd_en_i) ; 
                        end
                    wire [(FIFO_DATA - 1):0] one_err_det_raw_w ; 
                    wire [(FIFO_DATA - 1):0] two_err_det_raw_w ; 
                    assign one_err_det_out_w[i0] = (|one_err_det_raw_w) ; 
                    assign two_err_det_out_w[i0] = (|two_err_det_raw_w) ; 
                    for (i1 = 0;(i1 < FIFO_DATA);i1 = (i1 + 1))
                    begin : _FIFO_DATA
                        wire [(OPT_DATA_WIDTH - 1):0] in_fifo_w ; 
                        wire [(OPT_DATA_WIDTH - 1):0] out_fifo_w ; 
                        wire loc_full_w ; 
                        wire loc_empty_w ; 
                        wire loc_afull_w ; 
                        wire loc_aempty_w ; 
                        if (((OPT_DATA_WIDTH * (i1 + 1)) < WDATA_WIDTH)) 
                            begin : genblk1
                                assign in_fifo_w = wr_data_i[(OPT_DATA_WIDTH * i1) +: OPT_DATA_WIDTH] ; 
                                assign fifo_out_raw_w[(OPT_DATA_WIDTH * i1) +: OPT_DATA_WIDTH] = out_fifo_w ; 
                            end
                        else
                            begin : genblk1
                                assign in_fifo_w[(WDATA_WIDTH - (1 + (OPT_DATA_WIDTH * i1))):0] = wr_data_i[(WDATA_WIDTH - 1):(OPT_DATA_WIDTH * i1)] ; 
                                if ((OPT_DATA_WIDTH > (WDATA_WIDTH - (OPT_DATA_WIDTH * i1)))) 
                                    begin : genblk1
                                        assign in_fifo_w[(OPT_DATA_WIDTH - 1):(WDATA_WIDTH - (OPT_DATA_WIDTH * i1))] = {(OPT_DATA_WIDTH - (WDATA_WIDTH - (OPT_DATA_WIDTH * i1))){1'b0}} ; 
                                    end
                                assign fifo_out_raw_w[(RDATA_WIDTH - 1):(OPT_DATA_WIDTH * i1)] = out_fifo_w[(RDATA_WIDTH - (1 + (OPT_DATA_WIDTH * i1))):0] ; 
                            end
                        ctrl_fifo_ipgen_lscc_fifo_hw_core #(.FAMILY(FAMILY),
                                .WADDR_DEPTH(FULL_PER_EBR),
                                .WDATA_WIDTH(OPT_DATA_WIDTH),
                                .RADDR_DEPTH(FULL_PER_EBR),
                                .RDATA_WIDTH(OPT_DATA_WIDTH),
                                .REGMODE(REGMODE),
                                .RESETMODE(RESETMODE),
                                .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                                .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                                .ALMOST_FULL_ASSERTION("static-dual"),
                                .ALMOST_FULL_ASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_FULL_DEASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_EMPTY_ASSERTION("static-dual"),
                                .ALMOST_EMPTY_ASSERT_LVL(AEMPTY_PER_EBR),
                                .ALMOST_EMPTY_DEASSERT_LVL(AEMPTY_PER_EBR),
                                .ENABLE_DATA_COUNT_WR("FALSE"),
                                .ENABLE_DATA_COUNT_RD("FALSE"),
                                .ECC_ENABLE(ECC_ENABLE),
                                .IS_CASCADE(IS_CASCADE),
                                .FWFT(FWFT)) u_fifo (.wr_clk_i(wr_clk_i), 
                                    .wr_en_i(wr_fifo_w), 
                                    .wr_data_i(in_fifo_w), 
                                    .rd_clk_i(rd_clk_i), 
                                    .rd_en_i(rd_fifo_w), 
                                    .rst_i(rst_i), 
                                    .rp_rst_i(rp_rst_i), 
                                    .full_cascade_i(full_o), 
                                    .rd_data_o(out_fifo_w), 
                                    .full_o(loc_full_w), 
                                    .empty_o(loc_empty_w), 
                                    .almost_full_o(loc_afull_w), 
                                    .almost_empty_o(loc_aempty_w), 
                                    .one_err_det_o(one_err_det_raw_w[i1]), 
                                    .two_err_det_o(two_err_det_raw_w[i1])) ; 
                        if ((i1 == 0)) 
                            begin : genblk2
                                assign full_out_w[i0] = loc_full_w ; 
                                assign afull_out_w[i0] = loc_afull_w ; 
                                assign empty_out_w[i0] = loc_empty_w ; 
                                assign aempty_out_w[i0] = loc_aempty_w ; 
                            end
                    end
                end
                if ((FIFO_ADDR == 1)) 
                    begin : _SING_DEPTH
                        assign full_o = full_out_w[0] ; 
                        assign empty_o = empty_out_w[0] ; 
                        assign rd_data_o = rd_data_raw_w[0] ; 
                        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                            begin : genblk1
                                assign almost_full_o = afull_out_w[0] ; 
                            end
                        else
                            begin : genblk1
                                assign almost_full_o = 1'b0 ; 
                            end
                        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                            begin : genblk2
                                assign almost_empty_o = aempty_out_w[0] ; 
                            end
                        else
                            begin : genblk2
                                assign almost_empty_o = 1'b0 ; 
                            end
                        if (ECC_ENABLE) 
                            begin : genblk3
                                assign one_err_det_o = one_err_det_out_w[0] ; 
                                assign two_err_det_o = two_err_det_out_w[0] ; 
                            end
                        else
                            begin : genblk3
                                assign one_err_det_o = 1'b0 ; 
                                assign two_err_det_o = 1'b0 ; 
                            end
                    end
                else
                    begin : _MULT_DEPTH
                        reg [(FIFO_ADDR - 1):0] rd_pong_p_r ; 
                        always
                            @(*)
                            begin
                                wr_pong_nxt_c = wr_pong_r ;
                                if ((wr_en_i & (!full_o))) 
                                    begin
                                        wr_pong_nxt_c = (wr_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} : (wr_pong_r << 1)) ;
                                    end
                            end
                        always
                            @(*)
                            begin
                                rd_pong_nxt_c = rd_pong_r ;
                                if ((rd_en_i & (!empty_o))) 
                                    begin
                                        rd_pong_nxt_c = (rd_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} : (rd_pong_r << 1)) ;
                                    end
                            end
                        always
                            @(posedge wr_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        wr_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} ;
                                    end
                                else
                                    begin
                                        wr_pong_r <=  wr_pong_nxt_c ;
                                    end
                            end
                        always
                            @(posedge rd_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        rd_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                1'b1} ;
                                    end
                                else
                                    begin
                                        rd_pong_r <=  rd_pong_nxt_c ;
                                    end
                            end
                        if ((REGMODE == "noreg")) 
                            begin : _NREG
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        else
                            begin : _REG
                                reg [(FIFO_ADDR - 1):0] rd_pong_pr_r ; 
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                rd_pong_pr_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_pr_r ;
                                                rd_pong_pr_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        for (i0 = 0;(i0 < RDATA_WIDTH);i0 = (i0 + 1))
                        begin : genblk2
                            wire [(FIFO_ADDR - 1):0] translate_rd_data_w ; 
                            assign rd_data_o[i0] = (|translate_rd_data_w) ; 
                            for (i1 = 0;(i1 < FIFO_ADDR);i1 = (i1 + 1))
                            begin : genblk1
                                wire [(RDATA_WIDTH - 1):0] sampled_rd_data_w ; 
                                assign sampled_rd_data_w = (rd_pong_p_r[i1] ? rd_data_raw_w[i1] : {RDATA_WIDTH{1'b0}}) ; 
                                assign translate_rd_data_w[i1] = sampled_rd_data_w[i0] ; 
                            end
                        end
                        if (ECC_ENABLE) 
                            begin : genblk3
                                wire [(FIFO_ADDR - 1):0] one_todet_out_w ; 
                                wire [(FIFO_ADDR - 1):0] two_todet_out_w ; 
                                assign one_err_det_o = (|one_todet_out_w) ; 
                                assign two_err_det_o = (|two_todet_out_w) ; 
                                for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                begin : genblk1
                                    assign one_todet_out_w = (rd_pong_p_r[i0] & one_err_det_out_w[i0]) ; 
                                    assign two_todet_out_w = (rd_pong_p_r[i0] & one_err_det_out_w[i0]) ; 
                                end
                            end
                        else
                            begin : genblk3
                                assign one_err_det_o = 1'b0 ; 
                                assign two_err_det_o = 1'b0 ; 
                            end
                        assign empty_o = (&empty_out_w) ; 
                        if ((FULL_CNT == 0)) 
                            begin : _FIX_FULL
                                assign full_o = (&full_out_w) ; 
                            end
                        else
                            if ((FULL_CNT == 1)) 
                                begin : _SING_FULL
                                    assign full_o = (|full_out_w) ; 
                                end
                            else
                                begin : _MULT_FULL
                                    wire [(FIFO_ADDR - 1):0] full_expand_w ; 
                                    assign full_o = (|full_expand_w) ; 
                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                    begin : _EXP_FULL_FLAG
                                        wire [(FULL_CNT - 1):0] nterm_and_w ; 
                                        assign full_expand_w[i0] = (&nterm_and_w) ; 
                                        for (i1 = 0;(i1 < FULL_CNT);i1 = (i1 + 1))
                                        begin : _MULT_NTERM
                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                begin : genblk1
                                                    assign nterm_and_w[i1] = full_out_w[(i0 + i1)] ; 
                                                end
                                            else
                                                begin : genblk1
                                                    assign nterm_and_w[i1] = full_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                end
                                        end
                                    end
                                end
                        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                            begin : _EN_AF_FLAG
                                if ((AF_FLAG_CNT == 0)) 
                                    begin : _FIX_AF_FLAG
                                        assign almost_full_o = (&afull_out_w) ; 
                                    end
                                else
                                    if ((AF_FLAG_CNT == 1)) 
                                        begin : _SING_AF_FLAG
                                            assign almost_full_o = (|afull_out_w) ; 
                                        end
                                    else
                                        begin : genblk1
                                            wire [(FIFO_ADDR - 1):0] afull_expand_w ; 
                                            assign almost_full_o = (|afull_expand_w) ; 
                                            for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                            begin : genblk1
                                                wire [(AF_FLAG_CNT - 1):0] nterm_and_w ; 
                                                assign afull_expand_w[i0] = (&nterm_and_w) ; 
                                                for (i1 = 0;(i1 < AF_FLAG_CNT);i1 = (i1 + 1))
                                                begin : genblk1
                                                    if (((i0 + i1) < FIFO_ADDR)) 
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = afull_out_w[(i0 + i1)] ; 
                                                        end
                                                    else
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = afull_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                        end
                                                end
                                            end
                                        end
                            end
                        else
                            begin : _DIS_AF_FLAG
                                assign almost_full_o = 1'b0 ; 
                            end
                        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                            begin : _EN_AE_FLAG
                                if ((AE_FLAG_CNT == 0)) 
                                    begin : _FIX_AE_FLAG
                                        assign almost_empty_o = (&aempty_out_w) ; 
                                    end
                                else
                                    if ((AE_FLAG_CNT == 1)) 
                                        begin : _SING_AE_FLAG
                                            assign almost_empty_o = (|aempty_out_w) ; 
                                        end
                                    else
                                        begin : _MULT_AE_FLAG
                                            wire [(FIFO_ADDR - 1):0] aempty_expand_w ; 
                                            assign almost_empty_o = (|aempty_expand_w) ; 
                                            for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                            begin : _EXP_AEFLAG
                                                wire [(AE_FLAG_CNT - 1):0] nterm_and_w ; 
                                                assign aempty_expand_w[i0] = (&nterm_and_w) ; 
                                                for (i1 = 0;(i1 < AE_FLAG_CNT);i1 = (i1 + 1))
                                                begin : _MULT_NTERM
                                                    if (((i0 + i1) < FIFO_ADDR)) 
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = aempty_out_w[(i0 + i1)] ; 
                                                        end
                                                    else
                                                        begin : genblk1
                                                            assign nterm_and_w[i1] = aempty_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                        end
                                                end
                                            end
                                        end
                            end
                        else
                            begin : _DIS_AE_FLAG
                                assign almost_empty_o = 1'b0 ; 
                            end
                    end
            end
        else
            begin : _MIXED_WIDTH
                assign one_err_det_o = 1'b0 ; 
                assign two_err_det_o = 1'b0 ; 
                localparam IS_W_GREATER = (WDATA_WIDTH > RDATA_WIDTH) ; 
                localparam Q_FACTOR = (IS_W_GREATER ? (WDATA_WIDTH / RDATA_WIDTH) : (RDATA_WIDTH / WDATA_WIDTH)) ; 
                localparam MAX_DATA = (IS_W_GREATER ? WDATA_WIDTH : RDATA_WIDTH) ; 
                localparam MIN_DEPTH = (IS_W_GREATER ? WADDR_DEPTH : RADDR_DEPTH) ; 
                localparam PROC_MAX_DATA = procData(MAX_DATA,
                            FAMILY_CODE) ; 
                localparam PROC_MIN_DATA = (PROC_MAX_DATA / Q_FACTOR) ; 
                localparam W_DWID_USE = (IS_W_GREATER ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                localparam R_DWID_USE = (IS_W_GREATER ? PROC_MIN_DATA : PROC_MAX_DATA) ; 
                localparam W_DWID_IMPL = getDWIDImpl(WADDR_DEPTH,
                            WDATA_WIDTH,
                            RADDR_DEPTH,
                            RDATA_WIDTH,
                            1'b1,
                            FAMILY_CODE,
                            FORCE_FAST_CONTROLLER) ; 
                localparam W_ADEPTH_IMPL = data_to_addr(W_DWID_IMPL,
                            FAMILY_CODE) ; 
                localparam R_DWID_IMPL = getDWIDImpl(WADDR_DEPTH,
                            WDATA_WIDTH,
                            RADDR_DEPTH,
                            RDATA_WIDTH,
                            1'b0,
                            FAMILY_CODE,
                            FORCE_FAST_CONTROLLER) ; 
                localparam R_ADEPTH_IMPL = data_to_addr(R_DWID_IMPL,
                            FAMILY_CODE) ; 
                localparam FIFO_DATA = roundUP(WDATA_WIDTH,
                            W_DWID_IMPL) ; 
                localparam FIFO_ADDR = roundUP(WADDR_DEPTH,
                            W_ADEPTH_IMPL) ; 
                localparam FULL_PER_EBR = getFullFlag(WADDR_DEPTH,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b0) ; 
                localparam FULL_CNT = getFullFlag(WADDR_DEPTH,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b1) ; 
                localparam AFULL_PER_EBR = getAFullFlag(ALMOST_FULL_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b0) ; 
                localparam AF_FLAG_CNT = getAFullFlag(ALMOST_FULL_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b1) ; 
                localparam AEMPTY_PER_EBR = getAEmptyFlag(ALMOST_EMPTY_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b0) ; 
                localparam AE_NUM_TERMS = getAEmptyFlag(ALMOST_EMPTY_ASSERT_LVL,
                            FIFO_ADDR,
                            Q_FACTOR,
                            IS_W_GREATER,
                            1'b1) ; 
                localparam NUM_TERMS = (WADDR_DEPTH % FIFO_ADDR) ; 
                localparam IS_CASCADE = (FIFO_ADDR > 1) ; 
                reg [(FIFO_ADDR - 1):0] wr_pong_r ; 
                reg [(FIFO_ADDR - 1):0] rd_pong_r ; 
                wire [(W_DWID_USE - 1):0] wr_top_w ; 
                wire [(R_DWID_USE - 1):0] rd_top_w ; 
                wire [(W_DWID_USE - 1):0] wr_fifo_w ; 
                wire [(R_DWID_USE - 1):0] rd_fifo_w ; 
                wire [(R_DWID_USE - 1):0] rd_data_raw_w [(FIFO_ADDR - 1):0] ; 
                wire [(FIFO_ADDR - 1):0] full_out_w ; 
                wire [(FIFO_ADDR - 1):0] afull_out_w ; 
                wire [(FIFO_ADDR - 1):0] empty_out_w ; 
                wire [(FIFO_ADDR - 1):0] aempty_out_w ; 
                if (IS_W_GREATER) 
                    begin : _W_OVR_R
                        assign rd_data_o = rd_fifo_w[(RDATA_WIDTH - 1):0] ; 
                        for (i0 = 0;(i0 < Q_FACTOR);i0 = (i0 + 1))
                        begin : genblk1
                            wire [(R_DWID_USE - 1):0] conn_w ; 
                            assign conn_w[(RDATA_WIDTH - 1):0] = wr_data_i[(RDATA_WIDTH * i0) +: RDATA_WIDTH] ; 
                            if ((R_DWID_USE > RDATA_WIDTH)) 
                                begin : genblk1
                                    assign conn_w[(R_DWID_USE - 1):RDATA_WIDTH] = {(R_DWID_USE - RDATA_WIDTH){1'b0}} ; 
                                end
                            assign wr_top_w[(R_DWID_USE * i0) +: R_DWID_USE] = conn_w ; 
                        end
                        wire [(R_DWID_IMPL - 1):0] fifo_seg_w [((W_DWID_USE / R_DWID_IMPL) - 1):0] ; 
                        for (i0 = 0;(i0 < FIFO_DATA);i0 = (i0 + 1))
                        begin : genblk2
                            for (i1 = 0;(i1 < (W_DWID_USE / (R_DWID_IMPL * FIFO_DATA)));i1 = (i1 + 1))
                            begin : genblk1
                                assign fifo_seg_w[(((W_DWID_USE / (R_DWID_IMPL * FIFO_DATA)) * i0) + i1)] = wr_top_w[((i0 * R_DWID_IMPL) + ((i1 * FIFO_DATA) * R_DWID_IMPL)) +: R_DWID_IMPL] ; 
                            end
                        end
                        for (i0 = 0;(i0 < (W_DWID_USE / R_DWID_IMPL));i0 = (i0 + 1))
                        begin : genblk3
                            assign wr_fifo_w[(i0 * R_DWID_IMPL) +: R_DWID_IMPL] = fifo_seg_w[i0] ; 
                        end
                        if ((FIFO_ADDR > 1)) 
                            begin : _MULT_PONG
                                localparam RD_CNTR = (Q_FACTOR - 1) ; 
                                localparam RD_CTR_WID = clog2(RD_CNTR) ; 
                                reg [(FIFO_ADDR - 1):0] wr_pong_nxt_c ; 
                                reg [(FIFO_ADDR - 1):0] rd_pong_nxt_c ; 
                                reg [(RD_CTR_WID - 1):0] rd_ctr_r ; 
                                reg [(RD_CTR_WID - 1):0] rd_ctr_nxt_c ; 
                                always
                                    @(*)
                                    begin
                                        wr_pong_nxt_c = wr_pong_r ;
                                        if ((wr_en_i & (~full_o))) 
                                            begin
                                                wr_pong_nxt_c = (wr_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (wr_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        rd_pong_nxt_c = rd_pong_r ;
                                        if (((rd_en_i & (~empty_o)) & (rd_ctr_r == RD_CNTR))) 
                                            begin
                                                rd_pong_nxt_c = (rd_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (rd_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        rd_ctr_nxt_c = rd_ctr_r ;
                                        if ((rd_en_i & (~empty_o))) 
                                            begin
                                                rd_ctr_nxt_c = ((rd_ctr_r == RD_CNTR) ? {RD_CTR_WID{1'b0}} : (rd_ctr_r + 1'b1)) ;
                                            end
                                    end
                                always
                                    @(posedge wr_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                wr_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                wr_pong_r <=  wr_pong_nxt_c ;
                                            end
                                    end
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                rd_ctr_r <=  {RD_CTR_WID{1'b0}} ;
                                            end
                                        else
                                            begin
                                                rd_pong_r <=  rd_pong_nxt_c ;
                                                rd_ctr_r <=  rd_ctr_nxt_c ;
                                            end
                                    end
                            end
                    end
                else
                    begin : _R_OVR_W
                        assign wr_fifo_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                        if ((W_DWID_USE > WDATA_WIDTH)) 
                            begin : genblk1
                                assign wr_fifo_w[(W_DWID_USE - 1):WDATA_WIDTH] = {(W_DWID_USE - WDATA_WIDTH){1'b0}} ; 
                            end
                        for (i0 = 0;(i0 < Q_FACTOR);i0 = (i0 + 1))
                        begin : genblk2
                            wire [(W_DWID_USE - 1):0] conn_w ; 
                            assign conn_w = rd_top_w[(W_DWID_USE * i0) +: W_DWID_USE] ; 
                            assign rd_data_o[(WDATA_WIDTH * i0) +: WDATA_WIDTH] = conn_w[(WDATA_WIDTH - 1):0] ; 
                        end
                        wire [(W_DWID_IMPL - 1):0] fifo_seg_w [((R_DWID_USE / W_DWID_IMPL) - 1):0] ; 
                        for (i0 = 0;(i0 < Q_FACTOR);i0 = (i0 + 1))
                        begin : genblk3
                            for (i1 = 0;(i1 < FIFO_DATA);i1 = (i1 + 1))
                            begin : genblk1
                                assign fifo_seg_w[((i0 * FIFO_DATA) + i1)] = rd_fifo_w[((i1 * R_DWID_IMPL) + (i0 * W_DWID_IMPL)) +: W_DWID_IMPL] ; 
                            end
                        end
                        for (i0 = 0;(i0 < (R_DWID_USE / W_DWID_IMPL));i0 = (i0 + 1))
                        begin : genblk4
                            assign rd_top_w[(i0 * W_DWID_IMPL) +: W_DWID_IMPL] = fifo_seg_w[i0] ; 
                        end
                        if ((FIFO_ADDR > 1)) 
                            begin : _MULT_PONG
                                localparam WR_CNTR = (Q_FACTOR - 1) ; 
                                localparam WR_CTR_WID = clog2(WR_CNTR) ; 
                                reg [(FIFO_ADDR - 1):0] wr_pong_nxt_c ; 
                                reg [(FIFO_ADDR - 1):0] rd_pong_nxt_c ; 
                                reg [(WR_CTR_WID - 1):0] wr_ctr_r ; 
                                reg [(WR_CTR_WID - 1):0] wr_ctr_nxt_c ; 
                                always
                                    @(*)
                                    begin
                                        wr_pong_nxt_c = wr_pong_r ;
                                        if (((wr_en_i & (~full_o)) & (wr_ctr_r == WR_CNTR))) 
                                            begin
                                                wr_pong_nxt_c = (wr_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (wr_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        rd_pong_nxt_c = rd_pong_r ;
                                        if ((rd_en_i & (~empty_o))) 
                                            begin
                                                rd_pong_nxt_c = (rd_pong_r[(FIFO_ADDR - 1)] ? {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} : (rd_pong_r << 1)) ;
                                            end
                                    end
                                always
                                    @(*)
                                    begin
                                        wr_ctr_nxt_c = wr_ctr_r ;
                                        if ((wr_en_i & (~full_o))) 
                                            begin
                                                wr_ctr_nxt_c = ((wr_ctr_r == WR_CNTR) ? {WR_CTR_WID{1'b0}} : (wr_ctr_r + 1'b1)) ;
                                            end
                                    end
                                always
                                    @(posedge wr_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                wr_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                wr_ctr_r <=  {WR_CTR_WID{1'b0}} ;
                                            end
                                        else
                                            begin
                                                wr_pong_r <=  wr_pong_nxt_c ;
                                                wr_ctr_r <=  wr_ctr_nxt_c ;
                                            end
                                    end
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_r <=  rd_pong_nxt_c ;
                                            end
                                    end
                            end
                    end
                for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                begin : _EXP_ADDR
                    // ------ Read Port ------
                    wire [(RDATA_WIDTH - 1):0] fifo_out_raw_w ; 
                    assign rd_data_raw_w[i0] = fifo_out_raw_w ; 
                    wire wr_en_w ; 
                    wire rd_en_w ; 
                    if ((FIFO_ADDR == 1)) 
                        begin : genblk1
                            assign wr_en_w = wr_en_i ; 
                            assign rd_en_w = rd_en_i ; 
                        end
                    else
                        begin : genblk1
                            assign wr_en_w = (wr_pong_r[i0] & wr_en_i) ; 
                            assign rd_en_w = (rd_pong_r[i0] & rd_en_i) ; 
                        end
                    for (i1 = 0;(i1 < FIFO_DATA);i1 = (i1 + 1))
                    begin : _EXP_DATA
                        wire [(W_DWID_IMPL - 1):0] in_fifo_w ; 
                        wire [(R_DWID_IMPL - 1):0] out_fifo_w ; 
                        wire loc_full_w ; 
                        wire loc_empty_w ; 
                        wire loc_afull_w ; 
                        wire loc_aempty_w ; 
                        if (((W_DWID_IMPL * (i1 + 1)) < W_DWID_USE)) 
                            begin : genblk1
                                assign in_fifo_w = wr_fifo_w[(W_DWID_IMPL * i1) +: W_DWID_IMPL] ; 
                                assign fifo_out_raw_w[(R_DWID_IMPL * i1) +: R_DWID_IMPL] = out_fifo_w ; 
                            end
                        else
                            begin : genblk1
                                assign in_fifo_w[(W_DWID_USE - (1 + (W_DWID_IMPL * i1))):0] = wr_fifo_w[(W_DWID_USE - 1):(W_DWID_IMPL * i1)] ; 
                                if ((W_DWID_IMPL > (W_DWID_USE - (W_DWID_IMPL * i1)))) 
                                    begin : genblk1
                                        assign in_fifo_w[(W_DWID_IMPL - 1):(W_DWID_USE - (W_DWID_IMPL * i1))] = {(W_DWID_IMPL - (W_DWID_USE - (W_DWID_IMPL * i1))){1'b0}} ; 
                                    end
                                assign fifo_out_raw_w[(R_DWID_USE - 1):(R_DWID_IMPL * i1)] = out_fifo_w[(R_DWID_USE - (1 + (R_DWID_IMPL * i1))):0] ; 
                            end
                        ctrl_fifo_ipgen_lscc_fifo_hw_core #(.FAMILY(FAMILY),
                                .WADDR_DEPTH(FULL_PER_EBR),
                                .WDATA_WIDTH(W_DWID_IMPL),
                                .RADDR_DEPTH(FULL_PER_EBR),
                                .RDATA_WIDTH(R_DWID_IMPL),
                                .REGMODE(REGMODE),
                                .RESETMODE(RESETMODE),
                                .ENABLE_ALMOST_FULL_FLAG(ENABLE_ALMOST_FULL_FLAG),
                                .ENABLE_ALMOST_EMPTY_FLAG(ENABLE_ALMOST_EMPTY_FLAG),
                                .ALMOST_FULL_ASSERTION("static-dual"),
                                .ALMOST_FULL_ASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_FULL_DEASSERT_LVL(AFULL_PER_EBR),
                                .ALMOST_EMPTY_ASSERTION("static-dual"),
                                .ALMOST_EMPTY_ASSERT_LVL(AEMPTY_PER_EBR),
                                .ALMOST_EMPTY_DEASSERT_LVL(AEMPTY_PER_EBR),
                                .ENABLE_DATA_COUNT_WR("FALSE"),
                                .ENABLE_DATA_COUNT_RD("FALSE"),
                                .ECC_ENABLE(ECC_ENABLE),
                                .IS_CASCADE(IS_CASCADE),
                                .FWFT(FWFT)) u_fifo (.wr_clk_i(wr_clk_i), 
                                    .wr_en_i(wr_en_w), 
                                    .wr_data_i(in_fifo_w), 
                                    .rd_clk_i(rd_clk_i), 
                                    .rd_en_i(rd_en_w), 
                                    .rst_i(rst_i), 
                                    .rp_rst_i(rp_rst_i), 
                                    .full_cascade_i(full_o), 
                                    .rd_data_o(out_fifo_w), 
                                    .full_o(loc_full_w), 
                                    .empty_o(loc_empty_w), 
                                    .almost_full_o(loc_afull_w), 
                                    .almost_empty_o(loc_aempty_w), 
                                    .one_err_det_o(), 
                                    .two_err_det_o()) ; 
                        if ((i1 == 0)) 
                            begin : genblk2
                                assign full_out_w[i0] = loc_full_w ; 
                                assign afull_out_w[i0] = loc_afull_w ; 
                                assign empty_out_w[i0] = loc_empty_w ; 
                                assign aempty_out_w[i0] = loc_aempty_w ; 
                            end
                    end
                end
                if ((FIFO_ADDR == 1)) 
                    begin : _SING_DEPTH
                        assign full_o = full_out_w[0] ; 
                        assign empty_o = empty_out_w[0] ; 
                        assign rd_fifo_w = rd_data_raw_w[0] ; 
                        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                            begin : genblk1
                                assign almost_full_o = afull_out_w[0] ; 
                            end
                        else
                            begin : genblk1
                                assign almost_full_o = 1'b0 ; 
                            end
                        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                            begin : genblk2
                                assign almost_empty_o = aempty_out_w[0] ; 
                            end
                        else
                            begin : genblk2
                                assign almost_empty_o = 1'b0 ; 
                            end
                    end
                else
                    begin : _MULT_DEPTH
                        reg [(FIFO_ADDR - 1):0] rd_pong_p_r ; 
                        if ((REGMODE == "noreg")) 
                            begin : _NREG
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        else
                            begin : _REG
                                reg [(FIFO_ADDR - 1):0] rd_pong_pr_r ; 
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if (rst_i) 
                                            begin
                                                rd_pong_p_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                                rd_pong_pr_r <=  {{(FIFO_ADDR - 1){1'b0}},
                                                        1'b1} ;
                                            end
                                        else
                                            begin
                                                rd_pong_p_r <=  rd_pong_pr_r ;
                                                rd_pong_pr_r <=  rd_pong_r ;
                                            end
                                    end
                            end
                        for (i0 = 0;(i0 < R_DWID_USE);i0 = (i0 + 1))
                        begin : _DOUT_GEN_LOOP
                            wire [(FIFO_ADDR - 1):0] translate_rd_data_w ; 
                            assign rd_fifo_w[i0] = (|translate_rd_data_w) ; 
                            for (i1 = 0;(i1 < FIFO_ADDR);i1 = (i1 + 1))
                            begin : _DOUT_GEN_LOOP2
                                wire [(R_DWID_USE - 1):0] sampled_rd_data_w ; 
                                assign sampled_rd_data_w = (rd_pong_p_r[i1] ? rd_data_raw_w[i1] : {RDATA_WIDTH{1'b0}}) ; 
                                assign translate_rd_data_w[i1] = sampled_rd_data_w[i0] ; 
                            end
                        end
                        assign empty_o = (&empty_out_w) ; 
                        if (IS_W_GREATER) 
                            begin : _W_OVR_R
                                if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                                    begin : _EN_AF_FLAG
                                        if ((AF_FLAG_CNT == 0)) 
                                            begin : _FIX_AF_FLAG
                                                assign almost_full_o = (&afull_out_w) ; 
                                            end
                                        else
                                            if ((AF_FLAG_CNT == 1)) 
                                                begin : _SING_AF_FLAG
                                                    assign almost_full_o = (|afull_out_w) ; 
                                                end
                                            else
                                                begin : _MULT_AF_FLAG
                                                    wire [(FIFO_ADDR - 1):0] afull_expand_w ; 
                                                    assign almost_full_o = (|afull_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AFULL_FLAG
                                                        wire [(AF_FLAG_CNT - 1):0] nterm_and_w ; 
                                                        assign afull_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AF_FLAG_CNT);i1 = (i1 + 1))
                                                        begin : _GEN_MINTERM
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : _PRELOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : _POSTLOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AF_FLAG
                                        assign almost_full_o = 1'b0 ; 
                                    end
                                if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                                    begin : _EN_AE_FLAG
                                        if (((AE_NUM_TERMS == FIFO_ADDR) || (AE_NUM_TERMS == 0))) 
                                            begin : _FIX_AE_FLAG
                                                assign almost_empty_o = (&aempty_out_w) ; 
                                            end
                                        else
                                            if ((AE_NUM_TERMS == 1)) 
                                                begin : _SING_AE_FLAG
                                                    assign almost_empty_o = (|aempty_out_w) ; 
                                                end
                                            else
                                                begin : _MULT_AE_FLAG
                                                    wire [(FIFO_ADDR - 1):0] aempty_expand_w ; 
                                                    assign almost_empty_o = (|aempty_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AEFLAG
                                                        wire [(AE_NUM_TERMS - 1):0] nterm_and_w ; 
                                                        assign aempty_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AE_NUM_TERMS);i1 = (i1 + 1))
                                                        begin : genblk1
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AE_FLAG
                                        assign almost_empty_o = 1'b0 ; 
                                    end
                            end
                        else
                            begin : _R_OVR_W
                                if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                                    begin : _EN_AF_FLAG
                                        if ((AF_FLAG_CNT == 0)) 
                                            begin : genblk1
                                                assign almost_full_o = (&afull_out_w) ; 
                                            end
                                        else
                                            if ((AF_FLAG_CNT == 1)) 
                                                begin : genblk1
                                                    assign almost_full_o = (|afull_out_w) ; 
                                                end
                                            else
                                                begin : genblk1
                                                    wire [(FIFO_ADDR - 1):0] afull_expand_w ; 
                                                    assign almost_full_o = (|afull_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AFULL_FLAG
                                                        wire [(AF_FLAG_CNT - 1):0] nterm_and_w ; 
                                                        assign afull_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AF_FLAG_CNT);i1 = (i1 + 1))
                                                        begin : _GEN_MINTERM
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : _PRELOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : _POSTLOOP
                                                                    assign nterm_and_w[i1] = afull_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AF_FLAG
                                        assign almost_full_o = 1'b0 ; 
                                    end
                                if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                                    begin : _EN_AE_FLAG
                                        if (((AE_NUM_TERMS == FIFO_ADDR) || (AE_NUM_TERMS == 0))) 
                                            begin : _FIX_AE_FLAG
                                                assign almost_empty_o = (&aempty_out_w) ; 
                                            end
                                        else
                                            if ((AE_NUM_TERMS == 1)) 
                                                begin : _SING_AE_FLAG
                                                    assign almost_empty_o = (|aempty_out_w) ; 
                                                end
                                            else
                                                begin : _MULT_AE_FLAG
                                                    wire [(FIFO_ADDR - 1):0] aempty_expand_w ; 
                                                    assign almost_empty_o = (|aempty_expand_w) ; 
                                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                                    begin : _EXP_AEFLAG
                                                        wire [(AE_NUM_TERMS - 1):0] nterm_and_w ; 
                                                        assign aempty_expand_w[i0] = (&nterm_and_w) ; 
                                                        for (i1 = 0;(i1 < AE_NUM_TERMS);i1 = (i1 + 1))
                                                        begin : genblk1
                                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[(i0 + i1)] ; 
                                                                end
                                                            else
                                                                begin : genblk1
                                                                    assign nterm_and_w[i1] = aempty_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                                end
                                                        end
                                                    end
                                                end
                                    end
                                else
                                    begin : _DIS_AE_FLAG
                                        assign almost_empty_o = 1'b0 ; 
                                    end
                            end
                        if ((FULL_CNT == 0)) 
                            begin : _FIX_FULL
                                assign full_o = (&full_out_w) ; 
                            end
                        else
                            if ((FULL_CNT == 1)) 
                                begin : _SING_FULL
                                    assign full_o = (|full_out_w) ; 
                                end
                            else
                                begin : genblk4
                                    wire [(FIFO_ADDR - 1):0] full_expand_w ; 
                                    assign full_o = (|full_expand_w) ; 
                                    for (i0 = 0;(i0 < FIFO_ADDR);i0 = (i0 + 1))
                                    begin : _EXP_FULL_FLAG
                                        wire [(FULL_CNT - 1):0] nterm_and_w ; 
                                        assign full_expand_w[i0] = (&nterm_and_w) ; 
                                        for (i1 = 0;(i1 < FULL_CNT);i1 = (i1 + 1))
                                        begin : _GEN_MINTERM
                                            if (((i0 + i1) < FIFO_ADDR)) 
                                                begin : _PRELOOP
                                                    assign nterm_and_w[i1] = full_out_w[(i0 + i1)] ; 
                                                end
                                            else
                                                begin : _POSTLOOP
                                                    assign nterm_and_w[i1] = full_out_w[((i0 + i1) - FIFO_ADDR)] ; 
                                                end
                                        end
                                    end
                                end
                    end
            end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] getAEmptyFlag ; 
        input [31:0] flag_assert ; 
        input [31:0] split ; 
        input [31:0] factor ; 
        input IsWGreater ; 
        input IsGetFlagCnt ; 
        reg [31:0] base, 
            prod_spf, 
            per_ebr, 
            excess ; 
        begin
            if ((split == 1)) 
                begin
                    getAEmptyFlag = flag_assert ;
                end
            else
                if (IsWGreater) 
                    begin
                        prod_spf = (split * factor) ;
                        base = 0 ;
                        per_ebr = 0 ;
                        while (((flag_assert - base) > prod_spf))
                            begin
                                base = (base + prod_spf) ;
                                per_ebr = (per_ebr + factor) ;
                            end
                        excess = (flag_assert - base) ;
                        getAEmptyFlag = (per_ebr + (excess % factor)) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAEmptyFlag = (split - (excess / factor)) ;
                            end
                    end
                else
                    begin
                        getAEmptyFlag = (flag_assert / split) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAEmptyFlag = (split - (flag_assert % split)) ;
                            end
                    end
        end
    endfunction
    function [31:0] getAFullFlag ; 
        input [31:0] flag_assert ; 
        input [31:0] split ; 
        input [31:0] factor ; 
        input IsWGreater ; 
        input IsGetFlagCnt ; 
        reg [31:0] diff_chk ; 
        reg [31:0] factor_diff ; 
        begin
            if ((split == 1)) 
                begin
                    getAFullFlag = flag_assert ;
                end
            else
                if (IsWGreater) 
                    begin
                        getAFullFlag = roundUP(flag_assert,
                                split) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAFullFlag = (flag_assert % split) ;
                            end
                    end
                else
                    begin
                        getAFullFlag = (flag_assert / split) ;
                        while (((getAFullFlag % factor) != 0))
                            getAFullFlag = (getAFullFlag - 1) ;
                        diff_chk = (flag_assert - (getAFullFlag * split)) ;
                        factor_diff = 1 ;
                        while ((diff_chk > factor))
                            begin
                                diff_chk = (diff_chk - factor) ;
                                factor_diff = (factor_diff + 1) ;
                            end
                        getAFullFlag = (getAFullFlag + diff_chk) ;
                        if (IsGetFlagCnt) 
                            begin
                                getAFullFlag = factor_diff ;
                            end
                    end
        end
    endfunction
    function [31:0] getFullFlag ; 
        input [31:0] flag ; 
        input [31:0] split ; 
        input [31:0] factor ; 
        input IsWGreater ; 
        input IsGetFlagCnt ; 
        reg [31:0] prod_spf ; 
        begin
            if ((split == 1)) 
                begin
                    getFullFlag = flag ;
                end
            else
                if (IsWGreater) 
                    begin
                        getFullFlag = roundUP(flag,
                                split) ;
                        if (IsGetFlagCnt) 
                            begin
                                getFullFlag = (flag % split) ;
                            end
                    end
                else
                    begin
                        prod_spf = (split * factor) ;
                        getFullFlag = (roundUP(flag,
                                prod_spf) * factor) ;
                        if (IsGetFlagCnt) 
                            begin
                                getFullFlag = (split - (((getFullFlag * split) - flag) / factor)) ;
                            end
                    end
        end
    endfunction
    function [31:0] getBase9 ; 
        input [31:0] base ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    case (base)
                    0 : 
                        getBase9 = 36 ;
                    1 : 
                        getBase9 = 18 ;
                    default : 
                        getBase9 = 9 ;
                    endcase 
                end
            default : 
                getBase9 = base ;
            endcase 
        end
    endfunction
    function [31:0] getBase8 ; 
        input [31:0] base ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    case (base)
                    0 : 
                        getBase8 = 32 ;
                    1 : 
                        getBase8 = 16 ;
                    2 : 
                        getBase8 = 8 ;
                    3 : 
                        getBase8 = 4 ;
                    4 : 
                        getBase8 = 2 ;
                    default : 
                        getBase8 = 1 ;
                    endcase 
                end
            default : 
                getBase8 = base ;
            endcase 
        end
    endfunction
    function [31:0] getDWIDImpl ; 
        input [31:0] wdepth ; 
        input [31:0] wdwid ; 
        input [31:0] rdepth ; 
        input [31:0] rdwid ; 
        input isTakingWDWID ; 
        input [31:0] fcode ; 
        input IsUsingFastCtrl ; 
        reg [31:0] n0, 
            n1 ; 
        reg [31:0] factor, 
            addrWPart, 
            dataWPart, 
            addrRPart, 
            dataRPart ; 
        reg [31:0] addrWChk, 
            dataWChk, 
            addrRChk, 
            dataRChk ; 
        reg [31:0] UseFIFO, 
            UseADDR, 
            PROD ; 
        reg [31:0] AddrLimit ; 
        begin
            factor = ((wdwid > rdwid) ? (wdwid / rdwid) : (rdwid / wdwid)) ;
            UseFIFO = {32{1'b1}} ;
            UseADDR = {32{1'b1}} ;
            AddrLimit = 5 ;
            if (IsUsingFastCtrl) 
                AddrLimit = 1 ;
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    if ((factor <= 4)) 
                        begin
                            for (n0 = 0 ; (n0 < 3) ; n0 = (n0 + 1))
                                begin
                                    dataWPart = getBase9(n0,
                                            fcode) ;
                                    addrWPart = data_to_addr(dataWPart,
                                            fcode) ;
                                    dataWChk = roundUP(wdwid,
                                            dataWPart) ;
                                    addrWChk = roundUP(wdepth,
                                            addrWPart) ;
                                    for (n1 = 0 ; (n1 < 3) ; n1 = (n1 + 1))
                                        begin
                                            dataRPart = getBase9(n1,
                                                    fcode) ;
                                            addrRPart = data_to_addr(dataRPart,
                                                    fcode) ;
                                            dataRChk = roundUP(rdwid,
                                                    dataRPart) ;
                                            addrRChk = roundUP(rdepth,
                                                    addrRPart) ;
                                            if (((((dataRChk == dataWChk) && (addrWChk == addrRChk)) && (addrWChk <= AddrLimit)) && (addrRPart != addrWPart))) 
                                                begin
                                                    if ((((wdwid % dataWPart) == 0) && ((rdwid % dataRPart) == 0))) 
                                                        begin
                                                            PROD = (dataWChk * addrWChk) ;
                                                            if (((PROD < UseFIFO) || ((PROD == UseFIFO) & (addrWChk < UseADDR)))) 
                                                                begin
                                                                    UseADDR = addrWChk ;
                                                                    UseFIFO = PROD ;
                                                                    getDWIDImpl = (isTakingWDWID ? dataWPart : dataRPart) ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                    for (n0 = 0 ; (n0 < 6) ; n0 = (n0 + 1))
                        begin
                            dataWPart = getBase8(n0,
                                    fcode) ;
                            addrWPart = data_to_addr(dataWPart,
                                    fcode) ;
                            dataWChk = roundUP(wdwid,
                                    dataWPart) ;
                            addrWChk = roundUP(wdepth,
                                    addrWPart) ;
                            for (n1 = 0 ; (n1 < 6) ; n1 = (n1 + 1))
                                begin
                                    dataRPart = getBase8(n1,
                                            fcode) ;
                                    addrRPart = data_to_addr(dataRPart,
                                            fcode) ;
                                    dataRChk = roundUP(rdwid,
                                            dataRPart) ;
                                    addrRChk = roundUP(rdepth,
                                            addrRPart) ;
                                    if (((((dataRChk == dataWChk) && (addrWChk == addrRChk)) && (addrWChk <= AddrLimit)) && (addrRPart != addrWPart))) 
                                        begin
                                            if ((((wdwid % dataWPart) == 0) && ((rdwid % dataRPart) == 0))) 
                                                begin
                                                    PROD = (dataWChk * addrWChk) ;
                                                    if (((PROD < UseFIFO) || ((PROD == UseFIFO) & (addrWChk < UseADDR)))) 
                                                        begin
                                                            UseADDR = addrWChk ;
                                                            UseFIFO = PROD ;
                                                            getDWIDImpl = (isTakingWDWID ? dataWPart : dataRPart) ;
                                                        end
                                                end
                                        end
                                end
                        end
                end
            default : 
                getDWIDImpl = 0 ;
            endcase 
        end
    endfunction
    function [31:0] procData ; 
        input [31:0] maxData ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    procData = 1 ;
                    while ((procData < maxData))
                        begin
                            if ((procData < 8)) 
                                begin
                                    procData = (procData * 2) ;
                                end
                            else
                                begin
                                    if ((procData == 8)) 
                                        begin
                                            procData = 9 ;
                                        end
                                    else
                                        if (((procData % 9) == 0)) 
                                            begin
                                                procData = ((procData / 9) * 16) ;
                                            end
                                        else
                                            begin
                                                procData = ((procData / 8) * 9) ;
                                            end
                                end
                        end
                end
            default : 
                procData = maxData ;
            endcase 
        end
    endfunction
    function [31:0] data_to_addr ; 
        input [31:0] dwid ; 
        input [31:0] fcode ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    case (dwid)
                    36 : 
                        data_to_addr = 511 ;
                    32 : 
                        data_to_addr = 511 ;
                    18 : 
                        data_to_addr = 1023 ;
                    16 : 
                        data_to_addr = 1023 ;
                    9 : 
                        data_to_addr = 2047 ;
                    8 : 
                        data_to_addr = 2047 ;
                    4 : 
                        data_to_addr = 4095 ;
                    2 : 
                        data_to_addr = 8191 ;
                    1 : 
                        data_to_addr = 16383 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (dwid)
                    72 : 
                        data_to_addr = 512 ;
                    64 : 
                        data_to_addr = 512 ;
                    36 : 
                        data_to_addr = 1024 ;
                    32 : 
                        data_to_addr = 1024 ;
                    18 : 
                        data_to_addr = 2048 ;
                    16 : 
                        data_to_addr = 2048 ;
                    9 : 
                        data_to_addr = 4096 ;
                    8 : 
                        data_to_addr = 4096 ;
                    4 : 
                        data_to_addr = 8192 ;
                    2 : 
                        data_to_addr = 16384 ;
                    default : 
                        data_to_addr = 32768 ;
                    endcase 
                end
            default : 
                data_to_addr = 512 ;
            endcase 
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] FIFOimpl ; 
        input [31:0] DEPTH_IMPL ; 
        input [31:0] WIDTH_IMPL ; 
        input [31:0] ADDR_DEPTH_X ; 
        input [31:0] DATA_WIDTH_X ; 
        begin
            FIFOimpl = (roundUP(DEPTH_IMPL,
                    ADDR_DEPTH_X) * roundUP(WIDTH_IMPL,
                    DATA_WIDTH_X)) ;
        end
    endfunction
    function [31:0] getMinFIFO ; 
        input [31:0] depth ; 
        input [31:0] dwid ; 
        input ecc_en ; 
        input [31:0] fcode ; 
        input IsUsingFastCtrl ; 
        reg [31:0] temp_00, 
            temp_01, 
            temp_02, 
            temp_03, 
            temp_04, 
            temp_05, 
            temp_06 ; 
        reg [31:0] addr_00, 
            addr_01, 
            addr_02, 
            addr_03, 
            addr_04, 
            addr_05, 
            addr_06 ; 
        begin
            case (fcode)
            _FCODE_LIFCL_ : 
                begin
                    if (ecc_en) 
                        begin
                            getMinFIFO = 32 ;
                        end
                    else
                        begin
                            temp_00 = FIFOimpl(depth,
                                    dwid,
                                    511,
                                    36) ;
                            temp_01 = FIFOimpl(depth,
                                    dwid,
                                    1023,
                                    18) ;
                            temp_02 = FIFOimpl(depth,
                                    dwid,
                                    2047,
                                    9) ;
                            temp_03 = FIFOimpl(depth,
                                    dwid,
                                    4095,
                                    4) ;
                            temp_04 = FIFOimpl(depth,
                                    dwid,
                                    8191,
                                    2) ;
                            temp_05 = FIFOimpl(depth,
                                    dwid,
                                    16383,
                                    1) ;
                            addr_00 = roundUP(depth,
                                    511) ;
                            addr_01 = roundUP(depth,
                                    1023) ;
                            addr_02 = roundUP(depth,
                                    2047) ;
                            addr_03 = roundUP(depth,
                                    4095) ;
                            addr_04 = roundUP(depth,
                                    8191) ;
                            addr_05 = roundUP(depth,
                                    16383) ;
                            if (IsUsingFastCtrl) 
                                begin
                                    if ((addr_00 > 1)) 
                                        temp_00 = {32{1'b1}} ;
                                    if ((addr_01 > 1)) 
                                        temp_01 = {32{1'b1}} ;
                                    if ((addr_02 > 1)) 
                                        temp_02 = {32{1'b1}} ;
                                    if ((addr_03 > 1)) 
                                        temp_03 = {32{1'b1}} ;
                                    if ((addr_04 > 1)) 
                                        temp_04 = {32{1'b1}} ;
                                    if ((addr_05 > 1)) 
                                        temp_05 = {32{1'b1}} ;
                                end
                            else
                                begin
                                    if ((addr_00 > 5)) 
                                        temp_00 = {32{1'b1}} ;
                                    if ((addr_01 > 5)) 
                                        temp_01 = {32{1'b1}} ;
                                    if ((addr_02 > 5)) 
                                        temp_02 = {32{1'b1}} ;
                                    if ((addr_03 > 5)) 
                                        temp_03 = {32{1'b1}} ;
                                    if ((addr_04 > 5)) 
                                        temp_04 = {32{1'b1}} ;
                                    if ((addr_05 > 5)) 
                                        temp_05 = {32{1'b1}} ;
                                end
                            if ((temp_00 < temp_01)) 
                                begin
                                    if ((temp_00 < temp_02)) 
                                        begin
                                            if ((temp_00 < temp_03)) 
                                                begin
                                                    if ((temp_00 < temp_04)) 
                                                        begin
                                                            if ((temp_00 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 36 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        begin
                                                            if ((temp_02 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 9 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                            else
                                begin
                                    if ((temp_01 < temp_02)) 
                                        begin
                                            if ((temp_01 < temp_03)) 
                                                begin
                                                    if ((temp_01 < temp_04)) 
                                                        begin
                                                            if ((temp_01 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 18 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        begin
                                                            if ((temp_02 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 9 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 4 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    getMinFIFO = 2 ;
                                                                end
                                                            else
                                                                begin
                                                                    getMinFIFO = 1 ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                end
            _FCODE_AP6_ : 
                begin
                    if (ecc_en) 
                        begin
                            getMinFIFO = 64 ;
                        end
                    else
                        begin
                            temp_00 = FIFOimpl(depth,
                                    dwid,
                                    512,
                                    72) ;
                            temp_01 = FIFOimpl(depth,
                                    dwid,
                                    1024,
                                    36) ;
                            temp_02 = FIFOimpl(depth,
                                    dwid,
                                    2048,
                                    18) ;
                            temp_03 = FIFOimpl(depth,
                                    dwid,
                                    4096,
                                    9) ;
                            temp_04 = FIFOimpl(depth,
                                    dwid,
                                    8192,
                                    4) ;
                            temp_05 = FIFOimpl(depth,
                                    dwid,
                                    16384,
                                    2) ;
                            temp_06 = FIFOimpl(depth,
                                    dwid,
                                    32768,
                                    1) ;
                            // addr_00 = roundUP(depth,   512);
                            // addr_01 = roundUP(depth,  1024);
                            // addr_02 = roundUP(depth,  2048);
                            // addr_03 = roundUP(depth,  4096);
                            // addr_04 = roundUP(depth,  8192);
                            // addr_05 = roundUP(depth, 16384);
                            // addr_06 = roundUP(depth, 32768);
                            if ((temp_00 < temp_01)) 
                                begin
                                    if ((temp_00 < temp_02)) 
                                        begin
                                            if ((temp_00 < temp_03)) 
                                                begin
                                                    if ((temp_00 < temp_04)) 
                                                        begin
                                                            if ((temp_00 < temp_05)) 
                                                                begin
                                                                    if ((temp_00 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 72 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    if ((temp_03 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 9 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        begin
                                                            if ((temp_02 < temp_05)) 
                                                                begin
                                                                    if ((temp_02 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 18 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    if ((temp_03 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 9 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                        end
                                end
                            else
                                begin
                                    if ((temp_01 < temp_02)) 
                                        begin
                                            if ((temp_01 < temp_03)) 
                                                begin
                                                    if ((temp_01 < temp_04)) 
                                                        begin
                                                            if ((temp_01 < temp_05)) 
                                                                begin
                                                                    if ((temp_01 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 36 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    if ((temp_03 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 9 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        begin
                                                            if ((temp_02 < temp_05)) 
                                                                begin
                                                                    if ((temp_02 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 18 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        begin
                                                            if ((temp_03 < temp_05)) 
                                                                begin
                                                                    if ((temp_03 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 9 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                    else
                                                        begin
                                                            if ((temp_04 < temp_05)) 
                                                                begin
                                                                    if ((temp_04 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 4 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                            else
                                                                begin
                                                                    if ((temp_05 < temp_06)) 
                                                                        begin
                                                                            getMinFIFO = 2 ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getMinFIFO = 1 ;
                                                                        end
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                end
            default : 
                getMinFIFO = dwid ;
            endcase 
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 2.1
// File                  : lscc_fifo_hw_core.v
// Title                 :
// Dependencies          :
// Description           : Implements a single FIFO DC using an internal 
//                         controller
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module ctrl_fifo_ipgen_lscc_fifo_hw_core #(parameter FAMILY = "LIFCL", 
        parameter WADDR_DEPTH = 512, 
        parameter WDATA_WIDTH = 36, 
        parameter RADDR_DEPTH = 512, 
        parameter RDATA_WIDTH = 36, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 510, 
        parameter ALMOST_FULL_DEASSERT_LVL = 509, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter ECC_ENABLE = 0, 
        parameter IS_CASCADE = 0, 
        parameter FWFT = 0) (
    input wr_clk_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input rd_clk_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input full_cascade_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    if ((FAMILY == "LIFCL")) 
        begin : _LIFCL
            localparam W_FACTOR = (((WDATA_WIDTH == 36) || (WDATA_WIDTH == 32)) ? 32 : (((WDATA_WIDTH == 18) || (WDATA_WIDTH == 16)) ? 16 : (((WDATA_WIDTH == 9) || (WDATA_WIDTH == 8)) ? 8 : ((WDATA_WIDTH == 4) ? 4 : ((WDATA_WIDTH == 2) ? 2 : 1))))) ; 
            localparam R_FACTOR = (((RDATA_WIDTH == 36) || (RDATA_WIDTH == 32)) ? 32 : (((RDATA_WIDTH == 18) || (RDATA_WIDTH == 16)) ? 16 : (((RDATA_WIDTH == 9) || (RDATA_WIDTH == 8)) ? 8 : ((RDATA_WIDTH == 4) ? 4 : ((RDATA_WIDTH == 2) ? 2 : 1))))) ; 
            localparam DWID_W = (((WDATA_WIDTH == 36) || (WDATA_WIDTH == 32)) ? "X36" : (((WDATA_WIDTH == 18) || (WDATA_WIDTH == 16)) ? "X18" : (((WDATA_WIDTH == 9) || (WDATA_WIDTH == 8)) ? "X9" : ((WDATA_WIDTH == 4) ? "X4" : ((WDATA_WIDTH == 2) ? "X2" : "X1"))))) ; 
            localparam DWID_R = (((RDATA_WIDTH == 36) || (RDATA_WIDTH == 32)) ? "X36" : (((RDATA_WIDTH == 18) || (RDATA_WIDTH == 16)) ? "X18" : (((RDATA_WIDTH == 9) || (RDATA_WIDTH == 8)) ? "X9" : ((RDATA_WIDTH == 4) ? "X4" : ((RDATA_WIDTH == 2) ? "X2" : "X1"))))) ; 
            localparam WF_DIFF = ((W_FACTOR <= 2) ? 0 : {{(((W_FACTOR <= 2) + clog2(W_FACTOR)) - 1){1'b1}},
                        1'b0}) ; 
            localparam RF_DIFF = ((R_FACTOR == 1) ? 0 : ((R_FACTOR == 2) ? 1'b1 : {((R_FACTOR <= 2) + clog2((R_FACTOR - 1))){1'b1}})) ; 
            localparam [13:0] W_FULL_FLAG_BIN = (((WADDR_DEPTH * W_FACTOR) > WF_DIFF) ? ((WADDR_DEPTH * W_FACTOR) - WF_DIFF) : 0) ; 
            localparam [13:0] W_AFULL_FLAG_BIN = (((ALMOST_FULL_ASSERT_LVL * W_FACTOR) > WF_DIFF) ? ((ALMOST_FULL_ASSERT_LVL * W_FACTOR) - WF_DIFF) : 0) ; 
            localparam [127:0] W_FULL_FLAG_STR = {"0b",
                        (W_FULL_FLAG_BIN[13] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[12] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[11] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[10] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[9] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[8] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[7] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[6] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[5] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[4] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[3] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[2] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[1] ? "1" : "0"),
                        (W_FULL_FLAG_BIN[0] ? "1" : "0")} ; 
            localparam [127:0] W_AFULL_FLAG_STR = {"0b",
                        (W_AFULL_FLAG_BIN[13] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[12] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[11] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[10] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[9] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[8] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[7] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[6] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[5] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[4] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[3] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[2] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[1] ? "1" : "0"),
                        (W_AFULL_FLAG_BIN[0] ? "1" : "0")} ; 
            localparam [13:0] R_AEMPTY_FLAG_BIN = ((((ALMOST_EMPTY_ASSERT_LVL * R_FACTOR) + RF_DIFF) < RADDR_DEPTH) ? ((ALMOST_EMPTY_ASSERT_LVL * R_FACTOR) + RF_DIFF) : RADDR_DEPTH) ; 
            localparam [127:0] R_AEMPTY_FLAG_STR = {"0b",
                        (R_AEMPTY_FLAG_BIN[13] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[12] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[11] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[10] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[9] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[8] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[7] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[6] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[5] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[4] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[3] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[2] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[1] ? "1" : "0"),
                        (R_AEMPTY_FLAG_BIN[0] ? "1" : "0")} ; 
            localparam T_REG = ((REGMODE == "reg") ? "USED" : "BYPASSED") ; 
            localparam T_RST = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
            localparam T_REL = T_RST ; 
            wire [35:0] di_w ; 
            wire [35:0] do_w ; 
            wire rd_en_w ; 
            wire empty_w ; 
            wire FULL ; 
            wire EMPTY ; 
            wire ALMOSTFULL ; 
            wire ALMOSTEMPTY ; 
            wire ONEBITERR ; 
            wire TWOBITERR ; 
            wire cascade_chk_w ; 
            reg empty_r ; 
            reg empty_out_r ; 
            reg aempty_out_r ; 
            reg pre_read_r ; 
            reg rd_en_p_r ; 
            case (WDATA_WIDTH)
            36 : 
                begin: genblk1
                    assign di_w = wr_data_i ; 
                end
            32 : 
                begin : genblk1
                    assign di_w[7:0] = wr_data_i[7:0] ; 
                    assign di_w[16:9] = wr_data_i[15:8] ; 
                    assign di_w[25:18] = wr_data_i[23:16] ; 
                    assign di_w[34:27] = wr_data_i[31:24] ; 
                    assign di_w[8] = 1'b0 ; 
                    assign di_w[17] = 1'b0 ; 
                    assign di_w[26] = 1'b0 ; 
                    assign di_w[35] = 1'b0 ; 
                end
            18 : 
                begin : genblk1
                    assign di_w = {{18{1'b0}},
                                wr_data_i} ; 
                end
            16 : 
                begin : genblk1
                    assign di_w[7:0] = wr_data_i[7:0] ; 
                    assign di_w[16:9] = wr_data_i[15:8] ; 
                    assign di_w[8] = 1'b0 ; 
                    assign di_w[17] = 1'b0 ; 
                    assign di_w[35:18] = {18{1'b0}} ; 
                end
            default : 
                begin : genblk1
                    assign di_w = {{(36 - WDATA_WIDTH){1'b0}},
                                wr_data_i} ; 
                end
            endcase
            if ((REGMODE == "noreg")) 
                begin : _NREG
                    case (RDATA_WIDTH)
                    32 : 
                        begin : genblk1
                            assign rd_data_o[7:0] = do_w[7:0] ; 
                            assign rd_data_o[15:8] = do_w[16:9] ; 
                            assign rd_data_o[23:16] = do_w[25:18] ; 
                            assign rd_data_o[31:24] = do_w[34:27] ; 
                        end
                    16 : 
                        begin : genblk1
                            assign rd_data_o[15:8] = do_w[16:9] ; 
                            assign rd_data_o[7:0] = do_w[7:0] ; 
                        end
                    default : 
                        begin: genblk1
                            assign rd_data_o = do_w[(RDATA_WIDTH - 1):0] ; 
                        end
                    endcase
                end
            else
                begin : _REG
                    reg [(RDATA_WIDTH - 1):0] do_r ; 
                    wire [(RDATA_WIDTH - 1):0] do_mix_w ; 
                    assign rd_data_o = do_r ; 
                    case (RDATA_WIDTH)
                    32 : 
                        begin : genblk1
                            assign do_mix_w[7:0] = do_w[7:0] ; 
                            assign do_mix_w[15:8] = do_w[16:9] ; 
                            assign do_mix_w[23:16] = do_w[25:18] ; 
                            assign do_mix_w[31:24] = do_w[34:27] ; 
                        end
                    16 : 
                        begin : genblk1
                            assign do_mix_w[15:8] = do_w[16:9] ; 
                            assign do_mix_w[7:0] = do_w[7:0] ; 
                        end
                    default : 
                        begin: genblk1
                            assign do_mix_w = do_w[(RDATA_WIDTH - 1):0] ; 
                        end
                    endcase
                    always
                        @(posedge rd_clk_i or 
                            posedge rst_i)
                        begin
                            if (rst_i) 
                                begin
                                    do_r <=  {RDATA_WIDTH{1'b0}} ;
                                end
                            else
                                begin
                                    do_r <=  do_mix_w ;
                                end
                        end
                end
            assign rd_en_w = rd_en_i ; 
            assign empty_w = EMPTY ; 
            assign empty_o = EMPTY ; 
            assign almost_full_o = ALMOSTFULL ; 
            assign almost_empty_o = ALMOSTEMPTY ; 
            assign full_o = FULL ; 
            assign one_err_det_o = ONEBITERR ; 
            assign two_err_det_o = TWOBITERR ; 
            assign cascade_chk_w = (IS_CASCADE ? full_cascade_i : 1'b0) ; 
            FIFO16K fifo16K (.DI(di_w), 
                        .CLKW(wr_clk_i), 
                        .CLKR(rd_clk_i), 
                        .WE(wr_en_i), 
                        .RE(rd_en_w), 
                        .RSTW(rst_i), 
                        .RPRST(rp_rst_i), 
                        .FULLI(full_o), 
                        .EMPTYI(empty_w), 
                        .CSW({1'b1,
                            cascade_chk_w}), 
                        .CSR(2'b11), 
                        .DO(do_w), 
                        .ONEBITERR(ONEBITERR), 
                        .TWOBITERR(TWOBITERR), 
                        .ALMOSTFULL(ALMOSTFULL), 
                        .FULL(FULL), 
                        .ALMOSTEMPTY(ALMOSTEMPTY), 
                        .EMPTY(EMPTY)) ; 
            defparam fifo16K.DATA_WIDTH_W = DWID_W ; 
            defparam fifo16K.DATA_WIDTH_R = DWID_R ; 
            defparam fifo16K.OUTREG = "BYPASSED" ; 
            defparam fifo16K.RESETMODE = T_RST ; 
            defparam fifo16K.ASYNC_RST_RELEASE = T_REL ; 
            defparam fifo16K.ECC = (ECC_ENABLE ? "ENABLED" : "DISABLED") ; 
            defparam fifo16K.CSDECODE_W = "01" ; 
            defparam fifo16K.CSDECODE_R = "00" ; 
            defparam fifo16K.FULLBITS = W_FULL_FLAG_STR ; 
            defparam fifo16K.ALMOST_FULL = W_AFULL_FLAG_STR ; 
            defparam fifo16K.ALMOST_EMPTY = R_AEMPTY_FLAG_STR ; 
        end
    else
        if ((FAMILY == "LATG1") || (FAMILY == "LAV-AT"))
            begin : _AP6
                localparam W_FACTOR = (((WDATA_WIDTH == 72) || (WDATA_WIDTH == 64)) ? 64 : (((WDATA_WIDTH == 36) || (WDATA_WIDTH == 32)) ? 32 : (((WDATA_WIDTH == 18) || (WDATA_WIDTH == 16)) ? 16 : (((WDATA_WIDTH == 9) || (WDATA_WIDTH == 8)) ? 8 : ((WDATA_WIDTH == 4) ? 4 : ((WDATA_WIDTH == 2) ? 2 : 1)))))) ; 
                localparam R_FACTOR = (((RDATA_WIDTH == 72) || (RDATA_WIDTH == 64)) ? 64 : (((RDATA_WIDTH == 36) || (RDATA_WIDTH == 32)) ? 32 : (((RDATA_WIDTH == 18) || (RDATA_WIDTH == 16)) ? 16 : (((RDATA_WIDTH == 9) || (RDATA_WIDTH == 8)) ? 8 : ((RDATA_WIDTH == 4) ? 4 : ((RDATA_WIDTH == 2) ? 2 : 1)))))) ; 
                localparam DWID_W = (((WDATA_WIDTH == 72) || (WDATA_WIDTH == 64)) ? "X72" : (((WDATA_WIDTH == 36) || (WDATA_WIDTH == 32)) ? "X36" : (((WDATA_WIDTH == 18) || (WDATA_WIDTH == 16)) ? "X18" : (((WDATA_WIDTH == 9) || (WDATA_WIDTH == 8)) ? "X9" : ((WDATA_WIDTH == 4) ? "X4" : ((WDATA_WIDTH == 2) ? "X2" : "X1")))))) ; 
                localparam DWID_R = (((RDATA_WIDTH == 72) || (RDATA_WIDTH == 64)) ? "X72" : (((RDATA_WIDTH == 36) || (RDATA_WIDTH == 32)) ? "X36" : (((RDATA_WIDTH == 18) || (RDATA_WIDTH == 16)) ? "X18" : (((RDATA_WIDTH == 9) || (RDATA_WIDTH == 8)) ? "X9" : ((RDATA_WIDTH == 4) ? "X4" : ((RDATA_WIDTH == 2) ? "X2" : "X1")))))) ; 
                localparam [14:0] W_FULL_FLAG_BIN = ((WADDR_DEPTH - 1) * W_FACTOR) ; 
                localparam [14:0] W_AFULL_FLAG_BIN = ((ALMOST_FULL_ASSERT_LVL - 1) * W_FACTOR) ; 
                localparam [14:0] R_AEMPTY_FLAG_BIN = (((ALMOST_EMPTY_ASSERT_LVL + 1) * R_FACTOR) - 1) ; 
                localparam FULLBITS = {"0b",
                            (W_FULL_FLAG_BIN[14] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[13] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[12] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[11] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[10] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[9] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[8] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[7] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[6] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[5] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[4] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[3] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[2] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[1] ? "1" : "0"),
                            (W_FULL_FLAG_BIN[0] ? "1" : "0")} ; 
                localparam AFULLBITS = {"0b",
                            (W_AFULL_FLAG_BIN[14] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[13] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[12] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[11] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[10] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[9] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[8] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[7] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[6] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[5] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[4] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[3] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[2] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[1] ? "1" : "0"),
                            (W_AFULL_FLAG_BIN[0] ? "1" : "0")} ; 
                localparam AEMPTYBITS = {"0b",
                            (R_AEMPTY_FLAG_BIN[14] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[13] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[12] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[11] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[10] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[9] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[8] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[7] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[6] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[5] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[4] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[3] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[2] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[1] ? "1" : "0"),
                            (R_AEMPTY_FLAG_BIN[0] ? "1" : "0")} ; 
                wire [71:0] DI ; 
                wire [71:0] DO ; 
                wire CEW ; 
                wire CER ; 
                wire OCE ; 
                wire [2:0] CSW ; 
                wire [2:0] CSR ; 
                wire WE ; 
                wire ONEBITERR ; 
                wire TWOBITERR ; 
                wire FULL ; 
                wire EMPTY ; 
                wire ALMOSTFULL ; 
                wire ALMOSTEMPTY ; 
                assign CEW = (wr_en_i & (~FULL)) ; 
                assign OCE = 1'b1 ; 
                assign CSW = (IS_CASCADE ? {2'b11,
                            (~full_cascade_i)} : 3'b111) ; 
                assign CSR = 3'b111 ; 
                assign CER = (rd_en_i & (~EMPTY)) ; 
                assign full_o = FULL ; 
                assign empty_o = EMPTY ; 
                assign almost_empty_o = ALMOSTEMPTY ; 
                assign almost_full_o = ALMOSTFULL ; 
                case (WDATA_WIDTH)
                72 : 
                    begin: genblk1
                        assign DI = wr_data_i ; 
                    end
                64 : 
                    begin : genblk1
                        assign DI[8:0] = {1'b0,
                                    wr_data_i[7:0]} ; 
                        assign DI[17:9] = {1'b0,
                                    wr_data_i[15:8]} ; 
                        assign DI[26:18] = {1'b0,
                                    wr_data_i[23:16]} ; 
                        assign DI[35:27] = {1'b0,
                                    wr_data_i[31:24]} ; 
                        assign DI[44:36] = {1'b0,
                                    wr_data_i[39:32]} ; 
                        assign DI[53:45] = {1'b0,
                                    wr_data_i[47:40]} ; 
                        assign DI[62:54] = {1'b0,
                                    wr_data_i[55:48]} ; 
                        assign DI[71:63] = {1'b0,
                                    wr_data_i[63:56]} ; 
                    end
                32 : 
                    begin : genblk1
                        assign DI[8:0] = {1'b0,
                                    wr_data_i[7:0]} ; 
                        assign DI[17:9] = {1'b0,
                                    wr_data_i[15:8]} ; 
                        assign DI[26:18] = {1'b0,
                                    wr_data_i[23:16]} ; 
                        assign DI[35:27] = {1'b0,
                                    wr_data_i[31:24]} ; 
                        assign DI[71:36] = 36'h0 ; 
                    end
                16 : 
                    begin : genblk1
                        assign DI[8:0] = {1'b0,
                                    wr_data_i[7:0]} ; 
                        assign DI[17:9] = {1'b0,
                                    wr_data_i[15:8]} ; 
                        assign DI[71:18] = 54'h0 ; 
                    end
                default : 
                    begin: genblk1
                        assign DI = {{(72 - WDATA_WIDTH){1'b0}},
                                    wr_data_i} ; 
                    end
                endcase
                case (RDATA_WIDTH)
                64 : 
                    begin : genblk2
                        assign rd_data_o[7:0] = DO[7:0] ; 
                        assign rd_data_o[15:8] = DO[16:9] ; 
                        assign rd_data_o[23:16] = DO[25:18] ; 
                        assign rd_data_o[31:24] = DO[34:27] ; 
                        assign rd_data_o[39:32] = DO[43:36] ; 
                        assign rd_data_o[47:40] = DO[52:45] ; 
                        assign rd_data_o[55:48] = DO[61:54] ; 
                        assign rd_data_o[63:56] = DO[70:63] ; 
                    end
                32 : 
                    begin : genblk2
                        assign rd_data_o[7:0] = DO[7:0] ; 
                        assign rd_data_o[15:8] = DO[16:9] ; 
                        assign rd_data_o[23:16] = DO[25:18] ; 
                        assign rd_data_o[31:24] = DO[34:27] ; 
                    end
                16 : 
                    begin : genblk2
                        assign rd_data_o[7:0] = DO[7:0] ; 
                        assign rd_data_o[15:8] = DO[16:9] ; 
                    end
                default : 
                    begin: genblk2
                        assign rd_data_o = DO[(RDATA_WIDTH - 1):0] ; 
                    end
                endcase
                FIFO32K u_fifo (.DI(DI), 
                            .CLKW(wr_clk_i), 
                            .CLKR(rd_clk_i), 
                            .RSTW(rst_i), 
                            .RPRST(rp_rst_i), 
                            .CEW(CEW), 
                            .CER(CER), 
                            .OCE(OCE), 
                            .CSW(CSW), 
                            .CSR(CSR), 
                            .DO(DO), 
                            .ONEBITERR(ONEBITERR), 
                            .TWOBITERR(TWOBITERR), 
                            .FULL(FULL), 
                            .EMPTY(EMPTY), 
                            .ALMOSTFULL(ALMOSTFULL), 
                            .ALMOSTEMPTY(ALMOSTEMPTY)) ; 
                defparam u_fifo.DATA_WIDTH_W = DWID_W ; 
                defparam u_fifo.DATA_WIDTH_R = DWID_R ; 
                defparam u_fifo.OUTREG = ((REGMODE == "reg") ? "USED" : "BYPASSED") ; 
                defparam u_fifo.RESETMODE = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
                defparam u_fifo.CSDECODE_W = "000" ; 
                defparam u_fifo.CSDECODE_R = "000" ; 
                defparam u_fifo.ASYNC_RST_RELEASE = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
                defparam u_fifo.FWFT = (FWFT ? "ENABLED" : "DISABLED") ; 
                defparam u_fifo.GSR = "ENABLED" ; 
                defparam u_fifo.ECC = "DISABLED" ; 
                defparam u_fifo.INIT_DATA = "STATIC" ; 
                defparam u_fifo.FULLBITS = FULLBITS ; 
                defparam u_fifo.ALMOST_FULL = AFULLBITS ; 
                defparam u_fifo.ALMOST_EMPTY = AEMPTYBITS ; 
            end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_soft_fifo.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module ctrl_fifo_ipgen_lscc_soft_fifo #(parameter IMPLEMENTATION = "EBR", 
        parameter ADDRESS_DEPTH = 512, 
        parameter ADDRESS_WIDTH = clog2(ADDRESS_DEPTH), 
        parameter DATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter RESET_MODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 1023, 
        parameter ALMOST_FULL_DEASSERT_LVL = 1020, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 4, 
        parameter ENABLE_DATA_COUNT = "FALSE", 
        parameter FAMILY = "common") (
    //----------------------------
    // Parameters
    //----
    //----------------------------
    // Inputs
    //----------------------------
    input clk_i, 
    input [(DATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(DATA_WIDTH - 1):0] rd_data_o, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [ADDRESS_WIDTH:0] data_cnt_o) ;
    //----------------------------
    // Wire and Registers
    //----------------------------
    (* syn_preserve=1 *) reg full_r ; 
    (* syn_preserve=1 *) reg full_mem_r ; 
    (* syn_preserve=1 *) reg full_ext_r ; 
    (* syn_preserve=1 *) reg empty_r ; 
    (* syn_preserve=1 *) reg empty_mem_r ; 
    (* syn_preserve=1 *) reg empty_ext_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_addr_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_addr_p1_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_addr_p1cmp_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] wr_cmpaddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] waddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] wr_cmpaddr_p1_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_addr_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_addr_p1_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_addr_p1cmp_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] rd_cmpaddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] raddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] rd_cmpaddr_p1_r ; 
    // WRITE address controller
    wire [ADDRESS_WIDTH:0] wr_addr_nxt_w = ((wr_en_i & (~full_r)) ? wr_addr_p1_r : wr_addr_r) ; 
    wire [ADDRESS_WIDTH:0] wr_addr_nxt_p1_w = (wr_addr_nxt_w + 1'b1) ; 
    // READ address controller									    
    wire [ADDRESS_WIDTH:0] rd_addr_nxt_w = ((rd_en_i & (~empty_r)) ? rd_addr_p1_r : rd_addr_r) ; 
    wire [ADDRESS_WIDTH:0] rd_addr_nxt_p1_w = (rd_addr_nxt_w + 1'b1) ; 
    // Flag controller
    wire full_nxt_w = (((((~(rd_en_i & (~empty_r))) & (wr_en_i & (~full_r))) & (wr_cmpaddr_p1_r == rd_cmpaddr_r)) & (wr_addr_p1cmp_r[ADDRESS_WIDTH] != rd_addr_r[ADDRESS_WIDTH])) || ((~((wr_cmpaddr_r != rd_cmpaddr_r) || rd_en_i)) & full_r)) ; 
    wire empty_nxt_w = ((((rd_en_i & (~empty_r)) & (rd_addr_p1cmp_r == wr_addr_r)) & (~(wr_en_i & (~full_r)))) || ((~((wr_cmpaddr_r != rd_cmpaddr_r) || wr_en_i)) & empty_r)) ; 
    assign full_o = full_ext_r ; 
    assign empty_o = empty_ext_r ; 
    //----------------------------
    // Sequential Circuit
    //----------------------------
    if ((RESET_MODE == "sync")) 
        begin : MASTER_SYNC
            always
                @(posedge clk_i)
                begin
                    if (rst_i) 
                        begin
                            full_ext_r <=  1'b0 ;
                            full_r <=  1'b0 ;
                            full_mem_r <=  1'b0 ;
                            empty_ext_r <=  1'b1 ;
                            empty_r <=  1'b1 ;
                            empty_mem_r <=  1'b1 ;
                            wr_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            wr_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            wr_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            waddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                            rd_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            rd_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            raddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            rd_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                        end
                    else
                        begin
                            full_ext_r <=  full_nxt_w ;
                            full_r <=  full_nxt_w ;
                            full_mem_r <=  full_nxt_w ;
                            empty_ext_r <=  empty_nxt_w ;
                            empty_r <=  empty_nxt_w ;
                            empty_mem_r <=  empty_nxt_w ;
                            wr_addr_r <=  wr_addr_nxt_w ;
                            wr_addr_p1_r <=  wr_addr_nxt_p1_w ;
                            wr_cmpaddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_addr_p1cmp_r <=  wr_addr_nxt_p1_w ;
                            waddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_cmpaddr_p1_r <=  wr_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_addr_r <=  rd_addr_nxt_w ;
                            rd_addr_p1_r <=  rd_addr_nxt_p1_w ;
                            rd_addr_p1cmp_r <=  rd_addr_nxt_p1_w ;
                            rd_cmpaddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            raddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_cmpaddr_p1_r <=  rd_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                        end
                end
        end
    else
        begin : MASTER_ASYNC
            always
                @(posedge clk_i or 
                    posedge rst_i)
                begin
                    if (rst_i) 
                        begin
                            full_ext_r <=  1'b0 ;
                            full_r <=  1'b0 ;
                            full_mem_r <=  1'b0 ;
                            empty_ext_r <=  1'b1 ;
                            empty_r <=  1'b1 ;
                            empty_mem_r <=  1'b1 ;
                            wr_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            wr_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            wr_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            waddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                            rd_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            rd_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            raddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            rd_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                        end
                    else
                        begin
                            full_ext_r <=  full_nxt_w ;
                            full_r <=  full_nxt_w ;
                            full_mem_r <=  full_nxt_w ;
                            empty_ext_r <=  empty_nxt_w ;
                            empty_r <=  empty_nxt_w ;
                            empty_mem_r <=  empty_nxt_w ;
                            wr_addr_r <=  wr_addr_nxt_w ;
                            wr_addr_p1_r <=  wr_addr_nxt_p1_w ;
                            wr_cmpaddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_addr_p1cmp_r <=  wr_addr_nxt_p1_w ;
                            waddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_cmpaddr_p1_r <=  wr_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_addr_r <=  rd_addr_nxt_w ;
                            rd_addr_p1_r <=  rd_addr_nxt_p1_w ;
                            rd_addr_p1cmp_r <=  rd_addr_nxt_p1_w ;
                            rd_cmpaddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            raddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_cmpaddr_p1_r <=  rd_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                        end
                end
        end
    //----------------------------
    // MISCELLANEOUS Features
    //----------------------------
    if ((((ENABLE_ALMOST_FULL_FLAG == "TRUE") || (ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) || (ENABLE_DATA_COUNT == "TRUE"))) 
        begin : MISC
            (* syn_preserve=1 *) reg full_flag_r ; 
            (* syn_preserve=1 *) reg empty_flag_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_flag_addr_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_flag_addr_p1_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_flag_addr_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_flag_addr_p1_r ; 
            wire [ADDRESS_WIDTH:0] diff_norm_w = (wr_flag_addr_r - rd_flag_addr_r) ; 
            wire [ADDRESS_WIDTH:0] diff_wr_w = (wr_flag_addr_p1_r - rd_flag_addr_r) ; 
            wire [ADDRESS_WIDTH:0] diff_rd_w = (wr_flag_addr_r - rd_flag_addr_p1_r) ; 
            wire wr_w = (wr_en_i & (~full_flag_r)) ; 
            wire rd_w = (rd_en_i & (~empty_flag_r)) ; 
            wire [ADDRESS_WIDTH:0] diff_w = ((wr_w == rd_w) ? diff_norm_w : (wr_w ? diff_wr_w : diff_rd_w)) ; 
            if ((RESET_MODE == "sync")) 
                begin : SYNC_CON
                    always
                        @(posedge clk_i)
                        begin
                            if (rst_i) 
                                begin
                                    wr_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    wr_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    rd_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    rd_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    full_flag_r <=  1'b0 ;
                                    empty_flag_r <=  1'b1 ;
                                end
                            else
                                begin
                                    wr_flag_addr_r <=  wr_addr_nxt_w ;
                                    wr_flag_addr_p1_r <=  wr_addr_nxt_p1_w ;
                                    rd_flag_addr_r <=  rd_addr_nxt_w ;
                                    rd_flag_addr_p1_r <=  rd_addr_nxt_p1_w ;
                                    full_flag_r <=  full_nxt_w ;
                                    empty_flag_r <=  empty_nxt_w ;
                                end
                        end
                end
            else
                begin : ASYNC_CON
                    always
                        @(posedge clk_i or 
                            posedge rst_i)
                        begin
                            if (rst_i) 
                                begin
                                    wr_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    wr_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    rd_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    rd_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    full_flag_r <=  1'b0 ;
                                    empty_flag_r <=  1'b1 ;
                                end
                            else
                                begin
                                    wr_flag_addr_r <=  wr_addr_nxt_w ;
                                    wr_flag_addr_p1_r <=  wr_addr_nxt_p1_w ;
                                    rd_flag_addr_r <=  rd_addr_nxt_w ;
                                    rd_flag_addr_p1_r <=  rd_addr_nxt_p1_w ;
                                    full_flag_r <=  full_nxt_w ;
                                    empty_flag_r <=  empty_nxt_w ;
                                end
                        end
                end
            // Almost Flag Controller
            if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                begin : AFull
                    wire [(ADDRESS_WIDTH - 1):0] almost_full_tick_w = (((ALMOST_FULL_ASSERTION == "static-single") || (ALMOST_FULL_ASSERTION == "static-dual")) ? ALMOST_FULL_ASSERT_LVL : almost_full_th_i) ; 
                    wire [(ADDRESS_WIDTH - 1):0] almost_full_tock_w = ((ALMOST_FULL_ASSERTION == "static-single") ? ALMOST_FULL_ASSERT_LVL : ((ALMOST_FULL_ASSERTION == "static-dual") ? ALMOST_FULL_DEASSERT_LVL : ((ALMOST_FULL_ASSERTION == "dynamic-single") ? almost_full_th_i : almost_full_clr_th_i))) ; 
                    reg almost_full_r ; 
                    reg almost_full_ext_r ; 
                    wire almost_full_nxt_w ; 
                    if (((ALMOST_FULL_ASSERTION == "static-single") || (ALMOST_FULL_ASSERTION == "dynamic-single"))) 
                        begin : genblk1
                            assign almost_full_nxt_w = (~(diff_w < almost_full_tick_w)) ; 
                        end
                    else
                        begin : genblk1
                            assign almost_full_nxt_w = ((~(diff_w < almost_full_tick_w)) | ((diff_w > almost_full_tock_w) & almost_full_r)) ; 
                        end
                    assign almost_full_o = almost_full_ext_r ; 
                    if ((RESET_MODE == "sync")) 
                        begin : genblk2
                            always
                                @(posedge clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_full_ext_r <=  1'b0 ;
                                            almost_full_r <=  1'b0 ;
                                        end
                                    else
                                        begin
                                            almost_full_ext_r <=  almost_full_nxt_w ;
                                            almost_full_r <=  almost_full_nxt_w ;
                                        end
                                end
                        end
                    else
                        begin : genblk2
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_full_ext_r <=  1'b0 ;
                                            almost_full_r <=  1'b0 ;
                                        end
                                    else
                                        begin
                                            almost_full_ext_r <=  almost_full_nxt_w ;
                                            almost_full_r <=  almost_full_nxt_w ;
                                        end
                                end
                        end
                end
            else
                begin : genblk2
                    assign almost_full_o = 1'b0 ; 
                end
            // Almost Empty Controller
            if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                begin : AEmpty
                    wire [(ADDRESS_WIDTH - 1):0] almost_empty_tick_w = (((ALMOST_EMPTY_ASSERTION == "static-single") || (ALMOST_EMPTY_ASSERTION == "static-dual")) ? ALMOST_EMPTY_ASSERT_LVL : almost_empty_th_i) ; 
                    wire [(ADDRESS_WIDTH - 1):0] almost_empty_tock_w = ((ALMOST_EMPTY_ASSERTION == "static-single") ? ALMOST_EMPTY_ASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "static-dual") ? ALMOST_EMPTY_DEASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "dynamic-single") ? almost_empty_th_i : almost_empty_clr_th_i))) ; 
                    reg almost_empty_r ; 
                    reg almost_empty_ext_r ; 
                    wire almost_empty_nxt_w ; 
                    if (((ALMOST_EMPTY_ASSERTION == "static-single") || (ALMOST_EMPTY_ASSERTION == "dynamic-single"))) 
                        begin : genblk1
                            assign almost_empty_nxt_w = (~(diff_w > almost_empty_tick_w)) ; 
                        end
                    else
                        begin : genblk1
                            assign almost_empty_nxt_w = ((diff_w < almost_empty_tock_w) & ((~(diff_w > almost_empty_tick_w)) | almost_empty_r)) ; 
                        end
                    assign almost_empty_o = almost_empty_ext_r ; 
                    if ((RESET_MODE == "sync")) 
                        begin : genblk2
                            always
                                @(posedge clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_empty_ext_r <=  1'b1 ;
                                            almost_empty_r <=  1'b1 ;
                                        end
                                    else
                                        begin
                                            almost_empty_ext_r <=  almost_empty_nxt_w ;
                                            almost_empty_r <=  almost_empty_nxt_w ;
                                        end
                                end
                        end
                    else
                        begin : genblk2
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_empty_ext_r <=  1'b1 ;
                                            almost_empty_r <=  1'b1 ;
                                        end
                                    else
                                        begin
                                            almost_empty_ext_r <=  almost_empty_nxt_w ;
                                            almost_empty_r <=  almost_empty_nxt_w ;
                                        end
                                end
                        end
                end
            else
                begin : genblk3
                    assign almost_empty_o = 1'b0 ; 
                end
            // Enable Data Count Controller
            if ((ENABLE_DATA_COUNT == "TRUE")) 
                begin : genblk4
                    reg [ADDRESS_WIDTH:0] data_cnt_r ; 
                    assign data_cnt_o = data_cnt_r ; 
                    if ((RESET_MODE == "sync")) 
                        begin : genblk1
                            always
                                @(posedge clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            data_cnt_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                        end
                                    else
                                        begin
                                            data_cnt_r <=  diff_w ;
                                        end
                                end
                        end
                    else
                        begin : genblk1
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            data_cnt_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                        end
                                    else
                                        begin
                                            data_cnt_r <=  diff_w ;
                                        end
                                end
                        end
                end
            else
                begin : genblk4
                    assign data_cnt_o = {(ADDRESS_WIDTH + 1){1'b0}} ; 
                end
        end
    // -----------------
    // -- FIFO MEMORY --
    // -----------------
    wire wr_fifo_en_w = (wr_en_i & (~full_mem_r)) ; 
    wire rd_fifo_en_w = (rd_en_i & (~empty_mem_r)) ; 
    if ((IMPLEMENTATION == "EBR")) 
        begin : mem_EBR
            (* syn_ramstyle="block_ram" *) reg [(DATA_WIDTH - 1):0] mem [((2 ** ADDRESS_WIDTH) - 1):0] ; 
            reg [(DATA_WIDTH - 1):0] data_raw_r ; 
            reg [(DATA_WIDTH - 1):0] data_buff_r ; 
            assign rd_data_o = ((REGMODE == "reg") ? data_buff_r : data_raw_r) ; 
            always
                @(posedge clk_i)
                begin
                    if ((wr_fifo_en_w == 1'b1)) 
                        begin
                            mem[waddr_r] <=  wr_data_i ;
                        end
                end
            always
                @(posedge clk_i)
                begin
                    if ((rd_fifo_en_w == 1'b1)) 
                        begin
                            data_raw_r <=  mem[raddr_r] ;
                        end
                end
            if ((REGMODE == "reg")) 
                begin : mem_reg
                    if ((RESET_MODE == "sync")) 
                        begin : sync
                            always
                                @(posedge clk_i)
                                begin
                                    if ((rst_i == 1'b1)) 
                                        begin
                                            data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                        end
                                    else
                                        begin
                                            data_buff_r <=  data_raw_r ;
                                        end
                                end
                        end
                    else
                        begin : async
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if ((rst_i == 1'b1)) 
                                        begin
                                            data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                        end
                                    else
                                        begin
                                            data_buff_r <=  data_raw_r ;
                                        end
                                end
                        end
                end
        end
    else
        if (((FAMILY == "LIFCL") || (FAMILY == "LATG1") || (FAMILY == "LAV-AT"))) 
            begin : mem_LUT
                (* syn_ramstyle="distributed" *) reg [(DATA_WIDTH - 1):0] mem [((2 ** ADDRESS_WIDTH) - 1):0] ; 
                reg [(DATA_WIDTH - 1):0] data_raw_r = {DATA_WIDTH{1'b0}} ; 
                reg [(DATA_WIDTH - 1):0] data_buff_r = {DATA_WIDTH{1'b0}} ; 
                assign rd_data_o = ((REGMODE == "reg") ? data_buff_r : data_raw_r) ; 
                always
                    @(posedge clk_i)
                    begin
                        if ((wr_fifo_en_w == 1'b1)) 
                            begin
                                mem[waddr_r] <=  wr_data_i ;
                            end
                    end
                always
                    @(posedge clk_i)
                    begin
                        if ((rd_fifo_en_w == 1'b1)) 
                            begin
                                data_raw_r <=  mem[raddr_r] ;
                            end
                    end
                if ((REGMODE == "reg")) 
                    begin : mem_reg
                        if ((RESET_MODE == "sync")) 
                            begin : sync
                                always
                                    @(posedge clk_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            begin
                                                data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                data_buff_r <=  data_raw_r ;
                                            end
                                    end
                            end
                        else
                            begin : async
                                always
                                    @(posedge clk_i or 
                                        posedge rst_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            begin
                                                data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                data_buff_r <=  data_raw_r ;
                                            end
                                    end
                            end
                    end
            end
        else
            begin : mem_REG
                (* syn_ramstyle="registers" *) reg [(DATA_WIDTH - 1):0] mem [((2 ** ADDRESS_WIDTH) - 1):0] ; 
                reg [(DATA_WIDTH - 1):0] data_raw_r = {DATA_WIDTH{1'b0}} ; 
                reg [(DATA_WIDTH - 1):0] data_buff_r = {DATA_WIDTH{1'b0}} ; 
                assign rd_data_o = ((REGMODE == "reg") ? data_buff_r : data_raw_r) ; 
                always
                    @(posedge clk_i)
                    begin
                        if ((wr_fifo_en_w == 1'b1)) 
                            begin
                                mem[waddr_r] <=  wr_data_i ;
                            end
                    end
                always
                    @(posedge clk_i)
                    begin
                        if ((rd_fifo_en_w == 1'b1)) 
                            begin
                                data_raw_r <=  mem[raddr_r] ;
                            end
                    end
                if ((REGMODE == "reg")) 
                    begin : mem_reg
                        if ((RESET_MODE == "sync")) 
                            begin : sync
                                always
                                    @(posedge clk_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            begin
                                                data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                data_buff_r <=  data_raw_r ;
                                            end
                                    end
                            end
                        else
                            begin : async
                                always
                                    @(posedge clk_i or 
                                        posedge rst_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            begin
                                                data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                            end
                                        else
                                            begin
                                                data_buff_r <=  data_raw_r ;
                                            end
                                    end
                            end
                    end
            end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule


