
`pragma protect begin_protected

`pragma protect version=1
`pragma protect author="Lattice Semiconductor Corporation"
`pragma protect author_info="Lattice Semiconductor Corporation"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
MqaDCBNYg5BVkMX4Kaf/J63Ll8fCOxrVN6EdzKfpSCTxT3MHJwOFZPjKmXnwwrOk
y7VJZxv15sD9xkqMSxWJ+6JOtSxSS3k2cFwhE+68qXrwlZd380upsBhKdb+rkbw7
nYrFumLPA1oakurH9XtllLRjuTkF3sKnq2xbK2RAKr3yE9yKYvEfi/5hPCky5cQF
r+7rzkvOiksq9VI/PGp12XSQZIDHCwqufXLLvbR3nIX0apWrvBOkEzbBRKMisNki
pFMRouRaqZbI+5a7yHL3BMRic8gNOHUH5waZMqXgx8JKkirEnq0JaT7aymyNUl9j
MLh8B/3ud6Aem6zetVWAMA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
ck0XRfSXTt279qtwPAbL43pplF/Z0ZGXOCWUcT38b6uOK5PAIdUTB6PKWmAXUVzb
haZpZLqd3B+8Ors1rX5WLebTjBnQU+u6LL/Tl3GavgkrXBdaQDXOEFka++mlr5n6
brQtUN0UR/KpugF9nzUg6paMix7ZBr/X7yGrZisxpuA6jhBWvFWVFIBKzJwUXRqg
fsK4dR4FucbbHg5Mnt4txX71jz1vYxp5FoURxhMfNuKq6Tinme//aafAMlpPdSmB
weBu8b0G1WHy7m7SMNWFuvq+UgLlRqsD9/L8JiWF7BzpyXGZlYSJwJdTEajEIukH
IE49AHiW6tiV5KJpd25mwA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIF-SIM-RSA-2"
`pragma protect key_method="rsa"
`pragma protect key_block
FMYK0vknOr1YFOlPekPnPV4axHDMFrUpxDHZmqGowLj+1Wd3iBmIOclfV8CE+PzH
eGKtKFgHWWLVLJbjyhXUrl16Nii3oNYW8Sdza33ZrXzVsN7dT7FqmYzTo1yYhxCU
8BnsM1qCfAiIozr1RDB0ZPirpFLwdafAvRkm6leP4G87Lfz0zKciiYjd6RUMsBlF
bz91EnVNM5Aj9d6eXTZ/rXHuc3iNSGYMTEOnueFghuE4yu13YFvUNSuWLId+W+ho
IUwSxVPNpePi+3DGwMI6SgQ8BIqHy/uREX4YDLhwKRRCrX4ZBrd0KSQQrKT0YQTu
cRxAqwrcLDYYaXi39FROdQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
E8KkZF/eoM7Ix+eGFbn4hnyI4O9gPPcV8N797S2IBBf2OjDGtWz5NjWOQcxmkBJQ
zQ8OAw6Ad7VBvJ8fNjXNUmBImMbWXkydCZMQQPU7FFLUY7t0ixtbWE97fsHEpFDt
gCV7mlBKcbK5HHXe3+3L/Xi9fhnM3T/U5j87sPBQrnY=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Aldec"
`pragma protect key_keyname="ALDEC15_001"
`pragma protect key_method="rsa"
`pragma protect key_block
b/5PKXRfHTqwg9usqbCvkDptgCF+iVtkF9kylCkSXIraGBArpdB7lyL4bpS1qkrn
/GLAwVlpcWDrHzhndtSPhfR/APSv4ruyhuzRnmNDHs9nG/0te5pOPjufAWtRgF8h
Pmzj7vF7nTDEKfRlzAS3d9+S7L/uEmFSUXmKE6eJlhnLW3aIvj/LZtcNJjrmR8Sd
1xqPtYy2XEyUjaBTiffgmD0KGEM3ZPEvOZZhRNm1VkY7X3xcMGWtFi78xG2/tm2A
1McXkvcyQlwjzCHx7s7sxEhDitdOGRF38HRmCuulP+7a0ehHGtKiGpz7lkS+4Nz7
9XbT3CWwtL6UarB1fEE+GQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Cadence Design Systems."
`pragma protect key_keyname="CDS_RSA_KEY_VER_1"
`pragma protect key_method="rsa"
`pragma protect key_block
PGQGnMMBOgn4bgmQCN3AVFNTySpl5l6LE+7uz6iRlf4blnr/b9XvQ0H7TBbW68bu
/7R2TPgui5soiJb86yNmJG9DbvbZdR6KDI8vmA8X6T4GTfN+R0KkwVKbK2nZEV9s
oz2CjII8YG4EGDai+lh2Dble8EdYTiYFm9TNE9jU0i4+xgyJCl+1qZrSfIT76cKg
OFAfjCG9v8mVpiiCPGCHqDaKzyu8rz5BpwyN5qF4XXiniZXuCfjiyojzE5W7nSPH
htWgHITfFEAS2sdQLVB0YLlcjx+P1Cekde/giurkE8f6Ep8JP+T9fflhTpYbkr82
qFduV01sIJ6ZSPMjnoBXRg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
rbJyqoNpJ3Ja9zUvba3JRKpx5S/LwK+mZqogUlL7h2r/+1TFwQ/wn0ZMkuO2PyAb
c0ozRxzcuo6xqbX6ylipvBBd+ouAsvFZAOSiDH/upCV7jQozp4YWJlBKkV658qM8
rU8GM8Cl1ARcrgVBJtxg7UuQjT8Y5eGUza7Gp8AYu+JuEpO2VDv0zPSbfUO7AGWd
Q2w9xxX3PgEHoA8tp9lvmYUTRm9dEsBFieXeGusy7B20ATW8pbYAazhGDWu8GVsW
AysYyKLPR39ODSLCxzbFV4Eov/sycItz2qS8yPHmDA+mbHED5JUbgQ1RoP5S1trF
k8zo0/m3qG10KLMKYWk2hQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=384)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_3"
`pragma protect key_method="rsa"
`pragma protect key_block
YtMd7lfCyhGXx8YlOB1SU9EwonNHG4UHQHtcOjenR4iNwje4D5VARcSmSEUb9sAE
mGipAzklb7oo9M0g8wMg5+CQIzXqLXnEoyCVN5hI9psAgX85sMlMzH3Wq9Beifp7
2SIVxpueLFiSKQWXcptHn/7uL4Ng8tBlkaqQ9RFnOAOsCvES7RrvzwaLX7D7BbK0
b932rgvuLXSfmh0WT1Zryf7fNngN3ZqxRIsvML5eM02Guhf3rRKv1r/87VJXb3Jv
wt9tyz4IrDM4lQkQcr8kE3MuYEzdGXQ81AyS0mArP3A9uzIOAQjs9ZqXb4kG/C9b
GI1IoR/OA2LmP3WHd1Kp/dPoux2aKuACbWxvjsrl2jyCAF8HPbIfD0iTrHZ/yTQc
bXRmCOB+MiKs90OiOocIiX4BZiaUiCGTHIpGu4MqZkoaADZz04LuZG5FtCVFPIFR
tCvjGfYXMQOS+cCmUgwGpJxw4jtXWhPlz9p28szkU2SEIjwi3MHzL/3pkOEBGdqC

`pragma protect data_method="aes256-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4128)
`pragma protect data_block
M6moaoL01XlcVeZZwgkHq6Rd8VqPODwh9JEyE3F4ZpsNCrmhHlqprDQ+ITYXiGVu
ue2BXbXj6HpSVJ1BtN479l3kBeRVQkrYNpV5hQWsy2GU7l+aFYUyvkAocoNxE6nF
ZSv0WtD6Ruq6lnmUL4BlzE305uXvBv72ya7Y6hC64npmnGMlfQdCxVn24iB4p0TT
i8tKsV5w3ZmUAdxxFOCGfL7M2FxbkRjd+Bce0iC7dPGqy0BK4Fj/OQZoP1Yu7ImH
9OxuP4KcHxliafG/qvhi68hklwzUcB8W6k8laoHoacnCV7zWF9G8M7pAhvHi+Y+O
On0AzzgrAJXRHqgeAwc6BVogO2VkTtQpLv3Y2FsOJZW03aNqNWQEEafD6MwFCfiX
JRB3CENPjC3F9vzxbRMDE7aoEHuqU97xYs/BIVXcwKyBuRY3kQoeUy8/EIOYcLMV
WFQb7pXiHzXYE1O0LLfxhplqkndTq4jgXGptW58OvNjqXOcbYDDDNovkJ95Faxwo
cG0/e4FFdqPgUbf2e1REuIjyTHl70ihMJldo8L1k7ASAL3UriOCPHFAnD2xrAb3M
1YJ4EtYVrZXZaGxbap1EyXR3wu6wEdDeCqKeffGALVX/uZiuFrjBVVPrQmTy4RP+
bFtDvjJ0RZ+uJ3uLgUGB2L3ee1BBdbfK1gKp9Ahfbquh3pZ8gb2r891dErbEYvHQ
10bH5gmrT4vd4j9FJuMvQieTOrPYH13PFQdXvPv5BdfRSh3WUYZBBGY9lcRdbIwp
uPgxxmF5IjCtmYDm4JYTq1GQVr2Z1QWNEWimeQv1ilk4Lc1Hxt4Y+gEz3fv4KfpX
pWcs6D9RtbGEgXmD4gDl5Oeywv0HTDHman8sZXJ/zo9GTgzkLSas/J5mGGXPKNo0
FjFgIrn7vmyj1kknwM2baR3KHLkN69gg49Y+35lV9g0zvANDUmWN8qMTDgYzBvll
0VnhNQwlyBT9miGG+NFHzAgLscdrs3V+tY1Tj0JtMcnrkwBbPewAu2GbJFcBNefn
VDNx7uRgLjkwEmpzTdqH3leDiOk+hJKFc0jNWxrf73hmx8JyeUhv3NfCSNISlOoF
HsC+UymO4AkYfWQw6onnfUeIe1jYjK6NIlGHj7R0hm5LxMEJ2AZVulUsjyeeYQ+o
/AJFO1xAdAWAJCzbGZ2y9r+zXw9jvL9bCMjUbUVOHl+oWN48AdaB0U3HWD1EE44i
JEmUesqqg4STzDurh6Fq1sHYybw1/3Ui98UTHmGEvUVBRKJyuNJaCpknUWU3ZYz6
rNHYOXdOSLnxsXWKY19ikNgpIJp4CE1kizr9hA18FX+d3ATyRpuZo3J1u2drBUG6
q/VrzArRFCpbPYYK8fxmgCI02axSsu5AE7GkXSnzsmwXKXx98fTlTyTZ5XUb2X75
fakyVRcH4dZfSdmBkNJBxASWJQnpZfmBbGFSdVcavCVcjrvPquVsJjAFbcvpDjqg
nJciHucBwWv2W+FThNGcK4mjP+P2hoSuuTd1kSDuE0Y/iQQtGGWGM8DWOJqgQuyr
o9zkGPi2EdUAuSb8RAvrYf11J+rd2BJGoF/tFsS9DkcUHJcaTECRYpCfY945KkRF
hLZuk4kukuKMMYXir2sdrkI2XuU/eWyRcX4MsEHwFIvl3HOFAQSEayLgY1Y40fp+
PtNNY/sBZUmLm74WV9KA/o9uwxxgRl8OkVrThLZ8VVpi4/ZyPU24ZmN8iIa2iydb
Uxkr1pSn+IOlPHjR4HjmuzcA5cvvxivsx7g8u4q8z3LF8pWOY6+wpoCrF0R8GQyt
xBaL8KjGRK3sDjLQ/DFw0o6vKxjycD4Rasm0qpVsJS6zB00AA4+6+T271hrgeM45
Mon464IinNpqoRXfZHv1nvfOOOjhkRv4ZuNYE9ji0J1q4bOfge5BCF/hlPEbCzTD
r4hRZKcCsO/G8XXRDlWh/Nfa6/8kvKu0kzEhcfDZUEWqFTSll9NSdojjGlY3hu0Q
+KG6FTD9da+TsApLiOIk9eXnHUE3g8RlFbHXdCSjMASU4BZ6uFMogCq0/0iJaLlI
5wOGTKCCCqa8f+hWgHSFZnsAMF32i92lLoSkFH6odhpb/NDQ8h0XCRlzi/aH3BB0
ei6EP8z02FCjffDmoPlDrC9BKge8WJqJLFqrE30aWJLg3xcUm9rwgoKomETQcJhb
PxQIi4hJ0hCpPYn438Ghtp8r5Tp4cmRQQn/DbKcseegbHIIYQtTtqxHHb1QjBC0o
fAqJQJvyULELOyA4VEQ8tXbJ/uHk7iMvMylMYGsSf7eBfJ6iXlqJe6lybKtv7mWL
gCGiTYQyqoACHUcuhfH/1hR9LT8kpVdyEUr/Kr+jiFg1sZvR+NoM7J2D8FzfipQO
Sctha/hEnryU4ognCRtDAh1hyknecgYDex0QmgYvFYNEX9DFQaZlR424apVK794r
Gtax7rKPLmkpl+xhtpbFVFnGYBED7K8qCpR2RYitR9maAplmBJa4LdtPjEgiSeu8
62kpNsGbGLBDumiIngZxwDus4SUrkuIfGDnm3Vcpnpi/zeTphM01Mr3gx3Aban9W
0qeXOX3v8RMTpP975meMH1lC2LZ6Chvt2YvjlsApdM5gH9ldCss1FsZu4ezihfkE
vEX7R3Eril5D9Ga3cY9DZtoLeB/A51NWT6cAqY9Q23TuVn/fvUdbI3oihncIVRJ/
cxj1eTVKOVBlQH2csll+KhbnhIBwrG4Q3rzHCrOgvvDuT0gJF906+Ib5BsY+esBu
xgA+YKwtyhMw5v6sHMoaYJLRZZZTvKvqSxHUSp52aO868AMO4v/7GHjyMdgrn2nd
d7YbTQmRG/Dq1omtQKXUWIbbF7DD1I98GnLzS63jkez5rmVRZzdA7VgnQ32OJNza
rAonvJxKsxkJs9kAqI/+bF1PdCEK3zLjnuJRP1IcMFZ3QdStNyHfbMkhCVyyew+4
zFs3tdxCRBcj5vIqlEZN9GLBwxtrHgahO4U/ulQ+vuqPn7LRen6x6qg13Yz+V3WS
8jjcnalDuzFpoQvtZfLmyKmVI/y5Vhfc2VYq0DvGHsIJjR99yNX+rHOV0Jn7Jrnb
tth6xbkiCxyljQ8jhhys3PgZiLW1ByU6MPsCtl6ujiWFCrWqKVkIULj+3w7IB8T8
ekfqOLz5MSoZIwkkC5EABNapO5u3P6ZaSLhaR/s08UMgj7TWj0UVRamrYCL22UP9
aOVYn7pLHsxAcf4/C4U/4YM8FZ6qDO0Tn245kJAOljupi/wd3OjxFE5GJcPbOeih
ZTJeRSI4XFFu1cxdmkMsUMxtqVleg8HDJ36OYCICjSOiMH1ysMnJwBET7gr0JlhV
bECKtJRZCvkjEFG71bh1+JCEt9G+AzDFUbgwlpsWw2QTuk7116OsfMrw8w7MWfsr
OKGp3kipGjvu95BIDaM0rU++ZCw8ElKfNfGIsms9EU9lULE0U9uzmYUYIioqBGut
dZCOrJ+/YeAqE5uRQhO3hGT2DpjmJcVgXuprNyn0v7xGI6LltCc+U5LKjhqf4aDN
WZqMNys3U3JHvUzA051UZvx1S/BL/d+DqHA9BymUaGbp3fbROA/hyQlQS7pMZ7VJ
KqmBSjfcHY+Be3VH7yADQ0FVl8uiJe0tO6RQ4tbzpE4mVRvDTcbjaZVZMQ+60vbS
q+aIbUq5Dh4d2s8rGfNhb2pmk3SsTQiR8uYJUZSG5lfae0djdYpcMnazYKa34qbH
lURh7FmNdUhJG+ECGVYcI2ASZ5ldgKpl0WWkUFjqxSOcT7KCDHQQkjsLYysfKT17
nccJMz326iQRcQn2TV2v7CH+6ejVJ7BfR0XyRfFjAx9Zfso+zurYYwl5TMvQcVRG
pYmMPl08VwmqFHrAAyf+GQIuufc1+a72qW1t6ZoVWQLT2Lq3jULRdx2j8kYN09V+
aJGxwKjEvp4g6wbw9oP0U1pGWZGLaSPA3svlk+rPXXk718Lo5W/eeTZ6GZ2BRRvc
EyoRnH2LxgOTS2zU1TIBQdu1MmSll7rXjwHxID135owKg9L0eivLtcq6mwQVv06v
E5XhS7XF5VWRLkJ1ac8m3OvOULcLxZwN4tctzHpnkceV1Gln16SFg7naIEJXomjh
VoTzPyJDfuWe2/B9nrlghoo5C44u2lUyAK7mW4+QXnqc9SnBLxNWqnPsTpgOs9YJ
Lp9cmSBbG13ipTRZw/3163Wxc/7lvLfoHeWNXwZnO7rv1KnIcAco873nn5+pYNPW
2tR8+WajvFdDB12oWVabdZ2+CQab5W2Qg1VcKq+ZJAX9A0iayzo42pNzUeK4YZib
3wkZRf/DUmxRVPp9B2qd7HqMichPWzR4Pr/BgFWhOAFdJJQKbttL4Z5uoOpysQ00
BwbAWn4WyIhOhY1dqXaujJPpaUQsF0yi2kgTeKqbvUXvcux6xoSkor/aRkND5qpc
8GJJL20WDKd+Mzjrkf8C4M1knH41zM4jbUjyN3GrwhQvRrNtd+XKn8T5+RKjsW6e
hH2ntuay89nOTFVJ+5eeZ05rA5gH1+Qs9evVtX7kZDWomPL1DYh9OloN0keJiHDN
Az+l4aPcIP3YzPGVUwPcDrSRVh4TbSNuQvPpDjrtyfayMt9X53GGuWDnAMHlwOPX
WGxy74bT/2OKF4wbCBLFlZEuyiyptt6exbDx006aarG677famFPBK/C/BQwSnlOW
YKenyWD+4Ln/m1d0nJXaJqHWXAYXY//B1HT9U3WOjlODvRjYGI7Z7QSuDgNoDwrR
+JIxNnUJeHE1vf5GCouCw023HE8ABsjR8VUB1MzggamQLTWjbGORs8Hgr3twknbE
LReHa840mvCRtD9GcU5qiptDosHxGCrkeI7qYS3MCPoY/jll6DExOWA3dtjnHMX0
lz9RoXzPjJnCysxrtM7hGNIz6JW7dygzQNLtQ0siYXahhULxc9h7RRT+VukStXrO
QwF4Z81iZtWSxqf/B6W6Io3QgFgxmfMF2f9yflpZ3SI5YPjxPhU/LenyfJ/KG/dG
mpgYM7MKOuOkcJnUaVl7JAr6FgpM04uwxs9WHkRdTuZRXz1IvaAghW7kC72AZb9t
jZ2Eemtxo3ps4xI4qHgiQBgQpyThAyt6SQptzgHdAGz5hOAogwXNi3DEwfzkBulw
j/Nyu3mK+WYP1Ocd5yrXWGHVZZgIlx6TCSJkVQ2qQsVVdyyssCyAeHuZfzhKSuFE
9e5OaZcrBDvhOoPcDotk/v3R58oWQEGYqiLKi+WscVTVfE/t5L+gm5RVUQxEtEPA
7PvwnIGamLCuvhpGJAT/XGEu/v93elkk0INhfloxmYLYPu9TE5b6IthmuJqjg7vX
3FLgM5NuDrZ7mAKT9tXfQfVgti2WDnIl3R/5lp+a9eO9LyNuOlb33Aoj+bt+BJyR
HLQtNczklTZ6617FgeiCPWiPZz+Z0Y4nXGc33FXTIfstxC9gc9aCKUmzfFpxiGUw
v7ouUlzsJMCp/TjqoT2FjQk86h6gHDq3HN2t2EIpEIAKzQp+KKLl4nfDsdKdLvNE

`pragma protect end_protected


/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Propel (64-bit)
    2023.1.2306260112
    Soft IP Version: 2.1.0
    2024 10 03 15:58:01
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module new_lpddr4 (pll_refclk_i, 
        pll_rst_n_i, 
        areset_n_i, 
        aclk_i, 
        rst_n_i, 
        pclk_i, 
        preset_n_i, 
        pll_lock_o, 
        sclk_o, 
        irq_o, 
        init_done_o, 
        trn_err_o, 
        axi_arvalid_i, 
        axi_arid_i, 
        axi_arlen_i, 
        axi_arburst_i, 
        axi_araddr_i, 
        axi_arqos_i, 
        axi_arsize_i, 
        axi_arready_o, 
        axi_rdata_o, 
        axi_rresp_o, 
        axi_rid_o, 
        axi_rvalid_o, 
        axi_rlast_o, 
        axi_rready_i, 
        axi_awvalid_i, 
        axi_awid_i, 
        axi_awlen_i, 
        axi_awburst_i, 
        axi_awaddr_i, 
        axi_awqos_i, 
        axi_awsize_i, 
        axi_awready_o, 
        axi_wvalid_i, 
        axi_wdata_i, 
        axi_wstrb_i, 
        axi_wlast_i, 
        axi_wready_o, 
        axi_bvalid_o, 
        axi_bready_i, 
        axi_bresp_o, 
        axi_bid_o, 
        apb_penable_i, 
        apb_psel_i, 
        apb_pwrite_i, 
        apb_paddr_i, 
        apb_pwdata_i, 
        apb_pready_o, 
        apb_pslverr_o, 
        apb_prdata_o, 
        ddr_ck_o, 
        ddr_cke_o, 
        ddr_cs_o, 
        ddr_ca_o, 
        ddr_reset_n_o, 
        ddr_dq_io, 
        ddr_dqs_io, 
        ddr_dmi_io) ;
    input pll_refclk_i ; 
    input pll_rst_n_i ; 
    input areset_n_i ; 
    input aclk_i ; 
    input rst_n_i ; 
    input pclk_i ; 
    input preset_n_i ; 
    output pll_lock_o ; 
    output sclk_o ; 
    output irq_o ; 
    output init_done_o ; 
    output trn_err_o ; 
    input axi_arvalid_i ; 
    input [1:0] axi_arid_i ; 
    input [7:0] axi_arlen_i ; 
    input [1:0] axi_arburst_i ; 
    input [30:0] axi_araddr_i ; 
    input [3:0] axi_arqos_i ; 
    input [2:0] axi_arsize_i ; 
    output axi_arready_o ; 
    output [255:0] axi_rdata_o ; 
    output [1:0] axi_rresp_o ; 
    output [1:0] axi_rid_o ; 
    output axi_rvalid_o ; 
    output axi_rlast_o ; 
    input axi_rready_i ; 
    input axi_awvalid_i ; 
    input [1:0] axi_awid_i ; 
    input [7:0] axi_awlen_i ; 
    input [1:0] axi_awburst_i ; 
    input [30:0] axi_awaddr_i ; 
    input [3:0] axi_awqos_i ; 
    input [2:0] axi_awsize_i ; 
    output axi_awready_o ; 
    input axi_wvalid_i ; 
    input [255:0] axi_wdata_i ; 
    input [31:0] axi_wstrb_i ; 
    input axi_wlast_i ; 
    output axi_wready_o ; 
    output axi_bvalid_o ; 
    input axi_bready_i ; 
    output [1:0] axi_bresp_o ; 
    output [1:0] axi_bid_o ; 
    input apb_penable_i ; 
    input apb_psel_i ; 
    input apb_pwrite_i ; 
    input [11:0] apb_paddr_i ; 
    input [31:0] apb_pwdata_i ; 
    output apb_pready_o ; 
    output apb_pslverr_o ; 
    output [31:0] apb_prdata_o ; 
    output [0:0] ddr_ck_o ; 
    output [0:0] ddr_cke_o ; 
    output [0:0] ddr_cs_o ; 
    output [5:0] ddr_ca_o ; 
    output ddr_reset_n_o ; 
    inout [31:0] ddr_dq_io ; 
    inout [3:0] ddr_dqs_io ; 
    inout [3:0] ddr_dmi_io ; 
    new_lpddr4_ipgen_lscc_lpddr4_mc #(.SIM_VAL(0),
            .FAMILY("LFCPNX"),
            .DDR_TYPE(1),
            .IO_TYPE("LVSTL_I"),
            .CK_DQS_IO("LVSTLD_I"),
            .DDR_CMD_FREQ(400.0),
            .SLEW_RATE("MED"),
            .GEAR_RATIO(8),
            .ECC_ENABLE(0),
            .PWR_DOWN_EN(0),
            .DBI_ENABLE(0),
            .READ_LATENCY(10),
            .RD_PREAMBLE(2),
            .RD_POSTAMBLE(1),
            .WRITE_LATENCY(6),
            .WR_PREAMBLE(2),
            .WR_POSTAMBLE(1),
            .CPU_GRP_EN(1),
            .PLL_EN(1),
            .INTFBKDEL_SEL("DISABLED"),
            .PMU_WAITFORLOCK("ENABLED"),
            .REF_OSC_CTRL("3P2"),
            .REF_COUNTS("0000"),
            .EN_REFCLK_MON(0),
            .CLKI_FREQ(100.0),
            .CLKI_DIVIDER_ACTUAL_STR("1"),
            .FRAC_N_EN(0),
            .FBK_MODE("CLKOP"),
            .FBCLK_DIVIDER_ACTUAL_STR("1"),
            .SSC_N_CODE_STR("0b000000001"),
            .SSC_F_CODE_STR("0b000000000000000"),
            .SS_EN(0),
            .SSC_PROFILE("DOWN"),
            .SSC_TBASE_STR("0b000000000000"),
            .SSC_STEP_IN_STR("0b0000000"),
            .SSC_REG_WEIGHTING_SEL_STR("0b000"),
            .CLKOP_BYPASS(0),
            .ENCLKOP_EN(0),
            .CLKOP_FREQ_ACTUAL(100.0),
            .CLKOP_PHASE_ACTUAL(0.0),
            .DIVOP_ACTUAL_STR("7"),
            .DELA("7"),
            .PHIA("0"),
            .TRIM_EN_P(0),
            .CLKOP_TRIM_MODE("Falling"),
            .CLKOP_TRIM("0b0000"),
            .CLKOS_EN(1),
            .CLKOS_BYPASS(0),
            .ENCLKOS_EN(0),
            .CLKOS_FREQ_ACTUAL(400.0),
            .CLKOS_PHASE_ACTUAL(0.0),
            .DIVOS_ACTUAL_STR("1"),
            .DELB("1"),
            .PHIB("0"),
            .TRIM_EN_S(0),
            .CLKOS_TRIM_MODE("Falling"),
            .CLKOS_TRIM("0b0000"),
            .CLKOS2_EN(0),
            .CLKOS2_BYPASS(0),
            .ENCLKOS2_EN(0),
            .CLKOS2_FREQ_ACTUAL(100.0),
            .CLKOS2_PHASE_ACTUAL(0.0),
            .DIVOS2_ACTUAL_STR("7"),
            .DELC("7"),
            .PHIC("0"),
            .CLKOS3_EN(0),
            .CLKOS3_BYPASS(0),
            .ENCLKOS3_EN(0),
            .CLKOS3_FREQ_ACTUAL(100.0),
            .CLKOS3_PHASE_ACTUAL(0.0),
            .DIVOS3_ACTUAL_STR("7"),
            .DELD("7"),
            .PHID("0"),
            .CLKOS4_EN(0),
            .CLKOS4_BYPASS(0),
            .ENCLKOS4_EN(0),
            .CLKOS4_FREQ_ACTUAL(100.0),
            .CLKOS4_PHASE_ACTUAL(0.0),
            .DIVOS4_ACTUAL_STR("7"),
            .DELE("7"),
            .PHIE("0"),
            .CLKOS5_EN(0),
            .CLKOS5_BYPASS(0),
            .ENCLKOS5_EN(0),
            .CLKOS5_FREQ_ACTUAL(100.0),
            .CLKOS5_PHASE_ACTUAL(0.0),
            .DIVOS5_ACTUAL_STR("7"),
            .DELF("7"),
            .PHIF("0"),
            .PLL_REFCLK_FROM_PIN(1),
            .PLL_IO_TYPE("LVSTLD_I"),
            .DYN_PORTS_EN(0),
            .PLL_RST(1),
            .LOCK_EN(1),
            .PLL_LOCK_STICKY(0),
            .LMMI_EN(0),
            .APB_EN(0),
            .LEGACY_EN(0),
            .POWERDOWN_EN(0),
            .IPI_CMP("0b0100"),
            .CSET("24P"),
            .CRIPPLE("3P"),
            .IPP_CTRL("0b0100"),
            .IPP_SEL("0b1111"),
            .BW_CTL_BIAS("0b1111"),
            .V2I_PP_RES("9K"),
            .KP_VCO("0b00011"),
            .V2I_KVCO_SEL("60"),
            .V2I_1V_EN("ENABLED"),
            .DDR_DENSITY(8),
            .ROW_WIDTH(16),
            .COL_WIDTH(10),
            .DDR_WIDTH(32),
            .DQS_WIDTH(4),
            .NUM_RANKS(1),
            .CA_WIDTH(6),
            .CK_WIDTH(1),
            .CS_WIDTH(1),
            .ODT_WIDTH(1),
            .AXI(1),
            .AXI_ADDR_WIDTH(31),
            .AXI_DATA_WIDTH(256),
            .AXI_ID_WIDTH(2),
            .ORDER_ID_WIDTH(3),
            .AXI_LEN_WIDTH(8),
            .AXI_QOS_WIDTH(4),
            .AXI_CTRL_WIDTH(16),
            .AXI_STRB_WIDTH(32),
            .AHBL_ADDR_WIDTH(31),
            .AHBL_DATA_WIDTH(128),
            .SCH_NUM_WR_SUPPORTED(4),
            .SCH_NUM_RD_SUPPORTED(4),
            .DATA_CLK_EN(1),
            .APB_INTF_EN(1),
            .APB_ADDR_WIDTH(12),
            .APB_DATA_WIDTH(32),
            .BI_RD_DATA_Q_DEPTH(4),
            .BI_RD_DATA_Q_WIDTH(256),
            .NUM_BANKS(8),
            .RANK_WIDTH(1),
            .BANK_WIDTH(3),
            .OFFSET_LO(0),
            .OFFSET_HI(1),
            .COL_ADDR_LO(2),
            .COL_ADDR_HI(11),
            .BANK_ADDR_LO(12),
            .BANK_ADDR_HI(14),
            .ROW_ADDR_LO(15),
            .ROW_ADDR_HI(30),
            .CA_CTL(4),
            .ECC_WIDTH_PER_EDGE(0),
            .ECC_WIDTH(0),
            .DQ_DATA_PER_EDGE(36),
            .MC2PHY_DQ_CTRL_WIDTH(4),
            .MC2PHY_DQ_WIDTH(256),
            .MC2PHY_DM_WIDTH(32),
            .MC2PHY_DQS_WIDTH(32),
            .SCH_WR_DATA_Q_DEPTH(256),
            .SCH_WR_DATA_Q_WIDTH(288),
            .NUM_REQS(8),
            .PHY2MC_DQ_WIDTH(256),
            .PHY2MC_DM_WIDTH(32),
            .PHY2MC_DQS_WIDTH(32),
            .DQS_OE_WIDTH(16),
            .BUS_WIDTH(32),
            .CTRL_Q_DEPTH(8),
            .LPDDR_MC_CS_WIDTH(4),
            .LPDDR_MC_CA_WIDTH(24),
            .LPDDR_MC_ODT_WIDTH(4),
            .LPDDR_MC_CK_WIDTH(4),
            .TRCD_VALUE(2),
            .TRAS_VALUE(5),
            .TRPPB_VALUE(2),
            .TWR_VALUE(2),
            .TRTP_VALUE(2),
            .TCCD_VALUE(2),
            .MWR2MWR_VALUE(8),
            .TRRD_VALUE(1),
            .TRFC_VALUE(28),
            .TFAW_VALUE(10),
            .TZQCAL_VALUE(3),
            .TMRR_VALUE(2),
            .TMRD_VALUE(3),
            .TRPAB_VALUE(3),
            .TRTW_VALUE(8),
            .TDQSS(1),
            .CAS2CAS_VALUE(2),
            .TRD2PRE_VALUE(2),
            .TWR2PRE_VALUE(7),
            .TWR2RD_VALUE(5),
            .TXP_VALUE(3),
            .TXPSR_VALUE(29),
            .IDLE_TIME(1000),
            .REF_PERIOD_VALUE(391),
            .REF_PERIOD_WIDTH(9),
            .REF_OUTSTANDING(8),
            .ZQ_PERIOD_VALUE('hBEBC2000),
            .ZQ_PERIOD_WIDTH(32),
            .ZQSTART2LATCH_VALUE(100),
            .TEMPERATURE_VALUE('hBEBC2000),
            .TEMPERATURE_WIDTH(32),
            .CK_DELAY_VAL(76),
            .DQS_GRP_VREF_VAL(70),
            .MEM_CA_VREF_VAL(80),
            .MEM_DQ_VREF_VAL(80),
            .DQ_ODT_VAL(0),
            .TRND_WRLVL_0(76),
            .TRND_WRLVL_1(76),
            .TRND_WRLVL_2(76),
            .TRND_WRLVL_3(76),
            .TRND_WRLVL_4(76),
            .TRND_WRLVL_5(76),
            .TRND_WRLVL_6(76),
            .TRND_WRLVL_7(76),
            .TRND_RDCLKSEL_0(5),
            .TRND_RDCLKSEL_1(5),
            .TRND_RDCLKSEL_2(5),
            .TRND_RDCLKSEL_3(5),
            .TRND_RDCLKSEL_4(5),
            .TRND_RDCLKSEL_5(5),
            .TRND_RDCLKSEL_6(5),
            .TRND_RDCLKSEL_7(5),
            .TRND_CS_DLY(76),
            .TRND_CA_DLY(76),
            .TRND_RD_DLY(24),
            .TRND_RD_SIGN(0),
            .TRND_DQ_DBI_DLY(76),
            .TRND_WR_LAT(7),
            .TRND_RD_LAT(12)) lscc_lpddr4_mc_inst (.pll_refclk_i(pll_refclk_i), 
                .pll_rst_n_i(pll_rst_n_i), 
                .areset_n_i(areset_n_i), 
                .aclk_i(aclk_i), 
                .rst_n_i(rst_n_i), 
                .pclk_i(pclk_i), 
                .prst_n_i(preset_n_i), 
                .pll_lock_o(pll_lock_o), 
                .sclk_o(sclk_o), 
                .irq_o(irq_o), 
                .init_start_i(1'b0), 
                .trn_opr_i(8'b00000000), 
                .init_done_o(init_done_o), 
                .trn_err_o(trn_err_o), 
                .axi_arvalid_i(axi_arvalid_i), 
                .axi_arid_i(axi_arid_i[1:0]), 
                .axi_arlen_i(axi_arlen_i[7:0]), 
                .axi_arburst_i(axi_arburst_i[1:0]), 
                .axi_araddr_i(axi_araddr_i[30:0]), 
                .axi_arqos_i(axi_arqos_i[3:0]), 
                .axi_arsize_i(axi_arsize_i[2:0]), 
                .axi_arready_o(axi_arready_o), 
                .axi_rdata_o(axi_rdata_o[255:0]), 
                .axi_rresp_o(axi_rresp_o[1:0]), 
                .axi_rid_o(axi_rid_o[1:0]), 
                .axi_rvalid_o(axi_rvalid_o), 
                .axi_rlast_o(axi_rlast_o), 
                .axi_rready_i(axi_rready_i), 
                .axi_awvalid_i(axi_awvalid_i), 
                .axi_awid_i(axi_awid_i[1:0]), 
                .axi_awlen_i(axi_awlen_i[7:0]), 
                .axi_awburst_i(axi_awburst_i[1:0]), 
                .axi_awaddr_i(axi_awaddr_i[30:0]), 
                .axi_awqos_i(axi_awqos_i[3:0]), 
                .axi_awsize_i(axi_awsize_i[2:0]), 
                .axi_awready_o(axi_awready_o), 
                .axi_wvalid_i(axi_wvalid_i), 
                .axi_wdata_i(axi_wdata_i[255:0]), 
                .axi_wstrb_i(axi_wstrb_i[31:0]), 
                .axi_wlast_i(axi_wlast_i), 
                .axi_wready_o(axi_wready_o), 
                .axi_bvalid_o(axi_bvalid_o), 
                .axi_bready_i(axi_bready_i), 
                .axi_bresp_o(axi_bresp_o[1:0]), 
                .axi_bid_o(axi_bid_o[1:0]), 
                .wr_req_ready_o(), 
                .wr_req_valid_i(1'b0), 
                .wr_req_id_i(2'b00), 
                .wr_req_order_id_i(3'b000), 
                .wr_req_addr_i(31'b0000000000000000000000000000000), 
                .wr_req_len_i(8'b00000000), 
                .wr_req_size_i(3'b000), 
                .wr_ready_o(), 
                .wr_valid_i(1'b0), 
                .wr_data_i(256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), 
                .wr_byte_en_i(32'b00000000000000000000000000000000), 
                .wr_data_last_i(1'b0), 
                .rd_req_ready_o(), 
                .rd_req_valid_i(1'b0), 
                .rd_req_id_i(2'b00), 
                .rd_req_order_id_i(3'b000), 
                .rd_req_addr_i(31'b0000000000000000000000000000000), 
                .rd_req_len_i(8'b00000000), 
                .rd_req_size_i(3'b000), 
                .rd_rsp_ready_i(1'b0), 
                .rd_rsp_valid_o(), 
                .rd_rsp_id_o(), 
                .rd_rsp_order_id_o(), 
                .rd_rsp_data_o(), 
                .rd_rsp_len_o(), 
                .rd_rsp_size_o(), 
                .rd_rsp_buff_addr_o(), 
                .apb_penable_i(apb_penable_i), 
                .apb_psel_i(apb_psel_i), 
                .apb_pwrite_i(apb_pwrite_i), 
                .apb_paddr_i(apb_paddr_i[11:0]), 
                .apb_pwdata_i(apb_pwdata_i[31:0]), 
                .apb_pready_o(apb_pready_o), 
                .apb_pslverr_o(apb_pslverr_o), 
                .apb_prdata_o(apb_prdata_o[31:0]), 
                .ddr_ck_o(ddr_ck_o[0]), 
                .ddr_cke_o(ddr_cke_o[0]), 
                .ddr_cs_o(ddr_cs_o[0]), 
                .ddr_ca_o(ddr_ca_o[5:0]), 
                .ddr_we_n_o(), 
                .ddr_cas_n_o(), 
                .ddr_ras_n_o(), 
                .ddr_ba_o(), 
                .ddr_addr_o(), 
                .ddr_odt_o(), 
                .ddr_reset_n_o(ddr_reset_n_o), 
                .ddr_dq_io(ddr_dq_io[31:0]), 
                .ddr_dqs_io(ddr_dqs_io[3:0]), 
                .ddr_dmi_io(ddr_dmi_io[3:0]), 
                .dbg_rddata_en_o(), 
                .dbg_wddata_en_o()) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lpddr4_mc_async_fifo.v
// Title                 :
// Dependencies          :
// Description           :
// =============================================================================
module new_lpddr4_ipgen_lpddr4_mc_async_fifo (wr_clk_i, 
        rd_clk_i, 
        rst_i, 
        rp_rst_i, 
        wr_en_i, 
        rd_en_i, 
        wr_data_i, 
        full_o, 
        almost_full_o, 
        empty_o, 
        rd_data_nxt, 
        rd_data_o) ;
    parameter WIDTH = 16 ; 
    parameter DEPTH = 4 ; 
    parameter DEPTH_LOG = $clog2(DEPTH) ; 
    input wr_clk_i ; 
    input rd_clk_i ; 
    input rst_i ; 
    input rp_rst_i ; 
    input wr_en_i ; 
    input rd_en_i ; 
    input [(WIDTH - 1):0] wr_data_i ; 
    output full_o ; 
    output almost_full_o ; 
    output empty_o ; 
    output [(WIDTH - 1):0] rd_data_nxt ; 
    output [(WIDTH - 1):0] rd_data_o ; 
    new_lpddr4_ipgen_lscc_soft_fifo_dc_dist #(.IMPLEMENTATION("LUT"),
            .WADDR_DEPTH(DEPTH),
            .WADDR_WIDTH(DEPTH_LOG),
            .WDATA_WIDTH(WIDTH),
            .RADDR_DEPTH(DEPTH),
            .RADDR_WIDTH(DEPTH_LOG),
            .RDATA_WIDTH(WIDTH),
            .REGMODE("reg"),
            .RESETMODE("async"),
            .ENABLE_ALMOST_FULL_FLAG("TRUE"),
            .ENABLE_ALMOST_EMPTY_FLAG("FALSE"),
            .ALMOST_FULL_ASSERTION("static-single"),
            .ALMOST_FULL_ASSERT_LVL((DEPTH - 2)),
            .ALMOST_FULL_DEASSERT_LVL((DEPTH - 3)),
            .ALMOST_EMPTY_ASSERTION("static-dual"),
            .ALMOST_EMPTY_ASSERT_LVL(1),
            .ALMOST_EMPTY_DEASSERT_LVL(2),
            .ENABLE_DATA_COUNT_WR("FALSE"),
            .ENABLE_DATA_COUNT_RD("FALSE"),
            .FAMILY("LFCPNX")) u_fifo_dc (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(rst_i), 
                .rp_rst_i(rp_rst_i), 
                .wr_en_i(wr_en_i), 
                .rd_en_i(rd_en_i), 
                .wr_data_i(wr_data_i[(WIDTH - 1):0]), 
                .almost_full_th_i({DEPTH_LOG{1'b1}}), 
                .almost_full_clr_th_i({DEPTH_LOG{1'b1}}), 
                .almost_empty_th_i({DEPTH_LOG{1'b1}}), 
                .almost_empty_clr_th_i({DEPTH_LOG{1'b1}}), 
                .full_o(full_o), 
                .empty_o(empty_o), 
                .almost_full_o(almost_full_o), 
                .almost_empty_o(), 
                .wr_data_cnt_o(), 
                .rd_data_cnt_o(), 
                .rd_data_nxt(rd_data_nxt[(WIDTH - 1):0]), 
                .rd_data_o(rd_data_o[(WIDTH - 1):0]), 
                .one_err_det_o(), 
                .two_err_det_o()) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_soft_fifo_dc_dist.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO using distributed RAM.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_soft_fifo_dc_dist #(parameter IMPLEMENTATION = "EBR", 
        parameter WADDR_DEPTH = 512, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 36, 
        parameter RADDR_DEPTH = 512, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 36, 
        parameter REGMODE = "reg", 
        parameter RESETMODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 511, 
        parameter ALMOST_FULL_DEASSERT_LVL = 510, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 2, 
        parameter ENABLE_DATA_COUNT_WR = "FALSE", 
        parameter ENABLE_DATA_COUNT_RD = "FALSE", 
        parameter FAMILY = "LIFCL") (
    //----------------------------
    // Inputs
    //----------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input rp_rst_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_th_i, 
    input [(WADDR_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_th_i, 
    input [(RADDR_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output [(RDATA_WIDTH - 1):0] rd_data_nxt, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [WADDR_WIDTH:0] wr_data_cnt_o, 
    output [RADDR_WIDTH:0] rd_data_cnt_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    //--end_ports--
    //----------------------------
    // Local Parameters
    //----------------------------
    localparam G_WADDR_WIDTH = (WADDR_WIDTH + 1) ; 
    localparam G_RADDR_WIDTH = (RADDR_WIDTH + 1) ; 
    localparam CMP_WIDTH = ((WADDR_WIDTH >= RADDR_WIDTH) ? (RADDR_WIDTH + 1) : (WADDR_WIDTH + 1)) ; 
    genvar i0, 
        i1 ; 
    generate
        //----------------------------
        // Wire and Registers
        //----------------------------
        // -- Write-Synced Signals --
        reg full_r ; 
        reg full_ext_r ; 
        reg [WADDR_WIDTH:0] wr_addr_r ; 
        reg [WADDR_WIDTH:0] wr_addr_arith_r ; 
        reg [WADDR_WIDTH:0] wr_addr_nxt_c ; 
        wire [(WADDR_WIDTH - 1):0] wr_mem_addr_w = wr_addr_r[(WADDR_WIDTH - 1):0] ; 
        wire [WADDR_WIDTH:0] wr_addr_p1_w = (wr_addr_r + 1'b1) ; 
        (* syn_preserve=1 *) reg [(G_RADDR_WIDTH - 1):0] rp_sync1_r ; 
        (* syn_preserve=1 *) reg [(G_RADDR_WIDTH - 1):0] rp_sync2_r ; 
        wire [(G_WADDR_WIDTH - 1):0] wr_grey_w ; 
        reg [(G_WADDR_WIDTH - 1):0] wr_grey_sync_r ; 
        wire [RADDR_WIDTH:0] rp_sync_w ; 
        wire [(CMP_WIDTH - 1):0] wr_cmp_wr_w = wr_addr_p1_w[WADDR_WIDTH:((WADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 1):0] rd_cmp_wr_w = rp_sync_w[RADDR_WIDTH:((RADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 2):0] wr_cmp_mem_wr_w = wr_cmp_wr_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] rd_cmp_mem_wr_w = rd_cmp_wr_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] wr_cur_mem_wr_w = wr_mem_addr_w[(WADDR_WIDTH - 1):((WADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [WADDR_WIDTH:0] wr_sig_rd_w ; 
        wire [WADDR_WIDTH:0] wr_sig_diff0_w = (wr_addr_arith_r - wr_sig_rd_w) ; 
        reg full_nxt_c ; 
        // -- Read-Synced Signals --
        reg empty_r ; 
        reg empty_ext_r ; 
        reg [RADDR_WIDTH:0] rd_addr_r ; 
        reg [RADDR_WIDTH:0] rd_addr_arith_r ; 
        reg [RADDR_WIDTH:0] rd_addr_nxt_c ; 
        wire [(RADDR_WIDTH - 1):0] rd_mem_addr_w = rd_addr_r[(RADDR_WIDTH - 1):0] ; 
        wire [RADDR_WIDTH:0] rd_addr_p1_w = (rd_addr_r + 1'b1) ; 
        (* syn_preserve=1 *) reg [(G_WADDR_WIDTH - 1):0] wp_sync1_r ; 
        (* syn_preserve=1 *) reg [(G_WADDR_WIDTH - 1):0] wp_sync2_r ; 
        wire [(G_RADDR_WIDTH - 1):0] rd_grey_w ; 
        (* syn_preserve=1 *) reg [(G_RADDR_WIDTH - 1):0] rd_grey_sync_r ; 
        wire [WADDR_WIDTH:0] wp_sync_w ; 
        wire [(CMP_WIDTH - 1):0] rd_cmp_rd_w = rd_addr_p1_w[RADDR_WIDTH:((RADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 1):0] wr_cmp_rd_w = wp_sync_w[WADDR_WIDTH:((WADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [(CMP_WIDTH - 2):0] wr_cmp_mem_rd_w = wr_cmp_rd_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] rd_cmp_mem_rd_w = rd_cmp_rd_w[(CMP_WIDTH - 2):0] ; 
        wire [(CMP_WIDTH - 2):0] rd_cur_mem_rd_w = rd_mem_addr_w[(RADDR_WIDTH - 1):((RADDR_WIDTH - CMP_WIDTH) + 1)] ; 
        wire [RADDR_WIDTH:0] rd_sig_wr_w ; 
        wire [RADDR_WIDTH:0] rd_sig_diff0_w = (rd_sig_wr_w - rd_addr_arith_r) ; 
        reg empty_nxt_c ; 
        wire [RADDR_WIDTH:0] full_addr_w ; 
        // -- Top-Level Assignments --
        assign full_o = full_ext_r ; 
        assign empty_o = empty_ext_r ; 
        // -- Global Signals -- 
        wire wr_fifo_en_w = (wr_en_i & (~full_r)) ; 
        wire rd_fifo_en_w = (rd_en_i & (~empty_r)) ; 
        //----------------------------------------
        // Register Initialization for Simulation
        //----------------------------------------
        genvar gri0 ; 
        //----------------------------
        // Behavioral Model
        //----------------------------
        // ----------------------
        // -- WRITE CONTROLLER --
        // ----------------------
        // -- wr_grey_encode --
        assign wr_grey_w = (wr_addr_nxt_c ^ (wr_addr_nxt_c >> 1)) ; 
        if ((RESETMODE == "sync")) 
            begin : wr_encode_sync
                always
                    @(posedge wr_clk_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_grey_sync_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wr_grey_sync_r <=  wr_grey_w ;
                            end
                    end
            end
        else
            begin : wr_encode_async
                always
                    @(posedge wr_clk_i or 
                        posedge rst_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_grey_sync_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wr_grey_sync_r <=  wr_grey_w ;
                            end
                    end
            end
        // -- rd_grey_decode --  
        for (gri0 = 0;(gri0 < G_RADDR_WIDTH);gri0 = (gri0 + 1))
        begin : genblk2
            assign rp_sync_w[gri0] = (^rp_sync2_r[(G_RADDR_WIDTH - 1):gri0]) ; 
        end
        // ---------------------------
        // -- Core Write Controller --
        // ---------------------------
        wire wr_sig_mv_w = (wr_en_i & (~full_r)) ; 
        wire full_cmp_w = (wr_cmp_mem_wr_w == rd_cmp_mem_wr_w) ; 
        wire full_rel_cmp_w = (wr_cur_mem_wr_w == rd_cmp_mem_wr_w) ; 
        wire full_max_w = (wr_cmp_wr_w[(CMP_WIDTH - 1)] ^ rd_cmp_wr_w[(CMP_WIDTH - 1)]) ; 
        always
            @(*)
            begin
                //Removed reset on this logic since both reset will assert, just de-assert at different times
                //full_nxt_c = ~rp_rst_i & (wr_sig_mv_w ? (full_cmp_w & full_max_w) : (full_rel_cmp_w & full_r));
                full_nxt_c = (wr_sig_mv_w ? (full_cmp_w & full_max_w) : (full_rel_cmp_w & full_r)) ;
            end
        always
            @(*)
            begin
                //Removed reset on this logic since both reset will assert, just de-assert at different times
                //wr_addr_nxt_c = (wr_sig_mv_w & ~rp_rst_i) ? wr_addr_p1_w : wr_addr_r;
                wr_addr_nxt_c = (wr_sig_mv_w ? wr_addr_p1_w : wr_addr_r) ;
            end
        if ((RESETMODE == "sync")) 
            begin : sync_wr_controller
                always
                    @(posedge wr_clk_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_addr_r <=  {WADDR_WIDTH{1'b0}} ;
                                wr_addr_arith_r <=  {WADDR_WIDTH{1'b0}} ;
                                full_r <=  1'b0 ;
                                full_ext_r <=  1'b0 ;
                            end
                        else
                            begin
                                wr_addr_r <=  wr_addr_nxt_c ;
                                wr_addr_arith_r <=  wr_addr_nxt_c ;
                                full_r <=  full_nxt_c ;
                                full_ext_r <=  full_nxt_c ;
                            end
                    end
            end
        else
            begin : async_wr_controller
                always
                    @(posedge wr_clk_i or 
                        posedge rst_i)
                    begin
                        if (rst_i) 
                            begin
                                wr_addr_r <=  {WADDR_WIDTH{1'b0}} ;
                                wr_addr_arith_r <=  {WADDR_WIDTH{1'b0}} ;
                                full_r <=  1'b0 ;
                                full_ext_r <=  1'b0 ;
                            end
                        else
                            begin
                                wr_addr_r <=  wr_addr_nxt_c ;
                                wr_addr_arith_r <=  wr_addr_nxt_c ;
                                full_r <=  full_nxt_c ;
                                full_ext_r <=  full_nxt_c ;
                            end
                    end
            end
        // -- Read to Write Synchronizer --
        if ((RESETMODE == "sync")) 
            begin : genblk4
                always
                    @(posedge wr_clk_i)
                    begin : RP_RS
                        if ((rst_i == 1'b1)) 
                            begin
                                rp_sync1_r <=  {G_RADDR_WIDTH{1'b0}} ;
                                rp_sync2_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rp_sync1_r <=  rd_grey_sync_r ;
                                rp_sync2_r <=  rp_sync1_r ;
                            end
                    end
            end
        else
            begin : RP_RA
                always
                    @(posedge wr_clk_i or 
                        posedge rst_i)
                    begin
                        if ((rst_i == 1'b1)) 
                            begin
                                rp_sync1_r <=  {G_RADDR_WIDTH{1'b0}} ;
                                rp_sync2_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rp_sync1_r <=  rd_grey_sync_r ;
                                rp_sync2_r <=  rp_sync1_r ;
                            end
                    end
            end
        // -- Routing for WR difference signals --
        if ((WADDR_WIDTH > RADDR_WIDTH)) 
            begin : genblk5
                assign wr_sig_rd_w = {rp_sync_w,
                            {(WADDR_WIDTH - RADDR_WIDTH){1'b0}}} ; 
            end
        else
            begin : genblk5
                assign wr_sig_rd_w = rp_sync_w[RADDR_WIDTH:(RADDR_WIDTH - WADDR_WIDTH)] ; 
            end
        // -- Almost Full Flag Controller --
        if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
            begin : afull_flag_impl
                wire [(WADDR_WIDTH - 1):0] almost_full_tick_w = (((ALMOST_FULL_ASSERTION == "static-single") || (ALMOST_FULL_ASSERTION == "static-dual")) ? ALMOST_FULL_ASSERT_LVL : almost_full_th_i) ; 
                wire [(WADDR_WIDTH - 1):0] almost_full_tock_w = ((ALMOST_FULL_ASSERTION == "static-single") ? ALMOST_FULL_ASSERT_LVL : ((ALMOST_FULL_ASSERTION == "static-dual") ? ALMOST_FULL_DEASSERT_LVL : ((ALMOST_FULL_ASSERTION == "dynamic-single") ? almost_full_th_i : almost_full_clr_th_i))) ; 
                reg af_flag_r ; 
                reg af_flag_ext_r ; 
                wire af_flag_p_w ; 
                wire af_flag_n_w ; 
                wire af_flag_nxt_w ; 
                assign af_flag_p_w = (~(wr_sig_diff0_w < (almost_full_tick_w - wr_en_i))) ; 
                assign af_flag_n_w = (wr_sig_diff0_w > almost_full_tock_w) ; 
                assign af_flag_nxt_w = (af_flag_p_w | (af_flag_n_w & af_flag_r)) ; 
                assign almost_full_o = af_flag_ext_r ; 
                if ((RESETMODE == "sync")) 
                    begin : sync
                        always
                            @(posedge wr_clk_i)
                            begin
                                if ((rst_i == 1'b1)) 
                                    begin
                                        af_flag_r <=  1'b0 ;
                                        af_flag_ext_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        af_flag_r <=  af_flag_nxt_w ;
                                        af_flag_ext_r <=  af_flag_nxt_w ;
                                    end
                            end
                    end
                else
                    begin : async
                        always
                            @(posedge wr_clk_i or 
                                posedge rst_i)
                            begin
                                if ((rst_i == 1'b1)) 
                                    begin
                                        af_flag_r <=  1'b0 ;
                                        af_flag_ext_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        af_flag_r <=  af_flag_nxt_w ;
                                        af_flag_ext_r <=  af_flag_nxt_w ;
                                    end
                            end
                    end
            end
        else
            begin : genblk6
                assign almost_full_o = 1'b0 ; 
            end
        // -- Enable WR Data Count Controller --
        if ((ENABLE_DATA_COUNT_WR == "TRUE")) 
            begin : en_wr_cnt
                reg [WADDR_WIDTH:0] wr_counter_r ; 
                assign wr_data_cnt_o = wr_counter_r ; 
                if ((RESETMODE == "sync")) 
                    begin : genblk1
                        always
                            @(posedge wr_clk_i)
                            begin
                                if (rst_i) 
                                    begin
                                        wr_counter_r <=  {(WADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        wr_counter_r <=  wr_sig_diff0_w ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(posedge wr_clk_i or 
                                posedge rst_i)
                            begin
                                if (rst_i) 
                                    begin
                                        wr_counter_r <=  {(WADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        wr_counter_r <=  wr_sig_diff0_w ;
                                    end
                            end
                    end
            end
        else
            begin : genblk7
                assign wr_data_cnt_o = {(WADDR_WIDTH + 1){1'b0}} ; 
            end
        // ---------------------
        // -- READ CONTROLLER --
        // ---------------------
        // -- Full Address for rp_rst_i --
        if ((WADDR_WIDTH >= RADDR_WIDTH)) 
            begin : full_addr_e
                assign full_addr_w = {(~wp_sync_w[WADDR_WIDTH]),
                            wp_sync_w[(WADDR_WIDTH - 1):(WADDR_WIDTH - RADDR_WIDTH)]} ; 
            end
        else
            begin : full_addr_o
                assign full_addr_w = {(~wp_sync_w[WADDR_WIDTH]),
                            wp_sync_w[(WADDR_WIDTH - 1):0],
                            {(RADDR_WIDTH - WADDR_WIDTH){1'b0}}} ; 
            end
        // -- rd_grey_encode --
        assign rd_grey_w = (rd_addr_nxt_c ^ (rd_addr_nxt_c >> 1)) ; 
        if ((RESETMODE == "sync")) 
            begin : rd_encode_sync
                always
                    @(posedge rd_clk_i)
                    begin
                        if (rp_rst_i) 
                            begin
                                rd_grey_sync_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rd_grey_sync_r <=  rd_grey_w ;
                            end
                    end
            end
        else
            begin : rd_encode_async
                always
                    @(posedge rd_clk_i or 
                        posedge rp_rst_i)
                    begin
                        if (rp_rst_i) 
                            begin
                                rd_grey_sync_r <=  {G_RADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                rd_grey_sync_r <=  rd_grey_w ;
                            end
                    end
            end
        // -- wr_grey_decode --
        for (gri0 = 0;(gri0 < G_WADDR_WIDTH);gri0 = (gri0 + 1))
        begin : genblk10
            assign wp_sync_w[gri0] = (^wp_sync2_r[(G_WADDR_WIDTH - 1):gri0]) ; 
        end
        // ---------------------------
        // -- Core Read Controller --
        // ---------------------------
        wire empty_cmp_w = (wr_cmp_rd_w == rd_cmp_rd_w) ; 
        wire empty_rel_cmp_w = (rd_cur_mem_rd_w == wr_cmp_mem_rd_w) ; 
        wire rd_sig_mv_w = (rd_en_i & (~empty_r)) ; 
        always
            @(*)
            begin
                rd_addr_nxt_c = (rp_rst_i ? full_addr_w : (rd_sig_mv_w ? rd_addr_p1_w : rd_addr_r)) ;
            end
        always
            @(*)
            begin
                empty_nxt_c = ((~rp_rst_i) & (rd_sig_mv_w ? empty_cmp_w : (empty_rel_cmp_w & empty_r))) ;
            end
        if ((RESETMODE == "sync")) 
            begin : sync_rd_controller
                always
                    @(posedge rd_clk_i)
                    begin
                        if (rp_rst_i) 
                            begin
                                empty_r <=  1'b1 ;
                                empty_ext_r <=  1'b1 ;
                                rd_addr_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                rd_addr_arith_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                            end
                        else
                            begin
                                empty_r <=  empty_nxt_c ;
                                empty_ext_r <=  empty_nxt_c ;
                                rd_addr_r <=  rd_addr_nxt_c ;
                                rd_addr_arith_r <=  rd_addr_nxt_c ;
                            end
                    end
            end
        else
            begin : async_rd_controller
                always
                    @(posedge rd_clk_i or 
                        posedge rp_rst_i)
                    begin
                        if (rp_rst_i) 
                            begin
                                empty_r <=  1'b1 ;
                                empty_ext_r <=  1'b1 ;
                                rd_addr_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                rd_addr_arith_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                            end
                        else
                            begin
                                empty_r <=  empty_nxt_c ;
                                empty_ext_r <=  empty_nxt_c ;
                                rd_addr_r <=  rd_addr_nxt_c ;
                                rd_addr_arith_r <=  rd_addr_nxt_c ;
                            end
                    end
            end
        // -- Write to Read Synchronizer --
        if ((RESETMODE == "sync")) 
            begin : WP_RS
                always
                    @(posedge rd_clk_i)
                    begin
                        if ((rp_rst_i == 1'b1)) 
                            begin
                                wp_sync1_r <=  {G_WADDR_WIDTH{1'b0}} ;
                                wp_sync2_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wp_sync1_r <=  wr_grey_sync_r ;
                                wp_sync2_r <=  wp_sync1_r ;
                            end
                    end
            end
        else
            begin : WP_RA
                always
                    @(posedge rd_clk_i or 
                        posedge rp_rst_i)
                    begin
                        if ((rp_rst_i == 1'b1)) 
                            begin
                                wp_sync1_r <=  {G_WADDR_WIDTH{1'b0}} ;
                                wp_sync2_r <=  {G_WADDR_WIDTH{1'b0}} ;
                            end
                        else
                            begin
                                wp_sync1_r <=  wr_grey_sync_r ;
                                wp_sync2_r <=  wp_sync1_r ;
                            end
                    end
            end
        // -- Routing for RD difference signals --
        if ((RADDR_WIDTH > WADDR_WIDTH)) 
            begin : genblk13
                assign rd_sig_wr_w = {wp_sync_w,
                            {(RADDR_WIDTH - WADDR_WIDTH){1'b0}}} ; 
            end
        else
            begin : genblk13
                assign rd_sig_wr_w = wp_sync_w[WADDR_WIDTH:(WADDR_WIDTH - RADDR_WIDTH)] ; 
            end
        // -- Almost Empty Flag Controller --
        if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
            begin : aempty_flag_impl
                wire [(RADDR_WIDTH - 1):0] almost_empty_tick_w = (((ALMOST_EMPTY_ASSERTION == "static-single") || (ALMOST_EMPTY_ASSERTION == "static-dual")) ? ALMOST_EMPTY_ASSERT_LVL : almost_empty_th_i) ; 
                wire [(RADDR_WIDTH - 1):0] almost_empty_tock_w = ((ALMOST_EMPTY_ASSERTION == "static-single") ? ALMOST_EMPTY_ASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "static-dual") ? ALMOST_EMPTY_DEASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "dynamic-single") ? almost_empty_th_i : almost_empty_clr_th_i))) ; 
                reg ae_flag_r ; 
                reg ae_flag_ext_r ; 
                wire ae_flag_pos_w ; 
                wire ae_flag_neg_w ; 
                wire ae_flag_nxt_w ; 
                assign ae_flag_pos_w = (~(rd_sig_diff0_w > (almost_empty_tick_w + rd_en_i))) ; 
                assign ae_flag_neg_w = (rd_sig_diff0_w < almost_empty_tock_w) ; 
                assign ae_flag_nxt_w = (ae_flag_pos_w | (ae_flag_neg_w & ae_flag_r)) ; 
                assign almost_empty_o = ae_flag_ext_r ; 
                if ((RESETMODE == "sync")) 
                    begin : sync
                        always
                            @(posedge rd_clk_i or 
                                posedge rp_rst_i)
                            begin
                                if (rp_rst_i) 
                                    begin
                                        ae_flag_ext_r <=  1'b1 ;
                                        ae_flag_r <=  1'b1 ;
                                    end
                                else
                                    begin
                                        ae_flag_ext_r <=  ae_flag_nxt_w ;
                                        ae_flag_r <=  ae_flag_nxt_w ;
                                    end
                            end
                    end
                else
                    begin : async
                        always
                            @(posedge rd_clk_i or 
                                posedge rp_rst_i)
                            begin
                                if (rp_rst_i) 
                                    begin
                                        ae_flag_ext_r <=  1'b1 ;
                                        ae_flag_r <=  1'b1 ;
                                    end
                                else
                                    begin
                                        ae_flag_ext_r <=  ae_flag_nxt_w ;
                                        ae_flag_r <=  ae_flag_nxt_w ;
                                    end
                            end
                    end
            end
        else
            begin : genblk14
                assign almost_empty_o = 1'b0 ; 
            end
        // -- Enable RD Data Count Controller --
        if ((ENABLE_DATA_COUNT_RD == "TRUE")) 
            begin : en_rd_cnt
                reg [RADDR_WIDTH:0] rd_counter_r ; 
                assign rd_data_cnt_o = rd_counter_r ; 
                if ((RESETMODE == "sync")) 
                    begin : genblk1
                        always
                            @(posedge rd_clk_i)
                            begin
                                if (rp_rst_i) 
                                    begin
                                        rd_counter_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        rd_counter_r <=  rd_sig_diff0_w ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(posedge rd_clk_i or 
                                posedge rp_rst_i)
                            begin
                                if (rp_rst_i) 
                                    begin
                                        rd_counter_r <=  {(RADDR_WIDTH + 1){1'b0}} ;
                                    end
                                else
                                    begin
                                        rd_counter_r <=  rd_sig_diff0_w ;
                                    end
                            end
                    end
            end
        else
            begin : dis_rd_cnt
                assign rd_data_cnt_o = {(RADDR_WIDTH + 1){1'b0}} ; 
            end
        wire t_rd_fifo_en_w ; 
        if ((REGMODE == "noreg")) 
            begin : genblk16
                assign t_rd_fifo_en_w = rd_fifo_en_w ; 
            end
        else
            begin : genblk16
                reg rd_prev_r ; 
                //assign t_rd_fifo_en_w = (rd_fifo_en_w | rd_prev_r);
                assign t_rd_fifo_en_w = rd_fifo_en_w ; 
                if ((RESETMODE == "sync")) 
                    begin : genblk1
                        always
                            @(posedge rd_clk_i)
                            begin
                                if (rp_rst_i) 
                                    begin
                                        rd_prev_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        rd_prev_r <=  rd_fifo_en_w ;
                                    end
                            end
                    end
                else
                    begin : genblk1
                        always
                            @(posedge rd_clk_i or 
                                posedge rp_rst_i)
                            begin
                                if (rp_rst_i) 
                                    begin
                                        rd_prev_r <=  1'b0 ;
                                    end
                                else
                                    begin
                                        rd_prev_r <=  rd_fifo_en_w ;
                                    end
                            end
                    end
            end
        (* syn_ramstyle="distributed" *) reg [(RDATA_WIDTH - 1):0] mem [((2 ** RADDR_WIDTH) - 1):0] ; 
        //reg [RDATA_WIDTH-1:0]   out_raw;
        wire [(RDATA_WIDTH - 1):0] out_raw ; 
        reg [(RDATA_WIDTH - 1):0] out_buffer ; 
        wire [(RDATA_WIDTH - 1):0] out_buffer_nxt ; 
        wire write_enable = wr_fifo_en_w ; 
        wire read_enable = t_rd_fifo_en_w ; 
        assign rd_data_o = ((REGMODE == "noreg") ? out_raw : out_buffer) ; 
        assign rd_data_nxt = ((REGMODE == "noreg") ? out_raw : out_buffer_nxt) ; 
        always
            @(posedge wr_clk_i)
            begin
                if ((write_enable == 1'b1)) 
                    begin
                        mem[wr_mem_addr_w] <=  wr_data_i ;
                    end
            end
        assign out_raw = mem[rd_mem_addr_w] ; 
        assign out_buffer_nxt = (read_enable ? out_raw : out_buffer) ; 
        if ((REGMODE == "reg")) 
            begin : genblk17
                if ((RESETMODE == "async")) 
                    begin : async
                        always
                            @(posedge rd_clk_i or 
                                posedge rp_rst_i)
                            begin
                                if ((rp_rst_i == 1'b1)) 
                                    out_buffer <=  'h0 ;
                                else
                                    out_buffer <=  out_buffer_nxt ;
                            end
                    end
                else
                    begin : sync
                        always
                            @(posedge rd_clk_i)
                            begin
                                if ((rp_rst_i == 1'b1)) 
                                    out_buffer <=  'h0 ;
                                else
                                    out_buffer <=  out_buffer_nxt ;
                            end
                    end
            end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Radiant Software (64-bit)
    3.1.0.43.0
    Soft IP Version: 1.1.0
    2022 01 31 00:42:29
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module new_lpddr4_ipgen_lpddr4_mc_dpram (wr_clk_i, 
        rd_clk_i, 
        wr_clk_en_i, 
        rd_en_i, 
        rd_clk_en_i, 
        wr_en_i, 
        wr_data_i, 
        wr_addr_i, 
        rd_addr_i, 
        rd_data_o) ;
    parameter WIDTH = 26 ; 
    parameter DEPTH = 8 ; 
    parameter DEPTH_LOG = $clog2(DEPTH) ; 
    input wr_clk_i ; 
    input rd_clk_i ; 
    input wr_clk_en_i ; 
    input rd_en_i ; 
    input rd_clk_en_i ; 
    input wr_en_i ; 
    input [(WIDTH - 1):0] wr_data_i ; 
    input [(DEPTH_LOG - 1):0] wr_addr_i ; 
    input [(DEPTH_LOG - 1):0] rd_addr_i ; 
    output [(WIDTH - 1):0] rd_data_o ; 
    new_lpddr4_ipgen_dpram_ipgen_lscc_distributed_dpram #(.FAMILY("common"),
            .WADDR_DEPTH(DEPTH),
            .WDATA_WIDTH(WIDTH),
            .RADDR_DEPTH(DEPTH),
            .RDATA_WIDTH(WIDTH),
            .WADDR_WIDTH(DEPTH_LOG),
            .REGMODE("noreg"),
            .RADDR_WIDTH(DEPTH_LOG),
            .RESETMODE("sync"),
            .INIT_MODE("none"),
            .INIT_FILE("none"),
            .INIT_FILE_FORMAT("hex")) lscc_distributed_dpram_inst (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(1'b0), 
                .wr_clk_en_i(wr_clk_en_i), 
                .rd_en_i(rd_en_i), 
                .rd_clk_en_i(rd_clk_en_i), 
                .wr_en_i(wr_en_i), 
                .wr_data_i(wr_data_i), 
                .wr_addr_i(wr_addr_i), 
                .rd_addr_i(rd_addr_i), 
                .rd_data_o(rd_data_o)) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_distributed_dpram.v
// Title                 :
// Dependencies          :
// Description           : Implements a pseudo Dual Port RAM using distributed memory.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_dpram_ipgen_lscc_distributed_dpram #(parameter WADDR_DEPTH = 256, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 8, 
        parameter RADDR_DEPTH = 256, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 8, 
        parameter REGMODE = "reg", 
        parameter GSR = "", 
        parameter RESETMODE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter FAMILY = "common", 
        parameter MODULE_TYPE = "lscc_distributed_dpram", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 0, 
        parameter BYTE_SIZE = 8, 
        parameter BYTE_WIDTH = 0, 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = "") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input [(WADDR_WIDTH - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(RADDR_WIDTH - 1):0] rd_addr_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    // -----------------------------------------------------------------------------
    // Register Declarations
    // -----------------------------------------------------------------------------
    (* syn_ramstyle="distributed" *) reg [(RDATA_WIDTH - 1):0] mem [((2 ** RADDR_WIDTH) - 1):0] ; 
    reg [(RDATA_WIDTH - 1):0] out_raw ; 
    reg [(RDATA_WIDTH - 1):0] out_buffer ; 
    wire write_enable = (wr_clk_en_i & wr_en_i) ; 
    wire read_enable = (rd_clk_en_i & rd_en_i) ; 
    assign rd_data_o = ((REGMODE == "noreg") ? out_raw : out_buffer) ; 
    // -----------------------------------------------------------------------------
    // Initial Block
    // -----------------------------------------------------------------------------
    initial
        begin
            if (((INIT_MODE == "mem_file") && (INIT_FILE != "none"))) 
                begin
                    if ((INIT_FILE_FORMAT == "hex")) 
                        begin
                            $readmemh (INIT_FILE,
                                    mem,
                                    0,
                                    (RADDR_DEPTH - 1)) ;
                        end
                    else
                        begin
                            $readmemb (INIT_FILE,
                                    mem,
                                    0,
                                    (RADDR_DEPTH - 1)) ;
                        end
                end
        end
    // -----------------------------------------------------------------------------
    // Generate Sequential Blocks
    // -----------------------------------------------------------------------------
    always
        @(posedge wr_clk_i)
        begin
            if ((write_enable == 1'b1)) 
                begin
                    mem[wr_addr_i] <=  wr_data_i ;
                end
        end
    always
        @(*)
        begin
            out_raw = mem[rd_addr_i] ;
        end
    if ((REGMODE == "reg")) 
        begin : genblk1
            if ((RESETMODE == "async")) 
                begin : genblk1
                    always
                        @(posedge rd_clk_i or 
                            posedge rst_i)
                        begin
                            if ((rst_i == 1'b1)) 
                                begin
                                    out_buffer <=  'h0 ;
                                end
                            else
                                if ((read_enable == 1'b1)) 
                                    begin
                                        out_buffer <=  out_raw ;
                                    end
                        end
                end
            else
                begin : genblk1
                    always
                        @(posedge rd_clk_i)
                        begin
                            if ((rst_i == 1'b1)) 
                                begin
                                    out_buffer <=  'h0 ;
                                end
                            else
                                if ((read_enable == 1'b1)) 
                                    begin
                                        out_buffer <=  out_raw ;
                                    end
                        end
                end
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Radiant Software (64-bit)
    2.3.b1.26.0
    Soft IP Version: 1.1.2
    2021 01 07 20:48:29
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module new_lpddr4_ipgen_lpddr4_mc_sch_ebr (wr_clk_i, 
        rd_clk_i, 
        rst_i, 
        wr_clk_en_i, 
        rd_en_i, 
        rd_clk_en_i, 
        wr_en_i, 
        ben_i, 
        wr_data_i, 
        wr_addr_i, 
        rd_addr_i, 
        rd_data_o) ;
    parameter WIDTH = 256 ; 
    parameter BYTE_EN_WIDTH = (WIDTH / 8) ; 
    parameter DEPTH = 16 ; 
    parameter DEPTH_LOG = $clog2(DEPTH) ; 
    input wr_clk_i ; 
    input rd_clk_i ; 
    input rst_i ; 
    input wr_clk_en_i ; 
    input rd_en_i ; 
    input rd_clk_en_i ; 
    input wr_en_i ; 
    input [(BYTE_EN_WIDTH - 1):0] ben_i ; 
    input [(WIDTH - 1):0] wr_data_i ; 
    input [(DEPTH_LOG - 1):0] wr_addr_i ; 
    input [(DEPTH_LOG - 1):0] rd_addr_i ; 
    output [(WIDTH - 1):0] rd_data_o ; 
    parameter MEM_ID = "ebr" ; 
    new_lpddr4_ipgen_lscc_ram_dp #(.FAMILY("LFCPNX"),
            .MEM_ID(MEM_ID),
            .MEM_SIZE("WIDTH,DEPTH"),
            .WADDR_DEPTH(DEPTH),
            .WDATA_WIDTH(WIDTH),
            .RADDR_DEPTH(DEPTH),
            .RDATA_WIDTH(WIDTH),
            .WADDR_WIDTH(DEPTH_LOG),
            .REGMODE("noreg"),
            .RADDR_WIDTH(DEPTH_LOG),
            .OUTPUT_CLK_EN(0),
            .RESETMODE("sync"),
            .BYTE_ENABLE(1),
            .BYTE_WIDTH(BYTE_EN_WIDTH),
            .BYTE_SIZE(8),
            .ECC_ENABLE(0),
            .INIT_MODE("none"),
            .INIT_FILE("none"),
            .INIT_FILE_FORMAT("hex"),
            .INIT_VALUE_00("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_01("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_02("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_03("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_04("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_05("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_06("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_07("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_08("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_09("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_0A("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_0B("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_0C("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_0D("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_0E("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_0F("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_10("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_11("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_12("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_13("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_14("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_15("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_16("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_17("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_18("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_19("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_1A("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_1B("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_1C("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_1D("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_1E("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_1F("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_20("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_21("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_22("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_23("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_24("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_25("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_26("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_27("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_28("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_29("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_2A("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_2B("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_2C("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_2D("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_2E("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_2F("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_30("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_31("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_32("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_33("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_34("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_35("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_36("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_37("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_38("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_39("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_3A("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_3B("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_3C("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_3D("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_3E("0x0000000000000000000000000000000000000000000000000000000000000000"),
            .INIT_VALUE_3F("0x0000000000000000000000000000000000000000000000000000000000000000")) lscc_ram_dp_inst (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(rst_i), 
                .wr_clk_en_i(wr_clk_en_i), 
                .rd_en_i(rd_en_i), 
                .rd_clk_en_i(rd_clk_en_i), 
                .rd_out_clk_en_i(1'b1), 
                .wr_en_i(wr_en_i), 
                .ben_i(ben_i[(BYTE_EN_WIDTH - 1):0]), 
                .wr_data_i(wr_data_i[(WIDTH - 1):0]), 
                .wr_addr_i(wr_addr_i[(DEPTH_LOG - 1):0]), 
                .rd_addr_i(rd_addr_i[(DEPTH_LOG - 1):0]), 
                .rd_data_o(rd_data_o[(WIDTH - 1):0]), 
                .one_err_det_o(), 
                .two_err_det_o()) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lpddr4_mc_sync_fifo.v
// Title                 :
// Dependencies          :
// Description           :
// =============================================================================
module new_lpddr4_ipgen_lpddr4_mc_sync_fifo (clk_i, 
        rst_i, 
        wr_en_i, 
        rd_en_i, 
        wr_data_i, 
        full_o, 
        almost_full_o, 
        empty_o, 
        rd_data_nxt, 
        rd_data_o) ;
    parameter WIDTH = 16 ; 
    parameter DEPTH = 4 ; 
    parameter DEPTH_LOG = $clog2(DEPTH) ; 
    input clk_i ; 
    input rst_i ; 
    input wr_en_i ; 
    input rd_en_i ; 
    input [(WIDTH - 1):0] wr_data_i ; 
    output full_o ; 
    output almost_full_o ; 
    output empty_o ; 
    output [(WIDTH - 1):0] rd_data_nxt ; 
    output [(WIDTH - 1):0] rd_data_o ; 
    new_lpddr4_ipgen_lscc_soft_fifo_dist #(.IMPLEMENTATION("LUT"),
            .ADDRESS_DEPTH(DEPTH),
            .ADDRESS_WIDTH(DEPTH_LOG),
            .DATA_WIDTH(WIDTH),
            .REGMODE("noreg"),
            .RESET_MODE("async"),
            .ENABLE_ALMOST_FULL_FLAG("TRUE"),
            .ENABLE_ALMOST_EMPTY_FLAG("FALSE"),
            .ALMOST_FULL_ASSERTION("static-single"),
            .ALMOST_FULL_ASSERT_LVL((DEPTH - 2)),
            .ALMOST_FULL_DEASSERT_LVL((DEPTH - 3)),
            .ALMOST_EMPTY_ASSERTION("static-dual"),
            .ALMOST_EMPTY_ASSERT_LVL(1),
            .ALMOST_EMPTY_DEASSERT_LVL(2),
            .ENABLE_DATA_COUNT("FALSE"),
            .FAMILY("LAV-AT")) u_fifo (.clk_i(clk_i), 
                .rst_i(rst_i), 
                .wr_en_i(wr_en_i), 
                .rd_en_i(rd_en_i), 
                .wr_data_i(wr_data_i), 
                .almost_full_th_i({DEPTH_LOG{1'b1}}),  // unused
            .almost_full_clr_th_i({DEPTH_LOG{1'b1}}),  // unused
            .almost_empty_th_i({DEPTH_LOG{1'b1}}),  // unused
            .almost_empty_clr_th_i({DEPTH_LOG{1'b1}}),  // unused
            .full_o(full_o), 
                .empty_o(empty_o), 
                .almost_full_o(almost_full_o), 
                .almost_empty_o(), 
                .data_cnt_o(), 
                .rd_data_nxt(rd_data_nxt), 
                .rd_data_o(rd_data_o)) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_soft_fifo_dist.v
// Title                 :
// Dependencies          :
// Description           : Implements a dual clock FIFO.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_soft_fifo_dist #(parameter IMPLEMENTATION = "EBR", 
        parameter ADDRESS_DEPTH = 512, 
        parameter ADDRESS_WIDTH = clog2(ADDRESS_DEPTH), 
        parameter DATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter RESET_MODE = "async", 
        parameter ENABLE_ALMOST_FULL_FLAG = "TRUE", 
        parameter ENABLE_ALMOST_EMPTY_FLAG = "TRUE", 
        parameter ALMOST_FULL_ASSERTION = "static-dual", 
        parameter ALMOST_FULL_ASSERT_LVL = 1023, 
        parameter ALMOST_FULL_DEASSERT_LVL = 1020, 
        parameter ALMOST_EMPTY_ASSERTION = "static-dual", 
        parameter ALMOST_EMPTY_ASSERT_LVL = 1, 
        parameter ALMOST_EMPTY_DEASSERT_LVL = 4, 
        parameter ENABLE_DATA_COUNT = "FALSE", 
        parameter FAMILY = "common") (
    //----------------------------
    // Parameters
    //----
    //----------------------------
    // Inputs
    //----------------------------
    input clk_i, 
    input [(DATA_WIDTH - 1):0] wr_data_i, 
    input wr_en_i, 
    input rd_en_i, 
    input rst_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_full_clr_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_th_i, 
    input [(ADDRESS_WIDTH - 1):0] almost_empty_clr_th_i, 
    //----------------------------
    // Outputs
    //----------------------------
    output [(DATA_WIDTH - 1):0] rd_data_o, 
    output [(DATA_WIDTH - 1):0] rd_data_nxt, 
    output full_o, 
    output empty_o, 
    output almost_full_o, 
    output almost_empty_o, 
    output [ADDRESS_WIDTH:0] data_cnt_o) ;
    //----------------------------
    // Wire and Registers
    //----------------------------
    (* syn_preserve=1 *) reg full_r ; 
    (* syn_preserve=1 *) reg full_mem_r ; 
    (* syn_preserve=1 *) reg full_ext_r ; 
    (* syn_preserve=1 *) reg empty_r ; 
    (* syn_preserve=1 *) reg empty_mem_r ; 
    (* syn_preserve=1 *) reg empty_ext_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_addr_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_addr_p1_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_addr_p1cmp_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] wr_cmpaddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] waddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] wr_cmpaddr_p1_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_addr_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_addr_p1_r ; 
    (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_addr_p1cmp_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] rd_cmpaddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] raddr_r ; 
    (* syn_preserve=1 *) reg [(ADDRESS_WIDTH - 1):0] rd_cmpaddr_p1_r ; 
    // WRITE address controller
    wire [ADDRESS_WIDTH:0] wr_addr_nxt_w = ((wr_en_i & (~full_r)) ? wr_addr_p1_r : wr_addr_r) ; 
    wire [ADDRESS_WIDTH:0] wr_addr_nxt_p1_w = (wr_addr_nxt_w + 1'b1) ; 
    // READ address controller
    wire [ADDRESS_WIDTH:0] rd_addr_nxt_w = ((rd_en_i & (~empty_r)) ? rd_addr_p1_r : rd_addr_r) ; 
    wire [ADDRESS_WIDTH:0] rd_addr_nxt_p1_w = (rd_addr_nxt_w + 1'b1) ; 
    // Flag controller
    wire full_nxt_w = (((((~(rd_en_i & (~empty_r))) & (wr_en_i & (~full_r))) & (wr_cmpaddr_p1_r == rd_cmpaddr_r)) & (wr_addr_p1cmp_r[ADDRESS_WIDTH] != rd_addr_r[ADDRESS_WIDTH])) || ((~((wr_cmpaddr_r != rd_cmpaddr_r) || rd_en_i)) & full_r)) ; 
    wire empty_nxt_w = ((((rd_en_i & (~empty_r)) & (rd_addr_p1cmp_r == wr_addr_r)) & (~(wr_en_i & (~full_r)))) || ((~((wr_cmpaddr_r != rd_cmpaddr_r) || wr_en_i)) & empty_r)) ; 
    assign full_o = full_ext_r ; 
    assign empty_o = empty_ext_r ; 
    //----------------------------
    // Sequential Circuit
    //----------------------------
    if ((RESET_MODE == "sync")) 
        begin : MASTER_SYNC
            always
                @(posedge clk_i)
                begin
                    if (rst_i) 
                        begin
                            full_ext_r <=  1'b0 ;
                            full_r <=  1'b0 ;
                            full_mem_r <=  1'b0 ;
                            empty_ext_r <=  1'b1 ;
                            empty_r <=  1'b1 ;
                            empty_mem_r <=  1'b1 ;
                            wr_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            wr_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            wr_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            waddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                            rd_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            rd_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            raddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            rd_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                        end
                    else
                        begin
                            full_ext_r <=  full_nxt_w ;
                            full_r <=  full_nxt_w ;
                            full_mem_r <=  full_nxt_w ;
                            empty_ext_r <=  empty_nxt_w ;
                            empty_r <=  empty_nxt_w ;
                            empty_mem_r <=  empty_nxt_w ;
                            wr_addr_r <=  wr_addr_nxt_w ;
                            wr_addr_p1_r <=  wr_addr_nxt_p1_w ;
                            wr_cmpaddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_addr_p1cmp_r <=  wr_addr_nxt_p1_w ;
                            waddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_cmpaddr_p1_r <=  wr_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_addr_r <=  rd_addr_nxt_w ;
                            rd_addr_p1_r <=  rd_addr_nxt_p1_w ;
                            rd_addr_p1cmp_r <=  rd_addr_nxt_p1_w ;
                            rd_cmpaddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            raddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_cmpaddr_p1_r <=  rd_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                        end
                end
        end
    else
        begin : MASTER_ASYNC
            always
                @(posedge clk_i or 
                    posedge rst_i)
                begin
                    if (rst_i) 
                        begin
                            full_ext_r <=  1'b0 ;
                            full_r <=  1'b0 ;
                            full_mem_r <=  1'b0 ;
                            empty_ext_r <=  1'b1 ;
                            empty_r <=  1'b1 ;
                            empty_mem_r <=  1'b1 ;
                            wr_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            wr_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            wr_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            waddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            wr_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                            rd_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                            rd_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_addr_p1cmp_r <=  {{ADDRESS_WIDTH{1'b0}},
                                    1'b1} ;
                            rd_cmpaddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            raddr_r <=  {ADDRESS_WIDTH{1'b0}} ;
                            rd_cmpaddr_p1_r <=  {{(ADDRESS_WIDTH - 1){1'b0}},
                                    1'b1} ;
                        end
                    else
                        begin
                            full_ext_r <=  full_nxt_w ;
                            full_r <=  full_nxt_w ;
                            full_mem_r <=  full_nxt_w ;
                            empty_ext_r <=  empty_nxt_w ;
                            empty_r <=  empty_nxt_w ;
                            empty_mem_r <=  empty_nxt_w ;
                            wr_addr_r <=  wr_addr_nxt_w ;
                            wr_addr_p1_r <=  wr_addr_nxt_p1_w ;
                            wr_cmpaddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_addr_p1cmp_r <=  wr_addr_nxt_p1_w ;
                            waddr_r <=  wr_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            wr_cmpaddr_p1_r <=  wr_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_addr_r <=  rd_addr_nxt_w ;
                            rd_addr_p1_r <=  rd_addr_nxt_p1_w ;
                            rd_addr_p1cmp_r <=  rd_addr_nxt_p1_w ;
                            rd_cmpaddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            raddr_r <=  rd_addr_nxt_w[(ADDRESS_WIDTH - 1):0] ;
                            rd_cmpaddr_p1_r <=  rd_addr_nxt_p1_w[(ADDRESS_WIDTH - 1):0] ;
                        end
                end
        end
    //----------------------------
    // MISCELLANEOUS Features
    //----------------------------
    if ((((ENABLE_ALMOST_FULL_FLAG == "TRUE") || (ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) || (ENABLE_DATA_COUNT == "TRUE"))) 
        begin : MISC
            (* syn_preserve=1 *) reg full_flag_r ; 
            (* syn_preserve=1 *) reg empty_flag_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_flag_addr_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] wr_flag_addr_p1_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_flag_addr_r ; 
            (* syn_preserve=1 *) reg [ADDRESS_WIDTH:0] rd_flag_addr_p1_r ; 
            wire [ADDRESS_WIDTH:0] diff_norm_w = (wr_flag_addr_r - rd_flag_addr_r) ; 
            wire [ADDRESS_WIDTH:0] diff_wr_w = (wr_flag_addr_p1_r - rd_flag_addr_r) ; 
            wire [ADDRESS_WIDTH:0] diff_rd_w = (wr_flag_addr_r - rd_flag_addr_p1_r) ; 
            wire wr_w = (wr_en_i & (~full_flag_r)) ; 
            wire rd_w = (rd_en_i & (~empty_flag_r)) ; 
            wire [ADDRESS_WIDTH:0] diff_w = ((wr_w == rd_w) ? diff_norm_w : (wr_w ? diff_wr_w : diff_rd_w)) ; 
            if ((RESET_MODE == "sync")) 
                begin : SYNC_CON
                    always
                        @(posedge clk_i)
                        begin
                            if (rst_i) 
                                begin
                                    wr_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    wr_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    rd_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    rd_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    full_flag_r <=  1'b0 ;
                                    empty_flag_r <=  1'b1 ;
                                end
                            else
                                begin
                                    wr_flag_addr_r <=  wr_addr_nxt_w ;
                                    wr_flag_addr_p1_r <=  wr_addr_nxt_p1_w ;
                                    rd_flag_addr_r <=  rd_addr_nxt_w ;
                                    rd_flag_addr_p1_r <=  rd_addr_nxt_p1_w ;
                                    full_flag_r <=  full_nxt_w ;
                                    empty_flag_r <=  empty_nxt_w ;
                                end
                        end
                end
            else
                begin : ASYNC_CON
                    always
                        @(posedge clk_i or 
                            posedge rst_i)
                        begin
                            if (rst_i) 
                                begin
                                    wr_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    wr_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    rd_flag_addr_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                    rd_flag_addr_p1_r <=  {{ADDRESS_WIDTH{1'b0}},
                                            1'b1} ;
                                    full_flag_r <=  1'b0 ;
                                    empty_flag_r <=  1'b1 ;
                                end
                            else
                                begin
                                    wr_flag_addr_r <=  wr_addr_nxt_w ;
                                    wr_flag_addr_p1_r <=  wr_addr_nxt_p1_w ;
                                    rd_flag_addr_r <=  rd_addr_nxt_w ;
                                    rd_flag_addr_p1_r <=  rd_addr_nxt_p1_w ;
                                    full_flag_r <=  full_nxt_w ;
                                    empty_flag_r <=  empty_nxt_w ;
                                end
                        end
                end
            // Almost Flag Controller
            if ((ENABLE_ALMOST_FULL_FLAG == "TRUE")) 
                begin : AFull
                    wire [(ADDRESS_WIDTH - 1):0] almost_full_tick_w = (((ALMOST_FULL_ASSERTION == "static-single") || (ALMOST_FULL_ASSERTION == "static-dual")) ? ALMOST_FULL_ASSERT_LVL : almost_full_th_i) ; 
                    wire [(ADDRESS_WIDTH - 1):0] almost_full_tock_w = ((ALMOST_FULL_ASSERTION == "static-single") ? ALMOST_FULL_ASSERT_LVL : ((ALMOST_FULL_ASSERTION == "static-dual") ? ALMOST_FULL_DEASSERT_LVL : ((ALMOST_FULL_ASSERTION == "dynamic-single") ? almost_full_th_i : almost_full_clr_th_i))) ; 
                    reg almost_full_r ; 
                    reg almost_full_ext_r ; 
                    wire almost_full_nxt_w ; 
                    if (((ALMOST_FULL_ASSERTION == "static-single") || (ALMOST_FULL_ASSERTION == "dynamic-single"))) 
                        begin : genblk1
                            assign almost_full_nxt_w = (~(diff_w < almost_full_tick_w)) ; 
                        end
                    else
                        begin : genblk1
                            assign almost_full_nxt_w = ((~(diff_w < almost_full_tick_w)) | ((diff_w > almost_full_tock_w) & almost_full_r)) ; 
                        end
                    assign almost_full_o = almost_full_ext_r ; 
                    if ((RESET_MODE == "sync")) 
                        begin : genblk2
                            always
                                @(posedge clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_full_ext_r <=  1'b0 ;
                                            almost_full_r <=  1'b0 ;
                                        end
                                    else
                                        begin
                                            almost_full_ext_r <=  almost_full_nxt_w ;
                                            almost_full_r <=  almost_full_nxt_w ;
                                        end
                                end
                        end
                    else
                        begin : genblk2
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_full_ext_r <=  1'b0 ;
                                            almost_full_r <=  1'b0 ;
                                        end
                                    else
                                        begin
                                            almost_full_ext_r <=  almost_full_nxt_w ;
                                            almost_full_r <=  almost_full_nxt_w ;
                                        end
                                end
                        end
                end
            else
                begin : genblk2
                    assign almost_full_o = 1'b0 ; 
                end
            // Almost Empty Controller
            if ((ENABLE_ALMOST_EMPTY_FLAG == "TRUE")) 
                begin : AEmpty
                    wire [(ADDRESS_WIDTH - 1):0] almost_empty_tick_w = (((ALMOST_EMPTY_ASSERTION == "static-single") || (ALMOST_EMPTY_ASSERTION == "static-dual")) ? ALMOST_EMPTY_ASSERT_LVL : almost_empty_th_i) ; 
                    wire [(ADDRESS_WIDTH - 1):0] almost_empty_tock_w = ((ALMOST_EMPTY_ASSERTION == "static-single") ? ALMOST_EMPTY_ASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "static-dual") ? ALMOST_EMPTY_DEASSERT_LVL : ((ALMOST_EMPTY_ASSERTION == "dynamic-single") ? almost_empty_th_i : almost_empty_clr_th_i))) ; 
                    reg almost_empty_r ; 
                    reg almost_empty_ext_r ; 
                    wire almost_empty_nxt_w ; 
                    if (((ALMOST_EMPTY_ASSERTION == "static-single") || (ALMOST_EMPTY_ASSERTION == "dynamic-single"))) 
                        begin : genblk1
                            assign almost_empty_nxt_w = (~(diff_w > almost_empty_tick_w)) ; 
                        end
                    else
                        begin : genblk1
                            assign almost_empty_nxt_w = ((diff_w < almost_empty_tock_w) & ((~(diff_w > almost_empty_tick_w)) | almost_empty_r)) ; 
                        end
                    assign almost_empty_o = almost_empty_ext_r ; 
                    if ((RESET_MODE == "sync")) 
                        begin : genblk2
                            always
                                @(posedge clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_empty_ext_r <=  1'b1 ;
                                            almost_empty_r <=  1'b1 ;
                                        end
                                    else
                                        begin
                                            almost_empty_ext_r <=  almost_empty_nxt_w ;
                                            almost_empty_r <=  almost_empty_nxt_w ;
                                        end
                                end
                        end
                    else
                        begin : genblk2
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            almost_empty_ext_r <=  1'b1 ;
                                            almost_empty_r <=  1'b1 ;
                                        end
                                    else
                                        begin
                                            almost_empty_ext_r <=  almost_empty_nxt_w ;
                                            almost_empty_r <=  almost_empty_nxt_w ;
                                        end
                                end
                        end
                end
            else
                begin : genblk3
                    assign almost_empty_o = 1'b0 ; 
                end
            // Enable Data Count Controller
            if ((ENABLE_DATA_COUNT == "TRUE")) 
                begin : genblk4
                    reg [ADDRESS_WIDTH:0] data_cnt_r ; 
                    assign data_cnt_o = data_cnt_r ; 
                    if ((RESET_MODE == "sync")) 
                        begin : genblk1
                            always
                                @(posedge clk_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            data_cnt_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                        end
                                    else
                                        begin
                                            data_cnt_r <=  diff_w ;
                                        end
                                end
                        end
                    else
                        begin : genblk1
                            always
                                @(posedge clk_i or 
                                    posedge rst_i)
                                begin
                                    if (rst_i) 
                                        begin
                                            data_cnt_r <=  {(ADDRESS_WIDTH + 1){1'b0}} ;
                                        end
                                    else
                                        begin
                                            data_cnt_r <=  diff_w ;
                                        end
                                end
                        end
                end
            else
                begin : genblk4
                    assign data_cnt_o = {(ADDRESS_WIDTH + 1){1'b0}} ; 
                end
        end
    // -----------------
    // -- FIFO MEMORY --
    // -----------------
    wire wr_fifo_en_w = (wr_en_i & (~full_mem_r)) ; 
    wire rd_fifo_en_w = (rd_en_i & (~empty_mem_r)) ; 
    (* syn_ramstyle="distributed" *) reg [(DATA_WIDTH - 1):0] mem [((2 ** ADDRESS_WIDTH) - 1):0] ; 
    reg [(DATA_WIDTH - 1):0] data_raw_r ; 
    wire [(DATA_WIDTH - 1):0] data_raw_nxt ; 
    reg [(DATA_WIDTH - 1):0] data_buff_r ; 
    assign rd_data_o = ((REGMODE == "reg") ? data_buff_r : data_raw_r) ; 
    assign rd_data_nxt = ((REGMODE == "reg") ? data_raw_r : data_raw_nxt) ; 
    always
        @(posedge clk_i)
        begin
            if ((wr_fifo_en_w == 1'b1)) 
                begin
                    mem[waddr_r] <=  wr_data_i ;
                end
        end
    assign data_raw_nxt = (rd_fifo_en_w ? mem[raddr_r] : data_raw_r) ; 
    always
        @(posedge clk_i)
        begin
            data_raw_r <=  data_raw_nxt ;
        end
    if ((REGMODE == "reg")) 
        begin : mem_reg
            if ((RESET_MODE == "sync")) 
                begin : sync
                    always
                        @(posedge clk_i)
                        begin
                            if ((rst_i == 1'b1)) 
                                begin
                                    data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                end
                            else
                                begin
                                    data_buff_r <=  data_raw_r ;
                                end
                        end
                end
            else
                begin : async
                    always
                        @(posedge clk_i or 
                            posedge rst_i)
                        begin
                            if ((rst_i == 1'b1)) 
                                begin
                                    data_buff_r <=  {DATA_WIDTH{1'b0}} ;
                                end
                            else
                                begin
                                    data_buff_r <=  data_raw_r ;
                                end
                        end
                end
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_cdc.sv
// Title                 :
// Dependencies          :
// Description           :
// =============================================================================
module new_lpddr4_ipgen_lscc_apb_cdc #(parameter ADDR_WIDTH = 10, 
        parameter DATA_WIDTH = 32, 
        parameter PSLVERR_EN = 0, 
        parameter REVEAL_DBG_EN = 1) (
    input apb_s0_pclk_i, 
    input apb_s0_presetn_i, 
    input apb_s0_psel_slv_i, 
    input [(ADDR_WIDTH - 1):0] apb_s0_paddr_slv_i, 
    input apb_s0_pwrite_slv_i, 
    input [(DATA_WIDTH - 1):0] apb_s0_pwdata_slv_i, 
    input apb_s0_penable_slv_i, 
    output reg apb_s0_pready_slv_o, 
    output apb_s0_pslverr_slv_o, 
    (* syn_preserve=1 *) output reg [(DATA_WIDTH - 1):0] apb_s0_prdata_slv_o, 
    input apb_m0_pclk_i, 
    input apb_m0_presetn_i, 
    input apb_m0_pready_mst_i, 
    input apb_m0_pslverr_mst_i, 
    input [(DATA_WIDTH - 1):0] apb_m0_prdata_mst_i, 
    output reg apb_m0_psel_mst_o, 
    (* syn_preserve=1 *) output reg [(ADDR_WIDTH - 1):0] apb_m0_paddr_mst_o, 
    (* syn_preserve=1 *) output reg apb_m0_pwrite_mst_o, 
    (* syn_preserve=1 *) output reg [(DATA_WIDTH - 1):0] apb_m0_pwdata_mst_o, 
    output reg apb_m0_penable_mst_o) ;
    localparam WRITE_POS = (ADDR_WIDTH + DATA_WIDTH) ; 
    localparam VALID_POS = ((ADDR_WIDTH + DATA_WIDTH) + 1) ; 
    localparam BUFF_WIDTH = ((ADDR_WIDTH + DATA_WIDTH) + 2) ; 
    localparam ST_IDLE = 2'b00 ; 
    localparam ST_SETUP = 2'b01 ; 
    localparam ST_ACCESS = 2'b11 ; 
    // Registered using apb_s0_pclk_i
    reg [(BUFF_WIDTH - 1):0] s_buf0_r ; 
    reg [(BUFF_WIDTH - 1):0] s_buf1_r ; 
    reg s_wsel_r ; 
    (* syn_preserve=1 *) reg s_s2m_pend0_r ; 
    (* syn_preserve=1 *) reg s_s2m_pend1_r ; 
    (* syn_preserve=1 *) reg s_s2m_pend0_rep_r ; 
    (* syn_preserve=1 *) reg s_s2m_pend1_rep_r ; 
    wire s_s2m_pend0_nxt ; 
    wire s_s2m_pend1_nxt ; 
    reg s_m2s_b0_r0 ; 
    reg s_m2s_b0_r1 ; 
    reg s_m2s_b0_r2 ; 
    reg s_m2s_b1_r0 ; 
    reg s_m2s_b1_r1 ; 
    reg s_m2s_b1_r2 ; 
    reg s_m2s_rdata_r0 ; 
    reg s_m2s_rdata_r1 ; 
    reg s_m2s_rdata_r2 ; 
    //  reg                  s_clear_buf0_r;
    //  reg                  s_clear_buf1_r;
    // Registered using apb_m0_pclk_i
    reg m_rsel_r ; 
    reg m_s2m_b0_r0 ; 
    reg m_s2m_b0_r1 ; 
    reg m_s2m_b0_r2 ; 
    reg m_s2m_b1_r0 ; 
    reg m_s2m_b1_r1 ; 
    reg m_s2m_b1_r2 ; 
    (* syn_preserve=1 *) reg m_m2s_pend0_r ; 
    (* syn_preserve=1 *) reg m_m2s_pend1_r ; 
    (* syn_preserve=1 *) reg m_m2s_pend0_rep_r ; 
    (* syn_preserve=1 *) reg m_m2s_pend1_rep_r ; 
    wire m_m2s_pend0_nxt ; 
    wire m_m2s_pend1_nxt ; 
    (* syn_preserve=1 *) reg m_m2s_rdata_pend_r ; 
    (* syn_preserve=1 *) reg m_m2s_rdata_pend_rep_r ; 
    wire m_m2s_rdata_pend_nxt ; 
    reg [(DATA_WIDTH - 1):0] m_m2s_prdata_r ; 
    reg [1:0] apbm_sm_curr ; 
    reg [1:0] apbm_sm_next ; 
    reg m_buf0_valid_r ; 
    reg m_buf1_valid_r ; 
    wire s_clear_buf0_w ; 
    wire s_clear_buf1_w ; 
    wire s_buf0_wr_ok_w ; 
    wire s_buf1_wr_ok_w ; 
    wire s_tx_done_w ; 
    wire s_rdata_valid_w ; 
    wire m_buf0_valid_w ; 
    wire m_buf1_valid_w ; 
    wire s_buffer_empty ; 
    wire s_pending_tx_w ; 
    assign s_pending_tx_w = ((apb_s0_psel_slv_i & apb_s0_penable_slv_i) & (~apb_s0_pready_slv_o)) ; 
    assign s_clear_buf0_w = (s_m2s_b0_r2 != s_m2s_b0_r1) ; 
    assign s_clear_buf1_w = (s_m2s_b1_r2 != s_m2s_b1_r1) ; 
    assign s_buffer_empty = ((~s_buf0_r[VALID_POS]) & (~s_buf1_r[VALID_POS])) ; 
    assign s_buf0_wr_ok_w = (((~s_wsel_r) & (~s_buf0_r[VALID_POS])) & ((apb_s0_psel_slv_i & (~apb_s0_penable_slv_i)) | s_pending_tx_w)) ; 
    //  assign s_buf0_wr_ok_w = ~s_wsel_r & apb_s0_psel_slv_i & (
    //                          (~apb_s0_penable_slv_i & ~s_buf0_r[VALID_POS]));              // setup state and buffer0 is empty
    //                        | (apb_s0_pwrite_slv_i & s_buf0_r[VALID_POS] & s_clear_buf0_w)// buffer0 has data and buffer0 clear is asserted
    //                        | (s_pending_tx_w & s_buffer_empty));
    assign s_buf1_wr_ok_w = ((s_wsel_r & (~s_buf1_r[VALID_POS])) & ((apb_s0_psel_slv_i & (~apb_s0_penable_slv_i)) | s_pending_tx_w)) ; 
    //  assign s_buf1_wr_ok_w =  s_wsel_r & apb_s0_psel_slv_i & (
    //                          (~apb_s0_penable_slv_i & ~s_buf1_r[VALID_POS]));              // setup state and buffer1 is empty
    //                        | (apb_s0_pwrite_slv_i & s_buf1_r[VALID_POS] & s_clear_buf1_w)  // buffer1 has data and buffer1 clear is asserted
    //                        | (s_pending_tx_w & s_buffer_empty));  
    // These get optimized in synthesis 
    //  assign apb_m0_psel_mst_o    = apbm_sm_curr[0]; 
    //  assign apb_m0_penable_mst_o = apbm_sm_curr[1];
    assign s_tx_done_w = ((apb_s0_psel_slv_i & apb_s0_penable_slv_i) & apb_s0_pready_slv_o) ; 
    assign s_rdata_valid_w = (s_m2s_rdata_r2 != s_m2s_rdata_r1) ; 
    assign m_buf0_valid_w = (m_s2m_b0_r2 != m_s2m_b0_r1) ; 
    assign m_buf1_valid_w = (m_s2m_b1_r2 != m_s2m_b1_r1) ; 
    assign s_s2m_pend0_nxt = (s_buf0_wr_ok_w ? (~s_s2m_pend0_rep_r) : s_s2m_pend0_rep_r) ; 
    assign s_s2m_pend1_nxt = (s_buf1_wr_ok_w ? (~s_s2m_pend1_rep_r) : s_s2m_pend1_rep_r) ; 
    always
        @(posedge apb_s0_pclk_i or 
            negedge apb_s0_presetn_i)
        begin
            if ((!apb_s0_presetn_i)) 
                begin
                    s_buf0_r <=  {BUFF_WIDTH{1'b0}} ;
                    s_buf1_r <=  {BUFF_WIDTH{1'b0}} ;
                    s_wsel_r <=  1'b0 ;
                    s_m2s_b0_r0 <=  1'b0 ;
                    s_m2s_b0_r1 <=  1'b0 ;
                    s_m2s_b0_r2 <=  1'b0 ;
                    s_m2s_b1_r0 <=  1'b0 ;
                    s_m2s_b1_r1 <=  1'b0 ;
                    s_m2s_b1_r2 <=  1'b0 ;
                    s_s2m_pend0_r <=  1'b0 ;
                    s_s2m_pend1_r <=  1'b0 ;
                    s_s2m_pend0_rep_r <=  1'b0 ;
                    s_s2m_pend1_rep_r <=  1'b0 ;
                    //      s_clear_buf0_r  <= 1'b0;
                    //      s_clear_buf1_r  <= 1'b0;
                end
            else
                begin
                    s_s2m_pend0_r <=  s_s2m_pend0_nxt ;
                    s_s2m_pend1_r <=  s_s2m_pend1_nxt ;
                    s_s2m_pend0_rep_r <=  s_s2m_pend0_nxt ;
                    s_s2m_pend1_rep_r <=  s_s2m_pend1_nxt ;
                    if (s_buf0_wr_ok_w) 
                        s_buf0_r <=  {1'b1,
                                apb_s0_pwrite_slv_i,
                                apb_s0_paddr_slv_i,
                                apb_s0_pwdata_slv_i} ;
                    else
                        if (s_clear_buf0_w) 
                            s_buf0_r[VALID_POS] <=  1'b0 ;
                    if (s_buf1_wr_ok_w) 
                        s_buf1_r <=  {1'b1,
                                apb_s0_pwrite_slv_i,
                                apb_s0_paddr_slv_i,
                                apb_s0_pwdata_slv_i} ;
                    else
                        if (s_clear_buf1_w) 
                            s_buf1_r[VALID_POS] <=  1'b0 ;
                    if (s_tx_done_w) 
                        s_wsel_r <=  (~s_wsel_r) ;
                    // Triple registers for CDC
                    s_m2s_b0_r0 <=  m_m2s_pend0_r ;
                    s_m2s_b0_r1 <=  s_m2s_b0_r0 ;
                    s_m2s_b0_r2 <=  s_m2s_b0_r1 ;
                    s_m2s_b1_r0 <=  m_m2s_pend1_r ;
                    s_m2s_b1_r1 <=  s_m2s_b1_r0 ;
                    s_m2s_b1_r2 <=  s_m2s_b1_r1 ;
                    //      s_clear_buf0_r  <= s_clear_buf0_w;
                    //      s_clear_buf1_r  <= s_clear_buf1_w;
                end
        end// always
    // read data logic on Slave port side
    always
        @(posedge apb_s0_pclk_i or 
            negedge apb_s0_presetn_i)
        begin
            if ((!apb_s0_presetn_i)) 
                begin
                    s_m2s_rdata_r0 <=  1'b0 ;
                    s_m2s_rdata_r1 <=  1'b0 ;
                    s_m2s_rdata_r2 <=  1'b0 ;
                    apb_s0_pready_slv_o <=  1'b0 ;
                    apb_s0_prdata_slv_o <=  {DATA_WIDTH{1'b0}} ;
                end
            else
                begin
                    if (s_rdata_valid_w) 
                        apb_s0_prdata_slv_o <=  m_m2s_prdata_r ;
                    if (apb_s0_psel_slv_i) 
                        begin
                            if (apb_s0_pwrite_slv_i) 
                                apb_s0_pready_slv_o <=  (s_wsel_r ? s_buf1_wr_ok_w : s_buf0_wr_ok_w) ;
                            else
                                apb_s0_pready_slv_o <=  s_rdata_valid_w ;
                        end
                    else
                        apb_s0_pready_slv_o <=  1'b0 ;
                    // Triple registers for CDC
                    s_m2s_rdata_r0 <=  m_m2s_rdata_pend_r ;
                    s_m2s_rdata_r1 <=  s_m2s_rdata_r0 ;
                    s_m2s_rdata_r2 <=  s_m2s_rdata_r1 ;
                end
        end// always
    wire m_tx_done_w ; 
    wire m_rd_done_w ; 
    wire m_rsel_nxt ; 
    wire m_new_req_w ; 
    assign m_tx_done_w = ((apbm_sm_curr == ST_ACCESS) ? apb_m0_pready_mst_i : 1'b0) ; 
    assign m_rd_done_w = (m_tx_done_w & (~apb_m0_pwrite_mst_o)) ; 
    assign m_rsel_nxt = (m_tx_done_w ? (~m_rsel_r) : m_rsel_r) ; 
    //assign m_new_req_w          = m_rsel_nxt ? (m_buf1_valid_r | m_buf1_valid_w) : (m_buf0_valid_r | m_buf0_valid_w);
    assign m_new_req_w = (m_rsel_nxt ? m_buf1_valid_r : m_buf0_valid_r) ; 
    assign m_m2s_rdata_pend_nxt = (m_rd_done_w ? (~m_m2s_rdata_pend_rep_r) : m_m2s_rdata_pend_rep_r) ; 
    // read data logic on Master port side
    always
        @(posedge apb_m0_pclk_i or 
            negedge apb_m0_presetn_i)
        begin
            if ((!apb_m0_presetn_i)) 
                begin
                    m_m2s_prdata_r <=  {DATA_WIDTH{1'b0}} ;
                    m_m2s_rdata_pend_r <=  1'b0 ;
                    m_m2s_rdata_pend_rep_r <=  1'b0 ;
                end
            else
                begin
                    // will remain static until the next read done
                    // Read will be spaced due to CDC so no risk of data collision
                    if (m_rd_done_w) 
                        m_m2s_prdata_r <=  apb_m0_prdata_mst_i ;
                    m_m2s_rdata_pend_r <=  m_m2s_rdata_pend_nxt ;
                    m_m2s_rdata_pend_rep_r <=  m_m2s_rdata_pend_nxt ;
                end
        end// always
    always
        @(*)
        begin
            case (apbm_sm_curr)
            ST_IDLE : 
                begin
                    apbm_sm_next = (m_new_req_w ? ST_SETUP : ST_IDLE) ;
                end
            ST_SETUP : 
                begin
                    apbm_sm_next = ST_ACCESS ;
                end
            ST_ACCESS : 
                begin
                    if (apb_m0_pready_mst_i) 
                        begin
                            if (m_new_req_w) 
                                // there is new request
                                apbm_sm_next = ST_SETUP ;
                            else
                                apbm_sm_next = ST_IDLE ;
                        end
                    else
                        apbm_sm_next = ST_ACCESS ;
                end
            default : 
                begin
                    apbm_sm_next = ST_IDLE ;
                end
            endcase 
        end// always
    // APB master state register and state output
    always
        @(posedge apb_m0_pclk_i or 
            negedge apb_m0_presetn_i)
        begin
            if ((!apb_m0_presetn_i)) 
                begin
                    apbm_sm_curr <=  ST_IDLE ;
                    apb_m0_pwdata_mst_o <=  {DATA_WIDTH{1'b0}} ;
                    apb_m0_paddr_mst_o <=  {ADDR_WIDTH{1'b0}} ;
                    apb_m0_pwrite_mst_o <=  1'b0 ;
                    apb_m0_psel_mst_o <=  1'b0 ;
                    apb_m0_penable_mst_o <=  1'b0 ;
                end
            else
                begin
                    apbm_sm_curr <=  apbm_sm_next ;
                    if ((apbm_sm_next == ST_SETUP)) 
                        begin
                            if (m_rsel_nxt) 
                                begin
                                    apb_m0_pwdata_mst_o <=  s_buf1_r[(DATA_WIDTH - 1):0] ;
                                    apb_m0_paddr_mst_o <=  s_buf1_r[(VALID_POS - 2):DATA_WIDTH] ;
                                    apb_m0_pwrite_mst_o <=  s_buf1_r[(VALID_POS - 1)] ;
                                end
                            else
                                begin
                                    apb_m0_pwdata_mst_o <=  s_buf0_r[(DATA_WIDTH - 1):0] ;
                                    apb_m0_paddr_mst_o <=  s_buf0_r[(VALID_POS - 2):DATA_WIDTH] ;
                                    apb_m0_pwrite_mst_o <=  s_buf0_r[(VALID_POS - 1)] ;
                                end
                        end
                    case (apbm_sm_next)
                    ST_SETUP : 
                        begin
                            apb_m0_psel_mst_o <=  1'b1 ;
                            apb_m0_penable_mst_o <=  1'b0 ;
                        end
                    ST_ACCESS : 
                        begin
                            apb_m0_psel_mst_o <=  1'b1 ;
                            apb_m0_penable_mst_o <=  1'b1 ;
                        end
                    default : 
                        begin
                            apb_m0_psel_mst_o <=  1'b0 ;
                            apb_m0_penable_mst_o <=  1'b0 ;
                        end
                    endcase 
                end
        end// always
    reg buff_empty_r ; 
    wire only_buff0_valid_w = (m_buf0_valid_r & (~m_buf1_valid_r)) ; 
    wire only_buff1_valid_w = ((~m_buf0_valid_r) & m_buf1_valid_r) ; 
    assign m_m2s_pend0_nxt = (((m_buf0_valid_r && m_tx_done_w) && (!m_rsel_r)) ? (~m_m2s_pend0_rep_r) : m_m2s_pend0_rep_r) ; 
    assign m_m2s_pend1_nxt = (((m_buf1_valid_r && m_tx_done_w) && m_rsel_r) ? (~m_m2s_pend1_rep_r) : m_m2s_pend1_rep_r) ; 
    always
        @(posedge apb_m0_pclk_i or 
            negedge apb_m0_presetn_i)
        begin
            if ((!apb_m0_presetn_i)) 
                begin
                    m_s2m_b0_r0 <=  1'b0 ;
                    m_s2m_b0_r1 <=  1'b0 ;
                    m_s2m_b0_r2 <=  1'b0 ;
                    m_s2m_b1_r0 <=  1'b0 ;
                    m_s2m_b1_r1 <=  1'b0 ;
                    m_s2m_b1_r2 <=  1'b0 ;
                    m_buf0_valid_r <=  1'b0 ;
                    m_buf1_valid_r <=  1'b0 ;
                    m_m2s_pend0_r <=  1'b0 ;
                    m_m2s_pend1_r <=  1'b0 ;
                    m_m2s_pend0_rep_r <=  1'b0 ;
                    m_m2s_pend1_rep_r <=  1'b0 ;
                    m_rsel_r <=  1'b0 ;
                    buff_empty_r <=  1'b0 ;
                end
            else
                begin
                    buff_empty_r <=  ((~m_buf0_valid_r) & (~m_buf1_valid_r)) ;
                    if (m_tx_done_w) 
                        m_rsel_r <=  (~m_rsel_r) ;
                    else
                        if (buff_empty_r) 
                            begin
                                // Buffers are previously empty
                                // correcting the m_rsel_r in case race condition happens
                                if ((only_buff0_valid_w & m_rsel_r)) 
                                    m_rsel_r <=  1'b0 ;
                                else
                                    if ((only_buff1_valid_w & (!m_rsel_r))) 
                                        m_rsel_r <=  1'b1 ;
                            end
                    // Double registers for CDC - capturing the s_s2m_pend*
                    m_s2m_b0_r0 <=  s_s2m_pend0_r ;
                    m_s2m_b0_r1 <=  m_s2m_b0_r0 ;
                    m_s2m_b0_r2 <=  m_s2m_b0_r1 ;
                    m_s2m_b1_r0 <=  s_s2m_pend1_r ;
                    m_s2m_b1_r1 <=  m_s2m_b1_r0 ;
                    m_s2m_b1_r2 <=  m_s2m_b1_r1 ;
                    m_m2s_pend0_r <=  m_m2s_pend0_nxt ;
                    m_m2s_pend1_r <=  m_m2s_pend1_nxt ;
                    m_m2s_pend0_rep_r <=  m_m2s_pend0_nxt ;
                    m_m2s_pend1_rep_r <=  m_m2s_pend1_nxt ;
                    if (m_buf0_valid_r) 
                        begin
                            if ((m_tx_done_w && (!m_rsel_r))) 
                                m_buf0_valid_r <=  1'b0 ;
                        end
                    else
                        m_buf0_valid_r <=  m_buf0_valid_w ;
                    if (m_buf1_valid_r) 
                        begin
                            if ((m_tx_done_w && m_rsel_r)) 
                                m_buf1_valid_r <=  1'b0 ;
                        end
                    else
                        m_buf1_valid_r <=  m_buf1_valid_w ;
                end
        end// always
    generate
        if ((PSLVERR_EN == 1)) 
            begin : ERR
                reg s_pslverr ; 
                reg m_m2s_pslverr ; 
                always
                    @(posedge apb_s0_pclk_i or 
                        negedge apb_s0_presetn_i)
                    begin
                        if ((!apb_s0_presetn_i)) 
                            begin
                                s_pslverr <=  1'b0 ;
                            end
                        else
                            begin
                                if (s_rdata_valid_w) 
                                    s_pslverr <=  m_m2s_pslverr ;
                            end
                    end
                assign apb_s0_pslverr_slv_o = s_pslverr ; 
                always
                    @(posedge apb_m0_pclk_i or 
                        negedge apb_m0_presetn_i)
                    begin
                        if ((!apb_m0_presetn_i)) 
                            begin
                                m_m2s_pslverr <=  1'b0 ;
                            end
                        else
                            begin
                                if (m_rd_done_w) 
                                    m_m2s_pslverr <=  apb_m0_pslverr_mst_i ;
                            end
                    end
            end
        else
            begin : NO_ERR
                assign apb_s0_pslverr_slv_o = 0 ; 
            end
    endgenerate

// Added for Reveal
/*
    reg rvl_s_buf0_valid_r0;
    reg rvl_s_buf0_valid_r1;
    reg rvl_s_buf1_valid_r0;
    reg rvl_s_buf1_valid_r1;
    
    always @(posedge apb_m0_pclk_i or negedge apb_m0_presetn_i) begin
      if (!apb_m0_presetn_i) begin
        rvl_s_buf0_valid_r0  <= 1'b0;
        rvl_s_buf0_valid_r1  <= 1'b0;
        rvl_s_buf1_valid_r0  <= 1'b0;
        rvl_s_buf1_valid_r1  <= 1'b0;
      end
      else begin
        rvl_s_buf0_valid_r0  <= s_buf0_r[VALID_POS];
        rvl_s_buf1_valid_r0  <= s_buf1_r[VALID_POS];
        rvl_s_buf0_valid_r1  <= rvl_s_buf0_valid_r0;
        rvl_s_buf1_valid_r1  <= rvl_s_buf1_valid_r0;
      end
    end
*/
//endgenerate
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp.v
// Title                 :
// Dependencies          :
// Description           : Implements a pseudo Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.1.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp #(parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter FAMILY = "common", 
        parameter WADDR_DEPTH = 1024, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 18, 
        parameter RADDR_DEPTH = 1024, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE = "sync", 
        parameter RESET_RELEASE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 1, 
        parameter BYTE_SIZE = 9, 
        parameter BYTE_WIDTH = (WDATA_WIDTH / BYTE_SIZE), 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter OUTPUT_CLK_EN = 0, 
        parameter BYTE_ENABLE_POL = "active-high", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input rd_out_clk_en_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input [(WADDR_WIDTH - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(RADDR_WIDTH - 1):0] rd_addr_i, 
    input [(BYTE_WIDTH - 1):0] ben_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    localparam T_FAMILY = ((((FAMILY == "LFD2NX") || (FAMILY == "LFCPNX")) || (FAMILY == "LFMXO5")) ? "LIFCL" : FAMILY) ; 
    new_lpddr4_ipgen_lscc_ram_dp_main #(.MEM_ID(MEM_ID),
            .MEM_SIZE(MEM_SIZE),
            .FAMILY(T_FAMILY),
            .WADDR_DEPTH(WADDR_DEPTH),
            .WADDR_WIDTH(WADDR_WIDTH),
            .WDATA_WIDTH(WDATA_WIDTH),
            .RADDR_DEPTH(RADDR_DEPTH),
            .RADDR_WIDTH(RADDR_WIDTH),
            .RDATA_WIDTH(RDATA_WIDTH),
            .REGMODE(REGMODE),
            .GSR(GSR),
            .RESETMODE(RESETMODE),
            .RESET_RELEASE(RESET_RELEASE),
            .INIT_FILE(INIT_FILE),
            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
            .MODULE_TYPE(MODULE_TYPE),
            .INIT_MODE(INIT_MODE),
            .BYTE_ENABLE(BYTE_ENABLE),
            .BYTE_SIZE(BYTE_SIZE),
            .BYTE_WIDTH(BYTE_WIDTH),
            .PIPELINES(PIPELINES),
            .ECC_ENABLE(ECC_ENABLE),
            .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
            .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
            .INIT_VALUE_00(INIT_VALUE_00),
            .INIT_VALUE_01(INIT_VALUE_01),
            .INIT_VALUE_02(INIT_VALUE_02),
            .INIT_VALUE_03(INIT_VALUE_03),
            .INIT_VALUE_04(INIT_VALUE_04),
            .INIT_VALUE_05(INIT_VALUE_05),
            .INIT_VALUE_06(INIT_VALUE_06),
            .INIT_VALUE_07(INIT_VALUE_07),
            .INIT_VALUE_08(INIT_VALUE_08),
            .INIT_VALUE_09(INIT_VALUE_09),
            .INIT_VALUE_0A(INIT_VALUE_0A),
            .INIT_VALUE_0B(INIT_VALUE_0B),
            .INIT_VALUE_0C(INIT_VALUE_0C),
            .INIT_VALUE_0D(INIT_VALUE_0D),
            .INIT_VALUE_0E(INIT_VALUE_0E),
            .INIT_VALUE_0F(INIT_VALUE_0F),
            .INIT_VALUE_10(INIT_VALUE_10),
            .INIT_VALUE_11(INIT_VALUE_11),
            .INIT_VALUE_12(INIT_VALUE_12),
            .INIT_VALUE_13(INIT_VALUE_13),
            .INIT_VALUE_14(INIT_VALUE_14),
            .INIT_VALUE_15(INIT_VALUE_15),
            .INIT_VALUE_16(INIT_VALUE_16),
            .INIT_VALUE_17(INIT_VALUE_17),
            .INIT_VALUE_18(INIT_VALUE_18),
            .INIT_VALUE_19(INIT_VALUE_19),
            .INIT_VALUE_1A(INIT_VALUE_1A),
            .INIT_VALUE_1B(INIT_VALUE_1B),
            .INIT_VALUE_1C(INIT_VALUE_1C),
            .INIT_VALUE_1D(INIT_VALUE_1D),
            .INIT_VALUE_1E(INIT_VALUE_1E),
            .INIT_VALUE_1F(INIT_VALUE_1F),
            .INIT_VALUE_20(INIT_VALUE_20),
            .INIT_VALUE_21(INIT_VALUE_21),
            .INIT_VALUE_22(INIT_VALUE_22),
            .INIT_VALUE_23(INIT_VALUE_23),
            .INIT_VALUE_24(INIT_VALUE_24),
            .INIT_VALUE_25(INIT_VALUE_25),
            .INIT_VALUE_26(INIT_VALUE_26),
            .INIT_VALUE_27(INIT_VALUE_27),
            .INIT_VALUE_28(INIT_VALUE_28),
            .INIT_VALUE_29(INIT_VALUE_29),
            .INIT_VALUE_2A(INIT_VALUE_2A),
            .INIT_VALUE_2B(INIT_VALUE_2B),
            .INIT_VALUE_2C(INIT_VALUE_2C),
            .INIT_VALUE_2D(INIT_VALUE_2D),
            .INIT_VALUE_2E(INIT_VALUE_2E),
            .INIT_VALUE_2F(INIT_VALUE_2F),
            .INIT_VALUE_30(INIT_VALUE_30),
            .INIT_VALUE_31(INIT_VALUE_31),
            .INIT_VALUE_32(INIT_VALUE_32),
            .INIT_VALUE_33(INIT_VALUE_33),
            .INIT_VALUE_34(INIT_VALUE_34),
            .INIT_VALUE_35(INIT_VALUE_35),
            .INIT_VALUE_36(INIT_VALUE_36),
            .INIT_VALUE_37(INIT_VALUE_37),
            .INIT_VALUE_38(INIT_VALUE_38),
            .INIT_VALUE_39(INIT_VALUE_39),
            .INIT_VALUE_3A(INIT_VALUE_3A),
            .INIT_VALUE_3B(INIT_VALUE_3B),
            .INIT_VALUE_3C(INIT_VALUE_3C),
            .INIT_VALUE_3D(INIT_VALUE_3D),
            .INIT_VALUE_3E(INIT_VALUE_3E),
            .INIT_VALUE_3F(INIT_VALUE_3F),
            .INIT_VALUE_40(INIT_VALUE_40),
            .INIT_VALUE_41(INIT_VALUE_41),
            .INIT_VALUE_42(INIT_VALUE_42),
            .INIT_VALUE_43(INIT_VALUE_43),
            .INIT_VALUE_44(INIT_VALUE_44),
            .INIT_VALUE_45(INIT_VALUE_45),
            .INIT_VALUE_46(INIT_VALUE_46),
            .INIT_VALUE_47(INIT_VALUE_47),
            .INIT_VALUE_48(INIT_VALUE_48),
            .INIT_VALUE_49(INIT_VALUE_49),
            .INIT_VALUE_4A(INIT_VALUE_4A),
            .INIT_VALUE_4B(INIT_VALUE_4B),
            .INIT_VALUE_4C(INIT_VALUE_4C),
            .INIT_VALUE_4D(INIT_VALUE_4D),
            .INIT_VALUE_4E(INIT_VALUE_4E),
            .INIT_VALUE_4F(INIT_VALUE_4F),
            .INIT_VALUE_50(INIT_VALUE_50),
            .INIT_VALUE_51(INIT_VALUE_51),
            .INIT_VALUE_52(INIT_VALUE_52),
            .INIT_VALUE_53(INIT_VALUE_53),
            .INIT_VALUE_54(INIT_VALUE_54),
            .INIT_VALUE_55(INIT_VALUE_55),
            .INIT_VALUE_56(INIT_VALUE_56),
            .INIT_VALUE_57(INIT_VALUE_57),
            .INIT_VALUE_58(INIT_VALUE_58),
            .INIT_VALUE_59(INIT_VALUE_59),
            .INIT_VALUE_5A(INIT_VALUE_5A),
            .INIT_VALUE_5B(INIT_VALUE_5B),
            .INIT_VALUE_5C(INIT_VALUE_5C),
            .INIT_VALUE_5D(INIT_VALUE_5D),
            .INIT_VALUE_5E(INIT_VALUE_5E),
            .INIT_VALUE_5F(INIT_VALUE_5F),
            .INIT_VALUE_60(INIT_VALUE_60),
            .INIT_VALUE_61(INIT_VALUE_61),
            .INIT_VALUE_62(INIT_VALUE_62),
            .INIT_VALUE_63(INIT_VALUE_63),
            .INIT_VALUE_64(INIT_VALUE_64),
            .INIT_VALUE_65(INIT_VALUE_65),
            .INIT_VALUE_66(INIT_VALUE_66),
            .INIT_VALUE_67(INIT_VALUE_67),
            .INIT_VALUE_68(INIT_VALUE_68),
            .INIT_VALUE_69(INIT_VALUE_69),
            .INIT_VALUE_6A(INIT_VALUE_6A),
            .INIT_VALUE_6B(INIT_VALUE_6B),
            .INIT_VALUE_6C(INIT_VALUE_6C),
            .INIT_VALUE_6D(INIT_VALUE_6D),
            .INIT_VALUE_6E(INIT_VALUE_6E),
            .INIT_VALUE_6F(INIT_VALUE_6F),
            .INIT_VALUE_70(INIT_VALUE_70),
            .INIT_VALUE_71(INIT_VALUE_71),
            .INIT_VALUE_72(INIT_VALUE_72),
            .INIT_VALUE_73(INIT_VALUE_73),
            .INIT_VALUE_74(INIT_VALUE_74),
            .INIT_VALUE_75(INIT_VALUE_75),
            .INIT_VALUE_76(INIT_VALUE_76),
            .INIT_VALUE_77(INIT_VALUE_77),
            .INIT_VALUE_78(INIT_VALUE_78),
            .INIT_VALUE_79(INIT_VALUE_79),
            .INIT_VALUE_7A(INIT_VALUE_7A),
            .INIT_VALUE_7B(INIT_VALUE_7B),
            .INIT_VALUE_7C(INIT_VALUE_7C),
            .INIT_VALUE_7D(INIT_VALUE_7D),
            .INIT_VALUE_7E(INIT_VALUE_7E),
            .INIT_VALUE_7F(INIT_VALUE_7F)) mem_main (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(rst_i), 
                .wr_clk_en_i(wr_clk_en_i), 
                .rd_clk_en_i(rd_clk_en_i), 
                .rd_out_clk_en_i(rd_out_clk_en_i), 
                .wr_en_i(wr_en_i), 
                .wr_data_i(wr_data_i), 
                .wr_addr_i(wr_addr_i), 
                .rd_en_i(rd_en_i), 
                .rd_addr_i(rd_addr_i), 
                .ben_i(ben_i), 
                .rd_data_o(rd_data_o), 
                .one_err_det_o(one_err_det_o), 
                .two_err_det_o(two_err_det_o)) ; 
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp_main.v
// Title                 :
// Dependencies          :
// Description           : Top-level pseudo Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.1.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp_main #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_ICE_ = 2, 
        parameter _FCODE_AP6_ = 3, 
        parameter _FCODE_COMMON_ = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter FAMILY = "common", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : ((FAMILY == "iCE40UP") ? _FCODE_ICE_ : ((FAMILY == "ap6a00") ? _FCODE_AP6_ : _FCODE_COMMON_))), 
        parameter WADDR_DEPTH = 1024, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 18, 
        parameter RADDR_DEPTH = 1024, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 18, 
        parameter REGMODE = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE = "sync", 
        parameter RESET_RELEASE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 1, 
        parameter BYTE_SIZE = ((BYTE_ENABLE == 1) ? getByteSize(WDATA_WIDTH,
                FAMILY_CODE) : WDATA_WIDTH), 
        parameter BYTE_WIDTH = (WDATA_WIDTH / BYTE_SIZE), 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter OUTPUT_CLK_EN = 0, 
        parameter BYTE_ENABLE_POL = "active-high", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input rd_out_clk_en_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input [(WADDR_WIDTH - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(RADDR_WIDTH - 1):0] rd_addr_i, 
    input [(BYTE_WIDTH - 1):0] ben_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    localparam IS_BYTE_ENABLE = (((BYTE_ENABLE == 1) && ((WDATA_WIDTH % BYTE_SIZE) == 0)) && (BYTE_WIDTH > 1)) ; 
    localparam IS_GSR_EN = ((GSR == "enable") ? "ENABLED" : "DISABLED") ; 
    localparam IS_ECC = (((ECC_ENABLE == "enable") || (ECC_ENABLE == "ENABLE")) ? "ENABLE" : "DISABLE") ; 
    localparam STRING_LENGTH = ((FAMILY == "iCE40UP") ? 66 : 82) ; 
    // -----------------------------------------------------------------------------
    // Generate Sequential Blocks
    // -----------------------------------------------------------------------------
    genvar i0, 
        i1, 
        i_0, 
        i_1 ; 
    generate
        if ((FAMILY == "common")) 
            begin : behavioral
                reg [(RDATA_WIDTH - 1):0] dataout_reg ; 
                reg [(RDATA_WIDTH - 1):0] dataout_reg_buffer ; 
                reg [(RDATA_WIDTH - 1):0] mem /* sythesis syn_ramstyle="block_ram" */ [((2 ** RADDR_WIDTH) - 1):0] ; 
                assign rd_data_o = ((REGMODE == "reg") ? dataout_reg : dataout_reg_buffer) ; 
                initial
                    begin
                        if (((INIT_MODE == "mem_file") && (INIT_FILE != "none"))) 
                            begin
                                if ((INIT_FILE_FORMAT == "hex")) 
                                    $readmemh (INIT_FILE,
                                            mem,
                                            0,
                                            (RADDR_DEPTH - 1)) ;
                                else
                                    $readmemb (INIT_FILE,
                                            mem,
                                            0,
                                            (RADDR_DEPTH - 1)) ;
                            end
                    end
                always
                    @(posedge wr_clk_i)
                    begin
                        if (((wr_clk_en_i == 1'b1) && (wr_en_i == 1'b1))) 
                            mem[wr_addr_i] <=  wr_data_i ;
                    end
                always
                    @(posedge rd_clk_i)
                    begin
                        if (((rd_clk_en_i == 1'b1) && (rd_en_i == 1'b1))) 
                            dataout_reg_buffer <=  mem[rd_addr_i] ;
                    end
                if ((REGMODE == "reg")) 
                    begin : genblk1
                        if ((RESETMODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge rd_clk_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            dataout_reg <=  'h0 ;
                                        else
                                            if (((rd_out_clk_en_i == 1'b1) && (rd_en_i == 1'b1))) 
                                                dataout_reg <=  dataout_reg_buffer ;
                                    end
                            end
                        else
                            begin : genblk1
                                always
                                    @(posedge rd_clk_i or 
                                        posedge rst_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            dataout_reg <=  'h0 ;
                                        else
                                            if (((rd_out_clk_en_i == 1'b1) && (rd_en_i == 1'b1))) 
                                                dataout_reg <=  dataout_reg_buffer ;
                                    end
                            end
                    end
            end
        else
            if (((RDATA_WIDTH == WDATA_WIDTH) && (RADDR_DEPTH == WADDR_DEPTH))) 
                begin : NON_MIX
                    localparam OPT_DATA_WIDTH = getMinimaData(RADDR_DEPTH,
                                RDATA_WIDTH,
                                IS_BYTE_ENABLE,
                                BYTE_SIZE,
                                ECC_ENABLE,
                                FAMILY_CODE) ; 
                    localparam OPT_ADDR_DEPTH = data_to_addr(OPT_DATA_WIDTH,
                                FAMILY_CODE) ; 
                    localparam OPT_ADDR_WIDTH = clog2(OPT_ADDR_DEPTH) ; 
                    localparam EBR_DATA = roundUP(RDATA_WIDTH,
                                OPT_DATA_WIDTH) ; 
                    localparam EBR_ADDR = roundUP(RADDR_DEPTH,
                                OPT_ADDR_DEPTH) ; 
                    localparam BYTE_WIDTH_IMPL = ((BYTE_ENABLE == 0) ? 1 : (((OPT_DATA_WIDTH == 72) | (OPT_DATA_WIDTH == 64)) ? 8 : (((OPT_DATA_WIDTH == 36) | (OPT_DATA_WIDTH == 32)) ? 4 : (((OPT_DATA_WIDTH == 18) | (OPT_DATA_WIDTH == 16)) ? 2 : 1)))) ; 
                    wire [(RDATA_WIDTH - 1):0] rd_data_raw_w [(EBR_ADDR - 1):0] ; 
                    wire [(EBR_ADDR - 1):0] one_err_det_raw_w ; 
                    wire [(EBR_ADDR - 1):0] two_err_det_raw_w ; 
                    for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                    begin : ADDR_ROUTE
                        wire [(RDATA_WIDTH - 1):0] raw_output_w ; 
                        assign rd_data_raw_w[i0] = raw_output_w ; 
                        wire chk_addr_r_w ; 
                        if ((EBR_ADDR > 1)) 
                            begin : genblk1
                                assign chk_addr_r_w = (rd_addr_i[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH] == i0) ; 
                            end
                        else
                            begin : genblk1
                                assign chk_addr_r_w = 1'b1 ; 
                            end
                        wire [(OPT_ADDR_WIDTH - 1):0] act_addr_r_w ; 
                        if ((OPT_ADDR_WIDTH > RADDR_WIDTH)) 
                            begin : genblk2
                                assign act_addr_r_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                assign act_addr_r_w[(OPT_ADDR_WIDTH - 1):RADDR_WIDTH] = 'h000 ; 
                            end
                        else
                            begin : genblk2
                                assign act_addr_r_w = rd_addr_i[(OPT_ADDR_WIDTH - 1):0] ; 
                            end
                        wire chk_addr_w_w ; 
                        if ((EBR_ADDR > 1)) 
                            begin : genblk3
                                assign chk_addr_w_w = (wr_addr_i[(WADDR_WIDTH - 1):OPT_ADDR_WIDTH] == i0) ; 
                            end
                        else
                            begin : genblk3
                                assign chk_addr_w_w = 1'b1 ; 
                            end
                        wire [(OPT_ADDR_WIDTH - 1):0] act_addr_w_w ; 
                        if ((OPT_ADDR_WIDTH > WADDR_WIDTH)) 
                            begin : genblk4
                                assign act_addr_w_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                assign act_addr_w_w[(OPT_ADDR_WIDTH - 1):WADDR_WIDTH] = 'h000 ; 
                            end
                        else
                            begin : genblk4
                                assign act_addr_w_w = wr_addr_i[(OPT_ADDR_WIDTH - 1):0] ; 
                            end
                        wire [(EBR_DATA - 1):0] one_err_det_ind_w ; 
                        wire [(EBR_DATA - 1):0] two_err_det_ind_w ; 
                        if ((EBR_DATA == 1)) 
                            begin : genblk5
                                assign one_err_det_raw_w[i0] = one_err_det_ind_w[0] ; 
                                assign two_err_det_raw_w[i0] = two_err_det_ind_w[0] ; 
                            end
                        else
                            begin : genblk5
                                assign one_err_det_raw_w[i0] = (|one_err_det_ind_w) ; 
                                assign two_err_det_raw_w[i0] = (|two_err_det_ind_w) ; 
                            end
                        for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                        begin : DATA_ROUTE
                            localparam ECO_POSX = (i1 * OPT_DATA_WIDTH) ; 
                            localparam ECO_POSY = (i0 * OPT_ADDR_DEPTH) ; 
                            wire [(OPT_DATA_WIDTH - 1):0] act_in_w ; 
                            wire [(OPT_DATA_WIDTH - 1):0] act_out_w ; 
                            wire one_err_det_ebr_w ; 
                            wire two_err_det_ebr_w ; 
                            wire [(BYTE_WIDTH_IMPL - 1):0] act_ben_w ; 
                            assign one_err_det_ind_w[i1] = one_err_det_ebr_w ; 
                            assign two_err_det_ind_w[i1] = two_err_det_ebr_w ; 
                            if (((OPT_DATA_WIDTH * (i1 + 1)) <= RDATA_WIDTH)) 
                                begin : genblk1
                                    assign act_in_w = wr_data_i[(((i1 + 1) * OPT_DATA_WIDTH) - 1):(i1 * OPT_DATA_WIDTH)] ; 
                                    assign raw_output_w[(((i1 + 1) * OPT_DATA_WIDTH) - 1):(i1 * OPT_DATA_WIDTH)] = act_out_w ; 
                                end
                            else
                                begin : genblk1
                                    assign act_in_w[(WDATA_WIDTH - (1 + (i1 * OPT_DATA_WIDTH))):0] = wr_data_i[(WDATA_WIDTH - 1):(i1 * OPT_DATA_WIDTH)] ; 
                                    if ((OPT_DATA_WIDTH > (WDATA_WIDTH - (i1 * OPT_DATA_WIDTH)))) 
                                        begin : genblk1
                                            assign act_in_w[(OPT_DATA_WIDTH - 1):(WDATA_WIDTH - (i1 * OPT_DATA_WIDTH))] = {(OPT_DATA_WIDTH - (WDATA_WIDTH - (i1 * OPT_DATA_WIDTH))){1'b0}} ; 
                                        end
                                    assign raw_output_w[(RDATA_WIDTH - 1):(i1 * OPT_DATA_WIDTH)] = act_out_w[(RDATA_WIDTH - (1 + (i1 * OPT_DATA_WIDTH))):0] ; 
                                end
                            if ((IS_BYTE_ENABLE == 0)) 
                                begin : genblk2
                                    assign act_ben_w = {BYTE_WIDTH_IMPL{1'b1}} ; 
                                end
                            else
                                if ((OPT_DATA_WIDTH >= 8)) 
                                    begin : genblk2
                                        if ((BYTE_WIDTH_IMPL > 1)) 
                                            begin : genblk1
                                                if ((((i1 + 1) * BYTE_WIDTH_IMPL) <= BYTE_WIDTH)) 
                                                    begin : genblk1
                                                        assign act_ben_w = ben_i[(((i1 + 1) * BYTE_WIDTH_IMPL) - 1):(i1 * BYTE_WIDTH_IMPL)] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign act_ben_w[(BYTE_WIDTH_IMPL - 1):(BYTE_WIDTH - (i1 * BYTE_WIDTH_IMPL))] = {(BYTE_WIDTH_IMPL - (BYTE_WIDTH - (i1 * BYTE_WIDTH_IMPL))){1'b1}} ; 
                                                        assign act_ben_w[(BYTE_WIDTH - (1 + (i1 * BYTE_WIDTH_IMPL))):0] = ben_i[(BYTE_WIDTH - 1):(i1 * BYTE_WIDTH_IMPL)] ; 
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                assign act_ben_w = ben_i[i1] ; 
                                            end
                                    end
                                else
                                    begin : genblk2
                                        assign act_ben_w = ben_i[(((i1 * OPT_DATA_WIDTH) * BYTE_WIDTH) / WDATA_WIDTH)] ; 
                                    end
                            wire f_wr_en_w = (chk_addr_w_w & wr_en_i) ; 
                            wire f_rd_en_w = (chk_addr_r_w & rd_en_i) ; 
                            wire ff_rd_en_w ; 
                            if ((REGMODE == "noreg")) 
                                begin : genblk3
                                    assign ff_rd_en_w = f_rd_en_w ; 
                                end
                            else
                                begin : genblk3
                                    reg f_rd_en_r ; 
                                    assign ff_rd_en_w = (f_rd_en_w | f_rd_en_r) ; 
                                    if ((RESETMODE == "sync")) 
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            f_rd_en_r <=  1'b0 ;
                                                        end
                                                    else
                                                        begin
                                                            f_rd_en_r <=  (f_rd_en_w & rd_clk_en_i) ;
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i or 
                                                    posedge rst_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            f_rd_en_r <=  1'b0 ;
                                                        end
                                                    else
                                                        begin
                                                            f_rd_en_r <=  (f_rd_en_w & rd_clk_en_i) ;
                                                        end
                                                end
                                        end
                                end
                            if ((INIT_MODE == "mem_file")) 
                                begin : mem_init
                                    new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                            .MEM_SIZE(MEM_SIZE),
                                            .POSx(ECO_POSX),
                                            .POSy(ECO_POSY),
                                            .FAMILY(FAMILY),
                                            ._FCODE_ICE_(_FCODE_ICE_),
                                            ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                            ._FCODE_AP6_(_FCODE_AP6_),
                                            ._FCODE_COMMON_(_FCODE_COMMON_),
                                            .DATA_WIDTH_W(OPT_DATA_WIDTH),
                                            .DATA_WIDTH_R(OPT_DATA_WIDTH),
                                            .REGMODE(REGMODE),
                                            .RESETMODE(RESETMODE),
                                            .RESET_RELEASE(RESET_RELEASE),
                                            .INIT_MODE(INIT_MODE),
                                            .BYTE_ENABLE(IS_BYTE_ENABLE),
                                            .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                            .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                            .INIT_VALUE_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                            .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                            .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                .rd_clk_i(rd_clk_i), 
                                                .rst_i(rst_i), 
                                                .wr_clk_en_i(wr_clk_en_i), 
                                                .rd_clk_en_i(rd_clk_en_i), 
                                                .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                .wr_en_i(f_wr_en_w), 
                                                .wr_data_i(act_in_w), 
                                                .wr_addr_i(act_addr_w_w), 
                                                .rd_en_i(ff_rd_en_w), 
                                                .rd_addr_i(act_addr_r_w), 
                                                .ben_i(act_ben_w), 
                                                .rd_data_o(act_out_w), 
                                                .one_err_det_o(one_err_det_ebr_w), 
                                                .two_err_det_o(two_err_det_ebr_w)) ; 
                                end
                            else
                                begin : no_init
                                    new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                            .MEM_SIZE(MEM_SIZE),
                                            .POSx(ECO_POSX),
                                            .POSy(ECO_POSY),
                                            .FAMILY(FAMILY),
                                            ._FCODE_ICE_(_FCODE_ICE_),
                                            ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                            ._FCODE_AP6_(_FCODE_AP6_),
                                            ._FCODE_COMMON_(_FCODE_COMMON_),
                                            .DATA_WIDTH_W(OPT_DATA_WIDTH),
                                            .DATA_WIDTH_R(OPT_DATA_WIDTH),
                                            .REGMODE(REGMODE),
                                            .RESETMODE(RESETMODE),
                                            .RESET_RELEASE(RESET_RELEASE),
                                            .INIT_MODE(INIT_MODE),
                                            .BYTE_ENABLE(IS_BYTE_ENABLE),
                                            .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                            .BYTE_ENABLE_POL(BYTE_ENABLE_POL)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                .rd_clk_i(rd_clk_i), 
                                                .rst_i(rst_i), 
                                                .wr_clk_en_i(wr_clk_en_i), 
                                                .rd_clk_en_i(rd_clk_en_i), 
                                                .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                .wr_en_i(f_wr_en_w), 
                                                .wr_data_i(act_in_w), 
                                                .wr_addr_i(act_addr_w_w), 
                                                .rd_en_i(ff_rd_en_w), 
                                                .rd_addr_i(act_addr_r_w), 
                                                .ben_i(act_ben_w), 
                                                .rd_data_o(act_out_w), 
                                                .one_err_det_o(one_err_det_ebr_w), 
                                                .two_err_det_o(two_err_det_ebr_w)) ; 
                                end
                        end
                    end
                    if ((EBR_ADDR == 1)) 
                        begin : genblk2
                            assign rd_data_o = rd_data_raw_w[0] ; 
                            assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_raw_w[0] : 1'b0) ; 
                            assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_raw_w[0] : 1'b0) ; 
                        end
                    else
                        begin : genblk2
                            reg [(RDATA_WIDTH - 1):0] rd_out_buff_r ; 
                            reg [(RADDR_WIDTH - 1):0] rd_addr_0_r = {RADDR_WIDTH{1'b0}} ; 
                            reg one_err_det_r ; 
                            reg two_err_det_r ; 
                            assign rd_data_o = rd_out_buff_r ; 
                            assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_r : 1'b0) ; 
                            assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_r : 1'b0) ; 
                            if ((REGMODE == "noreg")) 
                                begin : _nreg
                                    if ((RESETMODE == "sync")) 
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i or 
                                                    posedge rst_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                        end
                                                end
                                        end
                                end
                            else
                                begin : _reg
                                    reg [(RADDR_WIDTH - 1):0] rd_addr_1_r = {RADDR_WIDTH{1'b0}} ; 
                                    if ((RESETMODE == "sync")) 
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                            rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  rd_addr_1_r ;
                                                            rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            always
                                                @(posedge rd_clk_i or 
                                                    posedge rst_i)
                                                begin
                                                    if (rst_i) 
                                                        begin
                                                            rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                            rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                        end
                                                    else
                                                        begin
                                                            rd_addr_0_r <=  rd_addr_1_r ;
                                                            rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                        end
                                                end
                                        end
                                end
                            always
                                @(*)
                                begin
                                    rd_out_buff_r = rd_data_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH]] ;
                                    one_err_det_r = one_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH]] ;
                                    two_err_det_r = two_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):OPT_ADDR_WIDTH]] ;
                                end
                        end
                end
            else
                if ((IS_BYTE_ENABLE == 0)) 
                    begin : MIX_NO_BYTE_EN
                        localparam MAX_DATA = ((WDATA_WIDTH > RDATA_WIDTH) ? WDATA_WIDTH : RDATA_WIDTH) ; 
                        localparam MAX_PORT = ((WDATA_WIDTH > RDATA_WIDTH) ? "W" : "R") ; 
                        localparam MIN_DEPTH = ((MAX_PORT == "W") ? WADDR_DEPTH : RADDR_DEPTH) ; 
                        localparam Q_FACTOR = ((MAX_PORT == "W") ? (WDATA_WIDTH / RDATA_WIDTH) : (RDATA_WIDTH / WDATA_WIDTH)) ; 
                        localparam PROC_MAX_DATA = procData(MAX_DATA,
                                    ECC_ENABLE,
                                    FAMILY_CODE) ; 
                        localparam PROC_MIN_DEPTH = (2 ** clog2(MIN_DEPTH)) ; 
                        localparam PROC_MIN_DATA = (PROC_MAX_DATA / Q_FACTOR) ; 
                        localparam PROC_MAX_DEPTH = (PROC_MIN_DEPTH * Q_FACTOR) ; 
                        localparam W_PORT_USE = ((MAX_PORT == "W") ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                        localparam W_DEPTH_USE = ((MAX_PORT == "W") ? PROC_MIN_DEPTH : PROC_MAX_DEPTH) ; 
                        localparam W_DEPTH_WIDTH_USE = clog2(W_DEPTH_USE) ; 
                        localparam R_PORT_USE = ((MAX_PORT == "R") ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                        localparam R_DEPTH_USE = ((MAX_PORT == "R") ? PROC_MIN_DEPTH : PROC_MAX_DEPTH) ; 
                        localparam R_DEPTH_WIDTH_USE = clog2(R_DEPTH_USE) ; 
                        localparam W_DATA_WIDTH_IMPL = getCASE1DataImpl(W_DEPTH_USE,
                                    W_PORT_USE,
                                    R_DEPTH_USE,
                                    R_PORT_USE,
                                    1'b1,
                                    0,
                                    ECC_ENABLE,
                                    FAMILY_CODE) ; 
                        localparam W_ADDR_DEPTH_IMPL = data_to_addr(W_DATA_WIDTH_IMPL,
                                    FAMILY_CODE) ; 
                        localparam W_ADDR_WIDTH_IMPL = clog2(W_ADDR_DEPTH_IMPL) ; 
                        localparam R_DATA_WIDTH_IMPL = getCASE1DataImpl(W_DEPTH_USE,
                                    W_PORT_USE,
                                    R_DEPTH_USE,
                                    R_PORT_USE,
                                    1'b0,
                                    0,
                                    ECC_ENABLE,
                                    FAMILY_CODE) ; 
                        localparam R_ADDR_DEPTH_IMPL = data_to_addr(R_DATA_WIDTH_IMPL,
                                    FAMILY_CODE) ; 
                        localparam R_ADDR_WIDTH_IMPL = clog2(R_ADDR_DEPTH_IMPL) ; 
                        localparam EBR_ADDR = roundUP(W_DEPTH_USE,
                                    W_ADDR_DEPTH_IMPL) ; 
                        localparam EBR_DATA = roundUP(W_PORT_USE,
                                    W_DATA_WIDTH_IMPL) ; 
                        wire [(W_DEPTH_WIDTH_USE - 1):0] wr_addr_buff_w ; 
                        wire [(R_DEPTH_WIDTH_USE - 1):0] rd_addr_buff_w ; 
                        if ((W_DEPTH_WIDTH_USE > WADDR_WIDTH)) 
                            begin : genblk1
                                assign wr_addr_buff_w[(W_DEPTH_WIDTH_USE - 1):WADDR_WIDTH] = 'h0000 ; 
                            end
                        assign wr_addr_buff_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                        if ((R_DEPTH_WIDTH_USE > RADDR_WIDTH)) 
                            begin : genblk2
                                assign rd_addr_buff_w[(R_DEPTH_WIDTH_USE - 1):RADDR_WIDTH] = 'h0000 ; 
                            end
                        assign rd_addr_buff_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                        wire [(W_PORT_USE - 1):0] input_buff_w ; 
                        wire [(R_PORT_USE - 1):0] output_buff_w ; 
                        wire [(R_PORT_USE - 1):0] rd_data_raw_w [(EBR_ADDR - 1):0] ; 
                        wire [(W_PORT_USE - 1):0] master_data_in_w ; 
                        wire [(R_PORT_USE - 1):0] master_data_out_w ; 
                        if ((EBR_DATA > 1)) 
                            begin : genblk3
                                if ((W_PORT_USE > R_PORT_USE)) 
                                    begin : genblk1
                                        assign rd_data_o = output_buff_w[(RDATA_WIDTH - 1):0] ; 
                                        assign output_buff_w = master_data_out_w ; 
                                        wire [(R_PORT_USE - 1):0] inp_buff_seg_w [((W_PORT_USE / R_PORT_USE) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < (W_PORT_USE / R_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk1
                                            assign inp_buff_seg_w[i_0] = wr_data_i[((RDATA_WIDTH * (i_0 + 1)) - 1):(RDATA_WIDTH * i_0)] ; 
                                        end
                                        for (i_0 = 0;(i_0 < (W_PORT_USE / R_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk2
                                            assign input_buff_w[(((i_0 * R_PORT_USE) + R_PORT_USE) - 1):(i_0 * R_PORT_USE)] = inp_buff_seg_w[i_0] ; 
                                        end
                                        wire [(R_DATA_WIDTH_IMPL - 1):0] master_data_ind_w [((W_PORT_USE / R_DATA_WIDTH_IMPL) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                        begin : genblk3
                                            for (i_1 = 0;(i_1 < (W_PORT_USE / (EBR_DATA * R_DATA_WIDTH_IMPL)));i_1 = (i_1 + 1))
                                            begin : genblk1
                                                assign master_data_ind_w[(((W_PORT_USE / (EBR_DATA * R_DATA_WIDTH_IMPL)) * i_0) + i_1)] = input_buff_w[((((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL)) + R_DATA_WIDTH_IMPL) - 1):((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL))] ; 
                                            end
                                        end
                                        for (i_0 = 0;(i_0 < (W_PORT_USE / R_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                        begin : genblk4
                                            assign master_data_in_w[(((i_0 * R_DATA_WIDTH_IMPL) + R_DATA_WIDTH_IMPL) - 1):(i_0 * R_DATA_WIDTH_IMPL)] = master_data_ind_w[i_0] ; 
                                        end
                                    end
                                else
                                    begin : genblk1
                                        if ((W_PORT_USE > WDATA_WIDTH)) 
                                            begin : genblk1
                                                assign input_buff_w[(W_PORT_USE - 1):WDATA_WIDTH] = 'h0000 ; 
                                            end
                                        assign input_buff_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                        assign master_data_in_w = input_buff_w ; 
                                        wire [(W_PORT_USE - 1):0] out_buff_seg_w [((R_PORT_USE / W_PORT_USE) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk2
                                            assign rd_data_o[((WDATA_WIDTH * (i_0 + 1)) - 1):(WDATA_WIDTH * i_0)] = out_buff_seg_w[i_0] ; 
                                        end
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk3
                                            assign out_buff_seg_w[i_0] = output_buff_w[(((i_0 + 1) * W_PORT_USE) - 1):(i_0 * W_PORT_USE)] ; 
                                        end
                                        wire [(W_DATA_WIDTH_IMPL - 1):0] master_data_ind_out_w [((R_PORT_USE / W_DATA_WIDTH_IMPL) - 1):0] ; 
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_PORT_USE));i_0 = (i_0 + 1))
                                        begin : genblk4
                                            for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                            begin : genblk1
                                                assign master_data_ind_out_w[((i_0 * EBR_DATA) + i_1)] = master_data_out_w[((((i_1 * R_DATA_WIDTH_IMPL) + (i_0 * W_DATA_WIDTH_IMPL)) + W_DATA_WIDTH_IMPL) - 1):((i_1 * R_DATA_WIDTH_IMPL) + (i_0 * W_DATA_WIDTH_IMPL))] ; 
                                            end
                                        end
                                        for (i_0 = 0;(i_0 < (R_PORT_USE / W_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                        begin : genblk5
                                            assign output_buff_w[(((i_0 * W_DATA_WIDTH_IMPL) + W_DATA_WIDTH_IMPL) - 1):(i_0 * W_DATA_WIDTH_IMPL)] = master_data_ind_out_w[i_0] ; 
                                        end
                                    end
                            end
                        else
                            if ((EBR_ADDR > 1)) 
                                begin : genblk3
                                    localparam Q_SRD_x = (R_PORT_USE / W_PORT_USE) ; 
                                    localparam Q_SWR_x = (W_PORT_USE / R_PORT_USE) ; 
                                    if ((R_PORT_USE < W_PORT_USE)) 
                                        begin : genblk1
                                            for (i_0 = 0;(i_0 < Q_SWR_x);i_0 = (i_0 + 1))
                                            begin : genblk1
                                                assign master_data_in_w[(((i_0 * R_PORT_USE) + RDATA_WIDTH) - 1):(i_0 * R_PORT_USE)] = wr_data_i[(((i_0 * RDATA_WIDTH) + RDATA_WIDTH) - 1):(i_0 * RDATA_WIDTH)] ; 
                                                if ((R_PORT_USE != RDATA_WIDTH)) 
                                                    begin : genblk1
                                                        assign master_data_in_w[(((i_0 * R_PORT_USE) + R_PORT_USE) - 1):((i_0 * R_PORT_USE) + RDATA_WIDTH)] = {(R_PORT_USE - RDATA_WIDTH){1'b0}} ; 
                                                    end
                                            end
                                            assign rd_data_o = master_data_out_w[(RDATA_WIDTH - 1):0] ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign master_data_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                            for (i_0 = 0;(i_0 < Q_SRD_x);i_0 = (i_0 + 1))
                                            begin : genblk1
                                                assign rd_data_o[(((i_0 * WDATA_WIDTH) + WDATA_WIDTH) - 1):(i_0 * WDATA_WIDTH)] = master_data_out_w[(((i_0 * W_PORT_USE) + WDATA_WIDTH) - 1):(i_0 * W_PORT_USE)] ; 
                                            end
                                        end
                                end
                        if (((EBR_ADDR == 1) && (EBR_DATA == 1))) 
                            begin : SINGLE_IMPL
                                localparam W_SINGULAR_DATA_x = getSingularCase(W_PORT_USE,
                                            FAMILY_CODE) ; 
                                localparam R_SINGULAR_DATA_x = getSingularCase(R_PORT_USE,
                                            FAMILY_CODE) ; 
                                localparam W_SINGULAR_ADDR_WIDTH = clog2(data_to_addr(W_SINGULAR_DATA_x,
                                                FAMILY_CODE)) ; 
                                localparam R_SINGULAR_ADDR_WIDTH = clog2(data_to_addr(R_SINGULAR_DATA_x,
                                                FAMILY_CODE)) ; 
                                localparam Q_SRD_x = (R_SINGULAR_DATA_x / W_SINGULAR_DATA_x) ; 
                                localparam Q_SWR_x = (W_SINGULAR_DATA_x / R_SINGULAR_DATA_x) ; 
                                wire [(W_SINGULAR_DATA_x - 1):0] single_wire_in_w ; 
                                wire [(R_SINGULAR_DATA_x - 1):0] single_wire_out_w ; 
                                wire [(W_SINGULAR_ADDR_WIDTH - 1):0] single_wr_addr_w ; 
                                wire [(R_SINGULAR_ADDR_WIDTH - 1):0] single_rd_addr_w ; 
                                if ((R_SINGULAR_DATA_x < W_SINGULAR_DATA_x)) 
                                    begin : genblk1
                                        for (i0 = 0;(i0 < Q_SWR_x);i0 = (i0 + 1))
                                        begin : genblk1
                                            assign single_wire_in_w[(((i0 * R_SINGULAR_DATA_x) + RDATA_WIDTH) - 1):(i0 * R_SINGULAR_DATA_x)] = wr_data_i[(((i0 * RDATA_WIDTH) + RDATA_WIDTH) - 1):(i0 * RDATA_WIDTH)] ; 
                                            if ((R_SINGULAR_DATA_x != RDATA_WIDTH)) 
                                                begin : genblk1
                                                    assign single_wire_in_w[(((i0 * R_SINGULAR_DATA_x) + R_SINGULAR_DATA_x) - 1):((i0 * R_SINGULAR_DATA_x) + RDATA_WIDTH)] = {(R_SINGULAR_DATA_x - RDATA_WIDTH){1'b0}} ; 
                                                end
                                        end
                                        assign rd_data_o = single_wire_out_w[(RDATA_WIDTH - 1):0] ; 
                                    end
                                else
                                    begin : genblk1
                                        assign single_wire_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                        for (i0 = 0;(i0 < Q_SRD_x);i0 = (i0 + 1))
                                        begin : genblk1
                                            assign rd_data_o[(((i0 * WDATA_WIDTH) + WDATA_WIDTH) - 1):(i0 * WDATA_WIDTH)] = single_wire_out_w[(((i0 * W_SINGULAR_DATA_x) + WDATA_WIDTH) - 1):(i0 * W_SINGULAR_DATA_x)] ; 
                                        end
                                    end
                                if ((W_SINGULAR_ADDR_WIDTH > WADDR_WIDTH)) 
                                    begin : genblk2
                                        assign single_wr_addr_w[(W_SINGULAR_ADDR_WIDTH - 1):WADDR_WIDTH] = 'h0000 ; 
                                    end
                                assign single_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                if ((R_SINGULAR_ADDR_WIDTH > RADDR_WIDTH)) 
                                    begin : genblk3
                                        assign single_rd_addr_w[(R_SINGULAR_ADDR_WIDTH - 1):RADDR_WIDTH] = 'h0000 ; 
                                    end
                                assign single_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                wire ff_rd_en_w ; 
                                if ((REGMODE == "noreg")) 
                                    begin : genblk4
                                        assign ff_rd_en_w = rd_en_i ; 
                                    end
                                else
                                    begin : genblk4
                                        reg f_rd_en_r ; 
                                        assign ff_rd_en_w = (rd_en_i | f_rd_en_r) ; 
                                        if ((RESETMODE == "sync")) 
                                            begin : genblk1
                                                always
                                                    @(posedge rd_clk_i)
                                                    begin
                                                        if (rst_i) 
                                                            begin
                                                                f_rd_en_r <=  1'b0 ;
                                                            end
                                                        else
                                                            begin
                                                                f_rd_en_r <=  (rd_en_i & rd_clk_en_i) ;
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                always
                                                    @(posedge rd_clk_i or 
                                                        posedge rst_i)
                                                    begin
                                                        if (rst_i) 
                                                            begin
                                                                f_rd_en_r <=  1'b0 ;
                                                            end
                                                        else
                                                            begin
                                                                f_rd_en_r <=  (rd_en_i & rd_clk_en_i) ;
                                                            end
                                                    end
                                            end
                                    end
                                if ((INIT_MODE == "mem_file")) 
                                    begin : mem_init
                                        new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                .MEM_SIZE(MEM_SIZE),
                                                .FAMILY(FAMILY),
                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                .REGMODE(REGMODE),
                                                .RESETMODE(RESETMODE),
                                                .RESET_RELEASE(RESET_RELEASE),
                                                .BYTE_ENABLE(0),
                                                .INIT_MODE(INIT_MODE),
                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                .INIT_VALUE_00(INIT_VALUE_00),
                                                .INIT_VALUE_01(INIT_VALUE_01),
                                                .INIT_VALUE_02(INIT_VALUE_02),
                                                .INIT_VALUE_03(INIT_VALUE_03),
                                                .INIT_VALUE_04(INIT_VALUE_04),
                                                .INIT_VALUE_05(INIT_VALUE_05),
                                                .INIT_VALUE_06(INIT_VALUE_06),
                                                .INIT_VALUE_07(INIT_VALUE_07),
                                                .INIT_VALUE_08(INIT_VALUE_08),
                                                .INIT_VALUE_09(INIT_VALUE_09),
                                                .INIT_VALUE_0A(INIT_VALUE_0A),
                                                .INIT_VALUE_0B(INIT_VALUE_0B),
                                                .INIT_VALUE_0C(INIT_VALUE_0C),
                                                .INIT_VALUE_0D(INIT_VALUE_0D),
                                                .INIT_VALUE_0E(INIT_VALUE_0E),
                                                .INIT_VALUE_0F(INIT_VALUE_0F),
                                                .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10 : "0x00")),
                                                .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11 : "0x00")),
                                                .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12 : "0x00")),
                                                .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13 : "0x00")),
                                                .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14 : "0x00")),
                                                .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15 : "0x00")),
                                                .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16 : "0x00")),
                                                .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17 : "0x00")),
                                                .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18 : "0x00")),
                                                .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19 : "0x00")),
                                                .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A : "0x00")),
                                                .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B : "0x00")),
                                                .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C : "0x00")),
                                                .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D : "0x00")),
                                                .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E : "0x00")),
                                                .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F : "0x00")),
                                                .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20 : "0x00")),
                                                .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21 : "0x00")),
                                                .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22 : "0x00")),
                                                .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23 : "0x00")),
                                                .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24 : "0x00")),
                                                .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25 : "0x00")),
                                                .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26 : "0x00")),
                                                .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27 : "0x00")),
                                                .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28 : "0x00")),
                                                .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29 : "0x00")),
                                                .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A : "0x00")),
                                                .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B : "0x00")),
                                                .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C : "0x00")),
                                                .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D : "0x00")),
                                                .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E : "0x00")),
                                                .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F : "0x00")),
                                                .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30 : "0x00")),
                                                .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31 : "0x00")),
                                                .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32 : "0x00")),
                                                .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33 : "0x00")),
                                                .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34 : "0x00")),
                                                .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35 : "0x00")),
                                                .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36 : "0x00")),
                                                .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37 : "0x00")),
                                                .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38 : "0x00")),
                                                .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39 : "0x00")),
                                                .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A : "0x00")),
                                                .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B : "0x00")),
                                                .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C : "0x00")),
                                                .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D : "0x00")),
                                                .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E : "0x00")),
                                                .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F : "0x00")),
                                                .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40 : "0x00")),
                                                .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41 : "0x00")),
                                                .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42 : "0x00")),
                                                .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43 : "0x00")),
                                                .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44 : "0x00")),
                                                .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45 : "0x00")),
                                                .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46 : "0x00")),
                                                .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47 : "0x00")),
                                                .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48 : "0x00")),
                                                .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49 : "0x00")),
                                                .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A : "0x00")),
                                                .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B : "0x00")),
                                                .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C : "0x00")),
                                                .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D : "0x00")),
                                                .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E : "0x00")),
                                                .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F : "0x00")),
                                                .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50 : "0x00")),
                                                .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51 : "0x00")),
                                                .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52 : "0x00")),
                                                .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53 : "0x00")),
                                                .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54 : "0x00")),
                                                .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55 : "0x00")),
                                                .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56 : "0x00")),
                                                .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57 : "0x00")),
                                                .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58 : "0x00")),
                                                .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59 : "0x00")),
                                                .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A : "0x00")),
                                                .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B : "0x00")),
                                                .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C : "0x00")),
                                                .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D : "0x00")),
                                                .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E : "0x00")),
                                                .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F : "0x00")),
                                                .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60 : "0x00")),
                                                .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61 : "0x00")),
                                                .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62 : "0x00")),
                                                .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63 : "0x00")),
                                                .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64 : "0x00")),
                                                .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65 : "0x00")),
                                                .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66 : "0x00")),
                                                .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67 : "0x00")),
                                                .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68 : "0x00")),
                                                .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69 : "0x00")),
                                                .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A : "0x00")),
                                                .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B : "0x00")),
                                                .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C : "0x00")),
                                                .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D : "0x00")),
                                                .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E : "0x00")),
                                                .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F : "0x00")),
                                                .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70 : "0x00")),
                                                .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71 : "0x00")),
                                                .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72 : "0x00")),
                                                .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73 : "0x00")),
                                                .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74 : "0x00")),
                                                .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75 : "0x00")),
                                                .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76 : "0x00")),
                                                .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77 : "0x00")),
                                                .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78 : "0x00")),
                                                .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79 : "0x00")),
                                                .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A : "0x00")),
                                                .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B : "0x00")),
                                                .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C : "0x00")),
                                                .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D : "0x00")),
                                                .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E : "0x00")),
                                                .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                    .rd_clk_i(rd_clk_i), 
                                                    .rst_i(rst_i), 
                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                    .wr_en_i(wr_en_i), 
                                                    .wr_data_i(single_wire_in_w), 
                                                    .wr_addr_i(single_wr_addr_w), 
                                                    .rd_en_i(ff_rd_en_w), 
                                                    .rd_addr_i(single_rd_addr_w), 
                                                    .ben_i(1'b1), 
                                                    .rd_data_o(single_wire_out_w), 
                                                    .one_err_det_o(one_err_det_o), 
                                                    .two_err_det_o(two_err_det_o)) ; 
                                    end
                                else
                                    begin : no_init
                                        new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                .MEM_SIZE(MEM_SIZE),
                                                .FAMILY(FAMILY),
                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                .REGMODE(REGMODE),
                                                .RESETMODE(RESETMODE),
                                                .RESET_RELEASE(RESET_RELEASE),
                                                .BYTE_ENABLE(0),
                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                .INIT_MODE(INIT_MODE)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                    .rd_clk_i(rd_clk_i), 
                                                    .rst_i(rst_i), 
                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                    .wr_en_i(wr_en_i), 
                                                    .wr_data_i(single_wire_in_w), 
                                                    .wr_addr_i(single_wr_addr_w), 
                                                    .rd_en_i(ff_rd_en_w), 
                                                    .rd_addr_i(single_rd_addr_w), 
                                                    .ben_i(1'b1), 
                                                    .rd_data_o(single_wire_out_w), 
                                                    .one_err_det_o(one_err_det_o), 
                                                    .two_err_det_o(two_err_det_o)) ; 
                                    end
                            end
                        else
                            begin : MULT_IMPL
                                wire [(EBR_ADDR - 1):0] one_err_det_raw_w ; 
                                wire [(EBR_ADDR - 1):0] two_err_det_raw_w ; 
                                for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                                begin : ADDR_x
                                    wire [(R_PORT_USE - 1):0] raw_output_w ; 
                                    assign rd_data_raw_w[i0] = raw_output_w ; 
                                    wire chk_addr_wr_w ; 
                                    if ((EBR_ADDR > 1)) 
                                        begin : genblk1
                                            assign chk_addr_wr_w = (wr_addr_i[(WADDR_WIDTH - 1):W_ADDR_WIDTH_IMPL] == i0) ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign chk_addr_wr_w = 1'b1 ; 
                                        end
                                    wire [(W_ADDR_WIDTH_IMPL - 1):0] act_wr_addr_w ; 
                                    if ((W_ADDR_WIDTH_IMPL > WADDR_WIDTH)) 
                                        begin : genblk2
                                            assign act_wr_addr_w[(W_ADDR_WIDTH_IMPL - 1):WADDR_WIDTH] = 'h0000 ; 
                                            assign act_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                        end
                                    else
                                        begin : genblk2
                                            assign act_wr_addr_w = wr_addr_i[(W_ADDR_WIDTH_IMPL - 1):0] ; 
                                        end
                                    wire chk_addr_rd_w ; 
                                    if ((EBR_ADDR > 1)) 
                                        begin : genblk3
                                            assign chk_addr_rd_w = (rd_addr_i[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL] == i0) ; 
                                        end
                                    else
                                        begin : genblk3
                                            assign chk_addr_rd_w = 1'b1 ; 
                                        end
                                    wire [(R_ADDR_WIDTH_IMPL - 1):0] act_rd_addr_w ; 
                                    if ((R_ADDR_WIDTH_IMPL > RADDR_WIDTH)) 
                                        begin : genblk4
                                            assign act_rd_addr_w[(R_ADDR_WIDTH_IMPL - 1):RADDR_WIDTH] = 'h0000 ; 
                                            assign act_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                        end
                                    else
                                        begin : genblk4
                                            assign act_rd_addr_w = rd_addr_i[(R_ADDR_WIDTH_IMPL - 1):0] ; 
                                        end
                                    wire [(EBR_DATA - 1):0] one_err_det_ind_w ; 
                                    wire [(EBR_DATA - 1):0] two_err_det_ind_w ; 
                                    if ((EBR_DATA == 1)) 
                                        begin : genblk5
                                            assign one_err_det_raw_w[i0] = one_err_det_ind_w[0] ; 
                                            assign two_err_det_raw_w[i0] = two_err_det_ind_w[0] ; 
                                        end
                                    else
                                        begin : genblk5
                                            assign one_err_det_raw_w[i0] = (|one_err_det_ind_w) ; 
                                            assign two_err_det_raw_w[i0] = (|two_err_det_ind_w) ; 
                                        end
                                    for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                                    begin : DATA_x
                                        localparam ECO_POSX = (i1 * W_DATA_WIDTH_IMPL) ; 
                                        localparam ECO_POSY = (i0 * W_ADDR_DEPTH_IMPL) ; 
                                        wire [(W_DATA_WIDTH_IMPL - 1):0] act_wr_data_w ; 
                                        wire [(R_DATA_WIDTH_IMPL - 1):0] act_rd_data_w ; 
                                        wire one_err_det_ebr_w ; 
                                        wire two_err_det_ebr_w ; 
                                        assign one_err_det_ind_w[i1] = one_err_det_ebr_w ; 
                                        assign two_err_det_ind_w[i1] = two_err_det_ebr_w ; 
                                        if (((W_DATA_WIDTH_IMPL * (i1 + 1)) <= W_PORT_USE)) 
                                            begin : genblk1
                                                assign act_wr_data_w = master_data_in_w[((W_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                            end
                                        else
                                            begin : genblk1
                                                assign act_wr_data_w[(W_DATA_WIDTH_IMPL - 1):(W_PORT_USE - (i1 * W_DATA_WIDTH_IMPL))] = 'h0000 ; 
                                                assign act_wr_data_w[(W_PORT_USE - (1 + (W_DATA_WIDTH_IMPL * i1))):0] = master_data_in_w[(W_PORT_USE - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                            end
                                        if (((R_DATA_WIDTH_IMPL * (i1 + 1)) <= R_PORT_USE)) 
                                            begin : genblk2
                                                assign raw_output_w[((R_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w ; 
                                            end
                                        else
                                            begin : genblk2
                                                assign raw_output_w[(R_PORT_USE - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w[(R_PORT_USE - (1 + (R_DATA_WIDTH_IMPL * i1))):0] ; 
                                            end
                                        wire f_wr_en_w = (chk_addr_wr_w & wr_en_i) ; 
                                        wire f_rd_en_w = (chk_addr_rd_w & rd_en_i) ; 
                                        wire ff_rd_en_w ; 
                                        if ((REGMODE == "noreg")) 
                                            begin : genblk3
                                                assign ff_rd_en_w = f_rd_en_w ; 
                                            end
                                        else
                                            begin : genblk3
                                                reg f_rd_en_r ; 
                                                assign ff_rd_en_w = (f_rd_en_w | f_rd_en_r) ; 
                                                if ((RESETMODE == "sync")) 
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        f_rd_en_r <=  1'b0 ;
                                                                    end
                                                                else
                                                                    begin
                                                                        f_rd_en_r <=  (f_rd_en_w & rd_clk_en_i) ;
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i or 
                                                                posedge rst_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        f_rd_en_r <=  1'b0 ;
                                                                    end
                                                                else
                                                                    begin
                                                                        f_rd_en_r <=  (f_rd_en_w & rd_clk_en_i) ;
                                                                    end
                                                            end
                                                    end
                                            end
                                        if ((INIT_MODE == "mem_file")) 
                                            begin : mem_init
                                                new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .POSx(ECO_POSX),
                                                        .POSy(ECO_POSY),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                        .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(0),
                                                        .INIT_MODE(INIT_MODE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                        .INIT_VALUE_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                        .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                        .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(f_wr_en_w), 
                                                            .wr_data_i(act_wr_data_w), 
                                                            .wr_addr_i(act_wr_addr_w), 
                                                            .rd_en_i(ff_rd_en_w), 
                                                            .rd_addr_i(act_rd_addr_w), 
                                                            .ben_i(1'b1), 
                                                            .rd_data_o(act_rd_data_w), 
                                                            .one_err_det_o(one_err_det_ebr_w), 
                                                            .two_err_det_o(two_err_det_ebr_w)) ; 
                                            end
                                        else
                                            begin : no_init
                                                new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .POSx(ECO_POSX),
                                                        .POSy(ECO_POSY),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                        .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                        .INIT_MODE(INIT_MODE),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(0),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(f_wr_en_w), 
                                                            .wr_data_i(act_wr_data_w), 
                                                            .wr_addr_i(act_wr_addr_w), 
                                                            .rd_en_i(ff_rd_en_w), 
                                                            .rd_addr_i(act_rd_addr_w), 
                                                            .ben_i(1'b1), 
                                                            .rd_data_o(act_rd_data_w), 
                                                            .one_err_det_o(one_err_det_ebr_w), 
                                                            .two_err_det_o(two_err_det_ebr_w)) ; 
                                            end
                                    end
                                end
                                if ((EBR_ADDR == 1)) 
                                    begin : genblk2
                                        assign master_data_out_w = rd_data_raw_w[0] ; 
                                        assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_raw_w[0] : 1'b0) ; 
                                        assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_raw_w[0] : 1'b0) ; 
                                    end
                                else
                                    begin : genblk2
                                        reg [(R_PORT_USE - 1):0] rd_out_buff_r ; 
                                        reg [(RADDR_WIDTH - 1):0] rd_addr_0_r ; 
                                        reg one_err_det_r ; 
                                        reg two_err_det_r ; 
                                        assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_r : 1'b0) ; 
                                        assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_r : 1'b0) ; 
                                        if ((REGMODE == "noreg")) 
                                            begin : _nreg
                                                if ((RESETMODE == "sync")) 
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i or 
                                                                posedge rst_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                    end
                                                            end
                                                    end
                                            end
                                        else
                                            begin : _reg
                                                reg [(RADDR_WIDTH - 1):0] rd_addr_1_r = {RADDR_WIDTH{1'b0}} ; 
                                                if ((RESETMODE == "sync")) 
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                        rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  rd_addr_1_r ;
                                                                        rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i or 
                                                                posedge rst_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                        rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        rd_addr_0_r <=  rd_addr_1_r ;
                                                                        rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                    end
                                                            end
                                                    end
                                            end
                                        always
                                            @(*)
                                            begin
                                                rd_out_buff_r = rd_data_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                one_err_det_r = one_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                two_err_det_r = two_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                            end
                                        assign master_data_out_w = rd_out_buff_r ; 
                                    end
                            end
                    end
                else
                    begin : MIX_W_BYTE_EN
                        localparam MAX_DATA = ((RDATA_WIDTH > WDATA_WIDTH) ? RDATA_WIDTH : WDATA_WIDTH) ; 
                        localparam MIN_DATA = ((RDATA_WIDTH > WDATA_WIDTH) ? WDATA_WIDTH : RDATA_WIDTH) ; 
                        if ((is_byte_enable_good(MAX_DATA,
                                MIN_DATA,
                                FAMILY_CODE) == 1)) 
                            begin : BYTE_PASS
                                localparam W_DATA_WIDTH_IMPL = getCASE1DataImpl_wBen(WADDR_DEPTH,
                                            WDATA_WIDTH,
                                            RADDR_DEPTH,
                                            RDATA_WIDTH,
                                            1,
                                            FAMILY_CODE) ; 
                                localparam W_ADDR_DEPTH_IMPL = data_to_addr(W_DATA_WIDTH_IMPL,
                                            FAMILY_CODE) ; 
                                localparam W_ADDR_WIDTH_IMPL = clog2(W_ADDR_DEPTH_IMPL) ; 
                                localparam R_DATA_WIDTH_IMPL = getCASE1DataImpl_wBen(WADDR_DEPTH,
                                            WDATA_WIDTH,
                                            RADDR_DEPTH,
                                            RDATA_WIDTH,
                                            0,
                                            FAMILY_CODE) ; 
                                localparam R_ADDR_DEPTH_IMPL = data_to_addr(R_DATA_WIDTH_IMPL,
                                            FAMILY_CODE) ; 
                                localparam R_ADDR_WIDTH_IMPL = clog2(R_ADDR_DEPTH_IMPL) ; 
                                localparam EBR_ADDR = roundUP(WADDR_DEPTH,
                                            W_ADDR_DEPTH_IMPL) ; 
                                localparam EBR_DATA = roundUP(WDATA_WIDTH,
                                            W_DATA_WIDTH_IMPL) ; 
                                localparam TRUE_BYTE_WIDTH = getTrueByteWidth(W_DATA_WIDTH_IMPL,
                                            FAMILY_CODE) ; 
                                wire [(RDATA_WIDTH - 1):0] rd_data_raw_w [(EBR_ADDR - 1):0] ; 
                                wire [(BYTE_WIDTH - 1):0] byte_en_buffer_w ; 
                                wire [(WDATA_WIDTH - 1):0] master_data_in_w ; 
                                wire [(RDATA_WIDTH - 1):0] master_data_out_w ; 
                                if ((EBR_DATA > 1)) 
                                    begin : WIRE_chk
                                        if ((WDATA_WIDTH > RDATA_WIDTH)) 
                                            begin : W_OVR_R
                                                assign rd_data_o = master_data_out_w ; 
                                                wire [(R_DATA_WIDTH_IMPL - 1):0] master_data_ind_w [((WDATA_WIDTH / R_DATA_WIDTH_IMPL) - 1):0] ; 
                                                for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                                begin : genblk1
                                                    for (i_1 = 0;(i_1 < (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL)));i_1 = (i_1 + 1))
                                                    begin : genblk1
                                                        assign master_data_ind_w[(((WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL)) * i_0) + i_1)] = wr_data_i[((((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL)) + R_DATA_WIDTH_IMPL) - 1):((i_0 * R_DATA_WIDTH_IMPL) + ((i_1 * EBR_DATA) * R_DATA_WIDTH_IMPL))] ; 
                                                    end
                                                end
                                                localparam BYTE_EN_BUFF = (TRUE_BYTE_WIDTH / (WDATA_WIDTH / RDATA_WIDTH)) ; 
                                                for (i_0 = 0;(i_0 < (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL)));i_0 = (i_0 + 1))
                                                begin : genblk2
                                                    for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                                    begin : genblk1
                                                        assign byte_en_buffer_w[(((((i_1 * (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL))) + i_0) * BYTE_EN_BUFF) + BYTE_EN_BUFF) - 1):(((i_1 * (WDATA_WIDTH / (EBR_DATA * R_DATA_WIDTH_IMPL))) + i_0) * BYTE_EN_BUFF)] = ben_i[(((((i_0 * EBR_DATA) + i_1) * BYTE_EN_BUFF) + BYTE_EN_BUFF) - 1):(((i_0 * EBR_DATA) + i_1) * BYTE_EN_BUFF)] ; 
                                                    end
                                                end
                                                for (i_0 = 0;(i_0 < (WDATA_WIDTH / R_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                                begin : genblk3
                                                    assign master_data_in_w[(((i_0 * R_DATA_WIDTH_IMPL) + R_DATA_WIDTH_IMPL) - 1):(i_0 * R_DATA_WIDTH_IMPL)] = master_data_ind_w[i_0] ; 
                                                end
                                            end
                                        else
                                            begin : R_OVR_W
                                                assign master_data_in_w = wr_data_i ; 
                                                assign byte_en_buffer_w = ben_i ; 
                                                wire [(W_DATA_WIDTH_IMPL - 1):0] master_data_ind_out [((RDATA_WIDTH / W_DATA_WIDTH_IMPL) - 1):0] ; 
                                                for (i_0 = 0;(i_0 < (RDATA_WIDTH / WDATA_WIDTH));i_0 = (i_0 + 1))
                                                begin : genblk1
                                                    for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                                    begin : genblk1
                                                        assign master_data_ind_out[(i_1 + (i_0 * EBR_DATA))] = master_data_out_w[((((i_0 * W_DATA_WIDTH_IMPL) + (i_1 * R_DATA_WIDTH_IMPL)) + W_DATA_WIDTH_IMPL) - 1):((i_0 * W_DATA_WIDTH_IMPL) + (i_1 * R_DATA_WIDTH_IMPL))] ; 
                                                    end
                                                end
                                                for (i_0 = 0;(i_0 < (RDATA_WIDTH / W_DATA_WIDTH_IMPL));i_0 = (i_0 + 1))
                                                begin : genblk2
                                                    assign rd_data_o[(((i_0 + 1) * W_DATA_WIDTH_IMPL) - 1):(i_0 * W_DATA_WIDTH_IMPL)] = master_data_ind_out[i_0] ; 
                                                end
                                            end
                                    end
                                else
                                    if ((EBR_ADDR > 1)) 
                                        begin : genblk1
                                            assign master_data_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                            assign byte_en_buffer_w[(TRUE_BYTE_WIDTH - 1):0] = ben_i ; 
                                            assign rd_data_o = master_data_out_w[(RDATA_WIDTH - 1):0] ; 
                                        end
                                if (((EBR_ADDR == 1) && (EBR_DATA == 1))) 
                                    begin : SINGLE_IMPL
                                        localparam W_SINGULAR_DATA_x = WDATA_WIDTH ; 
                                        localparam W_SINGULAR_ADDR_x = clog2(data_to_addr(W_SINGULAR_DATA_x,
                                                        FAMILY_CODE)) ; 
                                        localparam R_SINGULAR_DATA_x = RDATA_WIDTH ; 
                                        localparam R_SINGULAR_ADDR_x = clog2(data_to_addr(R_SINGULAR_DATA_x,
                                                        FAMILY_CODE)) ; 
                                        wire [(W_SINGULAR_DATA_x - 1):0] single_true_wr_in_w ; 
                                        wire [(R_SINGULAR_DATA_x - 1):0] single_true_rd_out_w ; 
                                        wire [(W_SINGULAR_ADDR_x - 1):0] single_true_wr_addr_w ; 
                                        wire [(R_SINGULAR_ADDR_x - 1):0] single_true_rd_addr_w ; 
                                        assign single_true_wr_in_w[(WDATA_WIDTH - 1):0] = wr_data_i ; 
                                        if ((W_SINGULAR_ADDR_x > WADDR_WIDTH)) 
                                            begin : genblk1
                                                assign single_true_wr_addr_w[(W_SINGULAR_ADDR_x - 1):WADDR_WIDTH] = 'h0000 ; 
                                            end
                                        assign single_true_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                        assign rd_data_o = single_true_rd_out_w ; 
                                        if ((R_SINGULAR_ADDR_x > RADDR_WIDTH)) 
                                            begin : genblk2
                                                assign single_true_rd_addr_w[(R_SINGULAR_ADDR_x - 1):RADDR_WIDTH] = 'h0000 ; 
                                            end
                                        assign single_true_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                        wire ff_rd_en_w ; 
                                        if ((REGMODE == "noreg")) 
                                            begin : genblk3
                                                assign ff_rd_en_w = rd_en_i ; 
                                            end
                                        else
                                            begin : genblk3
                                                reg f_rd_en_r ; 
                                                assign ff_rd_en_w = (rd_en_i | f_rd_en_r) ; 
                                                if ((RESETMODE == "sync")) 
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        f_rd_en_r <=  1'b0 ;
                                                                    end
                                                                else
                                                                    begin
                                                                        f_rd_en_r <=  (rd_clk_en_i & rd_en_i) ;
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : genblk1
                                                        always
                                                            @(posedge rd_clk_i or 
                                                                posedge rst_i)
                                                            begin
                                                                if (rst_i) 
                                                                    begin
                                                                        f_rd_en_r <=  1'b0 ;
                                                                    end
                                                                else
                                                                    begin
                                                                        f_rd_en_r <=  (rd_clk_en_i & rd_en_i) ;
                                                                    end
                                                            end
                                                    end
                                            end
                                        if ((INIT_MODE == "mem_file")) 
                                            begin : mem_init
                                                new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                        .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(1),
                                                        .INIT_MODE(INIT_MODE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                        .INIT_VALUE_00(INIT_VALUE_00),
                                                        .INIT_VALUE_01(INIT_VALUE_01),
                                                        .INIT_VALUE_02(INIT_VALUE_02),
                                                        .INIT_VALUE_03(INIT_VALUE_03),
                                                        .INIT_VALUE_04(INIT_VALUE_04),
                                                        .INIT_VALUE_05(INIT_VALUE_05),
                                                        .INIT_VALUE_06(INIT_VALUE_06),
                                                        .INIT_VALUE_07(INIT_VALUE_07),
                                                        .INIT_VALUE_08(INIT_VALUE_08),
                                                        .INIT_VALUE_09(INIT_VALUE_09),
                                                        .INIT_VALUE_0A(INIT_VALUE_0A),
                                                        .INIT_VALUE_0B(INIT_VALUE_0B),
                                                        .INIT_VALUE_0C(INIT_VALUE_0C),
                                                        .INIT_VALUE_0D(INIT_VALUE_0D),
                                                        .INIT_VALUE_0E(INIT_VALUE_0E),
                                                        .INIT_VALUE_0F(INIT_VALUE_0F),
                                                        .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10 : "0x00")),
                                                        .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11 : "0x00")),
                                                        .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12 : "0x00")),
                                                        .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13 : "0x00")),
                                                        .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14 : "0x00")),
                                                        .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15 : "0x00")),
                                                        .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16 : "0x00")),
                                                        .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17 : "0x00")),
                                                        .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18 : "0x00")),
                                                        .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19 : "0x00")),
                                                        .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A : "0x00")),
                                                        .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B : "0x00")),
                                                        .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C : "0x00")),
                                                        .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D : "0x00")),
                                                        .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E : "0x00")),
                                                        .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F : "0x00")),
                                                        .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20 : "0x00")),
                                                        .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21 : "0x00")),
                                                        .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22 : "0x00")),
                                                        .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23 : "0x00")),
                                                        .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24 : "0x00")),
                                                        .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25 : "0x00")),
                                                        .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26 : "0x00")),
                                                        .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27 : "0x00")),
                                                        .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28 : "0x00")),
                                                        .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29 : "0x00")),
                                                        .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A : "0x00")),
                                                        .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B : "0x00")),
                                                        .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C : "0x00")),
                                                        .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D : "0x00")),
                                                        .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E : "0x00")),
                                                        .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F : "0x00")),
                                                        .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30 : "0x00")),
                                                        .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31 : "0x00")),
                                                        .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32 : "0x00")),
                                                        .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33 : "0x00")),
                                                        .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34 : "0x00")),
                                                        .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35 : "0x00")),
                                                        .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36 : "0x00")),
                                                        .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37 : "0x00")),
                                                        .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38 : "0x00")),
                                                        .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39 : "0x00")),
                                                        .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A : "0x00")),
                                                        .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B : "0x00")),
                                                        .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C : "0x00")),
                                                        .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D : "0x00")),
                                                        .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E : "0x00")),
                                                        .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F : "0x00")),
                                                        .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40 : "0x00")),
                                                        .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41 : "0x00")),
                                                        .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42 : "0x00")),
                                                        .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43 : "0x00")),
                                                        .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44 : "0x00")),
                                                        .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45 : "0x00")),
                                                        .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46 : "0x00")),
                                                        .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47 : "0x00")),
                                                        .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48 : "0x00")),
                                                        .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49 : "0x00")),
                                                        .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A : "0x00")),
                                                        .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B : "0x00")),
                                                        .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C : "0x00")),
                                                        .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D : "0x00")),
                                                        .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E : "0x00")),
                                                        .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F : "0x00")),
                                                        .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50 : "0x00")),
                                                        .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51 : "0x00")),
                                                        .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52 : "0x00")),
                                                        .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53 : "0x00")),
                                                        .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54 : "0x00")),
                                                        .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55 : "0x00")),
                                                        .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56 : "0x00")),
                                                        .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57 : "0x00")),
                                                        .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58 : "0x00")),
                                                        .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59 : "0x00")),
                                                        .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A : "0x00")),
                                                        .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B : "0x00")),
                                                        .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C : "0x00")),
                                                        .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D : "0x00")),
                                                        .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E : "0x00")),
                                                        .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F : "0x00")),
                                                        .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60 : "0x00")),
                                                        .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61 : "0x00")),
                                                        .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62 : "0x00")),
                                                        .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63 : "0x00")),
                                                        .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64 : "0x00")),
                                                        .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65 : "0x00")),
                                                        .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66 : "0x00")),
                                                        .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67 : "0x00")),
                                                        .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68 : "0x00")),
                                                        .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69 : "0x00")),
                                                        .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A : "0x00")),
                                                        .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B : "0x00")),
                                                        .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C : "0x00")),
                                                        .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D : "0x00")),
                                                        .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E : "0x00")),
                                                        .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F : "0x00")),
                                                        .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70 : "0x00")),
                                                        .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71 : "0x00")),
                                                        .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72 : "0x00")),
                                                        .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73 : "0x00")),
                                                        .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74 : "0x00")),
                                                        .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75 : "0x00")),
                                                        .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76 : "0x00")),
                                                        .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77 : "0x00")),
                                                        .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78 : "0x00")),
                                                        .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79 : "0x00")),
                                                        .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A : "0x00")),
                                                        .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B : "0x00")),
                                                        .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C : "0x00")),
                                                        .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D : "0x00")),
                                                        .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E : "0x00")),
                                                        .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(wr_en_i), 
                                                            .wr_data_i(single_true_wr_in_w), 
                                                            .wr_addr_i(single_true_wr_addr_w), 
                                                            .rd_en_i(ff_rd_en_w), 
                                                            .rd_addr_i(single_true_rd_addr_w), 
                                                            .ben_i(ben_i), 
                                                            .rd_data_o(single_true_rd_out_w), 
                                                            .one_err_det_o(one_err_det_o), 
                                                            .two_err_det_o(two_err_det_o)) ; 
                                            end
                                        else
                                            begin : no_init
                                                new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                        .MEM_SIZE(MEM_SIZE),
                                                        .FAMILY(FAMILY),
                                                        ._FCODE_ICE_(_FCODE_ICE_),
                                                        ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                        ._FCODE_AP6_(_FCODE_AP6_),
                                                        ._FCODE_COMMON_(_FCODE_COMMON_),
                                                        .DATA_WIDTH_W(W_SINGULAR_DATA_x),
                                                        .DATA_WIDTH_R(R_SINGULAR_DATA_x),
                                                        .REGMODE(REGMODE),
                                                        .RESETMODE(RESETMODE),
                                                        .RESET_RELEASE(RESET_RELEASE),
                                                        .BYTE_ENABLE(1),
                                                        .INIT_MODE(INIT_MODE),
                                                        .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                        .BYTE_ENABLE_POL(BYTE_ENABLE_POL)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                            .rd_clk_i(rd_clk_i), 
                                                            .rst_i(rst_i), 
                                                            .wr_clk_en_i(wr_clk_en_i), 
                                                            .rd_clk_en_i(rd_clk_en_i), 
                                                            .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                            .wr_en_i(wr_en_i), 
                                                            .wr_data_i(single_true_wr_in_w), 
                                                            .wr_addr_i(single_true_wr_addr_w), 
                                                            .rd_en_i(ff_rd_en_w), 
                                                            .rd_addr_i(single_true_rd_addr_w), 
                                                            .ben_i(ben_i), 
                                                            .rd_data_o(single_true_rd_out_w), 
                                                            .one_err_det_o(one_err_det_o), 
                                                            .two_err_det_o(two_err_det_o)) ; 
                                            end
                                    end
                                else
                                    begin : MULT_IMPL
                                        wire [(EBR_ADDR - 1):0] one_err_det_raw_w ; 
                                        wire [(EBR_ADDR - 1):0] two_err_det_raw_w ; 
                                        for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                                        begin : ADDR_x
                                            wire [(RDATA_WIDTH - 1):0] raw_output_w ; 
                                            assign rd_data_raw_w[i0] = raw_output_w ; 
                                            wire chk_addr_wr_w ; 
                                            if ((EBR_ADDR > 1)) 
                                                begin : genblk1
                                                    assign chk_addr_wr_w = (wr_addr_i[(WADDR_WIDTH - 1):W_ADDR_WIDTH_IMPL] == i0) ; 
                                                end
                                            else
                                                begin : genblk1
                                                    assign chk_addr_wr_w = 1'b1 ; 
                                                end
                                            wire [(W_ADDR_WIDTH_IMPL - 1):0] act_wr_addr_w ; 
                                            if ((W_ADDR_WIDTH_IMPL > WADDR_WIDTH)) 
                                                begin : genblk2
                                                    assign act_wr_addr_w[(W_ADDR_WIDTH_IMPL - 1):WADDR_WIDTH] = 'h0000 ; 
                                                    assign act_wr_addr_w[(WADDR_WIDTH - 1):0] = wr_addr_i ; 
                                                end
                                            else
                                                begin : genblk2
                                                    assign act_wr_addr_w = wr_addr_i[(W_ADDR_WIDTH_IMPL - 1):0] ; 
                                                end
                                            wire chk_addr_rd_w ; 
                                            if ((EBR_ADDR > 1)) 
                                                begin : genblk3
                                                    assign chk_addr_rd_w = (rd_addr_i[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL] == i0) ; 
                                                end
                                            else
                                                begin : genblk3
                                                    assign chk_addr_rd_w = 1'b1 ; 
                                                end
                                            wire [(R_ADDR_WIDTH_IMPL - 1):0] act_rd_addr_w ; 
                                            if ((R_ADDR_WIDTH_IMPL > RADDR_WIDTH)) 
                                                begin : genblk4
                                                    assign act_rd_addr_w[(R_ADDR_WIDTH_IMPL - 1):RADDR_WIDTH] = 'h0000 ; 
                                                    assign act_rd_addr_w[(RADDR_WIDTH - 1):0] = rd_addr_i ; 
                                                end
                                            else
                                                begin : genblk4
                                                    assign act_rd_addr_w = rd_addr_i[(R_ADDR_WIDTH_IMPL - 1):0] ; 
                                                end
                                            wire [(EBR_DATA - 1):0] one_err_det_ind_w ; 
                                            wire [(EBR_DATA - 1):0] two_err_det_ind_w ; 
                                            if ((EBR_DATA == 1)) 
                                                begin : genblk5
                                                    assign one_err_det_raw_w[i0] = one_err_det_ind_w[0] ; 
                                                    assign two_err_det_raw_w[i0] = two_err_det_ind_w[0] ; 
                                                end
                                            else
                                                begin : genblk5
                                                    assign one_err_det_raw_w[i0] = (|one_err_det_ind_w) ; 
                                                    assign two_err_det_raw_w[i0] = (|two_err_det_ind_w) ; 
                                                end
                                            for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                                            begin : DATA_x
                                                localparam ECO_POSX = (i1 * W_DATA_WIDTH_IMPL) ; 
                                                localparam ECO_POSY = (i0 * W_ADDR_DEPTH_IMPL) ; 
                                                wire [(W_DATA_WIDTH_IMPL - 1):0] act_wr_data_w ; 
                                                wire [(R_DATA_WIDTH_IMPL - 1):0] act_rd_data_w ; 
                                                wire [(TRUE_BYTE_WIDTH - 1):0] act_ben_w ; 
                                                wire one_err_det_ebr_w ; 
                                                wire two_err_det_ebr_w ; 
                                                assign one_err_det_ind_w[i1] = one_err_det_ebr_w ; 
                                                assign two_err_det_ind_w[i1] = two_err_det_ebr_w ; 
                                                if (((W_DATA_WIDTH_IMPL * (i1 + 1)) <= WDATA_WIDTH)) 
                                                    begin : genblk1
                                                        assign act_wr_data_w = master_data_in_w[((W_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign act_wr_data_w[(W_DATA_WIDTH_IMPL - 1):(WDATA_WIDTH - (i1 * W_DATA_WIDTH_IMPL))] = 'h0000 ; 
                                                        assign act_wr_data_w[(WDATA_WIDTH - (1 + (W_DATA_WIDTH_IMPL * i1))):0] = master_data_in_w[(WDATA_WIDTH - 1):(W_DATA_WIDTH_IMPL * i1)] ; 
                                                    end
                                                if (((R_DATA_WIDTH_IMPL * (i1 + 1)) <= RDATA_WIDTH)) 
                                                    begin : genblk2
                                                        assign raw_output_w[((R_DATA_WIDTH_IMPL * (i1 + 1)) - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w ; 
                                                    end
                                                else
                                                    begin : genblk2
                                                        assign raw_output_w[(RDATA_WIDTH - 1):(R_DATA_WIDTH_IMPL * i1)] = act_rd_data_w[(RDATA_WIDTH - (1 + (R_DATA_WIDTH_IMPL * i1))):0] ; 
                                                    end
                                                if ((TRUE_BYTE_WIDTH > 1)) 
                                                    begin : genblk3
                                                        if ((((i1 + 1) * TRUE_BYTE_WIDTH) <= BYTE_WIDTH)) 
                                                            begin : genblk1
                                                                assign act_ben_w = byte_en_buffer_w[(((i1 + 1) * TRUE_BYTE_WIDTH) - 1):(i1 * TRUE_BYTE_WIDTH)] ; 
                                                            end
                                                        else
                                                            begin : genblk1
                                                                assign act_ben_w[(BYTE_WIDTH - (1 + (i1 * TRUE_BYTE_WIDTH))):0] = byte_en_buffer_w[(BYTE_WIDTH - 1):(i1 * TRUE_BYTE_WIDTH)] ; 
                                                                assign act_ben_w[(TRUE_BYTE_WIDTH - 1):(BYTE_WIDTH - (i1 * TRUE_BYTE_WIDTH))] = {(TRUE_BYTE_WIDTH - (BYTE_WIDTH - (i1 * TRUE_BYTE_WIDTH))){1'b1}} ; 
                                                            end
                                                    end
                                                else
                                                    begin : genblk3
                                                        assign act_ben_w[0] = byte_en_buffer_w[i1] ; 
                                                    end
                                                wire f_wr_en_w = (chk_addr_wr_w & wr_en_i) ; 
                                                wire f_rd_en_w = (chk_addr_rd_w & rd_en_i) ; 
                                                wire ff_rd_en_w ; 
                                                if ((REGMODE == "noreg")) 
                                                    begin : genblk4
                                                        assign ff_rd_en_w = f_rd_en_w ; 
                                                    end
                                                else
                                                    begin : genblk4
                                                        reg f_rd_en_r ; 
                                                        assign ff_rd_en_w = (f_rd_en_w | f_rd_en_r) ; 
                                                        if ((RESETMODE == "sync")) 
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                f_rd_en_r <=  1'b0 ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                f_rd_en_r <=  (f_rd_en_w & rd_clk_en_i) ;
                                                                            end
                                                                    end
                                                            end
                                                        else
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i or 
                                                                        posedge rst_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                f_rd_en_r <=  1'b0 ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                f_rd_en_r <=  (f_rd_en_w & rd_clk_en_i) ;
                                                                            end
                                                                    end
                                                            end
                                                    end
                                                if ((INIT_MODE == "mem_file")) 
                                                    begin : mem_init
                                                        new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                                .MEM_SIZE(MEM_SIZE),
                                                                .POSx(ECO_POSX),
                                                                .POSy(ECO_POSY),
                                                                .FAMILY(FAMILY),
                                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                                .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                                .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                                .REGMODE(REGMODE),
                                                                .RESETMODE(RESETMODE),
                                                                .RESET_RELEASE(RESET_RELEASE),
                                                                .BYTE_ENABLE(1),
                                                                .INIT_MODE(INIT_MODE),
                                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                                .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                                .INIT_VALUE_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                                .INIT_VALUE_10(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_11(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_12(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_13(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_14(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_15(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_16(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_17(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_18(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_19(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_1F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_20(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_21(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_22(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_23(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_24(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_25(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_26(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_27(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_28(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_29(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_2F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_30(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_31(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_32(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_33(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_34(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_35(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_36(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_37(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_38(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_39(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3A(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3B(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3C(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3D(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3E(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_3F(((checkINIT(FAMILY_CODE) >= 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_40(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_40[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_41(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_41[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_42(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_42[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_43(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_43[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_44(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_44[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_45(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_45[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_46(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_46[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_47(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_47[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_48(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_48[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_49(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_49[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_4F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_4F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_50(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_50[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_51(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_51[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_52(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_52[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_53(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_53[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_54(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_54[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_55(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_55[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_56(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_56[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_57(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_57[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_58(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_58[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_59(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_59[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_5F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_5F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_60(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_60[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_61(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_61[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_62(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_62[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_63(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_63[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_64(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_64[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_65(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_65[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_66(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_66[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_67(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_67[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_68(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_68[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_69(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_69[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_6F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_6F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_70(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_70[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_71(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_71[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_72(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_72[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_73(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_73[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_74(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_74[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_75(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_75[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_76(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_76[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_77(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_77[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_78(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_78[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_79(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_79[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7A(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7B(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7C(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7D(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7E(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                                .INIT_VALUE_7F(((checkINIT(FAMILY_CODE) >= 2) ? INIT_VALUE_7F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                                    .rd_clk_i(rd_clk_i), 
                                                                    .rst_i(rst_i), 
                                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                                    .wr_en_i(f_wr_en_w), 
                                                                    .wr_data_i(act_wr_data_w), 
                                                                    .wr_addr_i(act_wr_addr_w), 
                                                                    .rd_en_i(ff_rd_en_w), 
                                                                    .rd_addr_i(act_rd_addr_w), 
                                                                    .ben_i(act_ben_w), 
                                                                    .rd_data_o(act_rd_data_w), 
                                                                    .one_err_det_o(one_err_det_ebr_w), 
                                                                    .two_err_det_o(two_err_det_ebr_w)) ; 
                                                    end
                                                else
                                                    begin : no_init
                                                        new_lpddr4_ipgen_lscc_ram_dp_core #(.MEM_ID(MEM_ID),
                                                                .MEM_SIZE(MEM_SIZE),
                                                                .POSx(ECO_POSX),
                                                                .POSy(ECO_POSY),
                                                                .FAMILY(FAMILY),
                                                                ._FCODE_ICE_(_FCODE_ICE_),
                                                                ._FCODE_LIFCL_(_FCODE_LIFCL_),
                                                                ._FCODE_AP6_(_FCODE_AP6_),
                                                                ._FCODE_COMMON_(_FCODE_COMMON_),
                                                                .DATA_WIDTH_W(W_DATA_WIDTH_IMPL),
                                                                .DATA_WIDTH_R(R_DATA_WIDTH_IMPL),
                                                                .REGMODE(REGMODE),
                                                                .RESETMODE(RESETMODE),
                                                                .RESET_RELEASE(RESET_RELEASE),
                                                                .BYTE_ENABLE(1),
                                                                .OUTPUT_CLK_EN(OUTPUT_CLK_EN),
                                                                .BYTE_ENABLE_POL(BYTE_ENABLE_POL),
                                                                .INIT_MODE(INIT_MODE)) u_mem0 (.wr_clk_i(wr_clk_i), 
                                                                    .rd_clk_i(rd_clk_i), 
                                                                    .rst_i(rst_i), 
                                                                    .wr_clk_en_i(wr_clk_en_i), 
                                                                    .rd_clk_en_i(rd_clk_en_i), 
                                                                    .rd_out_clk_en_i(rd_out_clk_en_i), 
                                                                    .wr_en_i(f_wr_en_w), 
                                                                    .wr_data_i(act_wr_data_w), 
                                                                    .wr_addr_i(act_wr_addr_w), 
                                                                    .rd_en_i(ff_rd_en_w), 
                                                                    .rd_addr_i(act_rd_addr_w), 
                                                                    .ben_i(act_ben_w), 
                                                                    .rd_data_o(act_rd_data_w), 
                                                                    .one_err_det_o(one_err_det_ebr_w), 
                                                                    .two_err_det_o(two_err_det_ebr_w)) ; 
                                                    end
                                            end
                                        end
                                        if ((EBR_ADDR == 1)) 
                                            begin : genblk2
                                                assign master_data_out_w = rd_data_raw_w[0] ; 
                                                assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_raw_w[0] : 1'b0) ; 
                                                assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_raw_w[0] : 1'b0) ; 
                                            end
                                        else
                                            begin : genblk2
                                                reg [(RDATA_WIDTH - 1):0] rd_out_buff_r ; 
                                                reg one_err_det_r = 1'b0 ; 
                                                reg two_err_det_r = 1'b0 ; 
                                                reg [(RADDR_WIDTH - 1):0] rd_addr_0_r ; 
                                                assign one_err_det_o = ((ECC_ENABLE == 1) ? one_err_det_r : 1'b0) ; 
                                                assign two_err_det_o = ((ECC_ENABLE == 1) ? two_err_det_r : 1'b0) ; 
                                                if ((REGMODE == "noreg")) 
                                                    begin : _nreg
                                                        if ((RESETMODE == "sync")) 
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                            end
                                                                    end
                                                            end
                                                        else
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i or 
                                                                        posedge rst_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_0_r) ;
                                                                            end
                                                                    end
                                                            end
                                                    end
                                                else
                                                    begin : _reg
                                                        reg [(RADDR_WIDTH - 1):0] rd_addr_1_r ; 
                                                        if ((RESETMODE == "sync")) 
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                                rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  rd_addr_1_r ;
                                                                                rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                            end
                                                                    end
                                                            end
                                                        else
                                                            begin : genblk1
                                                                always
                                                                    @(posedge rd_clk_i)
                                                                    begin
                                                                        if (rst_i) 
                                                                            begin
                                                                                rd_addr_0_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                                rd_addr_1_r <=  {RADDR_WIDTH{1'b0}} ;
                                                                            end
                                                                        else
                                                                            begin
                                                                                rd_addr_0_r <=  rd_addr_1_r ;
                                                                                rd_addr_1_r <=  ((rd_en_i & rd_clk_en_i) ? rd_addr_i : rd_addr_1_r) ;
                                                                            end
                                                                    end
                                                            end
                                                    end
                                                always
                                                    @(*)
                                                    begin
                                                        rd_out_buff_r = rd_data_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                        one_err_det_r = one_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                        two_err_det_r = two_err_det_raw_w[rd_addr_0_r[(RADDR_WIDTH - 1):R_ADDR_WIDTH_IMPL]] ;
                                                    end
                                                assign master_data_out_w = rd_out_buff_r ; 
                                            end
                                    end
                            end
                    end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [1:0] checkINIT ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                checkINIT = 1 ;
            _FCODE_AP6_ : 
                checkINIT = 2 ;
            default : 
                checkINIT = 0 ;
            endcase 
        end
    endfunction
    function [31:0] getTrueByteWidth ; 
        input [31:0] dwid_in ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                getTrueByteWidth = (((dwid_in == 36) || (dwid_in == 32)) ? 4 : (((dwid_in == 18) || (dwid_in == 16)) ? 2 : 1)) ;
            _FCODE_ICE_ : 
                getTrueByteWidth = ((dwid_in == 16) ? 2 : 1) ;
            _FCODE_AP6_ : 
                getTrueByteWidth = (((dwid_in == 72) || (dwid_in == 64)) ? 8 : (((dwid_in == 36) || (dwid_in == 32)) ? 4 : (((dwid_in == 18) || (dwid_in == 16)) ? 2 : 1))) ;
            endcase 
        end
    endfunction
    function [31:0] procData ; 
        input [31:0] TARGET_DATA ; 
        input isECC ; 
        input [31:0] FAMILY_CODE ; 
        begin
            procData = 1 ;
            while ((procData < TARGET_DATA))
                begin
                    case (FAMILY_CODE)
                    _FCODE_LIFCL_ : 
                        begin
                            if (isECC) 
                                begin
                                    if ((procData < 32)) 
                                        begin
                                            procData = 32 ;
                                        end
                                    else
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                end
                            else
                                begin
                                    if ((procData < 8)) 
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                    else
                                        begin
                                            if ((procData == 8)) 
                                                begin
                                                    procData = 9 ;
                                                end
                                            else
                                                if (((procData % 9) == 0)) 
                                                    begin
                                                        procData = ((procData / 9) * 16) ;
                                                    end
                                                else
                                                    begin
                                                        procData = ((procData / 8) * 9) ;
                                                    end
                                        end
                                end
                        end
                    _FCODE_ICE_ : 
                        procData = (procData * 2) ;
                    _FCODE_AP6_ : 
                        begin
                            if (isECC) 
                                begin
                                    if ((procData < 64)) 
                                        begin
                                            procData = 64 ;
                                        end
                                    else
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                end
                            else
                                begin
                                    if ((procData < 8)) 
                                        begin
                                            procData = (procData * 2) ;
                                        end
                                    else
                                        begin
                                            if ((procData == 8)) 
                                                begin
                                                    procData = 9 ;
                                                end
                                            else
                                                if (((procData % 9) == 0)) 
                                                    begin
                                                        procData = ((procData / 9) * 16) ;
                                                    end
                                                else
                                                    begin
                                                        procData = ((procData / 8) * 9) ;
                                                    end
                                        end
                                end
                        end
                    default : 
                        procData = TARGET_DATA ;
                    endcase 
                end
        end
    endfunction
    function [31:0] getSingularCase ; 
        input [31:0] port_use ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    if ((port_use > 32)) 
                        getSingularCase = 36 ;
                    else
                        if ((port_use > 18)) 
                            getSingularCase = 32 ;
                        else
                            if ((port_use > 16)) 
                                getSingularCase = 18 ;
                            else
                                if ((port_use > 9)) 
                                    getSingularCase = 16 ;
                                else
                                    if ((port_use > 8)) 
                                        getSingularCase = 9 ;
                                    else
                                        getSingularCase = (2 ** clog2(port_use)) ;
                end
            _FCODE_ICE_ : 
                getSingularCase = (2 ** clog2(port_use)) ;
            _FCODE_AP6_ : 
                begin
                    if ((port_use > 64)) 
                        getSingularCase = 72 ;
                    else
                        if ((port_use > 36)) 
                            getSingularCase = 64 ;
                        else
                            if ((port_use > 32)) 
                                getSingularCase = 36 ;
                            else
                                if ((port_use > 18)) 
                                    getSingularCase = 32 ;
                                else
                                    if ((port_use > 16)) 
                                        getSingularCase = 18 ;
                                    else
                                        if ((port_use > 9)) 
                                            getSingularCase = 16 ;
                                        else
                                            if ((port_use > 8)) 
                                                getSingularCase = 9 ;
                                            else
                                                getSingularCase = (2 ** clog2(port_use)) ;
                end
            default : 
                getSingularCase = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getCASE1DataImpl ; 
        input [31:0] wr_addr_depth ; 
        input [31:0] wr_data_width ; 
        input [31:0] rd_addr_depth ; 
        input [31:0] rd_data_width ; 
        input is_taking_write_port ; 
        input is_taking_total_ebr ; 
        input is_ecc ; 
        input [31:0] family_code ; 
        reg [5:0] num0, 
            num1, 
            limit ; 
        reg [31:0] divisor, 
            wr_addr_div, 
            wr_data_div, 
            rd_addr_div, 
            rd_data_div ; 
        reg [31:0] wr_addr_chk, 
            wr_data_chk, 
            rd_addr_chk, 
            rd_data_chk ; 
        reg [31:0] EBR_usage, 
            prod ; 
        begin
            divisor = ((wr_addr_depth > rd_addr_depth) ? (wr_addr_depth / rd_addr_depth) : (rd_addr_depth / wr_addr_depth)) ;
            EBR_usage = 32'hffffffff ;
            getCASE1DataImpl = 0 ;
            if ((is_ecc == 1)) 
                begin
                    if ((is_taking_write_port == 1)) 
                        begin
                            if ((family_code == _FCODE_AP6_)) 
                                getCASE1DataImpl = 64 ;
                            else
                                getCASE1DataImpl = 32 ;
                        end
                    else
                        begin
                            if ((family_code == _FCODE_AP6_)) 
                                getCASE1DataImpl = (64 / divisor) ;
                            else
                                getCASE1DataImpl = (32 / divisor) ;
                        end
                end
            else
                begin
                    if ((((family_code == _FCODE_LIFCL_) && (divisor <= 4)) || ((family_code == _FCODE_AP6_) && (divisor <= 8)))) 
                        begin
                            limit = ((family_code == _FCODE_LIFCL_) ? 3 : 4) ;
                            for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                                begin
                                    wr_data_div = getDatabase(9,
                                            num0,
                                            family_code) ;
                                    wr_addr_div = data_to_addr(wr_data_div,
                                            family_code) ;
                                    wr_addr_chk = roundUP(wr_addr_depth,
                                            wr_addr_div) ;
                                    wr_data_chk = roundUP(wr_data_width,
                                            wr_data_div) ;
                                    for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                        begin
                                            rd_data_div = getDatabase(9,
                                                    num1,
                                                    family_code) ;
                                            rd_addr_div = data_to_addr(rd_data_div,
                                                    family_code) ;
                                            rd_addr_chk = roundUP(rd_addr_depth,
                                                    rd_addr_div) ;
                                            rd_data_chk = roundUP(rd_data_width,
                                                    rd_data_div) ;
                                            if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                                begin
                                                    if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                        begin
                                                            prod = (wr_addr_chk * wr_data_chk) ;
                                                            if ((prod < EBR_usage)) 
                                                                begin
                                                                    EBR_usage = prod ;
                                                                    if ((is_taking_total_ebr == 1'b1)) 
                                                                        getCASE1DataImpl = EBR_usage ;
                                                                    else
                                                                        if ((is_taking_write_port == 1'b1)) 
                                                                            getCASE1DataImpl = wr_data_div ;
                                                                        else
                                                                            getCASE1DataImpl = rd_data_div ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                    limit = ((family_code == _FCODE_LIFCL_) ? 6 : 7) ;
                    for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                        begin
                            wr_data_div = getDatabase(8,
                                    num0,
                                    family_code) ;
                            wr_addr_div = data_to_addr(wr_data_div,
                                    family_code) ;
                            wr_addr_chk = roundUP(wr_addr_depth,
                                    wr_addr_div) ;
                            wr_data_chk = roundUP(wr_data_width,
                                    wr_data_div) ;
                            for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                begin
                                    rd_data_div = getDatabase(8,
                                            num1,
                                            family_code) ;
                                    rd_addr_div = data_to_addr(rd_data_div,
                                            family_code) ;
                                    rd_addr_chk = roundUP(rd_addr_depth,
                                            rd_addr_div) ;
                                    rd_data_chk = roundUP(rd_data_width,
                                            rd_data_div) ;
                                    if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                        begin
                                            if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                begin
                                                    prod = (wr_addr_chk * wr_data_chk) ;
                                                    if ((prod < EBR_usage)) 
                                                        begin
                                                            EBR_usage = prod ;
                                                            if ((is_taking_total_ebr == 1'b1)) 
                                                                getCASE1DataImpl = EBR_usage ;
                                                            else
                                                                if ((is_taking_write_port == 1'b1)) 
                                                                    getCASE1DataImpl = wr_data_div ;
                                                                else
                                                                    getCASE1DataImpl = rd_data_div ;
                                                        end
                                                end
                                        end
                                end
                        end
                end
        end
    endfunction
    function [31:0] getCASE1DataImpl_wBen ; 
        input [31:0] wr_addr_depth ; 
        input [31:0] wr_data_width ; 
        input [31:0] rd_addr_depth ; 
        input [31:0] rd_data_width ; 
        input is_taking_write_port ; 
        input [31:0] family_code ; 
        reg [5:0] num0, 
            num1, 
            limit ; 
        reg [31:0] wr_addr_div, 
            wr_data_div, 
            rd_addr_div, 
            rd_data_div ; 
        reg [31:0] wr_addr_chk, 
            wr_data_chk, 
            rd_addr_chk, 
            rd_data_chk ; 
        reg [31:0] EBR_usage, 
            prod ; 
        begin
            if ((family_code == _FCODE_ICE_)) 
                begin
                    if ((wr_data_width > rd_data_width)) 
                        begin
                            if ((is_taking_write_port == 1)) 
                                getCASE1DataImpl_wBen = 16 ;
                            else
                                getCASE1DataImpl_wBen = 8 ;
                        end
                    else
                        begin
                            if ((is_taking_write_port == 1)) 
                                getCASE1DataImpl_wBen = 8 ;
                            else
                                getCASE1DataImpl_wBen = 16 ;
                        end
                end
            else
                if (((family_code == _FCODE_LIFCL_) || (family_code == _FCODE_AP6_))) 
                    begin
                        EBR_usage = 32'hffffffff ;
                        getCASE1DataImpl_wBen = 0 ;
                        limit = ((family_code == _FCODE_LIFCL_) ? 3 : 4) ;
                        if (((wr_data_width % 9) == 0)) 
                            begin
                                for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                                    begin
                                        wr_data_div = getDatabase_wBen(9,
                                                num0,
                                                family_code) ;
                                        wr_addr_div = data_to_addr(wr_data_div,
                                                family_code) ;
                                        wr_addr_chk = roundUP(wr_addr_depth,
                                                wr_addr_div) ;
                                        wr_data_chk = roundUP(wr_data_width,
                                                wr_data_div) ;
                                        for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                            begin
                                                rd_data_div = getDatabase_wBen(9,
                                                        num1,
                                                        family_code) ;
                                                rd_addr_div = data_to_addr(rd_data_div,
                                                        family_code) ;
                                                rd_addr_chk = roundUP(rd_addr_depth,
                                                        rd_addr_div) ;
                                                rd_data_chk = roundUP(rd_data_width,
                                                        rd_data_div) ;
                                                if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                                    begin
                                                        if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                            begin
                                                                prod = (wr_addr_chk * wr_data_chk) ;
                                                                if ((prod < EBR_usage)) 
                                                                    begin
                                                                        EBR_usage = prod ;
                                                                        if ((is_taking_write_port == 1'b1)) 
                                                                            getCASE1DataImpl_wBen = wr_data_div ;
                                                                        else
                                                                            getCASE1DataImpl_wBen = rd_data_div ;
                                                                    end
                                                            end
                                                    end
                                            end
                                    end
                            end
                        else
                            begin
                                for (num0 = 0 ; (num0 < limit) ; num0 = (num0 + 1))
                                    begin
                                        wr_data_div = getDatabase_wBen(8,
                                                num0,
                                                family_code) ;
                                        wr_addr_div = data_to_addr(wr_data_div,
                                                family_code) ;
                                        wr_addr_chk = roundUP(wr_addr_depth,
                                                wr_addr_div) ;
                                        wr_data_chk = roundUP(wr_data_width,
                                                wr_data_div) ;
                                        for (num1 = 0 ; (num1 < limit) ; num1 = (num1 + 1))
                                            begin
                                                rd_data_div = getDatabase_wBen(8,
                                                        num1,
                                                        family_code) ;
                                                rd_addr_div = data_to_addr(rd_data_div,
                                                        family_code) ;
                                                rd_addr_chk = roundUP(rd_addr_depth,
                                                        rd_addr_div) ;
                                                rd_data_chk = roundUP(rd_data_width,
                                                        rd_data_div) ;
                                                if (((wr_addr_chk == rd_addr_chk) && (wr_data_chk == rd_data_chk))) 
                                                    begin
                                                        if ((((wr_data_width % wr_data_div) == 0) && ((rd_data_width % rd_data_div) == 0))) 
                                                            begin
                                                                prod = (wr_addr_chk * wr_data_chk) ;
                                                                if ((prod < EBR_usage)) 
                                                                    begin
                                                                        EBR_usage = prod ;
                                                                        if ((is_taking_write_port == 1'b1)) 
                                                                            getCASE1DataImpl_wBen = wr_data_div ;
                                                                        else
                                                                            getCASE1DataImpl_wBen = rd_data_div ;
                                                                    end
                                                            end
                                                    end
                                            end
                                    end
                            end
                    end
        end
    endfunction
    function [31:0] getDatabase ; 
        input [31:0] base_count ; 
        input [31:0] index ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 9 ;
                            1 : 
                                getDatabase = 18 ;
                            default : 
                                getDatabase = 36 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 1 ;
                            1 : 
                                getDatabase = 2 ;
                            2 : 
                                getDatabase = 4 ;
                            3 : 
                                getDatabase = 8 ;
                            4 : 
                                getDatabase = 16 ;
                            default : 
                                getDatabase = 32 ;
                            endcase 
                        end
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (index)
                    0 : 
                        getDatabase = 2 ;
                    1 : 
                        getDatabase = 4 ;
                    2 : 
                        getDatabase = 8 ;
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 9 ;
                            1 : 
                                getDatabase = 18 ;
                            2 : 
                                getDatabase = 36 ;
                            default : 
                                getDatabase = 72 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 1 ;
                            1 : 
                                getDatabase = 2 ;
                            2 : 
                                getDatabase = 4 ;
                            3 : 
                                getDatabase = 8 ;
                            4 : 
                                getDatabase = 16 ;
                            5 : 
                                getDatabase = 32 ;
                            default : 
                                getDatabase = 64 ;
                            endcase 
                        end
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            default : 
                getDatabase = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getDatabase_wBen ; 
        input [31:0] base_count ; 
        input [31:0] index ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 9 ;
                            1 : 
                                getDatabase_wBen = 18 ;
                            default : 
                                getDatabase_wBen = 36 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 8 ;
                            1 : 
                                getDatabase_wBen = 16 ;
                            default : 
                                getDatabase_wBen = 32 ;
                            endcase 
                        end
                    default : 
                        getDatabase_wBen = 16 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 9 ;
                            1 : 
                                getDatabase_wBen = 18 ;
                            2 : 
                                getDatabase_wBen = 36 ;
                            default : 
                                getDatabase_wBen = 72 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase_wBen = 8 ;
                            1 : 
                                getDatabase_wBen = 16 ;
                            2 : 
                                getDatabase_wBen = 32 ;
                            default : 
                                getDatabase_wBen = 64 ;
                            endcase 
                        end
                    default : 
                        getDatabase_wBen = 16 ;
                    endcase 
                end
            default : 
                getDatabase_wBen = 8 ;
            endcase 
        end
    endfunction
    function [31:0] data_to_addr ; 
        input [31:0] data_size ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (data_size)
                    36 : 
                        data_to_addr = 512 ;
                    32 : 
                        data_to_addr = 512 ;
                    18 : 
                        data_to_addr = 1024 ;
                    16 : 
                        data_to_addr = 1024 ;
                    9 : 
                        data_to_addr = 2048 ;
                    8 : 
                        data_to_addr = 2048 ;
                    4 : 
                        data_to_addr = 4096 ;
                    2 : 
                        data_to_addr = 8192 ;
                    default : 
                        data_to_addr = 16384 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (data_size)
                    16 : 
                        data_to_addr = 256 ;
                    8 : 
                        data_to_addr = 512 ;
                    4 : 
                        data_to_addr = 1024 ;
                    2 : 
                        data_to_addr = 2048 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (data_size)
                    72 : 
                        data_to_addr = 512 ;
                    64 : 
                        data_to_addr = 512 ;
                    36 : 
                        data_to_addr = 1024 ;
                    32 : 
                        data_to_addr = 1024 ;
                    18 : 
                        data_to_addr = 2048 ;
                    16 : 
                        data_to_addr = 2048 ;
                    9 : 
                        data_to_addr = 4096 ;
                    8 : 
                        data_to_addr = 4096 ;
                    4 : 
                        data_to_addr = 8192 ;
                    2 : 
                        data_to_addr = 16384 ;
                    default : 
                        data_to_addr = 32768 ;
                    endcase 
                end
            default : 
                data_to_addr = 1024 ;
            endcase 
        end
    endfunction
    function [31:0] addr_to_data ; 
        input [31:0] addr_size ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (addr_size)
                    512 : 
                        addr_to_data = 36 ;
                    1024 : 
                        addr_to_data = 18 ;
                    2048 : 
                        addr_to_data = 9 ;
                    4096 : 
                        addr_to_data = 4 ;
                    8192 : 
                        addr_to_data = 2 ;
                    default : 
                        addr_to_data = 1 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (addr_size)
                    256 : 
                        addr_to_data = 16 ;
                    512 : 
                        addr_to_data = 8 ;
                    1024 : 
                        addr_to_data = 4 ;
                    2048 : 
                        addr_to_data = 2 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (addr_size)
                    512 : 
                        addr_to_data = 72 ;
                    1024 : 
                        addr_to_data = 36 ;
                    2048 : 
                        addr_to_data = 18 ;
                    4096 : 
                        addr_to_data = 9 ;
                    8192 : 
                        addr_to_data = 4 ;
                    16384 : 
                        addr_to_data = 2 ;
                    default : 
                        addr_to_data = 1 ;
                    endcase 
                end
            default : 
                addr_to_data = 1024 ;
            endcase 
        end
    endfunction
    function [31:0] getMinimaData ; 
        input [31:0] depth_impl ; 
        input [31:0] width_impl ; 
        input is_byte_enable ; 
        input [31:0] byte_size ; 
        input is_ecc ; 
        input [31:0] family_code ; 
        reg [31:0] temp_00, 
            temp_01, 
            temp_02, 
            temp_03, 
            temp_04, 
            temp_05, 
            temp_06 ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    if (is_ecc) 
                        begin
                            getMinimaData = 32 ;
                        end
                    else
                        begin
                            temp_00 = EBR_impl(depth_impl,
                                    width_impl,
                                    512,
                                    36) ;
                            temp_01 = EBR_impl(depth_impl,
                                    width_impl,
                                    1024,
                                    18) ;
                            temp_02 = EBR_impl(depth_impl,
                                    width_impl,
                                    2048,
                                    9) ;
                            temp_03 = EBR_impl(depth_impl,
                                    width_impl,
                                    4096,
                                    4) ;
                            temp_04 = EBR_impl(depth_impl,
                                    width_impl,
                                    8192,
                                    2) ;
                            temp_05 = EBR_impl(depth_impl,
                                    width_impl,
                                    16384,
                                    1) ;
                            if (((is_byte_enable == 1) && ((width_impl % 9) != 0))) 
                                begin
                                    temp_00 = EBR_impl(depth_impl,
                                            width_impl,
                                            512,
                                            32) ;
                                    temp_01 = EBR_impl(depth_impl,
                                            width_impl,
                                            1024,
                                            16) ;
                                    temp_02 = EBR_impl(depth_impl,
                                            width_impl,
                                            2048,
                                            8) ;
                                    if ((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05))) 
                                        getMinimaData = 32 ;
                                    else
                                        if (((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05))) 
                                            getMinimaData = 16 ;
                                        else
                                            if ((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05))) 
                                                getMinimaData = 8 ;
                                            else
                                                if (((temp_03 < temp_04) && (temp_03 < temp_05))) 
                                                    getMinimaData = 4 ;
                                                else
                                                    if ((temp_04 < temp_05)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                end
                            else
                                begin
                                    if ((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05))) 
                                        getMinimaData = 36 ;
                                    else
                                        if (((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05))) 
                                            getMinimaData = 18 ;
                                        else
                                            if ((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05))) 
                                                getMinimaData = 9 ;
                                            else
                                                if (((temp_03 < temp_04) && (temp_03 < temp_05))) 
                                                    getMinimaData = 4 ;
                                                else
                                                    if ((temp_04 < temp_05)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                end
                        end
                end
            _FCODE_ICE_ : 
                begin
                    temp_00 = EBR_impl(depth_impl,
                            width_impl,
                            256,
                            16) ;
                    temp_01 = EBR_impl(depth_impl,
                            width_impl,
                            512,
                            8) ;
                    temp_02 = EBR_impl(depth_impl,
                            width_impl,
                            1024,
                            4) ;
                    temp_03 = EBR_impl(depth_impl,
                            width_impl,
                            2048,
                            2) ;
                    if ((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03))) 
                        getMinimaData = 16 ;
                    else
                        if (((temp_01 < temp_02) && (temp_01 < temp_03))) 
                            getMinimaData = 8 ;
                        else
                            if ((temp_02 < temp_03)) 
                                getMinimaData = 4 ;
                            else
                                getMinimaData = 2 ;
                end
            _FCODE_AP6_ : 
                begin
                    if (is_ecc) 
                        begin
                            getMinimaData = 64 ;
                        end
                    else
                        begin
                            temp_00 = EBR_impl(depth_impl,
                                    width_impl,
                                    512,
                                    72) ;
                            temp_01 = EBR_impl(depth_impl,
                                    width_impl,
                                    1024,
                                    36) ;
                            temp_02 = EBR_impl(depth_impl,
                                    width_impl,
                                    2048,
                                    18) ;
                            temp_03 = EBR_impl(depth_impl,
                                    width_impl,
                                    4096,
                                    9) ;
                            temp_04 = EBR_impl(depth_impl,
                                    width_impl,
                                    8192,
                                    4) ;
                            temp_05 = EBR_impl(depth_impl,
                                    width_impl,
                                    16384,
                                    2) ;
                            temp_06 = EBR_impl(depth_impl,
                                    width_impl,
                                    32768,
                                    1) ;
                            if (((is_byte_enable == 1) && ((width_impl % 9) != 0))) 
                                begin
                                    temp_00 = EBR_impl(depth_impl,
                                            width_impl,
                                            512,
                                            64) ;
                                    temp_01 = EBR_impl(depth_impl,
                                            width_impl,
                                            1024,
                                            32) ;
                                    temp_02 = EBR_impl(depth_impl,
                                            width_impl,
                                            2048,
                                            16) ;
                                    temp_03 = EBR_impl(depth_impl,
                                            width_impl,
                                            4096,
                                            8) ;
                                    if (((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05)) && (temp_00 < temp_06))) 
                                        getMinimaData = 64 ;
                                    else
                                        if ((((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05)) && (temp_01 < temp_06))) 
                                            getMinimaData = 32 ;
                                        else
                                            if (((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05)) && (temp_02 < temp_06))) 
                                                getMinimaData = 16 ;
                                            else
                                                if ((((temp_03 < temp_04) && (temp_03 < temp_05)) && (temp_03 < temp_06))) 
                                                    getMinimaData = 8 ;
                                                else
                                                    if (((temp_04 < temp_05) && (temp_04 < temp_06))) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        if ((temp_05 < temp_06)) 
                                                            getMinimaData = 2 ;
                                                        else
                                                            getMinimaData = 1 ;
                                end
                            else
                                begin
                                    if (((((((temp_00 < temp_01) && (temp_00 < temp_02)) && (temp_00 < temp_03)) && (temp_00 < temp_04)) && (temp_00 < temp_05)) && (temp_00 < temp_06))) 
                                        getMinimaData = 72 ;
                                    else
                                        if ((((((temp_01 < temp_02) && (temp_01 < temp_03)) && (temp_01 < temp_04)) && (temp_01 < temp_05)) && (temp_01 < temp_06))) 
                                            getMinimaData = 36 ;
                                        else
                                            if (((((temp_02 < temp_03) && (temp_02 < temp_04)) && (temp_02 < temp_05)) && (temp_02 < temp_06))) 
                                                getMinimaData = 18 ;
                                            else
                                                if ((((temp_03 < temp_04) && (temp_03 < temp_05)) && (temp_03 < temp_06))) 
                                                    getMinimaData = 9 ;
                                                else
                                                    if (((temp_04 < temp_05) && (temp_04 < temp_06))) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        if ((temp_05 < temp_06)) 
                                                            getMinimaData = 2 ;
                                                        else
                                                            getMinimaData = 1 ;
                                end
                        end
                end
            default : 
                getMinimaData = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getByteSize ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    if (((data_width % 9) == 0)) 
                        getByteSize = 9 ;
                    else
                        getByteSize = 8 ;
                end
            _FCODE_ICE_ : 
                getByteSize = 8 ;
            _FCODE_AP6_ : 
                begin
                    if (((data_width % 9) == 0)) 
                        getByteSize = 9 ;
                    else
                        getByteSize = 8 ;
                end
            default : 
                getByteSize = 8 ;
            endcase 
        end
    endfunction
    function is_byte_enable_good ; 
        input [31:0] max_data ; 
        input [31:0] min_data ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_ICE_ : 
                is_byte_enable_good = ((((max_data / min_data) == 2) && ((max_data % 16) == 0)) ? 1'b1 : 1'b0) ;
            _FCODE_LIFCL_ : 
                begin
                    if (((max_data / min_data) == 4)) 
                        is_byte_enable_good = ((((max_data % 36) == 0) || ((max_data % 32) == 0)) ? 1'b1 : 1'b0) ;
                    else
                        if (((max_data / min_data) == 2)) 
                            is_byte_enable_good = ((((max_data % 16) == 0) || ((max_data % 18) == 0)) ? 1'b1 : 1'b0) ;
                        else
                            is_byte_enable_good = 1'b0 ;
                end
            _FCODE_AP6_ : 
                begin
                    if (((max_data / min_data) == 8)) 
                        is_byte_enable_good = ((((max_data % 72) == 0) || ((max_data % 64) == 0)) ? 1'b1 : 1'b0) ;
                    else
                        if (((max_data / min_data) == 4)) 
                            is_byte_enable_good = ((((max_data % 36) == 0) || ((max_data % 32) == 0)) ? 1'b1 : 1'b0) ;
                        else
                            if (((max_data / min_data) == 2)) 
                                is_byte_enable_good = ((((max_data % 16) == 0) || ((max_data % 18) == 0)) ? 1'b1 : 1'b0) ;
                            else
                                is_byte_enable_good = 1'b0 ;
                end
            default : 
                is_byte_enable_good = 1'b0 ;
            endcase 
        end
    endfunction
    function [31:0] EBR_impl ; 
        input [31:0] DEPTH_IMPL ; 
        input [31:0] WIDTH_IMPL ; 
        input [31:0] ADDR_DEPTH_X ; 
        input [31:0] DATA_WIDTH_X ; 
        begin
            EBR_impl = (roundUP(DEPTH_IMPL,
                    ADDR_DEPTH_X) * roundUP(WIDTH_IMPL,
                    DATA_WIDTH_X)) ;
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



//=============================================================================
// lscc_ram_dp.v
// Local Variables:
// verilog-library-directories: ("../../common")
// End:
//=============================================================================
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED 
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement. 
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02 
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS         
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp_core.v
// Title                 : 
// Dependencies          : 
// Description           : Implements a single pseudo dual port memory instance.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             : 
// Mod. Date             : 
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp_core #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_ICE_ = 2, 
        parameter _FCODE_AP6_ = 3, 
        parameter _FCODE_COMMON_ = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "[18,1024]", 
        parameter FAMILY = "common", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : ((FAMILY == "iCE40UP") ? _FCODE_ICE_ : ((FAMILY == "ap6a00") ? _FCODE_AP6_ : _FCODE_COMMON_))), 
        parameter DATA_WIDTH_W = 36, 
        parameter ADDR_WIDTH_W = getAddrWidth(DATA_WIDTH_W,
                FAMILY_CODE), 
        parameter DATA_WIDTH_R = 36, 
        parameter ADDR_WIDTH_R = getAddrWidth(DATA_WIDTH_R,
                FAMILY_CODE), 
        parameter REGMODE = "reg", 
        parameter GSR = "enabled", 
        parameter RESETMODE = "sync", 
        parameter RESET_RELEASE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 0, 
        parameter BYTE_WIDTH = ((BYTE_ENABLE == 1) ? getByteWidth(DATA_WIDTH_W,
                FAMILY_CODE) : 1), 
        parameter ECC_ENABLE = 0, 
        parameter CSDECODE_W = 0, 
        parameter CSDECODE_R = 0, 
        parameter OPTIMIZATION = "speed", 
        parameter OUTPUT_CLK_EN = 0, 
        parameter BYTE_ENABLE_POL = "active-high", 
        parameter POSx = 0, 
        parameter POSy = 0, 
        parameter STRING_SIZE = calculateStringSize(POSx,
                POSy), 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_40 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_41 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_42 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_43 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_44 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_45 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_46 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_47 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_48 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_49 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_4F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_50 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_51 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_52 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_53 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_54 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_55 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_56 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_57 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_58 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_59 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_5F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_60 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_61 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_62 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_63 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_64 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_65 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_66 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_67 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_68 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_69 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_6F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_70 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_71 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_72 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_73 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_74 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_75 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_76 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_77 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_78 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_79 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_7F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    //unused
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input rd_out_clk_en_i, 
    input wr_en_i, 
    input [(DATA_WIDTH_W - 1):0] wr_data_i, 
    input [(ADDR_WIDTH_W - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(ADDR_WIDTH_R - 1):0] rd_addr_i, 
    input [(BYTE_WIDTH - 1):0] ben_i, 
    output [(DATA_WIDTH_R - 1):0] rd_data_o, 
    output one_err_det_o, 
    output two_err_det_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    localparam POS_X0 = (POSx % 10) ; 
    localparam POS_X1 = ((POSx / 10) % 10) ; 
    localparam POS_X2 = ((POSx / 100) % 10) ; 
    localparam POS_X3 = ((POSx / 1000) % 10) ; 
    localparam POS_X4 = ((POSx / 10000) % 10) ; 
    localparam POS_X5 = ((POSx / 100000) % 10) ; 
    localparam POS_X6 = ((POSx / 1000000) % 10) ; 
    localparam POS_X7 = ((POSx / 10000000) % 10) ; 
    localparam POS_Y0 = (POSy % 10) ; 
    localparam POS_Y1 = ((POSy / 10) % 10) ; 
    localparam POS_Y2 = ((POSy / 100) % 10) ; 
    localparam POS_Y3 = ((POSy / 1000) % 10) ; 
    localparam POS_Y4 = ((POSy / 10000) % 10) ; 
    localparam POS_Y5 = ((POSy / 100000) % 10) ; 
    localparam POS_Y6 = ((POSy / 1000000) % 10) ; 
    localparam POS_Y7 = ((POSy / 10000000) % 10) ; 
    localparam [79:0] NUM_STRING = "9876543210" ; 
    localparam BLOCK_POS = getStringFromPos(POSx,
                POSy) ; 
    localparam BLOCK_SIZE = ((DATA_WIDTH_W == 72) ? "[72,512]" : ((DATA_WIDTH_W == 64) ? "[64,512]" : ((DATA_WIDTH_W == 36) ? ((FAMILY == "ap6a00") ? "[36,1024]" : "[36,512]") : ((DATA_WIDTH_W == 32) ? ((FAMILY == "ap6a00") ? "[32,1024]" : "[32,512]") : ((DATA_WIDTH_W == 18) ? ((FAMILY == "ap6a00") ? "[18,2048]" : "[18,1024]") : ((DATA_WIDTH_W == 16) ? ((FAMILY == "ap6a00") ? "[16,2048]" : "[16,1024]") : ((DATA_WIDTH_W == 9) ? ((FAMILY == "ap6a00") ? "[9,4096]" : "[9,2048]") : ((DATA_WIDTH_W == 8) ? ((FAMILY == "ap6a00") ? "[8,4096]" : "[8,2048]") : ((DATA_WIDTH_W == 4) ? ((FAMILY == "ap6a00") ? "[4,8192]" : "[4,4096]") : ((DATA_WIDTH_W == 2) ? ((FAMILY == "ap6a00") ? "[2,16384]" : "[2,8192]") : ((FAMILY == "ap6a00") ? "[1,32768]" : "[1,16384]"))))))))))) ; 
    // -----------------------------------------------------------------------------
    // Generate Sequential Blocks
    // -----------------------------------------------------------------------------
    genvar i0 ; 
    generate
        if ((FAMILY_CODE == _FCODE_ICE_)) 
            begin : ICE_MEM
                wire [10:0] raddr_w ; 
                wire [10:0] waddr_w ; 
                wire [15:0] wdata_w ; 
                wire [15:0] rdata_w ; 
                wire [15:0] mask_w ; 
                wire [15:0] mask_t_w ; 
                wire [(DATA_WIDTH_R - 1):0] rd_data_w ; 
                for (i0 = 0;(i0 < 16);i0 = (i0 + 1))
                begin : genblk1
                    if ((i0 < 8)) 
                        begin: genblk1
                            assign mask_w[i0] = ((BYTE_ENABLE == 0) ? 1'b0 : ((DATA_WIDTH_W == 16) ? (~ben_i[0]) : 1'b0)) ; 
                        end
                    else
                        begin: genblk1
                            assign mask_w[i0] = ((BYTE_ENABLE == 0) ? 1'b0 : ((DATA_WIDTH_W == 16) ? (~ben_i[1]) : 1'b0)) ; 
                        end
                end
                if ((DATA_WIDTH_R == 16)) 
                    begin : genblk2
                        assign mask_t_w = mask_w ; 
                    end
                else
                    if ((DATA_WIDTH_R == 8)) 
                        begin : genblk2
                            assign mask_t_w[0] = mask_w[0] ; 
                            assign mask_t_w[2] = mask_w[1] ; 
                            assign mask_t_w[4] = mask_w[2] ; 
                            assign mask_t_w[6] = mask_w[3] ; 
                            assign mask_t_w[8] = mask_w[4] ; 
                            assign mask_t_w[10] = mask_w[5] ; 
                            assign mask_t_w[12] = mask_w[6] ; 
                            assign mask_t_w[14] = mask_w[7] ; 
                            assign mask_t_w[1] = mask_w[8] ; 
                            assign mask_t_w[3] = mask_w[9] ; 
                            assign mask_t_w[5] = mask_w[10] ; 
                            assign mask_t_w[7] = mask_w[11] ; 
                            assign mask_t_w[9] = mask_w[12] ; 
                            assign mask_t_w[11] = mask_w[13] ; 
                            assign mask_t_w[13] = mask_w[14] ; 
                            assign mask_t_w[15] = mask_w[15] ; 
                        end
                    else
                        if ((DATA_WIDTH_R == 4)) 
                            begin : genblk2
                                assign mask_t_w[0] = mask_w[0] ; 
                                assign mask_t_w[4] = mask_w[1] ; 
                                assign mask_t_w[8] = mask_w[2] ; 
                                assign mask_t_w[12] = mask_w[3] ; 
                                assign mask_t_w[1] = mask_w[4] ; 
                                assign mask_t_w[5] = mask_w[5] ; 
                                assign mask_t_w[9] = mask_w[6] ; 
                                assign mask_t_w[13] = mask_w[7] ; 
                                assign mask_t_w[2] = mask_w[8] ; 
                                assign mask_t_w[6] = mask_w[9] ; 
                                assign mask_t_w[10] = mask_w[10] ; 
                                assign mask_t_w[14] = mask_w[11] ; 
                                assign mask_t_w[3] = mask_w[12] ; 
                                assign mask_t_w[7] = mask_w[13] ; 
                                assign mask_t_w[11] = mask_w[14] ; 
                                assign mask_t_w[15] = mask_w[15] ; 
                            end
                        else
                            begin : genblk2
                                assign mask_t_w[0] = mask_w[0] ; 
                                assign mask_t_w[8] = mask_w[1] ; 
                                assign mask_t_w[1] = mask_w[2] ; 
                                assign mask_t_w[9] = mask_w[3] ; 
                                assign mask_t_w[2] = mask_w[4] ; 
                                assign mask_t_w[10] = mask_w[5] ; 
                                assign mask_t_w[3] = mask_w[6] ; 
                                assign mask_t_w[11] = mask_w[7] ; 
                                assign mask_t_w[4] = mask_w[8] ; 
                                assign mask_t_w[12] = mask_w[9] ; 
                                assign mask_t_w[5] = mask_w[10] ; 
                                assign mask_t_w[13] = mask_w[11] ; 
                                assign mask_t_w[6] = mask_w[12] ; 
                                assign mask_t_w[14] = mask_w[13] ; 
                                assign mask_t_w[7] = mask_w[14] ; 
                                assign mask_t_w[15] = mask_w[15] ; 
                            end
                if ((ADDR_WIDTH_R < 11)) 
                    begin: genblk3
                        assign raddr_w[10:ADDR_WIDTH_R] = {(11 - ADDR_WIDTH_R){1'b0}} ; 
                    end
                if ((ADDR_WIDTH_W < 11)) 
                    begin: genblk4
                        assign waddr_w[10:ADDR_WIDTH_W] = {(11 - ADDR_WIDTH_W){1'b0}} ; 
                    end
                if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 16))) 
                    begin : genblk5
                        assign wdata_w = wr_data_i ; 
                        assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                        assign raddr_w[(ADDR_WIDTH_R - 1):0] = rd_addr_i ; 
                        assign rd_data_w = rdata_w ; 
                    end
                else
                    if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 8))) 
                        begin : genblk5
                            assign wdata_w[0] = wr_data_i[0] ; 
                            assign wdata_w[2] = wr_data_i[1] ; 
                            assign wdata_w[4] = wr_data_i[2] ; 
                            assign wdata_w[6] = wr_data_i[3] ; 
                            assign wdata_w[8] = wr_data_i[4] ; 
                            assign wdata_w[10] = wr_data_i[5] ; 
                            assign wdata_w[12] = wr_data_i[6] ; 
                            assign wdata_w[14] = wr_data_i[7] ; 
                            assign wdata_w[1] = wr_data_i[8] ; 
                            assign wdata_w[3] = wr_data_i[9] ; 
                            assign wdata_w[5] = wr_data_i[10] ; 
                            assign wdata_w[7] = wr_data_i[11] ; 
                            assign wdata_w[9] = wr_data_i[12] ; 
                            assign wdata_w[11] = wr_data_i[13] ; 
                            assign wdata_w[13] = wr_data_i[14] ; 
                            assign wdata_w[15] = wr_data_i[15] ; 
                            assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                            assign raddr_w = {rd_addr_i[0],
                                        rd_addr_i[(ADDR_WIDTH_R - 1):1]} ; 
                            assign rd_data_w[7] = rdata_w[14] ; 
                            assign rd_data_w[6] = rdata_w[12] ; 
                            assign rd_data_w[5] = rdata_w[10] ; 
                            assign rd_data_w[4] = rdata_w[8] ; 
                            assign rd_data_w[3] = rdata_w[6] ; 
                            assign rd_data_w[2] = rdata_w[4] ; 
                            assign rd_data_w[1] = rdata_w[2] ; 
                            assign rd_data_w[0] = rdata_w[0] ; 
                        end
                    else
                        if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 4))) 
                            begin : genblk5
                                assign wdata_w[0] = wr_data_i[0] ; 
                                assign wdata_w[4] = wr_data_i[1] ; 
                                assign wdata_w[8] = wr_data_i[2] ; 
                                assign wdata_w[12] = wr_data_i[3] ; 
                                assign wdata_w[1] = wr_data_i[4] ; 
                                assign wdata_w[5] = wr_data_i[5] ; 
                                assign wdata_w[9] = wr_data_i[6] ; 
                                assign wdata_w[13] = wr_data_i[7] ; 
                                assign wdata_w[2] = wr_data_i[8] ; 
                                assign wdata_w[6] = wr_data_i[9] ; 
                                assign wdata_w[10] = wr_data_i[10] ; 
                                assign wdata_w[14] = wr_data_i[11] ; 
                                assign wdata_w[3] = wr_data_i[12] ; 
                                assign wdata_w[7] = wr_data_i[13] ; 
                                assign wdata_w[11] = wr_data_i[14] ; 
                                assign wdata_w[15] = wr_data_i[15] ; 
                                assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                assign raddr_w = {rd_addr_i[1:0],
                                            rd_addr_i[(ADDR_WIDTH_R - 1):2]} ; 
                                assign rd_data_w[3] = rdata_w[13] ; 
                                assign rd_data_w[2] = rdata_w[9] ; 
                                assign rd_data_w[1] = rdata_w[5] ; 
                                assign rd_data_w[0] = rdata_w[1] ; 
                            end
                        else
                            if (((DATA_WIDTH_W == 16) && (DATA_WIDTH_R == 2))) 
                                begin : genblk5
                                    assign wdata_w[0] = wr_data_i[0] ; 
                                    assign wdata_w[8] = wr_data_i[1] ; 
                                    assign wdata_w[1] = wr_data_i[2] ; 
                                    assign wdata_w[9] = wr_data_i[3] ; 
                                    assign wdata_w[2] = wr_data_i[4] ; 
                                    assign wdata_w[10] = wr_data_i[5] ; 
                                    assign wdata_w[3] = wr_data_i[6] ; 
                                    assign wdata_w[11] = wr_data_i[7] ; 
                                    assign wdata_w[4] = wr_data_i[8] ; 
                                    assign wdata_w[12] = wr_data_i[9] ; 
                                    assign wdata_w[5] = wr_data_i[10] ; 
                                    assign wdata_w[13] = wr_data_i[11] ; 
                                    assign wdata_w[6] = wr_data_i[12] ; 
                                    assign wdata_w[14] = wr_data_i[13] ; 
                                    assign wdata_w[7] = wr_data_i[14] ; 
                                    assign wdata_w[15] = wr_data_i[15] ; 
                                    assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                    assign raddr_w = {rd_addr_i[2:0],
                                                rd_addr_i[(ADDR_WIDTH_R - 1):3]} ; 
                                    assign rd_data_w[1] = rdata_w[11] ; 
                                    assign rd_data_w[0] = rdata_w[3] ; 
                                end
                            else
                                if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 16))) 
                                    begin : genblk5
                                        assign wdata_w[0] = wr_data_i[0] ; 
                                        assign wdata_w[2] = wr_data_i[1] ; 
                                        assign wdata_w[4] = wr_data_i[2] ; 
                                        assign wdata_w[6] = wr_data_i[3] ; 
                                        assign wdata_w[8] = wr_data_i[4] ; 
                                        assign wdata_w[10] = wr_data_i[5] ; 
                                        assign wdata_w[12] = wr_data_i[6] ; 
                                        assign wdata_w[14] = wr_data_i[7] ; 
                                        assign wdata_w[1] = 1'b0 ; 
                                        assign wdata_w[3] = 1'b0 ; 
                                        assign wdata_w[5] = 1'b0 ; 
                                        assign wdata_w[7] = 1'b0 ; 
                                        assign wdata_w[9] = 1'b0 ; 
                                        assign wdata_w[11] = 1'b0 ; 
                                        assign wdata_w[13] = 1'b0 ; 
                                        assign wdata_w[15] = 1'b0 ; 
                                        assign waddr_w = {wr_addr_i[0],
                                                    wr_addr_i[(ADDR_WIDTH_W - 1):1]} ; 
                                        assign raddr_w = rd_addr_i ; 
                                        assign rd_data_w[0] = rdata_w[0] ; 
                                        assign rd_data_w[1] = rdata_w[2] ; 
                                        assign rd_data_w[2] = rdata_w[4] ; 
                                        assign rd_data_w[3] = rdata_w[6] ; 
                                        assign rd_data_w[4] = rdata_w[8] ; 
                                        assign rd_data_w[5] = rdata_w[10] ; 
                                        assign rd_data_w[6] = rdata_w[12] ; 
                                        assign rd_data_w[7] = rdata_w[14] ; 
                                        assign rd_data_w[8] = rdata_w[1] ; 
                                        assign rd_data_w[9] = rdata_w[3] ; 
                                        assign rd_data_w[10] = rdata_w[5] ; 
                                        assign rd_data_w[11] = rdata_w[7] ; 
                                        assign rd_data_w[12] = rdata_w[9] ; 
                                        assign rd_data_w[13] = rdata_w[11] ; 
                                        assign rd_data_w[14] = rdata_w[13] ; 
                                        assign rd_data_w[15] = rdata_w[15] ; 
                                    end
                                else
                                    if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 8))) 
                                        begin : genblk5
                                            assign wdata_w[0] = wr_data_i[0] ; 
                                            assign wdata_w[2] = wr_data_i[1] ; 
                                            assign wdata_w[4] = wr_data_i[2] ; 
                                            assign wdata_w[6] = wr_data_i[3] ; 
                                            assign wdata_w[8] = wr_data_i[4] ; 
                                            assign wdata_w[10] = wr_data_i[5] ; 
                                            assign wdata_w[12] = wr_data_i[6] ; 
                                            assign wdata_w[14] = wr_data_i[7] ; 
                                            assign wdata_w[1] = 1'b0 ; 
                                            assign wdata_w[3] = 1'b0 ; 
                                            assign wdata_w[5] = 1'b0 ; 
                                            assign wdata_w[7] = 1'b0 ; 
                                            assign wdata_w[9] = 1'b0 ; 
                                            assign wdata_w[11] = 1'b0 ; 
                                            assign wdata_w[13] = 1'b0 ; 
                                            assign wdata_w[15] = 1'b0 ; 
                                            assign waddr_w = {wr_addr_i} ; 
                                            assign raddr_w = {rd_addr_i} ; 
                                            assign rd_data_w[0] = rdata_w[0] ; 
                                            assign rd_data_w[1] = rdata_w[2] ; 
                                            assign rd_data_w[2] = rdata_w[4] ; 
                                            assign rd_data_w[3] = rdata_w[6] ; 
                                            assign rd_data_w[4] = rdata_w[8] ; 
                                            assign rd_data_w[5] = rdata_w[10] ; 
                                            assign rd_data_w[6] = rdata_w[12] ; 
                                            assign rd_data_w[7] = rdata_w[14] ; 
                                        end
                                    else
                                        if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 4))) 
                                            begin : genblk5
                                                assign wdata_w[0] = wr_data_i[0] ; 
                                                assign wdata_w[4] = wr_data_i[1] ; 
                                                assign wdata_w[8] = wr_data_i[2] ; 
                                                assign wdata_w[12] = wr_data_i[3] ; 
                                                assign wdata_w[2] = wr_data_i[4] ; 
                                                assign wdata_w[6] = wr_data_i[5] ; 
                                                assign wdata_w[10] = wr_data_i[6] ; 
                                                assign wdata_w[14] = wr_data_i[7] ; 
                                                assign wdata_w[1] = 1'b0 ; 
                                                assign wdata_w[3] = 1'b0 ; 
                                                assign wdata_w[5] = 1'b0 ; 
                                                assign wdata_w[7] = 1'b0 ; 
                                                assign wdata_w[9] = 1'b0 ; 
                                                assign wdata_w[11] = 1'b0 ; 
                                                assign wdata_w[13] = 1'b0 ; 
                                                assign wdata_w[15] = 1'b0 ; 
                                                assign waddr_w = {wr_addr_i} ; 
                                                assign raddr_w = {rd_addr_i[0],
                                                            rd_addr_i[(ADDR_WIDTH_R - 1):1]} ; 
                                                assign rd_data_w[0] = rdata_w[1] ; 
                                                assign rd_data_w[1] = rdata_w[5] ; 
                                                assign rd_data_w[2] = rdata_w[9] ; 
                                                assign rd_data_w[3] = rdata_w[13] ; 
                                            end
                                        else
                                            if (((DATA_WIDTH_W == 8) && (DATA_WIDTH_R == 2))) 
                                                begin : genblk5
                                                    assign wdata_w[0] = wr_data_i[0] ; 
                                                    assign wdata_w[8] = wr_data_i[1] ; 
                                                    assign wdata_w[2] = wr_data_i[2] ; 
                                                    assign wdata_w[10] = wr_data_i[3] ; 
                                                    assign wdata_w[4] = wr_data_i[4] ; 
                                                    assign wdata_w[12] = wr_data_i[5] ; 
                                                    assign wdata_w[6] = wr_data_i[6] ; 
                                                    assign wdata_w[14] = wr_data_i[7] ; 
                                                    assign wdata_w[1] = 1'b0 ; 
                                                    assign wdata_w[3] = 1'b0 ; 
                                                    assign wdata_w[5] = 1'b0 ; 
                                                    assign wdata_w[7] = 1'b0 ; 
                                                    assign wdata_w[9] = 1'b0 ; 
                                                    assign wdata_w[11] = 1'b0 ; 
                                                    assign wdata_w[13] = 1'b0 ; 
                                                    assign wdata_w[15] = 1'b0 ; 
                                                    assign waddr_w = {wr_addr_i} ; 
                                                    assign raddr_w = {rd_addr_i[1:0],
                                                                rd_addr_i[(ADDR_WIDTH_R - 1):2]} ; 
                                                    assign rd_data_w[1] = rdata_w[11] ; 
                                                    assign rd_data_w[0] = rdata_w[3] ; 
                                                end
                                            else
                                                if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 16))) 
                                                    begin : genblk5
                                                        assign wdata_w[1] = wr_data_i[0] ; 
                                                        assign wdata_w[5] = wr_data_i[1] ; 
                                                        assign wdata_w[9] = wr_data_i[2] ; 
                                                        assign wdata_w[13] = wr_data_i[3] ; 
                                                        assign wdata_w[0] = 1'b0 ; 
                                                        assign wdata_w[4:2] = 3'b000 ; 
                                                        assign wdata_w[8:6] = 3'b000 ; 
                                                        assign wdata_w[12:10] = 3'b000 ; 
                                                        assign wdata_w[15:14] = 2'b00 ; 
                                                        assign waddr_w = {wr_addr_i[1:0],
                                                                    wr_addr_i[(ADDR_WIDTH_W - 1):2]} ; 
                                                        assign raddr_w = rd_addr_i ; 
                                                        assign rd_data_w[0] = rdata_w[0] ; 
                                                        assign rd_data_w[1] = rdata_w[4] ; 
                                                        assign rd_data_w[2] = rdata_w[8] ; 
                                                        assign rd_data_w[3] = rdata_w[12] ; 
                                                        assign rd_data_w[4] = rdata_w[1] ; 
                                                        assign rd_data_w[5] = rdata_w[5] ; 
                                                        assign rd_data_w[6] = rdata_w[9] ; 
                                                        assign rd_data_w[7] = rdata_w[13] ; 
                                                        assign rd_data_w[8] = rdata_w[2] ; 
                                                        assign rd_data_w[9] = rdata_w[6] ; 
                                                        assign rd_data_w[10] = rdata_w[10] ; 
                                                        assign rd_data_w[11] = rdata_w[14] ; 
                                                        assign rd_data_w[12] = rdata_w[3] ; 
                                                        assign rd_data_w[13] = rdata_w[7] ; 
                                                        assign rd_data_w[14] = rdata_w[11] ; 
                                                        assign rd_data_w[15] = rdata_w[15] ; 
                                                    end
                                                else
                                                    if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 8))) 
                                                        begin : genblk5
                                                            assign wdata_w[1] = wr_data_i[0] ; 
                                                            assign wdata_w[5] = wr_data_i[1] ; 
                                                            assign wdata_w[9] = wr_data_i[2] ; 
                                                            assign wdata_w[13] = wr_data_i[3] ; 
                                                            assign wdata_w[0] = 1'b0 ; 
                                                            assign wdata_w[4:2] = 3'b000 ; 
                                                            assign wdata_w[8:6] = 3'b000 ; 
                                                            assign wdata_w[12:10] = 3'b000 ; 
                                                            assign wdata_w[15:14] = 2'b00 ; 
                                                            assign waddr_w = {wr_addr_i[0],
                                                                        wr_addr_i[(ADDR_WIDTH_W - 1):1]} ; 
                                                            assign raddr_w = rd_addr_i ; 
                                                            assign rd_data_w[0] = rdata_w[0] ; 
                                                            assign rd_data_w[1] = rdata_w[4] ; 
                                                            assign rd_data_w[2] = rdata_w[8] ; 
                                                            assign rd_data_w[3] = rdata_w[12] ; 
                                                            assign rd_data_w[4] = rdata_w[2] ; 
                                                            assign rd_data_w[5] = rdata_w[6] ; 
                                                            assign rd_data_w[6] = rdata_w[10] ; 
                                                            assign rd_data_w[7] = rdata_w[14] ; 
                                                        end
                                                    else
                                                        if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 4))) 
                                                            begin : genblk5
                                                                assign wdata_w[1] = wr_data_i[0] ; 
                                                                assign wdata_w[5] = wr_data_i[1] ; 
                                                                assign wdata_w[9] = wr_data_i[2] ; 
                                                                assign wdata_w[13] = wr_data_i[3] ; 
                                                                assign wdata_w[0] = 1'b0 ; 
                                                                assign wdata_w[4:2] = 3'b000 ; 
                                                                assign wdata_w[8:6] = 3'b000 ; 
                                                                assign wdata_w[12:10] = 3'b000 ; 
                                                                assign wdata_w[15:14] = 2'b00 ; 
                                                                assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                                                assign raddr_w[(ADDR_WIDTH_R - 1):0] = rd_addr_i ; 
                                                                assign rd_data_w[0] = rdata_w[1] ; 
                                                                assign rd_data_w[1] = rdata_w[5] ; 
                                                                assign rd_data_w[2] = rdata_w[9] ; 
                                                                assign rd_data_w[3] = rdata_w[13] ; 
                                                            end
                                                        else
                                                            if (((DATA_WIDTH_W == 4) && (DATA_WIDTH_R == 2))) 
                                                                begin : genblk5
                                                                    assign wdata_w[1] = wr_data_i[0] ; 
                                                                    assign wdata_w[9] = wr_data_i[1] ; 
                                                                    assign wdata_w[5] = wr_data_i[2] ; 
                                                                    assign wdata_w[13] = wr_data_i[3] ; 
                                                                    assign wdata_w[0] = 1'b0 ; 
                                                                    assign wdata_w[4:2] = 3'b000 ; 
                                                                    assign wdata_w[8:6] = 3'b000 ; 
                                                                    assign wdata_w[12:10] = 3'b000 ; 
                                                                    assign wdata_w[15:14] = 2'b00 ; 
                                                                    assign waddr_w[(ADDR_WIDTH_W - 1):0] = wr_addr_i ; 
                                                                    assign raddr_w = {rd_addr_i[0],
                                                                                rd_addr_i[(ADDR_WIDTH_R - 1):1]} ; 
                                                                    assign rd_data_w[1] = rdata_w[11] ; 
                                                                    assign rd_data_w[0] = rdata_w[3] ; 
                                                                end
                                                            else
                                                                if (((DATA_WIDTH_W == 2) && (DATA_WIDTH_R == 16))) 
                                                                    begin : genblk5
                                                                        assign wdata_w[11] = wr_data_i[1] ; 
                                                                        assign wdata_w[3] = wr_data_i[0] ; 
                                                                        assign wdata_w[2:0] = 3'b000 ; 
                                                                        assign wdata_w[10:4] = 7'h00 ; 
                                                                        assign wdata_w[15:12] = 4'h0 ; 
                                                                        assign waddr_w = {wr_addr_i[2:0],
                                                                                wr_addr_i[(ADDR_WIDTH_W - 1):3]} ; 
                                                                        assign raddr_w = rd_addr_i ; 
                                                                        assign rd_data_w[0] = rdata_w[0] ; 
                                                                        assign rd_data_w[1] = rdata_w[8] ; 
                                                                        assign rd_data_w[2] = rdata_w[1] ; 
                                                                        assign rd_data_w[3] = rdata_w[9] ; 
                                                                        assign rd_data_w[4] = rdata_w[2] ; 
                                                                        assign rd_data_w[5] = rdata_w[10] ; 
                                                                        assign rd_data_w[6] = rdata_w[3] ; 
                                                                        assign rd_data_w[7] = rdata_w[11] ; 
                                                                        assign rd_data_w[8] = rdata_w[4] ; 
                                                                        assign rd_data_w[9] = rdata_w[12] ; 
                                                                        assign rd_data_w[10] = rdata_w[5] ; 
                                                                        assign rd_data_w[11] = rdata_w[13] ; 
                                                                        assign rd_data_w[12] = rdata_w[6] ; 
                                                                        assign rd_data_w[13] = rdata_w[14] ; 
                                                                        assign rd_data_w[14] = rdata_w[7] ; 
                                                                        assign rd_data_w[15] = rdata_w[15] ; 
                                                                    end
                                                                else
                                                                    if (((DATA_WIDTH_W == 2) && (DATA_WIDTH_R == 8))) 
                                                                        begin : genblk5
                                                                            assign wdata_w[11] = wr_data_i[1] ; 
                                                                            assign wdata_w[3] = wr_data_i[0] ; 
                                                                            assign wdata_w[2:0] = 3'b000 ; 
                                                                            assign wdata_w[10:4] = 7'h00 ; 
                                                                            assign wdata_w[15:12] = 4'h0 ; 
                                                                            assign waddr_w = {wr_addr_i[1:0],
                                                                                wr_addr_i[(ADDR_WIDTH_W - 1):2]} ; 
                                                                            assign raddr_w = rd_addr_i ; 
                                                                            assign rd_data_w[0] = rdata_w[0] ; 
                                                                            assign rd_data_w[1] = rdata_w[8] ; 
                                                                            assign rd_data_w[2] = rdata_w[2] ; 
                                                                            assign rd_data_w[3] = rdata_w[10] ; 
                                                                            assign rd_data_w[4] = rdata_w[4] ; 
                                                                            assign rd_data_w[5] = rdata_w[12] ; 
                                                                            assign rd_data_w[6] = rdata_w[6] ; 
                                                                            assign rd_data_w[7] = rdata_w[14] ; 
                                                                        end
                                                                    else
                                                                        if (((DATA_WIDTH_W == 2) && (DATA_WIDTH_R == 4))) 
                                                                            begin : genblk5
                                                                                assign wdata_w[11] = wr_data_i[1] ; 
                                                                                assign wdata_w[3] = wr_data_i[0] ; 
                                                                                assign wdata_w[2:0] = 3'b000 ; 
                                                                                assign wdata_w[10:4] = 7'h00 ; 
                                                                                assign wdata_w[15:12] = 4'h0 ; 
                                                                                assign waddr_w = {wr_addr_i[0],
                                                                                wr_addr_i[(ADDR_WIDTH_W - 1):1]} ; 
                                                                                assign raddr_w = rd_addr_i ; 
                                                                                assign rd_data_w[0] = rdata_w[1] ; 
                                                                                assign rd_data_w[1] = rdata_w[9] ; 
                                                                                assign rd_data_w[2] = rdata_w[5] ; 
                                                                                assign rd_data_w[3] = rdata_w[13] ; 
                                                                            end
                                                                        else
                                                                            begin : genblk5
                                                                                assign wdata_w[11] = wr_data_i[1] ; 
                                                                                assign wdata_w[3] = wr_data_i[0] ; 
                                                                                assign wdata_w[2:0] = 3'b000 ; 
                                                                                assign wdata_w[10:4] = 7'h00 ; 
                                                                                assign wdata_w[15:12] = 4'h0 ; 
                                                                                assign waddr_w = wr_addr_i ; 
                                                                                assign raddr_w = rd_addr_i ; 
                                                                                assign rd_data_w[0] = rdata_w[3] ; 
                                                                                assign rd_data_w[1] = rdata_w[11] ; 
                                                                            end
                wire t_wr_en_i = ((BYTE_ENABLE == 0) ? wr_en_i : ((BYTE_WIDTH > 1) ? wr_en_i : (wr_en_i & ben_i))) ; 
                PDP4K u_mem0 (.ADR(raddr_w), 
                            .ADW(waddr_w), 
                            .DI(wdata_w), 
                            .MASK_N(mask_t_w), 
                            .CER(rd_clk_en_i), 
                            .CKR(rd_clk_i), 
                            .RE(rd_en_i), 
                            .CEW(wr_clk_en_i), 
                            .CKW(wr_clk_i), 
                            .WE(t_wr_en_i), 
                            .DO(rdata_w)) ; 
                localparam R = ((DATA_WIDTH_R == 16) ? "16" : ((DATA_WIDTH_R == 8) ? "8" : ((DATA_WIDTH_R == 4) ? "4" : "2"))) ; 
                localparam W = ((DATA_WIDTH_W == 16) ? "16" : ((DATA_WIDTH_W == 8) ? "8" : ((DATA_WIDTH_W == 4) ? "4" : "2"))) ; 
                localparam X_T0 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T1 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T2 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T3 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T4 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T5 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T6 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T7 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T8 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_T9 = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TA = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TB = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TC = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TD = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TE = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X_TF = ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x0000000000000000000000000000000000000000000000000000000000000000") ; 
                localparam X0 = ((INIT_MODE == "mem_file") ? INIT_VALUE_00 : X_T0) ; 
                localparam X1 = ((INIT_MODE == "mem_file") ? INIT_VALUE_01 : X_T1) ; 
                localparam X2 = ((INIT_MODE == "mem_file") ? INIT_VALUE_02 : X_T2) ; 
                localparam X3 = ((INIT_MODE == "mem_file") ? INIT_VALUE_03 : X_T3) ; 
                localparam X4 = ((INIT_MODE == "mem_file") ? INIT_VALUE_04 : X_T4) ; 
                localparam X5 = ((INIT_MODE == "mem_file") ? INIT_VALUE_05 : X_T5) ; 
                localparam X6 = ((INIT_MODE == "mem_file") ? INIT_VALUE_06 : X_T6) ; 
                localparam X7 = ((INIT_MODE == "mem_file") ? INIT_VALUE_07 : X_T7) ; 
                localparam X8 = ((INIT_MODE == "mem_file") ? INIT_VALUE_08 : X_T8) ; 
                localparam X9 = ((INIT_MODE == "mem_file") ? INIT_VALUE_09 : X_T9) ; 
                localparam XA = ((INIT_MODE == "mem_file") ? INIT_VALUE_0A : X_TA) ; 
                localparam XB = ((INIT_MODE == "mem_file") ? INIT_VALUE_0B : X_TB) ; 
                localparam XC = ((INIT_MODE == "mem_file") ? INIT_VALUE_0C : X_TC) ; 
                localparam XD = ((INIT_MODE == "mem_file") ? INIT_VALUE_0D : X_TD) ; 
                localparam XE = ((INIT_MODE == "mem_file") ? INIT_VALUE_0E : X_TE) ; 
                localparam XF = ((INIT_MODE == "mem_file") ? INIT_VALUE_0F : X_TF) ; 
                defparam u_mem0.DATA_WIDTH_W = W ; 
                defparam u_mem0.DATA_WIDTH_R = R ; 
                defparam u_mem0.INITVAL_0 = X0 ; 
                defparam u_mem0.INITVAL_1 = X1 ; 
                defparam u_mem0.INITVAL_2 = X2 ; 
                defparam u_mem0.INITVAL_3 = X3 ; 
                defparam u_mem0.INITVAL_4 = X4 ; 
                defparam u_mem0.INITVAL_5 = X5 ; 
                defparam u_mem0.INITVAL_6 = X6 ; 
                defparam u_mem0.INITVAL_7 = X7 ; 
                defparam u_mem0.INITVAL_8 = X8 ; 
                defparam u_mem0.INITVAL_9 = X9 ; 
                defparam u_mem0.INITVAL_A = XA ; 
                defparam u_mem0.INITVAL_B = XB ; 
                defparam u_mem0.INITVAL_C = XC ; 
                defparam u_mem0.INITVAL_D = XD ; 
                defparam u_mem0.INITVAL_E = XE ; 
                defparam u_mem0.INITVAL_F = XF ; 
                if ((REGMODE == "reg")) 
                    begin : genblk6
                        reg [(DATA_WIDTH_R - 1):0] rd_buff_r ; 
                        assign rd_data_o = rd_buff_r ; 
                        if ((RESETMODE == "sync")) 
                            begin : genblk1
                                always
                                    @(posedge rd_clk_i)
                                    begin
                                        if ((rst_i == 1'b1)) 
                                            begin
                                                rd_buff_r <=  'h0 ;
                                            end
                                        else
                                            begin
                                                if ((rd_out_clk_en_i == 1'b1)) 
                                                    begin
                                                        rd_buff_r <=  rd_data_w ;
                                                    end
                                            end
                                    end
                            end
                        else
                            if ((RESET_RELEASE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if ((rst_i == 1'b1)) 
                                                begin
                                                    rd_buff_r <=  'h0 ;
                                                end
                                            else
                                                begin
                                                    if ((rd_out_clk_en_i == 1'b1)) 
                                                        begin
                                                            rd_buff_r <=  rd_data_w ;
                                                        end
                                                end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(*)
                                        begin
                                            if ((rst_i == 1'b1)) 
                                                begin
                                                    rd_buff_r = 'h0 ;
                                                end
                                            else
                                                begin
                                                    if ((rd_out_clk_en_i == 1'b1)) 
                                                        begin
                                                            rd_buff_r = rd_data_w ;
                                                        end
                                                end
                                        end
                                end
                    end
                else
                    begin : genblk6
                        assign rd_data_o = rd_data_w ; 
                    end
            end
        else
            if ((FAMILY_CODE == _FCODE_LIFCL_)) 
                begin : LIFCL_MEM
                    localparam OUTREG = ((REGMODE == "reg") ? ((OUTPUT_CLK_EN == 0) ? "USED" : "BYPASSED") : "BYPASSED") ; 
                    localparam TRUE_CSW = ((CSDECODE_W == 0) ? "000" : ((CSDECODE_W == 1) ? "001" : ((CSDECODE_W == 2) ? "010" : ((CSDECODE_W == 3) ? "011" : ((CSDECODE_W == 4) ? "100" : ((CSDECODE_W == 5) ? "101" : ((CSDECODE_W == 6) ? "110" : "111"))))))) ; 
                    localparam TRUE_CSR = ((CSDECODE_R == 0) ? "000" : ((CSDECODE_R == 1) ? "001" : ((CSDECODE_R == 2) ? "010" : ((CSDECODE_R == 3) ? "011" : ((CSDECODE_R == 4) ? "100" : ((CSDECODE_R == 5) ? "101" : ((CSDECODE_R == 6) ? "110" : "111"))))))) ; 
                    localparam DW_W = (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32)) ? "X36" : (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16)) ? "X18" : (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8)) ? "X9" : ((DATA_WIDTH_W == 4) ? "X4" : ((DATA_WIDTH_W == 2) ? "X2" : "X1"))))) ; 
                    localparam DW_R = (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32)) ? "X36" : (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16)) ? "X18" : (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8)) ? "X9" : ((DATA_WIDTH_R == 4) ? "X4" : ((DATA_WIDTH_R == 2) ? "X2" : "X1"))))) ; 
                    localparam TRUE_RST = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
                    localparam TRUE_RST_REL = ((RESET_RELEASE == "sync") ? "SYNC" : "ASYNC") ; 
                    localparam TRUE_ECC = (((ECC_ENABLE == 1) && (DATA_WIDTH_W == 32)) ? "ENABLED" : "DISABLED") ; 
                    localparam TRUE_GSR = ((GSR == "disabled") ? "DISABLED" : "ENABLED") ; 
                    wire [13:0] w_addr_w ; 
                    wire [13:0] r_addr_w ; 
                    wire [35:0] w_data_w ; 
                    wire [35:0] r_data_w ; 
                    wire [(DATA_WIDTH_R - 1):0] rd_data_w ; 
                    if (((REGMODE == "noreg") || (OUTPUT_CLK_EN == 0))) 
                        begin : genblk1
                            assign rd_data_o = rd_data_w ; 
                        end
                    else
                        begin : genblk1
                            reg [(DATA_WIDTH_R - 1):0] rd_data_r ; 
                            if ((RESETMODE == "sync")) 
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i)
                                        begin
                                            if ((rst_i == 1'b1)) 
                                                begin
                                                    rd_data_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                end
                                            else
                                                if ((rd_out_clk_en_i == 1'b1)) 
                                                    begin
                                                        rd_data_r <=  rd_data_w ;
                                                    end
                                        end
                                end
                            else
                                begin : genblk1
                                    always
                                        @(posedge rd_clk_i or 
                                            posedge rst_i)
                                        begin
                                            if ((rst_i == 1'b1)) 
                                                begin
                                                    rd_data_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                end
                                            else
                                                if ((rd_out_clk_en_i == 1'b1)) 
                                                    begin
                                                        rd_data_r <=  rd_data_w ;
                                                    end
                                        end
                                end
                            assign rd_data_o = rd_data_r ; 
                        end
                    if (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32))) 
                        begin : genblk2
                            assign w_addr_w[13:5] = wr_addr_i ; 
                            assign w_addr_w[4] = 1'b1 ; 
                            assign w_addr_w[3:0] = ((BYTE_ENABLE == 1) ? ben_i : 4'b1111) ; 
                            if ((DATA_WIDTH_W == 36)) 
                                begin : genblk1
                                    assign w_data_w = wr_data_i ; 
                                end
                            else
                                begin : genblk1
                                    assign w_data_w[35] = 1'b0 ; 
                                    assign w_data_w[26] = 1'b0 ; 
                                    assign w_data_w[17] = 1'b0 ; 
                                    assign w_data_w[8] = 1'b0 ; 
                                    assign w_data_w[34:27] = wr_data_i[31:24] ; 
                                    assign w_data_w[25:18] = wr_data_i[23:16] ; 
                                    assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                    assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                end
                        end
                    else
                        if (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16))) 
                            begin : genblk2
                                assign w_addr_w[13:5] = wr_addr_i[9:1] ; 
                                assign w_addr_w[4] = wr_addr_i[0] ; 
                                assign w_addr_w[3:2] = 2'b11 ; 
                                assign w_addr_w[1:0] = ((BYTE_ENABLE == 1) ? ben_i : 2'b11) ; 
                                assign w_data_w[35:18] = {18{1'b0}} ; 
                                if ((DATA_WIDTH_W == 18)) 
                                    begin : genblk1
                                        assign w_data_w[17:0] = wr_data_i ; 
                                    end
                                else
                                    begin : genblk1
                                        assign w_data_w[17] = 1'b0 ; 
                                        assign w_data_w[8] = 1'b0 ; 
                                        assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                        assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8))) 
                                begin : genblk2
                                    assign w_addr_w[13:5] = wr_addr_i[10:2] ; 
                                    assign w_addr_w[4] = wr_addr_i[1] ; 
                                    assign w_addr_w[3] = wr_addr_i[0] ; 
                                    assign w_addr_w[2:0] = 3'b111 ; 
                                    assign w_data_w[35:9] = {27{1'b0}} ; 
                                    if ((DATA_WIDTH_W == 9)) 
                                        begin: genblk1
                                            assign w_data_w[8:0] = wr_data_i ; 
                                        end
                                    else
                                        begin: genblk1
                                            assign w_data_w[8:0] = {1'b0,
                                                        wr_data_i} ; 
                                        end
                                end
                            else
                                if ((DATA_WIDTH_W == 4)) 
                                    begin : genblk2
                                        assign w_addr_w[13:5] = wr_addr_i[11:3] ; 
                                        assign w_addr_w[4] = wr_addr_i[2] ; 
                                        assign w_addr_w[3] = wr_addr_i[1] ; 
                                        assign w_addr_w[2] = wr_addr_i[0] ; 
                                        assign w_addr_w[1:0] = 2'b11 ; 
                                        assign w_data_w[35:4] = {32{1'b0}} ; 
                                        assign w_data_w[3:0] = wr_data_i ; 
                                    end
                                else
                                    if ((DATA_WIDTH_W == 2)) 
                                        begin : genblk2
                                            assign w_addr_w[13:5] = wr_addr_i[12:4] ; 
                                            assign w_addr_w[4] = wr_addr_i[3] ; 
                                            assign w_addr_w[3] = wr_addr_i[2] ; 
                                            assign w_addr_w[2] = wr_addr_i[1] ; 
                                            assign w_addr_w[1] = wr_addr_i[0] ; 
                                            assign w_addr_w[0] = 1'b1 ; 
                                            assign w_data_w[35:2] = {34{1'b0}} ; 
                                            assign w_data_w[1:0] = wr_data_i ; 
                                        end
                                    else
                                        begin : genblk2
                                            assign w_addr_w[13:5] = wr_addr_i[13:5] ; 
                                            assign w_addr_w[4] = wr_addr_i[4] ; 
                                            assign w_addr_w[3] = wr_addr_i[3] ; 
                                            assign w_addr_w[2] = wr_addr_i[2] ; 
                                            assign w_addr_w[1] = wr_addr_i[1] ; 
                                            assign w_addr_w[0] = wr_addr_i[0] ; 
                                            assign w_data_w[35:1] = {35{1'b0}} ; 
                                            assign w_data_w[0] = wr_data_i ; 
                                        end
                    if (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32))) 
                        begin : genblk3
                            assign r_addr_w[13:5] = rd_addr_i ; 
                            assign r_addr_w[4] = 1'b1 ; 
                            assign r_addr_w[3:0] = 4'b1111 ; 
                            if ((DATA_WIDTH_R == 36)) 
                                begin : genblk1
                                    assign rd_data_w = r_data_w ; 
                                end
                            else
                                begin : genblk1
                                    assign rd_data_w[31:24] = r_data_w[34:27] ; 
                                    assign rd_data_w[23:16] = r_data_w[25:18] ; 
                                    assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                    assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                end
                        end
                    else
                        if (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16))) 
                            begin : genblk3
                                assign r_addr_w[13:5] = rd_addr_i[9:1] ; 
                                assign r_addr_w[4] = rd_addr_i[0] ; 
                                assign r_addr_w[3:0] = 4'b1111 ; 
                                if ((DATA_WIDTH_R == 18)) 
                                    begin : genblk1
                                        assign rd_data_w[17:0] = r_data_w[17:0] ; 
                                    end
                                else
                                    begin : genblk1
                                        assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                        assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8))) 
                                begin : genblk3
                                    assign r_addr_w[13:5] = rd_addr_i[10:2] ; 
                                    assign r_addr_w[4] = rd_addr_i[1] ; 
                                    assign r_addr_w[3] = rd_addr_i[0] ; 
                                    assign r_addr_w[2:0] = 3'b111 ; 
                                    if ((DATA_WIDTH_R == 9)) 
                                        begin: genblk1
                                            assign rd_data_w = r_data_w[8:0] ; 
                                        end
                                    else
                                        begin: genblk1
                                            assign rd_data_w = r_data_w[7:0] ; 
                                        end
                                end
                            else
                                if ((DATA_WIDTH_R == 4)) 
                                    begin : genblk3
                                        assign r_addr_w[13:5] = rd_addr_i[11:3] ; 
                                        assign r_addr_w[4] = rd_addr_i[2] ; 
                                        assign r_addr_w[3] = rd_addr_i[1] ; 
                                        assign r_addr_w[2] = rd_addr_i[0] ; 
                                        assign r_addr_w[1:0] = 2'b11 ; 
                                        assign rd_data_w = r_data_w[3:0] ; 
                                    end
                                else
                                    if ((DATA_WIDTH_R == 2)) 
                                        begin : genblk3
                                            assign r_addr_w[13:5] = rd_addr_i[12:4] ; 
                                            assign r_addr_w[4] = rd_addr_i[3] ; 
                                            assign r_addr_w[3] = rd_addr_i[2] ; 
                                            assign r_addr_w[2] = rd_addr_i[1] ; 
                                            assign r_addr_w[1] = rd_addr_i[0] ; 
                                            assign r_addr_w[0] = 1'b1 ; 
                                            assign rd_data_w = r_data_w[1:0] ; 
                                        end
                                    else
                                        begin : genblk3
                                            assign r_addr_w[13:5] = rd_addr_i[13:5] ; 
                                            assign r_addr_w[4] = rd_addr_i[4] ; 
                                            assign r_addr_w[3] = rd_addr_i[3] ; 
                                            assign r_addr_w[2] = rd_addr_i[2] ; 
                                            assign r_addr_w[1] = rd_addr_i[1] ; 
                                            assign r_addr_w[0] = rd_addr_i[0] ; 
                                            assign rd_data_w = r_data_w[0] ; 
                                        end
                    wire t_wr_en_i = ((BYTE_ENABLE == 0) ? wr_en_i : ((BYTE_WIDTH > 1) ? wr_en_i : (wr_en_i & ben_i))) ; 
                    wire t_rd_en_i = rd_en_i ; 
                    wire [35:0] DI = w_data_w ; 
                    wire [13:0] ADW = w_addr_w ; 
                    wire [13:0] ADR = r_addr_w ; 
                    wire CLKW = wr_clk_i ; 
                    wire CLKR = rd_clk_i ; 
                    wire CEW = wr_clk_en_i ; 
                    wire CER = rd_clk_en_i ; 
                    wire [2:0] CSW = {t_wr_en_i,
                                t_wr_en_i,
                                t_wr_en_i} ; 
                    wire [2:0] CSR = {t_rd_en_i,
                                t_rd_en_i,
                                t_rd_en_i} ; 
                    wire RST = rst_i ; 
                    wire [35:0] DO ; 
                    assign r_data_w = DO ; 
                    localparam MEM_TYPE = "EBR" ; 
                    localparam T_MEM_SIZE = {"[",
                                MEM_SIZE,
                                "]"} ; 
                    (* ECO_MEM_TYPE=MEM_TYPE, ECO_MEM_ID=MEM_ID, ECO_MEM_SIZE=T_MEM_SIZE, ECO_MEM_BLOCK_SIZE=BLOCK_SIZE, ECO_MEM_BLOCK_POS=BLOCK_POS *) PDP16K pdp16k (.DI(DI), 
                                .ADW(ADW), 
                                .ADR(ADR), 
                                .CLKW(CLKW), 
                                .CLKR(CLKR), 
                                .CEW(CEW), 
                                .CER(CER), 
                                .CSW(CSW), 
                                .CSR(CSR), 
                                .RST(RST), 
                                .DO(DO), 
                                .ONEBITERR(one_err_det_o), 
                                .TWOBITERR(two_err_det_o)) ; 
                    defparam pdp16k.DATA_WIDTH_W = DW_W ; 
                    defparam pdp16k.DATA_WIDTH_R = DW_R ; 
                    defparam pdp16k.OUTREG = OUTREG ; 
                    defparam pdp16k.RESETMODE = TRUE_RST ; 
                    defparam pdp16k.CSDECODE_W = TRUE_CSW ; 
                    defparam pdp16k.CSDECODE_R = TRUE_CSR ; 
                    defparam pdp16k.ASYNC_RST_RELEASE = TRUE_RST_REL ; 
                    defparam pdp16k.INIT_DATA = "DYNAMIC" ; 
                    defparam pdp16k.ECC = (ECC_ENABLE ? "ENABLED" : "DISABLED") ; 
                    defparam pdp16k.INITVAL_00 = ((INIT_MODE == "mem_file") ? INIT_VALUE_00 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_01 = ((INIT_MODE == "mem_file") ? INIT_VALUE_01 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_02 = ((INIT_MODE == "mem_file") ? INIT_VALUE_02 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_03 = ((INIT_MODE == "mem_file") ? INIT_VALUE_03 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_04 = ((INIT_MODE == "mem_file") ? INIT_VALUE_04 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_05 = ((INIT_MODE == "mem_file") ? INIT_VALUE_05 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_06 = ((INIT_MODE == "mem_file") ? INIT_VALUE_06 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_07 = ((INIT_MODE == "mem_file") ? INIT_VALUE_07 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_08 = ((INIT_MODE == "mem_file") ? INIT_VALUE_08 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_09 = ((INIT_MODE == "mem_file") ? INIT_VALUE_09 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0A = ((INIT_MODE == "mem_file") ? INIT_VALUE_0A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0B = ((INIT_MODE == "mem_file") ? INIT_VALUE_0B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0C = ((INIT_MODE == "mem_file") ? INIT_VALUE_0C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0D = ((INIT_MODE == "mem_file") ? INIT_VALUE_0D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0E = ((INIT_MODE == "mem_file") ? INIT_VALUE_0E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_0F = ((INIT_MODE == "mem_file") ? INIT_VALUE_0F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_10 = ((INIT_MODE == "mem_file") ? INIT_VALUE_10 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_11 = ((INIT_MODE == "mem_file") ? INIT_VALUE_11 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_12 = ((INIT_MODE == "mem_file") ? INIT_VALUE_12 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_13 = ((INIT_MODE == "mem_file") ? INIT_VALUE_13 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_14 = ((INIT_MODE == "mem_file") ? INIT_VALUE_14 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_15 = ((INIT_MODE == "mem_file") ? INIT_VALUE_15 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_16 = ((INIT_MODE == "mem_file") ? INIT_VALUE_16 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_17 = ((INIT_MODE == "mem_file") ? INIT_VALUE_17 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_18 = ((INIT_MODE == "mem_file") ? INIT_VALUE_18 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_19 = ((INIT_MODE == "mem_file") ? INIT_VALUE_19 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1A = ((INIT_MODE == "mem_file") ? INIT_VALUE_1A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1B = ((INIT_MODE == "mem_file") ? INIT_VALUE_1B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1C = ((INIT_MODE == "mem_file") ? INIT_VALUE_1C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1D = ((INIT_MODE == "mem_file") ? INIT_VALUE_1D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1E = ((INIT_MODE == "mem_file") ? INIT_VALUE_1E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_1F = ((INIT_MODE == "mem_file") ? INIT_VALUE_1F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_20 = ((INIT_MODE == "mem_file") ? INIT_VALUE_20 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_21 = ((INIT_MODE == "mem_file") ? INIT_VALUE_21 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_22 = ((INIT_MODE == "mem_file") ? INIT_VALUE_22 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_23 = ((INIT_MODE == "mem_file") ? INIT_VALUE_23 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_24 = ((INIT_MODE == "mem_file") ? INIT_VALUE_24 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_25 = ((INIT_MODE == "mem_file") ? INIT_VALUE_25 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_26 = ((INIT_MODE == "mem_file") ? INIT_VALUE_26 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_27 = ((INIT_MODE == "mem_file") ? INIT_VALUE_27 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_28 = ((INIT_MODE == "mem_file") ? INIT_VALUE_28 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_29 = ((INIT_MODE == "mem_file") ? INIT_VALUE_29 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2A = ((INIT_MODE == "mem_file") ? INIT_VALUE_2A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2B = ((INIT_MODE == "mem_file") ? INIT_VALUE_2B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2C = ((INIT_MODE == "mem_file") ? INIT_VALUE_2C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2D = ((INIT_MODE == "mem_file") ? INIT_VALUE_2D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2E = ((INIT_MODE == "mem_file") ? INIT_VALUE_2E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_2F = ((INIT_MODE == "mem_file") ? INIT_VALUE_2F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_30 = ((INIT_MODE == "mem_file") ? INIT_VALUE_30 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_31 = ((INIT_MODE == "mem_file") ? INIT_VALUE_31 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_32 = ((INIT_MODE == "mem_file") ? INIT_VALUE_32 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_33 = ((INIT_MODE == "mem_file") ? INIT_VALUE_33 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_34 = ((INIT_MODE == "mem_file") ? INIT_VALUE_34 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_35 = ((INIT_MODE == "mem_file") ? INIT_VALUE_35 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_36 = ((INIT_MODE == "mem_file") ? INIT_VALUE_36 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_37 = ((INIT_MODE == "mem_file") ? INIT_VALUE_37 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_38 = ((INIT_MODE == "mem_file") ? INIT_VALUE_38 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_39 = ((INIT_MODE == "mem_file") ? INIT_VALUE_39 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3A = ((INIT_MODE == "mem_file") ? INIT_VALUE_3A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3B = ((INIT_MODE == "mem_file") ? INIT_VALUE_3B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3C = ((INIT_MODE == "mem_file") ? INIT_VALUE_3C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3D = ((INIT_MODE == "mem_file") ? INIT_VALUE_3D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3E = ((INIT_MODE == "mem_file") ? INIT_VALUE_3E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    defparam pdp16k.INITVAL_3F = ((INIT_MODE == "mem_file") ? INIT_VALUE_3F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                end
            else
                if ((FAMILY_CODE == _FCODE_AP6_)) 
                    begin : AP6_MEM
                        localparam OUTREG = ((REGMODE == "reg") ? ((OUTPUT_CLK_EN == 0) ? "USED" : "BYPASSED") : "BYPASSED") ; 
                        localparam TRUE_CSW = ((CSDECODE_W == 0) ? "000" : ((CSDECODE_W == 1) ? "001" : ((CSDECODE_W == 2) ? "010" : ((CSDECODE_W == 3) ? "011" : ((CSDECODE_W == 4) ? "100" : ((CSDECODE_W == 5) ? "101" : ((CSDECODE_W == 6) ? "110" : "111"))))))) ; 
                        localparam TRUE_CSR = ((CSDECODE_R == 0) ? "000" : ((CSDECODE_R == 1) ? "001" : ((CSDECODE_R == 2) ? "010" : ((CSDECODE_R == 3) ? "011" : ((CSDECODE_R == 4) ? "100" : ((CSDECODE_R == 5) ? "101" : ((CSDECODE_R == 6) ? "110" : "111"))))))) ; 
                        localparam DW_W = (((DATA_WIDTH_W == 72) || (DATA_WIDTH_W == 64)) ? "X72" : (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32)) ? "X36" : (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16)) ? "X18" : (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8)) ? "X9" : ((DATA_WIDTH_W == 4) ? "X4" : ((DATA_WIDTH_W == 2) ? "X2" : "X1")))))) ; 
                        localparam DW_R = (((DATA_WIDTH_R == 72) || (DATA_WIDTH_R == 64)) ? "X72" : (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32)) ? "X36" : (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16)) ? "X18" : (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8)) ? "X9" : ((DATA_WIDTH_R == 4) ? "X4" : ((DATA_WIDTH_R == 2) ? "X2" : "X1")))))) ; 
                        localparam TRUE_RST = ((RESETMODE == "sync") ? "SYNC" : "ASYNC") ; 
                        localparam TRUE_RST_REL = ((RESET_RELEASE == "sync") ? "SYNC" : "ASYNC") ; 
                        localparam TRUE_ECC = (((ECC_ENABLE == 1) && (DATA_WIDTH_W == 64)) ? "ENABLED" : "DISABLED") ; 
                        localparam TRUE_GSR = ((GSR == "disabled") ? "DISABLED" : "ENABLED") ; 
                        wire [14:0] w_addr_w ; 
                        wire [14:0] r_addr_w ; 
                        wire [71:0] w_data_w ; 
                        wire [71:0] r_data_w ; 
                        wire [(DATA_WIDTH_R - 1):0] rd_data_w ; 
                        if (((REGMODE == "noreg") || (OUTPUT_CLK_EN == 0))) 
                            begin : genblk1
                                assign rd_data_o = rd_data_w ; 
                            end
                        else
                            begin : genblk1
                                reg [(DATA_WIDTH_R - 1):0] rd_data_r ; 
                                if ((RESETMODE == "sync")) 
                                    begin : genblk1
                                        always
                                            @(posedge rd_clk_i)
                                            begin
                                                if ((rst_i == 1'b1)) 
                                                    begin
                                                        rd_data_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                    end
                                                else
                                                    begin
                                                        rd_data_r <=  rd_data_w ;
                                                    end
                                            end
                                    end
                                else
                                    begin : genblk1
                                        always
                                            @(posedge rd_clk_i or 
                                                posedge rst_i)
                                            begin
                                                if ((rst_i == 1'b1)) 
                                                    begin
                                                        rd_data_r <=  {DATA_WIDTH_R{1'b0}} ;
                                                    end
                                                else
                                                    begin
                                                        rd_data_r <=  rd_data_w ;
                                                    end
                                            end
                                    end
                                assign rd_data_o = rd_data_r ; 
                            end
                        if (((DATA_WIDTH_W == 72) || (DATA_WIDTH_W == 64))) 
                            begin : genblk2
                                assign w_addr_w[14:6] = wr_addr_i ; 
                                assign w_addr_w[5:0] = ((BYTE_ENABLE == 1) ? ben_i[5:0] : 6'b11_1111) ; 
                                if ((DATA_WIDTH_W == 72)) 
                                    begin : genblk1
                                        assign w_data_w = wr_data_i ; 
                                    end
                                else
                                    begin : genblk1
                                        assign w_data_w[71] = 1'b0 ; 
                                        assign w_data_w[62] = 1'b0 ; 
                                        assign w_data_w[53] = 1'b0 ; 
                                        assign w_data_w[44] = 1'b0 ; 
                                        assign w_data_w[35] = 1'b0 ; 
                                        assign w_data_w[26] = 1'b0 ; 
                                        assign w_data_w[17] = 1'b0 ; 
                                        assign w_data_w[8] = 1'b0 ; 
                                        assign w_data_w[70:63] = wr_data_i[63:56] ; 
                                        assign w_data_w[61:54] = wr_data_i[55:48] ; 
                                        assign w_data_w[52:45] = wr_data_i[47:40] ; 
                                        assign w_data_w[43:36] = wr_data_i[39:32] ; 
                                        assign w_data_w[34:27] = wr_data_i[31:24] ; 
                                        assign w_data_w[25:18] = wr_data_i[23:16] ; 
                                        assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                        assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_W == 36) || (DATA_WIDTH_W == 32))) 
                                begin : genblk2
                                    assign w_addr_w[14:5] = wr_addr_i ; 
                                    assign w_addr_w[4] = 1'b1 ; 
                                    assign w_addr_w[3:0] = ((BYTE_ENABLE == 1) ? ben_i : 4'b1111) ; 
                                    assign w_data_w[71:36] = {36{1'b0}} ; 
                                    if ((DATA_WIDTH_W == 36)) 
                                        begin : genblk1
                                            assign w_data_w = wr_data_i ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign w_data_w[35] = 1'b0 ; 
                                            assign w_data_w[26] = 1'b0 ; 
                                            assign w_data_w[17] = 1'b0 ; 
                                            assign w_data_w[8] = 1'b0 ; 
                                            assign w_data_w[34:27] = wr_data_i[31:24] ; 
                                            assign w_data_w[25:18] = wr_data_i[23:16] ; 
                                            assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                            assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                        end
                                end
                            else
                                if (((DATA_WIDTH_W == 18) || (DATA_WIDTH_W == 16))) 
                                    begin : genblk2
                                        assign w_addr_w[14:4] = wr_addr_i ; 
                                        assign w_addr_w[3:2] = 2'b11 ; 
                                        assign w_addr_w[1:0] = ((BYTE_ENABLE == 1) ? ben_i : 2'b11) ; 
                                        assign w_data_w[71:18] = {54{1'b0}} ; 
                                        if ((DATA_WIDTH_W == 18)) 
                                            begin : genblk1
                                                assign w_data_w[17:0] = wr_data_i ; 
                                            end
                                        else
                                            begin : genblk1
                                                assign w_data_w[17] = 1'b0 ; 
                                                assign w_data_w[8] = 1'b0 ; 
                                                assign w_data_w[16:9] = wr_data_i[15:8] ; 
                                                assign w_data_w[7:0] = wr_data_i[7:0] ; 
                                            end
                                    end
                                else
                                    if (((DATA_WIDTH_W == 9) || (DATA_WIDTH_W == 8))) 
                                        begin : genblk2
                                            assign w_addr_w[14:3] = wr_addr_i ; 
                                            assign w_addr_w[2:0] = 3'b111 ; 
                                            assign w_data_w[71:9] = {63{1'b0}} ; 
                                            if ((DATA_WIDTH_W == 9)) 
                                                begin: genblk1
                                                    assign w_data_w[8:0] = wr_data_i ; 
                                                end
                                            else
                                                begin: genblk1
                                                    assign w_data_w[8:0] = {1'b0,
                                                                wr_data_i} ; 
                                                end
                                        end
                                    else
                                        if ((DATA_WIDTH_W == 4)) 
                                            begin : genblk2
                                                assign w_addr_w[14:2] = wr_addr_i ; 
                                                assign w_addr_w[1:0] = 2'b11 ; 
                                                assign w_data_w[71:4] = {68{1'b0}} ; 
                                                assign w_data_w[3:0] = wr_data_i ; 
                                            end
                                        else
                                            if ((DATA_WIDTH_W == 2)) 
                                                begin : genblk2
                                                    assign w_addr_w[14:1] = wr_addr_i ; 
                                                    assign w_addr_w[0] = 1'b1 ; 
                                                    assign w_data_w[71:2] = {70{1'b0}} ; 
                                                    assign w_data_w[1:0] = wr_data_i ; 
                                                end
                                            else
                                                begin : genblk2
                                                    assign w_addr_w[14:0] = wr_addr_i ; 
                                                    assign w_data_w[71:1] = {71{1'b0}} ; 
                                                    assign w_data_w[0] = wr_data_i ; 
                                                end
                        if (((DATA_WIDTH_R == 72) || (DATA_WIDTH_R == 64))) 
                            begin : genblk3
                                assign r_addr_w[14:6] = rd_addr_i ; 
                                assign r_addr_w[5:0] = 6'b11_1111 ; 
                                if ((DATA_WIDTH_R == 72)) 
                                    begin : genblk1
                                        assign rd_data_w = r_data_w ; 
                                    end
                                else
                                    begin : genblk1
                                        assign rd_data_w[63:56] = r_data_w[70:63] ; 
                                        assign rd_data_w[55:48] = r_data_w[61:54] ; 
                                        assign rd_data_w[47:40] = r_data_w[52:45] ; 
                                        assign rd_data_w[39:32] = r_data_w[43:36] ; 
                                        assign rd_data_w[31:24] = r_data_w[34:27] ; 
                                        assign rd_data_w[23:16] = r_data_w[25:18] ; 
                                        assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                        assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                    end
                            end
                        else
                            if (((DATA_WIDTH_R == 36) || (DATA_WIDTH_R == 32))) 
                                begin : genblk3
                                    assign r_addr_w[14:5] = rd_addr_i ; 
                                    assign r_addr_w[4] = 1'b1 ; 
                                    assign r_addr_w[3:0] = 4'b1111 ; 
                                    if ((DATA_WIDTH_R == 36)) 
                                        begin : genblk1
                                            assign rd_data_w[35:0] = r_data_w[35:0] ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign rd_data_w[31:24] = r_data_w[34:27] ; 
                                            assign rd_data_w[23:16] = r_data_w[25:18] ; 
                                            assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                            assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                        end
                                end
                            else
                                if (((DATA_WIDTH_R == 18) || (DATA_WIDTH_R == 16))) 
                                    begin : genblk3
                                        assign r_addr_w[14:4] = rd_addr_i ; 
                                        assign r_addr_w[3:2] = 2'b11 ; 
                                        assign r_addr_w[1:0] = 2'b11 ; 
                                        if ((DATA_WIDTH_R == 18)) 
                                            begin : genblk1
                                                assign rd_data_w[17:0] = r_data_w[17:0] ; 
                                            end
                                        else
                                            begin : genblk1
                                                assign rd_data_w[15:8] = r_data_w[16:9] ; 
                                                assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                            end
                                    end
                                else
                                    if (((DATA_WIDTH_R == 9) || (DATA_WIDTH_R == 8))) 
                                        begin : genblk3
                                            assign r_addr_w[14:3] = rd_addr_i ; 
                                            assign r_addr_w[2:0] = 3'b111 ; 
                                            if ((DATA_WIDTH_R == 9)) 
                                                begin: genblk1
                                                    assign rd_data_w[8:0] = r_data_w[8:0] ; 
                                                end
                                            else
                                                begin: genblk1
                                                    assign rd_data_w[7:0] = r_data_w[7:0] ; 
                                                end
                                        end
                                    else
                                        if ((DATA_WIDTH_R == 4)) 
                                            begin : genblk3
                                                assign r_addr_w[14:2] = rd_addr_i ; 
                                                assign r_addr_w[1:0] = 2'b11 ; 
                                                assign rd_data_w = r_data_w[3:0] ; 
                                            end
                                        else
                                            if ((DATA_WIDTH_R == 2)) 
                                                begin : genblk3
                                                    assign r_addr_w[14:1] = rd_addr_i ; 
                                                    assign r_addr_w[0] = 1'b1 ; 
                                                    assign rd_data_w = r_data_w[1:0] ; 
                                                end
                                            else
                                                begin : genblk3
                                                    assign r_addr_w[14:0] = rd_addr_i ; 
                                                    assign rd_data_w = r_data_w[0] ; 
                                                end
                        wire t_wr_en_i = ((BYTE_ENABLE == 0) ? wr_en_i : ((BYTE_WIDTH > 1) ? wr_en_i : (wr_en_i & ben_i))) ; 
                        wire t_rd_en_i = rd_en_i ; 
                        wire [71:0] DI = w_data_w ; 
                        wire [14:0] ADW = w_addr_w ; 
                        wire [14:0] ADR = r_addr_w ; 
                        wire CLKW = wr_clk_i ; 
                        wire CLKR = rd_clk_i ; 
                        wire CEW = wr_clk_en_i ; 
                        wire CER = rd_clk_en_i ; 
                        wire [2:0] CSW = {t_wr_en_i,
                                    t_wr_en_i,
                                    t_wr_en_i} ; 
                        wire [2:0] CSR = {t_rd_en_i,
                                    t_rd_en_i,
                                    t_rd_en_i} ; 
                        wire RST = rst_i ; 
                        wire [71:0] DO ; 
                        wire BE6 = (((BYTE_ENABLE == 1) && (BYTE_WIDTH == 8)) ? ben_i[6] : 1'b1) ; 
                        wire BE7 = (((BYTE_ENABLE == 1) && (BYTE_WIDTH == 8)) ? ben_i[7] : 1'b1) ; 
                        assign r_data_w = DO ; 
                        localparam MEM_TYPE = "EBR" ; 
                        localparam T_MEM_SIZE = {"[",
                                    MEM_SIZE,
                                    "]"} ; 
                        (* ECO_MEM_TYPE=MEM_TYPE, ECO_MEM_ID=MEM_ID, ECO_MEM_SIZE=T_MEM_SIZE, ECO_MEM_BLOCK_SIZE=BLOCK_SIZE, ECO_MEM_BLOCK_POS=BLOCK_POS *) PDP32K pdp32k (.DI(DI), 
                                    .ADW(ADW), 
                                    .ADR(ADR), 
                                    .CLKW(CLKW), 
                                    .CLKR(CLKR), 
                                    .CEW(CEW), 
                                    .CER(CER), 
                                    .OCE(rd_out_clk_en_i), 
                                    .BE6(BE6), 
                                    .BE7(BE7), 
                                    .CSW(CSW), 
                                    .CSR(CSR), 
                                    .RST(RST), 
                                    .DO(DO), 
                                    .ONEBITERR(one_err_det_o), 
                                    .TWOBITERR(two_err_det_o)) ; 
                        defparam pdp32k.DATA_WIDTH_W = DW_W ; 
                        defparam pdp32k.DATA_WIDTH_R = DW_R ; 
                        defparam pdp32k.OUTREG = OUTREG ; 
                        defparam pdp32k.RESETMODE = TRUE_RST ; 
                        defparam pdp32k.CSDECODE_W = TRUE_CSW ; 
                        defparam pdp32k.CSDECODE_R = TRUE_CSR ; 
                        defparam pdp32k.ASYNC_RST_RELEASE = TRUE_RST_REL ; 
                        defparam pdp32k.INIT_DATA = "DYNAMIC" ; 
                        defparam pdp32k.ECC = (ECC_ENABLE ? "ENABLED" : "DISABLED") ; 
                        defparam pdp32k.INITVAL_00 = ((INIT_MODE == "mem_file") ? INIT_VALUE_00 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_01 = ((INIT_MODE == "mem_file") ? INIT_VALUE_01 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_02 = ((INIT_MODE == "mem_file") ? INIT_VALUE_02 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_03 = ((INIT_MODE == "mem_file") ? INIT_VALUE_03 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_04 = ((INIT_MODE == "mem_file") ? INIT_VALUE_04 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_05 = ((INIT_MODE == "mem_file") ? INIT_VALUE_05 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_06 = ((INIT_MODE == "mem_file") ? INIT_VALUE_06 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_07 = ((INIT_MODE == "mem_file") ? INIT_VALUE_07 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_08 = ((INIT_MODE == "mem_file") ? INIT_VALUE_08 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_09 = ((INIT_MODE == "mem_file") ? INIT_VALUE_09 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0A = ((INIT_MODE == "mem_file") ? INIT_VALUE_0A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0B = ((INIT_MODE == "mem_file") ? INIT_VALUE_0B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0C = ((INIT_MODE == "mem_file") ? INIT_VALUE_0C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0D = ((INIT_MODE == "mem_file") ? INIT_VALUE_0D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0E = ((INIT_MODE == "mem_file") ? INIT_VALUE_0E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_0F = ((INIT_MODE == "mem_file") ? INIT_VALUE_0F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_10 = ((INIT_MODE == "mem_file") ? INIT_VALUE_10 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_11 = ((INIT_MODE == "mem_file") ? INIT_VALUE_11 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_12 = ((INIT_MODE == "mem_file") ? INIT_VALUE_12 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_13 = ((INIT_MODE == "mem_file") ? INIT_VALUE_13 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_14 = ((INIT_MODE == "mem_file") ? INIT_VALUE_14 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_15 = ((INIT_MODE == "mem_file") ? INIT_VALUE_15 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_16 = ((INIT_MODE == "mem_file") ? INIT_VALUE_16 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_17 = ((INIT_MODE == "mem_file") ? INIT_VALUE_17 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_18 = ((INIT_MODE == "mem_file") ? INIT_VALUE_18 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_19 = ((INIT_MODE == "mem_file") ? INIT_VALUE_19 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1A = ((INIT_MODE == "mem_file") ? INIT_VALUE_1A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1B = ((INIT_MODE == "mem_file") ? INIT_VALUE_1B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1C = ((INIT_MODE == "mem_file") ? INIT_VALUE_1C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1D = ((INIT_MODE == "mem_file") ? INIT_VALUE_1D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1E = ((INIT_MODE == "mem_file") ? INIT_VALUE_1E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_1F = ((INIT_MODE == "mem_file") ? INIT_VALUE_1F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_20 = ((INIT_MODE == "mem_file") ? INIT_VALUE_20 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_21 = ((INIT_MODE == "mem_file") ? INIT_VALUE_21 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_22 = ((INIT_MODE == "mem_file") ? INIT_VALUE_22 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_23 = ((INIT_MODE == "mem_file") ? INIT_VALUE_23 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_24 = ((INIT_MODE == "mem_file") ? INIT_VALUE_24 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_25 = ((INIT_MODE == "mem_file") ? INIT_VALUE_25 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_26 = ((INIT_MODE == "mem_file") ? INIT_VALUE_26 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_27 = ((INIT_MODE == "mem_file") ? INIT_VALUE_27 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_28 = ((INIT_MODE == "mem_file") ? INIT_VALUE_28 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_29 = ((INIT_MODE == "mem_file") ? INIT_VALUE_29 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2A = ((INIT_MODE == "mem_file") ? INIT_VALUE_2A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2B = ((INIT_MODE == "mem_file") ? INIT_VALUE_2B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2C = ((INIT_MODE == "mem_file") ? INIT_VALUE_2C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2D = ((INIT_MODE == "mem_file") ? INIT_VALUE_2D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2E = ((INIT_MODE == "mem_file") ? INIT_VALUE_2E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_2F = ((INIT_MODE == "mem_file") ? INIT_VALUE_2F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_30 = ((INIT_MODE == "mem_file") ? INIT_VALUE_30 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_31 = ((INIT_MODE == "mem_file") ? INIT_VALUE_31 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_32 = ((INIT_MODE == "mem_file") ? INIT_VALUE_32 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_33 = ((INIT_MODE == "mem_file") ? INIT_VALUE_33 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_34 = ((INIT_MODE == "mem_file") ? INIT_VALUE_34 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_35 = ((INIT_MODE == "mem_file") ? INIT_VALUE_35 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_36 = ((INIT_MODE == "mem_file") ? INIT_VALUE_36 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_37 = ((INIT_MODE == "mem_file") ? INIT_VALUE_37 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_38 = ((INIT_MODE == "mem_file") ? INIT_VALUE_38 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_39 = ((INIT_MODE == "mem_file") ? INIT_VALUE_39 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3A = ((INIT_MODE == "mem_file") ? INIT_VALUE_3A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3B = ((INIT_MODE == "mem_file") ? INIT_VALUE_3B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3C = ((INIT_MODE == "mem_file") ? INIT_VALUE_3C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3D = ((INIT_MODE == "mem_file") ? INIT_VALUE_3D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3E = ((INIT_MODE == "mem_file") ? INIT_VALUE_3E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_3F = ((INIT_MODE == "mem_file") ? INIT_VALUE_3F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_40 = ((INIT_MODE == "mem_file") ? INIT_VALUE_40 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_41 = ((INIT_MODE == "mem_file") ? INIT_VALUE_41 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_42 = ((INIT_MODE == "mem_file") ? INIT_VALUE_42 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_43 = ((INIT_MODE == "mem_file") ? INIT_VALUE_43 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_44 = ((INIT_MODE == "mem_file") ? INIT_VALUE_44 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_45 = ((INIT_MODE == "mem_file") ? INIT_VALUE_45 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_46 = ((INIT_MODE == "mem_file") ? INIT_VALUE_46 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_47 = ((INIT_MODE == "mem_file") ? INIT_VALUE_47 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_48 = ((INIT_MODE == "mem_file") ? INIT_VALUE_48 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_49 = ((INIT_MODE == "mem_file") ? INIT_VALUE_49 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4A = ((INIT_MODE == "mem_file") ? INIT_VALUE_4A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4B = ((INIT_MODE == "mem_file") ? INIT_VALUE_4B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4C = ((INIT_MODE == "mem_file") ? INIT_VALUE_4C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4D = ((INIT_MODE == "mem_file") ? INIT_VALUE_4D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4E = ((INIT_MODE == "mem_file") ? INIT_VALUE_4E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_4F = ((INIT_MODE == "mem_file") ? INIT_VALUE_4F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_50 = ((INIT_MODE == "mem_file") ? INIT_VALUE_50 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_51 = ((INIT_MODE == "mem_file") ? INIT_VALUE_51 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_52 = ((INIT_MODE == "mem_file") ? INIT_VALUE_52 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_53 = ((INIT_MODE == "mem_file") ? INIT_VALUE_53 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_54 = ((INIT_MODE == "mem_file") ? INIT_VALUE_54 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_55 = ((INIT_MODE == "mem_file") ? INIT_VALUE_55 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_56 = ((INIT_MODE == "mem_file") ? INIT_VALUE_56 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_57 = ((INIT_MODE == "mem_file") ? INIT_VALUE_57 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_58 = ((INIT_MODE == "mem_file") ? INIT_VALUE_58 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_59 = ((INIT_MODE == "mem_file") ? INIT_VALUE_59 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5A = ((INIT_MODE == "mem_file") ? INIT_VALUE_5A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5B = ((INIT_MODE == "mem_file") ? INIT_VALUE_5B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5C = ((INIT_MODE == "mem_file") ? INIT_VALUE_5C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5D = ((INIT_MODE == "mem_file") ? INIT_VALUE_5D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5E = ((INIT_MODE == "mem_file") ? INIT_VALUE_5E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_5F = ((INIT_MODE == "mem_file") ? INIT_VALUE_5F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_60 = ((INIT_MODE == "mem_file") ? INIT_VALUE_60 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_61 = ((INIT_MODE == "mem_file") ? INIT_VALUE_61 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_62 = ((INIT_MODE == "mem_file") ? INIT_VALUE_62 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_63 = ((INIT_MODE == "mem_file") ? INIT_VALUE_63 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_64 = ((INIT_MODE == "mem_file") ? INIT_VALUE_64 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_65 = ((INIT_MODE == "mem_file") ? INIT_VALUE_65 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_66 = ((INIT_MODE == "mem_file") ? INIT_VALUE_66 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_67 = ((INIT_MODE == "mem_file") ? INIT_VALUE_67 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_68 = ((INIT_MODE == "mem_file") ? INIT_VALUE_68 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_69 = ((INIT_MODE == "mem_file") ? INIT_VALUE_69 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6A = ((INIT_MODE == "mem_file") ? INIT_VALUE_6A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6B = ((INIT_MODE == "mem_file") ? INIT_VALUE_6B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6C = ((INIT_MODE == "mem_file") ? INIT_VALUE_6C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6D = ((INIT_MODE == "mem_file") ? INIT_VALUE_6D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6E = ((INIT_MODE == "mem_file") ? INIT_VALUE_6E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_6F = ((INIT_MODE == "mem_file") ? INIT_VALUE_6F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_70 = ((INIT_MODE == "mem_file") ? INIT_VALUE_70 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_71 = ((INIT_MODE == "mem_file") ? INIT_VALUE_71 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_72 = ((INIT_MODE == "mem_file") ? INIT_VALUE_72 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_73 = ((INIT_MODE == "mem_file") ? INIT_VALUE_73 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_74 = ((INIT_MODE == "mem_file") ? INIT_VALUE_74 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_75 = ((INIT_MODE == "mem_file") ? INIT_VALUE_75 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_76 = ((INIT_MODE == "mem_file") ? INIT_VALUE_76 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_77 = ((INIT_MODE == "mem_file") ? INIT_VALUE_77 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_78 = ((INIT_MODE == "mem_file") ? INIT_VALUE_78 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_79 = ((INIT_MODE == "mem_file") ? INIT_VALUE_79 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7A = ((INIT_MODE == "mem_file") ? INIT_VALUE_7A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7B = ((INIT_MODE == "mem_file") ? INIT_VALUE_7B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7C = ((INIT_MODE == "mem_file") ? INIT_VALUE_7C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7D = ((INIT_MODE == "mem_file") ? INIT_VALUE_7D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7E = ((INIT_MODE == "mem_file") ? INIT_VALUE_7E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                        defparam pdp32k.INITVAL_7F = ((INIT_MODE == "mem_file") ? INIT_VALUE_7F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                    end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] calculateStringSize ; 
        input [31:0] x_calc ; 
        input [31:0] y_calc ; 
        reg [31:0] x_func ; 
        reg [31:0] y_func ; 
        begin
            if ((x_calc >= 10000000)) 
                begin
                    x_func = 8 ;
                end
            else
                if ((x_calc >= 1000000)) 
                    begin
                        x_func = 7 ;
                    end
                else
                    if ((x_calc >= 100000)) 
                        begin
                            x_func = 6 ;
                        end
                    else
                        if ((x_calc >= 10000)) 
                            begin
                                x_func = 5 ;
                            end
                        else
                            if ((x_calc >= 1000)) 
                                begin
                                    x_func = 4 ;
                                end
                            else
                                if ((x_calc >= 100)) 
                                    begin
                                        x_func = 3 ;
                                    end
                                else
                                    if ((x_calc >= 10)) 
                                        begin
                                            x_func = 2 ;
                                        end
                                    else
                                        begin
                                            x_func = 1 ;
                                        end
            if ((y_calc >= 10000000)) 
                begin
                    y_func = 8 ;
                end
            else
                if ((y_calc >= 1000000)) 
                    begin
                        y_func = 7 ;
                    end
                else
                    if ((y_calc >= 100000)) 
                        begin
                            y_func = 6 ;
                        end
                    else
                        if ((y_calc >= 10000)) 
                            begin
                                y_func = 5 ;
                            end
                        else
                            if ((y_calc >= 1000)) 
                                begin
                                    y_func = 4 ;
                                end
                            else
                                if ((y_calc >= 100)) 
                                    begin
                                        y_func = 3 ;
                                    end
                                else
                                    if ((y_calc >= 10)) 
                                        begin
                                            y_func = 2 ;
                                        end
                                    else
                                        begin
                                            y_func = 1 ;
                                        end
            calculateStringSize = (((3 + x_func) + y_func) * 8) ;
        end
    endfunction
    function [31:0] getByteWidth ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    if (((data_width == 36) || (data_width == 32))) 
                        getByteWidth = 4 ;
                    else
                        if (((data_width == 18) || (data_width == 16))) 
                            getByteWidth = 2 ;
                        else
                            getByteWidth = 1 ;
                end
            _FCODE_ICE_ : 
                begin
                    if ((data_width == 16)) 
                        getByteWidth = 2 ;
                    else
                        getByteWidth = 1 ;
                end
            _FCODE_AP6_ : 
                begin
                    if (((data_width == 72) || (data_width == 64))) 
                        getByteWidth = 8 ;
                    else
                        if (((data_width == 36) || (data_width == 32))) 
                            getByteWidth = 4 ;
                        else
                            if (((data_width == 18) || (data_width == 16))) 
                                getByteWidth = 2 ;
                            else
                                getByteWidth = 1 ;
                end
            default : 
                getByteWidth = 1 ;
            endcase 
        end
    endfunction
    function [(STRING_SIZE - 1):0] getStringFromPos ; 
        input [31:0] x ; 
        input [31:0] y ; 
        begin
            if ((y >= 10000000)) 
                begin
                    if ((x >= 10000000)) 
                        begin
                            getStringFromPos = {"[",
                                    NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                    ",",
                                    NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                    "]"} ;
                        end
                    else
                        if ((x >= 1000000)) 
                            begin
                                getStringFromPos = {"[",
                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                        ",",
                                        NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                        "]"} ;
                            end
                        else
                            if ((x >= 100000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 10000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 1000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 100)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 10)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y7 * 8) + 7):(POS_Y7 * 8)],
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                end
            else
                if ((y >= 1000000)) 
                    begin
                        if ((x >= 10000000)) 
                            begin
                                getStringFromPos = {"[",
                                        NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                        ",",
                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                        "]"} ;
                            end
                        else
                            if ((x >= 1000000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 100000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 10000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 1000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 100)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 10)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y6 * 8) + 7):(POS_Y6 * 8)],
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                    end
                else
                    if ((y >= 100000)) 
                        begin
                            if ((x >= 10000000)) 
                                begin
                                    getStringFromPos = {"[",
                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                            ",",
                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                            "]"} ;
                                end
                            else
                                if ((x >= 1000000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 100000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 10000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 1000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 100)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 10)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y5 * 8) + 7):(POS_Y5 * 8)],
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                        end
                    else
                        if ((y >= 10000)) 
                            begin
                                if ((x >= 10000000)) 
                                    begin
                                        getStringFromPos = {"[",
                                                NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                ",",
                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                "]"} ;
                                    end
                                else
                                    if ((x >= 1000000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 100000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 10000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y4 * 8) + 7):(POS_Y4 * 8)],
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                            end
                        else
                            if ((y >= 1000)) 
                                begin
                                    if ((x >= 10000000)) 
                                        begin
                                            getStringFromPos = {"[",
                                                    NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                    NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                    ",",
                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                    "]"} ;
                                        end
                                    else
                                        if ((x >= 1000000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 100000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 10000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 1000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 100)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 10)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y3 * 8) + 7):(POS_Y3 * 8)],
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                end
                            else
                                if ((y >= 100)) 
                                    begin
                                        if ((x >= 10000000)) 
                                            begin
                                                getStringFromPos = {"[",
                                                        NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                        NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                        NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                        ",",
                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                        "]"} ;
                                            end
                                        else
                                            if ((x >= 1000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 100000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 10000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 1000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 100)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 10)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y2 * 8) + 7):(POS_Y2 * 8)],
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                    end
                                else
                                    if ((y >= 10)) 
                                        begin
                                            if ((x >= 10000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 1000)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 100)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    if ((x >= 10)) 
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y1 * 8) + 7):(POS_Y1 * 8)],
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                        end
                                    else
                                        begin
                                            if ((x >= 10000000)) 
                                                begin
                                                    getStringFromPos = {"[",
                                                            NUM_STRING[((POS_X7 * 8) + 7):(POS_X7 * 8)],
                                                            NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                            NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                            NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                            ",",
                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                            "]"} ;
                                                end
                                            else
                                                if ((x >= 1000000)) 
                                                    begin
                                                        getStringFromPos = {"[",
                                                                NUM_STRING[((POS_X6 * 8) + 7):(POS_X6 * 8)],
                                                                NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                ",",
                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                "]"} ;
                                                    end
                                                else
                                                    if ((x >= 100000)) 
                                                        begin
                                                            getStringFromPos = {"[",
                                                                    NUM_STRING[((POS_X5 * 8) + 7):(POS_X5 * 8)],
                                                                    NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                    NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                    NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                    NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                    NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                    ",",
                                                                    NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                    "]"} ;
                                                        end
                                                    else
                                                        if ((x >= 10000)) 
                                                            begin
                                                                getStringFromPos = {"[",
                                                                        NUM_STRING[((POS_X4 * 8) + 7):(POS_X4 * 8)],
                                                                        NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                        NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                        NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                        NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                        ",",
                                                                        NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                        "]"} ;
                                                            end
                                                        else
                                                            if ((x >= 1000)) 
                                                                begin
                                                                    getStringFromPos = {"[",
                                                                            NUM_STRING[((POS_X3 * 8) + 7):(POS_X3 * 8)],
                                                                            NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                            NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                            NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                            ",",
                                                                            NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                            "]"} ;
                                                                end
                                                            else
                                                                if ((x >= 100)) 
                                                                    begin
                                                                        getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X2 * 8) + 7):(POS_X2 * 8)],
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                    end
                                                                else
                                                                    if ((x >= 10)) 
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X1 * 8) + 7):(POS_X1 * 8)],
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            getStringFromPos = {"[",
                                                                                NUM_STRING[((POS_X0 * 8) + 7):(POS_X0 * 8)],
                                                                                ",",
                                                                                NUM_STRING[((POS_Y0 * 8) + 7):(POS_Y0 * 8)],
                                                                                "]"} ;
                                                                        end
                                        end
        end
    endfunction
    function [31:0] getAddrWidth ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    case (data_width)
                    36 : 
                        getAddrWidth = 9 ;
                    32 : 
                        getAddrWidth = 9 ;
                    18 : 
                        getAddrWidth = 10 ;
                    16 : 
                        getAddrWidth = 10 ;
                    9 : 
                        getAddrWidth = 11 ;
                    8 : 
                        getAddrWidth = 11 ;
                    4 : 
                        getAddrWidth = 12 ;
                    2 : 
                        getAddrWidth = 13 ;
                    1 : 
                        getAddrWidth = 14 ;
                    endcase 
                end
            _FCODE_ICE_ : 
                begin
                    case (data_width)
                    16 : 
                        getAddrWidth = 8 ;
                    8 : 
                        getAddrWidth = 9 ;
                    4 : 
                        getAddrWidth = 10 ;
                    2 : 
                        getAddrWidth = 11 ;
                    endcase 
                end
            _FCODE_AP6_ : 
                begin
                    case (data_width)
                    72 : 
                        getAddrWidth = 9 ;
                    64 : 
                        getAddrWidth = 9 ;
                    36 : 
                        getAddrWidth = 10 ;
                    32 : 
                        getAddrWidth = 10 ;
                    18 : 
                        getAddrWidth = 11 ;
                    16 : 
                        getAddrWidth = 11 ;
                    9 : 
                        getAddrWidth = 12 ;
                    8 : 
                        getAddrWidth = 12 ;
                    4 : 
                        getAddrWidth = 13 ;
                    2 : 
                        getAddrWidth = 14 ;
                    1 : 
                        getAddrWidth = 15 ;
                    endcase 
                end
            default : 
                getAddrWidth = 8 ;
            endcase 
        end
    endfunction

//=============================================================================
// lscc_ram_dp_core.v
// Local Variables:
// verilog-library-directories: ("../../common")
// End:
//=============================================================================
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp_true.v
// Title                 :
// Dependencies          :
// Description           : Implements a true Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp_true #(parameter FAMILY = "common", 
        parameter ADDR_DEPTH_A = 1024, 
        parameter ADDR_WIDTH_A = clog2(ADDR_DEPTH_A), 
        parameter DATA_WIDTH_A = 36, 
        parameter ADDR_DEPTH_B = 1024, 
        parameter ADDR_WIDTH_B = clog2(ADDR_DEPTH_B), 
        parameter DATA_WIDTH_B = 36, 
        parameter REGMODE_A = "reg", 
        parameter REGMODE_B = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE_A = "sync", 
        parameter RESETMODE_B = "sync", 
        parameter RESET_RELEASE_A = "sync", 
        parameter RESET_RELEASE_B = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp_true", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE_A = 0, 
        parameter BYTE_SIZE_A = 9, 
        parameter BYTE_WIDTH_A = ((BYTE_ENABLE_A == 1) ? roundUP(DATA_WIDTH_A,
                BYTE_SIZE_A) : 1), 
        parameter BYTE_EN_POL_A = "active-high", 
        parameter WRITE_MODE_A = "normal", 
        parameter BYTE_ENABLE_B = 0, 
        parameter BYTE_SIZE_B = 9, 
        parameter BYTE_WIDTH_B = ((BYTE_ENABLE_B == 1) ? roundUP(DATA_WIDTH_B,
                BYTE_SIZE_B) : 1), 
        parameter BYTE_EN_POL_B = "active-high", 
        parameter WRITE_MODE_B = "normal", 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "36,1024", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input [(ADDR_WIDTH_A - 1):0] addr_a_i, 
    input [(ADDR_WIDTH_B - 1):0] addr_b_i, 
    input [(DATA_WIDTH_A - 1):0] wr_data_a_i, 
    input [(DATA_WIDTH_B - 1):0] wr_data_b_i, 
    input clk_a_i, 
    input clk_b_i, 
    input clk_en_a_i, 
    input clk_en_b_i, 
    input wr_en_a_i, 
    input wr_en_b_i, 
    input rst_a_i, 
    input rst_b_i, 
    input [(BYTE_WIDTH_A - 1):0] ben_a_i, 
    input [(BYTE_WIDTH_B - 1):0] ben_b_i, 
    output [(DATA_WIDTH_A - 1):0] rd_data_a_o, 
    output [(DATA_WIDTH_B - 1):0] rd_data_b_o, 
    output ecc_one_err_a_o, 
    output ecc_two_err_a_o, 
    output ecc_one_err_b_o, 
    output ecc_two_err_b_o) ;
    localparam T_FAMILY = ((((((FAMILY == "LFD2NX") || (FAMILY == "LFCPNX")) || (FAMILY == "LFMXO5")) || (FAMILY == "UT24C")) || (FAMILY == "UT24CP")) ? "LIFCL" : FAMILY) ; 
    new_lpddr4_ipgen_lscc_ram_dp_true_main #(.FAMILY(T_FAMILY),
            .ADDR_DEPTH_A(ADDR_DEPTH_A),
            .ADDR_WIDTH_A(ADDR_WIDTH_A),
            .DATA_WIDTH_A(DATA_WIDTH_A),
            .ADDR_DEPTH_B(ADDR_DEPTH_B),
            .ADDR_WIDTH_B(ADDR_WIDTH_B),
            .DATA_WIDTH_B(DATA_WIDTH_B),
            .REGMODE_A(REGMODE_A),
            .REGMODE_B(REGMODE_B),
            .GSR(GSR),
            .RESETMODE_A(RESETMODE_A),
            .RESETMODE_B(RESETMODE_B),
            .RESET_RELEASE_A(RESET_RELEASE_A),
            .RESET_RELEASE_B(RESET_RELEASE_B),
            .INIT_FILE(INIT_FILE),
            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
            .MODULE_TYPE(MODULE_TYPE),
            .INIT_MODE(INIT_MODE),
            .BYTE_ENABLE_A(BYTE_ENABLE_A),
            .BYTE_SIZE_A(BYTE_SIZE_A),
            .BYTE_WIDTH_A(BYTE_WIDTH_A),
            .BYTE_EN_POL_A(BYTE_EN_POL_A),
            .WRITE_MODE_A(WRITE_MODE_A),
            .BYTE_ENABLE_B(BYTE_ENABLE_B),
            .BYTE_SIZE_B(BYTE_SIZE_B),
            .BYTE_WIDTH_B(BYTE_WIDTH_B),
            .BYTE_EN_POL_B(BYTE_EN_POL_B),
            .WRITE_MODE_B(WRITE_MODE_B),
            .PIPELINES(PIPELINES),
            .ECC_ENABLE(ECC_ENABLE),
            .MEM_ID(MEM_ID),
            .MEM_SIZE(MEM_SIZE),
            .INIT_VALUE_00(INIT_VALUE_00),
            .INIT_VALUE_01(INIT_VALUE_01),
            .INIT_VALUE_02(INIT_VALUE_02),
            .INIT_VALUE_03(INIT_VALUE_03),
            .INIT_VALUE_04(INIT_VALUE_04),
            .INIT_VALUE_05(INIT_VALUE_05),
            .INIT_VALUE_06(INIT_VALUE_06),
            .INIT_VALUE_07(INIT_VALUE_07),
            .INIT_VALUE_08(INIT_VALUE_08),
            .INIT_VALUE_09(INIT_VALUE_09),
            .INIT_VALUE_0A(INIT_VALUE_0A),
            .INIT_VALUE_0B(INIT_VALUE_0B),
            .INIT_VALUE_0C(INIT_VALUE_0C),
            .INIT_VALUE_0D(INIT_VALUE_0D),
            .INIT_VALUE_0E(INIT_VALUE_0E),
            .INIT_VALUE_0F(INIT_VALUE_0F),
            .INIT_VALUE_10(INIT_VALUE_10),
            .INIT_VALUE_11(INIT_VALUE_11),
            .INIT_VALUE_12(INIT_VALUE_12),
            .INIT_VALUE_13(INIT_VALUE_13),
            .INIT_VALUE_14(INIT_VALUE_14),
            .INIT_VALUE_15(INIT_VALUE_15),
            .INIT_VALUE_16(INIT_VALUE_16),
            .INIT_VALUE_17(INIT_VALUE_17),
            .INIT_VALUE_18(INIT_VALUE_18),
            .INIT_VALUE_19(INIT_VALUE_19),
            .INIT_VALUE_1A(INIT_VALUE_1A),
            .INIT_VALUE_1B(INIT_VALUE_1B),
            .INIT_VALUE_1C(INIT_VALUE_1C),
            .INIT_VALUE_1D(INIT_VALUE_1D),
            .INIT_VALUE_1E(INIT_VALUE_1E),
            .INIT_VALUE_1F(INIT_VALUE_1F),
            .INIT_VALUE_20(INIT_VALUE_20),
            .INIT_VALUE_21(INIT_VALUE_21),
            .INIT_VALUE_22(INIT_VALUE_22),
            .INIT_VALUE_23(INIT_VALUE_23),
            .INIT_VALUE_24(INIT_VALUE_24),
            .INIT_VALUE_25(INIT_VALUE_25),
            .INIT_VALUE_26(INIT_VALUE_26),
            .INIT_VALUE_27(INIT_VALUE_27),
            .INIT_VALUE_28(INIT_VALUE_28),
            .INIT_VALUE_29(INIT_VALUE_29),
            .INIT_VALUE_2A(INIT_VALUE_2A),
            .INIT_VALUE_2B(INIT_VALUE_2B),
            .INIT_VALUE_2C(INIT_VALUE_2C),
            .INIT_VALUE_2D(INIT_VALUE_2D),
            .INIT_VALUE_2E(INIT_VALUE_2E),
            .INIT_VALUE_2F(INIT_VALUE_2F),
            .INIT_VALUE_30(INIT_VALUE_30),
            .INIT_VALUE_31(INIT_VALUE_31),
            .INIT_VALUE_32(INIT_VALUE_32),
            .INIT_VALUE_33(INIT_VALUE_33),
            .INIT_VALUE_34(INIT_VALUE_34),
            .INIT_VALUE_35(INIT_VALUE_35),
            .INIT_VALUE_36(INIT_VALUE_36),
            .INIT_VALUE_37(INIT_VALUE_37),
            .INIT_VALUE_38(INIT_VALUE_38),
            .INIT_VALUE_39(INIT_VALUE_39),
            .INIT_VALUE_3A(INIT_VALUE_3A),
            .INIT_VALUE_3B(INIT_VALUE_3B),
            .INIT_VALUE_3C(INIT_VALUE_3C),
            .INIT_VALUE_3D(INIT_VALUE_3D),
            .INIT_VALUE_3E(INIT_VALUE_3E),
            .INIT_VALUE_3F(INIT_VALUE_3F)) mem_main (.addr_a_i(addr_a_i), 
                .addr_b_i(addr_b_i), 
                .wr_data_a_i(wr_data_a_i), 
                .wr_data_b_i(wr_data_b_i), 
                .clk_a_i(clk_a_i), 
                .clk_b_i(clk_b_i), 
                .clk_en_a_i(clk_en_a_i), 
                .clk_en_b_i(clk_en_b_i), 
                .wr_en_a_i(wr_en_a_i), 
                .wr_en_b_i(wr_en_b_i), 
                .rst_a_i(rst_a_i), 
                .rst_b_i(rst_b_i), 
                .ben_a_i(ben_a_i), 
                .ben_b_i(ben_b_i), 
                .rd_data_a_o(rd_data_a_o), 
                .rd_data_b_o(rd_data_b_o), 
                .ecc_one_err_a_o(ecc_one_err_a_o), 
                .ecc_two_err_a_o(ecc_two_err_a_o), 
                .ecc_one_err_b_o(ecc_one_err_b_o), 
                .ecc_two_err_b_o(ecc_two_err_b_o)) ; 
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp_true_main.v
// Title                 :
// Dependencies          :
// Description           : Implements a true Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp_true_main #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_COMMON_ = 0, 
        parameter FAMILY = "common", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : _FCODE_COMMON_), 
        parameter ADDR_DEPTH_A = 1024, 
        parameter ADDR_WIDTH_A = clog2(ADDR_DEPTH_A), 
        parameter DATA_WIDTH_A = 36, 
        parameter ADDR_DEPTH_B = 1024, 
        parameter ADDR_WIDTH_B = clog2(ADDR_DEPTH_B), 
        parameter DATA_WIDTH_B = 36, 
        parameter REGMODE_A = "reg", 
        parameter REGMODE_B = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE_A = "sync", 
        parameter RESETMODE_B = "sync", 
        parameter RESET_RELEASE_A = "sync", 
        parameter RESET_RELEASE_B = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp_true", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE_A = 0, 
        parameter BYTE_SIZE_A = getByteSize(DATA_WIDTH_A,
                FAMILY_CODE), 
        parameter BYTE_WIDTH_A = ((BYTE_ENABLE_A == 1) ? roundUP(DATA_WIDTH_A,
                BYTE_SIZE_A) : 1), 
        parameter BYTE_EN_POL_A = "active-high", 
        parameter WRITE_MODE_A = "normal", 
        parameter BYTE_ENABLE_B = 0, 
        parameter BYTE_SIZE_B = getByteSize(DATA_WIDTH_B,
                FAMILY_CODE), 
        parameter BYTE_WIDTH_B = ((BYTE_ENABLE_B == 1) ? roundUP(DATA_WIDTH_B,
                BYTE_SIZE_B) : 1), 
        parameter BYTE_EN_POL_B = "active-high", 
        parameter WRITE_MODE_B = "normal", 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input [(ADDR_WIDTH_A - 1):0] addr_a_i, 
    input [(ADDR_WIDTH_B - 1):0] addr_b_i, 
    input [(DATA_WIDTH_A - 1):0] wr_data_a_i, 
    input [(DATA_WIDTH_B - 1):0] wr_data_b_i, 
    input clk_a_i, 
    input clk_b_i, 
    input clk_en_a_i, 
    input clk_en_b_i, 
    input wr_en_a_i, 
    input wr_en_b_i, 
    input rst_a_i, 
    input rst_b_i, 
    input [(BYTE_WIDTH_A - 1):0] ben_a_i, 
    input [(BYTE_WIDTH_B - 1):0] ben_b_i, 
    output [(DATA_WIDTH_A - 1):0] rd_data_a_o, 
    output [(DATA_WIDTH_B - 1):0] rd_data_b_o, 
    output ecc_one_err_a_o, 
    output ecc_two_err_a_o, 
    output ecc_one_err_b_o, 
    output ecc_two_err_b_o) ;
    wire [(DATA_WIDTH_A - 1):0] mem_out_a_w ; 
    wire [(DATA_WIDTH_B - 1):0] mem_out_b_w ; 
    new_lpddr4_ipgen_lscc_write_through #(.FAMILY(FAMILY),
            .DATA_WIDTH(DATA_WIDTH_A),
            .REGMODE(REGMODE_A),
            .WRITE_MODE(WRITE_MODE_A)) inst_wr_a (.clk_i(clk_a_i), 
                .clk_en_i(clk_en_a_i), 
                .wr_en_i(wr_en_a_i), 
                .rst_i(rst_a_i), 
                .wr_data_i(wr_data_a_i), 
                .mem_out_i(mem_out_a_w), 
                .rd_data_o(rd_data_a_o)) ; 
    new_lpddr4_ipgen_lscc_write_through #(.FAMILY(FAMILY),
            .DATA_WIDTH(DATA_WIDTH_B),
            .REGMODE(REGMODE_B),
            .WRITE_MODE(WRITE_MODE_B)) inst_wr_b (.clk_i(clk_b_i), 
                .clk_en_i(clk_en_b_i), 
                .wr_en_i(wr_en_b_i), 
                .rst_i(rst_b_i), 
                .wr_data_i(wr_data_b_i), 
                .mem_out_i(mem_out_b_w), 
                .rd_data_o(rd_data_b_o)) ; 
    localparam T_REG_MODE_A = ((WRITE_MODE_A == "write-through") ? "noreg" : REGMODE_A) ; 
    localparam T_REG_MODE_B = ((WRITE_MODE_B == "write-through") ? "noreg" : REGMODE_B) ; 
    new_lpddr4_ipgen_lscc_ram_dp_true_inst #(.FAMILY(FAMILY),
            .ADDR_DEPTH_A(ADDR_DEPTH_A),
            .ADDR_WIDTH_A(ADDR_WIDTH_A),
            .DATA_WIDTH_A(DATA_WIDTH_A),
            .ADDR_DEPTH_B(ADDR_DEPTH_B),
            .ADDR_WIDTH_B(ADDR_WIDTH_B),
            .DATA_WIDTH_B(DATA_WIDTH_B),
            .REGMODE_A(T_REG_MODE_A),
            .REGMODE_B(T_REG_MODE_B),
            .GSR(GSR),
            .RESETMODE_A(RESETMODE_A),
            .RESETMODE_B(RESETMODE_B),
            .RESET_RELEASE_A(RESET_RELEASE_A),
            .RESET_RELEASE_B(RESET_RELEASE_B),
            .INIT_FILE(INIT_FILE),
            .INIT_FILE_FORMAT(INIT_FILE_FORMAT),
            .MODULE_TYPE(MODULE_TYPE),
            .INIT_MODE(INIT_MODE),
            .BYTE_ENABLE_A(BYTE_ENABLE_A),
            .BYTE_SIZE_A(BYTE_SIZE_A),
            .BYTE_WIDTH_A(BYTE_WIDTH_A),
            .BYTE_EN_POL_A(BYTE_EN_POL_A),
            .BYTE_ENABLE_B(BYTE_ENABLE_B),
            .BYTE_SIZE_B(BYTE_SIZE_B),
            .BYTE_WIDTH_B(BYTE_WIDTH_B),
            .BYTE_EN_POL_B(BYTE_EN_POL_B),
            .PIPELINES(PIPELINES),
            .ECC_ENABLE(ECC_ENABLE),
            .MEM_ID(MEM_ID),
            .MEM_SIZE(MEM_SIZE),
            .INIT_VALUE_00(INIT_VALUE_00),
            .INIT_VALUE_01(INIT_VALUE_01),
            .INIT_VALUE_02(INIT_VALUE_02),
            .INIT_VALUE_03(INIT_VALUE_03),
            .INIT_VALUE_04(INIT_VALUE_04),
            .INIT_VALUE_05(INIT_VALUE_05),
            .INIT_VALUE_06(INIT_VALUE_06),
            .INIT_VALUE_07(INIT_VALUE_07),
            .INIT_VALUE_08(INIT_VALUE_08),
            .INIT_VALUE_09(INIT_VALUE_09),
            .INIT_VALUE_0A(INIT_VALUE_0A),
            .INIT_VALUE_0B(INIT_VALUE_0B),
            .INIT_VALUE_0C(INIT_VALUE_0C),
            .INIT_VALUE_0D(INIT_VALUE_0D),
            .INIT_VALUE_0E(INIT_VALUE_0E),
            .INIT_VALUE_0F(INIT_VALUE_0F),
            .INIT_VALUE_10(INIT_VALUE_10),
            .INIT_VALUE_11(INIT_VALUE_11),
            .INIT_VALUE_12(INIT_VALUE_12),
            .INIT_VALUE_13(INIT_VALUE_13),
            .INIT_VALUE_14(INIT_VALUE_14),
            .INIT_VALUE_15(INIT_VALUE_15),
            .INIT_VALUE_16(INIT_VALUE_16),
            .INIT_VALUE_17(INIT_VALUE_17),
            .INIT_VALUE_18(INIT_VALUE_18),
            .INIT_VALUE_19(INIT_VALUE_19),
            .INIT_VALUE_1A(INIT_VALUE_1A),
            .INIT_VALUE_1B(INIT_VALUE_1B),
            .INIT_VALUE_1C(INIT_VALUE_1C),
            .INIT_VALUE_1D(INIT_VALUE_1D),
            .INIT_VALUE_1E(INIT_VALUE_1E),
            .INIT_VALUE_1F(INIT_VALUE_1F),
            .INIT_VALUE_20(INIT_VALUE_20),
            .INIT_VALUE_21(INIT_VALUE_21),
            .INIT_VALUE_22(INIT_VALUE_22),
            .INIT_VALUE_23(INIT_VALUE_23),
            .INIT_VALUE_24(INIT_VALUE_24),
            .INIT_VALUE_25(INIT_VALUE_25),
            .INIT_VALUE_26(INIT_VALUE_26),
            .INIT_VALUE_27(INIT_VALUE_27),
            .INIT_VALUE_28(INIT_VALUE_28),
            .INIT_VALUE_29(INIT_VALUE_29),
            .INIT_VALUE_2A(INIT_VALUE_2A),
            .INIT_VALUE_2B(INIT_VALUE_2B),
            .INIT_VALUE_2C(INIT_VALUE_2C),
            .INIT_VALUE_2D(INIT_VALUE_2D),
            .INIT_VALUE_2E(INIT_VALUE_2E),
            .INIT_VALUE_2F(INIT_VALUE_2F),
            .INIT_VALUE_30(INIT_VALUE_30),
            .INIT_VALUE_31(INIT_VALUE_31),
            .INIT_VALUE_32(INIT_VALUE_32),
            .INIT_VALUE_33(INIT_VALUE_33),
            .INIT_VALUE_34(INIT_VALUE_34),
            .INIT_VALUE_35(INIT_VALUE_35),
            .INIT_VALUE_36(INIT_VALUE_36),
            .INIT_VALUE_37(INIT_VALUE_37),
            .INIT_VALUE_38(INIT_VALUE_38),
            .INIT_VALUE_39(INIT_VALUE_39),
            .INIT_VALUE_3A(INIT_VALUE_3A),
            .INIT_VALUE_3B(INIT_VALUE_3B),
            .INIT_VALUE_3C(INIT_VALUE_3C),
            .INIT_VALUE_3D(INIT_VALUE_3D),
            .INIT_VALUE_3E(INIT_VALUE_3E),
            .INIT_VALUE_3F(INIT_VALUE_3F)) uinst_0 (.addr_a_i(addr_a_i), 
                .addr_b_i(addr_b_i), 
                .wr_data_a_i(wr_data_a_i), 
                .wr_data_b_i(wr_data_b_i), 
                .clk_a_i(clk_a_i), 
                .clk_b_i(clk_b_i), 
                .clk_en_a_i(clk_en_a_i), 
                .clk_en_b_i(clk_en_b_i), 
                .wr_en_a_i(wr_en_a_i), 
                .wr_en_b_i(wr_en_b_i), 
                .rst_a_i(rst_a_i), 
                .rst_b_i(rst_b_i), 
                .ben_a_i(ben_a_i), 
                .ben_b_i(ben_b_i), 
                .rd_data_a_o(mem_out_a_w), 
                .rd_data_b_o(mem_out_b_w), 
                .ecc_one_err_a_o(ecc_one_err_a_o), 
                .ecc_two_err_a_o(ecc_two_err_a_o), 
                .ecc_one_err_b_o(ecc_one_err_b_o), 
                .ecc_two_err_b_o(ecc_two_err_b_o)) ; 
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] getByteSize ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    if (((data_width % 9) == 0)) 
                        getByteSize = 9 ;
                    else
                        getByteSize = 8 ;
                end
            default : 
                getByteSize = 8 ;
            endcase 
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



module new_lpddr4_ipgen_lscc_write_through #(parameter FAMILY = "common", 
        parameter DATA_WIDTH = 36, 
        parameter REGMODE = "noreg", 
        parameter WRITE_MODE = "normal") (
    input clk_i, 
    input clk_en_i, 
    input wr_en_i, 
    input rst_i, 
    input [(DATA_WIDTH - 1):0] wr_data_i, 
    input [(DATA_WIDTH - 1):0] mem_out_i, 
    output [(DATA_WIDTH - 1):0] rd_data_o) ;
    if ((WRITE_MODE == "write-through")) 
        begin : WRITE_THROUGH
            reg [(DATA_WIDTH - 1):0] wr_data_p_r ; 
            reg wr_en_p_r ; 
            always
                @(posedge clk_i or 
                    posedge rst_i)
                begin
                    if (rst_i) 
                        begin
                            wr_data_p_r <=  {DATA_WIDTH{1'b0}} ;
                            wr_en_p_r <=  1'b0 ;
                        end
                    else
                        begin
                            wr_data_p_r <=  wr_data_i ;
                            wr_en_p_r <=  wr_en_i ;
                        end
                end
            if ((REGMODE == "noreg")) 
                begin : _NoRegMode
                    assign rd_data_o = (wr_en_p_r ? wr_data_p_r : mem_out_i) ; 
                end
            else
                begin : _RegMode
                    reg [(DATA_WIDTH - 1):0] rd_data_r ; 
                    wire [(DATA_WIDTH - 1):0] rd_data_nxt_w = (wr_en_p_r ? wr_data_p_r : mem_out_i) ; 
                    assign rd_data_o = rd_data_r ; 
                    always
                        @(posedge clk_i or 
                            posedge rst_i)
                        begin
                            if (rst_i) 
                                begin
                                    rd_data_r <=  {DATA_WIDTH{1'b0}} ;
                                end
                            else
                                begin
                                    rd_data_r <=  rd_data_nxt_w ;
                                end
                        end
                end
        end
    else
        begin : NORMAL
            assign rd_data_o = mem_out_i ; 
        end
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp_true_inst.v
// Title                 :
// Dependencies          :
// Description           : Implements a true Dual Port RAM using EBR.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp_true_inst #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_COMMON_ = 0, 
        parameter FAMILY = "common", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : _FCODE_COMMON_), 
        parameter ADDR_DEPTH_A = 1024, 
        parameter ADDR_WIDTH_A = clog2(ADDR_DEPTH_A), 
        parameter DATA_WIDTH_A = 36, 
        parameter ADDR_DEPTH_B = 1024, 
        parameter ADDR_WIDTH_B = clog2(ADDR_DEPTH_B), 
        parameter DATA_WIDTH_B = 36, 
        parameter REGMODE_A = "reg", 
        parameter REGMODE_B = "reg", 
        parameter GSR = "enable", 
        parameter RESETMODE_A = "sync", 
        parameter RESETMODE_B = "sync", 
        parameter RESET_RELEASE_A = "sync", 
        parameter RESET_RELEASE_B = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter MODULE_TYPE = "ram_dp_true", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE_A = 0, 
        parameter BYTE_SIZE_A = getByteSize(DATA_WIDTH_A,
                FAMILY_CODE), 
        parameter BYTE_WIDTH_A = ((BYTE_ENABLE_A == 1) ? roundUP(DATA_WIDTH_A,
                BYTE_SIZE_A) : 1), 
        parameter BYTE_EN_POL_A = "active-high", 
        parameter BYTE_ENABLE_B = 0, 
        parameter BYTE_SIZE_B = getByteSize(DATA_WIDTH_B,
                FAMILY_CODE), 
        parameter BYTE_WIDTH_B = ((BYTE_ENABLE_B == 1) ? roundUP(DATA_WIDTH_B,
                BYTE_SIZE_B) : 1), 
        parameter BYTE_EN_POL_B = "active-high", 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = 0, 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter INIT_VALUE_00 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_01 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_02 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_03 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_04 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_05 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_06 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_07 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_08 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_09 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_0F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_10 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_11 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_12 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_13 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_14 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_15 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_16 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_17 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_18 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_19 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_1F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_20 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_21 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_22 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_23 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_24 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_25 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_26 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_27 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_28 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_29 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_2F = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_30 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_31 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_32 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_33 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_34 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_35 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_36 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_37 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_38 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_39 = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3A = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3B = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3C = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3D = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3E = "0x0000000000000000000000000000000000000000000000000000000000000000", 
        parameter INIT_VALUE_3F = "0x0000000000000000000000000000000000000000000000000000000000000000") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input [(ADDR_WIDTH_A - 1):0] addr_a_i, 
    input [(ADDR_WIDTH_B - 1):0] addr_b_i, 
    input [(DATA_WIDTH_A - 1):0] wr_data_a_i, 
    input [(DATA_WIDTH_B - 1):0] wr_data_b_i, 
    input clk_a_i, 
    input clk_b_i, 
    input clk_en_a_i, 
    input clk_en_b_i, 
    input wr_en_a_i, 
    input wr_en_b_i, 
    input rst_a_i, 
    input rst_b_i, 
    input [(BYTE_WIDTH_A - 1):0] ben_a_i, 
    input [(BYTE_WIDTH_B - 1):0] ben_b_i, 
    output [(DATA_WIDTH_A - 1):0] rd_data_a_o, 
    output [(DATA_WIDTH_B - 1):0] rd_data_b_o, 
    output ecc_one_err_a_o, 
    output ecc_two_err_a_o, 
    output ecc_one_err_b_o, 
    output ecc_two_err_b_o) ;
    localparam STRING_LENGTH = 82 ; 
    genvar i0, 
        i1, 
        i_0, 
        i_1 ; 
    generate
        if ((FAMILY == "common")) 
            begin : behavioral
                (* syn_ramstyle="block_ram" *) reg [(DATA_WIDTH_A - 1):0] mem [((2 ** ADDR_WIDTH_A) - 1):0] ; 
                integer mem_i0 ; 
                initial
                    begin
                        if (((INIT_MODE == "mem_file") && (INIT_FILE != "none"))) 
                            begin
                                if ((INIT_FILE_FORMAT == "hex")) 
                                    begin
                                        $readmemh (INIT_FILE,
                                                mem,
                                                0,
                                                (ADDR_DEPTH_A - 1)) ;
                                    end
                                else
                                    begin
                                        $readmemb (INIT_FILE,
                                                mem,
                                                0,
                                                (ADDR_DEPTH_A - 1)) ;
                                    end
                            end
                    end
                reg [(DATA_WIDTH_A - 1):0] dataout_reg_a_r = {DATA_WIDTH_A{1'b0}} ; 
                reg [(DATA_WIDTH_A - 1):0] dataout_reg_buff_a_r = {DATA_WIDTH_A{1'b0}} ; 
                assign rd_data_a_o = ((REGMODE_A == "reg") ? dataout_reg_a_r : dataout_reg_buff_a_r) ; 
                always
                    @(posedge clk_a_i)
                    begin
                        if ((clk_en_a_i == 1'b1)) 
                            begin
                                if ((wr_en_a_i == 1'b1)) 
                                    begin
                                        mem[addr_a_i] <=  wr_data_a_i ;
                                    end
                                else
                                    begin
                                        dataout_reg_buff_a_r <=  mem[addr_a_i] ;
                                    end
                            end
                    end
                if ((REGMODE_A == "reg")) 
                    begin : _reg_a
                        if ((RESETMODE_A == "sync")) 
                            begin : _sync_rst_a
                                always
                                    @(posedge clk_a_i)
                                    begin
                                        if ((rst_a_i == 1'b1)) 
                                            begin
                                                dataout_reg_a_r <=  'h0 ;
                                            end
                                        else
                                            if ((wr_en_a_i == 1'b0)) 
                                                begin
                                                    dataout_reg_a_r <=  dataout_reg_buff_a_r ;
                                                end
                                    end
                            end
                        else
                            if ((RESET_RELEASE_A == "sync")) 
                                begin : _sync_rel_a
                                    always
                                        @(posedge clk_a_i or 
                                            posedge rst_a_i)
                                        begin
                                            if ((rst_a_i == 1'b1)) 
                                                begin
                                                    dataout_reg_a_r <=  'h0 ;
                                                end
                                            else
                                                if ((wr_en_a_i == 1'b0)) 
                                                    begin
                                                        dataout_reg_a_r <=  dataout_reg_buff_a_r ;
                                                    end
                                        end
                                end
                            else
                                begin : _async_rel_a
                                    reg [(DATA_WIDTH_A - 1):0] dataout_reg_a_buffered_r = {DATA_WIDTH_A{1'b0}} ; 
                                    always
                                        @(*)
                                        begin
                                            if ((rst_a_i == 1'b1)) 
                                                begin
                                                    dataout_reg_a_r = 'h0 ;
                                                end
                                            else
                                                if ((wr_en_a_i == 1'b0)) 
                                                    begin
                                                        dataout_reg_a_r = dataout_reg_a_buffered_r ;
                                                    end
                                        end
                                    always
                                        @(posedge clk_a_i)
                                        begin
                                            dataout_reg_a_buffered_r <=  dataout_reg_buff_a_r ;
                                        end
                                end
                    end
                reg [(DATA_WIDTH_B - 1):0] dataout_reg_b_r = {DATA_WIDTH_B{1'b0}} ; 
                reg [(DATA_WIDTH_B - 1):0] dataout_reg_buff_b_r = {DATA_WIDTH_B{1'b0}} ; 
                assign rd_data_b_o = ((REGMODE_B == "reg") ? dataout_reg_b_r : dataout_reg_buff_b_r) ; 
                always
                    @(posedge clk_b_i)
                    begin
                        if ((clk_en_b_i == 1'b1)) 
                            begin
                                if ((wr_en_b_i == 1'b1)) 
                                    begin
                                        mem[addr_b_i] <=  wr_data_b_i ;
                                    end
                                else
                                    begin
                                        dataout_reg_buff_b_r <=  mem[addr_b_i] ;
                                    end
                            end
                    end
                if ((REGMODE_B == "reg")) 
                    begin : _reg_b
                        if ((RESETMODE_B == "sync")) 
                            begin : _sync_rst_b
                                always
                                    @(posedge clk_b_i)
                                    begin
                                        if ((rst_b_i == 1'b1)) 
                                            begin
                                                dataout_reg_b_r <=  'h0 ;
                                            end
                                        else
                                            if ((wr_en_b_i == 1'b0)) 
                                                begin
                                                    dataout_reg_b_r <=  dataout_reg_buff_b_r ;
                                                end
                                    end
                            end
                        else
                            if ((RESET_RELEASE_B == "sync")) 
                                begin : _sync_rel_b
                                    always
                                        @(posedge clk_b_i or 
                                            posedge rst_b_i)
                                        begin
                                            if ((rst_b_i == 1'b1)) 
                                                begin
                                                    dataout_reg_b_r <=  'h0 ;
                                                end
                                            else
                                                if ((wr_en_b_i == 1'b0)) 
                                                    begin
                                                        dataout_reg_b_r <=  dataout_reg_buff_b_r ;
                                                    end
                                        end
                                end
                            else
                                begin : _async_rel_b
                                    reg [(DATA_WIDTH_B - 1):0] dataout_reg_b_buffered_r = {DATA_WIDTH_B{1'b0}} ; 
                                    always
                                        @(*)
                                        begin
                                            if ((rst_b_i == 1'b1)) 
                                                begin
                                                    dataout_reg_b_r = 'h0 ;
                                                end
                                            else
                                                if ((wr_en_b_i == 1'b0)) 
                                                    begin
                                                        dataout_reg_b_r = dataout_reg_b_buffered_r ;
                                                    end
                                        end
                                    always
                                        @(posedge clk_b_i)
                                        begin
                                            dataout_reg_b_buffered_r <=  dataout_reg_buff_b_r ;
                                        end
                                end
                    end
            end
        else
            begin : prim
                // ---------------------------------------
                // ------ SAME WIDTH Implementation ------
                // ---------------------------------------
                if (((ADDR_DEPTH_A == ADDR_DEPTH_B) && (DATA_WIDTH_A == DATA_WIDTH_B))) 
                    begin : NON_MIX
                        // ---------------------------------------------------
                        // ------ Local Parameters for EBR Optimization ------
                        // ---------------------------------------------------
                        localparam OPT_DATA_WIDTH = getMinimaData(ADDR_DEPTH_A,
                                    DATA_WIDTH_A,
                                    (BYTE_ENABLE_A || BYTE_ENABLE_B),
                                    BYTE_SIZE_A,
                                    FAMILY_CODE) ; 
                        localparam OPT_ADDR_DEPTH = data_to_addr(OPT_DATA_WIDTH,
                                    FAMILY_CODE) ; 
                        localparam OPT_ADDR_WIDTH = clog2(OPT_ADDR_DEPTH) ; 
                        localparam EBR_DATA = roundUP(DATA_WIDTH_A,
                                    OPT_DATA_WIDTH) ; 
                        localparam EBR_ADDR = roundUP(ADDR_DEPTH_A,
                                    OPT_ADDR_DEPTH) ; 
                        localparam BWID_A = ((BYTE_ENABLE_A == 0) ? 1 : (((OPT_DATA_WIDTH == 18) || (OPT_DATA_WIDTH == 16)) ? 2 : 1)) ; 
                        localparam BWID_B = ((BYTE_ENABLE_B == 0) ? 1 : (((OPT_DATA_WIDTH == 18) || (OPT_DATA_WIDTH == 16)) ? 2 : 1)) ; 
                        // ------ PORT A & B Output MUX ------
                        wire [(DATA_WIDTH_A - 1):0] rd_data_raw_a_w [(EBR_ADDR - 1):0] ; 
                        wire [(DATA_WIDTH_B - 1):0] rd_data_raw_b_w [(EBR_ADDR - 1):0] ; 
                        // ------ PORT A Address Wiring ------
                        wire [(OPT_ADDR_WIDTH - 1):0] addr_a_w ; 
                        if ((OPT_ADDR_WIDTH > ADDR_WIDTH_A)) 
                            begin : port_a_wiring
                                assign addr_a_w[(ADDR_WIDTH_A - 1):0] = addr_a_i ; 
                                assign addr_a_w[(OPT_ADDR_WIDTH - 1):ADDR_WIDTH_A] = {(OPT_ADDR_WIDTH - ADDR_WIDTH_A){1'b0}} ; 
                            end
                        else
                            begin : genblk1
                                assign addr_a_w = addr_a_i[(OPT_ADDR_WIDTH - 1):0] ; 
                            end
                        // ------ PORT B Address Wiring ------
                        wire [(OPT_ADDR_WIDTH - 1):0] addr_b_w ; 
                        if ((OPT_ADDR_WIDTH > ADDR_WIDTH_B)) 
                            begin : port_b_wiring
                                assign addr_b_w[(ADDR_WIDTH_B - 1):0] = addr_b_i ; 
                                assign addr_b_w[(OPT_ADDR_WIDTH - 1):ADDR_WIDTH_B] = {(OPT_ADDR_WIDTH - ADDR_WIDTH_B){1'b0}} ; 
                            end
                        else
                            begin : genblk2
                                assign addr_b_w = addr_b_i[(OPT_ADDR_WIDTH - 1):0] ; 
                            end
                        // ------ Address Loop (Same Width) ------
                        for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                        begin : xADDR
                            // ------ PORT A output ports ------
                            wire [(DATA_WIDTH_A - 1):0] raw_out_a_w ; 
                            assign rd_data_raw_a_w[i0] = raw_out_a_w ; 
                            // ------ PORT A Address Control Signal ------
                            wire chk_addr_a_w ; 
                            if ((EBR_ADDR > 1)) 
                                begin : genblk1
                                    assign chk_addr_a_w = ((addr_a_i[(ADDR_WIDTH_A - 1):OPT_ADDR_WIDTH] == i0) ? 1'b1 : 1'b0) ; 
                                end
                            else
                                begin : genblk1
                                    assign chk_addr_a_w = 1'b1 ; 
                                end
                            // ------ PORT B output ports ------
                            wire [(DATA_WIDTH_B - 1):0] raw_out_b_w ; 
                            assign rd_data_raw_b_w[i0] = raw_out_b_w ; 
                            // ------ PORT B Address Control Signal ------
                            wire chk_addr_b_w ; 
                            if ((EBR_ADDR > 1)) 
                                begin : genblk2
                                    assign chk_addr_b_w = ((addr_b_i[(ADDR_WIDTH_B - 1):OPT_ADDR_WIDTH] == i0) ? 1'b1 : 1'b0) ; 
                                end
                            else
                                begin : genblk2
                                    assign chk_addr_b_w = 1'b1 ; 
                                end
                            // ------ Data Loop (Same Width) ------
                            for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                            begin : xDATA
                                localparam ECO_POSX = (i1 * OPT_DATA_WIDTH) ; 
                                localparam ECO_POSY = (i0 * OPT_ADDR_DEPTH) ; 
                                // ------ PORT A Data Wiring ------
                                wire [(OPT_DATA_WIDTH - 1):0] in_a_w ; 
                                wire [(OPT_DATA_WIDTH - 1):0] out_a_w ; 
                                if (((OPT_DATA_WIDTH * (i1 + 1)) < DATA_WIDTH_A)) 
                                    begin : ASSIGN_A
                                        assign in_a_w = wr_data_a_i[((OPT_DATA_WIDTH * (i1 + 1)) - 1):(OPT_DATA_WIDTH * i1)] ; 
                                        assign raw_out_a_w[((OPT_DATA_WIDTH * (i1 + 1)) - 1):(OPT_DATA_WIDTH * i1)] = out_a_w ; 
                                    end
                                else
                                    begin : genblk1
                                        assign in_a_w[(DATA_WIDTH_A - (1 + (OPT_DATA_WIDTH * i1))):0] = wr_data_a_i[(DATA_WIDTH_A - 1):(OPT_DATA_WIDTH * i1)] ; 
                                        if ((OPT_DATA_WIDTH > (DATA_WIDTH_A - (OPT_DATA_WIDTH * i1)))) 
                                            begin : genblk1
                                                assign in_a_w[(OPT_DATA_WIDTH - 1):(DATA_WIDTH_A - (OPT_DATA_WIDTH * i1))] = {(OPT_DATA_WIDTH - (DATA_WIDTH_A - (OPT_DATA_WIDTH * i1))){1'b0}} ; 
                                            end
                                        assign raw_out_a_w[(DATA_WIDTH_A - 1):(OPT_DATA_WIDTH * i1)] = out_a_w[(DATA_WIDTH_A - (1 + (OPT_DATA_WIDTH * i1))):0] ; 
                                    end
                                // ------ PORT B Data Wiring ------
                                wire [(OPT_DATA_WIDTH - 1):0] in_b_w ; 
                                wire [(OPT_DATA_WIDTH - 1):0] out_b_w ; 
                                if (((OPT_DATA_WIDTH * (i1 + 1)) < DATA_WIDTH_B)) 
                                    begin : ASSIGN_B
                                        assign in_b_w = wr_data_b_i[((OPT_DATA_WIDTH * (i1 + 1)) - 1):(OPT_DATA_WIDTH * i1)] ; 
                                        assign raw_out_b_w[((OPT_DATA_WIDTH * (i1 + 1)) - 1):(OPT_DATA_WIDTH * i1)] = out_b_w ; 
                                    end
                                else
                                    begin : genblk2
                                        assign in_b_w[(DATA_WIDTH_B - (1 + (OPT_DATA_WIDTH * i1))):0] = wr_data_b_i[(DATA_WIDTH_B - 1):(OPT_DATA_WIDTH * i1)] ; 
                                        if ((OPT_DATA_WIDTH > (DATA_WIDTH_B - (OPT_DATA_WIDTH * i1)))) 
                                            begin : genblk1
                                                assign in_b_w[(OPT_DATA_WIDTH - 1):(DATA_WIDTH_B - (OPT_DATA_WIDTH * i1))] = {(OPT_DATA_WIDTH - (DATA_WIDTH_B - (OPT_DATA_WIDTH * i1))){1'b0}} ; 
                                            end
                                        assign raw_out_b_w[(DATA_WIDTH_B - 1):(OPT_DATA_WIDTH * i1)] = out_b_w[(DATA_WIDTH_B - (1 + (OPT_DATA_WIDTH * i1))):0] ; 
                                    end
                                wire [(BWID_A - 1):0] ben_a_w ; 
                                wire [(BWID_B - 1):0] ben_b_w ; 
                                // ------ Byte-Enable Wiring ------
                                if ((BWID_A == 2)) 
                                    begin : BEN_MULT_A
                                        if ((BYTE_ENABLE_A == 1)) 
                                            begin : genblk1
                                                if ((((i1 + 1) * BWID_A) < BYTE_WIDTH_A)) 
                                                    begin : _A
                                                        assign ben_a_w = ben_a_i[(((i1 + 1) * BWID_A) - 1):(i1 * BWID_A)] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign ben_a_w[(BYTE_WIDTH_A - (1 + (i1 * BWID_A))):0] = ben_a_i[(BYTE_WIDTH_A - 1):(i1 * BWID_A)] ; 
                                                        if ((((i1 + 1) * BWID_A) > BYTE_WIDTH_A)) 
                                                            begin : genblk1
                                                                assign ben_a_w[(BWID_A - 1):(BYTE_WIDTH_A - (i1 * BWID_A))] = {(BWID_A - (BYTE_WIDTH_A - (i1 * BWID_A))){1'b0}} ; 
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                assign ben_a_w = {BWID_A{1'b1}} ; 
                                            end
                                    end
                                else
                                    begin : BEN_SING_A
                                        if ((BYTE_ENABLE_A == 1)) 
                                            begin : genblk1
                                                if ((OPT_DATA_WIDTH >= 8)) 
                                                    begin : genblk1
                                                        assign ben_a_w = ben_a_i[i1] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign ben_a_w = ben_a_i[(((i1 * OPT_DATA_WIDTH) * BYTE_WIDTH_A) / DATA_WIDTH_A)] ; 
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                assign ben_a_w = {BWID_A{1'b1}} ; 
                                            end
                                    end
                                if ((BWID_B == 2)) 
                                    begin : BEN_MULT_B
                                        if ((BYTE_ENABLE_B == 1)) 
                                            begin : genblk1
                                                if ((((i1 + 1) * 2) < BYTE_WIDTH_B)) 
                                                    begin : _B
                                                        assign ben_b_w = ben_b_i[(((i1 + 1) * BWID_B) - 1):(i1 * BWID_B)] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign ben_b_w[(BYTE_WIDTH_B - (1 + (i1 * BWID_B))):0] = ben_b_i[(BYTE_WIDTH_B - 1):(i1 * BWID_B)] ; 
                                                        if ((((i1 + 1) * BWID_B) > BYTE_WIDTH_B)) 
                                                            begin : genblk1
                                                                assign ben_b_w[(BWID_B - 1):(BYTE_WIDTH_B - (i1 * BWID_B))] = {(BWID_B - (BYTE_WIDTH_B - (i1 * BWID_B))){1'b0}} ; 
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                assign ben_b_w = {BWID_B{1'b1}} ; 
                                            end
                                    end
                                else
                                    begin : BEN_SING_B
                                        if ((BYTE_ENABLE_B == 1)) 
                                            begin : genblk1
                                                if ((OPT_DATA_WIDTH >= 8)) 
                                                    begin : genblk1
                                                        assign ben_b_w = ben_b_i[i1] ; 
                                                    end
                                                else
                                                    begin : genblk1
                                                        assign ben_b_w = ben_b_i[(((i1 * OPT_DATA_WIDTH) * BYTE_WIDTH_B) / DATA_WIDTH_B)] ; 
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                assign ben_b_w = {BWID_B{1'b1}} ; 
                                            end
                                    end
                                // ------------------------------------
                                // ------ SINGLE MEMORY INSTANCE ------
                                // ------------------------------------
                                if ((INIT_MODE == "mem_file")) 
                                    begin : mem_file
                                        new_lpddr4_ipgen_lscc_ram_dp_true_core #(.FAMILY(FAMILY),
                                                .INIT_MODE(INIT_MODE),
                                                .MEM_SIZE(MEM_SIZE),
                                                .MEM_ID(MEM_ID),
                                                .POSx(ECO_POSX),
                                                .POSy(ECO_POSY),
                                                .DATA_WIDTH_A(OPT_DATA_WIDTH),
                                                .REGMODE_A(REGMODE_A),
                                                .RESETMODE_A(RESETMODE_A),
                                                .RESET_RELEASE_A(RESET_RELEASE_A),
                                                .BYTE_ENABLE_A(BYTE_ENABLE_A),
                                                .BYTE_EN_POL_A(BYTE_EN_POL_A),
                                                .DATA_WIDTH_B(OPT_DATA_WIDTH),
                                                .REGMODE_B(REGMODE_B),
                                                .RESETMODE_B(RESETMODE_B),
                                                .RESET_RELEASE_B(RESET_RELEASE_B),
                                                .BYTE_ENABLE_B(BYTE_ENABLE_B),
                                                .BYTE_EN_POL_B(BYTE_EN_POL_B),
                                                .INITVAL_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                .INITVAL_10(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_11(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_12(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_13(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_14(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_15(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_16(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_17(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_18(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_19(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_1A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_1B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_1C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_1D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_1E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_1F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_20(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_21(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_22(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_23(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_24(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_25(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_26(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_27(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_28(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_29(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_2A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_2B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_2C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_2D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_2E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_2F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_30(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_31(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_32(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_33(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_34(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_35(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_36(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_37(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_38(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_39(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_3A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_3B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_3C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_3D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_3E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                .INITVAL_3F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_dp16k (// ------ COMMON PARAMETERS ------
                                                // ------ PORT A PARAMETERS ------
                                                // ------ PORT B PARAMETERS ------
                                                // ------ INIT PARAMETERS ------
                                                // ------ PORT A signals ------
                                                .clk_a_i(clk_a_i), 
                                                    .clk_en_a_i(clk_en_a_i), 
                                                    .rst_a_i(rst_a_i), 
                                                    .wr_en_a_i((wr_en_a_i & chk_addr_a_w)), 
                                                    .ben_a_i(ben_a_w), 
                                                    .addr_a_i(addr_a_w), 
                                                    .wr_data_a_i(in_a_w), 
                                                    .rd_data_a_o(out_a_w), 
                                                    // ------ PORT B signals ------
                                                .clk_b_i(clk_b_i), 
                                                    .clk_en_b_i(clk_en_b_i), 
                                                    .rst_b_i(rst_b_i), 
                                                    .wr_en_b_i((wr_en_b_i & chk_addr_b_w)), 
                                                    .ben_b_i(ben_b_w), 
                                                    .addr_b_i(addr_b_w), 
                                                    .wr_data_b_i(in_b_w), 
                                                    .rd_data_b_o(out_b_w)) ; 
                                    end
                                else
                                    begin : no_mem_file
                                        new_lpddr4_ipgen_lscc_ram_dp_true_core #(.FAMILY(FAMILY),
                                                .INIT_MODE(INIT_MODE),
                                                .MEM_SIZE(MEM_SIZE),
                                                .MEM_ID(MEM_ID),
                                                .POSx(ECO_POSX),
                                                .POSy(ECO_POSY),
                                                .DATA_WIDTH_A(OPT_DATA_WIDTH),
                                                .REGMODE_A(REGMODE_A),
                                                .RESETMODE_A(RESETMODE_A),
                                                .RESET_RELEASE_A(RESET_RELEASE_A),
                                                .BYTE_ENABLE_A(BYTE_ENABLE_A),
                                                .BYTE_EN_POL_A(BYTE_EN_POL_A),
                                                .DATA_WIDTH_B(OPT_DATA_WIDTH),
                                                .REGMODE_B(REGMODE_B),
                                                .RESETMODE_B(RESETMODE_B),
                                                .RESET_RELEASE_B(RESET_RELEASE_B),
                                                .BYTE_ENABLE_B(BYTE_ENABLE_B),
                                                .BYTE_EN_POL_B(BYTE_EN_POL_B)) u_dp16k (// ------ COMMON PARAMETERS ------
                                                // ------ PORT A PARAMETERS ------
                                                // ------ PORT B PARAMETERS ------
                                                // ------ PORT A signals ------
                                                .clk_a_i(clk_a_i), 
                                                    .clk_en_a_i(clk_en_a_i), 
                                                    .rst_a_i(rst_a_i), 
                                                    .wr_en_a_i((wr_en_a_i & chk_addr_a_w)), 
                                                    .ben_a_i(ben_a_w), 
                                                    .addr_a_i(addr_a_w), 
                                                    .wr_data_a_i(in_a_w), 
                                                    .rd_data_a_o(out_a_w), 
                                                    // ------ PORT B signals ------
                                                .clk_b_i(clk_b_i), 
                                                    .clk_en_b_i(clk_en_b_i), 
                                                    .rst_b_i(rst_b_i), 
                                                    .wr_en_b_i((wr_en_b_i & chk_addr_b_w)), 
                                                    .ben_b_i(ben_b_w), 
                                                    .addr_b_i(addr_b_w), 
                                                    .wr_data_b_i(in_b_w), 
                                                    .rd_data_b_o(out_b_w)) ; 
                                    end
                            end
                        end
                        if ((EBR_ADDR == 1)) 
                            begin : ONE_OUT
                                assign rd_data_a_o = rd_data_raw_a_w[0] ; 
                                assign rd_data_b_o = rd_data_raw_b_w[0] ; 
                            end
                        else
                            begin : MULT_OUT
                                // ------ PORT A output assignment
                                reg [(DATA_WIDTH_A - 1):0] a_out_buff_r ; 
                                reg [(ADDR_WIDTH_A - 1):0] addr_a_p_r ; 
                                assign rd_data_a_o = a_out_buff_r ; 
                                always
                                    @(*)
                                    begin
                                        a_out_buff_r = rd_data_raw_a_w[addr_a_p_r[(ADDR_WIDTH_A - 1):OPT_ADDR_WIDTH]] ;
                                    end
                                if ((REGMODE_A == "noreg")) 
                                    begin : genblk1
                                        if ((RESETMODE_A == "sync")) 
                                            begin : genblk1
                                                always
                                                    @(posedge clk_a_i)
                                                    begin
                                                        if (rst_a_i) 
                                                            begin
                                                                addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_a_p_r <=  addr_a_i ;
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                always
                                                    @(posedge clk_a_i or 
                                                        posedge rst_a_i)
                                                    begin
                                                        if (rst_a_i) 
                                                            begin
                                                                addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_a_p_r <=  addr_a_i ;
                                                            end
                                                    end
                                            end
                                    end
                                else
                                    begin : genblk1
                                        reg [(ADDR_WIDTH_A - 1):0] addr_a_p2_r ; 
                                        if ((RESETMODE_A == "sync")) 
                                            begin : genblk1
                                                always
                                                    @(posedge clk_a_i)
                                                    begin
                                                        if (rst_a_i) 
                                                            begin
                                                                addr_a_p2_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_a_p2_r <=  addr_a_i ;
                                                                addr_a_p_r <=  addr_a_p2_r ;
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                always
                                                    @(posedge clk_a_i or 
                                                        posedge rst_a_i)
                                                    begin
                                                        if (rst_a_i) 
                                                            begin
                                                                addr_a_p2_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_a_p2_r <=  addr_a_i ;
                                                                addr_a_p_r <=  addr_a_p2_r ;
                                                            end
                                                    end
                                            end
                                    end
                                // ------ PORT B output assignment
                                reg [(DATA_WIDTH_B - 1):0] b_out_buff_r ; 
                                reg [(ADDR_WIDTH_B - 1):0] addr_b_p_r ; 
                                assign rd_data_b_o = b_out_buff_r ; 
                                always
                                    @(*)
                                    begin
                                        b_out_buff_r = rd_data_raw_b_w[addr_b_p_r[(ADDR_WIDTH_B - 1):OPT_ADDR_WIDTH]] ;
                                    end
                                if ((REGMODE_B == "noreg")) 
                                    begin : genblk2
                                        if ((RESETMODE_B == "sync")) 
                                            begin : genblk1
                                                always
                                                    @(posedge clk_b_i)
                                                    begin
                                                        if (rst_b_i) 
                                                            begin
                                                                addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_b_p_r <=  addr_b_i ;
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                always
                                                    @(posedge clk_b_i or 
                                                        posedge rst_b_i)
                                                    begin
                                                        if (rst_b_i) 
                                                            begin
                                                                addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_b_p_r <=  addr_b_i ;
                                                            end
                                                    end
                                            end
                                    end
                                else
                                    begin : genblk2
                                        reg [(ADDR_WIDTH_B - 1):0] addr_b_p2_r ; 
                                        if ((RESETMODE_B == "sync")) 
                                            begin : genblk1
                                                always
                                                    @(posedge clk_b_i)
                                                    begin
                                                        if (rst_b_i) 
                                                            begin
                                                                addr_b_p2_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_b_p2_r <=  addr_b_i ;
                                                                addr_b_p_r <=  addr_b_p2_r ;
                                                            end
                                                    end
                                            end
                                        else
                                            begin : genblk1
                                                always
                                                    @(posedge clk_b_i or 
                                                        posedge rst_b_i)
                                                    begin
                                                        if (rst_b_i) 
                                                            begin
                                                                addr_b_p2_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                            end
                                                        else
                                                            begin
                                                                addr_b_p2_r <=  addr_b_i ;
                                                                addr_b_p_r <=  addr_b_p2_r ;
                                                            end
                                                    end
                                            end
                                    end
                            end
                    end
                else
                    // ---------------------------------------------------------
                    // ------ Mixed WIDTH Implementation (no Byte-Enable) ------
                    // ---------------------------------------------------------
                    if (((BYTE_ENABLE_A == 0) && (BYTE_ENABLE_B == 0))) 
                        begin : MIX_N_BEN
                            // ---------------------------------------------------
                            // ------ Local Parameters for EBR Optimization ------
                            // ---------------------------------------------------
                            localparam Q_FACTOR = ((DATA_WIDTH_A > DATA_WIDTH_B) ? (DATA_WIDTH_A / DATA_WIDTH_B) : (DATA_WIDTH_B / DATA_WIDTH_A)) ; 
                            localparam MAX_DATA = ((DATA_WIDTH_A > DATA_WIDTH_B) ? DATA_WIDTH_A : DATA_WIDTH_B) ; 
                            localparam MAX_PORT = ((DATA_WIDTH_A > DATA_WIDTH_B) ? "A" : "B") ; 
                            localparam MIN_DEPTH = ((MAX_PORT == "A") ? ADDR_DEPTH_A : ADDR_DEPTH_B) ; 
                            localparam PROC_MAX_DATA = procData(MAX_DATA,
                                        FAMILY_CODE) ; 
                            localparam PROC_MIN_DEPTH = (2 ** clog2(MIN_DEPTH)) ; 
                            localparam PROC_MIN_DATA = (PROC_MAX_DATA / Q_FACTOR) ; 
                            localparam PROC_MAX_DEPTH = (PROC_MIN_DEPTH * Q_FACTOR) ; 
                            localparam PORT_A_DATA_USE = ((MAX_PORT == "A") ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                            localparam PORT_A_DEPTH_USE = ((MAX_PORT == "A") ? PROC_MIN_DEPTH : PROC_MAX_DEPTH) ; 
                            localparam PORT_A_DEPTH_WIDTH = clog2(PORT_A_DEPTH_USE) ; 
                            localparam PORT_B_DATA_USE = ((MAX_PORT == "B") ? PROC_MAX_DATA : PROC_MIN_DATA) ; 
                            localparam PORT_B_DEPTH_USE = ((MAX_PORT == "B") ? PROC_MIN_DEPTH : PROC_MAX_DEPTH) ; 
                            localparam PORT_B_DEPTH_WIDTH = clog2(PORT_B_DEPTH_USE) ; 
                            localparam A_DWID_IMPL = getCASE1DataImpl(PORT_A_DEPTH_USE,
                                        PORT_A_DATA_USE,
                                        PORT_B_DEPTH_USE,
                                        PORT_B_DATA_USE,
                                        1'b1,
                                        0,
                                        FAMILY_CODE) ; 
                            localparam A_DEPTH_IMPL = data_to_addr(A_DWID_IMPL,
                                        FAMILY_CODE) ; 
                            localparam A_AWID_IMPL = clog2(A_DEPTH_IMPL) ; 
                            localparam B_DWID_IMPL = getCASE1DataImpl(PORT_A_DEPTH_USE,
                                        PORT_A_DATA_USE,
                                        PORT_B_DEPTH_USE,
                                        PORT_B_DATA_USE,
                                        1'b0,
                                        0,
                                        FAMILY_CODE) ; 
                            localparam B_DEPTH_IMPL = data_to_addr(B_DWID_IMPL,
                                        FAMILY_CODE) ; 
                            localparam B_AWID_IMPL = clog2(B_DEPTH_IMPL) ; 
                            localparam EBR_ADDR = roundUP(PORT_A_DEPTH_USE,
                                        A_DEPTH_IMPL) ; 
                            localparam EBR_DATA = roundUP(PORT_A_DATA_USE,
                                        A_DWID_IMPL) ; 
                            // ------ Port A address truncation ------
                            wire [(A_AWID_IMPL - 1):0] addr_a_w ; 
                            if ((A_AWID_IMPL > ADDR_WIDTH_A)) 
                                begin : genblk1
                                    assign addr_a_w[(A_AWID_IMPL - 1):ADDR_WIDTH_A] = {(A_AWID_IMPL - ADDR_WIDTH_A){1'b0}} ; 
                                    assign addr_a_w[(ADDR_WIDTH_A - 1):0] = addr_a_i ; 
                                end
                            else
                                begin : genblk1
                                    assign addr_a_w[(A_AWID_IMPL - 1):0] = addr_a_i[(A_AWID_IMPL - 1):0] ; 
                                end
                            // ------ Port B address truncation ------
                            wire [(B_AWID_IMPL - 1):0] addr_b_w ; 
                            if ((B_AWID_IMPL > ADDR_WIDTH_B)) 
                                begin : genblk2
                                    assign addr_b_w[(B_AWID_IMPL - 1):ADDR_WIDTH_B] = {(B_AWID_IMPL - ADDR_WIDTH_B){1'b0}} ; 
                                    assign addr_b_w[(ADDR_WIDTH_B - 1):0] = addr_b_i ; 
                                end
                            else
                                begin : genblk2
                                    assign addr_b_w[(B_AWID_IMPL - 1):0] = addr_b_i[(B_AWID_IMPL - 1):0] ; 
                                end
                            // ------ TOP level wiring ports ------
                            wire [(PORT_A_DATA_USE - 1):0] in_a_top_w ; 
                            wire [(PORT_B_DATA_USE - 1):0] in_b_top_w ; 
                            wire [(PORT_A_DATA_USE - 1):0] out_a_top_w ; 
                            wire [(PORT_B_DATA_USE - 1):0] out_b_top_w ; 
                            // ------ EBR level wiring ports ------
                            wire [(PORT_A_DATA_USE - 1):0] in_a_ebr_w ; 
                            wire [(PORT_B_DATA_USE - 1):0] in_b_ebr_w ; 
                            wire [(PORT_A_DATA_USE - 1):0] out_a_ebr_w ; 
                            wire [(PORT_B_DATA_USE - 1):0] out_b_ebr_w ; 
                            // ------ Output Port MUX ------
                            wire [(PORT_A_DATA_USE - 1):0] out_a_ebr_raw_w [(EBR_ADDR - 1):0] ; 
                            wire [(PORT_B_DATA_USE - 1):0] out_b_ebr_raw_w [(EBR_ADDR - 1):0] ; 
                            // ------------------------------------------------
                            // ------ WIRING translation from TOP to EBR ------
                            // ------------------------------------------------
                            if ((PORT_A_DATA_USE > PORT_B_DATA_USE)) 
                                begin : A_OVR_B
                                    // ------ PORT B (TOP wrapper to TOP level split) Wiring : (DATA_WIDTH_A > DATA_WIDTH_B) ------
                                    if ((PORT_B_DATA_USE > DATA_WIDTH_B)) 
                                        begin : genblk1
                                            assign in_b_top_w[(PORT_B_DATA_USE - 1):DATA_WIDTH_B] = {(PORT_B_DATA_USE - DATA_WIDTH_B){1'b0}} ; 
                                        end
                                    assign in_b_top_w[(DATA_WIDTH_B - 1):0] = wr_data_b_i ; 
                                    assign rd_data_b_o = out_b_top_w[(DATA_WIDTH_B - 1):0] ; 
                                    // ------ PORT A (TOP wrapper to TOP level split) Wiring : (DATA_WIDTH_A > DATA_WIDTH_B) ------
                                    wire [(PORT_B_DATA_USE - 1):0] inp_a_buff_seg_w [((PORT_A_DATA_USE / PORT_B_DATA_USE) - 1):0] ; 
                                    wire [(PORT_B_DATA_USE - 1):0] out_a_buff_seg_w [((PORT_A_DATA_USE / PORT_B_DATA_USE) - 1):0] ; 
                                    for (i_0 = 0;(i_0 < (PORT_A_DATA_USE / PORT_B_DATA_USE));i_0 = (i_0 + 1))
                                    begin : genblk2
                                        assign inp_a_buff_seg_w[i_0] = wr_data_a_i[((DATA_WIDTH_B * (i_0 + 1)) - 1):(DATA_WIDTH_B * i_0)] ; 
                                        assign rd_data_a_o[((DATA_WIDTH_B * (i_0 + 1)) - 1):(DATA_WIDTH_B * i_0)] = out_a_buff_seg_w[i_0] ; 
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_A_DATA_USE / PORT_B_DATA_USE));i_0 = (i_0 + 1))
                                    begin : genblk3
                                        assign in_a_top_w[(((i_0 * PORT_B_DATA_USE) + PORT_B_DATA_USE) - 1):(i_0 * PORT_B_DATA_USE)] = inp_a_buff_seg_w[i_0] ; 
                                        assign out_a_buff_seg_w[i_0] = out_a_top_w[(((i_0 * PORT_B_DATA_USE) + PORT_B_DATA_USE) - 1):(i_0 * PORT_B_DATA_USE)] ; 
                                    end
                                    // ------ PORT B (TOP level to EBR level splt) Wiring : (DATA_WIDTH_A > DATA_WIDTH_B) ------
                                    assign in_b_ebr_w = in_b_top_w ; 
                                    assign out_b_top_w = out_b_ebr_w ; 
                                    // ------ PORT A (TOP level to EBR level splt) Wiring : (DATA_WIDTH_A > DATA_WIDTH_B) ------
                                    wire [(B_DWID_IMPL - 1):0] in_a_ebr_seg_w [((PORT_A_DATA_USE / B_DWID_IMPL) - 1):0] ; 
                                    wire [(B_DWID_IMPL - 1):0] out_a_ebr_seg_w [((PORT_A_DATA_USE / B_DWID_IMPL) - 1):0] ; 
                                    for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                    begin : genblk4
                                        for (i_1 = 0;(i_1 < (PORT_A_DATA_USE / (B_DWID_IMPL * EBR_DATA)));i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign in_a_ebr_seg_w[(((PORT_A_DATA_USE / (B_DWID_IMPL * EBR_DATA)) * i_0) + i_1)] = in_a_top_w[((((i_0 * B_DWID_IMPL) + ((i_1 * EBR_DATA) * B_DWID_IMPL)) + B_DWID_IMPL) - 1):((i_0 * B_DWID_IMPL) + ((i_1 * EBR_DATA) * B_DWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_A_DATA_USE / B_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk5
                                        assign in_a_ebr_w[(((i_0 * B_DWID_IMPL) + B_DWID_IMPL) - 1):(i_0 * B_DWID_IMPL)] = in_a_ebr_seg_w[i_0] ; 
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_A_DATA_USE / PORT_B_DATA_USE));i_0 = (i_0 + 1))
                                    begin : genblk6
                                        for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign out_a_ebr_seg_w[((i_0 * EBR_DATA) + i_1)] = out_a_ebr_w[((((i_1 * A_DWID_IMPL) + (i_0 * B_DWID_IMPL)) + B_DWID_IMPL) - 1):((i_1 * A_DWID_IMPL) + (i_0 * B_DWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_A_DATA_USE / B_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk7
                                        assign out_a_top_w[(((i_0 * B_DWID_IMPL) + B_DWID_IMPL) - 1):(i_0 * B_DWID_IMPL)] = out_a_ebr_seg_w[i_0] ; 
                                    end
                                end
                            else
                                begin : B_OVR_A
                                    // ------ PORT A (TOP wrapper to TOP level split) Wiring : (DATA_WIDTH_B > DATA_WIDTH_A) ------
                                    if ((PORT_A_DATA_USE > DATA_WIDTH_A)) 
                                        begin : genblk1
                                            assign in_a_top_w[(PORT_A_DATA_USE - 1):DATA_WIDTH_A] = {(PORT_A_DATA_USE - DATA_WIDTH_A){1'b0}} ; 
                                        end
                                    assign in_a_top_w[(DATA_WIDTH_A - 1):0] = wr_data_a_i ; 
                                    assign rd_data_a_o = out_a_top_w ; 
                                    // ------ PORT B (TOP wrapper to TOP level split) Wiring : (DATA_WIDTH_B > DATA_WIDTH_A) ------
                                    wire [(PORT_A_DATA_USE - 1):0] inp_b_buff_seg_w [((PORT_B_DATA_USE / PORT_A_DATA_USE) - 1):0] ; 
                                    wire [(PORT_A_DATA_USE - 1):0] out_b_buff_seg_w [((PORT_B_DATA_USE / PORT_A_DATA_USE) - 1):0] ; 
                                    for (i_0 = 0;(i_0 < (PORT_B_DATA_USE / PORT_A_DATA_USE));i_0 = (i_0 + 1))
                                    begin : genblk2
                                        assign inp_b_buff_seg_w[i_0] = wr_data_b_i[((DATA_WIDTH_A * (i_0 + 1)) - 1):(DATA_WIDTH_A * i_0)] ; 
                                        assign rd_data_b_o[((DATA_WIDTH_A * (i_0 + 1)) - 1):(DATA_WIDTH_A * i_0)] = out_b_buff_seg_w[i_0] ; 
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_B_DATA_USE / PORT_A_DATA_USE));i_0 = (i_0 + 1))
                                    begin : genblk3
                                        assign in_b_top_w[(((i_0 * PORT_A_DATA_USE) + PORT_A_DATA_USE) - 1):(i_0 * PORT_A_DATA_USE)] = inp_b_buff_seg_w[i_0] ; 
                                        assign out_b_buff_seg_w[i_0] = out_b_top_w[(((i_0 * PORT_A_DATA_USE) + PORT_A_DATA_USE) - 1):(i_0 * PORT_A_DATA_USE)] ; 
                                    end
                                    // ------ PORT A (TOP level to EBR level splt) Wiring : (DATA_WIDTH_B > DATA_WIDTH_A) ------
                                    assign in_a_ebr_w = in_a_top_w ; 
                                    assign out_a_top_w = out_a_ebr_w ; 
                                    // ------ PORT B (TOP level to EBR level splt) Wiring : (DATA_WIDTH_B > DATA_WIDTH_A) ------
                                    wire [(A_DWID_IMPL - 1):0] in_b_ebr_seg_w [((PORT_B_DATA_USE / A_DWID_IMPL) - 1):0] ; 
                                    wire [(A_DWID_IMPL - 1):0] out_b_ebr_seg_w [((PORT_B_DATA_USE / A_DWID_IMPL) - 1):0] ; 
                                    for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                    begin : genblk4
                                        for (i_1 = 0;(i_1 < (PORT_B_DATA_USE / (A_DWID_IMPL * EBR_DATA)));i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign in_b_ebr_seg_w[(((PORT_B_DATA_USE / (A_DWID_IMPL * EBR_DATA)) * i_0) + i_1)] = in_b_top_w[((((i_0 * A_DWID_IMPL) + ((i_1 * EBR_DATA) * A_DWID_IMPL)) + A_DWID_IMPL) - 1):((i_0 * A_DWID_IMPL) + ((i_1 * EBR_DATA) * A_DWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_B_DATA_USE / A_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk5
                                        assign in_b_ebr_w[(((i_0 * A_DWID_IMPL) + A_DWID_IMPL) - 1):(i_0 * A_DWID_IMPL)] = in_b_ebr_seg_w[i_0] ; 
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_B_DATA_USE / PORT_A_DATA_USE));i_0 = (i_0 + 1))
                                    begin : genblk6
                                        for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign out_b_ebr_seg_w[((i_0 * EBR_DATA) + i_1)] = out_b_ebr_w[((((i_1 * B_DWID_IMPL) + (i_0 * A_DWID_IMPL)) + A_DWID_IMPL) - 1):((i_1 * B_DWID_IMPL) + (i_0 * A_DWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (PORT_B_DATA_USE / A_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk7
                                        assign out_b_top_w[(((i_0 * A_DWID_IMPL) + A_DWID_IMPL) - 1):(i_0 * A_DWID_IMPL)] = out_b_ebr_seg_w[i_0] ; 
                                    end
                                end
                            // ------ Address Loop (Mixed Width no Byte-Enable) ------
                            for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                            begin : xADDR
                                // ------ PORT A output ports ------
                                wire [(PORT_A_DATA_USE - 1):0] raw_out_a_w ; 
                                assign out_a_ebr_raw_w[i0] = raw_out_a_w ; 
                                // ------ PORT A Address Control Signal ------
                                wire chk_addr_a_w ; 
                                if ((EBR_ADDR > 1)) 
                                    begin : genblk1
                                        assign chk_addr_a_w = ((addr_a_i[(ADDR_WIDTH_A - 1):A_AWID_IMPL] == i0) ? 1'b1 : 1'b0) ; 
                                    end
                                else
                                    begin : genblk1
                                        assign chk_addr_a_w = 1'b1 ; 
                                    end
                                // ------ PORT B output ports ------
                                wire [(PORT_B_DATA_USE - 1):0] raw_out_b_w ; 
                                assign out_b_ebr_raw_w[i0] = raw_out_b_w ; 
                                // ------ PORT B Address Control Signal ------
                                wire chk_addr_b_w ; 
                                if ((EBR_ADDR > 1)) 
                                    begin : genblk2
                                        assign chk_addr_b_w = ((addr_b_i[(ADDR_WIDTH_B - 1):B_AWID_IMPL] == i0) ? 1'b1 : 1'b0) ; 
                                    end
                                else
                                    begin : genblk2
                                        assign chk_addr_b_w = 1'b1 ; 
                                    end
                                // ------ Data Loop (Mixed Width no Byte-Enable) ------                
                                for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                                begin : xDATA
                                    localparam ECO_POSX = (i1 * A_DWID_IMPL) ; 
                                    localparam ECO_POSY = (i0 * A_DEPTH_IMPL) ; 
                                    // ------ PORT A Data Wiring ------
                                    wire [(A_DWID_IMPL - 1):0] in_a_w ; 
                                    wire [(A_DWID_IMPL - 1):0] out_a_w ; 
                                    if ((PORT_A_DATA_USE > (A_DWID_IMPL * (i1 + 1)))) 
                                        begin : genblk1
                                            assign in_a_w = in_a_ebr_w[((A_DWID_IMPL * (i1 + 1)) - 1):(A_DWID_IMPL * i1)] ; 
                                            assign raw_out_a_w[((A_DWID_IMPL * (i1 + 1)) - 1):(A_DWID_IMPL * i1)] = out_a_w ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign in_a_w[(PORT_A_DATA_USE - (1 + (A_DWID_IMPL * i1))):0] = in_a_ebr_w[(PORT_A_DATA_USE - 1):(A_DWID_IMPL * i1)] ; 
                                            if ((A_DWID_IMPL > (PORT_A_DATA_USE - (A_DWID_IMPL * i1)))) 
                                                begin : genblk1
                                                    assign in_a_w[(A_DWID_IMPL - 1):(PORT_A_DATA_USE - (A_DWID_IMPL * i1))] = {(A_DWID_IMPL - (PORT_A_DATA_USE - (A_DWID_IMPL * i1))){1'b0}} ; 
                                                end
                                            assign raw_out_a_w[(PORT_A_DATA_USE - 1):(A_DWID_IMPL * i1)] = out_a_w[(PORT_A_DATA_USE - (1 + (A_DWID_IMPL * i1))):0] ; 
                                        end
                                    // ------ PORT B Data Wiring ------
                                    wire [(B_DWID_IMPL - 1):0] in_b_w ; 
                                    wire [(B_DWID_IMPL - 1):0] out_b_w ; 
                                    if ((PORT_B_DATA_USE > (B_DWID_IMPL * (i1 + 1)))) 
                                        begin : genblk2
                                            assign in_b_w = in_b_ebr_w[((B_DWID_IMPL * (i1 + 1)) - 1):(B_DWID_IMPL * i1)] ; 
                                            assign raw_out_b_w[((B_DWID_IMPL * (i1 + 1)) - 1):(B_DWID_IMPL * i1)] = out_b_w ; 
                                        end
                                    else
                                        begin : genblk2
                                            assign in_b_w[(PORT_B_DATA_USE - (1 + (B_DWID_IMPL * i1))):0] = in_b_ebr_w[(PORT_B_DATA_USE - 1):(B_DWID_IMPL * i1)] ; 
                                            if ((B_DWID_IMPL > (PORT_B_DATA_USE - (B_DWID_IMPL * i1)))) 
                                                begin : genblk1
                                                    assign in_b_w[(B_DWID_IMPL - 1):(PORT_B_DATA_USE - (B_DWID_IMPL * i1))] = {(B_DWID_IMPL - (PORT_B_DATA_USE - (B_DWID_IMPL * i1))){1'b0}} ; 
                                                end
                                            assign raw_out_b_w[(PORT_B_DATA_USE - 1):(B_DWID_IMPL * i1)] = out_b_w[(PORT_B_DATA_USE - (1 + (B_DWID_IMPL * i1))):0] ; 
                                        end
                                    // ------------------------------------
                                    // ------ SINGLE MEMORY INSTANCE ------
                                    // ------------------------------------
                                    if ((INIT_MODE == "mem_file")) 
                                        begin : mem_file
                                            new_lpddr4_ipgen_lscc_ram_dp_true_core #(.FAMILY(FAMILY),
                                                    .INIT_MODE(INIT_MODE),
                                                    .MEM_SIZE(MEM_SIZE),
                                                    .MEM_ID(MEM_ID),
                                                    .POSx(ECO_POSX),
                                                    .POSy(ECO_POSY),
                                                    .DATA_WIDTH_A(A_DWID_IMPL),
                                                    .REGMODE_A(REGMODE_A),
                                                    .RESETMODE_A(RESETMODE_A),
                                                    .RESET_RELEASE_A(RESET_RELEASE_A),
                                                    .BYTE_ENABLE_A(0),
                                                    .DATA_WIDTH_B(B_DWID_IMPL),
                                                    .REGMODE_B(REGMODE_B),
                                                    .RESETMODE_B(RESETMODE_B),
                                                    .RESET_RELEASE_B(RESET_RELEASE_B),
                                                    .BYTE_ENABLE_B(0),
                                                    .INITVAL_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_10(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_11(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_12(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_13(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_14(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_15(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_16(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_17(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_18(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_19(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_20(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_21(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_22(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_23(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_24(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_25(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_26(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_27(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_28(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_29(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_30(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_31(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_32(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_33(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_34(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_35(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_36(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_37(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_38(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_39(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_dp16k (// ------ COMMON PARAMETERS ------
                                                    // ------ PORT A PARAMETERS ------
                                                    // ------ PORT B PARAMETERS ------                        
                                                    // ------ INIT PARAMETERS ------
                                                    // ------ PORT A signals ------
                                                    .clk_a_i(clk_a_i), 
                                                        .clk_en_a_i(clk_en_a_i), 
                                                        .rst_a_i(rst_a_i), 
                                                        .wr_en_a_i((wr_en_a_i & chk_addr_a_w)), 
                                                        .ben_a_i(1'b1), 
                                                        .addr_a_i(addr_a_w), 
                                                        .wr_data_a_i(in_a_w), 
                                                        .rd_data_a_o(out_a_w), 
                                                        // ------ PORT B signals ------
                                                    .clk_b_i(clk_b_i), 
                                                        .clk_en_b_i(clk_en_b_i), 
                                                        .rst_b_i(rst_b_i), 
                                                        .wr_en_b_i((wr_en_b_i & chk_addr_b_w)), 
                                                        .ben_b_i(1'b1), 
                                                        .addr_b_i(addr_b_w), 
                                                        .wr_data_b_i(in_b_w), 
                                                        .rd_data_b_o(out_b_w)) ; 
                                        end
                                    else
                                        begin : no_mem_file
                                            new_lpddr4_ipgen_lscc_ram_dp_true_core #(.FAMILY(FAMILY),
                                                    .INIT_MODE(INIT_MODE),
                                                    .MEM_SIZE(MEM_SIZE),
                                                    .MEM_ID(MEM_ID),
                                                    .POSx(ECO_POSX),
                                                    .POSy(ECO_POSY),
                                                    .DATA_WIDTH_A(A_DWID_IMPL),
                                                    .REGMODE_A(REGMODE_A),
                                                    .RESETMODE_A(RESETMODE_A),
                                                    .RESET_RELEASE_A(RESET_RELEASE_A),
                                                    .BYTE_ENABLE_A(0),
                                                    .DATA_WIDTH_B(B_DWID_IMPL),
                                                    .REGMODE_B(REGMODE_B),
                                                    .RESETMODE_B(RESETMODE_B),
                                                    .RESET_RELEASE_B(RESET_RELEASE_B),
                                                    .BYTE_ENABLE_B(0)) u_dp16k (// ------ COMMON PARAMETERS ------
                                                    // ------ PORT A PARAMETERS ------
                                                    // ------ PORT B PARAMETERS ------                        
                                                    // ------ PORT A signals ------
                                                    .clk_a_i(clk_a_i), 
                                                        .clk_en_a_i(clk_en_a_i), 
                                                        .rst_a_i(rst_a_i), 
                                                        .wr_en_a_i((wr_en_a_i & chk_addr_a_w)), 
                                                        .ben_a_i(1'b1), 
                                                        .addr_a_i(addr_a_w), 
                                                        .wr_data_a_i(in_a_w), 
                                                        .rd_data_a_o(out_a_w), 
                                                        // ------ PORT B signals ------
                                                    .clk_b_i(clk_b_i), 
                                                        .clk_en_b_i(clk_en_b_i), 
                                                        .rst_b_i(rst_b_i), 
                                                        .wr_en_b_i((wr_en_b_i & chk_addr_b_w)), 
                                                        .ben_b_i(1'b1), 
                                                        .addr_b_i(addr_b_w), 
                                                        .wr_data_b_i(in_b_w), 
                                                        .rd_data_b_o(out_b_w)) ; 
                                        end
                                end
                            end
                            if ((EBR_ADDR == 1)) 
                                begin : genblk5
                                    assign out_a_ebr_w = out_a_ebr_raw_w[0] ; 
                                    assign out_b_ebr_w = out_b_ebr_raw_w[0] ; 
                                end
                            else
                                begin : genblk5
                                    // ------ PORT A output assignment ------
                                    reg [(PORT_A_DATA_USE - 1):0] a_out_buff_r ; 
                                    reg [(ADDR_WIDTH_A - 1):0] addr_a_p_r ; 
                                    assign out_a_ebr_w = a_out_buff_r ; 
                                    always
                                        @(*)
                                        begin
                                            a_out_buff_r = out_a_ebr_raw_w[addr_a_p_r[(ADDR_WIDTH_A - 1):A_AWID_IMPL]] ;
                                        end
                                    if ((REGMODE_A == "noreg")) 
                                        begin : genblk1
                                            if ((RESETMODE_A == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p_r <=  addr_a_i ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i or 
                                                            posedge rst_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p_r <=  addr_a_i ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            reg [(ADDR_WIDTH_A - 1):0] addr_a_p2_r ; 
                                            if ((RESETMODE_A == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p2_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p2_r <=  addr_a_i ;
                                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i or 
                                                            posedge rst_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p2_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p2_r <=  addr_a_i ;
                                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                                end
                                                        end
                                                end
                                        end
                                    // ------ PORT B output assignment ------
                                    reg [(PORT_B_DATA_USE - 1):0] b_out_buff_r ; 
                                    reg [(ADDR_WIDTH_B - 1):0] addr_b_p_r ; 
                                    assign out_b_ebr_w = b_out_buff_r ; 
                                    always
                                        @(*)
                                        begin
                                            b_out_buff_r = out_b_ebr_raw_w[addr_b_p_r[(ADDR_WIDTH_B - 1):B_AWID_IMPL]] ;
                                        end
                                    if ((REGMODE_B == "noreg")) 
                                        begin : genblk2
                                            if ((RESETMODE_B == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p_r <=  addr_b_i ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i or 
                                                            posedge rst_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p_r <=  addr_b_i ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk2
                                            reg [(ADDR_WIDTH_B - 1):0] addr_b_p2_r ; 
                                            if ((RESETMODE_B == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p2_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p2_r <=  addr_b_i ;
                                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i or 
                                                            posedge rst_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p2_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p2_r <=  addr_b_i ;
                                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                    else
                        begin : MIX_Y_BEN
                            // ---------------------------------------------------
                            // ------ Local Parameters for EBR Optimization ------
                            // ---------------------------------------------------
                            localparam A_DWID_IMPL = getCASE1DataImpl_wBEN(ADDR_DEPTH_A,
                                        DATA_WIDTH_A,
                                        ADDR_DEPTH_B,
                                        DATA_WIDTH_B,
                                        1'b1,
                                        0,
                                        FAMILY_CODE) ; 
                            localparam A_DEPTH_IMPL = data_to_addr(A_DWID_IMPL,
                                        FAMILY_CODE) ; 
                            localparam A_AWID_IMPL = clog2(A_DEPTH_IMPL) ; 
                            localparam A_BWID_IMPL = ((BYTE_ENABLE_A == 1) ? getImplByteWidth(A_DWID_IMPL,
                                        FAMILY_CODE) : 1) ; 
                            localparam B_DWID_IMPL = getCASE1DataImpl_wBEN(ADDR_DEPTH_A,
                                        DATA_WIDTH_A,
                                        ADDR_DEPTH_B,
                                        DATA_WIDTH_B,
                                        1'b0,
                                        0,
                                        FAMILY_CODE) ; 
                            localparam B_DEPTH_IMPL = data_to_addr(B_DWID_IMPL,
                                        FAMILY_CODE) ; 
                            localparam B_AWID_IMPL = clog2(B_DEPTH_IMPL) ; 
                            localparam B_BWID_IMPL = ((BYTE_ENABLE_B == 1) ? getImplByteWidth(B_DWID_IMPL,
                                        FAMILY_CODE) : 1) ; 
                            localparam EBR_ADDR = roundUP(ADDR_DEPTH_A,
                                        A_DEPTH_IMPL) ; 
                            localparam EBR_DATA = roundUP(DATA_WIDTH_A,
                                        A_DWID_IMPL) ; 
                            // ------ Port A address truncation ------
                            wire [(A_AWID_IMPL - 1):0] addr_a_w ; 
                            if ((A_AWID_IMPL > ADDR_WIDTH_A)) 
                                begin : genblk1
                                    assign addr_a_w[(A_AWID_IMPL - 1):ADDR_WIDTH_A] = {(A_AWID_IMPL - ADDR_WIDTH_A){1'b0}} ; 
                                    assign addr_a_w[(ADDR_WIDTH_A - 1):0] = addr_a_i ; 
                                end
                            else
                                begin : genblk1
                                    assign addr_a_w[(A_AWID_IMPL - 1):0] = addr_a_i[(A_AWID_IMPL - 1):0] ; 
                                end
                            // ------ Port B address truncation ------
                            wire [(B_AWID_IMPL - 1):0] addr_b_w ; 
                            if ((B_AWID_IMPL > ADDR_WIDTH_B)) 
                                begin : genblk2
                                    assign addr_b_w[(B_AWID_IMPL - 1):ADDR_WIDTH_B] = {(B_AWID_IMPL - ADDR_WIDTH_B){1'b0}} ; 
                                    assign addr_b_w[(ADDR_WIDTH_B - 1):0] = addr_b_i ; 
                                end
                            else
                                begin : genblk2
                                    assign addr_b_w[(B_AWID_IMPL - 1):0] = addr_b_i[(B_AWID_IMPL - 1):0] ; 
                                end
                            // ------ EBR level wiring ports ------
                            wire [(DATA_WIDTH_A - 1):0] in_a_ebr_w ; 
                            wire [(DATA_WIDTH_B - 1):0] in_b_ebr_w ; 
                            wire [(DATA_WIDTH_A - 1):0] out_a_ebr_w ; 
                            wire [(DATA_WIDTH_B - 1):0] out_b_ebr_w ; 
                            wire [(BYTE_WIDTH_A - 1):0] ben_a_ebr_w ; 
                            wire [(BYTE_WIDTH_B - 1):0] ben_b_ebr_w ; 
                            // ------ Output Port MUX ------
                            wire [(DATA_WIDTH_A - 1):0] out_a_ebr_raw_w [(EBR_ADDR - 1):0] ; 
                            wire [(DATA_WIDTH_B - 1):0] out_b_ebr_raw_w [(EBR_ADDR - 1):0] ; 
                            if ((DATA_WIDTH_A > DATA_WIDTH_B)) 
                                begin : A_OVR_B
                                    // ------ PORT B (TOP to EBR level split) Wiring : (DATA_WIDTH_A > DATA_WIDTH_B) ------
                                    assign in_b_ebr_w = wr_data_b_i ; 
                                    assign rd_data_b_o = out_b_ebr_w ; 
                                    assign ben_b_ebr_w = ben_b_i ; 
                                    // ------ PORT A (TOP to EBR level split) Wiring : (DATA_WIDTH_A > DATA_WIDTH_B) ------
                                    wire [(B_DWID_IMPL - 1):0] in_a_ebr_seg_w [((DATA_WIDTH_A / B_DWID_IMPL) - 1):0] ; 
                                    wire [(B_BWID_IMPL - 1):0] ben_a_ebr_seg_w [((DATA_WIDTH_A / B_DWID_IMPL) - 1):0] ; 
                                    wire [(B_DWID_IMPL - 1):0] out_a_ebr_seg_w [((DATA_WIDTH_A / B_DWID_IMPL) - 1):0] ; 
                                    for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                    begin : genblk1
                                        for (i_1 = 0;(i_1 < (DATA_WIDTH_A / (B_DWID_IMPL * EBR_DATA)));i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign in_a_ebr_seg_w[(((DATA_WIDTH_A / (B_DWID_IMPL * EBR_DATA)) * i_0) + i_1)] = wr_data_a_i[((((i_0 * B_DWID_IMPL) + ((i_1 * EBR_DATA) * B_DWID_IMPL)) + B_DWID_IMPL) - 1):((i_0 * B_DWID_IMPL) + ((i_1 * EBR_DATA) * B_DWID_IMPL))] ; 
                                            assign ben_a_ebr_seg_w[(((DATA_WIDTH_A / (B_DWID_IMPL * EBR_DATA)) * i_0) + i_1)] = ben_a_i[((((i_0 * B_BWID_IMPL) + ((i_1 * EBR_DATA) * B_BWID_IMPL)) + B_BWID_IMPL) - 1):((i_0 * B_BWID_IMPL) + ((i_1 * EBR_DATA) * B_BWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (DATA_WIDTH_A / B_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk2
                                        assign in_a_ebr_w[(((i_0 * B_DWID_IMPL) + B_DWID_IMPL) - 1):(i_0 * B_DWID_IMPL)] = in_a_ebr_seg_w[i_0] ; 
                                        assign ben_a_ebr_w[(((i_0 * B_BWID_IMPL) + B_BWID_IMPL) - 1):(i_0 * B_BWID_IMPL)] = ben_a_ebr_seg_w[i_0] ; 
                                    end
                                    for (i_0 = 0;(i_0 < (DATA_WIDTH_A / DATA_WIDTH_B));i_0 = (i_0 + 1))
                                    begin : genblk3
                                        for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign out_a_ebr_seg_w[((i_0 * EBR_DATA) + i_1)] = out_a_ebr_w[((((i_1 * A_DWID_IMPL) + (i_0 * B_DWID_IMPL)) + B_DWID_IMPL) - 1):((i_1 * A_DWID_IMPL) + (i_0 * B_DWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (DATA_WIDTH_A / B_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk4
                                        assign rd_data_a_o[(((i_0 * B_DWID_IMPL) + B_DWID_IMPL) - 1):(i_0 * B_DWID_IMPL)] = out_a_ebr_seg_w[i_0] ; 
                                    end
                                end
                            else
                                begin : B_OVR_A
                                    // ------ PORT A (TOP to EBR level split) Wiring : (DATA_WIDTH_B > DATA_WIDTH_A) ------
                                    assign in_a_ebr_w = wr_data_a_i ; 
                                    assign rd_data_a_o = out_a_ebr_w ; 
                                    assign ben_a_ebr_w = ben_a_i ; 
                                    // ------ PORT B (TOP to EBR level split) Wiring : (DATA_WIDTH_B > DATA_WIDTH_A) ------
                                    wire [(A_DWID_IMPL - 1):0] in_b_ebr_seg_w [((DATA_WIDTH_B / A_DWID_IMPL) - 1):0] ; 
                                    wire [(A_BWID_IMPL - 1):0] ben_b_ebr_seg_w [((DATA_WIDTH_B / A_DWID_IMPL) - 1):0] ; 
                                    wire [(A_DWID_IMPL - 1):0] out_b_ebr_seg_w [((DATA_WIDTH_B / A_DWID_IMPL) - 1):0] ; 
                                    for (i_0 = 0;(i_0 < EBR_DATA);i_0 = (i_0 + 1))
                                    begin : genblk1
                                        for (i_1 = 0;(i_1 < (DATA_WIDTH_B / (A_DWID_IMPL * EBR_DATA)));i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign in_b_ebr_seg_w[(((DATA_WIDTH_B / (A_DWID_IMPL * EBR_DATA)) * i_0) + i_1)] = wr_data_b_i[((((i_0 * A_DWID_IMPL) + ((i_1 * EBR_DATA) * A_DWID_IMPL)) + A_DWID_IMPL) - 1):((i_0 * A_DWID_IMPL) + ((i_1 * EBR_DATA) * A_DWID_IMPL))] ; 
                                            assign ben_b_ebr_seg_w[(((DATA_WIDTH_B / (A_DWID_IMPL * EBR_DATA)) * i_0) + i_1)] = ben_b_i[((((i_0 * A_BWID_IMPL) + ((i_1 * EBR_DATA) * A_BWID_IMPL)) + A_BWID_IMPL) - 1):((i_0 * A_BWID_IMPL) + ((i_1 * EBR_DATA) * A_BWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (DATA_WIDTH_B / A_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk2
                                        assign in_b_ebr_w[(((i_0 * A_DWID_IMPL) + A_DWID_IMPL) - 1):(i_0 * A_DWID_IMPL)] = in_b_ebr_seg_w[i_0] ; 
                                        assign ben_b_ebr_w[(((i_0 * A_BWID_IMPL) + A_BWID_IMPL) - 1):(i_0 * A_BWID_IMPL)] = ben_b_ebr_seg_w[i_0] ; 
                                    end
                                    for (i_0 = 0;(i_0 < (DATA_WIDTH_B / DATA_WIDTH_A));i_0 = (i_0 + 1))
                                    begin : genblk3
                                        for (i_1 = 0;(i_1 < EBR_DATA);i_1 = (i_1 + 1))
                                        begin : genblk1
                                            assign out_b_ebr_seg_w[((i_0 * EBR_DATA) + i_1)] = out_b_ebr_w[((((i_1 * B_DWID_IMPL) + (i_0 * A_DWID_IMPL)) + A_DWID_IMPL) - 1):((i_1 * B_DWID_IMPL) + (i_0 * A_DWID_IMPL))] ; 
                                        end
                                    end
                                    for (i_0 = 0;(i_0 < (DATA_WIDTH_B / A_DWID_IMPL));i_0 = (i_0 + 1))
                                    begin : genblk4
                                        assign rd_data_b_o[(((i_0 * A_DWID_IMPL) + A_DWID_IMPL) - 1):(i_0 * A_DWID_IMPL)] = out_b_ebr_seg_w[i_0] ; 
                                    end
                                end
                            // ------ Address Loop (Mixed Width w/ Byte-Enable) ------
                            for (i0 = 0;(i0 < EBR_ADDR);i0 = (i0 + 1))
                            begin : xADDR
                                // ------ PORT A output ports ------
                                wire [(DATA_WIDTH_A - 1):0] raw_out_a_w ; 
                                assign out_a_ebr_raw_w[i0] = raw_out_a_w ; 
                                // ------ PORT A Address Control Signal ------
                                wire chk_addr_a_w ; 
                                if ((EBR_ADDR > 1)) 
                                    begin : genblk1
                                        assign chk_addr_a_w = ((addr_a_i[(ADDR_WIDTH_A - 1):A_AWID_IMPL] == i0) ? 1'b1 : 1'b0) ; 
                                    end
                                else
                                    begin : genblk1
                                        assign chk_addr_a_w = 1'b1 ; 
                                    end
                                // ------ PORT B output ports ------
                                wire [(DATA_WIDTH_B - 1):0] raw_out_b_w ; 
                                assign out_b_ebr_raw_w[i0] = raw_out_b_w ; 
                                // ------ PORT B Address Control Signal ------
                                wire chk_addr_b_w ; 
                                if ((EBR_ADDR > 1)) 
                                    begin : genblk2
                                        assign chk_addr_b_w = ((addr_b_i[(ADDR_WIDTH_B - 1):B_AWID_IMPL] == i0) ? 1'b1 : 1'b0) ; 
                                    end
                                else
                                    begin : genblk2
                                        assign chk_addr_b_w = 1'b1 ; 
                                    end
                                // ------ Data Loop (Mixed Width w/ Byte-Enable) ------     
                                for (i1 = 0;(i1 < EBR_DATA);i1 = (i1 + 1))
                                begin : xDATA
                                    localparam ECO_POSX = (i1 * A_DWID_IMPL) ; 
                                    localparam ECO_POSY = (i0 * A_DEPTH_IMPL) ; 
                                    // ------ PORT A Data Wiring ------
                                    wire [(A_DWID_IMPL - 1):0] in_a_w ; 
                                    wire [(A_BWID_IMPL - 1):0] ben_a_w ; 
                                    wire [(A_DWID_IMPL - 1):0] out_a_w ; 
                                    if (((A_DWID_IMPL * (i1 + 1)) < DATA_WIDTH_A)) 
                                        begin : genblk1
                                            assign in_a_w = in_a_ebr_w[((A_DWID_IMPL * (i1 + 1)) - 1):(A_DWID_IMPL * i1)] ; 
                                            assign raw_out_a_w[((A_DWID_IMPL * (i1 + 1)) - 1):(A_DWID_IMPL * i1)] = out_a_w ; 
                                            assign ben_a_w = ((BYTE_ENABLE_A == 1) ? ben_a_ebr_w[((A_BWID_IMPL * (i1 + 1)) - 1):(A_BWID_IMPL * i1)] : {A_BWID_IMPL{1'b1}}) ; 
                                        end
                                    else
                                        begin : genblk1
                                            assign in_a_w[(DATA_WIDTH_A - (1 + (A_DWID_IMPL * i1))):0] = in_a_ebr_w[(DATA_WIDTH_A - 1):(A_DWID_IMPL * i1)] ; 
                                            if ((A_DWID_IMPL > (DATA_WIDTH_A - (A_DWID_IMPL * i1)))) 
                                                begin : genblk1
                                                    assign in_a_w[(A_DWID_IMPL - 1):(DATA_WIDTH_A - (A_DWID_IMPL * i1))] = {(A_DWID_IMPL - (DATA_WIDTH_A - (A_DWID_IMPL * i1))){1'b0}} ; 
                                                end
                                            if ((BYTE_ENABLE_A == 1)) 
                                                begin : genblk2
                                                    assign ben_a_w[(BYTE_WIDTH_A - (1 + (A_BWID_IMPL * i1))):0] = ben_a_ebr_w[(BYTE_WIDTH_A - 1):(A_BWID_IMPL * i1)] ; 
                                                    if ((A_BWID_IMPL > (BYTE_WIDTH_A - (A_BWID_IMPL * i1)))) 
                                                        begin : genblk1
                                                            assign ben_a_w[(A_BWID_IMPL - 1):(BYTE_WIDTH_A - (A_BWID_IMPL * i1))] = {(A_BWID_IMPL - (BYTE_WIDTH_A - (A_BWID_IMPL * i1))){1'b1}} ; 
                                                        end
                                                end
                                            else
                                                begin : genblk2
                                                    assign ben_a_w = {A_BWID_IMPL{1'b1}} ; 
                                                end
                                            assign raw_out_a_w[(DATA_WIDTH_A - 1):(A_DWID_IMPL * i1)] = out_a_w[(DATA_WIDTH_A - (1 + (A_DWID_IMPL * i1))):0] ; 
                                        end
                                    // ------ PORT B Data Wiring ------
                                    wire [(B_DWID_IMPL - 1):0] in_b_w ; 
                                    wire [(B_BWID_IMPL - 1):0] ben_b_w ; 
                                    wire [(B_DWID_IMPL - 1):0] out_b_w ; 
                                    if (((B_DWID_IMPL * (i1 + 1)) < DATA_WIDTH_B)) 
                                        begin : genblk2
                                            assign in_b_w = in_b_ebr_w[((B_DWID_IMPL * (i1 + 1)) - 1):(B_DWID_IMPL * i1)] ; 
                                            assign raw_out_b_w[((B_DWID_IMPL * (i1 + 1)) - 1):(B_DWID_IMPL * i1)] = out_b_w ; 
                                            assign ben_b_w = ((BYTE_ENABLE_B == 1) ? ben_b_ebr_w[((B_BWID_IMPL * (i1 + 1)) - 1):(B_BWID_IMPL * i1)] : {B_BWID_IMPL{1'b1}}) ; 
                                        end
                                    else
                                        begin : genblk2
                                            assign in_b_w[(DATA_WIDTH_B - (1 + (B_DWID_IMPL * i1))):0] = in_b_ebr_w[(DATA_WIDTH_B - 1):(B_DWID_IMPL * i1)] ; 
                                            if ((B_DWID_IMPL > (DATA_WIDTH_B - (B_DWID_IMPL * i1)))) 
                                                begin : genblk1
                                                    assign in_b_w[(B_DWID_IMPL - 1):(DATA_WIDTH_B - (B_DWID_IMPL * i1))] = {(B_DWID_IMPL - (DATA_WIDTH_B - (B_DWID_IMPL * i1))){1'b0}} ; 
                                                end
                                            if ((BYTE_ENABLE_B == 1)) 
                                                begin : genblk2
                                                    assign ben_b_w[(BYTE_WIDTH_B - (1 + (B_BWID_IMPL * i1))):0] = ben_b_ebr_w[(BYTE_WIDTH_B - 1):(B_BWID_IMPL * i1)] ; 
                                                    if ((B_BWID_IMPL > (DATA_WIDTH_B - (B_BWID_IMPL * i1)))) 
                                                        begin : genblk1
                                                            assign ben_b_w[(B_BWID_IMPL - 1):(BYTE_WIDTH_B - (B_BWID_IMPL * i1))] = {(B_BWID_IMPL - (BYTE_WIDTH_B - (B_BWID_IMPL * i1))){1'b1}} ; 
                                                        end
                                                end
                                            else
                                                begin : genblk2
                                                    assign ben_b_w = {B_BWID_IMPL{1'b1}} ; 
                                                end
                                            assign raw_out_b_w[(DATA_WIDTH_B - 1):(B_DWID_IMPL * i1)] = out_b_w[(DATA_WIDTH_B - (1 + (B_DWID_IMPL * i1))):0] ; 
                                        end
                                    // ------------------------------------
                                    // ------ SINGLE MEMORY INSTANCE ------
                                    // ------------------------------------
                                    if ((INIT_MODE == "mem_file")) 
                                        begin : mem_file
                                            new_lpddr4_ipgen_lscc_ram_dp_true_core #(.FAMILY(FAMILY),
                                                    .INIT_MODE(INIT_MODE),
                                                    .MEM_SIZE(MEM_SIZE),
                                                    .MEM_ID(MEM_ID),
                                                    .POSx(ECO_POSX),
                                                    .POSy(ECO_POSY),
                                                    .DATA_WIDTH_A(A_DWID_IMPL),
                                                    .REGMODE_A(REGMODE_A),
                                                    .RESETMODE_A(RESETMODE_A),
                                                    .RESET_RELEASE_A(RESET_RELEASE_A),
                                                    .BYTE_ENABLE_A(BYTE_ENABLE_A),
                                                    .BYTE_EN_POL_A(BYTE_EN_POL_A),
                                                    .DATA_WIDTH_B(B_DWID_IMPL),
                                                    .REGMODE_B(REGMODE_B),
                                                    .RESETMODE_B(RESETMODE_B),
                                                    .RESET_RELEASE_B(RESET_RELEASE_B),
                                                    .BYTE_ENABLE_B(BYTE_ENABLE_B),
                                                    .BYTE_EN_POL_B(BYTE_EN_POL_B),
                                                    .INITVAL_00(INIT_VALUE_00[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_01(INIT_VALUE_01[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_02(INIT_VALUE_02[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_03(INIT_VALUE_03[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_04(INIT_VALUE_04[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_05(INIT_VALUE_05[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_06(INIT_VALUE_06[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_07(INIT_VALUE_07[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_08(INIT_VALUE_08[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_09(INIT_VALUE_09[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0A(INIT_VALUE_0A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0B(INIT_VALUE_0B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0C(INIT_VALUE_0C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0D(INIT_VALUE_0D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0E(INIT_VALUE_0E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_0F(INIT_VALUE_0F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)]),
                                                    .INITVAL_10(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_10[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_11(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_11[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_12(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_12[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_13(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_13[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_14(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_14[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_15(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_15[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_16(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_16[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_17(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_17[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_18(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_18[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_19(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_19[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_1F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_1F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_20(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_20[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_21(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_21[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_22(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_22[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_23(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_23[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_24(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_24[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_25(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_25[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_26(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_26[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_27(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_27[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_28(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_28[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_29(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_29[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_2F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_2F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_30(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_30[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_31(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_31[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_32(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_32[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_33(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_33[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_34(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_34[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_35(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_35[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_36(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_36[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_37(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_37[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_38(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_38[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_39(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_39[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3A(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3A[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3B(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3B[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3C(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3C[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3D(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3D[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3E(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3E[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00")),
                                                    .INITVAL_3F(((checkINIT(FAMILY_CODE) == 1) ? INIT_VALUE_3F[((((((i0 * EBR_DATA) + i1) + 1) * STRING_LENGTH) * 8) - 1):((((i0 * EBR_DATA) + i1) * STRING_LENGTH) * 8)] : "0x00"))) u_dp16k (// ------ COMMON PARAMETERS ------
                                                    // ------ PORT A PARAMETERS ------
                                                    // ------ PORT B PARAMETERS ------                        
                                                    // ------ INIT PARAMETERS ------
                                                    // ------ PORT A signals ------
                                                    .clk_a_i(clk_a_i), 
                                                        .clk_en_a_i(clk_en_a_i), 
                                                        .rst_a_i(rst_a_i), 
                                                        .wr_en_a_i((wr_en_a_i & chk_addr_a_w)), 
                                                        .ben_a_i(ben_a_w), 
                                                        .addr_a_i(addr_a_w), 
                                                        .wr_data_a_i(in_a_w), 
                                                        .rd_data_a_o(out_a_w), 
                                                        // ------ PORT B signals ------
                                                    .clk_b_i(clk_b_i), 
                                                        .clk_en_b_i(clk_en_b_i), 
                                                        .rst_b_i(rst_b_i), 
                                                        .wr_en_b_i((wr_en_b_i & chk_addr_b_w)), 
                                                        .ben_b_i(ben_b_w), 
                                                        .addr_b_i(addr_b_w), 
                                                        .wr_data_b_i(in_b_w), 
                                                        .rd_data_b_o(out_b_w)) ; 
                                        end
                                    else
                                        begin : no_mem_file
                                            new_lpddr4_ipgen_lscc_ram_dp_true_core #(.FAMILY(FAMILY),
                                                    .INIT_MODE(INIT_MODE),
                                                    .MEM_SIZE(MEM_SIZE),
                                                    .MEM_ID(MEM_ID),
                                                    .POSx(ECO_POSX),
                                                    .POSy(ECO_POSY),
                                                    .DATA_WIDTH_A(A_DWID_IMPL),
                                                    .REGMODE_A(REGMODE_A),
                                                    .RESETMODE_A(RESETMODE_A),
                                                    .RESET_RELEASE_A(RESET_RELEASE_A),
                                                    .BYTE_ENABLE_A(BYTE_ENABLE_A),
                                                    .BYTE_EN_POL_A(BYTE_EN_POL_A),
                                                    .DATA_WIDTH_B(B_DWID_IMPL),
                                                    .REGMODE_B(REGMODE_B),
                                                    .RESETMODE_B(RESETMODE_B),
                                                    .RESET_RELEASE_B(RESET_RELEASE_B),
                                                    .BYTE_ENABLE_B(BYTE_ENABLE_B),
                                                    .BYTE_EN_POL_B(BYTE_EN_POL_B)) u_dp16k (// ------ COMMON PARAMETERS ------
                                                    // ------ PORT A PARAMETERS ------
                                                    // ------ PORT B PARAMETERS ------                        
                                                    // ------ PORT A signals ------
                                                    .clk_a_i(clk_a_i), 
                                                        .clk_en_a_i(clk_en_a_i), 
                                                        .rst_a_i(rst_a_i), 
                                                        .wr_en_a_i((wr_en_a_i & chk_addr_a_w)), 
                                                        .ben_a_i(ben_a_w), 
                                                        .addr_a_i(addr_a_w), 
                                                        .wr_data_a_i(in_a_w), 
                                                        .rd_data_a_o(out_a_w), 
                                                        // ------ PORT B signals ------
                                                    .clk_b_i(clk_b_i), 
                                                        .clk_en_b_i(clk_en_b_i), 
                                                        .rst_b_i(rst_b_i), 
                                                        .wr_en_b_i((wr_en_b_i & chk_addr_b_w)), 
                                                        .ben_b_i(ben_b_w), 
                                                        .addr_b_i(addr_b_w), 
                                                        .wr_data_b_i(in_b_w), 
                                                        .rd_data_b_o(out_b_w)) ; 
                                        end
                                end
                            end
                            if ((EBR_ADDR == 1)) 
                                begin : genblk5
                                    assign out_a_ebr_w = out_a_ebr_raw_w[0] ; 
                                    assign out_b_ebr_w = out_b_ebr_raw_w[0] ; 
                                end
                            else
                                begin : genblk5
                                    // ------ PORT A output assignment ------
                                    reg [(DATA_WIDTH_A - 1):0] a_out_buff_r ; 
                                    reg [(ADDR_WIDTH_A - 1):0] addr_a_p_r ; 
                                    assign out_a_ebr_w = a_out_buff_r ; 
                                    always
                                        @(*)
                                        begin
                                            a_out_buff_r = out_a_ebr_raw_w[addr_a_p_r[(ADDR_WIDTH_A - 1):A_AWID_IMPL]] ;
                                        end
                                    if ((REGMODE_A == "noreg")) 
                                        begin : genblk1
                                            if ((RESETMODE_A == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p_r <=  addr_a_i ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i or 
                                                            posedge rst_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p_r <=  addr_a_i ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk1
                                            reg [(ADDR_WIDTH_A - 1):0] addr_a_p2_r = {ADDR_WIDTH_A{1'b0}} ; 
                                            if ((RESETMODE_A == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p2_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p2_r <=  addr_a_i ;
                                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_a_i or 
                                                            posedge rst_a_i)
                                                        begin
                                                            if (rst_a_i) 
                                                                begin
                                                                    addr_a_p2_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                    addr_a_p_r <=  {ADDR_WIDTH_A{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_a_p2_r <=  addr_a_i ;
                                                                    addr_a_p_r <=  addr_a_p2_r ;
                                                                end
                                                        end
                                                end
                                        end
                                    // ------ PORT B output assignment ------
                                    reg [(DATA_WIDTH_B - 1):0] b_out_buff_r = {DATA_WIDTH_B{1'b0}} ; 
                                    reg [(ADDR_WIDTH_B - 1):0] addr_b_p_r = {ADDR_WIDTH_B{1'b0}} ; 
                                    assign out_b_ebr_w = b_out_buff_r ; 
                                    always
                                        @(*)
                                        begin
                                            b_out_buff_r = out_b_ebr_raw_w[addr_b_p_r[(ADDR_WIDTH_B - 1):B_AWID_IMPL]] ;
                                        end
                                    if ((REGMODE_B == "noreg")) 
                                        begin : genblk2
                                            if ((RESETMODE_B == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p_r <=  addr_b_i ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i or 
                                                            posedge rst_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p_r <=  addr_b_i ;
                                                                end
                                                        end
                                                end
                                        end
                                    else
                                        begin : genblk2
                                            reg [(ADDR_WIDTH_B - 1):0] addr_b_p2_r = {ADDR_WIDTH_B{1'b0}} ; 
                                            if ((RESETMODE_B == "sync")) 
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p2_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p2_r <=  addr_b_i ;
                                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                                end
                                                        end
                                                end
                                            else
                                                begin : genblk1
                                                    always
                                                        @(posedge clk_b_i or 
                                                            posedge rst_b_i)
                                                        begin
                                                            if (rst_b_i) 
                                                                begin
                                                                    addr_b_p2_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                    addr_b_p_r <=  {ADDR_WIDTH_B{1'b0}} ;
                                                                end
                                                            else
                                                                begin
                                                                    addr_b_p2_r <=  addr_b_i ;
                                                                    addr_b_p_r <=  addr_b_p2_r ;
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
            end
    endgenerate
    function checkINIT ; 
        input [31:0] val ; 
        begin
            checkINIT = 1 ;
        end
    endfunction
    function [31:0] getImplByteWidth ; 
        input [31:0] dwid ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (dwid)
                    18 : 
                        getImplByteWidth = 2 ;
                    16 : 
                        getImplByteWidth = 2 ;
                    9 : 
                        getImplByteWidth = 1 ;
                    default : 
                        getImplByteWidth = 1 ;
                    endcase 
                end
            default : 
                getImplByteWidth = 1 ;
            endcase 
        end
    endfunction
    function [31:0] getDatabase ; 
        input [31:0] base_count ; 
        input [31:0] index ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (base_count)
                    9 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 9 ;
                            default : 
                                getDatabase = 18 ;
                            endcase 
                        end
                    8 : 
                        begin
                            case (index)
                            0 : 
                                getDatabase = 1 ;
                            1 : 
                                getDatabase = 2 ;
                            2 : 
                                getDatabase = 4 ;
                            3 : 
                                getDatabase = 8 ;
                            default : 
                                getDatabase = 16 ;
                            endcase 
                        end
                    default : 
                        getDatabase = 16 ;
                    endcase 
                end
            default : 
                getDatabase = base_count ;
            endcase 
        end
    endfunction
    function [31:0] getCASE1DataImpl_wBEN ; 
        input [31:0] addr_a_depth ; 
        input [31:0] data_a_width ; 
        input [31:0] addr_b_depth ; 
        input [31:0] data_b_width ; 
        input is_taking_port_a ; 
        input is_taking_total_ebr ; 
        input [31:0] family_code ; 
        reg [5:0] num0, 
            num1 ; 
        reg [31:0] divisor, 
            addr_div_prtA, 
            data_div_prtA, 
            addr_div_prtB, 
            data_div_prtB ; 
        reg [31:0] portA_addr_chk, 
            portA_data_chk, 
            portB_addr_chk, 
            portB_data_chk ; 
        reg [31:0] EBR_usage, 
            PROD ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    if ((data_a_width > data_b_width)) 
                        begin
                            if (is_taking_port_a) 
                                begin
                                    if (((data_a_width % 9) == 0)) 
                                        getCASE1DataImpl_wBEN = 18 ;
                                    else
                                        getCASE1DataImpl_wBEN = 16 ;
                                end
                            else
                                begin
                                    if (((data_a_width % 9) == 0)) 
                                        getCASE1DataImpl_wBEN = 9 ;
                                    else
                                        getCASE1DataImpl_wBEN = 8 ;
                                end
                        end
                    else
                        begin
                            if (is_taking_port_a) 
                                begin
                                    if (((data_a_width % 9) == 0)) 
                                        getCASE1DataImpl_wBEN = 9 ;
                                    else
                                        getCASE1DataImpl_wBEN = 8 ;
                                end
                            else
                                begin
                                    if (((data_a_width % 9) == 0)) 
                                        getCASE1DataImpl_wBEN = 18 ;
                                    else
                                        getCASE1DataImpl_wBEN = 16 ;
                                end
                        end
                end
            default : 
                getCASE1DataImpl_wBEN = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getCASE1DataImpl ; 
        input [31:0] addr_a_depth ; 
        input [31:0] data_a_width ; 
        input [31:0] addr_b_depth ; 
        input [31:0] data_b_width ; 
        input is_taking_port_a ; 
        input is_taking_total_ebr ; 
        input [31:0] family_code ; 
        reg [5:0] num0, 
            num1 ; 
        reg [31:0] divisor, 
            addr_div_prtA, 
            data_div_prtA, 
            addr_div_prtB, 
            data_div_prtB ; 
        reg [31:0] portA_addr_chk, 
            portA_data_chk, 
            portB_addr_chk, 
            portB_data_chk ; 
        reg [31:0] EBR_usage, 
            PROD ; 
        begin
            divisor = ((addr_a_depth > addr_b_depth) ? (addr_a_depth / addr_b_depth) : (addr_b_depth / addr_a_depth)) ;
            EBR_usage = {32{1'b1}} ;
            getCASE1DataImpl = 0 ;
            if ((family_code == _FCODE_LIFCL_)) 
                begin
                    if ((divisor == 2)) 
                        begin
                            for (num0 = 0 ; (num0 < 2) ; num0 = (num0 + 1))
                                begin
                                    data_div_prtA = getDatabase(9,
                                            num0,
                                            family_code) ;
                                    addr_div_prtA = data_to_addr(data_div_prtA,
                                            family_code) ;
                                    portA_addr_chk = roundUP(addr_a_depth,
                                            addr_div_prtA) ;
                                    portA_data_chk = roundUP(data_a_width,
                                            data_div_prtA) ;
                                    for (num1 = 0 ; (num1 < 2) ; num1 = (num1 + 1))
                                        begin
                                            data_div_prtB = getDatabase(9,
                                                    num1,
                                                    family_code) ;
                                            addr_div_prtB = data_to_addr(data_div_prtB,
                                                    family_code) ;
                                            portB_addr_chk = roundUP(addr_b_depth,
                                                    addr_div_prtB) ;
                                            portB_data_chk = roundUP(data_b_width,
                                                    data_div_prtB) ;
                                            if (((portA_addr_chk == portB_addr_chk) && (portA_data_chk == portB_data_chk))) 
                                                begin
                                                    if ((((data_a_width % data_div_prtA) == 0) && ((data_b_width % data_div_prtB) == 0))) 
                                                        begin
                                                            PROD = (portA_addr_chk * portA_data_chk) ;
                                                            if ((PROD < EBR_usage)) 
                                                                begin
                                                                    EBR_usage = PROD ;
                                                                    if ((is_taking_total_ebr == 1'b1)) 
                                                                        begin
                                                                            getCASE1DataImpl = EBR_usage ;
                                                                        end
                                                                    else
                                                                        begin
                                                                            if ((is_taking_port_a == 1'b1)) 
                                                                                begin
                                                                                getCASE1DataImpl = data_div_prtA ;
                                                                                end
                                                                            else
                                                                                begin
                                                                                getCASE1DataImpl = data_div_prtB ;
                                                                                end
                                                                        end
                                                                end
                                                        end
                                                end
                                        end
                                end
                        end
                end
            for (num0 = 0 ; (num0 < 5) ; num0 = (num0 + 1))
                begin
                    data_div_prtA = getDatabase(8,
                            num0,
                            family_code) ;
                    addr_div_prtA = data_to_addr(data_div_prtA,
                            family_code) ;
                    portA_addr_chk = roundUP(addr_a_depth,
                            addr_div_prtA) ;
                    portA_data_chk = roundUP(data_a_width,
                            data_div_prtA) ;
                    for (num1 = 0 ; (num1 < 5) ; num1 = (num1 + 1))
                        begin
                            data_div_prtB = getDatabase(8,
                                    num1,
                                    family_code) ;
                            addr_div_prtB = data_to_addr(data_div_prtB,
                                    family_code) ;
                            portB_addr_chk = roundUP(addr_b_depth,
                                    addr_div_prtB) ;
                            portB_data_chk = roundUP(data_b_width,
                                    data_div_prtB) ;
                            if (((portA_addr_chk == portB_addr_chk) && (portA_data_chk == portB_data_chk))) 
                                begin
                                    PROD = (portA_addr_chk * portA_data_chk) ;
                                    if ((PROD < EBR_usage)) 
                                        begin
                                            EBR_usage = PROD ;
                                            if ((is_taking_total_ebr == 1'b1)) 
                                                begin
                                                    getCASE1DataImpl = EBR_usage ;
                                                end
                                            else
                                                begin
                                                    if ((is_taking_port_a == 1'b1)) 
                                                        begin
                                                            getCASE1DataImpl = data_div_prtA ;
                                                        end
                                                    else
                                                        begin
                                                            getCASE1DataImpl = data_div_prtB ;
                                                        end
                                                end
                                        end
                                end
                        end
                end
        end
    endfunction
    function [31:0] procData ; 
        input [31:0] max_data ; 
        input [31:0] family_code ; 
        begin
            procData = 1 ;
            while ((procData < max_data))
                begin
                    case (family_code)
                    _FCODE_LIFCL_ : 
                        begin
                            if ((procData < 8)) 
                                begin
                                    procData = (procData * 2) ;
                                end
                            else
                                begin
                                    if ((procData == 8)) 
                                        begin
                                            procData = 9 ;
                                        end
                                    else
                                        if (((procData % 9) == 0)) 
                                            begin
                                                procData = ((procData / 9) * 16) ;
                                            end
                                        else
                                            begin
                                                procData = ((procData / 8) * 9) ;
                                            end
                                end
                        end
                    default : 
                        procData = max_data ;
                    endcase 
                end
        end
    endfunction
    function [31:0] data_to_addr ; 
        input [31:0] data_size ; 
        input [31:0] family_code ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    case (data_size)
                    18 : 
                        data_to_addr = 1024 ;
                    16 : 
                        data_to_addr = 1024 ;
                    9 : 
                        data_to_addr = 2048 ;
                    8 : 
                        data_to_addr = 2048 ;
                    4 : 
                        data_to_addr = 4096 ;
                    2 : 
                        data_to_addr = 8192 ;
                    default : 
                        data_to_addr = 16384 ;
                    endcase 
                end
            default : 
                data_to_addr = 1024 ;
            endcase 
        end
    endfunction
    function [31:0] getMinimaData ; 
        input [31:0] depth_impl ; 
        input [31:0] width_impl ; 
        input is_byte_en ; 
        input [31:0] byte_size ; 
        input [31:0] family_code ; 
        reg [31:0] temp_00, 
            temp_01, 
            temp_02, 
            temp_03, 
            temp_04 ; 
        begin
            case (family_code)
            _FCODE_LIFCL_ : 
                begin
                    temp_00 = EBR_impl(depth_impl,
                            width_impl,
                            1024,
                            18) ;
                    temp_01 = EBR_impl(depth_impl,
                            width_impl,
                            2048,
                            9) ;
                    temp_02 = EBR_impl(depth_impl,
                            width_impl,
                            4096,
                            4) ;
                    temp_03 = EBR_impl(depth_impl,
                            width_impl,
                            8192,
                            2) ;
                    temp_04 = EBR_impl(depth_impl,
                            width_impl,
                            16384,
                            1) ;
                    if (((is_byte_en == 1) && ((width_impl % 9) != 0))) 
                        begin
                            temp_00 = EBR_impl(depth_impl,
                                    width_impl,
                                    1024,
                                    16) ;
                            temp_01 = EBR_impl(depth_impl,
                                    width_impl,
                                    2048,
                                    8) ;
                            if ((temp_00 < temp_01)) 
                                begin
                                    if ((temp_00 < temp_02)) 
                                        begin
                                            if ((temp_00 < temp_03)) 
                                                begin
                                                    if ((temp_00 < temp_04)) 
                                                        getMinimaData = 16 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                end
                            else
                                begin
                                    if ((temp_01 < temp_02)) 
                                        begin
                                            if ((temp_01 < temp_03)) 
                                                begin
                                                    if ((temp_01 < temp_04)) 
                                                        getMinimaData = 8 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                end
                        end
                    else
                        begin
                            if ((temp_00 < temp_01)) 
                                begin
                                    if ((temp_00 < temp_02)) 
                                        begin
                                            if ((temp_00 < temp_03)) 
                                                begin
                                                    if ((temp_00 < temp_04)) 
                                                        getMinimaData = 18 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                end
                            else
                                begin
                                    if ((temp_01 < temp_02)) 
                                        begin
                                            if ((temp_01 < temp_03)) 
                                                begin
                                                    if ((temp_01 < temp_04)) 
                                                        getMinimaData = 9 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                    else
                                        begin
                                            if ((temp_02 < temp_03)) 
                                                begin
                                                    if ((temp_02 < temp_04)) 
                                                        getMinimaData = 4 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                            else
                                                begin
                                                    if ((temp_03 < temp_04)) 
                                                        getMinimaData = 2 ;
                                                    else
                                                        getMinimaData = 1 ;
                                                end
                                        end
                                end
                        end
                end
            default : 
                getMinimaData = 8 ;
            endcase 
        end
    endfunction
    function [31:0] getByteSize ; 
        input [31:0] data_width ; 
        input [31:0] dev_code ; 
        begin
            case (dev_code)
            _FCODE_LIFCL_ : 
                begin
                    if (((data_width % 9) == 0)) 
                        getByteSize = 9 ;
                    else
                        getByteSize = 8 ;
                end
            default : 
                getByteSize = 8 ;
            endcase 
        end
    endfunction
    function [31:0] EBR_impl ; 
        input [31:0] DEPTH_IMPL ; 
        input [31:0] WIDTH_IMPL ; 
        input [31:0] ADDR_DEPTH_X ; 
        input [31:0] DATA_WIDTH_X ; 
        begin
            EBR_impl = (roundUP(DEPTH_IMPL,
                    ADDR_DEPTH_X) * roundUP(WIDTH_IMPL,
                    DATA_WIDTH_X)) ;
        end
    endfunction
    function [31:0] roundUP ; 
        input [31:0] dividend ; 
        input [31:0] divisor ; 
        begin
            if ((divisor == 1)) 
                begin
                    roundUP = dividend ;
                end
            else
                if ((divisor == dividend)) 
                    begin
                        roundUP = 1 ;
                    end
                else
                    begin
                        roundUP = ((dividend / divisor) + (((dividend % divisor) == 0) ? 0 : 1)) ;
                    end
        end
    endfunction
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2017 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_ram_dp_true_core.v
// Title                 :
// Dependencies          :
// Description           : Implements a single true dual port EBR primitive.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module new_lpddr4_ipgen_lscc_ram_dp_true_core #(parameter _FCODE_LIFCL_ = 1, 
        parameter _FCODE_COMMON_ = 0, 
        parameter FAMILY = "common", 
        parameter MEM_ID = "MEM0", 
        parameter MEM_SIZE = "18,1024", 
        parameter FAMILY_CODE = ((FAMILY == "LIFCL") ? _FCODE_LIFCL_ : _FCODE_COMMON_), 
        parameter DATA_WIDTH_A = 18, 
        parameter ADDR_WIDTH_A = getAddrWidth(DATA_WIDTH_A,
                FAMILY_CODE), 
        parameter REGMODE_A = "reg", 
        parameter RESETMODE_A = "sync", 
        parameter RESET_RELEASE_A = "sync", 
        parameter BYTE_ENABLE_A = 0, 
        parameter BYTE_SIZE_A = getByteSize(BYTE_ENABLE_A,
                FAMILY_CODE,
                DATA_WIDTH_A), 
        parameter BYTE_WIDTH_A = roundUP(DATA_WIDTH_A,
                BYTE_SIZE_A), 
        parameter BYTE_EN_POL_A = "active-high", 
        parameter DATA_WIDTH_B = 18, 
        parameter ADDR_WIDTH_B = getAddrWidth(DATA_WIDTH_B,
                FAMILY_CODE), 
        parameter REGMODE_B = "reg", 
        parameter RESETMODE_B = "sync", 
        parameter RESET_RELEASE_B = "sync", 
        parameter BYTE_ENABLE_B = 0, 
        parameter BYTE_SIZE_B = getByteSize(BYTE_ENABLE_B,
                FAMILY_CODE,
                DATA_WIDTH_B), 
        parameter BYTE_WIDTH_B = roundUP(DATA_WIDTH_B,
                BYTE_SIZE_B), 
        parameter BYTE_EN_POL_B = "active-high", 
        parameter POSx = 0, 
        parameter POSy = 0, 
        parameter STRING_SIZE = calculateStringSize(POSx,
                POSy), 
        parameter INIT_MODE = "none", 
        parameter INITVAL_00 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_01 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_02 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_03 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_04 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_05 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_06 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_07 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_08 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_09 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_0F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_10 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_11 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_12 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_13 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_14 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_15 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_16 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_17 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_18 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_19 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_1F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_20 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_21 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_22 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_23 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_24 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_25 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_26 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_27 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_28 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_29 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_2F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_30 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_31 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_32 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_33 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_34 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_35 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_36 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_37 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_38 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_39 = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3A = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3B = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3C = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3D = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3E = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000", 
        parameter INITVAL_3F = "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000") (
    // ---------------------------
    // --------- Family parameters
    // ---------------------------
    // ---------------------------
    // --------- PORT A parameters
    // ---------------------------
    // ---------------------------
    // --------- PORT B parameters
    // ---------------------------
    // ---------------------------
    // --------- Common parameters
    // ---------------------------
    // ---------------------------
    // - PORT A input/output ports
    // ---------------------------
    input clk_a_i, 
    input clk_en_a_i, 
    input rst_a_i, 
    input wr_en_a_i, 
    input [(BYTE_WIDTH_A - 1):0] ben_a_i, 
    input [(ADDR_WIDTH_A - 1):0] addr_a_i, 
    input [(DATA_WIDTH_A - 1):0] wr_data_a_i, 
    output [(DATA_WIDTH_A - 1):0] rd_data_a_o, 
    // ---------------------------
    // - PORT B input/output ports
    // ---------------------------
    input clk_b_i, 
    input clk_en_b_i, 
    input rst_b_i, 
    input wr_en_b_i, 
    input [(BYTE_WIDTH_B - 1):0] ben_b_i, 
    input [(ADDR_WIDTH_B - 1):0] addr_b_i, 
    input [(DATA_WIDTH_B - 1):0] wr_data_b_i, 
    output [(DATA_WIDTH_B - 1):0] rd_data_b_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    localparam POS_X0 = (POSx % 10) ; 
    localparam POS_X1 = ((POSx / 10) % 10) ; 
    localparam POS_X2 = ((POSx / 100) % 10) ; 
    localparam POS_X3 = ((POSx / 1000) % 10) ; 
    localparam POS_X4 = ((POSx / 10000) % 10) ; 
    localparam POS_X5 = ((POSx / 100000) % 10) ; 
    localparam POS_X6 = ((POSx / 1000000) % 10) ; 
    localparam POS_X7 = ((POSx / 10000000) % 10) ; 
    localparam POS_Y0 = (POSy % 10) ; 
    localparam POS_Y1 = ((POSy / 10) % 10) ; 
    localparam POS_Y2 = ((POSy / 100) % 10) ; 
    localparam POS_Y3 = ((POSy / 1000) % 10) ; 
    localparam POS_Y4 = ((POSy / 10000) % 10) ; 
    localparam POS_Y5 = ((POSy / 100000) % 10) ; 
    localparam POS_Y6 = ((POSy / 1000000) % 10) ; 
    localparam POS_Y7 = ((POSy / 10000000) % 10) ; 
    localparam [79:0] NUM_STRING = "9876543210" ; 
    localparam BLOCK_POS = getStringFromPos(POSx,
                POSy) ; 
    localparam BLOCK_SIZE = ((DATA_WIDTH_A == 18) ? "[18,1024]" : ((DATA_WIDTH_A == 16) ? "[16,1024]" : ((DATA_WIDTH_A == 9) ? "[9,2048]" : ((DATA_WIDTH_A == 8) ? "[8,2048]" : ((DATA_WIDTH_A == 4) ? "[4,4096]" : ((DATA_WIDTH_A == 2) ? "[2,8192]" : "[1,16384]")))))) ; 
    generate
        if ((FAMILY == "LIFCL")) 
            begin : LIFCL
                wire [13:0] addr_a_w ; 
                wire [17:0] in_a_w ; 
                wire [17:0] out_a_w ; 
                wire [13:0] addr_b_w ; 
                wire [17:0] in_b_w ; 
                wire [17:0] out_b_w ; 
                if (((DATA_WIDTH_A == 18) || (DATA_WIDTH_A == 16))) 
                    begin : genblk1
                        assign addr_a_w[13:4] = addr_a_i ; 
                        assign addr_a_w[3:2] = 2'b11 ; 
                        assign addr_a_w[1:0] = ((BYTE_ENABLE_A == 1) ? ben_a_i : 2'b11) ; 
                        if ((DATA_WIDTH_A == 18)) 
                            begin : genblk1
                                assign in_a_w = wr_data_a_i ; 
                                assign rd_data_a_o = out_a_w ; 
                            end
                        else
                            begin : genblk1
                                assign in_a_w[16:9] = wr_data_a_i[15:8] ; 
                                assign in_a_w[7:0] = wr_data_a_i[7:0] ; 
                                assign in_a_w[8] = 1'b0 ; 
                                assign in_a_w[17] = 1'b0 ; 
                                assign rd_data_a_o[15:8] = out_a_w[16:9] ; 
                                assign rd_data_a_o[7:0] = out_a_w[7:0] ; 
                            end
                    end
                else
                    begin : genblk1
                        assign addr_a_w[13:(14 - ADDR_WIDTH_A)] = addr_a_i ; 
                        if ((ADDR_WIDTH_A != 14)) 
                            begin : genblk1
                                assign addr_a_w[(14 - (ADDR_WIDTH_A + 1)):0] = {(14 - ADDR_WIDTH_A){1'b1}} ; 
                            end
                        assign in_a_w[17:DATA_WIDTH_A] = {(18 - DATA_WIDTH_A){1'b0}} ; 
                        assign in_a_w[(DATA_WIDTH_A - 1):0] = wr_data_a_i ; 
                        assign rd_data_a_o = out_a_w[(DATA_WIDTH_A - 1):0] ; 
                    end
                if (((DATA_WIDTH_B == 18) || (DATA_WIDTH_B == 16))) 
                    begin : genblk2
                        assign addr_b_w[13:4] = addr_b_i ; 
                        assign addr_b_w[3:2] = 2'b11 ; 
                        assign addr_b_w[1:0] = ((BYTE_ENABLE_B == 1) ? ben_b_i : 2'b11) ; 
                        if ((DATA_WIDTH_B == 18)) 
                            begin : genblk1
                                assign in_b_w = wr_data_b_i ; 
                                assign rd_data_b_o = out_b_w ; 
                            end
                        else
                            begin : genblk1
                                assign in_b_w[16:9] = wr_data_b_i[15:8] ; 
                                assign in_b_w[7:0] = wr_data_b_i[7:0] ; 
                                assign in_b_w[8] = 1'b0 ; 
                                assign in_b_w[17] = 1'b0 ; 
                                assign rd_data_b_o[15:8] = out_b_w[16:9] ; 
                                assign rd_data_b_o[7:0] = out_b_w[7:0] ; 
                            end
                    end
                else
                    begin : genblk2
                        assign addr_b_w[13:(14 - ADDR_WIDTH_B)] = addr_b_i ; 
                        if ((ADDR_WIDTH_B != 14)) 
                            begin : genblk1
                                assign addr_b_w[(14 - (ADDR_WIDTH_B + 1)):0] = {(14 - ADDR_WIDTH_B){1'b1}} ; 
                            end
                        assign in_b_w[17:DATA_WIDTH_B] = {(18 - DATA_WIDTH_B){1'b0}} ; 
                        assign in_b_w[(DATA_WIDTH_B - 1):0] = wr_data_b_i ; 
                        assign rd_data_b_o = out_b_w[(DATA_WIDTH_B - 1):0] ; 
                    end
                wire t_wr_en_a_i = (((BYTE_ENABLE_A == 0) || (BYTE_WIDTH_A > 1)) ? wr_en_a_i : (wr_en_a_i & ben_a_i)) ; 
                wire t_wr_en_b_i = (((BYTE_ENABLE_B == 0) || (BYTE_WIDTH_B > 1)) ? wr_en_b_i : (wr_en_b_i & ben_b_i)) ; 
                wire [17:0] DIA = in_a_w ; 
                wire [17:0] DIB = in_b_w ; 
                wire [13:0] ADA = addr_a_w ; 
                wire [13:0] ADB = addr_b_w ; 
                wire CLKA = clk_a_i ; 
                wire CLKB = clk_b_i ; 
                wire CEA = clk_en_a_i ; 
                wire CEB = clk_en_b_i ; 
                wire WEA = t_wr_en_a_i ; 
                wire WEB = t_wr_en_b_i ; 
                wire [2:0] CSA = {clk_en_a_i,
                            clk_en_a_i,
                            clk_en_a_i} ; 
                wire [2:0] CSB = {clk_en_b_i,
                            clk_en_b_i,
                            clk_en_b_i} ; 
                wire RSTA = rst_a_i ; 
                wire RSTB = rst_b_i ; 
                localparam DW_A = (((DATA_WIDTH_A == 18) || (DATA_WIDTH_A == 16)) ? "X18" : (((DATA_WIDTH_A == 9) || (DATA_WIDTH_A == 8)) ? "X9" : ((DATA_WIDTH_A == 4) ? "X4" : ((DATA_WIDTH_A == 2) ? "X2" : "X1")))) ; 
                localparam REG_A = ((REGMODE_A == "reg") ? "USED" : "BYPASSED") ; 
                localparam RST_A = ((RESETMODE_A == "sync") ? "SYNC" : "ASYNC") ; 
                localparam CSC_A = "000" ; 
                localparam RST_REL_A = ((RESET_RELEASE_A == "sync") ? "SYNC" : "ASYNC") ; 
                localparam DW_B = (((DATA_WIDTH_B == 18) || (DATA_WIDTH_B == 16)) ? "X18" : (((DATA_WIDTH_B == 9) || (DATA_WIDTH_B == 8)) ? "X9" : ((DATA_WIDTH_B == 4) ? "X4" : ((DATA_WIDTH_B == 2) ? "X2" : "X1")))) ; 
                localparam REG_B = ((REGMODE_B == "reg") ? "USED" : "BYPASSED") ; 
                localparam RST_B = ((RESETMODE_B == "sync") ? "SYNC" : "ASYNC") ; 
                localparam CSC_B = "000" ; 
                localparam RST_REL_B = ((RESET_RELEASE_B == "sync") ? "SYNC" : "ASYNC") ; 
                localparam MEM_TYPE = "EBR" ; 
                localparam T_MEM_SIZE = {"[",
                            MEM_SIZE,
                            "]"} ; 
                (* ECO_MEM_TYPE=MEM_TYPE, ECO_MEM_ID=MEM_ID, ECO_MEM_SIZE=T_MEM_SIZE, ECO_MEM_BLOCK_SIZE=BLOCK_SIZE, ECO_MEM_BLOCK_POS=BLOCK_POS *) DP16K dp16k (.DIA(DIA), 
                            .DIB(DIB), 
                            .ADA(ADA), 
                            .ADB(ADB), 
                            .CLKA(CLKA), 
                            .CLKB(CLKB), 
                            .WEA(WEA), 
                            .WEB(WEB), 
                            .CEA(CEA), 
                            .CEB(CEB), 
                            .RSTA(RSTA), 
                            .RSTB(RSTB), 
                            .CSA(CSA), 
                            .CSB(CSB), 
                            .DOA(out_a_w), 
                            .DOB(out_b_w)) ; 
                defparam dp16k.DATA_WIDTH_A = DW_A ; 
                defparam dp16k.DATA_WIDTH_B = DW_B ; 
                defparam dp16k.OUTREG_A = REG_A ; 
                defparam dp16k.OUTREG_B = REG_B ; 
                defparam dp16k.RESETMODE_A = RST_A ; 
                defparam dp16k.RESETMODE_B = RST_B ; 
                defparam dp16k.CSDECODE_A = CSC_A ; 
                defparam dp16k.CSDECODE_B = CSC_B ; 
                defparam dp16k.ASYNC_RST_RELEASE_A = RST_REL_A ; 
                defparam dp16k.ASYNC_RST_RELEASE_B = RST_REL_B ; 
                defparam dp16k.INIT_DATA = "DYNAMIC" ; 
                defparam dp16k.INITVAL_00 = ((INIT_MODE == "mem_file") ? INITVAL_00 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_01 = ((INIT_MODE == "mem_file") ? INITVAL_01 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_02 = ((INIT_MODE == "mem_file") ? INITVAL_02 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_03 = ((INIT_MODE == "mem_file") ? INITVAL_03 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_04 = ((INIT_MODE == "mem_file") ? INITVAL_04 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_05 = ((INIT_MODE == "mem_file") ? INITVAL_05 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_06 = ((INIT_MODE == "mem_file") ? INITVAL_06 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_07 = ((INIT_MODE == "mem_file") ? INITVAL_07 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_08 = ((INIT_MODE == "mem_file") ? INITVAL_08 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_09 = ((INIT_MODE == "mem_file") ? INITVAL_09 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_0A = ((INIT_MODE == "mem_file") ? INITVAL_0A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_0B = ((INIT_MODE == "mem_file") ? INITVAL_0B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_0C = ((INIT_MODE == "mem_file") ? INITVAL_0C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_0D = ((INIT_MODE == "mem_file") ? INITVAL_0D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_0E = ((INIT_MODE == "mem_file") ? INITVAL_0E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_0F = ((INIT_MODE == "mem_file") ? INITVAL_0F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_10 = ((INIT_MODE == "mem_file") ? INITVAL_10 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_11 = ((INIT_MODE == "mem_file") ? INITVAL_11 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_12 = ((INIT_MODE == "mem_file") ? INITVAL_12 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_13 = ((INIT_MODE == "mem_file") ? INITVAL_13 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_14 = ((INIT_MODE == "mem_file") ? INITVAL_14 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_15 = ((INIT_MODE == "mem_file") ? INITVAL_15 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_16 = ((INIT_MODE == "mem_file") ? INITVAL_16 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_17 = ((INIT_MODE == "mem_file") ? INITVAL_17 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_18 = ((INIT_MODE == "mem_file") ? INITVAL_18 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_19 = ((INIT_MODE == "mem_file") ? INITVAL_19 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_1A = ((INIT_MODE == "mem_file") ? INITVAL_1A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_1B = ((INIT_MODE == "mem_file") ? INITVAL_1B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_1C = ((INIT_MODE == "mem_file") ? INITVAL_1C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_1D = ((INIT_MODE == "mem_file") ? INITVAL_1D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_1E = ((INIT_MODE == "mem_file") ? INITVAL_1E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_1F = ((INIT_MODE == "mem_file") ? INITVAL_1F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_20 = ((INIT_MODE == "mem_file") ? INITVAL_20 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_21 = ((INIT_MODE == "mem_file") ? INITVAL_21 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_22 = ((INIT_MODE == "mem_file") ? INITVAL_22 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_23 = ((INIT_MODE == "mem_file") ? INITVAL_23 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_24 = ((INIT_MODE == "mem_file") ? INITVAL_24 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_25 = ((INIT_MODE == "mem_file") ? INITVAL_25 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_26 = ((INIT_MODE == "mem_file") ? INITVAL_26 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_27 = ((INIT_MODE == "mem_file") ? INITVAL_27 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_28 = ((INIT_MODE == "mem_file") ? INITVAL_28 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_29 = ((INIT_MODE == "mem_file") ? INITVAL_29 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_2A = ((INIT_MODE == "mem_file") ? INITVAL_2A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_2B = ((INIT_MODE == "mem_file") ? INITVAL_2B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_2C = ((INIT_MODE == "mem_file") ? INITVAL_2C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_2D = ((INIT_MODE == "mem_file") ? INITVAL_2D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_2E = ((INIT_MODE == "mem_file") ? INITVAL_2E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_2F = ((INIT_MODE == "mem_file") ? INITVAL_2F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_30 = ((INIT_MODE == "mem_file") ? INITVAL_30 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_31 = ((INIT_MODE == "mem_file") ? INITVAL_31 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_32 = ((INIT_MODE == "mem_file") ? INITVAL_32 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_33 = ((INIT_MODE == "mem_file") ? INITVAL_33 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_34 = ((INIT_MODE == "mem_file") ? INITVAL_34 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_35 = ((INIT_MODE == "mem_file") ? INITVAL_35 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_36 = ((INIT_MODE == "mem_file") ? INITVAL_36 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_37 = ((INIT_MODE == "mem_file") ? INITVAL_37 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_38 = ((INIT_MODE == "mem_file") ? INITVAL_38 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_39 = ((INIT_MODE == "mem_file") ? INITVAL_39 : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_3A = ((INIT_MODE == "mem_file") ? INITVAL_3A : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_3B = ((INIT_MODE == "mem_file") ? INITVAL_3B : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_3C = ((INIT_MODE == "mem_file") ? INITVAL_3C : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_3D = ((INIT_MODE == "mem_file") ? INITVAL_3D : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_3E = ((INIT_MODE == "mem_file") ? INITVAL_3E : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
                defparam dp16k.INITVAL_3F = ((INIT_MODE == "mem_file") ? INITVAL_3F : ((INIT_MODE == "all_one") ? "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" : "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000")) ; 
            end
    endgenerate
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] calculateStringSize ; 
        input [31:0] x_calc ; 
        input [31:0] y_calc ; 
        reg [31:0] x_func ; 
        reg [31:0] y_func ; 
        begin
            if ((x_calc 