/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2020 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#ifndef FLASH_CNTL_H_
#define FLASH_CNTL_H_

#include <stdint.h>
#include <stdbool.h>


/*
 ------------------------------------------------------
 -                                                    -
 - Flash Controller Register-map                           -
 -                                                    -
 ------------------------------------------------------
 */
struct flash_cntl_dev {
	// basic command registers
	volatile uint32_t reg_page_program;
	volatile uint32_t reg_page_read;
	volatile uint32_t reg_4k_erase;
	volatile uint32_t reg_32k_erase;
	volatile uint32_t reg_64k_erase;
	volatile uint32_t reg_chip_erase;
	volatile uint32_t reg_wr_en;
	volatile uint32_t reg_wr_dis;
	volatile uint32_t reg_status_read;
	volatile uint32_t reg_status_write;
	volatile uint32_t reg_power_down;
	volatile uint32_t reg_power_up;
	volatile uint32_t reg_mf_id;
	// user command
	volatile uint32_t reg_user_cmd0;
	volatile uint32_t reg_user_cmd1;
	volatile uint32_t reg_user_cmd_length;
	volatile uint32_t reg_user_rtn_length;
	volatile uint32_t reg_user_rtn_data;
	volatile uint32_t reg_use_cmd_init;

	volatile uint32_t reg_write_protect;
};

#define PAGE_PROGRAM_BUFF_OFFSET	0x200
#define PAGE_READ_BUFF_OFFSET		0x400

// command register
#define FLASH_ADDR_MASK  0x0FFFFFF
#define FLASH_CMD_MASK   0xFF000000

// start trans reg
#define START_TRANSACTION  (1 << 0)

// flash cmd list
#define FLASH_READ				0x03
#define FLASH_FAST_READ 		0x0B
#define FLASH_READ_STSTUS		0x05
#define FLASH_STS_WIP		0x01
#define FLASH_WRITE_EN			0x06
#define FLASH_WRITE_DIS			0x04
#define FLASH_PAGE_PROGRAM		0x02



enum
{
 FLASH_4K_ERASE	= 0,
 FLASH_32K_ERASE,
 FLASH_64K_ERASE,
 FLASH_CHIP_ERASE,
};

#define PAGE_SIZE	256
#define SECTOR_SIZE    4096

#define STS_ERR		-1
#define STS_OK		0

#define SCFC_READ_TRANS		2
#define SCFC_WRITE_TRANS	1
#define IDLE			0

struct flash_cntl_instance {
	const char *name;
	uint32_t base;                       // base address of the SCFC module
	uint8_t work_mode;                   // polling mode or INT mode
	uint8_t status;                      // SCFC current status
	uint8_t data_rd_buf[PAGE_SIZE];      // store the data back in INT mode
	uint8_t data_wr_buf[PAGE_SIZE];      // store the data written out in INT mode
};

uint8_t flash_cntl_init(struct flash_cntl_instance *this_flash_cntl,
			uint32_t base_addr);

uint8_t flash_cntl_status_read(struct flash_cntl_instance *this_flash_cntl,
			uint32_t *buff);

uint8_t flash_cntl_status_write(struct flash_cntl_instance *this_flash_cntl,
			 uint8_t status);

uint8_t flash_cntl_page_read(struct flash_cntl_instance *this_flash_cntl,
			 uint32_t addr, uint32_t *buff);

uint8_t flash_cntl_page_program(struct flash_cntl_instance *this_flash_cntl,
		uint32_t addr, uint32_t *buff);

uint8_t flash_cntl_erase(struct flash_cntl_instance *this_flash_cntl,
			    uint32_t addr, uint32_t mode);

uint8_t flash_cntl_pw(struct flash_cntl_instance *this_flash_cntl,
			 uint32_t power_on);

uint8_t flash_cntl_id_read(struct flash_cntl_instance *this_flash_cntl,
			 uint8_t *manu_id);

void flash_cntl_isr(void *ctx);

#endif				/* FLASH_CNTL_H_ */
