
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Radiant Software (64-bit)
    3.1.0.43.0
    Soft IP Version: 1.1.0
    2022 01 31 00:42:29
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module lpddr4_mc_dpram (wr_clk_i, 
        rd_clk_i, 
        wr_clk_en_i, 
        rd_en_i, 
        rd_clk_en_i, 
        wr_en_i, 
        wr_data_i, 
        wr_addr_i, 
        rd_addr_i, 
        rd_data_o) ;

parameter WIDTH = 26;
parameter DEPTH = 8;
parameter DEPTH_LOG = $clog2(DEPTH);


    input wr_clk_i ; 
    input rd_clk_i ; 
    input wr_clk_en_i ; 
    input rd_en_i ; 
    input rd_clk_en_i ; 
    input wr_en_i ; 
    input [WIDTH -1:0] wr_data_i ; 
    input [DEPTH_LOG-1:0] wr_addr_i ; 
    input [DEPTH_LOG-1:0] rd_addr_i ; 
    output [WIDTH-1:0] rd_data_o ; 
    dpram_ipgen_lscc_distributed_dpram #(.FAMILY("common"),
            .WADDR_DEPTH(DEPTH),
            .WDATA_WIDTH(WIDTH),
            .RADDR_DEPTH(DEPTH),
            .RDATA_WIDTH(WIDTH),
            .WADDR_WIDTH(DEPTH_LOG),
            .REGMODE("noreg"),
            .RADDR_WIDTH(DEPTH_LOG),
            .RESETMODE("sync"),
            .INIT_MODE("none"),
            .INIT_FILE("none"),
            .INIT_FILE_FORMAT("hex")) lscc_distributed_dpram_inst (.wr_clk_i(wr_clk_i), 
                .rd_clk_i(rd_clk_i), 
                .rst_i(1'b0), 
                .wr_clk_en_i(wr_clk_en_i), 
                .rd_en_i(rd_en_i), 
                .rd_clk_en_i(rd_clk_en_i), 
                .wr_en_i(wr_en_i), 
                .wr_data_i(wr_data_i), 
                .wr_addr_i(wr_addr_i), 
                .rd_addr_i(rd_addr_i), 
                .rd_data_o(rd_data_o)) ; 
endmodule



// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               : Radiant Software 1.1
// File                  : lscc_distributed_dpram.v
// Title                 :
// Dependencies          :
// Description           : Implements a pseudo Dual Port RAM using distributed memory.
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0.
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module dpram_ipgen_lscc_distributed_dpram #(parameter WADDR_DEPTH = 256, 
        parameter WADDR_WIDTH = clog2(WADDR_DEPTH), 
        parameter WDATA_WIDTH = 8, 
        parameter RADDR_DEPTH = 256, 
        parameter RADDR_WIDTH = clog2(RADDR_DEPTH), 
        parameter RDATA_WIDTH = 8, 
        parameter REGMODE = "reg", 
        parameter GSR = "", 
        parameter RESETMODE = "sync", 
        parameter INIT_FILE = "none", 
        parameter INIT_FILE_FORMAT = "binary", 
        parameter FAMILY = "common", 
        parameter MODULE_TYPE = "lscc_distributed_dpram", 
        parameter INIT_MODE = "none", 
        parameter BYTE_ENABLE = 0, 
        parameter BYTE_SIZE = 8, 
        parameter BYTE_WIDTH = 0, 
        parameter PIPELINES = 0, 
        parameter ECC_ENABLE = "") (
    // -----------------------------------------------------------------------------
    // Input/Output Ports
    // -----------------------------------------------------------------------------
    input wr_clk_i, 
    input rd_clk_i, 
    input rst_i, 
    input wr_clk_en_i, 
    input rd_clk_en_i, 
    input wr_en_i, 
    input [(WDATA_WIDTH - 1):0] wr_data_i, 
    input [(WADDR_WIDTH - 1):0] wr_addr_i, 
    input rd_en_i, 
    input [(RADDR_WIDTH - 1):0] rd_addr_i, 
    output [(RDATA_WIDTH - 1):0] rd_data_o) ;
    // -----------------------------------------------------------------------------
    // Local Parameters
    // -----------------------------------------------------------------------------
    // -----------------------------------------------------------------------------
    // Register Declarations
    // -----------------------------------------------------------------------------
    (* syn_ramstyle="distributed" *) reg [(RDATA_WIDTH - 1):0] mem [((2 ** RADDR_WIDTH) - 1):0] ; 
    reg [(RDATA_WIDTH - 1):0] out_raw ; 
    reg [(RDATA_WIDTH - 1):0] out_buffer ; 
    wire write_enable = (wr_clk_en_i & wr_en_i) ; 
    wire read_enable = (rd_clk_en_i & rd_en_i) ; 
    assign rd_data_o = ((REGMODE == "noreg") ? out_raw : out_buffer) ; 
    // -----------------------------------------------------------------------------
    // Initial Block
    // -----------------------------------------------------------------------------
    initial
        begin
            if (((INIT_MODE == "mem_file") && (INIT_FILE != "none"))) 
                begin
                    if ((INIT_FILE_FORMAT == "hex")) 
                        begin
                            $readmemh (INIT_FILE,
                                    mem,
                                    0,
                                    (RADDR_DEPTH - 1)) ;
                        end
                    else
                        begin
                            $readmemb (INIT_FILE,
                                    mem,
                                    0,
                                    (RADDR_DEPTH - 1)) ;
                        end
                end
        end
    // -----------------------------------------------------------------------------
    // Generate Sequential Blocks
    // -----------------------------------------------------------------------------
    always
        @(posedge wr_clk_i)
        begin
            if ((write_enable == 1'b1)) 
                begin
                    mem[wr_addr_i] <=  wr_data_i ;
                end
        end
    always
        @(*)
        begin
            out_raw = mem[rd_addr_i] ;
        end
    if ((REGMODE == "reg")) 
        begin : genblk1
            if ((RESETMODE == "async")) 
                begin : genblk1
                    always
                        @(posedge rd_clk_i or 
                            posedge rst_i)
                        begin
                            if ((rst_i == 1'b1)) 
                                begin
                                    out_buffer <=  'h0 ;
                                end
                            else
                                if ((read_enable == 1'b1)) 
                                    begin
                                        out_buffer <=  out_raw ;
                                    end
                        end
                end
            else
                begin : genblk1
                    always
                        @(posedge rd_clk_i)
                        begin
                            if ((rst_i == 1'b1)) 
                                begin
                                    out_buffer <=  'h0 ;
                                end
                            else
                                if ((read_enable == 1'b1)) 
                                    begin
                                        out_buffer <=  out_raw ;
                                    end
                        end
                end
        end
    //------------------------------------------------------------------------------
    // Function Definition
    //------------------------------------------------------------------------------
    function [31:0] clog2 ; 
        input [31:0] value ; 
        reg [31:0] num ; 
        begin
            num = (value - 1) ;
            for (clog2 = 0 ; (num > 0) ; clog2 = (clog2 + 1))
                num = (num >> 1) ;
        end
    endfunction
endmodule


