# =============================================================================
# >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
# -----------------------------------------------------------------------------
#   Copyright (c) 2019 by Lattice Semiconductor Corporation
#   ALL RIGHTS RESERVED
# -----------------------------------------------------------------------------
#
#   Permission:
#
#      Lattice SG Pte. Ltd. grants permission to use this code
#      pursuant to the terms of the Lattice Reference Design License Agreement.
#
#
#   Disclaimer:
#
#      This VHDL or Verilog source code is intended as a design reference
#      which illustrates how these types of functions can be implemented.
#      It is the user's responsibility to verify their design for
#      consistency and functionality through the use of formal
#      verification methods.  Lattice provides no warranty
#      regarding the use or functionality of this code.
#
# ------------------------------------------------------------------------------
#
#                  Lattice SG Pte. Ltd.
#                  101 Thomson Road, United Square #07-02
#                  Singapore 307591
#
#
#                  TEL: 1-800-Lattice (USA and Canada)
#                       +65-6631-2000 (Singapore)
#                       +1-503-268-8001 (other locations)
#
#                  web: http://www.latticesemi.com/
#                  email: techsupport@latticesemi.com
#
# ------------------------------------------------------------------------------
#
# ==============================================================================
#                         FILE DETAILS
# Project               : LIFCL
# File                  : create_constraint.py
# Title                 :
# Dependencies          : 1.
#                       : 2.
# Description           :
# ==============================================================================
#                        REVISION HISTORY
# Version               : 1.0.0
# Author(s)             :
# Mod. Date             :
# Changes Made          : Initial release.
# ==============================================================================
import os

# Initialize parameter dictionary
ip_params = {'CLOCK_SEL':0}
str_param = ['CLOCK_SEL', 'END']

f_pdc = open('eval/constraint.pdc', 'w')


def load_parameters():
    global ip_params

    f_params = open('eval/dut_params.v', 'r')
    param = ''
    i = 0
    while True:
        line = f_params.readline()
        str_spl = line.split(' ')
        val = str_spl[-1]
        param = str_spl[1]
        if str_param[i] == 'END':
            break
        elif param == str_param[i]:
            pos = val.index(';')
            val = val[0:pos]
            #print(param, ' = ', val)
            i = i + 1
            if '.' in val:
                ip_params[str_spl[1]] = float(val)
            else:
                ip_params[str_spl[1]] = int(val.replace('"', ''))
                #print(str_spl[1], " = ", val)
    return


load_parameters()
f_pdc.write("set HCLK_PERIOD  10\n")
f_pdc.write("set PCLK_PERIOD  20\n")
f_pdc.write("create_clock -name {ahbl_hclk_i} -period $HCLK_PERIOD [get_ports ahbl_hclk_i]\n")
f_pdc.write("create_clock -name {apb_pclk_i}  -period $PCLK_PERIOD [get_ports apb_pclk_i]\n\n")

f_pdc.write("## Generated SPI Clock:\n")
f_pdc.write("set CLOCK_SEL %d\n\n" % ip_params['CLOCK_SEL'])
f_pdc.write("if {$CLOCK_SEL > 0} {\n")
f_pdc.write("  set CLK_DIV [expr {2*$CLOCK_SEL}]\n")
f_pdc.write("} else {\n")
f_pdc.write("  set CLK_DIV 1\n")
f_pdc.write("}\n")
f_pdc.write("create_generated_clock -name {spi_clk} -source [get_ports apb_pclk_i] -divide_by $CLK_DIV [get_nets lscc_spi_flash_inst/spi_flash_intf_inst/spi_clk]\n\n")

f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/ahb_spi_req}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/ahb_spi_addr*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/ahb_spi_wr}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/ahb_byte_length*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/ahb_write_data*}]\n\n")

f_pdc.write("set_false_path -from [get_nets  {lscc_spi_flash_inst/apb_spi_req}]\n")
f_pdc.write("set_false_path -from [get_nets  {lscc_spi_flash_inst/apb_spi_addr*}]\n")
f_pdc.write("set_false_path -from [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/apb_write_data*}]\n\n")

f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_spi_addr_mode}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_lsb_first}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/cpol}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/cphase}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_fast_read}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_spi_read*}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_spi_page_prg*}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_spi_read_stat*}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_spi_fast_read*}] -to [get_clocks spi_clk]\n\n")

f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_byte_prg*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_blk1_ers*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_blk2_ers*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_blk3_ers*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_chip_ers*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_wrt_disb*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_wrt_stat*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_pwd_down*}]\n") 
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_pwd_up*}]\n")
f_pdc.write("set_false_path -through [get_nets {lscc_spi_flash_inst/apb_intf_inst/reg_spi_dev_id*}]\n\n")

f_pdc.write("set_false_path -from [get_nets {lscc_spi_flash_inst/apb_intf_inst/apb_wp_enable}] -to [get_clocks spi_clk]\n\n")

f_pdc.write("set_false_path -from [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/spi_mode_sel_r*}] -to [get_clocks spi_clk]\n")
f_pdc.write("set_false_path -from [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/cs_r_pre*}] -to [get_clocks spi_clk]\n\n")

f_pdc.close()
