# =============================================================================
# >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
# -----------------------------------------------------------------------------
#   Copyright (c) 2024 by Lattice Semiconductor Corporation
#   ALL RIGHTS RESERVED
# -----------------------------------------------------------------------------
#
#   Permission:
#
#      Lattice SG Pte. Ltd. grants permission to use this code
#      pursuant to the terms of the Lattice Reference Design License Agreement.
#
#
#   Disclaimer:
#
#      This VHDL or Verilog source code is intended as a design reference
#      which illustrates how these types of functions can be implemented.
#      It is the user's responsibility to verify their design for
#      consistency and functionality through the use of formal
#      verification methods.  Lattice provides no warranty
#      regarding the use or functionality of this code.
#
# ------------------------------------------------------------------------------
#
#                  Lattice SG Pte. Ltd.
#                  101 Thomson Road, United Square #07-02
#                  Singapore 307591
#
#
#                  TEL: 1-800-Lattice (USA and Canada)
#                       +65-6631-2000 (Singapore)
#                       +1-503-268-8001 (other locations)
#
#                  web: http://www.latticesemi.com/
#                  email: techsupport@latticesemi.com
#
# ------------------------------------------------------------------------------
#
# ==============================================================================
#                         FILE DETAILS
# Project               : LIFCL
# File                  : create_constraint.py
# Title                 :
# Dependencies          : 1.
#                       : 2.
# Description           :
# ==============================================================================
#                        REVISION HISTORY
# Version               : 1.0.0
# Author(s)             :
# Mod. Date             :
# Changes Made          : Initial release.
# ==============================================================================
import os

f_pdc = open('eval/constraint.pdc', 'w')

def load_parameter(param_name):
    f_params = open('eval/dut_params.v', 'r')
    while f_params:
        line = f_params.readline()
        if (param_name in line):
            str_spl = line.split('=')
            val = str_spl[1]
            f_val = val.replace(";\n",'')
            f_val2 = f_val.replace("\"",'')
            f_val3 = f_val2.replace(" ",'')
            break
    f_params.close()
    return (f_val3)


clock_sel_param                           = load_parameter("CLOCK_SEL") 
clock_sel_val                             = int(clock_sel_param.replace('"', ' '))
page_prg_buf_ena_param                    = load_parameter("PAGE_PRG_BUF_ENA") 
page_prg_buffer_distributed_ram_param     = load_parameter("PAGE_PRG_BUFFER_DISTRIBUTED_RAM") 
page_prg_buffer_ebr_param                 = load_parameter("PAGE_PRG_BUFFER_EBR") 
page_read_buf_ena_param                   = load_parameter("PAGE_READ_BUF_ENA") 
page_read_buffer_distributed_ram_param    = load_parameter("PAGE_READ_BUFFER_DISTRIBUTED_RAM") 
page_read_buffer_ebr_param                = load_parameter("PAGE_READ_BUFFER_EBR") 
page_buffer_intf_param                    = load_parameter("PAGE_BUFFER_INTF")
c_apb_dat_width_param                     = load_parameter("C_APB_DAT_WIDTH")
s_ahb_dat_width_param                     = load_parameter("S_AHB_DAT_WIDTH")

f_pdc.write("set HCLK_PERIOD  10\n")
f_pdc.write("set PCLK_PERIOD  20\n")
f_pdc.write("create_clock -name {ahbl_hclk_i} -period $HCLK_PERIOD [get_ports ahbl_hclk_i]\n")
f_pdc.write("create_clock -name {apb_pclk_i}  -period $PCLK_PERIOD [get_ports apb_pclk_i]\n\n")

f_pdc.write("## Generated SPI Clock:\n")
f_pdc.write("set CLOCK_SEL %d\n\n" % clock_sel_val)
f_pdc.write("if {$CLOCK_SEL > 0} {\n")
f_pdc.write("  set CLK_DIV [expr {2*$CLOCK_SEL}]\n")
f_pdc.write("} else {\n")
f_pdc.write("  set CLK_DIV 1\n")
f_pdc.write("}\n")
f_pdc.write("create_generated_clock -name {spi_clk} -source [get_ports apb_pclk_i] -divide_by $CLK_DIV [get_nets lscc_spi_flash_inst/spi_clk]\n\n")

f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*spi_req*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*spi_wr}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*spi_addr*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*byte_length*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*write_data*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_spi_req}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_spi_addr*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_lsb_first}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/cpol}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/cphase}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_fast_read}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_spi_read*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_spi_fast_read*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_wp_enable}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_write_data*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*paddr*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_spi_wrt_enb[*]}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_byte_length[*]}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_dummy*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_usr_dummy*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_usr_dir}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_usr_dlen[*]}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_page_prg_len[*]}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_page_rd_len[*]}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_blk1_ers*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_blk2_ers*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_blk3_ers*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_chip_ers*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_wrt_stat*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_page_prg*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_pwd_down*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_pwd_up*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_dev_id*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_spi_wrt_disb*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/apb_intf_inst/*reg_usr_cmd*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*ahb0_apb1*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/*read_data*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/reg_spi_ack*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/cs_r*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/spi_state*}]\n")
f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/read_data_en*}]\n")
        
if (page_prg_buf_ena_param == '1'):
    f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/*page_wr_addr*}]\n")
        
if (page_read_buf_ena_param == '1'):
    f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/*_we}]\n")
    f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/spi_flash_intf_inst/*page_rd_addr*}]\n")
    
if (page_prg_buf_ena_param == '1' and page_prg_buffer_distributed_ram_param == '1'):
    f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/PAGE_PRG_BUF.prg_buffer_distributed_mem.page_prg_buf_inst/u_mem0/mem_ram_*}]\n")

if (page_read_buf_ena_param == '1' and page_read_buffer_distributed_ram_param == '1'):
    f_pdc.write("set_false_path -through [get_nets  {lscc_spi_flash_inst/PAGE_READ_BUF.read_buffer_distributed_mem.page_read_buf_inst/u_mem0/mem_ram_*}]\n")

f_pdc.write("##set_input_delay -clock [get_clocks spi_clk] -clock_fall -max 8 [get_ports miso_i]\n")
f_pdc.write("##set_input_delay -clock [get_clocks spi_clk] -clock_fall -min 7 [get_ports miso_i]\n")

f_pdc.close()
