/*   ==================================================================

     >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2024 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL™
       DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

    LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS,
    WHETHER EXPRESSED, IMPLIED, STATUTORY,
    OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR
    COMMUNICATION WITH LICENSEE,
    AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
    LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET
    LICENSEE 'S REQUIREMENTS, OR THAT LICENSEE' S OPERATION OF ANY DEVICE,
    SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE
    UNINTERRUPTED OR ERROR FREE,
    OR THAT DEFECTS HEREIN WILL BE CORRECTED.
    LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE
    ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE,
    AND RESULTS OBTAINED THEREFROM.
    LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING
    DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT,
    LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE,
    CORRECTION,
    OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
    SOFTWARE.IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
    INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
    INCLUDING LOST PROFITS,
    ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS,
    EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
    LATTICE 'S SOLE LIABILITY, AND LICENSEE' S SOLE REMEDY,
    IS SET FORTH ABOVE.
    LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE,
    ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES'
    INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER' S
    RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND
    FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.
     ------------------------------------------------------------------

     ================================================================== */

#include <stdint.h>
#include "riscv.h"
#include "debug.h"
#include "pmp.h"


typedef struct {
    uint8_t r : 1;
    uint8_t w : 1;
    uint8_t x : 1;
    uint8_t a : 2;
    uint8_t rsvd : 2;
    uint8_t l : 1;
} pmp_cfg_field;

typedef union
{
    pmp_cfg_field fields[4];
    reg_t val;
} pmp_cfg_reg;

static uint32_t s_pmp_granularity = 0;


uint32_t pmp_init()
{
	asm volatile("csrw pmpcfg0, %0" : : "r" (0));

    reg_t addr = 0;
    csr_write(CSR_PMPADDR0, 0xffffffff);
    addr = csr_read(CSR_PMPADDR0);

    for (uint32_t i = 0; i < sizeof(addr)*8; ++i)
    {
        if ((1<<i) & addr)
        {
            s_pmp_granularity = 1 << (i + 2);
            break;
        }
    }

    return 0;
}


uint32_t pmp_granularity()
{
    return s_pmp_granularity;
}


uint32_t pmp_entry_lock_read(uint32_t id, uint32_t *lock)
{
    if (id >= PMP_ENTRY_NUM)
    {
        ERROR("invalid pmp entry id, id=%d\r\n", id);
        return 1;
    }

	pmp_cfg_reg reg;
	asm volatile("csrr %0, pmpcfg0" : "=r" (reg.val));

    *lock = reg.fields[id].l;
    
	return 0;
}


uint32_t pmp_entry_lock_write(uint32_t id, uint32_t lock)
{
    if (id >= PMP_ENTRY_NUM)
    {
        ERROR("invalid pmp entry id, id=%d\r\n", id);
        return 1;
    }

	pmp_cfg_reg reg;
	asm volatile("csrr %0, pmpcfg0" : "=r" (reg.val));

    if (reg.fields[id].l)
    {
        ERROR("pmp entry already locked, id=%d\r\n", id);
        return 1;
    }
    
    reg.fields[id].l = lock;
	asm volatile("csrw pmpcfg0, %0" : : "r" (reg.val));

    return 0;
}


uint32_t pmp_entry_read(uint32_t id, pmp_entry_t *entry)
{
    if (id >= PMP_ENTRY_NUM)
    {
        ERROR("invalid pmp entry id, id=%d\r\n", id);
        return 1;
    }

	pmp_cfg_reg reg;
	asm volatile("csrr %0, pmpcfg0" : "=r" (reg.val));

    entry->mode = reg.fields[id].a;
    entry->permission = reg.fields[id].r ? PMP_CFG_PER_R : 0;
    entry->permission |= reg.fields[id].w ? PMP_CFG_PER_W : 0;
    entry->permission |= reg.fields[id].x ? PMP_CFG_PER_X : 0;

    switch(id)
    {
    case 0:
        entry->addr = csr_read(CSR_PMPADDR0);
        break;
    case 1:
        entry->addr = csr_read(CSR_PMPADDR1);
        break;
    case 2:
        entry->addr = csr_read(CSR_PMPADDR2);
        break;
    case 3:
        entry->addr = csr_read(CSR_PMPADDR3);
        break;
    default:
        break;
    }
 
    return 0;
}


uint32_t pmp_entry_write(uint32_t id, const pmp_entry_t *entry)
{
    if (id >= PMP_ENTRY_NUM)
    {
        ERROR("invalid pmp entry id, id=%d\r\n", id);
        return 1;
    }

	pmp_cfg_reg reg;
	asm volatile("csrr %0, pmpcfg0" : "=r" (reg.val));

    if (reg.fields[id].l)
    {
        ERROR("pmp entry already locked, id=%d\r\n", id);
        return 1;
    }

    reg.fields[id].a = entry->mode;
    reg.fields[id].r = ((entry->permission & PMP_CFG_PER_R) == PMP_CFG_PER_R) ? 1 : 0;
    reg.fields[id].w = ((entry->permission & PMP_CFG_PER_W) == PMP_CFG_PER_W) ? 1 : 0;
    reg.fields[id].x = ((entry->permission & PMP_CFG_PER_X) == PMP_CFG_PER_X) ? 1 : 0;
	asm volatile("csrw pmpcfg0, %0" : : "r" (reg.val));

    switch(id)
    {
    case 0:
        csr_write(CSR_PMPADDR0, entry->addr);
        break;
    case 1:
        csr_write(CSR_PMPADDR1, entry->addr);
        break;
    case 2:
        csr_write(CSR_PMPADDR2, entry->addr);
        break;
    case 3:
        csr_write(CSR_PMPADDR3, entry->addr);
        break;
    default:
        break;
    }
 
    return 0;
}



