
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Propel (64-bit)
    1.1.2010292113
    Soft IP Version: 1.0.0
    2021 04 10 11:05:39
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module memc_apb (
        pclk_i,
        preset_n_i,
        apb_penable_slv_i, 
        apb_psel_slv_i, 
        apb_pwrite_slv_i, 
        apb_paddr_slv_i, 
        apb_pwdata_slv_i, 
        apb_pready_slv_o, 
        apb_pslverr_slv_o, 
        apb_prdata_slv_o, 
        apb_penable_mstr_o, 
        apb_psel_mstr_o, 
        apb_pwrite_mstr_o, 
        apb_paddr_mstr_o, 
        apb_pwdata_mstr_o, 
        apb_pready_mstr_i, 
        apb_pslverr_mstr_i, 
        apb_prdata_mstr_i) ;
    input pclk_i;
    input preset_n_i;
    input apb_penable_slv_i ; 
    input apb_psel_slv_i ; 
    input apb_pwrite_slv_i ; 
    input [11:0] apb_paddr_slv_i ; 
    input [31:0] apb_pwdata_slv_i ; 
    output apb_pready_slv_o ; 
    output apb_pslverr_slv_o ; 
    output [31:0] apb_prdata_slv_o ; 
    output apb_penable_mstr_o ; 
    output apb_psel_mstr_o ; 
    output apb_pwrite_mstr_o ; 
    output [11:0] apb_paddr_mstr_o ; 
    output [31:0] apb_pwdata_mstr_o ; 
    input apb_pready_mstr_i ; 
    input apb_pslverr_mstr_i ; 
    input [31:0] apb_prdata_mstr_i ; 
    memc_apb_ipgen_lscc_apb_feedthrough #(.M_ADDR_WIDTH(12),
            .DATA_WIDTH(32)) lscc_apb_feedthrough_inst (
                .pclk_i    (pclk_i),
                .preset_n_i(preset_n_i),
                .apb_penable_slv_i(apb_penable_slv_i), 
                .apb_psel_slv_i(apb_psel_slv_i), 
                .apb_pwrite_slv_i(apb_pwrite_slv_i), 
                .apb_paddr_slv_i(apb_paddr_slv_i[11:0]), 
                .apb_pwdata_slv_i(apb_pwdata_slv_i[31:0]), 
                .apb_pready_slv_o(apb_pready_slv_o), 
                .apb_pslverr_slv_o(apb_pslverr_slv_o), 
                .apb_prdata_slv_o(apb_prdata_slv_o[31:0]), 
                .apb_penable_mstr_o(apb_penable_mstr_o), 
                .apb_psel_mstr_o(apb_psel_mstr_o), 
                .apb_pwrite_mstr_o(apb_pwrite_mstr_o), 
                .apb_paddr_mstr_o(apb_paddr_mstr_o[11:0]), 
                .apb_pwdata_mstr_o(apb_pwdata_mstr_o[31:0]), 
                .apb_pready_mstr_i(apb_pready_mstr_i), 
                .apb_pslverr_mstr_i(apb_pslverr_mstr_i), 
                .apb_prdata_mstr_i(apb_prdata_mstr_i[31:0])) ; 
endmodule



`timescale 1ns/1ps
// =============================================================================
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -----------------------------------------------------------------------------
//   Copyright (c) 2022 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED
// -----------------------------------------------------------------------------
//
//   Permission:
//
//      Lattice SG Pte. Ltd. grants permission to use this code
//      pursuant to the terms of the Lattice Reference Design License Agreement.
//
//
//   Disclaimer:
//
//      This VHDL or Verilog source code is intended as a design reference
//      which illustrates how these types of functions can be implemented.
//      It is the user's responsibility to verify their design for
//      consistency and functionality through the use of formal
//      verification methods.  Lattice provides no warranty
//      regarding the use or functionality of this code.
//
// -----------------------------------------------------------------------------
//
//                  Lattice SG Pte. Ltd.
//                  101 Thomson Road, United Square #07-02
//                  Singapore 307591
//
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                       +65-6631-2000 (Singapore)
//                       +1-503-268-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
// -----------------------------------------------------------------------------
//
// =============================================================================
//                         FILE DETAILS
// Project               :
// File                  : lscc_apb_feedthrough.v
// Title                 :
// Dependencies          : 1.
//                       : 2.
// Description           : Provides address map for master or memory map for slave.
//                         This is useful for exporting bus interfaces
// =============================================================================
//                        REVISION HISTORY
// Version               : 1.0.0
// Author(s)             :
// Mod. Date             :
// Changes Made          : Initial release.
// =============================================================================
module memc_apb_ipgen_lscc_apb_feedthrough #(parameter M_ADDR_WIDTH = 32, 
        parameter DATA_WIDTH = 32) (
    // -----------------------------------------------------------------------------
    // Module Parameters
    // -----------------------------------------------------------------------------
    // Propel has special purpose for M_ADDR_WIDTH in bridges 
    // ------------------------------------------------------------------------------
    // Input/Output Ports
    // ------------------------------------------------------------------------------
    //----------------------------
    // APB Interface 
    //----------------------------
    input                             pclk_i,
    input                             preset_n_i,
    input                             apb_penable_slv_i,  // apb enable
    input                             apb_psel_slv_i,  // apb slave select
    input                             apb_pwrite_slv_i,  // apb write 1, read 0
    input      [(M_ADDR_WIDTH - 1):0] apb_paddr_slv_i,  // apb address
    input      [(DATA_WIDTH - 1):0]   apb_pwdata_slv_i,  // apb write data
    output reg                        apb_pready_slv_o,  // apb ready
    output reg                        apb_pslverr_slv_o,  // apb slave error
    output reg [(DATA_WIDTH - 1):0]   apb_prdata_slv_o,  // apb read data
    output reg                        apb_penable_mstr_o,  // apb enable
    output reg                        apb_psel_mstr_o,  // apb slave select
    output reg                        apb_pwrite_mstr_o,  // apb write 1, read 0
    output reg [(M_ADDR_WIDTH - 1):0] apb_paddr_mstr_o,  // apb address
    output reg [(DATA_WIDTH - 1):0]   apb_pwdata_mstr_o,  // apb write data
    input                             apb_pready_mstr_i,  // apb ready
    input                             apb_pslverr_mstr_i,  // apb slave error
    input      [(DATA_WIDTH - 1):0]   apb_prdata_mstr_i // apb read data
) ;
//    assign apb_penable_mstr_o = apb_penable_slv_i ; 
//    assign apb_psel_mstr_o = apb_psel_slv_i ; 
//    assign apb_pwrite_mstr_o = apb_pwrite_slv_i ; 
//    assign apb_paddr_mstr_o = apb_paddr_slv_i ; 
//    assign apb_pwdata_mstr_o = apb_pwdata_slv_i ; 
//    assign apb_pready_slv_o = apb_pready_mstr_i ; 
//    assign apb_pslverr_slv_o = apb_pslverr_mstr_i ; 
//    assign apb_prdata_slv_o = apb_prdata_mstr_i ; 
always @(posedge pclk_i or negedge preset_n_i) begin
  if (!preset_n_i) begin
    apb_pready_slv_o   <= 'h0;
    apb_pslverr_slv_o  <= 'h0;
    apb_prdata_slv_o   <= 'h0;
    apb_penable_mstr_o <= 'h0;
    apb_psel_mstr_o    <= 'h0;
    apb_pwrite_mstr_o  <= 'h0;
    apb_paddr_mstr_o   <= 'h0;
    apb_pwdata_mstr_o  <= 'h0;
  end
  else begin
    if (apb_pready_mstr_i | apb_pready_slv_o) begin
      apb_psel_mstr_o    <= 1'b0 ;
      apb_penable_mstr_o <= 1'b0 ;
    end
    else begin
      apb_psel_mstr_o    <= apb_psel_slv_i    ; 
      apb_penable_mstr_o <= apb_penable_slv_i ; 
    end
    if (apb_psel_slv_i && !apb_penable_slv_i) begin
      apb_pwrite_mstr_o  <= apb_pwrite_slv_i  ; 
      apb_paddr_mstr_o   <= apb_paddr_slv_i   ; 
      apb_pwdata_mstr_o  <= apb_pwdata_slv_i  ; 
    end 
    apb_pready_slv_o     <= apb_pready_mstr_i ; 
    if (apb_pready_mstr_i) begin
      apb_pslverr_slv_o  <= apb_pslverr_mstr_i; 
      apb_prdata_slv_o   <= apb_prdata_mstr_i ;   
    end
  end
end

endmodule


