// >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// ------------------------------------------------------------------
// Copyright (c) 2019-2024 by Lattice Semiconductor Corporation
// ALL RIGHTS RESERVED
// ------------------------------------------------------------------
//
// IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL
// DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.
//
// Lattice grants permission to use this code pursuant to the
// terms of the Lattice Propel License Agreement.
//
// DISCLAIMER:
//
//  LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER
//  EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE
//  PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE
//  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
//  FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE
//  FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT
//  LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE
//  OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS
//  HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR 
//  SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE
//  PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE
//  ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE
//  OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL
//  ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR
//  ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE
//  SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT,
//  INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST
//  PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF
//  LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S
//  SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE. 
//  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR
//  USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY
//  RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY
//  THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE
//  USE OF FORMAL SOFTWARE VALIDATION METHODS.
// ------------------------------------------------------------------

/* synthesis translate_off*/
`define SBP_SIMULATION
/* synthesis translate_on*/
`ifndef SBP_SIMULATION
`define SBP_SYNTHESIS
`endif



//
// Verific Verilog Description of module cpnx_riscv_rx_rd
//
module cpnx_riscv_rx_rd (ddr_ca_o, ddr_ck_o, ddr_cke_o, ddr_cs_o, ddr_dmi_io, 
            ddr_dq_io, ddr_dqs_io, gpio_io, ddr_pll_refclk_i, ddr_reset_n_o, 
            miso_i, mosi_o, rstn_i, sclk_o, ss_n_o, uart_rxd_i, 
            uart_txd_o, wpj_o);
    output [5:0]ddr_ca_o;
    output [0:0]ddr_ck_o;
    output [0:0]ddr_cke_o;
    output [0:0]ddr_cs_o;
    inout [3:0]ddr_dmi_io;
    inout [31:0]ddr_dq_io;
    inout [3:0]ddr_dqs_io;
    inout [7:0]gpio_io;
    input ddr_pll_refclk_i;
    output ddr_reset_n_o;
    input miso_i;
    output mosi_o;
    input rstn_i;
    output sclk_o;
    output ss_n_o;
    input uart_rxd_i;
    output uart_txd_o;
    output wpj_o;
    
    wire [31:0]apb_interconnect0_inst_APB_M00_interconnect_PADDR;
    wire [31:0]apb_interconnect0_inst_APB_M00_interconnect_PRDATA;
    wire [31:0]apb_interconnect0_inst_APB_M00_interconnect_PWDATA;
    wire [31:0]apb_interconnect0_inst_APB_M01_interconnect_PADDR;
    wire [31:0]apb_interconnect0_inst_APB_M01_interconnect_PRDATA;
    wire [31:0]apb_interconnect0_inst_APB_M01_interconnect_PWDATA;
    wire [31:0]apb_interconnect0_inst_APB_M02_interconnect_PADDR;
    wire [31:0]apb_interconnect0_inst_APB_M02_interconnect_PRDATA;
    wire [31:0]apb_interconnect0_inst_APB_M02_interconnect_PWDATA;
    wire [31:0]axi2apb0_inst_APB3_M_interconnect_PADDR;
    wire [31:0]axi2apb0_inst_APB3_M_interconnect_PRDATA;
    wire [31:0]axi2apb0_inst_APB3_M_interconnect_PWDATA;
    
    wire apb_interconnect0_inst_APB_M00_interconnect_PENABLE, apb_interconnect0_inst_APB_M00_interconnect_PREADY, 
        apb_interconnect0_inst_APB_M00_interconnect_PSELx, apb_interconnect0_inst_APB_M00_interconnect_PSLVERR, 
        apb_interconnect0_inst_APB_M00_interconnect_PWRITE, apb_interconnect0_inst_APB_M01_interconnect_PENABLE, 
        apb_interconnect0_inst_APB_M01_interconnect_PREADY, apb_interconnect0_inst_APB_M01_interconnect_PSELx, 
        apb_interconnect0_inst_APB_M01_interconnect_PSLVERR, apb_interconnect0_inst_APB_M01_interconnect_PWRITE, 
        apb_interconnect0_inst_APB_M02_interconnect_PENABLE, apb_interconnect0_inst_APB_M02_interconnect_PREADY, 
        apb_interconnect0_inst_APB_M02_interconnect_PSELx, apb_interconnect0_inst_APB_M02_interconnect_PSLVERR, 
        apb_interconnect0_inst_APB_M02_interconnect_PWRITE, pll0_inst_clkop_o_net, 
        cpu_inst_system_resetn_o_net, axi2apb0_inst_APB3_M_interconnect_PENABLE, 
        axi2apb0_inst_APB3_M_interconnect_PREADY, axi2apb0_inst_APB3_M_interconnect_PSELx, 
        axi2apb0_inst_APB3_M_interconnect_PSLVERR, axi2apb0_inst_APB3_M_interconnect_PWRITE;
    wire [31:0]axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HADDR;
    wire [2:0]axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HBURST;
    wire [31:0]axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HRDATA;
    wire [2:0]axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HSIZE;
    wire [1:0]axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HTRANS;
    wire [31:0]axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HWDATA;
    wire [63:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARBURST;
    wire [3:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARCACHE;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARID;
    wire [7:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARLEN;
    wire [2:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARPROT;
    wire [3:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARQOS;
    wire [3:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARREGION;
    wire [2:0]axi_interconnect_0_inst_AXI_M03_interconnect_ARSIZE;
    wire [63:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWBURST;
    wire [3:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWCACHE;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWID;
    wire [7:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWLEN;
    wire [2:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWPROT;
    wire [3:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWQOS;
    wire [3:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWREGION;
    wire [2:0]axi_interconnect_0_inst_AXI_M03_interconnect_AWSIZE;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_BID;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_BRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M03_interconnect_RDATA;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_RID;
    wire [1:0]axi_interconnect_0_inst_AXI_M03_interconnect_RRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M03_interconnect_WDATA;
    wire [31:0]axi_interconnect_0_inst_AXI_M03_interconnect_WSTRB;
    
    wire axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HREADYOUT, axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HREADY, 
        axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HRESP, axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HSELx, 
        axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HWRITE, axi_interconnect_0_inst_AXI_M03_interconnect_ARLOCK, 
        axi_interconnect_0_inst_AXI_M03_interconnect_ARREADY, axi_interconnect_0_inst_AXI_M03_interconnect_ARUSER, 
        axi_interconnect_0_inst_AXI_M03_interconnect_ARVALID, axi_interconnect_0_inst_AXI_M03_interconnect_AWLOCK, 
        axi_interconnect_0_inst_AXI_M03_interconnect_AWREADY, axi_interconnect_0_inst_AXI_M03_interconnect_AWUSER, 
        axi_interconnect_0_inst_AXI_M03_interconnect_AWVALID, axi_interconnect_0_inst_AXI_M03_interconnect_BREADY, 
        axi_interconnect_0_inst_AXI_M03_interconnect_BUSER, axi_interconnect_0_inst_AXI_M03_interconnect_BVALID, 
        axi_interconnect_0_inst_AXI_M03_interconnect_RLAST, axi_interconnect_0_inst_AXI_M03_interconnect_RREADY, 
        axi_interconnect_0_inst_AXI_M03_interconnect_RUSER, axi_interconnect_0_inst_AXI_M03_interconnect_RVALID, 
        axi_interconnect_0_inst_AXI_M03_interconnect_WLAST, axi_interconnect_0_inst_AXI_M03_interconnect_WREADY, 
        axi_interconnect_0_inst_AXI_M03_interconnect_WUSER, axi_interconnect_0_inst_AXI_M03_interconnect_WVALID;
    wire [63:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARBURST;
    wire [3:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARCACHE;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARID;
    wire [7:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARLEN;
    wire [2:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARPROT;
    wire [3:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARQOS;
    wire [3:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARREGION;
    wire [2:0]axi_interconnect_0_inst_AXI_M02_interconnect_ARSIZE;
    wire [63:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWBURST;
    wire [3:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWCACHE;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWID;
    wire [7:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWLEN;
    wire [2:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWPROT;
    wire [3:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWQOS;
    wire [3:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWREGION;
    wire [2:0]axi_interconnect_0_inst_AXI_M02_interconnect_AWSIZE;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_BID;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_BRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M02_interconnect_RDATA;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_RID;
    wire [1:0]axi_interconnect_0_inst_AXI_M02_interconnect_RRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M02_interconnect_WDATA;
    wire [31:0]axi_interconnect_0_inst_AXI_M02_interconnect_WSTRB;
    
    wire axi_interconnect_0_inst_AXI_M02_interconnect_ARLOCK, axi_interconnect_0_inst_AXI_M02_interconnect_ARREADY, 
        axi_interconnect_0_inst_AXI_M02_interconnect_ARUSER, axi_interconnect_0_inst_AXI_M02_interconnect_ARVALID, 
        axi_interconnect_0_inst_AXI_M02_interconnect_AWLOCK, axi_interconnect_0_inst_AXI_M02_interconnect_AWREADY, 
        axi_interconnect_0_inst_AXI_M02_interconnect_AWUSER, axi_interconnect_0_inst_AXI_M02_interconnect_AWVALID, 
        axi_interconnect_0_inst_AXI_M02_interconnect_BREADY, axi_interconnect_0_inst_AXI_M02_interconnect_BUSER, 
        axi_interconnect_0_inst_AXI_M02_interconnect_BVALID, axi_interconnect_0_inst_AXI_M02_interconnect_RLAST, 
        axi_interconnect_0_inst_AXI_M02_interconnect_RREADY, axi_interconnect_0_inst_AXI_M02_interconnect_RUSER, 
        axi_interconnect_0_inst_AXI_M02_interconnect_RVALID, axi_interconnect_0_inst_AXI_M02_interconnect_WLAST, 
        axi_interconnect_0_inst_AXI_M02_interconnect_WREADY, axi_interconnect_0_inst_AXI_M02_interconnect_WUSER, 
        axi_interconnect_0_inst_AXI_M02_interconnect_WVALID;
    wire [63:0]axi_interconnect_0_inst_AXI_M00_interconnect_ARADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_ARBURST;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_ARID;
    wire [7:0]axi_interconnect_0_inst_AXI_M00_interconnect_ARLEN;
    wire [3:0]axi_interconnect_0_inst_AXI_M00_interconnect_ARQOS;
    wire [2:0]axi_interconnect_0_inst_AXI_M00_interconnect_ARSIZE;
    wire [63:0]axi_interconnect_0_inst_AXI_M00_interconnect_AWADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_AWBURST;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_AWID;
    wire [7:0]axi_interconnect_0_inst_AXI_M00_interconnect_AWLEN;
    wire [3:0]axi_interconnect_0_inst_AXI_M00_interconnect_AWQOS;
    wire [2:0]axi_interconnect_0_inst_AXI_M00_interconnect_AWSIZE;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_BID;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_BRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M00_interconnect_RDATA;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_RID;
    wire [1:0]axi_interconnect_0_inst_AXI_M00_interconnect_RRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M00_interconnect_WDATA;
    wire [31:0]axi_interconnect_0_inst_AXI_M00_interconnect_WSTRB;
    wire [63:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARBURST;
    wire [3:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARCACHE;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARID;
    wire [7:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARLEN;
    wire [2:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARPROT;
    wire [3:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARQOS;
    wire [3:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARREGION;
    wire [2:0]axi_interconnect_0_inst_AXI_M01_interconnect_ARSIZE;
    wire [63:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWADDR;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWBURST;
    wire [3:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWCACHE;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWID;
    wire [7:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWLEN;
    wire [2:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWPROT;
    wire [3:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWQOS;
    wire [3:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWREGION;
    wire [2:0]axi_interconnect_0_inst_AXI_M01_interconnect_AWSIZE;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_BID;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_BRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M01_interconnect_RDATA;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_RID;
    wire [1:0]axi_interconnect_0_inst_AXI_M01_interconnect_RRESP;
    wire [255:0]axi_interconnect_0_inst_AXI_M01_interconnect_WDATA;
    wire [31:0]axi_interconnect_0_inst_AXI_M01_interconnect_WSTRB;
    wire [31:0]cpu_inst_AXI_M_INSTR_interconnect_ARADDR;
    wire [1:0]cpu_inst_AXI_M_INSTR_interconnect_ARBURST;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_ARCACHE;
    wire [7:0]cpu_inst_AXI_M_INSTR_interconnect_ARLEN;
    wire [2:0]cpu_inst_AXI_M_INSTR_interconnect_ARPROT;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_ARQOS;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_ARREGION;
    wire [2:0]cpu_inst_AXI_M_INSTR_interconnect_ARSIZE;
    wire [31:0]cpu_inst_AXI_M_INSTR_interconnect_AWADDR;
    wire [1:0]cpu_inst_AXI_M_INSTR_interconnect_AWBURST;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_AWCACHE;
    wire [7:0]cpu_inst_AXI_M_INSTR_interconnect_AWLEN;
    wire [2:0]cpu_inst_AXI_M_INSTR_interconnect_AWPROT;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_AWQOS;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_AWREGION;
    wire [2:0]cpu_inst_AXI_M_INSTR_interconnect_AWSIZE;
    wire [1:0]cpu_inst_AXI_M_INSTR_interconnect_BRESP;
    wire [31:0]cpu_inst_AXI_M_INSTR_interconnect_RDATA;
    wire [1:0]cpu_inst_AXI_M_INSTR_interconnect_RRESP;
    wire [31:0]cpu_inst_AXI_M_INSTR_interconnect_WDATA;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_WSTRB;
    wire [31:0]cpu_inst_AXI_M_DATA_interconnect_ARADDR;
    wire [1:0]cpu_inst_AXI_M_DATA_interconnect_ARBURST;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_ARCACHE;
    wire [7:0]cpu_inst_AXI_M_DATA_interconnect_ARLEN;
    wire [2:0]cpu_inst_AXI_M_DATA_interconnect_ARPROT;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_ARQOS;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_ARREGION;
    wire [2:0]cpu_inst_AXI_M_DATA_interconnect_ARSIZE;
    wire [31:0]cpu_inst_AXI_M_DATA_interconnect_AWADDR;
    wire [1:0]cpu_inst_AXI_M_DATA_interconnect_AWBURST;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_AWCACHE;
    wire [7:0]cpu_inst_AXI_M_DATA_interconnect_AWLEN;
    wire [2:0]cpu_inst_AXI_M_DATA_interconnect_AWPROT;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_AWQOS;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_AWREGION;
    wire [2:0]cpu_inst_AXI_M_DATA_interconnect_AWSIZE;
    wire [1:0]cpu_inst_AXI_M_DATA_interconnect_BRESP;
    wire [31:0]cpu_inst_AXI_M_DATA_interconnect_RDATA;
    wire [1:0]cpu_inst_AXI_M_DATA_interconnect_RRESP;
    wire [31:0]cpu_inst_AXI_M_DATA_interconnect_WDATA;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_WSTRB;
    
    wire axi_interconnect_0_inst_AXI_M00_interconnect_ARREADY, axi_interconnect_0_inst_AXI_M00_interconnect_ARVALID, 
        axi_interconnect_0_inst_AXI_M00_interconnect_AWREADY, axi_interconnect_0_inst_AXI_M00_interconnect_AWVALID, 
        axi_interconnect_0_inst_AXI_M00_interconnect_BREADY, axi_interconnect_0_inst_AXI_M00_interconnect_BVALID, 
        axi_interconnect_0_inst_AXI_M00_interconnect_RLAST, axi_interconnect_0_inst_AXI_M00_interconnect_RREADY, 
        axi_interconnect_0_inst_AXI_M00_interconnect_RVALID, axi_interconnect_0_inst_AXI_M00_interconnect_WLAST, 
        axi_interconnect_0_inst_AXI_M00_interconnect_WREADY, axi_interconnect_0_inst_AXI_M00_interconnect_WVALID, 
        axi_interconnect_0_inst_AXI_M01_interconnect_ARLOCK, axi_interconnect_0_inst_AXI_M01_interconnect_ARREADY, 
        axi_interconnect_0_inst_AXI_M01_interconnect_ARVALID, axi_interconnect_0_inst_AXI_M01_interconnect_AWLOCK, 
        axi_interconnect_0_inst_AXI_M01_interconnect_AWREADY, axi_interconnect_0_inst_AXI_M01_interconnect_AWVALID, 
        axi_interconnect_0_inst_AXI_M01_interconnect_BREADY, axi_interconnect_0_inst_AXI_M01_interconnect_BVALID, 
        axi_interconnect_0_inst_AXI_M01_interconnect_RLAST, axi_interconnect_0_inst_AXI_M01_interconnect_RREADY, 
        axi_interconnect_0_inst_AXI_M01_interconnect_RVALID, axi_interconnect_0_inst_AXI_M01_interconnect_WLAST, 
        axi_interconnect_0_inst_AXI_M01_interconnect_WREADY, axi_interconnect_0_inst_AXI_M01_interconnect_WVALID;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_ARID;
    
    wire cpu_inst_AXI_M_INSTR_interconnect_ARLOCK, cpu_inst_AXI_M_INSTR_interconnect_ARREADY, 
        cpu_inst_AXI_M_INSTR_interconnect_ARVALID;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_AWID;
    
    wire cpu_inst_AXI_M_INSTR_interconnect_AWLOCK, cpu_inst_AXI_M_INSTR_interconnect_AWREADY, 
        cpu_inst_AXI_M_INSTR_interconnect_AWVALID;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_BID;
    
    wire cpu_inst_AXI_M_INSTR_interconnect_BREADY, cpu_inst_AXI_M_INSTR_interconnect_BVALID;
    wire [3:0]cpu_inst_AXI_M_INSTR_interconnect_RID;
    
    wire cpu_inst_AXI_M_INSTR_interconnect_RLAST, cpu_inst_AXI_M_INSTR_interconnect_RREADY, 
        cpu_inst_AXI_M_INSTR_interconnect_RVALID, cpu_inst_AXI_M_INSTR_interconnect_WLAST, 
        cpu_inst_AXI_M_INSTR_interconnect_WREADY, cpu_inst_AXI_M_INSTR_interconnect_WVALID;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_ARID;
    
    wire cpu_inst_AXI_M_DATA_interconnect_ARLOCK, cpu_inst_AXI_M_DATA_interconnect_ARREADY, 
        cpu_inst_AXI_M_DATA_interconnect_ARVALID;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_AWID;
    
    wire cpu_inst_AXI_M_DATA_interconnect_AWLOCK, cpu_inst_AXI_M_DATA_interconnect_AWREADY, 
        cpu_inst_AXI_M_DATA_interconnect_AWVALID;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_BID;
    
    wire cpu_inst_AXI_M_DATA_interconnect_BREADY, cpu_inst_AXI_M_DATA_interconnect_BVALID;
    wire [3:0]cpu_inst_AXI_M_DATA_interconnect_RID;
    
    wire cpu_inst_AXI_M_DATA_interconnect_RLAST, cpu_inst_AXI_M_DATA_interconnect_RREADY, 
        cpu_inst_AXI_M_DATA_interconnect_RVALID, cpu_inst_AXI_M_DATA_interconnect_WLAST, 
        cpu_inst_AXI_M_DATA_interconnect_WREADY, cpu_inst_AXI_M_DATA_interconnect_WVALID, 
        osc0_inst_lf_clk_out_o_net, gpio0_inst_INTR_interconnect_IRQ, equation_module_inst_O_net, 
        osc0_inst_hf_clk_out_o_net, pll0_inst_lock_o_net, invert_O_net;
    
    
    assign equation_module_inst_O_net = (pll0_inst_lock_o_net & rstn_i) ; 

    assign invert_O_net = !cpu_inst_system_resetn_o_net;
    apb_interconnect0 apb_interconnect0_inst (.apb_m00_paddr_mstr_o({apb_interconnect0_inst_APB_M00_interconnect_PADDR}), 
            .apb_m00_prdata_mstr_i({apb_interconnect0_inst_APB_M00_interconnect_PRDATA}), 
            .apb_m00_pwdata_mstr_o({apb_interconnect0_inst_APB_M00_interconnect_PWDATA}), 
            .apb_m01_paddr_mstr_o({apb_interconnect0_inst_APB_M01_interconnect_PADDR}), 
            .apb_m01_prdata_mstr_i({apb_interconnect0_inst_APB_M01_interconnect_PRDATA}), 
            .apb_m01_pwdata_mstr_o({apb_interconnect0_inst_APB_M01_interconnect_PWDATA}), 
            .apb_m02_paddr_mstr_o({apb_interconnect0_inst_APB_M02_interconnect_PADDR}), 
            .apb_m02_prdata_mstr_i({apb_interconnect0_inst_APB_M02_interconnect_PRDATA}), 
            .apb_m02_pwdata_mstr_o({apb_interconnect0_inst_APB_M02_interconnect_PWDATA}), 
            .apb_s00_paddr_slv_i({axi2apb0_inst_APB3_M_interconnect_PADDR}), 
            .apb_s00_prdata_slv_o({axi2apb0_inst_APB3_M_interconnect_PRDATA}), 
            .apb_s00_pwdata_slv_i({axi2apb0_inst_APB3_M_interconnect_PWDATA}), 
            .apb_m00_penable_mstr_o(apb_interconnect0_inst_APB_M00_interconnect_PENABLE), 
            .apb_m00_pready_mstr_i(apb_interconnect0_inst_APB_M00_interconnect_PREADY), 
            .apb_m00_psel_mstr_o(apb_interconnect0_inst_APB_M00_interconnect_PSELx), 
            .apb_m00_pslverr_mstr_i(apb_interconnect0_inst_APB_M00_interconnect_PSLVERR), 
            .apb_m00_pwrite_mstr_o(apb_interconnect0_inst_APB_M00_interconnect_PWRITE), 
            .apb_m01_penable_mstr_o(apb_interconnect0_inst_APB_M01_interconnect_PENABLE), 
            .apb_m01_pready_mstr_i(apb_interconnect0_inst_APB_M01_interconnect_PREADY), 
            .apb_m01_psel_mstr_o(apb_interconnect0_inst_APB_M01_interconnect_PSELx), 
            .apb_m01_pslverr_mstr_i(apb_interconnect0_inst_APB_M01_interconnect_PSLVERR), 
            .apb_m01_pwrite_mstr_o(apb_interconnect0_inst_APB_M01_interconnect_PWRITE), 
            .apb_m02_penable_mstr_o(apb_interconnect0_inst_APB_M02_interconnect_PENABLE), 
            .apb_m02_pready_mstr_i(apb_interconnect0_inst_APB_M02_interconnect_PREADY), 
            .apb_m02_psel_mstr_o(apb_interconnect0_inst_APB_M02_interconnect_PSELx), 
            .apb_m02_pslverr_mstr_i(apb_interconnect0_inst_APB_M02_interconnect_PSLVERR), 
            .apb_m02_pwrite_mstr_o(apb_interconnect0_inst_APB_M02_interconnect_PWRITE), 
            .apb_pclk_i(pll0_inst_clkop_o_net), .apb_presetn_i(cpu_inst_system_resetn_o_net), 
            .apb_s00_penable_slv_i(axi2apb0_inst_APB3_M_interconnect_PENABLE), 
            .apb_s00_pready_slv_o(axi2apb0_inst_APB3_M_interconnect_PREADY), 
            .apb_s00_psel_slv_i(axi2apb0_inst_APB3_M_interconnect_PSELx), 
            .apb_s00_pslverr_slv_o(axi2apb0_inst_APB3_M_interconnect_PSLVERR), 
            .apb_s00_pwrite_slv_i(axi2apb0_inst_APB3_M_interconnect_PWRITE));
    defparam apb_interconnect0_inst.FULL_DECODE_EN = 1;
    defparam apb_interconnect0_inst.S0_ADDR_RANGE = 32'h00001000;
    defparam apb_interconnect0_inst.S0_BASE_ADDR = 32'h49008000;
    defparam apb_interconnect0_inst.S1_ADDR_RANGE = 32'h00001000;
    defparam apb_interconnect0_inst.S1_BASE_ADDR = 32'h40009000;
    defparam apb_interconnect0_inst.S2_ADDR_RANGE = 32'h00001000;
    defparam apb_interconnect0_inst.S2_BASE_ADDR = 32'h4800A000;
    axi2ahbl_spi_flash axi2ahbl_spi_flash_inst (.ahb_mas_addr_o({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HADDR}), 
            .ahb_mas_burst_o({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HBURST}), 
            .ahb_mas_rdata_i({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HRDATA}), 
            .ahb_mas_size_o({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HSIZE}), 
            .ahb_mas_trans_o({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HTRANS}), 
            .ahb_mas_wdata_o({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HWDATA}), 
            .axi_slv_araddr_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARADDR[31:0]}), 
            .axi_slv_arburst_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARBURST}), 
            .axi_slv_arcache_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARCACHE}), 
            .axi_slv_arid_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARID}), 
            .axi_slv_arlen_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARLEN}), 
            .axi_slv_arprot_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARPROT}), 
            .axi_slv_arqos_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARQOS}), 
            .axi_slv_arregion_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARREGION}), 
            .axi_slv_arsize_i({axi_interconnect_0_inst_AXI_M03_interconnect_ARSIZE}), 
            .axi_slv_awaddr_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWADDR[31:0]}), 
            .axi_slv_awburst_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWBURST}), 
            .axi_slv_awcache_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWCACHE}), 
            .axi_slv_awid_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWID}), 
            .axi_slv_awlen_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWLEN}), 
            .axi_slv_awprot_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWPROT}), 
            .axi_slv_awqos_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWQOS}), 
            .axi_slv_awregion_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWREGION}), 
            .axi_slv_awsize_i({axi_interconnect_0_inst_AXI_M03_interconnect_AWSIZE}), 
            .axi_slv_bid_o({axi_interconnect_0_inst_AXI_M03_interconnect_BID}), 
            .axi_slv_bresp_o({axi_interconnect_0_inst_AXI_M03_interconnect_BRESP}), 
            .axi_slv_rdata_o({axi_interconnect_0_inst_AXI_M03_interconnect_RDATA[31:0]}), 
            .axi_slv_rid_o({axi_interconnect_0_inst_AXI_M03_interconnect_RID}), 
            .axi_slv_rresp_o({axi_interconnect_0_inst_AXI_M03_interconnect_RRESP}), 
            .axi_slv_wdata_i({axi_interconnect_0_inst_AXI_M03_interconnect_WDATA[31:0]}), 
            .axi_slv_wstrb_i({axi_interconnect_0_inst_AXI_M03_interconnect_WSTRB[3:0]}), 
            .aclk_i(pll0_inst_clkop_o_net), .ahb_mas_ready_i(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HREADYOUT), 
            .ahb_mas_ready_o(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HREADY), 
            .ahb_mas_resp_i(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HRESP), 
            .ahb_mas_sel_o(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HSELx), 
            .ahb_mas_write_o(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HWRITE), 
            .aresetn_i(cpu_inst_system_resetn_o_net), .axi_slv_arlock_i(axi_interconnect_0_inst_AXI_M03_interconnect_ARLOCK), 
            .axi_slv_arready_o(axi_interconnect_0_inst_AXI_M03_interconnect_ARREADY), 
            .axi_slv_aruser_i(axi_interconnect_0_inst_AXI_M03_interconnect_ARUSER), 
            .axi_slv_arvalid_i(axi_interconnect_0_inst_AXI_M03_interconnect_ARVALID), 
            .axi_slv_awlock_i(axi_interconnect_0_inst_AXI_M03_interconnect_AWLOCK), 
            .axi_slv_awready_o(axi_interconnect_0_inst_AXI_M03_interconnect_AWREADY), 
            .axi_slv_awuser_i(axi_interconnect_0_inst_AXI_M03_interconnect_AWUSER), 
            .axi_slv_awvalid_i(axi_interconnect_0_inst_AXI_M03_interconnect_AWVALID), 
            .axi_slv_bready_i(axi_interconnect_0_inst_AXI_M03_interconnect_BREADY), 
            .axi_slv_buser_o(axi_interconnect_0_inst_AXI_M03_interconnect_BUSER), 
            .axi_slv_bvalid_o(axi_interconnect_0_inst_AXI_M03_interconnect_BVALID), 
            .axi_slv_rlast_o(axi_interconnect_0_inst_AXI_M03_interconnect_RLAST), 
            .axi_slv_rready_i(axi_interconnect_0_inst_AXI_M03_interconnect_RREADY), 
            .axi_slv_ruser_o(axi_interconnect_0_inst_AXI_M03_interconnect_RUSER), 
            .axi_slv_rvalid_o(axi_interconnect_0_inst_AXI_M03_interconnect_RVALID), 
            .axi_slv_wlast_i(axi_interconnect_0_inst_AXI_M03_interconnect_WLAST), 
            .axi_slv_wready_o(axi_interconnect_0_inst_AXI_M03_interconnect_WREADY), 
            .axi_slv_wuser_i(axi_interconnect_0_inst_AXI_M03_interconnect_WUSER), 
            .axi_slv_wvalid_i(axi_interconnect_0_inst_AXI_M03_interconnect_WVALID));
    axi2apb0 axi2apb0_inst (.apb_mas_addr_o({axi2apb0_inst_APB3_M_interconnect_PADDR}), 
            .apb_mas_rdata_i({axi2apb0_inst_APB3_M_interconnect_PRDATA}), 
            .apb_mas_wdata_o({axi2apb0_inst_APB3_M_interconnect_PWDATA}), 
            .axi_slv_araddr_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARADDR[31:0]}), 
            .axi_slv_arburst_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARBURST}), 
            .axi_slv_arcache_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARCACHE}), 
            .axi_slv_arid_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARID}), 
            .axi_slv_arlen_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARLEN}), 
            .axi_slv_arprot_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARPROT}), 
            .axi_slv_arqos_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARQOS}), 
            .axi_slv_arregion_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARREGION}), 
            .axi_slv_arsize_i({axi_interconnect_0_inst_AXI_M02_interconnect_ARSIZE}), 
            .axi_slv_awaddr_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWADDR[31:0]}), 
            .axi_slv_awburst_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWBURST}), 
            .axi_slv_awcache_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWCACHE}), 
            .axi_slv_awid_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWID}), 
            .axi_slv_awlen_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWLEN}), 
            .axi_slv_awprot_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWPROT}), 
            .axi_slv_awqos_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWQOS}), 
            .axi_slv_awregion_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWREGION}), 
            .axi_slv_awsize_i({axi_interconnect_0_inst_AXI_M02_interconnect_AWSIZE}), 
            .axi_slv_bid_o({axi_interconnect_0_inst_AXI_M02_interconnect_BID}), 
            .axi_slv_bresp_o({axi_interconnect_0_inst_AXI_M02_interconnect_BRESP}), 
            .axi_slv_rdata_o({axi_interconnect_0_inst_AXI_M02_interconnect_RDATA[31:0]}), 
            .axi_slv_rid_o({axi_interconnect_0_inst_AXI_M02_interconnect_RID}), 
            .axi_slv_rresp_o({axi_interconnect_0_inst_AXI_M02_interconnect_RRESP}), 
            .axi_slv_wdata_i({axi_interconnect_0_inst_AXI_M02_interconnect_WDATA[31:0]}), 
            .axi_slv_wstrb_i({axi_interconnect_0_inst_AXI_M02_interconnect_WSTRB[3:0]}), 
            .aclk_i(pll0_inst_clkop_o_net), .apb_mas_en_o(axi2apb0_inst_APB3_M_interconnect_PENABLE), 
            .apb_mas_ready_i(axi2apb0_inst_APB3_M_interconnect_PREADY), .apb_mas_sel_o(axi2apb0_inst_APB3_M_interconnect_PSELx), 
            .apb_mas_slverr_i(axi2apb0_inst_APB3_M_interconnect_PSLVERR), 
            .apb_mas_write_o(axi2apb0_inst_APB3_M_interconnect_PWRITE), .aresetn_i(cpu_inst_system_resetn_o_net), 
            .axi_slv_arlock_i(axi_interconnect_0_inst_AXI_M02_interconnect_ARLOCK), 
            .axi_slv_arready_o(axi_interconnect_0_inst_AXI_M02_interconnect_ARREADY), 
            .axi_slv_aruser_i(axi_interconnect_0_inst_AXI_M02_interconnect_ARUSER), 
            .axi_slv_arvalid_i(axi_interconnect_0_inst_AXI_M02_interconnect_ARVALID), 
            .axi_slv_awlock_i(axi_interconnect_0_inst_AXI_M02_interconnect_AWLOCK), 
            .axi_slv_awready_o(axi_interconnect_0_inst_AXI_M02_interconnect_AWREADY), 
            .axi_slv_awuser_i(axi_interconnect_0_inst_AXI_M02_interconnect_AWUSER), 
            .axi_slv_awvalid_i(axi_interconnect_0_inst_AXI_M02_interconnect_AWVALID), 
            .axi_slv_bready_i(axi_interconnect_0_inst_AXI_M02_interconnect_BREADY), 
            .axi_slv_buser_o(axi_interconnect_0_inst_AXI_M02_interconnect_BUSER), 
            .axi_slv_bvalid_o(axi_interconnect_0_inst_AXI_M02_interconnect_BVALID), 
            .axi_slv_rlast_o(axi_interconnect_0_inst_AXI_M02_interconnect_RLAST), 
            .axi_slv_rready_i(axi_interconnect_0_inst_AXI_M02_interconnect_RREADY), 
            .axi_slv_ruser_o(axi_interconnect_0_inst_AXI_M02_interconnect_RUSER), 
            .axi_slv_rvalid_o(axi_interconnect_0_inst_AXI_M02_interconnect_RVALID), 
            .axi_slv_wlast_i(axi_interconnect_0_inst_AXI_M02_interconnect_WLAST), 
            .axi_slv_wready_o(axi_interconnect_0_inst_AXI_M02_interconnect_WREADY), 
            .axi_slv_wuser_i(axi_interconnect_0_inst_AXI_M02_interconnect_WUSER), 
            .axi_slv_wvalid_i(axi_interconnect_0_inst_AXI_M02_interconnect_WVALID));
    axi_interconnect_0 axi_interconnect_0_inst (.axi_M00_araddr_o({axi_interconnect_0_inst_AXI_M00_interconnect_ARADDR}), 
            .axi_M00_arburst_o({axi_interconnect_0_inst_AXI_M00_interconnect_ARBURST}), 
            .axi_M00_arid_o({axi_interconnect_0_inst_AXI_M00_interconnect_ARID}), 
            .axi_M00_arlen_o({axi_interconnect_0_inst_AXI_M00_interconnect_ARLEN}), 
            .axi_M00_arqos_o({axi_interconnect_0_inst_AXI_M00_interconnect_ARQOS}), 
            .axi_M00_arsize_o({axi_interconnect_0_inst_AXI_M00_interconnect_ARSIZE}), 
            .axi_M00_awaddr_o({axi_interconnect_0_inst_AXI_M00_interconnect_AWADDR}), 
            .axi_M00_awburst_o({axi_interconnect_0_inst_AXI_M00_interconnect_AWBURST}), 
            .axi_M00_awid_o({axi_interconnect_0_inst_AXI_M00_interconnect_AWID}), 
            .axi_M00_awlen_o({axi_interconnect_0_inst_AXI_M00_interconnect_AWLEN}), 
            .axi_M00_awqos_o({axi_interconnect_0_inst_AXI_M00_interconnect_AWQOS}), 
            .axi_M00_awsize_o({axi_interconnect_0_inst_AXI_M00_interconnect_AWSIZE}), 
            .axi_M00_bid_i({axi_interconnect_0_inst_AXI_M00_interconnect_BID}), 
            .axi_M00_bresp_i({axi_interconnect_0_inst_AXI_M00_interconnect_BRESP}), 
            .axi_M00_rdata_i({axi_interconnect_0_inst_AXI_M00_interconnect_RDATA}), 
            .axi_M00_rid_i({axi_interconnect_0_inst_AXI_M00_interconnect_RID}), 
            .axi_M00_rresp_i({axi_interconnect_0_inst_AXI_M00_interconnect_RRESP}), 
            .axi_M00_wdata_o({axi_interconnect_0_inst_AXI_M00_interconnect_WDATA}), 
            .axi_M00_wstrb_o({axi_interconnect_0_inst_AXI_M00_interconnect_WSTRB}), 
            .axi_M01_araddr_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARADDR}), 
            .axi_M01_arburst_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARBURST}), 
            .axi_M01_arcache_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARCACHE}), 
            .axi_M01_arid_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARID}), 
            .axi_M01_arlen_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARLEN}), 
            .axi_M01_arprot_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARPROT}), 
            .axi_M01_arqos_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARQOS}), 
            .axi_M01_arregion_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARREGION}), 
            .axi_M01_arsize_o({axi_interconnect_0_inst_AXI_M01_interconnect_ARSIZE}), 
            .axi_M01_awaddr_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWADDR}), 
            .axi_M01_awburst_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWBURST}), 
            .axi_M01_awcache_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWCACHE}), 
            .axi_M01_awid_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWID}), 
            .axi_M01_awlen_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWLEN}), 
            .axi_M01_awprot_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWPROT}), 
            .axi_M01_awqos_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWQOS}), 
            .axi_M01_awregion_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWREGION}), 
            .axi_M01_awsize_o({axi_interconnect_0_inst_AXI_M01_interconnect_AWSIZE}), 
            .axi_M01_bid_i({axi_interconnect_0_inst_AXI_M01_interconnect_BID}), 
            .axi_M01_bresp_i({axi_interconnect_0_inst_AXI_M01_interconnect_BRESP}), 
            .axi_M01_rdata_i({axi_interconnect_0_inst_AXI_M01_interconnect_RDATA}), 
            .axi_M01_rid_i({axi_interconnect_0_inst_AXI_M01_interconnect_RID}), 
            .axi_M01_rresp_i({axi_interconnect_0_inst_AXI_M01_interconnect_RRESP}), 
            .axi_M01_wdata_o({axi_interconnect_0_inst_AXI_M01_interconnect_WDATA}), 
            .axi_M01_wstrb_o({axi_interconnect_0_inst_AXI_M01_interconnect_WSTRB}), 
            .axi_M02_araddr_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARADDR}), 
            .axi_M02_arburst_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARBURST}), 
            .axi_M02_arcache_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARCACHE}), 
            .axi_M02_arid_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARID}), 
            .axi_M02_arlen_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARLEN}), 
            .axi_M02_arprot_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARPROT}), 
            .axi_M02_arqos_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARQOS}), 
            .axi_M02_arregion_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARREGION}), 
            .axi_M02_arsize_o({axi_interconnect_0_inst_AXI_M02_interconnect_ARSIZE}), 
            .axi_M02_awaddr_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWADDR}), 
            .axi_M02_awburst_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWBURST}), 
            .axi_M02_awcache_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWCACHE}), 
            .axi_M02_awid_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWID}), 
            .axi_M02_awlen_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWLEN}), 
            .axi_M02_awprot_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWPROT}), 
            .axi_M02_awqos_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWQOS}), 
            .axi_M02_awregion_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWREGION}), 
            .axi_M02_awsize_o({axi_interconnect_0_inst_AXI_M02_interconnect_AWSIZE}), 
            .axi_M02_bid_i({axi_interconnect_0_inst_AXI_M02_interconnect_BID}), 
            .axi_M02_bresp_i({axi_interconnect_0_inst_AXI_M02_interconnect_BRESP}), 
            .axi_M02_rdata_i({axi_interconnect_0_inst_AXI_M02_interconnect_RDATA}), 
            .axi_M02_rid_i({axi_interconnect_0_inst_AXI_M02_interconnect_RID}), 
            .axi_M02_rresp_i({axi_interconnect_0_inst_AXI_M02_interconnect_RRESP}), 
            .axi_M02_wdata_o({axi_interconnect_0_inst_AXI_M02_interconnect_WDATA}), 
            .axi_M02_wstrb_o({axi_interconnect_0_inst_AXI_M02_interconnect_WSTRB}), 
            .axi_M03_araddr_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARADDR}), 
            .axi_M03_arburst_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARBURST}), 
            .axi_M03_arcache_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARCACHE}), 
            .axi_M03_arid_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARID}), 
            .axi_M03_arlen_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARLEN}), 
            .axi_M03_arprot_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARPROT}), 
            .axi_M03_arqos_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARQOS}), 
            .axi_M03_arregion_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARREGION}), 
            .axi_M03_arsize_o({axi_interconnect_0_inst_AXI_M03_interconnect_ARSIZE}), 
            .axi_M03_awaddr_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWADDR}), 
            .axi_M03_awburst_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWBURST}), 
            .axi_M03_awcache_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWCACHE}), 
            .axi_M03_awid_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWID}), 
            .axi_M03_awlen_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWLEN}), 
            .axi_M03_awprot_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWPROT}), 
            .axi_M03_awqos_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWQOS}), 
            .axi_M03_awregion_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWREGION}), 
            .axi_M03_awsize_o({axi_interconnect_0_inst_AXI_M03_interconnect_AWSIZE}), 
            .axi_M03_bid_i({axi_interconnect_0_inst_AXI_M03_interconnect_BID}), 
            .axi_M03_bresp_i({axi_interconnect_0_inst_AXI_M03_interconnect_BRESP}), 
            .axi_M03_rdata_i({axi_interconnect_0_inst_AXI_M03_interconnect_RDATA}), 
            .axi_M03_rid_i({axi_interconnect_0_inst_AXI_M03_interconnect_RID}), 
            .axi_M03_rresp_i({axi_interconnect_0_inst_AXI_M03_interconnect_RRESP}), 
            .axi_M03_wdata_o({axi_interconnect_0_inst_AXI_M03_interconnect_WDATA}), 
            .axi_M03_wstrb_o({axi_interconnect_0_inst_AXI_M03_interconnect_WSTRB}), 
            .axi_S00_araddr_i({32'b00000000000000000000000000000000, cpu_inst_AXI_M_INSTR_interconnect_ARADDR}), 
            .axi_S00_arburst_i({cpu_inst_AXI_M_INSTR_interconnect_ARBURST}), 
            .axi_S00_arcache_i({cpu_inst_AXI_M_INSTR_interconnect_ARCACHE}), 
            .axi_S00_arlen_i({cpu_inst_AXI_M_INSTR_interconnect_ARLEN}), .axi_S00_arprot_i({cpu_inst_AXI_M_INSTR_interconnect_ARPROT}), 
            .axi_S00_arqos_i({cpu_inst_AXI_M_INSTR_interconnect_ARQOS}), .axi_S00_arregion_i({cpu_inst_AXI_M_INSTR_interconnect_ARREGION}), 
            .axi_S00_arsize_i({cpu_inst_AXI_M_INSTR_interconnect_ARSIZE}), 
            .axi_S00_awaddr_i({32'b00000000000000000000000000000000, cpu_inst_AXI_M_INSTR_interconnect_AWADDR}), 
            .axi_S00_awburst_i({cpu_inst_AXI_M_INSTR_interconnect_AWBURST}), 
            .axi_S00_awcache_i({cpu_inst_AXI_M_INSTR_interconnect_AWCACHE}), 
            .axi_S00_awlen_i({cpu_inst_AXI_M_INSTR_interconnect_AWLEN}), .axi_S00_awprot_i({cpu_inst_AXI_M_INSTR_interconnect_AWPROT}), 
            .axi_S00_awqos_i({cpu_inst_AXI_M_INSTR_interconnect_AWQOS}), .axi_S00_awregion_i({cpu_inst_AXI_M_INSTR_interconnect_AWREGION}), 
            .axi_S00_awsize_i({cpu_inst_AXI_M_INSTR_interconnect_AWSIZE}), 
            .axi_S00_bresp_o({cpu_inst_AXI_M_INSTR_interconnect_BRESP}), .axi_S00_rdata_o({cpu_inst_AXI_M_INSTR_interconnect_RDATA}), 
            .axi_S00_rresp_o({cpu_inst_AXI_M_INSTR_interconnect_RRESP}), .axi_S00_wdata_i({cpu_inst_AXI_M_INSTR_interconnect_WDATA}), 
            .axi_S00_wstrb_i({cpu_inst_AXI_M_INSTR_interconnect_WSTRB}), .axi_S01_araddr_i({32'b00000000000000000000000000000000, 
            cpu_inst_AXI_M_DATA_interconnect_ARADDR}), .axi_S01_arburst_i({cpu_inst_AXI_M_DATA_interconnect_ARBURST}), 
            .axi_S01_arcache_i({cpu_inst_AXI_M_DATA_interconnect_ARCACHE}), 
            .axi_S01_arlen_i({cpu_inst_AXI_M_DATA_interconnect_ARLEN}), .axi_S01_arprot_i({cpu_inst_AXI_M_DATA_interconnect_ARPROT}), 
            .axi_S01_arqos_i({cpu_inst_AXI_M_DATA_interconnect_ARQOS}), .axi_S01_arregion_i({cpu_inst_AXI_M_DATA_interconnect_ARREGION}), 
            .axi_S01_arsize_i({cpu_inst_AXI_M_DATA_interconnect_ARSIZE}), 
            .axi_S01_awaddr_i({32'b00000000000000000000000000000000, cpu_inst_AXI_M_DATA_interconnect_AWADDR}), 
            .axi_S01_awburst_i({cpu_inst_AXI_M_DATA_interconnect_AWBURST}), 
            .axi_S01_awcache_i({cpu_inst_AXI_M_DATA_interconnect_AWCACHE}), 
            .axi_S01_awlen_i({cpu_inst_AXI_M_DATA_interconnect_AWLEN}), .axi_S01_awprot_i({cpu_inst_AXI_M_DATA_interconnect_AWPROT}), 
            .axi_S01_awqos_i({cpu_inst_AXI_M_DATA_interconnect_AWQOS}), .axi_S01_awregion_i({cpu_inst_AXI_M_DATA_interconnect_AWREGION}), 
            .axi_S01_awsize_i({cpu_inst_AXI_M_DATA_interconnect_AWSIZE}), 
            .axi_S01_bresp_o({cpu_inst_AXI_M_DATA_interconnect_BRESP}), .axi_S01_rdata_o({cpu_inst_AXI_M_DATA_interconnect_RDATA}), 
            .axi_S01_rresp_o({cpu_inst_AXI_M_DATA_interconnect_RRESP}), .axi_S01_wdata_i({cpu_inst_AXI_M_DATA_interconnect_WDATA}), 
            .axi_S01_wstrb_i({cpu_inst_AXI_M_DATA_interconnect_WSTRB}), .axi_M00_arready_i(axi_interconnect_0_inst_AXI_M00_interconnect_ARREADY), 
            .axi_M00_arvalid_o(axi_interconnect_0_inst_AXI_M00_interconnect_ARVALID), 
            .axi_M00_awready_i(axi_interconnect_0_inst_AXI_M00_interconnect_AWREADY), 
            .axi_M00_awvalid_o(axi_interconnect_0_inst_AXI_M00_interconnect_AWVALID), 
            .axi_M00_bready_o(axi_interconnect_0_inst_AXI_M00_interconnect_BREADY), 
            .axi_M00_buser_i(1'b0), .axi_M00_bvalid_i(axi_interconnect_0_inst_AXI_M00_interconnect_BVALID), 
            .axi_M00_rlast_i(axi_interconnect_0_inst_AXI_M00_interconnect_RLAST), 
            .axi_M00_rready_o(axi_interconnect_0_inst_AXI_M00_interconnect_RREADY), 
            .axi_M00_ruser_i(1'b0), .axi_M00_rvalid_i(axi_interconnect_0_inst_AXI_M00_interconnect_RVALID), 
            .axi_M00_wlast_o(axi_interconnect_0_inst_AXI_M00_interconnect_WLAST), 
            .axi_M00_wready_i(axi_interconnect_0_inst_AXI_M00_interconnect_WREADY), 
            .axi_M00_wvalid_o(axi_interconnect_0_inst_AXI_M00_interconnect_WVALID), 
            .axi_M01_arlock_o(axi_interconnect_0_inst_AXI_M01_interconnect_ARLOCK), 
            .axi_M01_arready_i(axi_interconnect_0_inst_AXI_M01_interconnect_ARREADY), 
            .axi_M01_arvalid_o(axi_interconnect_0_inst_AXI_M01_interconnect_ARVALID), 
            .axi_M01_awlock_o(axi_interconnect_0_inst_AXI_M01_interconnect_AWLOCK), 
            .axi_M01_awready_i(axi_interconnect_0_inst_AXI_M01_interconnect_AWREADY), 
            .axi_M01_awvalid_o(axi_interconnect_0_inst_AXI_M01_interconnect_AWVALID), 
            .axi_M01_bready_o(axi_interconnect_0_inst_AXI_M01_interconnect_BREADY), 
            .axi_M01_buser_i(1'b0), .axi_M01_bvalid_i(axi_interconnect_0_inst_AXI_M01_interconnect_BVALID), 
            .axi_M01_rlast_i(axi_interconnect_0_inst_AXI_M01_interconnect_RLAST), 
            .axi_M01_rready_o(axi_interconnect_0_inst_AXI_M01_interconnect_RREADY), 
            .axi_M01_ruser_i(1'b0), .axi_M01_rvalid_i(axi_interconnect_0_inst_AXI_M01_interconnect_RVALID), 
            .axi_M01_wlast_o(axi_interconnect_0_inst_AXI_M01_interconnect_WLAST), 
            .axi_M01_wready_i(axi_interconnect_0_inst_AXI_M01_interconnect_WREADY), 
            .axi_M01_wvalid_o(axi_interconnect_0_inst_AXI_M01_interconnect_WVALID), 
            .axi_M02_arlock_o(axi_interconnect_0_inst_AXI_M02_interconnect_ARLOCK), 
            .axi_M02_arready_i(axi_interconnect_0_inst_AXI_M02_interconnect_ARREADY), 
            .axi_M02_aruser_o(axi_interconnect_0_inst_AXI_M02_interconnect_ARUSER), 
            .axi_M02_arvalid_o(axi_interconnect_0_inst_AXI_M02_interconnect_ARVALID), 
            .axi_M02_awlock_o(axi_interconnect_0_inst_AXI_M02_interconnect_AWLOCK), 
            .axi_M02_awready_i(axi_interconnect_0_inst_AXI_M02_interconnect_AWREADY), 
            .axi_M02_awuser_o(axi_interconnect_0_inst_AXI_M02_interconnect_AWUSER), 
            .axi_M02_awvalid_o(axi_interconnect_0_inst_AXI_M02_interconnect_AWVALID), 
            .axi_M02_bready_o(axi_interconnect_0_inst_AXI_M02_interconnect_BREADY), 
            .axi_M02_buser_i(axi_interconnect_0_inst_AXI_M02_interconnect_BUSER), 
            .axi_M02_bvalid_i(axi_interconnect_0_inst_AXI_M02_interconnect_BVALID), 
            .axi_M02_rlast_i(axi_interconnect_0_inst_AXI_M02_interconnect_RLAST), 
            .axi_M02_rready_o(axi_interconnect_0_inst_AXI_M02_interconnect_RREADY), 
            .axi_M02_ruser_i(axi_interconnect_0_inst_AXI_M02_interconnect_RUSER), 
            .axi_M02_rvalid_i(axi_interconnect_0_inst_AXI_M02_interconnect_RVALID), 
            .axi_M02_wlast_o(axi_interconnect_0_inst_AXI_M02_interconnect_WLAST), 
            .axi_M02_wready_i(axi_interconnect_0_inst_AXI_M02_interconnect_WREADY), 
            .axi_M02_wuser_o(axi_interconnect_0_inst_AXI_M02_interconnect_WUSER), 
            .axi_M02_wvalid_o(axi_interconnect_0_inst_AXI_M02_interconnect_WVALID), 
            .axi_M03_arlock_o(axi_interconnect_0_inst_AXI_M03_interconnect_ARLOCK), 
            .axi_M03_arready_i(axi_interconnect_0_inst_AXI_M03_interconnect_ARREADY), 
            .axi_M03_aruser_o(axi_interconnect_0_inst_AXI_M03_interconnect_ARUSER), 
            .axi_M03_arvalid_o(axi_interconnect_0_inst_AXI_M03_interconnect_ARVALID), 
            .axi_M03_awlock_o(axi_interconnect_0_inst_AXI_M03_interconnect_AWLOCK), 
            .axi_M03_awready_i(axi_interconnect_0_inst_AXI_M03_interconnect_AWREADY), 
            .axi_M03_awuser_o(axi_interconnect_0_inst_AXI_M03_interconnect_AWUSER), 
            .axi_M03_awvalid_o(axi_interconnect_0_inst_AXI_M03_interconnect_AWVALID), 
            .axi_M03_bready_o(axi_interconnect_0_inst_AXI_M03_interconnect_BREADY), 
            .axi_M03_buser_i(axi_interconnect_0_inst_AXI_M03_interconnect_BUSER), 
            .axi_M03_bvalid_i(axi_interconnect_0_inst_AXI_M03_interconnect_BVALID), 
            .axi_M03_rlast_i(axi_interconnect_0_inst_AXI_M03_interconnect_RLAST), 
            .axi_M03_rready_o(axi_interconnect_0_inst_AXI_M03_interconnect_RREADY), 
            .axi_M03_ruser_i(axi_interconnect_0_inst_AXI_M03_interconnect_RUSER), 
            .axi_M03_rvalid_i(axi_interconnect_0_inst_AXI_M03_interconnect_RVALID), 
            .axi_M03_wlast_o(axi_interconnect_0_inst_AXI_M03_interconnect_WLAST), 
            .axi_M03_wready_i(axi_interconnect_0_inst_AXI_M03_interconnect_WREADY), 
            .axi_M03_wuser_o(axi_interconnect_0_inst_AXI_M03_interconnect_WUSER), 
            .axi_M03_wvalid_o(axi_interconnect_0_inst_AXI_M03_interconnect_WVALID), 
            .axi_S00_arid_i(cpu_inst_AXI_M_INSTR_interconnect_ARID[0]), .axi_S00_arlock_i(cpu_inst_AXI_M_INSTR_interconnect_ARLOCK), 
            .axi_S00_arready_o(cpu_inst_AXI_M_INSTR_interconnect_ARREADY), 
            .axi_S00_aruser_i(1'b0), .axi_S00_arvalid_i(cpu_inst_AXI_M_INSTR_interconnect_ARVALID), 
            .axi_S00_awid_i(cpu_inst_AXI_M_INSTR_interconnect_AWID[0]), .axi_S00_awlock_i(cpu_inst_AXI_M_INSTR_interconnect_AWLOCK), 
            .axi_S00_awready_o(cpu_inst_AXI_M_INSTR_interconnect_AWREADY), 
            .axi_S00_awuser_i(1'b0), .axi_S00_awvalid_i(cpu_inst_AXI_M_INSTR_interconnect_AWVALID), 
            .axi_S00_bid_o(cpu_inst_AXI_M_INSTR_interconnect_BID[0]), .axi_S00_bready_i(cpu_inst_AXI_M_INSTR_interconnect_BREADY), 
            .axi_S00_bvalid_o(cpu_inst_AXI_M_INSTR_interconnect_BVALID), .axi_S00_rid_o(cpu_inst_AXI_M_INSTR_interconnect_RID[0]), 
            .axi_S00_rlast_o(cpu_inst_AXI_M_INSTR_interconnect_RLAST), .axi_S00_rready_i(cpu_inst_AXI_M_INSTR_interconnect_RREADY), 
            .axi_S00_rvalid_o(cpu_inst_AXI_M_INSTR_interconnect_RVALID), .axi_S00_wlast_i(cpu_inst_AXI_M_INSTR_interconnect_WLAST), 
            .axi_S00_wready_o(cpu_inst_AXI_M_INSTR_interconnect_WREADY), .axi_S00_wuser_i(1'b0), 
            .axi_S00_wvalid_i(cpu_inst_AXI_M_INSTR_interconnect_WVALID), .axi_S01_arid_i(cpu_inst_AXI_M_DATA_interconnect_ARID[0]), 
            .axi_S01_arlock_i(cpu_inst_AXI_M_DATA_interconnect_ARLOCK), .axi_S01_arready_o(cpu_inst_AXI_M_DATA_interconnect_ARREADY), 
            .axi_S01_aruser_i(1'b0), .axi_S01_arvalid_i(cpu_inst_AXI_M_DATA_interconnect_ARVALID), 
            .axi_S01_awid_i(cpu_inst_AXI_M_DATA_interconnect_AWID[0]), .axi_S01_awlock_i(cpu_inst_AXI_M_DATA_interconnect_AWLOCK), 
            .axi_S01_awready_o(cpu_inst_AXI_M_DATA_interconnect_AWREADY), 
            .axi_S01_awuser_i(1'b0), .axi_S01_awvalid_i(cpu_inst_AXI_M_DATA_interconnect_AWVALID), 
            .axi_S01_bid_o(cpu_inst_AXI_M_DATA_interconnect_BID[0]), .axi_S01_bready_i(cpu_inst_AXI_M_DATA_interconnect_BREADY), 
            .axi_S01_bvalid_o(cpu_inst_AXI_M_DATA_interconnect_BVALID), .axi_S01_rid_o(cpu_inst_AXI_M_DATA_interconnect_RID[0]), 
            .axi_S01_rlast_o(cpu_inst_AXI_M_DATA_interconnect_RLAST), .axi_S01_rready_i(cpu_inst_AXI_M_DATA_interconnect_RREADY), 
            .axi_S01_rvalid_o(cpu_inst_AXI_M_DATA_interconnect_RVALID), .axi_S01_wlast_i(cpu_inst_AXI_M_DATA_interconnect_WLAST), 
            .axi_S01_wready_o(cpu_inst_AXI_M_DATA_interconnect_WREADY), .axi_S01_wuser_i(1'b0), 
            .axi_S01_wvalid_i(cpu_inst_AXI_M_DATA_interconnect_WVALID), .axi_aclk_i(pll0_inst_clkop_o_net), 
            .axi_aresetn_i(cpu_inst_system_resetn_o_net));
    defparam axi_interconnect_0_inst.EXT_MAS_AXI_ADDR_WIDTH = {7'd64,7'd64};
    defparam axi_interconnect_0_inst.EXT_MAS_MAX_ADDR_WIDTH = 64;
    defparam axi_interconnect_0_inst.EXT_SLV_AXI_ADDR_WIDTH = {7'd64,7'd64,7'd64,7'd64};
    defparam axi_interconnect_0_inst.EXT_SLV_FRAGMENT_BASE_ADDR = {64'h0,64'h0,64'h0000000044000000,64'h000000004800A000,64'h0000000040009000,64'h0000000049008000,64'h0,64'h0,64'h0000000000000000,64'h0,64'h0,64'h0000000050000000};
    defparam axi_interconnect_0_inst.EXT_SLV_FRAGMENT_CNT = {5'd1,5'd3,5'd1,5'd1};
    defparam axi_interconnect_0_inst.EXT_SLV_FRAGMENT_END_ADDR = {64'h0,64'h0,64'h0000000047FFFFFF,64'h000000004800AFFF,64'h0000000040009FFF,64'h0000000049008FFF,64'h0,64'h0,64'h000000000001FFFF,64'h0,64'h0,64'h00000000CFFFFFFF};
    defparam axi_interconnect_0_inst.EXT_SLV_MAX_ADDR_WIDTH = 64;
    defparam axi_interconnect_0_inst.EXT_SLV_MAX_FRAGMENT_CNT = 3;
    defparam axi_interconnect_0_inst.TOTAL_EXTSLV_CNT = 4;
    cpu cpu_inst (.dBusAxi_ar_payload_addr({cpu_inst_AXI_M_DATA_interconnect_ARADDR}), 
        .dBusAxi_ar_payload_burst({cpu_inst_AXI_M_DATA_interconnect_ARBURST}), 
        .dBusAxi_ar_payload_cache({cpu_inst_AXI_M_DATA_interconnect_ARCACHE}), 
        .dBusAxi_ar_payload_id({cpu_inst_AXI_M_DATA_interconnect_ARID}), .dBusAxi_ar_payload_len({cpu_inst_AXI_M_DATA_interconnect_ARLEN}), 
        .dBusAxi_ar_payload_prot({cpu_inst_AXI_M_DATA_interconnect_ARPROT}), 
        .dBusAxi_ar_payload_qos({cpu_inst_AXI_M_DATA_interconnect_ARQOS}), 
        .dBusAxi_ar_payload_region({cpu_inst_AXI_M_DATA_interconnect_ARREGION}), 
        .dBusAxi_ar_payload_size({cpu_inst_AXI_M_DATA_interconnect_ARSIZE}), 
        .dBusAxi_aw_payload_addr({cpu_inst_AXI_M_DATA_interconnect_AWADDR}), 
        .dBusAxi_aw_payload_burst({cpu_inst_AXI_M_DATA_interconnect_AWBURST}), 
        .dBusAxi_aw_payload_cache({cpu_inst_AXI_M_DATA_interconnect_AWCACHE}), 
        .dBusAxi_aw_payload_id({cpu_inst_AXI_M_DATA_interconnect_AWID}), .dBusAxi_aw_payload_len({cpu_inst_AXI_M_DATA_interconnect_AWLEN}), 
        .dBusAxi_aw_payload_prot({cpu_inst_AXI_M_DATA_interconnect_AWPROT}), 
        .dBusAxi_aw_payload_qos({cpu_inst_AXI_M_DATA_interconnect_AWQOS}), 
        .dBusAxi_aw_payload_region({cpu_inst_AXI_M_DATA_interconnect_AWREGION}), 
        .dBusAxi_aw_payload_size({cpu_inst_AXI_M_DATA_interconnect_AWSIZE}), 
        .dBusAxi_b_payload_id({cpu_inst_AXI_M_DATA_interconnect_BID}), .dBusAxi_b_payload_resp({cpu_inst_AXI_M_DATA_interconnect_BRESP}), 
        .dBusAxi_r_payload_data({cpu_inst_AXI_M_DATA_interconnect_RDATA}), 
        .dBusAxi_r_payload_id({cpu_inst_AXI_M_DATA_interconnect_RID}), .dBusAxi_r_payload_resp({cpu_inst_AXI_M_DATA_interconnect_RRESP}), 
        .dBusAxi_w_payload_data({cpu_inst_AXI_M_DATA_interconnect_WDATA}), 
        .dBusAxi_w_payload_strb({cpu_inst_AXI_M_DATA_interconnect_WSTRB}), 
        .iBusAxi_ar_payload_addr({cpu_inst_AXI_M_INSTR_interconnect_ARADDR}), 
        .iBusAxi_ar_payload_burst({cpu_inst_AXI_M_INSTR_interconnect_ARBURST}), 
        .iBusAxi_ar_payload_cache({cpu_inst_AXI_M_INSTR_interconnect_ARCACHE}), 
        .iBusAxi_ar_payload_id({cpu_inst_AXI_M_INSTR_interconnect_ARID}), 
        .iBusAxi_ar_payload_len({cpu_inst_AXI_M_INSTR_interconnect_ARLEN}), 
        .iBusAxi_ar_payload_prot({cpu_inst_AXI_M_INSTR_interconnect_ARPROT}), 
        .iBusAxi_ar_payload_qos({cpu_inst_AXI_M_INSTR_interconnect_ARQOS}), 
        .iBusAxi_ar_payload_region({cpu_inst_AXI_M_INSTR_interconnect_ARREGION}), 
        .iBusAxi_ar_payload_size({cpu_inst_AXI_M_INSTR_interconnect_ARSIZE}), 
        .iBusAxi_aw_payload_addr({cpu_inst_AXI_M_INSTR_interconnect_AWADDR}), 
        .iBusAxi_aw_payload_burst({cpu_inst_AXI_M_INSTR_interconnect_AWBURST}), 
        .iBusAxi_aw_payload_cache({cpu_inst_AXI_M_INSTR_interconnect_AWCACHE}), 
        .iBusAxi_aw_payload_id({cpu_inst_AXI_M_INSTR_interconnect_AWID}), 
        .iBusAxi_aw_payload_len({cpu_inst_AXI_M_INSTR_interconnect_AWLEN}), 
        .iBusAxi_aw_payload_prot({cpu_inst_AXI_M_INSTR_interconnect_AWPROT}), 
        .iBusAxi_aw_payload_qos({cpu_inst_AXI_M_INSTR_interconnect_AWQOS}), 
        .iBusAxi_aw_payload_region({cpu_inst_AXI_M_INSTR_interconnect_AWREGION}), 
        .iBusAxi_aw_payload_size({cpu_inst_AXI_M_INSTR_interconnect_AWSIZE}), 
        .iBusAxi_b_payload_id({cpu_inst_AXI_M_INSTR_interconnect_BID}), .iBusAxi_b_payload_resp({cpu_inst_AXI_M_INSTR_interconnect_BRESP}), 
        .iBusAxi_r_payload_data({cpu_inst_AXI_M_INSTR_interconnect_RDATA}), 
        .iBusAxi_r_payload_id({cpu_inst_AXI_M_INSTR_interconnect_RID}), .iBusAxi_r_payload_resp({cpu_inst_AXI_M_INSTR_interconnect_RRESP}), 
        .iBusAxi_w_payload_data({cpu_inst_AXI_M_INSTR_interconnect_WDATA}), 
        .iBusAxi_w_payload_strb({cpu_inst_AXI_M_INSTR_interconnect_WSTRB}), 
        .clk_realtime_i(osc0_inst_lf_clk_out_o_net), .clk_system_i(pll0_inst_clkop_o_net), 
        .dBusAxi_ar_payload_lock(cpu_inst_AXI_M_DATA_interconnect_ARLOCK), 
        .dBusAxi_ar_ready(cpu_inst_AXI_M_DATA_interconnect_ARREADY), .dBusAxi_ar_valid(cpu_inst_AXI_M_DATA_interconnect_ARVALID), 
        .dBusAxi_aw_payload_lock(cpu_inst_AXI_M_DATA_interconnect_AWLOCK), 
        .dBusAxi_aw_ready(cpu_inst_AXI_M_DATA_interconnect_AWREADY), .dBusAxi_aw_valid(cpu_inst_AXI_M_DATA_interconnect_AWVALID), 
        .dBusAxi_b_ready(cpu_inst_AXI_M_DATA_interconnect_BREADY), .dBusAxi_b_valid(cpu_inst_AXI_M_DATA_interconnect_BVALID), 
        .dBusAxi_r_payload_last(cpu_inst_AXI_M_DATA_interconnect_RLAST), .dBusAxi_r_ready(cpu_inst_AXI_M_DATA_interconnect_RREADY), 
        .dBusAxi_r_valid(cpu_inst_AXI_M_DATA_interconnect_RVALID), .dBusAxi_w_payload_last(cpu_inst_AXI_M_DATA_interconnect_WLAST), 
        .dBusAxi_w_ready(cpu_inst_AXI_M_DATA_interconnect_WREADY), .dBusAxi_w_valid(cpu_inst_AXI_M_DATA_interconnect_WVALID), 
        .iBusAxi_ar_payload_lock(cpu_inst_AXI_M_INSTR_interconnect_ARLOCK), 
        .iBusAxi_ar_ready(cpu_inst_AXI_M_INSTR_interconnect_ARREADY), .iBusAxi_ar_valid(cpu_inst_AXI_M_INSTR_interconnect_ARVALID), 
        .iBusAxi_aw_payload_lock(cpu_inst_AXI_M_INSTR_interconnect_AWLOCK), 
        .iBusAxi_aw_ready(cpu_inst_AXI_M_INSTR_interconnect_AWREADY), .iBusAxi_aw_valid(cpu_inst_AXI_M_INSTR_interconnect_AWVALID), 
        .iBusAxi_b_ready(cpu_inst_AXI_M_INSTR_interconnect_BREADY), .iBusAxi_b_valid(cpu_inst_AXI_M_INSTR_interconnect_BVALID), 
        .iBusAxi_r_payload_last(cpu_inst_AXI_M_INSTR_interconnect_RLAST), 
        .iBusAxi_r_ready(cpu_inst_AXI_M_INSTR_interconnect_RREADY), .iBusAxi_r_valid(cpu_inst_AXI_M_INSTR_interconnect_RVALID), 
        .iBusAxi_w_payload_last(cpu_inst_AXI_M_INSTR_interconnect_WLAST), 
        .iBusAxi_w_ready(cpu_inst_AXI_M_INSTR_interconnect_WREADY), .iBusAxi_w_valid(cpu_inst_AXI_M_INSTR_interconnect_WVALID), 
        .irq2_i(gpio0_inst_INTR_interconnect_IRQ), .rstn_i(equation_module_inst_O_net), 
        .system_resetn_o(cpu_inst_system_resetn_o_net), .uart_rxd_i(uart_rxd_i), 
        .uart_txd_o(uart_txd_o));
    defparam cpu_inst.AXI_DATA_BASE_ADDR = 32'h0;
    defparam cpu_inst.DCACHE_ENABLE = 1;
    defparam cpu_inst.ICACHE_ENABLE = 1;
    defparam cpu_inst.TCM_BASE_ADDR = 32'h0;
    defparam cpu_inst.TCM_ENABLE = 0;
    gpio0 gpio0_inst (.apb_paddr_i({apb_interconnect0_inst_APB_M00_interconnect_PADDR[5:0]}), 
          .apb_prdata_o({apb_interconnect0_inst_APB_M00_interconnect_PRDATA}), 
          .apb_pwdata_i({apb_interconnect0_inst_APB_M00_interconnect_PWDATA}), 
          .gpio_io({gpio_io}), .apb_penable_i(apb_interconnect0_inst_APB_M00_interconnect_PENABLE), 
          .apb_pready_o(apb_interconnect0_inst_APB_M00_interconnect_PREADY), 
          .apb_psel_i(apb_interconnect0_inst_APB_M00_interconnect_PSELx), 
          .apb_pslverr_o(apb_interconnect0_inst_APB_M00_interconnect_PSLVERR), 
          .apb_pwrite_i(apb_interconnect0_inst_APB_M00_interconnect_PWRITE), 
          .clk_i(pll0_inst_clkop_o_net), .int_o(gpio0_inst_INTR_interconnect_IRQ), 
          .resetn_i(cpu_inst_system_resetn_o_net));
    new_lpddr4 lpddr4_inst (.apb_paddr_i({apb_interconnect0_inst_APB_M02_interconnect_PADDR[11:0]}), 
            .apb_prdata_o({apb_interconnect0_inst_APB_M02_interconnect_PRDATA}), 
            .apb_pwdata_i({apb_interconnect0_inst_APB_M02_interconnect_PWDATA}), 
            .axi_araddr_i({axi_interconnect_0_inst_AXI_M00_interconnect_ARADDR[30:0]}), 
            .axi_arburst_i({axi_interconnect_0_inst_AXI_M00_interconnect_ARBURST}), 
            .axi_arid_i({axi_interconnect_0_inst_AXI_M00_interconnect_ARID}), 
            .axi_arlen_i({axi_interconnect_0_inst_AXI_M00_interconnect_ARLEN}), 
            .axi_arqos_i({axi_interconnect_0_inst_AXI_M00_interconnect_ARQOS}), 
            .axi_arsize_i({axi_interconnect_0_inst_AXI_M00_interconnect_ARSIZE}), 
            .axi_awaddr_i({axi_interconnect_0_inst_AXI_M00_interconnect_AWADDR[30:0]}), 
            .axi_awburst_i({axi_interconnect_0_inst_AXI_M00_interconnect_AWBURST}), 
            .axi_awid_i({axi_interconnect_0_inst_AXI_M00_interconnect_AWID}), 
            .axi_awlen_i({axi_interconnect_0_inst_AXI_M00_interconnect_AWLEN}), 
            .axi_awqos_i({axi_interconnect_0_inst_AXI_M00_interconnect_AWQOS}), 
            .axi_awsize_i({axi_interconnect_0_inst_AXI_M00_interconnect_AWSIZE}), 
            .axi_bid_o({axi_interconnect_0_inst_AXI_M00_interconnect_BID}), 
            .axi_bresp_o({axi_interconnect_0_inst_AXI_M00_interconnect_BRESP}), 
            .axi_rdata_o({axi_interconnect_0_inst_AXI_M00_interconnect_RDATA}), 
            .axi_rid_o({axi_interconnect_0_inst_AXI_M00_interconnect_RID}), 
            .axi_rresp_o({axi_interconnect_0_inst_AXI_M00_interconnect_RRESP}), 
            .axi_wdata_i({axi_interconnect_0_inst_AXI_M00_interconnect_WDATA}), 
            .axi_wstrb_i({axi_interconnect_0_inst_AXI_M00_interconnect_WSTRB}), 
            .ddr_ca_o({ddr_ca_o}), .ddr_ck_o({ddr_ck_o}), .ddr_cke_o({ddr_cke_o}), 
            .ddr_cs_o({ddr_cs_o}), .ddr_dmi_io({ddr_dmi_io}), .ddr_dq_io({ddr_dq_io}), 
            .ddr_dqs_io({ddr_dqs_io}), .aclk_i(pll0_inst_clkop_o_net), .apb_penable_i(apb_interconnect0_inst_APB_M02_interconnect_PENABLE), 
            .apb_pready_o(apb_interconnect0_inst_APB_M02_interconnect_PREADY), 
            .apb_psel_i(apb_interconnect0_inst_APB_M02_interconnect_PSELx), 
            .apb_pslverr_o(apb_interconnect0_inst_APB_M02_interconnect_PSLVERR), 
            .apb_pwrite_i(apb_interconnect0_inst_APB_M02_interconnect_PWRITE), 
            .areset_n_i(cpu_inst_system_resetn_o_net), .axi_arready_o(axi_interconnect_0_inst_AXI_M00_interconnect_ARREADY), 
            .axi_arvalid_i(axi_interconnect_0_inst_AXI_M00_interconnect_ARVALID), 
            .axi_awready_o(axi_interconnect_0_inst_AXI_M00_interconnect_AWREADY), 
            .axi_awvalid_i(axi_interconnect_0_inst_AXI_M00_interconnect_AWVALID), 
            .axi_bready_i(axi_interconnect_0_inst_AXI_M00_interconnect_BREADY), 
            .axi_bvalid_o(axi_interconnect_0_inst_AXI_M00_interconnect_BVALID), 
            .axi_rlast_o(axi_interconnect_0_inst_AXI_M00_interconnect_RLAST), 
            .axi_rready_i(axi_interconnect_0_inst_AXI_M00_interconnect_RREADY), 
            .axi_rvalid_o(axi_interconnect_0_inst_AXI_M00_interconnect_RVALID), 
            .axi_wlast_i(axi_interconnect_0_inst_AXI_M00_interconnect_WLAST), 
            .axi_wready_o(axi_interconnect_0_inst_AXI_M00_interconnect_WREADY), 
            .axi_wvalid_i(axi_interconnect_0_inst_AXI_M00_interconnect_WVALID), 
            .ddr_reset_n_o(ddr_reset_n_o), .pclk_i(pll0_inst_clkop_o_net), 
            .pll_refclk_i(ddr_pll_refclk_i), .pll_rst_n_i(cpu_inst_system_resetn_o_net), 
            .preset_n_i(cpu_inst_system_resetn_o_net), .rst_n_i(cpu_inst_system_resetn_o_net));
    osc0 osc0_inst (.hf_clk_out_o(osc0_inst_hf_clk_out_o_net), .hf_out_en_i(1'b1), 
         .lf_clk_out_o(osc0_inst_lf_clk_out_o_net));
    pll0 pll0_inst (.clki_i(osc0_inst_hf_clk_out_o_net), .clkop_o(pll0_inst_clkop_o_net), 
         .lock_o(pll0_inst_lock_o_net), .rstn_i(rstn_i));
    spi_flash1 spi_flash1_inst (.ahbl_haddr_i({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HADDR}), 
            .ahbl_hburst_i({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HBURST}), 
            .ahbl_hrdata_o({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HRDATA}), 
            .ahbl_hsize_i({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HSIZE}), 
            .ahbl_htrans_i({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HTRANS}), 
            .ahbl_hwdata_i({axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HWDATA}), 
            .apb_paddr_i({apb_interconnect0_inst_APB_M01_interconnect_PADDR[10:0]}), 
            .apb_prdata_o({apb_interconnect0_inst_APB_M01_interconnect_PRDATA}), 
            .apb_pwdata_i({apb_interconnect0_inst_APB_M01_interconnect_PWDATA}), 
            .ahbl_hclk_i(pll0_inst_clkop_o_net), .ahbl_hready_i(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HREADY), 
            .ahbl_hready_o(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HREADYOUT), 
            .ahbl_hresp_o(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HRESP), 
            .ahbl_hsel_i(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HSELx), 
            .ahbl_hwrite_i(axi2ahbl_spi_flash_inst_AHBL_M_interconnect_HWRITE), 
            .apb_pclk_i(pll0_inst_clkop_o_net), .apb_penable_i(apb_interconnect0_inst_APB_M01_interconnect_PENABLE), 
            .apb_pready_o(apb_interconnect0_inst_APB_M01_interconnect_PREADY), 
            .apb_psel_i(apb_interconnect0_inst_APB_M01_interconnect_PSELx), 
            .apb_pslverr_o(apb_interconnect0_inst_APB_M01_interconnect_PSLVERR), 
            .apb_pwrite_i(apb_interconnect0_inst_APB_M01_interconnect_PWRITE), 
            .miso_i(miso_i), .mosi_o(mosi_o), .rst_i(invert_O_net), .sclk_o(sclk_o), 
            .ss_n_o(ss_n_o), .wpj_o(wpj_o));
    system0 system0_inst (.axi_s0_araddr_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARADDR[31:0]}), 
            .axi_s0_arburst_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARBURST}), 
            .axi_s0_arcache_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARCACHE}), 
            .axi_s0_arid_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARID}), 
            .axi_s0_arlen_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARLEN}), 
            .axi_s0_arprot_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARPROT}), 
            .axi_s0_arqos_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARQOS}), 
            .axi_s0_arregion_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARREGION}), 
            .axi_s0_arsize_i({axi_interconnect_0_inst_AXI_M01_interconnect_ARSIZE}), 
            .axi_s0_awaddr_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWADDR[31:0]}), 
            .axi_s0_awburst_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWBURST}), 
            .axi_s0_awcache_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWCACHE}), 
            .axi_s0_awid_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWID}), 
            .axi_s0_awlen_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWLEN}), 
            .axi_s0_awprot_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWPROT}), 
            .axi_s0_awqos_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWQOS}), 
            .axi_s0_awregion_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWREGION}), 
            .axi_s0_awsize_i({axi_interconnect_0_inst_AXI_M01_interconnect_AWSIZE}), 
            .axi_s0_bid_o({axi_interconnect_0_inst_AXI_M01_interconnect_BID}), 
            .axi_s0_bresp_o({axi_interconnect_0_inst_AXI_M01_interconnect_BRESP}), 
            .axi_s0_rdata_o({axi_interconnect_0_inst_AXI_M01_interconnect_RDATA[31:0]}), 
            .axi_s0_rid_o({axi_interconnect_0_inst_AXI_M01_interconnect_RID}), 
            .axi_s0_rresp_o({axi_interconnect_0_inst_AXI_M01_interconnect_RRESP}), 
            .axi_s0_wdata_i({axi_interconnect_0_inst_AXI_M01_interconnect_WDATA[31:0]}), 
            .axi_s0_wstrb_i({axi_interconnect_0_inst_AXI_M01_interconnect_WSTRB[3:0]}), 
            .axi_aclk_i(pll0_inst_clkop_o_net), .axi_resetn_i(cpu_inst_system_resetn_o_net), 
            .axi_s0_arlock_i(axi_interconnect_0_inst_AXI_M01_interconnect_ARLOCK), 
            .axi_s0_arready_o(axi_interconnect_0_inst_AXI_M01_interconnect_ARREADY), 
            .axi_s0_arvalid_i(axi_interconnect_0_inst_AXI_M01_interconnect_ARVALID), 
            .axi_s0_awlock_i(axi_interconnect_0_inst_AXI_M01_interconnect_AWLOCK), 
            .axi_s0_awready_o(axi_interconnect_0_inst_AXI_M01_interconnect_AWREADY), 
            .axi_s0_awvalid_i(axi_interconnect_0_inst_AXI_M01_interconnect_AWVALID), 
            .axi_s0_bready_i(axi_interconnect_0_inst_AXI_M01_interconnect_BREADY), 
            .axi_s0_bvalid_o(axi_interconnect_0_inst_AXI_M01_interconnect_BVALID), 
            .axi_s0_rlast_o(axi_interconnect_0_inst_AXI_M01_interconnect_RLAST), 
            .axi_s0_rready_i(axi_interconnect_0_inst_AXI_M01_interconnect_RREADY), 
            .axi_s0_rvalid_o(axi_interconnect_0_inst_AXI_M01_interconnect_RVALID), 
            .axi_s0_wlast_i(axi_interconnect_0_inst_AXI_M01_interconnect_WLAST), 
            .axi_s0_wready_o(axi_interconnect_0_inst_AXI_M01_interconnect_WREADY), 
            .axi_s0_wvalid_i(axi_interconnect_0_inst_AXI_M01_interconnect_WVALID));
    defparam system0_inst.MEM_ID = "system0";
    
endmodule

