
/*******************************************************************************
    Verilog netlist generated by IPGEN Lattice Propel (64-bit)
    2024.1.2403252315
    Soft IP Version: 1.3.0
    2024 03 28 21:53:11
*******************************************************************************/
/*******************************************************************************
    Wrapper Module generated per user settings.
*******************************************************************************/
module s1_apb_uart (rxd_i, 
        txd_o, 
        clk_i, 
        rst_n_i, 
        int_o, 
        apb_penable_i, 
        apb_psel_i, 
        apb_pwrite_i, 
        apb_paddr_i, 
        apb_pwdata_i, 
        apb_pready_o, 
        apb_pslverr_o, 
        apb_prdata_o) ;
    input rxd_i ; 
    output txd_o ; 
    input clk_i ; 
    input rst_n_i ; 
    output int_o ; 
    input apb_penable_i ; 
    input apb_psel_i ; 
    input apb_pwrite_i ; 
    input [5:0] apb_paddr_i ; 
    input [31:0] apb_pwdata_i ; 
    output apb_pready_o ; 
    output apb_pslverr_o ; 
    output [31:0] apb_prdata_o ; 
    s1_apb_uart_ipgen_lscc_uart #(.APB_ENABLE(1),
            .SYS_CLOCK_FREQ(100.0),
            .LCR_DATA_BITS(8),
            .LCR_STOP_BITS(1),
            .LCR_PARITY_ENABLE(0),
            .LCR_PARITY_ODD(0),
            .LCR_PARITY_STICK(0),
            .BAUD_RATE(115200),
            .CLK_DIVISOR(868),
            .FIFO(0),
            .MODEM_ENA(0)) lscc_uart_inst (.RTS_N(), 
                .DTR_N(), 
                .DSR_N(1'b0), 
                .DCD_N(1'b1), 
                .CTS_N(1'b0), 
                .RI_N(1'b1), 
                .SIN(rxd_i), 
                .SOUT(txd_o), 
                .pclk(clk_i), 
                .presetn(rst_n_i), 
                .INTR(int_o), 
                .apb_penable_i(apb_penable_i), 
                .apb_psel_i(apb_psel_i), 
                .apb_pwrite_i(apb_pwrite_i), 
                .apb_paddr_i(apb_paddr_i[5:0]), 
                .apb_pwdata_i(apb_pwdata_i[31:0]), 
                .apb_pready_o(apb_pready_o), 
                .apb_pslverr_o(apb_pslverr_o), 
                .apb_prdata_o(apb_prdata_o[31:0]), 
                .RXRDY_N(), 
                .TXRDY_N()) ; 
endmodule



/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                        REVISION HISTORY
// Version      : 1.0
// Changes Made : Initial Creation
//
// Version      : 7.0SP2
// Changes Made : No Change
//
// Version      : 7.1, 3.0
// Changes Made : Use CPU clock for the MSR update
//
// Version      : 3.1
// Changes Made : Baudrate Generation is modified. RX and TX path of the UART is 
//                updated to faster clock. 16-entry deep FIFO is implemented 
//                when FIFO option is selected
//
// Version      : 3.2
// Changes Made : UART driver is modified for TX/RX FIFO for FIFO mode of UART.
//
// Version      : 3.3
// Changes Made : UART optionally gives two additional output ports (RXRDY_N and
//                TXRDY_N) when defined in the UART GUI.
//
// Version      : 3.4
// Changes Made : Added support to print characters transmitted by UART when 
//                doing functional RTL simulation
//
// Version      : 3.5
// Changes Made : WISHBONE Address Bus is 3 bits and Data Bus is 8 bits or 32 
//                bits. All UART registers occupy a byte instead of 4 bytes 
//                (i.e. registers are accessible using 3 bits only instead 
//                of original 5 bits). UART LCR register has default value 
//                (8'b0000_0011).
//
// Version      : 3.6
// Changes Made : Add support for MICO 8
//
// Version      : 3.7
// Changes Made : Bug fixed for the TX FIFO cannot accept new data if TX FIFO is 
//                not empty. New FIFO supports Transmitter Hold Register Ready bit 
//                instead of Tranmitter Hold Register Empty bit.
// 
// Version      : 3.8
// Changes Made : Removed unused signal sel_i
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
//----------------------------------------------------------------------------
//   GENERAL REGISTER:                                                      --
//------------------------                                                  --
//   =================================================================      --
//  |  ADDRESS A[2:0]   |            REGISTER             | IMPLEMENT |     --
//   =================================================================      --
//  | $000 (READ)       | RBR (RECEIVER BUFFER REGISTER)  |  Y        |     --
//   -----------------------------------------------------------------      --
//  | $000 (WRITE)      | THR (TRANSMIT HOLD REGISTER)    |  Y        |     --
//   =================================================================      --
//  | $001 (WRITE)      | IER (INTERRUPT ENABLE REGISTER) |  Y        |     --
//   =================================================================      --
//  | $010 (READ)       | IIR (INTERRUPT ID REGISTER)     |  Y        |     --
//   =================================================================      --
//  | $011 (WRITE)      | LCR (LINE CONTROL REGISTER)     |  Y        |     --
//   =================================================================      --
//  | $100 (WRITE)      | MCR (MODEM CONTROL REGISTER)    |  Y        |     --
//   =================================================================      --
//  | $101 (READ)       | LSR (LINE STATUS REGISTER)      |  Y        |     --
//   =================================================================      --
//  | $110 (READ)       | MSR (MODEM STATUS REGISTER)     |  Y        |     --
//   =================================================================      --
//  | $111 (READ/WRITE) | SCR (SCRATCHPAD REGISTER)       |  N        |     --
//   =================================================================      --
//                                                                          --
//  NOTE:  By using Lattice ISP solution, the Baud Rate can be
//         re-configured even when the device is soldered on the board.     --
//         Therefore the Baud Rate register set is omitted.                 --
//                                                                          --
//         Because each Lattice ispLSI device has a embedded UES register,  --
//         the Scratchpad register can be omitted too.                      --
//                                                                          --
//----------------------------------------------------------------------------
//  REGISTER BIT FIELDS:                                                    --
//--------------------------                                                --
//                                                                          --
//    ============================                                          --
//   | LSR (LINE STATUS REGISTER) |                                         --
//    ==============================================================        --
//   |  0    | TEMT | THRR  |  BI   |  FE   |  PE   |  OE   | RxRDY |       --
//    ==============================================================        --
//                                                                          --
//    RxRDY : RECEIVE DATA READY                                            --
//    OE    : OVERRUN ERROR                                                 --
//    PE    : PARITY ERROR                                                  --
//    FE    : FRAMING ERROR                                                 --
//    BI    : BREAK INTERRUPT                                               --
//    THRR  : TRASMITTER HOLDING REGISTER READY                             --
//    TEMT  : TRASMITTER EMPTY                                              --
//                                                                          --
//                                                                          --
//    RxRDY: The data received flag is set to 1 at the successful           --
//           completion of a byte receive cycle.  It is automatically       --
//           cleared to 0 when the Rx Data Register is read.  If a new byte --
//           is received before an Rx Data Register read, the over run flag --
//           will be set to 1. If (SR) status option is set the UART will   --
//           ignore all further incoming bytes until the Rx Data Register   --
//           has been read.                                                 --
//                                                                          --
//    OE:    It indicates that the data in RBR was not read by the CPU      --
//           before the next character arrived, thereby destroying the the  --
//           previous character. The OE indicator is set to 1 upon          --
//           detection of an overrun condition and reset whenever the CPU   --
//           reads the contents of LSR                                      --
//                                                                          --
//    PE:    The parity error flag is set to 1 if an invalid parity bit is  --
//           encountered. It is automatically cleared to 0 when the CPU     --
//           reads the contents of Line Status Register.                    --
//                                                                          --
//    FE:    The framing error flag is set to 1 if an invalid stop bit is   --
//           encountered. It is automatically cleared to 0 when the CPU     --
//           reads the contents of Line Status Register.                    --
//                                                                          --
//    BI:    The start bit error flag is set to 1 if an invalid start bit   --
//           is encountered. It is automatically cleared to 0 when the CPU  --
//           reads the contents of Line Status Register.                    --
//                                                                          --
//    THRR:  The Transmit Holding Register Ready flag indicate that the     --
//           UART is ready to accept a new character for transmission. In   --
//           addition this bit cause the UART issue an interrupt to the CPU --
//           when the THRR interrupt enable is set to high                  --
//                                                                          --
//    TEMT:  The Transmitter Empty indicator is set to '1' whenever         --
//           whenever the Transmitter Holding Register and the Transmitter  --
//           Shifting Register are both empty. It is reset to '0' whenever  --
//           either the Transmitter Holding register or Transmitter Shift   --
//           Register contains a character                                  --
//                                                                          --
//    ================================                                      --
//   | LCR (LINE CONTROL REGISTER)    |                                     --
//    ===============================================================       --
//   |  DLAB |  SB   |  SP   | EPS   |  PEN  |  STB  | WLS1  | WLS0  |      --
//    ===============================================================       --
//                                                                          --
//    WLS1-WLS0:  WORD LENGTH SELECT  00 = 5 DATA BITS                      --
//                                    01 = 6 DATA BITS                      --
//                                    10 = 7 DATA BITS                      --
//                                    11 = 8 DATA BITS                      --
//                                                                          --
//    STB:  NUMBER OF STOP BITS  0 = 1 STOP BIT (DEFAULT)                   --
//                               1 = 1.5 STOP BITS (DATA LENGTH 5 BITS)     --
//                               1 = 2 STOP BITS   (DATA LENGTH 6,7,8 BITS) --
//                                                                          --
//    PEN:  PARITY ENABLE                                                   --
//    EPS:  EVEN PARITY SELECT                                              --
//    SP:   SET PARITY                                                      --
//                                  SP EPS PEN      PARITY SELECTION        --
//                                  X   X   0       NO PARITY               --
//                                  0   0   1       ODD PARITY              --
//                                  0   1   1       EVEN PARITY             --
//                                  1   0   1       FORCE PARITY "1"        --
//                                  1   1   1       FORCE PARITY "0"        --
//                                                                          --
//    SB:   SET BREAK When enable the Break control bit causes a break      --
//          condition to be transmitted (the TX output is forced to a logic --
//          0 state). This condition exits until disabled by resetting this --
//          bit to a logic 0.                                               --
//                                                                          --
//    DLAB: DIVISOR LATCH ACCESS BIT:   0 = Divisor latch disable (default) --
//                                      1 = Divisor latch enabled           --
//          Note: Because we use ISP solution to reconfigure Baud Rate,     --
//                this bit is omitted as well as the Baud Rate Register.    --
//                                                                          --
//    =============================                                         --
//   | IIR (INTERRUPT ID REGISTER) |                                        --
//    ===================================================================   --
//   |   0   |   0   |   0   |   0   | INT 2 | INT 1 | INT 0 | INT STAT  |  --
//    ===================================================================   --
//                                                                          --
//   PRIOTITY LEVEL  BIT-3  BIT-2  BIT-1  BIT-0  SOURCE OF INTERRUPT        --
//   NONE              0      0      0      1    NONE                       --
//   HIGHEST           0      1      1      0    LSR (OE/PE/FE/BI)          --
//   2nd               0      1      0      0    RxRDY (Receiver Data Ready)--
//   3rd               0      0      1      0    THRR (THR Ready)           --
//   4th               0      0      0      0    MSR (Modem Status Register)--
//                                                                          --
//      In the 16450 Mode Bit-3 is 0.                                       --
//                                                                          --
//    =================================                                     --
//   | IER (INTERRUPT ENABLE REGISTER) |                                    --
//    ===============================================================       --
//   |   0   |   0   |   0   |   0   |  MSI  |  RLSI |  THRI | RHRI  |      --
//    ===============================================================       --
//                                                                          --
//   RBRI:    Receiver Buffer Register Interrupt (1 = Enable, 0 = Disble)   --
//   THRI:    Transmitter Hold Register Interrupt (1 = Enalbe, 0 = Disble)  --
//   RLSI:    Receiver Line Status Interrupt (1 = Enalble, 0 = Disble)      --
//   MSI:     Modem Status Interrupt (1 = Enable, 0 = Disble)               --
//                                                                          --
//    =============================                                         --
//   | MSR (MODEM STATUS REGISTER) |                                        --
//    ===============================================================       --
//   |  DCD  |  RI   |  DSR  |  CTS  |  DDCD |  TERI |  DDSR |  DCTS |      --
//    ===============================================================       --
//                                                                          --
//   DCD:       Data Carrier Detect                                         --
//   RI:        Ring Indicator                                              --
//   DSR:       Data Set Ready                                              --
//   CTS:       Clear To Send                                               --
//   DDCD:      Delta Data Carrier Detect                                   --
//   TERI:      Trailing Edge Ring Indicator                                --
//   DDSR:      Delta Data Set Ready                                        --
//   DCTS:      Delta Clear to Send                                         --
//   Bit0-3 are set to '1' whenever a control input from the MODEM changes  --
//   state, and an Modem Stauts. Interrupt is generated. They are reset to  --
//   '0' whenever the CPU reads the Modem Status Register.                  --
//                                                                          --
//    ==============================                                        --
//   | MCR (MODEM CONTROL REGISTER) |                                       --
//    ===============================================================       --
//   |   0   |   0   |   0   | LOOP* | OUT2* | OUT1* |  RTS  |  DTR  |      --
//    ===============================================================       --
//                                                                          --
//   DTR:       Data Terminal Ready                                         --
//   RTS:       Request To Send                                             --
//   OUT1:      Auxiliary User-defined Output 1 (Not Implemented)           --
//   OUT2:      Auxiliary User-defined Output 2 (Not Implemented)           --
//   LOOP:      Local Loopback for diagnostic testing of the UART           --
//              (Not Implemented)                                           --
//                                                                          --
//   Note:      OUT1, OUT2 and LOOP are not implemented                     --
//                                                                          --
// =============================================================================
//                        REVISION HISTORY
// Version      : 1.0
// Changes Made : Initial Creation
//
// Version      : 7.0SP2
// Changes Made : No Change
//
// Version      : 7.1, 3.0
// Changes Made : msr_rd changed to be combinatorial logic
//                lsr_rd changed to be combinatorial logic
//                When IER is masked, should diasble the current INT
//
// Version      : 3.1
// Changes Made : Baudrate Generation is modified.
//                RX and TX path of the UART is updated to faster clock
//                16 word deep FIFO is implemented when FIFO option is
//                selected              
//
// Version      : 3.3
// Changes Made : Removed port-width mismatch for bus fifo_din_thr
//
// Version      : 3.4
// Changes Made : Added support to print characters transmitted by UART
//                when doing functional RTL simulation
//
// Version      : 3.5
// Changes Made : WISHBONE Address Bus is 3 bits and Data Bus is 8 bits or 32 
//                bits. All UART registers occupy a byte instead of 4 bytes 
//                (i.e. registers are accessible using 3 bits only instead 
//                of original 5 bits). UART LCR register has default value 
//                (8'b0000_0011).
//
// Version      : 3.7
// Changes Made : Bug fixed for the TX FIFO cannot accept new data if TX FIFO is 
//                not empty. New FIFO supports Transmitter Hold Register Ready bit 
//                instead of Tranmitter Hold Register Empty bit.
// 
// Version      : 3.8
// Changes Made : Removed unused signal sel_i
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                        REVISION HISTORY
// Version      : 7.2
// Changes Made : Initial Creation
//                Baudrate Generation is modified.
//                RX and TX path of the UART is updated to faster clock
//                16 word deep FIFO is implemented when FIFO option is
//                selected
// ============================================================================
module s1_apb_uart_ipgen_lscc_uart_txcver_fifo (Data, 
        Clock, 
        WrEn, 
        RdEn, 
        Reset, 
        Q, 
        Empty, 
        Full, 
        AlmostEmpty, 
        AlmostFull) ;
    input [7:0] Data ; 
    input Clock ; 
    input WrEn ; 
    input RdEn ; 
    input Reset ; 
    output [7:0] Q ; 
    output Empty ; 
    output Full ; 
    output AlmostEmpty ; 
    output AlmostFull ; 
    parameter lat_family = "MachXO3D" ; 
    generate
        if (((lat_family == "SC") || (lat_family == "SCM"))) 
            begin : genblk1
                pmi_fifo_dc #(.pmi_data_width_w(8),
                        .pmi_data_width_r(8),
                        .pmi_data_depth_w(16),
                        .pmi_data_depth_r(16),
                        .pmi_full_flag(16),
                        .pmi_empty_flag(0),
                        .pmi_almost_full_flag(8),
                        .pmi_almost_empty_flag(4),
                        .pmi_regmode("noreg"),
                        .pmi_family("MachXO3D"),
                        .module_type("pmi_fifo_dc"),
                        .pmi_implementation("LUT")) tx_fifo_inst_dc (.Data(Data), 
                            .WrClock(Clock), 
                            .RdClock(Clock), 
                            .WrEn(WrEn), 
                            .RdEn(RdEn), 
                            .Reset(Reset), 
                            .RPReset(Reset), 
                            .Q(Q), 
                            .Empty(Empty), 
                            .Full(Full), 
                            .AlmostEmpty(AlmostEmpty), 
                            .AlmostFull(AlmostFull)) ; 
            end
        else
            begin : genblk1
                pmi_fifo #(.pmi_data_width(8),
                        .pmi_data_depth(16),
                        .pmi_full_flag(16),
                        .pmi_empty_flag(0),
                        .pmi_almost_full_flag(8),
                        .pmi_almost_empty_flag(4),
                        .pmi_regmode("noreg"),
                        .pmi_family("MachXO3D"),
                        .module_type("pmi_fifo"),
                        .pmi_implementation("LUT")) tx_fifo_inst (.Data(Data), 
                            .Clock(Clock), 
                            .WrEn(WrEn), 
                            .RdEn(RdEn), 
                            .Reset(Reset), 
                            .Q(Q), 
                            .Empty(Empty), 
                            .Full(Full), 
                            .AlmostEmpty(AlmostEmpty), 
                            .AlmostFull(AlmostFull)) ; 
            end
    endgenerate
endmodule



module s1_apb_uart_ipgen_lscc_uart_intface #(parameter CLK_IN_MHZ = 25, 
        parameter BAUD_RATE = 115200, 
        parameter CLK_DIVISOR = (CLK_IN_MHZ / BAUD_RATE), 
        parameter UART_WB_ADR_WIDTH = 4, 
        parameter UART_WB_DAT_WIDTH = 8, 
        parameter FIFO = 0, 
        parameter LCR_DATA_BITS = 8, 
        parameter LCR_STOP_BITS = 1, 
        parameter LCR_PARITY_ENABLE = 0, 
        parameter LCR_PARITY_ODD = 0, 
        parameter LCR_PARITY_STICK = 0, 
        parameter LCR_SET_BREAK = 0, 
        parameter STDOUT_SIM = 0, 
        parameter STDOUT_SIMFAST = 0) (
    // system clock and reset
    input reset, 
    input clk, 
    //    // wishbone interface signals
    //    input cyc_i,
    //    input stb_i,
    //    input we_i,
    //    input [2:0] cti_i,
    //    input [1:0] bte_i,
    //    input [UART_WB_ADR_WIDTH-1:0] adr_i,
    //    input [UART_WB_DAT_WIDTH-1:0] dat_i,
    //    output reg ack_o,
    //    output [UART_WB_DAT_WIDTH-1:0] dat_o,
    // -----------------------------------------
    // APB Interface
    // -----------------------------------------
    //input         pclk   ,
    //input         presetn,
    input psel, 
    input [3:0] paddr, 
    input [7:0] pwdata, 
    input pwrite, 
    input penable, 
    output reg pready, 
    output [7:0] prdata, 
    output reg intr, 
    // Registers
    input [(UART_WB_DAT_WIDTH - 1):0] rbr, 
    input [(UART_WB_DAT_WIDTH - 1):0] rbr_fifo, 
    output [(UART_WB_DAT_WIDTH - 1):0] thr, 
    // Rising edge of registers read/write strobes
    output rbr_rd, 
    output reg thr_wr, 
    output lsr_rd, 
    // Receiver/Transmitter control
    output [1:0] databits, 
    output [1:0] stopbits, 
    output parity_en, 
    output parity_even, 
    output parity_stick, 
    output tx_break, 
    // Receiver/Transmitter status
    input rx_rdy, 
    input overrun_err, 
    input parity_err, 
    input frame_err, 
    input break_int, 
    input thrr, 
    input temt, 
    input fifo_empty, 
    output fifo_empty_thr, 
    output fifo_full_thr, 
    input thr_rd, 
    input fifo_almost_full, 
    output reg [15:0] divisor) ;
    localparam LCR_PARITY_EVEN = (LCR_PARITY_ODD ? 0 : 1) ; 
    reg dlab_r ; 
    wire [6:0] lcr_default ; 
    assign lcr_default[1:0] = (LCR_DATA_BITS - 5) ; 
    assign lcr_default[6:2] = {LCR_SET_BREAK[0],
                LCR_PARITY_STICK[0],
                LCR_PARITY_EVEN[0],
                LCR_PARITY_ENABLE[0],
                LCR_STOP_BITS[1]} ; 
    //   generate
    //      if (LCR_DATA_BITS == 5)
    //    assign lcr_default[1:0] = 2'b00;
    //      else if (LCR_DATA_BITS == 6)
    //    assign lcr_default[1:0] = 2'b01;
    //      else if (LCR_DATA_BITS == 7)
    //    assign lcr_default[1:0] = 2'b10;
    //      else
    //    assign lcr_default[1:0] = 2'b11;
    //   endgenerate
    //
    //   generate
    //      if (LCR_STOP_BITS == 1)
    //    assign lcr_default[2] = 1'b0;
    //      else
    //    assign lcr_default[2] = 1'b1;
    //   endgenerate
    //   
    //   generate
    //      if (LCR_PARITY_ENABLE == 0)
    //    assign lcr_default[3] = 1'b0;
    //      else
    //    assign lcr_default[3] = 1'b1;
    //   endgenerate
    //   
    //   generate
    //      if (LCR_PARITY_ODD == 0)
    //    assign lcr_default[4] = 1'b1;
    //      else
    //    assign lcr_default[4] = 1'b0;
    //   endgenerate
    //   
    //   generate
    //      if (LCR_PARITY_STICK == 0)
    //    assign lcr_default[5] = 1'b0;
    //      else
    //    assign lcr_default[5] = 1'b1;
    //   endgenerate
    //   
    //   generate
    //      if (LCR_SET_BREAK == 0)
    //    assign lcr_default[6] = 1'b0;
    //      else
    //    assign lcr_default[6] = 1'b1;
    //   endgenerate
    wire [(UART_WB_DAT_WIDTH - 1):0] thr_fifo ; 
    reg [(UART_WB_DAT_WIDTH - 1):0] thr_nonfifo ; 
    reg [7:0] data_8bit ; 
    generate
        if ((FIFO == 1)) 
            begin: genblk1
                assign thr = thr_fifo ; 
            end
        else
            begin: genblk1
                assign thr = thr_nonfifo ; 
            end
    endgenerate
    reg [6:0] lsr ; 
    reg [6:0] lcr ; 
    wire [3:0] iir ; 
    reg [2:0] ier ; 
    wire rx_rdy_int ; 
    wire thre_int ; 
    wire dataerr_int ; 
    wire data_err ; 
    wire wr_strobe ; 
    wire thr_wr_strobe ; 
    wire rbr_rd_strobe ; 
    wire iir_rd_strobe ; 
    reg iir_rd_strobe_delay ; 
    wire lsr_rd_strobe ; 
    wire div_wr_strobe ; 
    reg lsr2_r, 
        lsr3_r, 
        lsr4_r ; 
    wire rbr_rd_fifo ; 
    reg rbr_rd_nonfifo ; 
    generate
        if ((FIFO == 1)) 
            begin: genblk2
                assign rbr_rd = rbr_rd_fifo ; 
            end
        else
            begin: genblk2
                assign rbr_rd = rbr_rd_nonfifo ; 
            end
    endgenerate
    // FIFO signals for FIFO mode
    wire fifo_almost_full_thr ; 
    wire fifo_almost_empty_thr ; 
    wire [7:0] fifo_din_thr ; 
    reg fifo_wr_thr ; 
    reg fifo_wr_q_thr ; 
    wire fifo_wr_pulse_thr ; 
    // UART baud 16x clock generator
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                //divisor <= ((CLK_IN_MHZ*1000*1000)/(BAUD_RATE));
                divisor <=  CLK_DIVISOR[15:0] ;
            else
                if (div_wr_strobe) 
                    if (paddr[0]) 
                        //   adr_i[0])
                        //divisor <= {pwdata[7:0]  ,divisor[7:0]};
                        divisor[15:8] <=  pwdata[7:0] ;
                    else
                        //divisor <= {divisor[15:8],pwdata[7:0] };
                        divisor[7:0] <=  pwdata[7:0] ;
        end
    // UART Registers Address Map
    localparam A_RBR = 4'b0000 ; 
    localparam A_THR = 4'b0000 ; 
    localparam A_IER = 4'b0001 ; 
    localparam A_IIR = 4'b0010 ; 
    localparam A_LCR = 4'b0011 ; 
    localparam A_LSR = 4'b0101 ; 
    localparam A_DIV = 3'b100 ; 
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                thr_wr <=  1'b0 ;
            else
                thr_wr <=  thr_wr_strobe ;
        end// always
    assign lsr_rd = lsr_rd_strobe ; 
    assign rbr_rd_fifo = rbr_rd_strobe ; 
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                rbr_rd_nonfifo <=  1'b0 ;
            else
                rbr_rd_nonfifo <=  rbr_rd_strobe ;
        end// always
    ////////////////////////////////////////////////////////////////////////////////
    // Registers Read/Write Control Signals
    ////////////////////////////////////////////////////////////////////////////////
    generate
        if ((FIFO == 1)) 
            begin: genblk3
                assign wr_strobe = (((((paddr == A_THR) && psel) && pwrite) && (~fifo_full_thr)) && (~pready)) ; 
            end
        else
            begin: genblk3
                assign wr_strobe = ((((paddr == A_THR) && psel) && pwrite) && pready) ; 
            end
        if (((STDOUT_SIMFAST == 1) && (STDOUT_SIM == 1))) 
            begin : genblk4
                assign thr_wr_strobe = wr_strobe ; 
            end
        else
            begin : genblk4
                assign thr_wr_strobe = wr_strobe ; 
            end
    endgenerate
    generate
        if ((FIFO == 1)) 
            begin: genblk5
                assign rbr_rd_strobe = (((((paddr == A_RBR) && psel) && (~pwrite)) && (~fifo_empty)) && (~pready)) ; 
            end
        else
            begin: genblk5
                assign rbr_rd_strobe = (((paddr == A_RBR) && psel) && (~pwrite)) ; 
            end
    endgenerate
    generate
        if ((FIFO == 1)) 
            begin: genblk6
                assign iir_rd_strobe = ((((paddr == A_IIR) && psel) && (~pwrite)) && (~pready)) ; 
            end
        else
            begin: genblk6
                assign iir_rd_strobe = (((paddr == A_IIR) && psel) && (~pwrite)) ; 
            end
    endgenerate
    generate
        if ((FIFO == 1)) 
            begin: genblk7
                assign lsr_rd_strobe = ((((paddr == A_LSR) && psel) && (~pwrite)) && (~pready)) ; 
            end
        else
            begin: genblk7
                assign lsr_rd_strobe = (((paddr == A_LSR) && psel) && (~pwrite)) ; 
            end
    endgenerate
    assign div_wr_strobe = (((((paddr[3:1] == A_DIV) && psel) && pwrite) && penable) && pready) ; 
    ////////////////////////////////////////////////////////////////////////////////
    // Registers Read/Write Operation
    ////////////////////////////////////////////////////////////////////////////////
    generate
        if ((FIFO == 1)) 
            begin : fifo_regrd
                //   always @(cyc_i or stb_i or we_i or adr_i or rbr_fifo or iir 
                //`ifdef MODEM
                //        or msr
                //`endif 
                //        or lsr)
                always
                    @(*)
                    begin
                        case (paddr)
                        A_RBR : 
                            data_8bit <=  rbr_fifo ;
                        A_IER : 
                            data_8bit <=  {5'b00000,
                                    ier} ;
                        A_IIR : 
                            data_8bit <=  {4'b1100,
                                    iir} ;
                        A_LCR : 
                            // Indicates FIFOs are enabled
                            data_8bit <=  {1'b0,
                                    lcr} ;
                        A_LSR : 
                            data_8bit <=  {1'b0,
                                    lsr} ;
                        default : 
                            data_8bit <=  8'b00000000 ;
                        endcase 
                    end
            end
        else
            begin : nfifo_regrd
                // Register Read
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            data_8bit <=  8'b00000000 ;
                        else
                            //          else if (cyc_i && stb_i && ~we_i)
                            if ((psel && (~pwrite))) 
                                case (paddr)
                                A_RBR : 
                                    data_8bit <=  rbr ;
                                A_IER : 
                                    data_8bit <=  {5'b00000,
                                            ier} ;
                                A_IIR : 
                                    data_8bit <=  {4'b0000,
                                            iir} ;
                                A_LCR : 
                                    data_8bit <=  {1'b0,
                                            lcr} ;
                                A_LSR : 
                                    data_8bit <=  {1'b0,
                                            lsr} ;
                                default : 
                                    data_8bit <=  8'b00000000 ;
                                endcase 
                    end// always
            end
    endgenerate
    //   assign dat_o = data_8bit;   
    assign prdata = data_8bit ; 
    generate
        if ((FIFO == 0)) 
            begin : nfifo_regwr
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                thr_nonfifo <=  {UART_WB_DAT_WIDTH{1'b0}} ;
                                ier <=  3'b000 ;
                                lcr <=  lcr_default ;
                            end
                        else
                            //          else if (cyc_i && stb_i && we_i) begin
                            if (((psel && pwrite) && penable)) 
                                begin
                                    case (paddr)
                                    A_THR : 
                                        thr_nonfifo <=  pwdata[(UART_WB_DAT_WIDTH - 1):0] ;
                                    A_IER : 
                                        ier <=  pwdata[2:0] ;
                                    A_LCR : 
                                        lcr <=  pwdata[6:0] ;
                                    default : 
                                        ; 
                                    endcase 
                                end
                    end// always
            end
        else
            begin : fifo_regwr
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                ier <=  3'b000 ;
                                lcr <=  lcr_default ;
                            end
                        else
                            //          else if (cyc_i && stb_i && we_i)
                            if (((psel && pwrite) && penable)) 
                                case (paddr)
                                A_IER : 
                                    ier <=  pwdata[2:0] ;
                                A_LCR : 
                                    lcr <=  pwdata[6:0] ;
                                default : 
                                    ; 
                                endcase 
                    end// always
            end
    endgenerate
    generate
        if ((FIFO == 1)) 
            begin : tx_fifo_inst
                assign fifo_wr_pulse_thr = thr_wr_strobe ; 
                assign fifo_din_thr = pwdata ; //dat_i[7:0];
                s1_apb_uart_ipgen_lscc_uart_txcver_fifo TX_FIFO (.Data(fifo_din_thr), 
                            .Clock(clk), 
                            .WrEn(fifo_wr_pulse_thr), 
                            .RdEn(thr_rd), 
                            .Reset(reset), 
                            .Q(thr_fifo), 
                            .Empty(fifo_empty_thr), 
                            .Full(fifo_full_thr), 
                            .AlmostEmpty(fifo_almost_empty_thr), 
                            .AlmostFull(fifo_almost_full_thr)) ; 
            end
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    //  Line Control Register
    ////////////////////////////////////////////////////////////////////////////////
    // databits : "00"=5-bit, "01"=6-bit, "10"=7-bit, "11"=8-bit
    assign databits = lcr[1:0] ; 
    // stopbits : "00"=1-bit, "01"=1.5-bit(5-bit data), "10"=2-bit(6,7,8-bit data)
    assign stopbits = ((lcr[2] == 1'b0) ? 2'b00 : ((lcr[2:0] == 3'b100) ? 2'b01 : 2'b10)) ; 
    // parity_en : '0'=Parity Bit Enable, '1'=Parity Bit Disable
    assign parity_en = lcr[3] ; 
    // parity_even : '0'=Even Parity Selected, '1'=Odd Parity Selected
    assign parity_even = lcr[4] ; 
    // parity_stick : '0'=Stick Parity Disable, '1'=Stick Parity Enable
    assign parity_stick = lcr[5] ; 
    // tx_break : '0'=Disable BREAK assertion, '1'=Assert BREAK
    assign tx_break = lcr[6] ; 
    ////////////////////////////////////////////////////////////////////////////////
    //  Line Status Register
    ////////////////////////////////////////////////////////////////////////////////
    generate
        if ((FIFO == 1)) 
            begin : fifo_lsr
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        lsr2_r <=  1'b0 ;
                    else
                        if (parity_err) 
                            lsr2_r <=  1'b1 ;
                        else
                            if (lsr_rd_strobe) 
                                lsr2_r <=  1'b0 ;
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        lsr3_r <=  1'b0 ;
                    else
                        if (frame_err) 
                            lsr3_r <=  1'b1 ;
                        else
                            if (lsr_rd_strobe) 
                                lsr3_r <=  1'b0 ;
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        lsr4_r <=  1'b0 ;
                    else
                        if (break_int) 
                            lsr4_r <=  1'b1 ;
                        else
                            if (lsr_rd_strobe) 
                                lsr4_r <=  1'b0 ;
                always
                    @(posedge clk)
                    lsr <=  {temt,
                            thrr,
                            lsr4_r,
                            lsr3_r,
                            lsr2_r,
                            overrun_err,
                            rx_rdy} ;
            end
        else
            begin : nfifo_lsr
                always
                    @(temt or 
                        thrr or 
                        break_int or 
                        frame_err or 
                        parity_err or 
                        overrun_err or 
                        rx_rdy)
                    lsr = {temt,
                            thrr,
                            break_int,
                            frame_err,
                            parity_err,
                            overrun_err,
                            rx_rdy} ;
            end
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    // Interrupt Arbitrator
    ////////////////////////////////////////////////////////////////////////////////
    // Int is the common interrupt line for all internal UART events
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                intr <=  1'b0 ;
            else
                intr <=  ((rx_rdy_int | thre_int) | dataerr_int) ;
        end// always
    // Receiving Data Error Flags including Overrun, Parity, Framing and Break
    generate
        if ((FIFO == 1)) 
            begin: genblk12
                assign data_err = (((overrun_err | lsr2_r) | lsr3_r) | lsr4_r) ; 
            end
        else
            begin: genblk12
                assign data_err = (((overrun_err | parity_err) | frame_err) | break_int) ; 
            end
    endgenerate
    // Whenever bit0, 1, 2,or 3 is set to '1', A_WB Modem Status Interrupt is generated
    generate
        if ((FIFO == 1)) 
            begin: genblk13
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        iir_rd_strobe_delay <=  1'b0 ;
                    else
                        iir_rd_strobe_delay <=  iir_rd_strobe ;
            end
    endgenerate
    // State Machine Definition
    localparam idle = 3'b000 ; 
    localparam int0 = 3'b001 ; 
    localparam int1 = 3'b010 ; 
    localparam int2 = 3'b011 ; 
    localparam int3 = 3'b100 ; 
    reg [2:0] cs_state ; 
    generate
        if ((FIFO == 1)) 
            begin : fifo_int
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            cs_state <=  idle ;
                        else
                            case (cs_state)
                            idle : 
                                begin
                                    if (((ier[2] == 1'b1) && (data_err == 1'b1))) 
                                        cs_state <=  int0 ;
                                    else
                                        if (((ier[0] == 1'b1) && (fifo_almost_full || (!fifo_empty)))) 
                                            cs_state <=  int1 ;
                                        else
                                            if (((ier[1] == 1'b1) && (thrr == 1'b1))) 
                                                cs_state <=  int2 ;
                                end
                            int0 : 
                                begin
                                    if (((lsr_rd_strobe == 1'b1) || (ier[2] == 1'b0))) 
                                        begin
                                            if (((ier[0] == 1'b1) && fifo_almost_full)) 
                                                cs_state <=  int1 ;
                                            else
                                                cs_state <=  idle ;
                                        end
                                end
                            int1 : 
                                begin
                                    if (((data_err == 1'b1) && (ier[2] == 1'b1))) 
                                        cs_state <=  int0 ;
                                    else
                                        if (((!fifo_almost_full) || (ier[0] == 1'b0))) 
                                            cs_state <=  idle ;
                                end
                            int2 : 
                                begin
                                    if (((iir_rd_strobe_delay || (thrr == 1'b0)) || (ier[1] == 1'b0))) 
                                        cs_state <=  idle ;
                                end
                            default : 
                                cs_state <=  idle ;
                            endcase 
                    end// always
            end
        else
            begin : nfifo_int
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            cs_state <=  idle ;
                        else
                            case (cs_state)
                            idle : 
                                begin
                                    if (((ier[2] == 1'b1) && (data_err == 1'b1))) 
                                        cs_state <=  int0 ;
                                    else
                                        if (((ier[0] == 1'b1) && (rx_rdy == 1'b1))) 
                                            cs_state <=  int1 ;
                                        else
                                            if (((ier[1] == 1'b1) && (thrr == 1'b1))) 
                                                cs_state <=  int2 ;
                                end
                            int0 : 
                                begin
                                    if (((lsr_rd_strobe == 1'b1) || (ier[2] == 1'b0))) 
                                        begin
                                            if (((ier[0] == 1'b1) && rx_rdy)) 
                                                cs_state <=  int1 ;
                                            else
                                                cs_state <=  idle ;
                                        end
                                end
                            int1 : 
                                begin
                                    if (((data_err == 1'b1) && (ier[2] == 1'b1))) 
                                        cs_state <=  int0 ;
                                    else
                                        if (((rx_rdy == 1'b0) || (ier[0] == 1'b0))) 
                                            cs_state <=  idle ;
                                end
                            int2 : 
                                begin
                                    if (((iir_rd_strobe || (thrr == 1'b0)) || (ier[1] == 1'b0))) 
                                        cs_state <=  idle ;
                                end
                            default : 
                                cs_state <=  idle ;
                            endcase 
                    end// always
            end
    endgenerate
    // ACK signal generate
    always
        @(posedge clk or 
            posedge reset)
        if (reset) 
            pready <=  1'b0 ;
        else
            if (pready) 
                pready <=  1'b0 ;
            else
                if (psel) 
                    pready <=  1'b1 ;
    // Set Receiver Line Status Interrupt
    assign dataerr_int = ((cs_state == int0) ? 1'b1 : 1'b0) ; 
    // Set Received Data Available Interrupt
    assign rx_rdy_int = ((cs_state == int1) ? 1'b1 : 1'b0) ; 
    // Set thr Empty Interrupt
    assign thre_int = ((cs_state == int2) ? 1'b1 : 1'b0) ; 
    // Set MODEM Status Interrupt
    // Update IIR
    assign iir = ((cs_state == int0) ? 4'b0110 : ((cs_state == int1) ? 4'b0100 : ((cs_state == int2) ? 4'b0010 : 4'b0001))) ; // No Interrupt Pending
endmodule



// INTFACE_FILE
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                        REVISION HISTORY
// Version      : 1.0
// Changes Made : Initial Creation
//
// Version      : 7.0SP2, 3.0
// Changes Made : Add one more register to sin to avoid meta-stability
//
// Version      : 3.1
// Changes Made : Baudrate Generation is modified.
//                RX and TX path of the UART is updated to faster clock
//                16 word deep FIFO is implemented when FIFO option is
//                selected
//
// Version      : 3.5
// Changes Made : WISHBONE Data Bus can be 8 bits or 32 bits. All UART registers 
//                occupy byte instead of 4 bytes (i.e. registers are accessible 
//                using 3 bits only instead of original 5 bits).
// =============================================================================
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                        REVISION HISTORY
// Version      : 7.2
// Changes Made : Initial Creation
//                Baudrate Generation is modified.
//                RX and TX path of the UART is updated to faster clock
//                16 word deep FIFO is implemented when FIFO option is
//                selected
// =============================================================================
module s1_apb_uart_ipgen_lscc_uart_rxcver_fifo #(parameter lat_family = "MachXO3D") (// parameter passing of Device Family will be supported when available in system builder
    Data, 
        Clock, 
        WrEn, 
        RdEn, 
        Reset, 
        Q, 
        Q_error, 
        Empty, 
        Full, 
        AlmostEmpty, 
        AlmostFull) ;
    input [10:0] Data ; 
    input Clock ; 
    input WrEn ; 
    input RdEn ; 
    input Reset ; 
    output [7:0] Q ; 
    output [2:0] Q_error ; 
    output Empty ; 
    output Full ; 
    output AlmostEmpty ; 
    output AlmostFull ; 
    wire [7:0] Q_node ; 
    generate
        if (((lat_family == "SC") || (lat_family == "SCM"))) 
            begin : genblk1
                pmi_fifo_dc #(.pmi_data_width_w(8),
                        .pmi_data_width_r(8),
                        .pmi_data_depth_w(16),
                        .pmi_data_depth_r(16),
                        .pmi_full_flag(16),
                        .pmi_empty_flag(0),
                        .pmi_almost_full_flag(1),
                        .pmi_almost_empty_flag(0),
                        .pmi_regmode("noreg"),
                        .pmi_family("MachXO3D"),
                        .module_type("pmi_fifo_dc"),
                        .pmi_implementation("LUT")) rx_fifo_inst_dc (.Data(Data[10:3]), 
                            .WrClock(Clock), 
                            .RdClock(Clock), 
                            .WrEn(WrEn), 
                            .RdEn(RdEn), 
                            .Reset(Reset), 
                            .RPReset(Reset), 
                            .Q(Q_node), 
                            .Empty(Empty), 
                            .Full(Full), 
                            .AlmostEmpty(AlmostEmpty), 
                            .AlmostFull(AlmostFull)) ; 
            end
        else
            begin : genblk1
                pmi_fifo #(.pmi_data_width(8),
                        .pmi_data_depth(16),
                        .pmi_full_flag(16),
                        .pmi_empty_flag(0),
                        .pmi_almost_full_flag(1),
                        .pmi_almost_empty_flag(0),
                        .pmi_regmode("noreg"),
                        .pmi_family("MachXO3D"),
                        .module_type("pmi_fifo"),
                        .pmi_implementation("LUT")) rx_fifo_inst (.Data(Data[10:3]), 
                            .Clock(Clock), 
                            .WrEn(WrEn), 
                            .RdEn(RdEn), 
                            .Reset(Reset), 
                            .Q(Q_node), 
                            .Empty(Empty), 
                            .Full(Full), 
                            .AlmostEmpty(AlmostEmpty), 
                            .AlmostFull(AlmostFull)) ; 
            end
    endgenerate
    reg [2:0] fifo [15:0] ; 
    reg [4:0] wr_pointer1 = 0 ; 
    reg [4:0] rd_pointer1 = 0 ; 
    reg [4:0] rd_pointer_prev = 0 ; 
    reg valid_RdEn ; 
    always
        @(posedge Clock or 
            posedge Reset)
        begin
            if (Reset) 
                begin
                    wr_pointer1 <=  0 ;
                    rd_pointer1 <=  0 ;
                    valid_RdEn <=  0 ;
                    rd_pointer_prev <=  0 ;
                    fifo[0] <=  0 ;
                    fifo[1] <=  0 ;
                    fifo[2] <=  0 ;
                    fifo[3] <=  0 ;
                    fifo[4] <=  0 ;
                    fifo[5] <=  0 ;
                    fifo[6] <=  0 ;
                    fifo[7] <=  0 ;
                    fifo[8] <=  0 ;
                    fifo[9] <=  0 ;
                    fifo[10] <=  0 ;
                    fifo[11] <=  0 ;
                    fifo[12] <=  0 ;
                    fifo[13] <=  0 ;
                    fifo[14] <=  0 ;
                    fifo[15] <=  0 ;
                end
            else
                begin
                    if ((((WrEn == 1) && (RdEn != 1)) && (Full != 1))) 
                        begin
                            fifo[(wr_pointer1 % 16)] <=  Data[2:0] ;
                            wr_pointer1 <=  (wr_pointer1 + 1) ;
                        end
                    else
                        if ((((WrEn != 1) && (RdEn == 1)) && (Empty != 1))) 
                            begin
                                valid_RdEn <=  1'b1 ;
                                rd_pointer_prev <=  rd_pointer1 ;
                                rd_pointer1 <=  (rd_pointer1 + 1) ;
                            end
                        else
                            if (((WrEn == 1) && (RdEn == 1))) 
                                begin
                                    rd_pointer_prev <=  rd_pointer1 ;
                                    valid_RdEn <=  1'b1 ;
                                    fifo[(wr_pointer1 % 16)] <=  Data[2:0] ;
                                    rd_pointer1 <=  (rd_pointer1 + 1) ;
                                    wr_pointer1 <=  (wr_pointer1 + 1) ;
                                end
                    //	     else
                    //	       valid_RdEn          <= 1'b0;	     
                    if (valid_RdEn) 
                        begin
                            fifo[(rd_pointer_prev % 16)] <=  0 ;
                            valid_RdEn <=  1'b0 ;
                        end
                end
        end
    // Data is only valid for single clock cycle after read to the FIFO occurs  
    //    assign   Q = {Q_node, fifo[rd_pointer_prev%16]};
    assign Q = Q_node ; 
    assign Q_error = fifo[(rd_pointer_prev % 16)] ; 
endmodule



module s1_apb_uart_ipgen_lscc_uart_rxcver #(parameter UART_WB_DAT_WIDTH = 8, 
        parameter FIFO = 0) (// Global reset and clock
    reset, 
        clk, 
        // Register
    rbr, 
        rbr_fifo, 
        // Rising edge of rbr, lsr read strobes
    rbr_rd, 
        lsr_rd, 
        // Receiver input
    sin, 
        // Receiver control
    databits, 
        parity_en, 
        parity_even, 
        parity_stick, 
        // Receiver status
    rx_rdy, 
        overrun_err, 
        parity_err, 
        frame_err, 
        break_int, 
        fifo_empty, 
        fifo_almost_full, 
        divisor) ;
    input reset ; 
    input clk ; 
    input rbr_rd ; 
    input lsr_rd ; 
    input sin ; 
    input [1:0] databits ; 
    input parity_en ; 
    input parity_even ; 
    input parity_stick ; 
    output [7:0] rbr_fifo ; 
    output [(UART_WB_DAT_WIDTH - 1):0] rbr ; 
    output rx_rdy ; 
    output overrun_err ; 
    output parity_err ; 
    output frame_err ; 
    output break_int ; 
    output fifo_empty ; 
    output fifo_almost_full ; 
    input [15:0] divisor ; 
    reg [3:0] databit_recved_num ; 
    reg [(UART_WB_DAT_WIDTH - 1):0] rsr ; 
    reg rx_parity_err ; 
    reg rx_frame_err ; 
    reg rx_idle ; 
    reg rbr_datardy ; 
    reg [3:0] count ; 
    reg hunt ; 
    reg hunt_one ; 
    reg sin_r ; // added to deal with metastability
    reg sin_d0 ; 
    reg sin_d1 ; 
    reg rx_frame_err_d1 ; 
    reg rx_idle_d1 ; 
    reg overrun_err_int ; 
    reg parity_err_int ; 
    reg frame_err_int ; 
    reg break_int_int ; 
    reg sampled_once ; 
    reg rxclk_en ; 
    wire [7:0] rbr_fifo ; 
    wire [2:0] rbr_fifo_error ; 
    reg [(UART_WB_DAT_WIDTH - 1):0] rbr ; 
    // State Machine Definition - 1 hot encoding
    localparam ST_W = 5 ; 
    localparam idle = 5'h01 ; 
    localparam shift = 5'h02 ; 
    localparam parity = 5'h04 ; 
    localparam stop = 5'h08 ; 
    localparam idle1 = 5'h10 ; 
    reg [(ST_W - 1):0] cs_state ; 
    localparam lat_family = "MachXO3D" ; 
    // FIFO signals for FIFO mode
    wire fifo_full ; 
    wire fifo_empty ; 
    wire fifo_almost_full ; 
    wire fifo_almost_empty ; 
    reg [10:0] fifo_din ; 
    reg fifo_wr ; 
    reg fifo_wr_q ; 
    wire fifo_wr_pulse ; 
    reg [15:0] counter ; 
    // These wires and assignments aims to reuse logic resource
    wire [15:0] divisor_2 ; 
    wire [15:0] counter_minus_1 ; 
    wire counter_eq_div_2 ; 
    wire counter_eq_1 ; 
    assign divisor_2 = {1'b0,
                divisor[15:1]} ; //divisor/2;
    assign counter_eq_div_2 = (counter == divisor_2) ; 
    assign counter_minus_1 = (counter - 1'b1) ; 
    assign counter_eq_1 = (counter == 16'b0000_0000_0000_0001) ; 
    ////////////////////////////////////////////////////////////////////////////////
    // Generate hunt
    ////////////////////////////////////////////////////////////////////////////////
    // hunt : will be TRUE when start bit is found
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                hunt <=  1'b0 ;
            else
                if ((((cs_state == idle) && (sin_d0 == 1'b0)) && (sin_d1 == 1'b1))) 
                    // Set Hunt when SIN falling edge is found at the idle state
                    hunt <=  1'b1 ;
                else
                    if ((sampled_once && (~sin_d0))) 
                        // Start bit is successfully sampled twice after framing error
                        // set Hunt_r "true" for resynchronizing of next frame
                        hunt <=  1'b1 ;
                    else
                        if (((~rx_idle) || sin_d0)) 
                            hunt <=  1'b0 ;
        end
    // hunt_one :
    //   hunt_one, used for BI flag generation, indicates that there is at
    //   least a '1' in the (data + parity + stop) bits of the frame.
    //   Break Interrupt flag(BI) is set to '1' whenever the received input
    //   is held at the '0' state for all bits in the frame (Start bit +
    //   Data bits + Parity bit + Stop bit).  So, as long as hunt_one is still
    //   low after all bits are received, BI will be set to '1'.
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                hunt_one <=  1'b0 ;
            else
                if (hunt) 
                    hunt_one <=  1'b0 ;
                else
                    if ((((rx_idle == 1'b0) && counter_eq_div_2) && (sin_d0 == 1'b1))) 
                        hunt_one <=  1'b1 ;
        end
    // rbr_datardy :
    // This will be set to indicate that the data in rbr is ready for read and
    // will be cleared after rbr is read.
    //
    generate
        if ((FIFO == 1)) 
            begin : fifo_rbr_dtrdy
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            rbr_datardy <=  1'b0 ;
                        else
                            begin
                                if (fifo_empty) 
                                    // clear RbrDataRDY when RBR is read by CPU in 450 or FIFO is
                                    // empty in 550 mode
                                    rbr_datardy <=  1'b0 ;
                                else
                                    if ((!fifo_empty)) 
                                        // set RbrDataRDY at RxIdle_r rising edge
                                        rbr_datardy <=  1'b1 ;
                            end
                    end// always
            end
        else
            begin : nfifo_rbr_dtrdy
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            rbr_datardy <=  1'b0 ;
                        else
                            begin
                                if (rbr_rd) 
                                    // clear RbrDataRDY when RBR is read by CPU in 450 or FIFO is
                                    // empty in 550 mode
                                    rbr_datardy <=  1'b0 ;
                                else
                                    if (((rx_idle == 1'b1) && (rx_idle_d1 == 1'b0))) 
                                        // set RbrDataRDY at RxIdle_r rising edge
                                        rbr_datardy <=  1'b1 ;
                            end
                    end// always
            end
    endgenerate
    // sampled_once :
    //   This will be set for one clk clock after a framing error occurs not
    //   because of BREAK and a low sin signal is sampled by the clk right
    //   after the sample time of the Stop bit which causes the framing error.
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                sampled_once <=  1'b0 ;
            else
                if ((((rx_frame_err && (~rx_frame_err_d1)) && (~sin_d0)) && hunt_one)) 
                    // Start bit got sampled once
                    sampled_once <=  1'b1 ;
                else
                    sampled_once <=  1'b0 ;
        end
    // rx_idle Flag
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                rx_idle <=  1'b1 ;
            else
                if ((cs_state == idle)) 
                    rx_idle <=  1'b1 ;
                else
                    rx_idle <=  1'b0 ;
        end
    ////////////////////////////////////////////////////////////////////////////////
    // Receiver Finite State Machine
    ////////////////////////////////////////////////////////////////////////////////
    //  rx_parity_err:
    //               rx_parity_err is a dynamic Parity Error indicator which is
    //               initialized to 0 for even parity and 1 for odd parity.
    //               For odd parity, if there are odd number of '1's in the
    //               (data + parity) bits, the XOR will bring rx_parity_err back to 0
    //               which means no parity error, otherwise rx_parity_err will be 1 to
    //               indicate a parity error.
    // parity_stick='1' means Stick Parity is enabled.  In this case,
    //               the accumulated dynamic rx_parity_err result will be ignored.  A new
    //               value will be assigned to rx_parity_err based on the even/odd parity
    //               mode setting and the sin sampled in parity bit.
    //                  parity_even='0'(odd parity):
    //                     sin needs to be '1', otherwise it's a stick parity error.
    //                  parity_even='1'(even parity):
    //                     sin needs to be '0', otherwise it's a stick parity error.
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                begin
                    rsr <=  0 ;
                    databit_recved_num <=  4'h0 ;
                    rx_parity_err <=  1'b1 ;
                    rx_frame_err <=  1'b0 ;
                    cs_state <=  idle ;
                    counter <=  16'b0000_0000_0000_0000 ;
                end
            else
                case (cs_state)
                idle : 
                    begin
                        if (((sin_d0 == 1'b0) && (sin_d1 == 1'b1))) 
                            begin
                                cs_state <=  idle1 ;
                            end
                        counter <=  divisor ;// - 1'b1;
                    end
                idle1 : 
                    begin
                        if (counter_eq_div_2) 
                            begin
                                if ((sin_d0 == 1'b1)) 
                                    cs_state <=  idle ;
                                else
                                    begin
                                        rsr <=  0 ;
                                        databit_recved_num <=  4'h0 ;
                                        rx_parity_err <=  (~parity_even) ;
                                        rx_frame_err <=  1'b0 ;
                                    end
                            end
                        if (counter_eq_1) 
                            begin
                                cs_state <=  shift ;
                                counter <=  divisor ;
                            end
                        else
                            counter <=  counter_minus_1 ;
                    end
                shift : 
                    begin
                        if (counter_eq_div_2) 
                            begin
                                rsr <=  {sin_d0,
                                        rsr[7:1]} ;
                                rx_parity_err <=  (rx_parity_err ^ sin_d0) ;// parity generation
                                databit_recved_num <=  (databit_recved_num + 1) ;
                            end
                        if (counter_eq_1) 
                            begin
                                if ((((((databits == 2'b00) && (databit_recved_num == 4'h5)) || ((databits == 2'b01) && (databit_recved_num == 4'h6))) || ((databits == 2'b10) && (databit_recved_num == 4'h7))) || ((databits == 2'b11) && (databit_recved_num == 4'h8)))) 
                                    if ((parity_en == 1'b0)) 
                                        cs_state <=  stop ;
                                    else
                                        cs_state <=  parity ;
                                counter <=  divisor ;
                            end
                        else
                            counter <=  counter_minus_1 ;
                    end
                parity : 
                    begin
                        if (counter_eq_div_2) 
                            begin
                                // Parity checking
                                if ((parity_stick == 1'b0)) 
                                    rx_parity_err <=  (rx_parity_err ^ sin_d0) ;
                                else
                                    if ((parity_even == 1'b0)) 
                                        rx_parity_err <=  (~sin_d0) ;
                                    else
                                        rx_parity_err <=  sin_d0 ;
                            end
                        if (counter_eq_1) 
                            begin
                                cs_state <=  stop ;
                                counter <=  divisor ;
                            end
                        else
                            counter <=  counter_minus_1 ;
                    end
                stop : 
                    begin
                        if (counter_eq_div_2) 
                            begin
                                // The Receiver checks the 1st Stopbit only regardless of the number
                                // of Stop bits selected.
                                // Stop bit needs to be '1', otherwise it's a Framing error
                                rx_frame_err <=  (~sin_d0) ;
                                cs_state <=  idle ;
                            end
                        counter <=  counter_minus_1 ;
                    end
                default : 
                    cs_state <=  idle ;
                endcase 
        end// always
    ////////////////////////////////////////////////////////////////////////////////
    // Receiver Buffer Register
    ////////////////////////////////////////////////////////////////////////////////
    generate
        if ((FIFO == 1)) 
            begin : genblk2
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                fifo_din <=  0 ;
                                fifo_wr <=  0 ;
                            end
                        else
                            if (((rx_idle == 1'b1) && (rx_idle_d1 == 1'b0))) 
                                begin
                                    if (break_int_int) 
                                        begin
                                            fifo_din <=  {8'b0,
                                                    3'b100} ;
                                            fifo_wr <=  1'b1 ;
                                        end
                                    else
                                        begin
                                            case (databits)
                                            2'b00 : 
                                                fifo_din <=  {3'b000,
                                                        rsr[7:3],
                                                        1'b0,
                                                        parity_err_int,
                                                        frame_err_int} ;
                                            2'b01 : 
                                                fifo_din <=  {2'b00,
                                                        rsr[7:2],
                                                        1'b0,
                                                        parity_err_int,
                                                        frame_err_int} ;
                                            2'b10 : 
                                                fifo_din <=  {1'b0,
                                                        rsr[7:1],
                                                        1'b0,
                                                        parity_err_int,
                                                        frame_err_int} ;
                                            default : 
                                                fifo_din <=  {rsr,
                                                        1'b0,
                                                        parity_err_int,
                                                        frame_err_int} ;
                                            endcase 
                                            fifo_wr <=  1'b1 ;
                                        end
                                end
                            else
                                fifo_wr <=  1'b0 ;
                    end
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        fifo_wr_q <=  0 ;
                    else
                        fifo_wr_q <=  fifo_wr ;
                assign fifo_wr_pulse = (fifo_wr & (~fifo_wr_q)) ; 
                s1_apb_uart_ipgen_lscc_uart_rxcver_fifo RX_FIFO (.Data(fifo_din), 
                            .Clock(clk), 
                            .WrEn(fifo_wr_pulse), 
                            .RdEn(rbr_rd), 
                            .Reset(reset), 
                            .Q(rbr_fifo), 
                            .Q_error(rbr_fifo_error), 
                            .Empty(fifo_empty), 
                            .Full(fifo_full), 
                            .AlmostEmpty(fifo_almost_empty), 
                            .AlmostFull(fifo_almost_full)) ; 
            end
        else
            begin : genblk2
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            rbr <=  0 ;
                        else
                            if (((rx_idle == 1'b1) && (rx_idle_d1 == 1'b0))) 
                                case (databits)
                                2'b00 : 
                                    rbr <=  {3'b000,
                                            rsr[7:3]} ;
                                2'b01 : 
                                    rbr <=  {2'b00,
                                            rsr[7:2]} ;
                                2'b10 : 
                                    rbr <=  {1'b0,
                                            rsr[7:1]} ;
                                default : 
                                    rbr <=  rsr ;
                                endcase 
                    end
            end
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    // Delayed Signals for edge detections
    ////////////////////////////////////////////////////////////////////////////////
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                begin
                    sin_r <=  1'b1 ;
                    sin_d0 <=  1'b1 ;
                    sin_d1 <=  1'b1 ;
                end
            else
                begin
                    // sin_d0 : Signal for rising edge detection of signal sin
                    // must be registered before using with sin_d1, 
                    // since sin is ASYNCHRONOUS!!! to the system clock
                    sin_r <=  sin ;
                    sin_d0 <=  sin_r ;// use double FF synchronizer
                    sin_d1 <=  sin_d0 ;
                end
        end
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                begin
                    //          sin_d1 <= 1'b0;
                    rx_frame_err_d1 <=  1'b1 ;
                end
            else
                begin
                    //sin_d1 : Signal for falling edge detection of signal SIN
                    //          sin_d1 <= sin_d0;
                    // rx_frame_err_d1 :
                    // a delayed version of rx_frame_err for detacting the rising edge
                    // used to resynchronize the next frame after framing error
                    rx_frame_err_d1 <=  rx_frame_err ;
                end
        end
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                begin
                    rx_idle_d1 <=  1'b1 ;
                end
            else
                begin
                    // rx_idle_d1 : Signal for rising edge detection of signal rx_idle
                    rx_idle_d1 <=  rx_idle ;
                end
        end
    ////////////////////////////////////////////////////////////////////////////////
    // Generate Error Flags
    ////////////////////////////////////////////////////////////////////////////////
    // Receiver Error Flags in lsr
    //   overrun_err(OE), parity_err(PE), frame_err(FE), break_int(BI)
    //   will be set to reflect the sin line status only after the whole frame
    //   (Start bit + Data bits + Parity bit + Stop bit) is received.  A rising
    //   edge of rx_idle indicates the whole frame is received.
    //`endif
    generate
        if ((FIFO == 1)) 
            begin : genblk3
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                parity_err_int <=  1'b0 ;
                                frame_err_int <=  1'b0 ;
                                break_int_int <=  1'b0 ;
                            end
                        else
                            begin
                                // Set parity_err flag if rx_parity_err is 1 when Parity enable
                                parity_err_int <=  (rx_parity_err & parity_en) ;
                                // Set frame_err flag if rx_frame_err is 1(Stop bit is sampled low)
                                frame_err_int <=  rx_frame_err ;
                                // Set break_int flag if hunt_one is still low
                                break_int_int <=  (~hunt_one) ;
                            end
                    end
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        overrun_err_int <=  1'b0 ;
                    else
                        if ((fifo_full && fifo_wr)) 
                            overrun_err_int <=  1'b1 ;
                        else
                            if (lsr_rd) 
                                overrun_err_int <=  1'b0 ;
                assign overrun_err = overrun_err_int ; 
                assign parity_err = rbr_fifo_error[1] ; 
                assign frame_err = rbr_fifo_error[0] ; 
                assign break_int = rbr_fifo_error[2] ; 
                // Receiver ready for read when data is available in rbr
                assign rx_rdy = rbr_datardy ; 
            end
        else
            begin : genblk3
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                overrun_err_int <=  1'b0 ;
                                parity_err_int <=  1'b0 ;
                                frame_err_int <=  1'b0 ;
                                break_int_int <=  1'b0 ;
                            end
                        else
                            if ((rx_idle && (!rx_idle_d1))) 
                                begin
                                    // update at rxidle rising
                                    // Set overrun_err flag if RBR data is still not read by CPU
                                    overrun_err_int <=  rbr_datardy ;
                                    // Set parity_err flag if rx_parity_err is 1 when Parity enable
                                    parity_err_int <=  ((parity_err_int | rx_parity_err) & parity_en) ;
                                    // Set frame_err flag if rx_frame_err is 1(Stop bit is sampled low)
                                    frame_err_int <=  (frame_err_int | rx_frame_err) ;
                                    // Set break_int flag if hunt_one is still low
                                    break_int_int <=  (break_int_int | (~hunt_one)) ;
                                end
                            else
                                if (lsr_rd) 
                                    begin
                                        // clear when LSR is read
                                        parity_err_int <=  1'b0 ;
                                        frame_err_int <=  1'b0 ;
                                        overrun_err_int <=  1'b0 ;
                                        break_int_int <=  1'b0 ;
                                    end
                    end
                assign overrun_err = overrun_err_int ; 
                assign parity_err = parity_err_int ; 
                assign frame_err = frame_err_int ; 
                assign break_int = break_int_int ; 
                // Receiver ready for read when data is available in rbr
                assign rx_rdy = rbr_datardy ; 
            end
    endgenerate
endmodule



// RXCVER_FILE
/* >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
     ------------------------------------------------------------------
     Copyright (c) 2019-2022 by Lattice Semiconductor Corporation
     ALL RIGHTS RESERVED
     ------------------------------------------------------------------

       IMPORTANT: THIS FILE IS USED BY OR GENERATED BY the LATTICE PROPEL DEVELOPMENT SUITE, WHICH INCLUDES PROPEL BUILDER AND PROPEL SDK.

       Lattice grants permission to use this code pursuant to the
       terms of the Lattice Propel License Agreement.

     DISCLAIMER:

       LATTICE MAKES NO WARRANTIES ON THIS FILE OR ITS CONTENTS, WHETHER EXPRESSED, IMPLIED, STATUTORY, OR IN ANY PROVISION OF THE LATTICE PROPEL LICENSE AGREEMENT OR COMMUNICATION WITH LICENSEE, AND LATTICE SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  LATTICE DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED HEREIN WILL MEET LICENSEE'S REQUIREMENTS, OR THAT LICENSEE'S OPERATION OF ANY DEVICE, SOFTWARE OR SYSTEM USING THIS FILE OR ITS CONTENTS WILL BE UNINTERRUPTED OR ERROR FREE, OR THAT DEFECTS HEREIN WILL BE CORRECTED.  LICENSEE ASSUMES RESPONSIBILITY FOR SELECTION OF MATERIALS TO ACHIEVE ITS INTENDED RESULTS, AND FOR THE PROPER INSTALLATION, USE, AND RESULTS OBTAINED THEREFROM.  LICENSEE ASSUMES THE ENTIRE RISK OF THE FILE AND ITS CONTENTS PROVING DEFECTIVE OR FAILING TO PERFORM PROPERLY AND IN SUCH EVENT, LICENSEE SHALL ASSUME THE ENTIRE COST AND RISK OF ANY REPAIR, SERVICE, CORRECTION, OR ANY OTHER LIABILITIES OR DAMAGES CAUSED BY OR ASSOCIATED WITH THE SOFTWARE.  IN NO EVENT SHALL LATTICE BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS FILE OR ITS CONTENTS, EVEN IF LATTICE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. LATTICE'S SOLE LIABILITY, AND LICENSEE'S SOLE REMEDY, IS SET FORTH ABOVE.  LATTICE DOES NOT WARRANT OR REPRESENT THAT THIS FILE, ITS CONTENTS OR USE THEREOF DOES NOT INFRINGE ON THIRD PARTIES' INTELLECTUAL PROPERTY RIGHTS, INCLUDING ANY PATENT. IT IS THE USER'S RESPONSIBILITY TO VERIFY THE USER SOFTWARE DESIGN FOR CONSISTENCY AND FUNCTIONALITY THROUGH THE USE OF FORMAL SOFTWARE VALIDATION METHODS.

     ------------------------------------------------------------------
 */
//
// =============================================================================
//                        REVISION HISTORY
// Version      : 1.0
// Changes Made : Initial Creation
//
// Version      : 7.0SP2
// Changes Made : No Change
//
// Version      : 7.1, 3.0
// Changes Made : Fix one TSR bit setting issue, only update it after STOP bit is
//                totally shifted out.
//
// Version      : 3.1
// Changes Made : Initial Creation
//                Baudrate Generation is modified.
//                RX and TX path of the UART is updated to faster clock
//                16 word deep FIFO is implemented when FIFO option is
//                selected
//                
// Version      : 3.5
// Changes Made : WISHBONE Data Bus can be 8 bits or 32 bits. All UART registers 
//                occupy byte instead of 4 bytes (i.e. registers are accessible 
//                using 3 bits only instead of original 5 bits).
//
// Version      : 3.7
// Changes Made : Bug fixed for the TX FIFO cannot accept new data if TX FIFO is 
//                not empty. New FIFO supports Transmitter Hold Register Ready bit 
//                instead of Tranmitter Hold Register Empty bit.
// ============================================================================
module s1_apb_uart_ipgen_lscc_uart_txmitt #(parameter UART_WB_DAT_WIDTH = 8, 
        parameter FIFO = 0) (reset,  // Global reset and clock
    clk, 
        thr,  // Register THR                    
    thr_wr,  // THR write strobe 
    sout,  // Transmitter output              
    databits,  // Transmitter control             
    stopbits, 
        parity_en, 
        parity_even, 
        parity_stick, 
        tx_break, 
        thrr,  // Transmitter status  
    temt, 
        fifo_empty_thr, 
        fifo_full_thr, 
        thr_rd, 
        thr_ready, 
        divisor) ;
    input reset ; 
    input clk ; 
    input [(UART_WB_DAT_WIDTH - 1):0] thr ; 
    input thr_wr ; 
    input [1:0] databits ; 
    input [1:0] stopbits ; 
    input parity_en ; 
    input parity_even ; 
    input parity_stick ; 
    input tx_break ; 
    input fifo_empty_thr ; 
    input fifo_full_thr ; 
    output thr_rd ; 
    output thrr ; 
    output temt ; 
    output sout ; 
    output reg thr_ready ; 
    input [15:0] divisor ; 
    reg tx_output ; 
    reg [(UART_WB_DAT_WIDTH - 1):0] tsr ; 
    reg tx_parity ; 
    reg tsr_empty ; 
    reg thr_empty ; 
    reg tx_in_start_s ; 
    reg tx_in_shift_s ; 
    reg tx_in_stop_s ; 
    reg tx_in_shift_s1 ; //tx_in_shift_s delayed 1 clock
    reg tx_in_stop_s1 ; //tx_in_stop_s delayed 1 clock
    reg txclk_ena ; 
    reg txclk_enb ; 
    reg [2:0] tx_cnt ; 
    reg [3:0] count_v ; 
    reg thr_rd_int ; 
    reg thr_rd_delay ; 
    reg last_word ; 
    // State Machine Definition - 1hot encoding
    localparam ST_W = 7 ; 
    localparam start = 7'h01 ; 
    localparam shift = 7'h02 ; 
    localparam parity = 7'h04 ; 
    localparam stop_1bit = 7'h08 ; 
    localparam stop_2bit = 7'h10 ; 
    localparam stop_halfbit = 7'h20 ; 
    localparam start1 = 7'h40 ; 
    reg [(ST_W - 1):0] tx_state ; 
    reg [15:0] counter ; 
    wire [15:0] divisor_2 ; 
    wire [15:0] counter_minus_1 ; 
    wire counter_eq_0 ; 
    wire counter_eq_1 ; 
    assign divisor_2 = {1'b0,
                divisor[15:1]} ; 
    assign counter_eq_0 = (~|counter) ; 
    assign counter_eq_1 = (counter == 16'b0000_0000_0000_0001) ; 
    assign counter_minus_1 = (counter - 1'b1) ; 
    generate
        if ((FIFO == 1)) 
            begin: genblk1
                // Generate Single cycle THR FIFO read signal 
                always
                    @(posedge clk or 
                        posedge reset)
                    if (reset) 
                        thr_rd_delay <=  1'b0 ;
                    else
                        thr_rd_delay <=  thr_rd_int ;
            end
        assign thr_rd = (thr_rd_int & (~thr_rd_delay)) ; 
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    // Transmitter Finite State Machine
    ////////////////////////////////////////////////////////////////////////////////
    generate
        if ((FIFO == 1)) 
            begin : fifo_fsm
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            thr_rd_int <=  1'b0 ;
                        else
                            begin
                                if ((((tx_state == start) && (!fifo_empty_thr)) && (!thr_rd_int))) 
                                    thr_rd_int <=  1'b1 ;
                                else
                                    if ((tx_state == shift)) 
                                        thr_rd_int <=  1'b0 ;
                            end
                    end// always
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                tx_cnt <=  0 ;
                                tsr <=  0 ;
                                tx_output <=  1'b1 ;
                                tx_parity <=  1'b1 ;
                                tx_state <=  start ;
                                last_word <=  1'b0 ;
                                counter <=  16'b0000000000000000 ;
                            end
                        else
                            begin
                                case (tx_state)
                                start : 
                                    begin
                                        if (thr_rd_delay) 
                                            tx_state <=  start1 ;
                                    end
                                start1 : 
                                    begin
                                        if (last_word) 
                                            last_word <=  1'b0 ;
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  shift ;
                                                        tx_parity <=  (~parity_even) ;// TxParity initialization
                                                        tx_cnt <=  0 ;
                                                        tsr <=  thr ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b0 ;
                                    end
                                shift : 
                                    begin
                                        tx_output <=  tsr[0] ;
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        tx_parity <=  (tx_parity ^ tsr[0]) ;
                                                        counter <=  0 ;
                                                        tsr <=  {1'b0,
                                                                tsr[7:1]} ;// Shift serial data out
                                                        tx_cnt <=  (tx_cnt + 1) ;
                                                        if ((((((databits == 2'b00) && (tx_cnt == 3'h4)) || ((databits == 2'b01) && (tx_cnt == 3'h5))) || ((databits == 2'b10) && (tx_cnt == 3'h6))) || ((databits == 2'b11) && (tx_cnt == 3'h7)))) 
                                                            tx_state <=  (parity_en ? parity : stop_1bit) ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                    end
                                parity : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  stop_1bit ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  (parity_stick ? (~parity_even) : tx_parity) ;
                                    end
                                stop_1bit : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        if (fifo_empty_thr) 
                                                            last_word <=  1'b1 ;
                                                        if ((stopbits == 2'b00)) // 2 stop bits(for 6,7,8-bit data)
                                                            // 1 stop bit 
                                                            tx_state <=  start ;
                                                        else
                                                            if ((stopbits == 2'b01)) 
                                                                // 1.5 stop bits(for 5-bit data only)
                                                                tx_state <=  stop_halfbit ;
                                                            else
                                                                tx_state <=  stop_2bit ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b1 ;
                                    end
                                stop_2bit : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  start ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b1 ;
                                    end
                                stop_halfbit : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor_2 ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  start ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b1 ;
                                    end
                                default : 
                                    tx_state <=  start ;
                                endcase 
                            end
                    end// always
            end
        else
            begin : nfifo_fsm
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            begin
                                tx_cnt <=  0 ;
                                tsr <=  0 ;
                                tx_output <=  1'b1 ;
                                tx_parity <=  1'b1 ;
                                tx_state <=  start ;
                                counter <=  16'b0000000000000000 ;
                            end
                        else
                            begin
                                case (tx_state)
                                start : 
                                    begin
                                        if ((!thr_ready)) 
                                            tx_state <=  start1 ;
                                    end
                                start1 : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  shift ;
                                                        tx_parity <=  (~parity_even) ;// TxParity initialization
                                                        tx_cnt <=  0 ;
                                                        tsr <=  thr ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b0 ;
                                    end
                                shift : 
                                    begin
                                        tx_output <=  tsr[0] ;
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        tx_parity <=  (tx_parity ^ tsr[0]) ;
                                                        counter <=  0 ;
                                                        tsr <=  {1'b0,
                                                                tsr[7:1]} ;// Shift serial data out
                                                        tx_cnt <=  (tx_cnt + 1) ;
                                                        if ((((((databits == 2'b00) && (tx_cnt == 3'h4)) || ((databits == 2'b01) && (tx_cnt == 3'h5))) || ((databits == 2'b10) && (tx_cnt == 3'h6))) || ((databits == 2'b11) && (tx_cnt == 3'h7)))) 
                                                            tx_state <=  (parity_en ? parity : stop_1bit) ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                    end
                                parity : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  stop_1bit ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  (parity_stick ? (~parity_even) : tx_parity) ;
                                    end
                                stop_1bit : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        if ((stopbits == 2'b00)) // 2 stop bits(for 6,7,8-bit data)
                                                            // 1 stop bit 
                                                            tx_state <=  start ;
                                                        else
                                                            if ((stopbits == 2'b01)) 
                                                                // 1.5 stop bits(for 5-bit data only)
                                                                tx_state <=  stop_halfbit ;
                                                            else
                                                                tx_state <=  stop_2bit ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b1 ;
                                    end
                                stop_2bit : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  start ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b1 ;
                                    end
                                stop_halfbit : 
                                    begin
                                        if (counter_eq_0) 
                                            counter <=  divisor_2 ;
                                        else
                                            begin
                                                if (counter_eq_1) 
                                                    begin
                                                        counter <=  0 ;
                                                        tx_state <=  start ;
                                                    end
                                                else
                                                    counter <=  counter_minus_1 ;
                                            end
                                        tx_output <=  1'b1 ;
                                    end
                                default : 
                                    tx_state <=  start ;
                                endcase 
                            end
                    end
            end
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    // Generate tsr_empty and thr_empty signals
    ////////////////////////////////////////////////////////////////////////////////
    // tsr_empty : will be set whenever tsr is empty
    generate
        begin : genblk3
            if ((FIFO == 1)) 
                begin : genblk1
                    always
                        @(posedge clk or 
                            posedge reset)
                        begin
                            if (reset) 
                                tsr_empty <=  1'b1 ;
                            else
                                if ((((tx_in_stop_s == 1'b0) && (tx_in_stop_s1 == 1'b1)) && last_word)) 
                                    tsr_empty <=  1'b1 ;
                                else
                                    // Set TsrEmpty flag to '1' when StopBit(s) is all transmitted 
                                    if (((tx_in_shift_s == 1'b1) && (tx_in_shift_s1 == 1'b0))) //Reset TsrEmpty flag to '0' when data is transferred from THR to TSR
                                        tsr_empty <=  1'b0 ;
                        end
                end
            else
                begin : genblk1
                    always
                        @(posedge clk or 
                            posedge reset)
                        begin
                            if (reset) 
                                tsr_empty <=  1'b1 ;
                            else
                                if (((tx_in_stop_s == 1'b0) && (tx_in_stop_s1 == 1'b1))) 
                                    tsr_empty <=  1'b1 ;
                                else
                                    // Set TsrEmpty flag to '1' when StopBit(s) is all transmitted 
                                    if (((tx_in_shift_s == 1'b1) && (tx_in_shift_s1 == 1'b0))) //Reset TsrEmpty flag to '0' when data is transferred from THR to TSR
                                        tsr_empty <=  1'b0 ;
                        end
                end
        end
    endgenerate
    generate
        if ((FIFO == 1)) 
            begin : genblk4
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            thr_empty <=  1'b1 ;
                        else
                            if (thr_wr) 
                                thr_empty <=  1'b0 ;
                            else
                                // Reset ThrEmpty flag to '0' when data is written into THR by CPU   
                                if (((fifo_empty_thr && tx_in_shift_s) && (!tx_in_shift_s1))) 
                                    // Set ThrEmpty flag to '1' THR FIFO is empty              
                                    thr_empty <=  1'b1 ;
                    end
            end
        else
            begin : genblk4
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            thr_empty <=  1'b1 ;
                        else
                            if (thr_wr) 
                                thr_empty <=  1'b0 ;
                            else
                                // Reset ThrEmpty flag to '0' when data is written into THR by CPU         
                                if ((tx_in_shift_s && (!tx_in_shift_s1))) 
                                    // Set ThrEmpty flag to '1' when data is transferred from THR to TSR         
                                    thr_empty <=  1'b1 ;
                    end
            end
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    // Generate thr_ready signals
    ////////////////////////////////////////////////////////////////////////////////
    generate
        if ((FIFO == 1)) 
            begin : fifo_thrrdy
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) // Reset thr_ready flag to '1' when THR FIFO is not full     
                            thr_ready <=  1'b1 ;
                        else
                            thr_ready <=  (~fifo_full_thr) ;
                    end
            end
        else
            begin : nfifo_thrrdy
                always
                    @(posedge clk or 
                        posedge reset)
                    begin
                        if (reset) 
                            thr_ready <=  1'b1 ;
                        else
                            if (thr_wr) 
                                thr_ready <=  1'b0 ;
                            else
                                // Reset thr_ready flag to '0' when data is written into THR by CPU          
                                if ((tx_in_shift_s && (!tx_in_shift_s1))) 
                                    // Set thr_ready flag to '1' when data is transferred from THR to TSR        
                                    thr_ready <=  1'b1 ;
                    end
            end
    endgenerate
    ////////////////////////////////////////////////////////////////////////////////
    // Delayed signals for edge detections
    ////////////////////////////////////////////////////////////////////////////////
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                begin
                    tx_in_shift_s1 <=  1'b0 ;
                    tx_in_stop_s1 <=  1'b0 ;
                end
            else
                begin
                    tx_in_shift_s1 <=  tx_in_shift_s ;
                    tx_in_stop_s1 <=  tx_in_stop_s ;
                end
        end
    ////////////////////////////////////////////////////////////////////////////////
    // Transmitter FSM state indication signals
    ////////////////////////////////////////////////////////////////////////////////
    // tx_in_shift_s : will be set whenever transmitter is in shift state
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                tx_in_shift_s <=  1'b0 ;
            else
                if ((tx_state == shift)) 
                    tx_in_shift_s <=  1'b1 ;
                else
                    tx_in_shift_s <=  1'b0 ;
        end
    // tx_in_stop_s : will be set whenever transmitter is in stop_1bit state
    always
        @(posedge clk or 
            posedge reset)
        begin
            if (reset) 
                tx_in_stop_s <=  1'b0 ;
            else
                if ((tx_state == stop_1bit)) 
                    tx_in_stop_s <=  1'b1 ;
                else
                    tx_in_stop_s <=  1'b0 ;
        end
    ////////////////////////////////////////////////////////////////////////////////
    // Generate thrr/temt flags
    ////////////////////////////////////////////////////////////////////////////////
    // Transmitter Holding Register Ready Indicator
    //assign thrr = thr_ready;
    assign thrr = thr_empty ; // UART 16550 definition of THRE
    // Transmitter Empty Indicator is set to '1' whenever thr and tsr are
    // both empty, and reset to '0' when either thr or tsr contain a character
    assign temt = (((thr_empty == 1'b1) && (tsr_empty == 1'b1)) ? 1'b1 : 1'b0) ; 
    // Serial Data Output
    // If Break Control bit is set to 1, the serial output is forced to Zero
    assign sout = ((tx_break == 1'b1) ? 1'b0 : tx_output) ; 
endmodule



// TXMITT_FILE
module s1_apb_uart_ipgen_lscc_uart #(parameter APB_ENABLE = 1, 
        parameter SYS_CLOCK_FREQ = 25, 
        parameter BAUD_RATE = 115200, 
        parameter CLK_DIVISOR = (SYS_CLOCK_FREQ / BAUD_RATE), 
        parameter UART_WB_ADR_WIDTH = 4, 
        parameter UART_WB_DAT_WIDTH = 8, 
        parameter FIFO = 0, 
        parameter LCR_DATA_BITS = 8, 
        parameter LCR_STOP_BITS = 1, 
        parameter LCR_PARITY_ENABLE = 0, 
        parameter LCR_PARITY_ODD = 0, 
        parameter LCR_PARITY_STICK = 0, 
        parameter LCR_SET_BREAK = 0, 
        parameter STDOUT_SIM = 0, 
        parameter STDOUT_SIMFAST = 0, 
        parameter MODEM_ENA = 0) (
    // Set this instead when SYS_CLOCK_FREQ is floating point
    // Not supported for this release
    //    parameter RXRDY_ENA         = 0,
    //    parameter TXRDY_ENA         = 0
    // -----------------------------------------
    // APB Interface
    // -----------------------------------------
    input pclk, 
    input presetn, 
    input apb_psel_i, 
    input [5:0] apb_paddr_i, 
    input [31:0] apb_pwdata_i, 
    input apb_pwrite_i, 
    input apb_penable_i, 
    output apb_pready_o, 
    output [31:0] apb_prdata_o, 
    output apb_pslverr_o, 
    output INTR, 
    // Receiver interface
    input SIN, 
    //`ifdef RXRDY_ENABLE
    output RXRDY_N, 
    //`endif
    // Modem interface
    //`ifdef MODEM
    input DCD_N, 
    input CTS_N, 
    input DSR_N, 
    input RI_N, 
    output DTR_N, 
    output RTS_N, 
    //`endif
    // Transmitter interface
    //`ifdef TXRDY_ENABLE
    output TXRDY_N, 
    //`endif
    output SOUT) ;
    wire CLK = pclk ; 
    wire RESET = (~presetn) ; 
    wire thr_ready ; 
    wire [7:0] prdata_uart ; 
    assign apb_pslverr_o = 1'b0 ; 
    assign apb_prdata_o = {24'h0,
                prdata_uart} ; 
    //`ifndef RXRDY_ENABLE 
    //   wire            RXRDY_N;
    //`endif
    //`ifndef TXRDY_ENABLE
    //   wire            TXRDY_N;
    //`endif
    wire [(UART_WB_DAT_WIDTH - 1):0] RBR_FIFO ; 
    wire [(UART_WB_DAT_WIDTH - 1):0] RBR ; 
    wire [(UART_WB_DAT_WIDTH - 1):0] THR ; 
    wire [1:0] databits ; 
    wire [1:0] stopbits ; 
    wire parity_en ; 
    wire parity_stick ; 
    wire tx_break ; 
    wire thr_wr ; 
    wire rbr_rd ; 
    wire lsr_rd ; 
    wire rx_rdy ; 
    wire parity_err ; 
    wire frame_err ; 
    wire overrun_err ; 
    wire break_int ; 
    wire THRR ; 
    wire TEMT ; 
    wire fifo_empty ; 
    wire fifo_empty_thr ; 
    wire fifo_full_thr ; 
    wire thr_rd ; 
    wire fifo_almost_full ; 
    wire [15:0] divisor ; 
    //   assign               UART_RTY_O = 1'b0;
    //   assign               UART_ERR_O = 1'b0;
    s1_apb_uart_ipgen_lscc_uart_intface #(.CLK_IN_MHZ(SYS_CLOCK_FREQ),
            .BAUD_RATE(BAUD_RATE),
            .CLK_DIVISOR(CLK_DIVISOR),
            .UART_WB_ADR_WIDTH(UART_WB_ADR_WIDTH),
            .UART_WB_DAT_WIDTH(UART_WB_DAT_WIDTH),
            .FIFO(FIFO),
            .LCR_DATA_BITS(LCR_DATA_BITS),
            .LCR_STOP_BITS(LCR_STOP_BITS),
            .LCR_PARITY_ENABLE(LCR_PARITY_ENABLE),
            .LCR_PARITY_ODD(LCR_PARITY_ODD),
            .LCR_PARITY_STICK(LCR_PARITY_STICK),
            .LCR_SET_BREAK(LCR_SET_BREAK),
            .STDOUT_SIM(STDOUT_SIM),
            .STDOUT_SIMFAST(STDOUT_SIMFAST)) u_intface (.reset(RESET), 
                .clk(CLK), 
                //              .adr_i            (UART_ADR_I  ),
            //              .dat_i            (UART_DAT_I  ),
            //              .dat_o            (UART_DAT_O  ),
            //              .stb_i            (UART_STB_I  ),
            //              .cyc_i            (UART_CYC_I  ),
            //              .we_i             (UART_WE_I   ),
            //              .cti_i            (UART_CTI_I  ),
            //              .bte_i            (UART_BTE_I  ),
            //              .ack_o            (UART_ACK_O  ),
            //    .pclk     (pclk       ),
            //    .presetn  (presetn    ),
            .psel(apb_psel_i), 
                .penable(apb_penable_i), 
                .pwrite(apb_pwrite_i), 
                .paddr(apb_paddr_i[5:2]), 
                .pwdata(apb_pwdata_i[7:0]), 
                .pready(apb_pready_o), 
                .prdata(prdata_uart), 
                .intr(intr), 
                .rbr(RBR), 
                .rbr_fifo(RBR_FIFO), 
                .thr(THR), 
                .rbr_rd(rbr_rd), 
                .thr_wr(thr_wr), 
                .lsr_rd(lsr_rd), 
                .databits(databits), 
                .stopbits(stopbits), 
                .parity_en(parity_en), 
                .parity_even(parity_even), 
                .parity_stick(parity_stick), 
                .tx_break(tx_break), 
                .rx_rdy(rx_rdy), 
                .overrun_err(overrun_err), 
                .parity_err(parity_err), 
                .frame_err(frame_err), 
                .break_int(break_int), 
                .thrr(THRR), 
                .temt(TEMT), 
                .fifo_empty(fifo_empty), 
                .fifo_empty_thr(fifo_empty_thr), 
                .fifo_full_thr(fifo_full_thr), 
                .thr_rd(thr_rd), 
                .fifo_almost_full(fifo_almost_full), 
                .divisor(divisor)) ; 
    s1_apb_uart_ipgen_lscc_uart_rxcver #(.UART_WB_DAT_WIDTH(UART_WB_DAT_WIDTH),
            .FIFO(FIFO)) u_rxcver (.reset(RESET), 
                .clk(CLK), 
                .rbr(RBR), 
                .rbr_fifo(RBR_FIFO), 
                .rbr_rd(rbr_rd), 
                .lsr_rd(lsr_rd), 
                .sin(SIN), 
                .databits(databits), 
                .parity_en(parity_en), 
                .parity_even(parity_even), 
                .parity_stick(parity_stick), 
                .rx_rdy(rx_rdy), 
                .overrun_err(overrun_err), 
                .parity_err(parity_err), 
                .frame_err(frame_err), 
                .break_int(break_int), 
                .fifo_empty(fifo_empty), 
                .fifo_almost_full(fifo_almost_full), 
                .divisor(divisor)) ; 
    s1_apb_uart_ipgen_lscc_uart_txmitt #(.UART_WB_DAT_WIDTH(UART_WB_DAT_WIDTH),
            .FIFO(FIFO)) u_txmitt (.reset(RESET), 
                .clk(CLK), 
                .thr(THR), 
                .thr_wr(thr_wr), 
                .sout(sout), 
                .databits(databits), 
                .stopbits(stopbits), 
                .parity_en(parity_en), 
                .parity_even(parity_even), 
                .parity_stick(parity_stick), 
                .tx_break(tx_break), 
                .thrr(THRR), 
                .temt(TEMT), 
                .fifo_empty_thr(fifo_empty_thr), 
                .fifo_full_thr(fifo_full_thr), 
                .thr_rd(thr_rd), 
                .thr_ready(thr_ready), 
                .divisor(divisor)) ; 
    // TXRDY_N, RXRDY_N is low active output
    assign #(5) TXRDY_N = (~thr_ready) ; 
    assign #(5) RXRDY_N = (~rx_rdy) ; 
    assign #(5) INTR = intr ; 
    assign #(5) SOUT = sout ; 
    generate
        if ((!MODEM_ENA)) 
            begin : modem_dis
                assign DTR_N = 1'b0 ; 
                assign RTS_N = 1'b0 ; 
            end
    endgenerate
endmodule


