`timescale 100 ps/100 ps
module CCU2 (
  A0,
  B0,
  C0,
  D0,
  A1,
  B1,
  C1,
  D1,
  CIN,
  COUT,
  S0,
  S1
)
;
input A0 ;
input B0 ;
input C0 ;
input D0 ;
input A1 ;
input B1 ;
input C1 ;
input D1 ;
input CIN ;
output COUT ;
output S0 ;
output S1 ;
parameter INIT0="0x0000";
parameter INIT1="0x0000";
parameter INJECT="NO";
endmodule /* CCU2 */

module DCC (
  CE,
  CLKI,
  CLKO
)
;
input CE ;
input CLKI ;
output CLKO ;
endmodule /* DCC */

(* black_box_pad_pin="TDI,TCK,TMS,TDO" *)module JTAGH19 (
  TDI,
  TCK,
  TMS,
  TDO,
  JTCK,
  JTDI,
  JSHIFT,
  JUPDATE,
  JRSTN,
  JCE2,
  CDN,
  IP_ENABLE,
  ER2_TDO
)
;
input TDI ;
input TCK ;
input TMS ;
output TDO ;
output JTCK ;
output JTDI ;
output JSHIFT ;
output JUPDATE ;
output JRSTN ;
output JCE2 ;
output CDN ;
output [18:0] IP_ENABLE ;
input [18:0] ER2_TDO ;
endmodule /* JTAGH19 */

module PDP16K (
  DI,
  ADW,
  ADR,
  CLKW,
  CLKR,
  CEW,
  CSW,
  CSR,
  CER,
  RST,
  DO,
  ONEBITERR,
  TWOBITERR
)
;
input [35:0] DI ;
input [13:0] ADW ;
input [13:0] ADR ;
input CLKW ;
input CLKR ;
input CEW ;
input [2:0] CSW ;
input [2:0] CSR ;
input CER ;
input RST ;
output [35:0] DO ;
output ONEBITERR ;
output TWOBITERR ;
parameter DATA_WIDTH_W="X36";
parameter DATA_WIDTH_R="X36";
parameter OUTREG="BYPASSED";
parameter ECC="DISABLED";
parameter RESETMODE="SYNC";
parameter ASYNC_RST_RELEASE="ASYNC";
parameter CSDECODE_W="000";
parameter CSDECODE_R="000";
parameter GSR="ENABLED";
parameter INITVAL_00="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_01="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_02="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_03="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_04="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_05="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_06="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_07="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_08="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_09="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_0F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_10="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_11="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_12="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_13="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_14="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_15="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_16="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_17="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_18="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_19="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_1F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_20="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_21="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_22="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_23="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_24="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_25="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_26="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_27="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_28="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_29="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_2F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_30="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_31="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_32="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_33="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_34="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_35="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_36="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_37="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_38="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_39="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3A="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3B="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3C="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3D="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3E="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
parameter INITVAL_3F="0x00000000000000000000000000000000000000000000000000000000000000000000000000000000";
endmodule /* PDP16K */

module DDRDLL (
  CODE,
  FREEZE,
  LOCK,
  CLKIN,
  RST,
  DCNTL,
  UDDCNTL_N
)
;
output [8:0] CODE ;
input FREEZE ;
output LOCK ;
input CLKIN ;
input RST ;
output [8:0] DCNTL ;
input UDDCNTL_N ;
endmodule /* DDRDLL */

module ECLKSYNC (
  ECLKIN,
  ECLKOUT,
  STOP
)
;
input ECLKIN ;
output ECLKOUT ;
input STOP ;
endmodule /* ECLKSYNC */

module ECLKDIV (
  DIVOUT,
  DIVRST,
  ECLKIN,
  SLIP
)
;
output DIVOUT ;
input DIVRST ;
input ECLKIN ;
input SLIP ;
endmodule /* ECLKDIV */

module OUTDELAYA (
  DOUTI,
  TOUTI,
  TOUT,
  DOUT,
  LOAD_N_LPDDR4_WT,
  DIRECTION_LPDDR4_WT,
  MOVE_LPDDR4_WT,
  COUT_LPDDR4_WT
)
;
input DOUTI ;
input TOUTI ;
output TOUT ;
output DOUT ;
input LOAD_N_LPDDR4_WT ;
input DIRECTION_LPDDR4_WT ;
input MOVE_LPDDR4_WT ;
output COUT_LPDDR4_WT ;
endmodule /* OUTDELAYA */

module ODDRX4DQ (
  D0,
  D1,
  D2,
  D3,
  D4,
  D5,
  D6,
  D7,
  DQSW270,
  ECLK,
  SCLK,
  RST,
  Q
)
;
input D0 ;
input D1 ;
input D2 ;
input D3 ;
input D4 ;
input D5 ;
input D6 ;
input D7 ;
input DQSW270 ;
input ECLK ;
input SCLK ;
input RST ;
output Q ;
endmodule /* ODDRX4DQ */

module DELAYA (
  A,
  LOAD_N,
  MOVE,
  DIRECTION,
  COARSE0,
  COARSE1,
  Z,
  EDETERR,
  CFLAG,
  RANKSELECT,
  RANKENABLE,
  RANK0UPDATE,
  RANK1UPDATE
)
;
input A ;
input LOAD_N ;
input MOVE ;
input DIRECTION ;
input COARSE0 ;
input COARSE1 ;
output Z ;
output EDETERR ;
output CFLAG ;
input RANKSELECT ;
input RANKENABLE ;
input RANK0UPDATE ;
input RANK1UPDATE ;
endmodule /* DELAYA */

module IDDRX4DQ (
  D,
  DQSR90,
  ECLK,
  SCLK,
  RST,
  RDPNTR0,
  RDPNTR1,
  RDPNTR2,
  WRPNTR0,
  WRPNTR1,
  WRPNTR2,
  Q0,
  Q1,
  Q2,
  Q3,
  Q4,
  Q5,
  Q6,
  Q7
)
;
input D ;
input DQSR90 ;
input ECLK ;
input SCLK ;
input RST ;
input RDPNTR0 ;
input RDPNTR1 ;
input RDPNTR2 ;
input WRPNTR0 ;
input WRPNTR1 ;
input WRPNTR2 ;
output Q0 ;
output Q1 ;
output Q2 ;
output Q3 ;
output Q4 ;
output Q5 ;
output Q6 ;
output Q7 ;
endmodule /* IDDRX4DQ */

module TSHX4DQS (
  T0,
  T1,
  T2,
  T3,
  DQSW,
  ECLK,
  SCLK,
  RST,
  Q
)
;
input T0 ;
input T1 ;
input T2 ;
input T3 ;
input DQSW ;
input ECLK ;
input SCLK ;
input RST ;
output Q ;
endmodule /* TSHX4DQS */

module TSHX4DQ (
  T0,
  T1,
  T2,
  T3,
  DQSW270,
  ECLK,
  SCLK,
  RST,
  Q
)
;
input T0 ;
input T1 ;
input T2 ;
input T3 ;
input DQSW270 ;
input ECLK ;
input SCLK ;
input RST ;
output Q ;
endmodule /* TSHX4DQ */

module ODDRX4DQS (
  D0,
  D1,
  D2,
  D3,
  D4,
  D5,
  D6,
  D7,
  DQSW,
  ECLK,
  SCLK,
  RST,
  Q
)
;
input D0 ;
input D1 ;
input D2 ;
input D3 ;
input D4 ;
input D5 ;
input D6 ;
input D7 ;
input DQSW ;
input ECLK ;
input SCLK ;
input RST ;
output Q ;
endmodule /* ODDRX4DQS */

module DQSBUF_IVREF (
  BTDETECT,
  BURSTDETECT,
  DATAVALID,
  DQSI,
  DQSW,
  DQSWRD,
  PAUSE,
  RDCLKSEL,
  RDDIR,
  RDLOADN,
  RDPNTR,
  READ,
  READCOUT,
  READMOVE,
  RST,
  SCLK,
  SELCLK,
  DQSR90,
  DQSW270,
  WRCOUT,
  WRDIR,
  WRLOAD_N,
  WRLVCOUT,
  WRLVDIR,
  WRLVLOAD_N,
  WRLVMOVE,
  WRMOVE,
  WRPNTR,
  ECLKIN,
  RSTSMCNT,
  DLLCODE,
  IVREFI
)
;
output BTDETECT ;
output BURSTDETECT ;
output DATAVALID ;
input DQSI ;
output DQSW ;
output DQSWRD ;
input PAUSE ;
input [3:0] RDCLKSEL ;
input RDDIR ;
input RDLOADN ;
output [2:0] RDPNTR ;
input [3:0] READ ;
output READCOUT ;
input READMOVE ;
input RST ;
input SCLK ;
input SELCLK ;
output DQSR90 ;
output DQSW270 ;
output WRCOUT ;
input WRDIR ;
input WRLOAD_N ;
output WRLVCOUT ;
input WRLVDIR ;
input WRLVLOAD_N ;
input WRLVMOVE ;
input WRMOVE ;
output [2:0] WRPNTR ;
input ECLKIN ;
input RSTSMCNT ;
input [8:0] DLLCODE ;
input [6:0] IVREFI ;
endmodule /* DQSBUF_IVREF */

module ODDRX4 (
  D0,
  D1,
  D2,
  D3,
  D4,
  D5,
  D6,
  D7,
  SCLK,
  RST,
  ECLK,
  Q
)
;
input D0 ;
input D1 ;
input D2 ;
input D3 ;
input D4 ;
input D5 ;
input D6 ;
input D7 ;
input SCLK ;
input RST ;
input ECLK ;
output Q ;
endmodule /* ODDRX4 */

module PLL (
  INTFBKOP,
  INTFBKOS,
  INTFBKOS2,
  INTFBKOS3,
  INTFBKOS4,
  INTFBKOS5,
  DIR,
  DIRSEL,
  LOADREG,
  DYNROTATE,
  LMMICLK,
  LMMIRESET_N,
  LMMIREQUEST,
  LMMIWRRD_N,
  LMMIOFFSET,
  LMMIWDATA,
  LMMIRDATA,
  LMMIRDATAVALID,
  LMMIREADY,
  PLLPOWERDOWN_N,
  REFCK,
  CLKOP,
  CLKOS,
  CLKOS2,
  CLKOS3,
  CLKOS4,
  CLKOS5,
  ENCLKOP,
  ENCLKOS,
  ENCLKOS2,
  ENCLKOS3,
  ENCLKOS4,
  ENCLKOS5,
  FBKCK,
  INTLOCK,
  LEGACY,
  LEGRDYN,
  LOCK,
  PFDDN,
  PFDUP,
  PLLRESET,
  STDBY,
  REFMUXCK,
  REGQA,
  REGQB,
  REGQB1,
  CLKOUTDL,
  ROTDEL,
  DIRDEL,
  ROTDELP1,
  GRAYTEST,
  BINTEST,
  DIRDELP1,
  GRAYACT,
  BINACT
)
;
output INTFBKOP ;
output INTFBKOS ;
output INTFBKOS2 ;
output INTFBKOS3 ;
output INTFBKOS4 ;
output INTFBKOS5 ;
input DIR ;
input [2:0] DIRSEL ;
input LOADREG ;
input DYNROTATE ;
input LMMICLK ;
input LMMIRESET_N ;
input LMMIREQUEST ;
input LMMIWRRD_N ;
input [6:0] LMMIOFFSET ;
input [7:0] LMMIWDATA ;
output [7:0] LMMIRDATA ;
output LMMIRDATAVALID ;
output LMMIREADY ;
input PLLPOWERDOWN_N ;
input REFCK ;
output CLKOP ;
output CLKOS ;
output CLKOS2 ;
output CLKOS3 ;
output CLKOS4 ;
output CLKOS5 ;
input ENCLKOP ;
input ENCLKOS ;
input ENCLKOS2 ;
input ENCLKOS3 ;
input ENCLKOS4 ;
input ENCLKOS5 ;
input FBKCK ;
output INTLOCK ;
input LEGACY ;
output LEGRDYN ;
output LOCK ;
output PFDDN ;
output PFDUP ;
input PLLRESET ;
input STDBY ;
output REFMUXCK ;
output REGQA ;
output REGQB ;
output REGQB1 ;
output CLKOUTDL ;
input ROTDEL ;
input DIRDEL ;
input ROTDELP1 ;
input [4:0] GRAYTEST ;
input [1:0] BINTEST ;
input DIRDELP1 ;
input [4:0] GRAYACT ;
input [1:0] BINACT ;
endmodule /* PLL */

module OSCA (
  HFOUTEN,
  HFSDSCEN,
  HFCLKOUT,
  LFCLKOUT,
  HFCLKCFG,
  HFSDCOUT
)
;
input HFOUTEN ;
input HFSDSCEN ;
output HFCLKOUT ;
output LFCLKOUT ;
output HFCLKCFG ;
output HFSDCOUT ;
endmodule /* OSCA */

module LRAM (
  ADA,
  ADB,
  BENA_N,
  BENB_N,
  CEA,
  CEB,
  CLK,
  CSA,
  CSB,
  DIA,
  DIB,
  DOA,
  DOB,
  DPS,
  ERRDECA,
  ERRDECB,
  OCEA,
  OCEB,
  OEA,
  OEB,
  RSTA,
  RSTB,
  WEA,
  WEB,
  ERRDET,
  LRAMREADY
)
;
input [13:0] ADA ;
input [13:0] ADB ;
input [3:0] BENA_N ;
input [3:0] BENB_N ;
input CEA ;
input CEB ;
input CLK ;
input CSA ;
input CSB ;
input [31:0] DIA ;
input [31:0] DIB ;
output [31:0] DOA ;
output [31:0] DOB ;
input DPS ;
output [1:0] ERRDECA ;
output [1:0] ERRDECB ;
input OCEA ;
input OCEB ;
output OEA ;
output OEB ;
input RSTA ;
input RSTB ;
input WEA ;
input WEB ;
output ERRDET ;
output LRAMREADY ;
endmodule /* LRAM */

