#-- Lattice Semiconductor Corporation Ltd.
#-- Synplify OEM project file

#device options
set_option -technology LFCPNX
set_option -part LFCPNX_100
set_option -package BBG484C
set_option -speed_grade -8
#compilation/mapping options
set_option -symbolic_fsm_compiler true
set_option -resource_sharing true

#use verilog standard option
set_option -vlog_std v2001

#map options
set_option -frequency 200
set_option -maxfan 1000
set_option -auto_constrain_io 0
set_option -retiming false; set_option -pipe true
set_option -force_gsr false
set_option -compiler_compatible 0


set_option -default_enum_encoding default

#timing analysis options



#automatic place and route (vendor) options
set_option -write_apr_constraint 1

#synplifyPro options
set_option -fix_gated_and_generated_clocks 0
set_option -update_models_cp 0
set_option -resolve_multiple_driver 0


set_option -rw_check_on_ram 0
set_option -seqshift_no_replicate 0
set_option -automatic_compile_point 0

#-- set any command lines input by customer

set_option -dup false
set_option -disable_io_insertion false
add_file -constraint {C:/lscc/radiant/2024.1/scripts/tcl/flow/radiant_synplify_vars.tcl}
add_file -constraint {cpnx_riscv_rx_rd_impl_1_cpe.ldc}
add_file -verilog {C:/lscc/radiant/2024.1/ip/pmi/pmi_lfcpnx.v}
add_file -vhdl -lib pmi {C:/lscc/radiant/2024.1/ip/pmi/pmi_lfcpnx.vhd}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/system0/2.2.0/rtl/system0.v}
add_file -verilog -vlog_std sysv {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/new_lpddr4/2.1.0/rtl/new_lpddr4.sv}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/spi_flash1/1.9.0/rtl/spi_flash1.v}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd.v}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi2ahbl_spi_flash/1.1.0/rtl/axi2ahbl_spi_flash.v}
add_file -verilog -vlog_std sysv {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi_interconnect_0/1.2.2/rtl/axi_interconnect_0.sv}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/osc0/1.4.0/rtl/osc0.v}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/gpio0/1.6.1/rtl/gpio0.v}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi2apb0/1.1.1/rtl/axi2apb0.v}
add_file -verilog -vlog_std sysv {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/cpu/2.4.0/rtl/cpu.sv}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/apb_interconnect0/1.2.1/rtl/apb_interconnect0.v}
add_file -verilog -vlog_std v2001 {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/pll0/1.9.0/rtl/pll0.v}
#-- top module name
set_option -top_module cpnx_riscv_rx_rd
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi2ahbl_spi_flash/1.1.0}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi2apb0/1.1.1}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi_interconnect_0/1.2.2}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/cpu/2.4.0}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/gpio0/1.6.1}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/new_lpddr4/2.1.0}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/spi_flash1/1.9.0}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/system0/2.2.0}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/apb_interconnect0/1.2.1}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/osc0/1.4.0}
set_option -include_path {C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/pll0/1.9.0}

#-- set result format/file last
project -result_format "vm"
project -result_file {C:/LAB3/WS/cpnx_riscv_rx_rd/impl_1/cpnx_riscv_rx_rd_impl_1.vm}

#-- error message log file
project -log_file {cpnx_riscv_rx_rd_impl_1.srf}
project -run -clean
