set current_path "C:/LAB3/WS/cpnx_riscv_rx_rd"

cd $current_path

set radiant_project "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd.rdf"

set DEVICE "LFCPNX-100-9LFG672C"

set DESIGN "cpnx_riscv_rx_rd"

array set VFILE_LIST ""
set VFILE_LIST(1) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/system0/2.2.0/system0.ipx"
set VFILE_LIST(2) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/new_lpddr4/2.1.0/new_lpddr4.ipx"
set VFILE_LIST(3) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/spi_flash1/1.9.0/spi_flash1.ipx"
set VFILE_LIST(4) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd.v"
set VFILE_LIST(5) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi2ahbl_spi_flash/1.1.0/axi2ahbl_spi_flash.ipx"
set VFILE_LIST(6) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi_interconnect_0/1.2.2/axi_interconnect_0.ipx"
set VFILE_LIST(7) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/osc0/1.4.0/osc0.ipx"
set VFILE_LIST(8) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/gpio0/1.6.1/gpio0.ipx"
set VFILE_LIST(9) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/axi2apb0/1.1.1/axi2apb0.ipx"
set VFILE_LIST(10) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/ip/cpu/2.4.0/cpu.ipx"
set VFILE_LIST(11) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/apb_interconnect0/1.2.1/apb_interconnect0.ipx"
set VFILE_LIST(12) "C:/LAB3/WS/cpnx_riscv_rx_rd/cpnx_riscv_rx_rd/lib/latticesemi.com/module/pll0/1.9.0/pll0.ipx"

set index [array names VFILE_LIST]
if { [file exists $radiant_project] == 1} {
    prj_open $radiant_project
    prj_set_device -part $DEVICE -performance 9_High-Performance_1.0V
} else {
    prj_create -name "cpnx_riscv_rx_rd" -impl "impl_1" -dev $DEVICE -performance 9_High-Performance_1.0V -synthesis "synplify"
    prj_save
}


foreach i $index {
    if { [catch {prj_add_source $VFILE_LIST($i)} fid] } {
        puts "file already exists in project."
    }
}

prj_set_impl_opt top {cpnx_riscv_rx_rd}
prj_set_impl_opt -impl "impl_1" "include path" "."
prj_set_impl_opt -impl "impl_1" "top" "cpnx_riscv_rx_rd"
prj_set_strategy_value -strategy Strategy1 par_place_iterator=10
prj_set_strategy_value -strategy Strategy1 par_stop_zero=True
prj_set_strategy_value -strategy Strategy1 {par_cmdline_args=-exp nbrForceHoldTimeCorrection=1 }
prj_save

